import abc
from . import base as base
from typing import Any, Hashable

class AbstractMetaListStorage(base.AbstractStorage, metaclass=abc.ABCMeta):
    def raw_key(self, key): ...
    @property
    def storages(self): ...

class Fallback(AbstractMetaListStorage):
    async def get(self, key): ...
    async def set(self, key, value) -> None: ...

class Replicator(AbstractMetaListStorage):
    async def init(self) -> None: ...
    async def get(self, key): ...
    async def set(self, key, value) -> None: ...

class Cache(base.AbstractStorage):
    def raw_key(self, key): ...
    @property
    def storage(self): ...
    @property
    def source(self): ...
    async def get(self, key): ...
    def set(self, key, value): ...

class FutureStorage(base.AbstractStorage):
    def __init__(self, *args, **kwargs) -> None: ...
    def set_config(self, config) -> None: ...
    def raw_key(self, key: Any) -> Hashable: ...
    async def set(self, key: Hashable, value: Any) -> None: ...
    def get(self, key): ...
