import abc
from ..core.base import AbstractNamedEntity as AbstractNamedEntity, LoggingEntity as LoggingEntity, link as link
from ..queue.base import AbstractQueue as AbstractQueue
from ..utils import import_name as import_name
from abc import abstractmethod
from typing import Any, Dict, Optional

class AbstractWorker(LoggingEntity, AbstractNamedEntity, metaclass=abc.ABCMeta):
    @abstractmethod
    async def start(self): ...
    @abstractmethod
    async def stop(self): ...
    @abstractmethod
    async def status(self): ...

class Worker(AbstractWorker):
    counter: Dict
    input: Optional[AbstractQueue]
    output: Optional[AbstractQueue]
    def __init__(self, *args, **kwargs) -> None: ...
    def set_config(self, config) -> None: ...
    async def init(self) -> None: ...
    async def work(self) -> None: ...
    async def runner(self) -> None: ...
    async def run(self, value: Any = ...) -> Any: ...
    def __call__(self, *args, **kwargs): ...
    @property
    def started_at(self): ...
    @property
    def stopped_at(self): ...
    def running(self): ...
    async def start(self) -> None: ...
    async def stop(self, force: bool = ...) -> None: ...
    async def status(self): ...
