import type { Construct } from "constructs";
import { Project, type ProjectProps } from "github-actions-cdk";
/**
 * Adapter to integrate CDKTF (Cloud Development Kit for Terraform) projects with GitHub Actions.
 * This class extends the base `Project` class and allows for GitHub Actions workflow generation with annotation handling and validation.
 */
export declare class CdktfAdapter extends Project {
    private readonly awsCdkScope;
    private hasValidationErrors;
    /**
     * Initializes a new instance of the CdktfAdapter.
     *
     * @param awsCdkScope - The scope of the AWS CDK project.
     * @param props - Optional properties for project configuration.
     */
    constructor(awsCdkScope: Construct, props?: ProjectProps);
    /**
     * Handles errors occurring during the synthesis process, particularly validation errors.
     * Adds validation error messages as annotations to the CDK scope node.
     *
     * @param error - The error encountered during synthesis.
     */
    protected handleSynthesisError(error: unknown): void;
    /**
     * Finalizes the synthesis process by adding annotations based on workflow metadata.
     * Adds informational, warning, and error messages to the AWS CDK scope and handles whether synthesis should continue on error annotations.
     */
    protected finalizeSynthesis(): void;
}
