"""add entity status field

Revision ID: 2baede80b111
Revises: 956659992419
Create Date: 2023-01-24 19:09:55.648115

"""
from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils

# revision identifiers, used by Alembic.

revision = "2baede80b111"
down_revision = "956659992419"
branch_labels = None
depends_on = None

ENTITY_STATUSES = [
    ("standby", "Stand By"),
    ("running", "Running"),
    ("complete", "Complete"),
    ("canceled", "Canceled"),
]


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "entity",
        sa.Column(
            "status",
            sqlalchemy_utils.types.choice.ChoiceType(ENTITY_STATUSES),
            nullable=True,
            default="running",
        ),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("entity", "status")
    # ### end Alembic commands ###
