"""add task type field to playlists

Revision ID: 6c597e842afa
Revises: 6d7fa5a8e9a5
Create Date: 2021-05-10 00:12:27.927441

"""
from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "6c597e842afa"
down_revision = "6d7fa5a8e9a5"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "playlist",
        sa.Column(
            "task_type_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=True,
        ),
    )
    op.create_index(
        op.f("ix_playlist_task_type_id"),
        "playlist",
        ["task_type_id"],
        unique=False,
    )
    op.create_foreign_key(
        None, "playlist", "task_type", ["task_type_id"], ["id"]
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "playlist", type_="foreignkey")
    op.drop_index(op.f("ix_playlist_task_type_id"), table_name="playlist")
    op.drop_column("playlist", "task_type_id")
    # ### end Alembic commands ###
