"""Add ready for column to entities

Revision ID: 87efceb6745b
Revises: 398150912a3f
Create Date: 2021-11-09 00:13:49.912704

"""
from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "87efceb6745b"
down_revision = "398150912a3f"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "entity",
        sa.Column(
            "ready_for",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=True,
        ),
    )
    op.create_foreign_key(
        "fk_ready_for", "entity", "task_type", ["ready_for"], ["id"]
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint("fk_ready_for", "entity", type_="foreignkey")
    op.drop_column("entity", "ready_for")
    # ### end Alembic commands ###
