DOMAIN_REGEX = r"(?:(?=[a-z0-9-]{1,63}\.)(?:xn--)?[a-z0-9-]+(?:-[a-z0-9]+)*\.)+[a-z]{2,63}"
DOMAIN_ONLY_REGEX = f"^{DOMAIN_REGEX}$"
DOMAIN_EXCLUDED_NORM_CHARS = "./?@#"
EMAIL_REGEX = f"^[a-zA-Z0-9!#$%&'*+/=?^_‘{{|}}~-]+(?:\\.[a-zA-Z0-9!#$%&'*+/=?^_‘{{|}}~-]+)*@({DOMAIN_REGEX})$"
IPV4_REGEX = r"(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)"
IPV6_REGEX = (
    r"(?:(?:[0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,7}:|"
    r"(?:[0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,5}(?::[0-9a-fA-F]{1,4}){1,2}|"
    r"(?:[0-9a-fA-F]{1,4}:){1,4}(?::[0-9a-fA-F]{1,4}){1,3}|(?:[0-9a-fA-F]{1,4}:){1,3}(?::[0-9a-fA-F]{1,4}){1,4}|"
    r"(?:[0-9a-fA-F]{1,4}:){1,2}(?::[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:(?:(?::[0-9a-fA-F]{1,4}){1,6})|"
    r":(?:(?::[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(?::[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|"
    r"::(?:ffff(?::0{1,4}){0,1}:){0,1}(?:(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(?:25[0-5]|"
    r"(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])|(?:[0-9a-fA-F]{1,4}:){1,4}:(?:(?:25[0-5]|"
    r"(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(?:25[0-5]|(?:2[0-4]|1{0,1}[0-9]){0,1}[0-9]))"
)
IP_REGEX = f"(?:{IPV4_REGEX}|{IPV6_REGEX})"
IP_ONLY_REGEX = f"^{IP_REGEX}$"
IPV4_ONLY_REGEX = f"^{IPV4_REGEX}$"
IPV6_ONLY_REGEX = f"^{IPV6_REGEX}$"
PORT_REGEX = r"^(0|[1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])$"
MD5_REGEX = r"^[a-fA-F0-9]{32}$"
SHA1_REGEX = r"^[a-fA-F0-9]{40}$"
SHA256_REGEX = r"^[a-fA-F0-9]{64}$"
URI_PATH = r"([/?#]\S*)"
URI_REGEX = (
    f"((?:(?:[A-Za-z][A-Za-z0-9+.-]*:)//)(?:[^/?#\\s]+@)?({IP_REGEX}|{DOMAIN_REGEX})(?::\\d{{1,5}})?{URI_PATH}?)"
)
URI_ONLY = f"^{URI_REGEX}$"

EMAIL_PATH_REGEX = r"^[A-Z]*_EMAIL://.*"
HBS_AGENT_ID_REGEX = r"[0-9a-fA-F]{1,4}.[0-9a-fA-F]{1,4}.[0-9a-fA-F]{1,4}.[0-9a-fA-F]{1,4}"
