"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const lambda = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-lambda-pce-1');
const lambdaCode = 'exports.handler =  async function(event, context) { ' +
    'console.log("Hello from CDK! with #type# Provisioned Concurrent Exec!");}';
const pce = 5;
// Integration test for provisioned concurrent execution via Alias
const fn = new lambda.Function(stack, 'MyLambdaAliasPCE', {
    code: new lambda.InlineCode(lambdaCode.replace('#type#', 'Alias')),
    handler: 'index.handler',
    runtime: lambda.Runtime.NODEJS_10_X,
});
fn.addToRolePolicy(new iam.PolicyStatement({
    resources: ['*'],
    actions: ['*'],
}));
const version = fn.addVersion('1');
const alias = new lambda.Alias(stack, 'Alias', {
    aliasName: 'prod',
    version,
    provisionedConcurrentExecutions: pce,
});
alias.addPermission('AliasPermission', {
    principal: new iam.ServicePrincipal('cloudformation.amazonaws.com'),
});
// Integration test for provisioned concurrent execution via Version
const fnVersionPCE = new lambda.Function(stack, 'MyLambdaVersionPCE', {
    code: new lambda.InlineCode(lambdaCode.replace('#type#', 'Version')),
    handler: 'index.handler',
    runtime: lambda.Runtime.NODEJS_10_X,
});
fnVersionPCE.addToRolePolicy(new iam.PolicyStatement({
    resources: ['*'],
    actions: ['*'],
}));
const version2 = fnVersionPCE.addVersion('2', undefined, undefined, pce);
const alias2 = new lambda.Alias(stack, 'Alias2', {
    aliasName: 'prod',
    version: version2,
});
alias2.addPermission('AliasPermission2', {
    principal: new iam.ServicePrincipal('cloudformation.amazonaws.com'),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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