from llvm2py import parse_assembly


ir_text = """; Function Attrs: noinline nounwind optnone uwtable
define dso_local i32 @factorial_req(i32 noundef %0) #0 {
  %2 = alloca i32, align 4
  %3 = alloca i32, align 4
  store i32 %0, ptr %3, align 4
  %4 = load i32, ptr %3, align 4
  %5 = icmp eq i32 %4, 1
  br i1 %5, label %6, label %7

6:                                                ; preds = %1
  store i32 1, ptr %2, align 4
  br label %13

7:                                                ; preds = %1
  %8 = load i32, ptr %3, align 4
  %9 = sub nsw i32 %8, 1
  %10 = call i32 @factorial_req(i32 noundef %9)
  %11 = load i32, ptr %3, align 4
  %12 = mul nsw i32 %10, %11
  store i32 %12, ptr %2, align 4
  br label %13

13:                                               ; preds = %7, %6
  %14 = load i32, ptr %2, align 4
  ret i32 %14
}"""

dumped_ir = """Module(funcs=[Function(value=Value(val='factorial_req', ty=PtrType(addr_space=0, ty=None)), args=[Value(val='%0', ty=IntegerType(num_bits=32))], blocks=[Block(value=Value(val='%1', ty=LabelType()), instrs=[Alloca(attrs={('align', 4)}, result=Value(val='%2', ty=PtrType(addr_space=0, ty=None)), opcode='alloca', num_elements=Value(val=1, ty=IntegerType(num_bits=32)), allocated_ty=IntegerType(num_bits=32)), Alloca(attrs={('align', 4)}, result=Value(val='%3', ty=PtrType(addr_space=0, ty=None)), opcode='alloca', num_elements=Value(val=1, ty=IntegerType(num_bits=32)), allocated_ty=IntegerType(num_bits=32)), Store(attrs={('align', 4)}, result=Value(val='<badref>', ty=VoidType()), opcode='store', value=Value(val='%0', ty=IntegerType(num_bits=32)), address=Value(val='%3', ty=PtrType(addr_space=0, ty=None))), Load(attrs={('align', 4)}, result=Value(val='%4', ty=IntegerType(num_bits=32)), opcode='load', address=Value(val='%3', ty=PtrType(addr_space=0, ty=None))), ICmp(attrs=set(), result=Value(val='%5', ty=IntegerType(num_bits=1)), opcode='icmp', cond='eq', arg0=Value(val='%4', ty=IntegerType(num_bits=32)), arg1=Value(val=1, ty=IntegerType(num_bits=32))), Br(attrs=set(), result=Value(val='<badref>', ty=VoidType()), opcode='br', cond=Value(val='%5', ty=IntegerType(num_bits=1)), label_false=Value(val='%7', ty=LabelType()), label_true=Value(val='%6', ty=LabelType()))], pred_blocks=[]), Block(value=Value(val='%6', ty=LabelType()), instrs=[Store(attrs={('align', 4)}, result=Value(val='<badref>', ty=VoidType()), opcode='store', value=Value(val=1, ty=IntegerType(num_bits=32)), address=Value(val='%2', ty=PtrType(addr_space=0, ty=None))), Br(attrs=set(), result=Value(val='<badref>', ty=VoidType()), opcode='br', cond=None, label_false=Value(val='%13', ty=LabelType()), label_true=None)], pred_blocks=['%1']), Block(value=Value(val='%7', ty=LabelType()), instrs=[Load(attrs={('align', 4)}, result=Value(val='%8', ty=IntegerType(num_bits=32)), opcode='load', address=Value(val='%3', ty=PtrType(addr_space=0, ty=None))), BinOp(attrs={('nsw',)}, result=Value(val='%9', ty=IntegerType(num_bits=32)), opcode='sub', fst_operand=Value(val='%8', ty=IntegerType(num_bits=32)), snd_operand=Value(val=1, ty=IntegerType(num_bits=32))), Call(attrs=set(), result=Value(val='%10', ty=IntegerType(num_bits=32)), opcode='call', call_attributes=[set(), set(), {('noundef',)}], func=Value(val='factorial_req', ty=PtrType(addr_space=0, ty=None)), args=[Value(val='%9', ty=IntegerType(num_bits=32))]), Load(attrs={('align', 4)}, result=Value(val='%11', ty=IntegerType(num_bits=32)), opcode='load', address=Value(val='%3', ty=PtrType(addr_space=0, ty=None))), BinOp(attrs={('nsw',)}, result=Value(val='%12', ty=IntegerType(num_bits=32)), opcode='mul', fst_operand=Value(val='%10', ty=IntegerType(num_bits=32)), snd_operand=Value(val='%11', ty=IntegerType(num_bits=32))), Store(attrs={('align', 4)}, result=Value(val='<badref>', ty=VoidType()), opcode='store', value=Value(val='%12', ty=IntegerType(num_bits=32)), address=Value(val='%2', ty=PtrType(addr_space=0, ty=None))), Br(attrs=set(), result=Value(val='<badref>', ty=VoidType()), opcode='br', cond=None, label_false=Value(val='%13', ty=LabelType()), label_true=None)], pred_blocks=['%1']), Block(value=Value(val='%13', ty=LabelType()), instrs=[Load(attrs={('align', 4)}, result=Value(val='%14', ty=IntegerType(num_bits=32)), opcode='load', address=Value(val='%2', ty=PtrType(addr_space=0, ty=None))), Ret(attrs=set(), result=Value(val='<badref>', ty=VoidType()), opcode='ret', value=Value(val='%14', ty=IntegerType(num_bits=32)))], pred_blocks=['%7', '%6'])], attrs=[set(), set(), {('noundef',)}], calling_convention=<CallingConv.C: 0>, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>))], global_vars={}, funcs_map={'factorial_req': Function(value=Value(val='factorial_req', ty=PtrType(addr_space=0, ty=None)), args=[Value(val='%0', ty=IntegerType(num_bits=32))], blocks=[Block(value=Value(val='%1', ty=LabelType()), instrs=[Alloca(attrs={('align', 4)}, result=Value(val='%2', ty=PtrType(addr_space=0, ty=None)), opcode='alloca', num_elements=Value(val=1, ty=IntegerType(num_bits=32)), allocated_ty=IntegerType(num_bits=32)), Alloca(attrs={('align', 4)}, result=Value(val='%3', ty=PtrType(addr_space=0, ty=None)), opcode='alloca', num_elements=Value(val=1, ty=IntegerType(num_bits=32)), allocated_ty=IntegerType(num_bits=32)), Store(attrs={('align', 4)}, result=Value(val='<badref>', ty=VoidType()), opcode='store', value=Value(val='%0', ty=IntegerType(num_bits=32)), address=Value(val='%3', ty=PtrType(addr_space=0, ty=None))), Load(attrs={('align', 4)}, result=Value(val='%4', ty=IntegerType(num_bits=32)), opcode='load', address=Value(val='%3', ty=PtrType(addr_space=0, ty=None))), ICmp(attrs=set(), result=Value(val='%5', ty=IntegerType(num_bits=1)), opcode='icmp', cond='eq', arg0=Value(val='%4', ty=IntegerType(num_bits=32)), arg1=Value(val=1, ty=IntegerType(num_bits=32))), Br(attrs=set(), result=Value(val='<badref>', ty=VoidType()), opcode='br', cond=Value(val='%5', ty=IntegerType(num_bits=1)), label_false=Value(val='%7', ty=LabelType()), label_true=Value(val='%6', ty=LabelType()))], pred_blocks=[]), Block(value=Value(val='%6', ty=LabelType()), instrs=[Store(attrs={('align', 4)}, result=Value(val='<badref>', ty=VoidType()), opcode='store', value=Value(val=1, ty=IntegerType(num_bits=32)), address=Value(val='%2', ty=PtrType(addr_space=0, ty=None))), Br(attrs=set(), result=Value(val='<badref>', ty=VoidType()), opcode='br', cond=None, label_false=Value(val='%13', ty=LabelType()), label_true=None)], pred_blocks=['%1']), Block(value=Value(val='%7', ty=LabelType()), instrs=[Load(attrs={('align', 4)}, result=Value(val='%8', ty=IntegerType(num_bits=32)), opcode='load', address=Value(val='%3', ty=PtrType(addr_space=0, ty=None))), BinOp(attrs={('nsw',)}, result=Value(val='%9', ty=IntegerType(num_bits=32)), opcode='sub', fst_operand=Value(val='%8', ty=IntegerType(num_bits=32)), snd_operand=Value(val=1, ty=IntegerType(num_bits=32))), Call(attrs=set(), result=Value(val='%10', ty=IntegerType(num_bits=32)), opcode='call', call_attributes=[set(), set(), {('noundef',)}], func=Value(val='factorial_req', ty=PtrType(addr_space=0, ty=None)), args=[Value(val='%9', ty=IntegerType(num_bits=32))]), Load(attrs={('align', 4)}, result=Value(val='%11', ty=IntegerType(num_bits=32)), opcode='load', address=Value(val='%3', ty=PtrType(addr_space=0, ty=None))), BinOp(attrs={('nsw',)}, result=Value(val='%12', ty=IntegerType(num_bits=32)), opcode='mul', fst_operand=Value(val='%10', ty=IntegerType(num_bits=32)), snd_operand=Value(val='%11', ty=IntegerType(num_bits=32))), Store(attrs={('align', 4)}, result=Value(val='<badref>', ty=VoidType()), opcode='store', value=Value(val='%12', ty=IntegerType(num_bits=32)), address=Value(val='%2', ty=PtrType(addr_space=0, ty=None))), Br(attrs=set(), result=Value(val='<badref>', ty=VoidType()), opcode='br', cond=None, label_false=Value(val='%13', ty=LabelType()), label_true=None)], pred_blocks=['%1']), Block(value=Value(val='%13', ty=LabelType()), instrs=[Load(attrs={('align', 4)}, result=Value(val='%14', ty=IntegerType(num_bits=32)), opcode='load', address=Value(val='%2', ty=PtrType(addr_space=0, ty=None))), Ret(attrs=set(), result=Value(val='<badref>', ty=VoidType()), opcode='ret', value=Value(val='%14', ty=IntegerType(num_bits=32)))], pred_blocks=['%7', '%6'])], attrs=[set(), set(), {('noundef',)}], calling_convention=<CallingConv.C: 0>, global_object=GlobalObject(addr_space=0, align=0, linkage=<LinkageType.ExternalLinkage: 0>, visibility=<VisibilityTypes.DefaultVisibility: 0>, unnamed_addr=<UnnamedAddr.Default: 0>))})"""
module = parse_assembly(ir_text)


def test_lib():
    assert dumped_ir == repr(module), (
        "Dump is different from the original:\n" + dumped_ir
    )
