(function(){"use strict";RB.AbstractCommentBlock=Backbone.Model.extend({defaults:{hasDraft:false,canDelete:false,draftComment:null,reviewRequest:null,review:null,serializedComments:[],count:0},initialize:function initialize(){var _this=this;console.assert(this.get("reviewRequest"),"reviewRequest must be provided");console.assert(this.get("review"),"review must be provided");var comments=this.get("serializedComments");var newSerializedComments=[];if(comments.length>0){comments.forEach(function(comment){comment.text=$("<div>").html(comment.text).text();if(comment.localdraft){_this.ensureDraftComment(comment.comment_id,{text:comment.text,richText:comment.rich_text,issueOpened:comment.issue_opened,issueStatus:comment.issue_status,html:comment.html})}else{newSerializedComments.push(comment)}},this);this.set("serializedComments",newSerializedComments)}else{this.ensureDraftComment()}this.on("change:draftComment",this._updateCount,this);this._updateCount()},isEmpty:function isEmpty(){return this.get("serializedComments").length===0&&!this.has("draftComment")},createComment:function createComment(id){console.assert(false,"This must be implemented by a subclass")},ensureDraftComment:function ensureDraftComment(id,comment_attr){var _this2=this;if(this.has("draftComment")){return}var comment=this.createComment(id);comment.set(comment_attr);comment.on("saved",this._updateCount,this);comment.on("destroy",function(){_this2.set("draftComment",null);_this2._updateCount()});this.set("draftComment",comment)},_updateCount:function _updateCount(){var count=this.get("serializedComments").length;if(this.has("draftComment")){count++}this.set("count",count)}});"use strict";RB.AbstractReviewable=Backbone.Model.extend({defaults:{caption:null,renderedInline:false,reviewRequest:null,review:null,serializedCommentBlocks:[]},commentBlockModel:null,defaultCommentBlockFields:[],initialize:function initialize(){var reviewRequest=this.get("reviewRequest");console.assert(this.commentBlockModel,"'commentBlockModel' must be defined in the "+"reviewable's object definition");console.assert(reviewRequest,"'reviewRequest' must be provided when constructing "+"the reviewable");if(!this.get("review")){this.set("review",reviewRequest.createReview())}this.commentBlocks=new Backbone.Collection;this.commentBlocks.model=this.commentBlockModel;_.each(this.get("serializedCommentBlocks"),this.loadSerializedCommentBlock,this)},createCommentBlock:function createCommentBlock(attrs){this.commentBlocks.add(_.defaults({reviewRequest:this.get("reviewRequest"),review:this.get("review")},attrs))},loadSerializedCommentBlock:function loadSerializedCommentBlock(serializedCommentBlock){console.assert(false,"loadSerializedCommentBlock must be "+"implemented by a subclass")}});"use strict";RB.CommentEditor=Backbone.Model.extend(_.defaults({defaults:function defaults(){var userSession=RB.UserSession.instance;return{canDelete:false,canEdit:undefined,canSave:false,editing:false,extraData:{},comment:null,dirty:false,openIssue:userSession.get("commentsOpenAnIssue"),publishedComments:[],publishedCommentsType:null,requireVerification:false,reviewRequest:null,richText:userSession.get("defaultUseRichText"),text:""}},initialize:function initialize(){var _this=this;var reviewRequest=this.get("reviewRequest");this.on("change:comment",this._updateFromComment,this);this._updateFromComment();if(this.get("canEdit")===undefined){reviewRequest.on("change:hasDraft",this._updateCanEdit,this);this._updateCanEdit()}this.on("change:dirty",function(model,dirty){var reviewRequestEditor=_this.get("reviewRequestEditor");if(reviewRequestEditor){if(dirty){reviewRequestEditor.incr("editCount")}else{reviewRequestEditor.decr("editCount")}}});this.on("change:openIssue change:requireVerification "+"change:richText change:text",function(){if(_this.get("editing")){_this.set("dirty",true);_this._updateState()}});this._updateState();this._setupExtraData()},beginEdit:function beginEdit(){console.assert(this.get("canEdit"),"beginEdit() called when canEdit is false.");console.assert(this.get("comment"),"beginEdit() called when no comment was first set.");this.set({dirty:false,editing:true});this._updateState()},deleteComment:function deleteComment(){var _this2=this;console.assert(this.get("canDelete"),"deleteComment() called when canDelete is false.");var comment=this.get("comment");comment.destroy({success:function success(){_this2.trigger("deleted");_this2.close()}})},cancel:function cancel(){var comment=this.get("comment");this.off("change:comment",this._updateFromComment,this);if(comment){comment.destroyIfEmpty();this.trigger("canceled")}this.close()},close:function close(){this.set("editing",false);this.set({comment:null,dirty:false,extraData:new RB.ExtraData,text:""});this.trigger("closed")},save:function save(){var _this3=this;var options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};var context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:undefined;console.assert(this.get("canSave"),"save() called when canSave is false.");var extraData=_.clone(this.get("extraData"));extraData.require_verification=this.get("requireVerification");var comment=this.get("comment");comment.set({text:this.get("text"),issueOpened:this.get("openIssue"),extraData:extraData,richText:this.get("richText"),includeTextTypes:"html,raw,markdown"});comment.save({success:function success(){_this3.set("dirty",false);_this3.trigger("saved");if(_.isFunction(options.success)){options.success.call(context)}},error:_.isFunction(options.error)?options.error.bind(context):undefined})},_updateFromComment:function _updateFromComment(){var oldComment=this.previous("comment");var comment=this.get("comment");if(oldComment){oldComment.destroyIfEmpty()}if(comment){var defaultRichText=this.defaults().richText;this.set({dirty:false,extraData:comment.get("extraData"),openIssue:comment.get("issueOpened")===null?this.defaults().openIssue:comment.get("issueOpened"),requireVerification:comment.requiresVerification(),richText:defaultRichText||!!comment.get("richText")});var textFields=comment.get("richText")||!defaultRichText?comment.get("rawTextFields"):comment.get("markdownTextFields");this.set("text",!_.isEmpty(textFields)?textFields.text:comment.get("text"));comment.ready({ready:this._updateState},this)}},_updateCanEdit:function _updateCanEdit(){var reviewRequest=this.get("reviewRequest");var userSession=RB.UserSession.instance;this.set("canEdit",userSession.get("authenticated")&&!reviewRequest.get("hasDraft"))},_updateState:function _updateState(){var canEdit=this.get("canEdit");var editing=this.get("editing");var comment=this.get("comment");this.set({canDelete:canEdit&&editing&&comment&&!comment.isNew(),canSave:canEdit&&editing&&this.get("text")!==""})}},RB.ExtraDataMixin));"use strict";RB.CommentIssueManager=Backbone.Model.extend({defaults:{reviewRequest:null},initialize:function initialize(){this._comments={}},setCommentState:function setCommentState(reviewID,commentID,commentType,state){var comment=this.getComment(reviewID,commentID,commentType);this._requestState(comment,state)},getComment:function getComment(reviewID,commentID,commentType){if(!this._comments[commentID]){var reviewRequest=this.get("reviewRequest");var comment=null;switch(commentType){case"diff_comments":comment=reviewRequest.createReview(reviewID).createDiffComment(commentID);break;case"screenshot_comments":comment=reviewRequest.createReview(reviewID).createScreenshotComment(commentID);break;case"file_attachment_comments":comment=reviewRequest.createReview(reviewID).createFileAttachmentComment(commentID);break;case"general_comments":comment=reviewRequest.createReview(reviewID).createGeneralComment(commentID);break;default:console.error('getComment received unexpected comment type "%s"',commentType)}this._comments[commentID]=comment}return this._comments[commentID]},_requestState:function _requestState(comment,state){var _this=this;comment.ready({ready:function ready(){var oldIssueStatus=comment.get("issueStatus");comment.set("issueStatus",state);comment.save({attrs:["issueStatus"],success:function success(comment,rsp){var rspComment=rsp.diff_comment||rsp.file_attachment_comment||rsp.screenshot_comment||rsp.general_comment;_this.trigger("issueStatusUpdated",comment,oldIssueStatus,rspComment.timestamp)}})}})}});"use strict";RB.FileAttachmentCommentBlock=RB.AbstractCommentBlock.extend({defaults:_.defaults({fileAttachmentID:null,diffAgainstFileAttachmentID:null},RB.AbstractCommentBlock.prototype.defaults),serializedFields:[],createComment:function createComment(id){var comment=this.get("review").createFileAttachmentComment(id,this.get("fileAttachmentID"),this.get("diffAgainstFileAttachmentID"));_.extend(comment.get("extraData"),_.pick(this.attributes,this.serializedFields));return comment}});"use strict";RB.FileAttachmentReviewable=RB.AbstractReviewable.extend({defaults:_.defaults({attachmentRevisionIDs:null,caption:"",diffAgainstFileAttachmentID:null,diffCaption:"",diffRevision:null,diffTypeMismatch:false,fileAttachmentID:null,fileRevision:null,filename:"",numRevisions:null},RB.AbstractReviewable.prototype.defaults),defaultCommentBlockFields:["fileAttachmentID","diffAgainstFileAttachmentID"],loadSerializedCommentBlock:function loadSerializedCommentBlock(serializedCommentBlock){var parsedData=this.commentBlockModel.prototype.parse(_.pick(serializedCommentBlock[0],this.commentBlockModel.prototype.serializedFields));this.createCommentBlock(_.extend({fileAttachmentID:this.get("fileAttachmentID"),diffAgainstFileAttachmentID:this.get("diffAgainstFileAttachmentID"),serializedComments:serializedCommentBlock},parsedData))}});"use strict";RB.RegionCommentBlock=RB.FileAttachmentCommentBlock.extend({defaults:_.defaults({x:null,y:null,width:null,height:null},RB.AbstractCommentBlock.prototype.defaults),serializedFields:["x","y","width","height"],parse:function parse(fields){fields.x=parseInt(fields.x,10)||undefined;fields.y=parseInt(fields.y,10)||undefined;fields.width=parseInt(fields.width,10)||undefined;fields.height=parseInt(fields.height,10)||undefined;return fields},canUpdateBounds:function canUpdateBounds(){return _.isEmpty(this.get("serializedComments"))},saveDraftCommentBounds:function saveDraftCommentBounds(){var _this=this;var draftComment=this.get("draftComment");draftComment.ready({ready:function ready(){var extraData=draftComment.get("extraData");extraData.x=_this.get("x");extraData.y=_this.get("y");extraData.width=_this.get("width");extraData.height=_this.get("height");draftComment.save({attrs:["extra_data.x","extra_data.y","extra_data.width","extra_data.height"],boundsUpdated:true})}})}});"use strict";RB.ReviewRequestEditor=Backbone.Model.extend({defaults:{changeDescriptionRenderedText:"",closeDescriptionRenderedText:"",commentIssueManager:null,editable:false,editCount:0,hasDraft:false,fileAttachments:null,fileAttachmentComments:{},mutableByUser:false,pendingSaveCount:0,publishing:false,reviewRequest:null,screenshots:null,showSendEmail:false,statusEditable:false,statusMutableByUser:false},initialize:function initialize(){var _this=this;var reviewRequest=this.get("reviewRequest");var fileAttachments=this.get("fileAttachments");if(fileAttachments===null){fileAttachments=new Backbone.Collection([],{model:RB.FileAttachment});this.set("fileAttachments",fileAttachments)}this.listenTo(fileAttachments,"add",this._onFileAttachmentOrScreenshotAdded);fileAttachments.each(this._onFileAttachmentOrScreenshotAdded.bind(this));var screenshots=this.get("screenshots");if(screenshots===null){screenshots=new Backbone.Collection([],{model:RB.Screenshot});this.set("screenshots",screenshots)}this.listenTo(screenshots,"add",this._onFileAttachmentOrScreenshotAdded);screenshots.each(this._onFileAttachmentOrScreenshotAdded.bind(this));this.listenTo(reviewRequest.draft,"saving",function(){return _this.trigger("saving")});this.listenTo(reviewRequest.draft,"saved",function(){return _this.trigger("saved")});this.listenTo(reviewRequest,"change:state",this._computeEditable);this._computeEditable()},createFileAttachment:function createFileAttachment(attributes){var draft=this.get("reviewRequest").draft;var fileAttachments=this.get("fileAttachments");var fileAttachment=draft.createFileAttachment(attributes);fileAttachments.add(fileAttachment);return fileAttachment},getDraftField:function getDraftField(fieldName){var options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var reviewRequest=this.get("reviewRequest");var draft=reviewRequest.draft;if(options.useExtraData){var data=void 0;if(options.useRawTextValue){var rawTextFields=draft.get("rawTextFields");if(rawTextFields&&rawTextFields.extra_data){data=rawTextFields.extra_data}}if(!data){data=draft.get("extraData")}return data[fieldName]}else if(fieldName==="closeDescription"||fieldName==="closeDescriptionRichText"){return reviewRequest.get(fieldName)}else{return draft.get(fieldName)}},setDraftField:function setDraftField(fieldName,value){var _this2=this;var options=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};var context=arguments.length>3&&arguments[3]!==undefined?arguments[3]:undefined;var reviewRequest=this.get("reviewRequest");var data={};var jsonFieldName=options.jsonFieldName;console.assert(jsonFieldName,"jsonFieldName must be set when setting draft "+('field "'+fieldName+'".'));if(options.useExtraData){jsonFieldName="extra_data."+jsonFieldName}if(options.allowMarkdown){var jsonTextTypeFieldName=options.jsonTextTypeFieldName;console.assert(jsonTextTypeFieldName,"jsonTextTypeFieldName must be set.");if(options.useExtraData){jsonTextTypeFieldName="extra_data."+jsonTextTypeFieldName}var richText=!!options.richText;data[jsonTextTypeFieldName]=richText?"markdown":"plain";data.force_text_type="html";data.include_text_types="raw"}data[jsonFieldName]=value;reviewRequest.draft.save({data:data,error:function error(model,xhr){var message="";_this2.set("publishing",false);if(_.isFunction(options.error)){var rsp=xhr.errorPayload;var fieldValue=rsp.fields[jsonFieldName];var fieldValueLen=fieldValue.length;_.each(fieldValue,function(value,i){if(i===fieldValueLen-1&&fieldValueLen>1){if(i>2){message+=", "}message+=' and "'+value+'"'}else{if(i>0){message+=", "}message+='"'+value+'"'}});if(fieldName==="targetGroups"){message=interpolate(ngettext("Group %s does not exist.","Groups %s do not exist.",fieldValue.length),[message])}else if(fieldName==="targetPeople"){message=interpolate(ngettext("User %s does not exist.","Users %s do not exist.",fieldValue.length),[message])}else if(fieldName==="submitter"){message=interpolate(gettext("User %s does not exist."),[message])}else if(fieldName==="dependsOn"){message=interpolate(ngettext("Review Request %s does not exist.","Review Requests %s do not exist.",fieldValue.length),[message])}options.error.call(context,{errorText:message})}},success:function success(){_this2.set("hasDraft",true);if(_.isFunction(options.success)){options.success.call(context)}_this2.trigger("fieldChanged:"+fieldName,value);_this2.trigger("fieldChanged",fieldName,value);if(_this2.get("publishing")){_this2.decr("pendingSaveCount");if(_this2.get("pendingSaveCount")===0){_this2.set("publishing",false);_this2.publishDraft()}}}},this)},publishDraft:function publishDraft(){var _this3=this;var options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};var reviewRequest=this.get("reviewRequest");var onError=function onError(model,xhr){return _this3.trigger("publishError",xhr.errorText)};reviewRequest.draft.ensureCreated({success:function success(){if(reviewRequest.attributes.links.submitter.title!==reviewRequest.draft.attributes.links.submitter.title){if(!confirm(gettext("Are you sure you want to change the ownership of this review request? Doing so may prevent you from editing the review request afterwards."))){return}}reviewRequest.draft.publish({success:function success(){return _this3.trigger("published")},error:onError,trivial:options.trivial?1:0},_this3)},error:onError},this)},incr:function incr(attr){var value=this.get(attr);console.assert(_.isNumber(value));this.set(attr,value+1,{validate:true})},decr:function decr(attr){var value=this.get(attr);console.assert(_.isNumber(value));this.set(attr,value-1,{validate:true})},validate:function validate(attrs){var strings=RB.ReviewRequestEditor.strings;if(_.has(attrs,"editCount")&&attrs.editCount<0){return strings.UNBALANCED_EDIT_COUNT}},_computeEditable:function _computeEditable(){var state=this.get("reviewRequest").get("state");var pending=state===RB.ReviewRequest.PENDING;this.set({editable:this.get("mutableByUser")&&pending,statusEditable:this.get("statusMutableByUser")&&!pending})},_onFileAttachmentOrScreenshotAdded:function _onFileAttachmentOrScreenshotAdded(attachment){var _this4=this;this.listenTo(attachment,"saving",function(){return _this4.trigger("saving")});this.listenTo(attachment,"saved destroy",function(){_this4.set("hasDraft",true);_this4.trigger("saved")})}},{strings:{UNBALANCED_EDIT_COUNT:gettext("There is an internal error balancing the edit count")}});"use strict";RB.ImageReviewable=RB.FileAttachmentReviewable.extend({defaults:_.defaults({imageURL:"",diffAgainstImageURL:"",scale:1},RB.FileAttachmentReviewable.prototype.defaults),commentBlockModel:RB.RegionCommentBlock});"use strict";RB.DummyReviewable=RB.FileAttachmentReviewable.extend({commentBlockModel:RB.AbstractCommentBlock});"use strict";RB.ScreenshotCommentBlock=RB.AbstractCommentBlock.extend({defaults:_.defaults({screenshotID:null,x:null,y:null,width:null,height:null},RB.AbstractCommentBlock.prototype.defaults),canUpdateBounds:function canUpdateBounds(){return false},createComment:function createComment(id){return this.get("review").createScreenshotComment(id,this.get("screenshotID"),this.get("x"),this.get("y"),this.get("width"),this.get("height"))}});"use strict";RB.ScreenshotReviewable=RB.AbstractReviewable.extend({defaults:_.defaults({caption:"",imageURL:"",screenshotID:null},RB.AbstractReviewable.prototype.defaults),commentBlockModel:RB.ScreenshotCommentBlock,defaultCommentBlockFields:["screenshotID"],loadSerializedCommentBlock:function loadSerializedCommentBlock(serializedCommentBlock){this.createCommentBlock({screenshotID:this.get("screenshotID"),x:serializedCommentBlock[0].x,y:serializedCommentBlock[0].y,width:serializedCommentBlock[0].w,height:serializedCommentBlock[0].h,serializedComments:serializedCommentBlock})}});"use strict";RB.TextCommentBlock=RB.FileAttachmentCommentBlock.extend({defaults:_.defaults({beginLineNum:null,endLineNum:null,viewMode:false,$beginRow:null,$endRow:null},RB.FileAttachmentCommentBlock.prototype.defaults),serializedFields:["beginLineNum","endLineNum","viewMode"],parse:function parse(fields){fields.beginLineNum=parseInt(fields.beginLineNum,10);fields.endLineNum=parseInt(fields.endLineNum,10);return fields}});"use strict";RB.TextBasedReviewable=RB.FileAttachmentReviewable.extend({defaults:_.defaults({viewMode:"source",hasRenderedView:false},RB.FileAttachmentReviewable.prototype.defaults),commentBlockModel:RB.TextCommentBlock,defaultCommentBlockFields:["viewMode"].concat(RB.FileAttachmentReviewable.prototype.defaultCommentBlockFields)});RB.UploadDiffModel=Backbone.Model.extend({defaults:{basedir:null,changeNumber:null,diffFile:null,diffValid:false,error:null,parentDiffFile:null,repository:null,reviewRequest:null,state:0},State:{PROMPT_FOR_DIFF:0,PROMPT_FOR_BASEDIR:1,PROPMT_FOR_CHANGE_NUMBER:2,PROCESSING_DIFF:3,UPLOADING:4,PROMPT_FOR_PARENT_DIFF:5,ERROR:6},initialize:function(){_super(this).initialize.apply(this,arguments);this.on("change:diffFile change:parentDiffFile change:basedir "+"change:changeNumber change:diffValid",this._updateState,this)},startOver:function(){this.set({basedir:null,changeNumber:null,diffFile:null,diffValid:false,error:null,parentDiffFile:null,state:this.State.PROMPT_FOR_DIFF})},handleFiles:function(files){switch(this.get("state")){case this.State.PROMPT_FOR_DIFF:this.set("diffFile",files[0]);break;case this.State.PROMPT_FOR_PARENT_DIFF:this.set("parentDiffFile",files[0]);break;default:console.assert("File received in wrong state");break}},_updateState:function(){var basedir=this.get("basedir"),changeNumber=this.get("changeNumber"),diff=this.get("diffFile"),diffValid=this.get("diffValid"),parentDiff=this.get("parentDiffFile"),repository=this.get("repository"),requiresBasedir=repository.get("requiresBasedir"),requiresChangeNumber=repository.get("requiresChangeNumber"),state=this.get("state");switch(state){case this.State.PROMPT_FOR_DIFF:if(diff){if(requiresBasedir&&!basedir){this.set("state",this.State.PROMPT_FOR_BASEDIR)}else if(requiresChangeNumber&&!changeNumber){this.set("state",this.State.PROMPT_FOR_CHANGE_NUMBER)}else{this.set("state",this.State.PROCESSING_DIFF);this._tryValidate()}}break;case this.State.PROMPT_FOR_PARENT_DIFF:if(diff&&parentDiff){this.set("state",this.State.PROCESSING_DIFF);this._tryValidate()}break;case this.State.PROMPT_FOR_BASEDIR:console.assert(diff,"cannot be in basedir prompt state without a diff");if(basedir){if(requiresChangeNumber&&!changeNumber){this.set("state",this.State.PROMPT_FOR_CHANGE_NUMBER)}else{this.set("state",this.State.PROCESSING_DIFF);this._tryValidate()}}break;case this.State.PROMPT_FOR_CHANGE_NUMBER:console.assert(diff,"cannot be in changenum prompt state without a diff");if(changeNumber){this.set("state",this.State.PROCESSING_DIFF);this._tryValidate()}break;case this.State.PROCESSING_DIFF:if(diffValid){this.set("state",this.State.UPLOADING);if(this.get("reviewRequest")===null){this._createReviewRequest()}else{this._createDiff()}}break;case this.State.UPLOADING:break;case this.State.ERROR:break}},_tryValidate:function(){var diff=this.get("diffFile"),parentDiff=this.get("parentDiffFile"),repository=this.get("repository"),uploader=new RB.ValidateDiffModel;this.set("diffValid",false);console.assert(diff);uploader.set({repository:repository.get("id"),localSitePrefix:repository.get("localSitePrefix"),basedir:this.get("basedir"),diff:diff,parentDiff:parentDiff});uploader.save({success:_.bind(this._onValidateSuccess,this),error:_.bind(this._onValidateError,this)})},_onValidateSuccess:function(){this.set("diffValid",true)},_onValidateError:function(model,xhr){var rsp=$.parseJSON(xhr.responseText),newState=this.State.ERROR,error;if(rsp!==null){switch(rsp.err.code){case RB.APIErrors.REPO_FILE_NOT_FOUND:if(this.get("repository").get("scmtoolName")==="Git"&&rsp.revision.length!==40){error=gettext("The uploaded diff uses short revisions, but Review Board requires full revisions.<br />Please generate a new diff using the <code>--full-index</code> parameter.")}else{error=interpolate(gettext('The file "%(file)s" (revision %(revision)s) was not found in the repository.'),{file:rsp.file,revision:rsp.revision},true);if(this.get("parentDiffFile")===null){newState=this.State.PROMPT_FOR_PARENT_DIFF}}break;case RB.APIErrors.DIFF_PARSE_ERROR:error=interpolate(gettext("%(error)s<br />Line %(line)s: %(reason)s"),{error:rsp.err.msg,line:rsp.linenum,reason:rsp.reason},true);break;default:error=rsp.err.msg;break}}else{error=gettext("Unknown error")}if(error){this.set({state:newState,error:error})}},_createReviewRequest:function(){var repository=this.get("repository"),reviewRequest=new RB.ReviewRequest({commitID:this.get("changeNumber"),localSitePrefix:repository.get("localSitePrefix"),repository:repository.get("id")});reviewRequest.save({success:function(){this.set("reviewRequest",reviewRequest);this._createDiff()},error:this._onValidateError},this)},_createDiff:function(){var reviewRequest=this.get("reviewRequest"),diff=reviewRequest.createDiff();diff.set({basedir:this.get("basedir"),diff:this.get("diffFile"),parentDiff:this.get("parentDiffFile")});diff.url=reviewRequest.get("links").diffs.href;diff.save({success:function(){window.location=reviewRequest.get("reviewURL")},error:this._onValidateError},this)}});"use strict";RB.ReviewablePage=RB.Page.extend({defaults:_.defaults({checkForUpdates:false,checkUpdatesType:null,lastActivityTimestamp:null,pendingReview:null,reviewRequest:null},RB.Page.prototype.defaults),initialize:function initialize(attributes){var _this=this;RB.Page.prototype.initialize.apply(this,arguments);var reviewRequest=this.get("reviewRequest");console.assert(reviewRequest,"The reviewRequest attribute or parse=true must be provided.");console.assert(this.get("pendingReview"),"The pendingReview attribute or parse=true must be provided.");this.commentIssueManager=new RB.CommentIssueManager({reviewRequest:reviewRequest});var editorData=attributes.editorData||{};var fileAttachments=new Backbone.Collection(_.map(editorData.fileAttachments,editorData.mutableByUser?function(attrs){return reviewRequest.draft.createFileAttachment(attrs)}:function(attrs){return reviewRequest.createFileAttachment(attrs)}),{model:RB.FileAttachment});this.reviewRequestEditor=new RB.ReviewRequestEditor(_.defaults({commentIssueManager:this.commentIssueManager,reviewRequest:reviewRequest,fileAttachments:fileAttachments},editorData));this.listenTo(reviewRequest,"updated",function(info){return _this.trigger("reviewRequestUpdated",info)});if(this.get("checkForUpdates")){this._registerForUpdates()}},markShipIt:function markShipIt(){var pendingReview=this.get("pendingReview");pendingReview.ready({ready:function ready(){pendingReview.set({shipIt:true,bodyTop:gettext("Ship It!")});pendingReview.publish()}})},parse:function parse(rsp){var reviewRequestData=void 0;if(rsp.reviewRequestData){reviewRequestData=_.defaults({state:RB.ReviewRequest[rsp.reviewRequestData.state],visibility:RB.ReviewRequest["VISIBILITY_"+rsp.reviewRequestData.visibility]},rsp.reviewRequestData);if(reviewRequestData.repository){reviewRequestData.repository=new RB.Repository(_.defaults({localSitePrefix:rsp.reviewRequestData.localSitePrefix},rsp.reviewRequestData.repository))}}var reviewRequest=new RB.ReviewRequest(reviewRequestData,{extraDraftAttrs:rsp.extraReviewRequestDraftData});return{reviewRequest:reviewRequest,pendingReview:reviewRequest.createReview(),lastActivityTimestamp:rsp.lastActivityTimestamp,checkForUpdates:rsp.checkForUpdates,checkUpdatesType:rsp.checkUpdatesType}},_registerForUpdates:function _registerForUpdates(){this.get("reviewRequest").beginCheckForUpdates(this.get("checkUpdatesType"),this.get("lastActivityTimestamp"))}});"use strict";RB.DiffViewerPage=RB.ReviewablePage.extend({defaults:_.defaults({canDownloadDiff:false,filenamePatterns:null,numDiffs:1},RB.ReviewablePage.prototype.defaults),constructor:function constructor(){this.commentsHint=new RB.DiffCommentsHint;this.files=new RB.DiffFileCollection;this.pagination=new RB.Pagination;this.revision=new RB.DiffRevision;RB.ReviewablePage.apply(this,arguments)},initialize:function initialize(){RB.ReviewablePage.prototype.initialize.apply(this,arguments);this.diffReviewables=new RB.DiffReviewableCollection([],{reviewRequest:this.get("reviewRequest")});this.diffReviewables.watchFiles(this.files)},parse:function parse(rsp){return _.extend(this._parseDiffContext(rsp),RB.ReviewablePage.prototype.parse.call(this,rsp))},loadDiffRevision:function loadDiffRevision(){var _this=this;var options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};var reviewRequestURL=this.get("reviewRequest").url();var queryData=[];if(options.revision){queryData.push({name:"revision",value:options.revision})}if(options.interdiffRevision){queryData.push({name:"interdiff-revision",value:options.interdiffRevision})}if(options.page&&options.page!==1){queryData.push({name:"page",value:options.page})}if(options.filenamePatterns){queryData.push({name:"filenames",value:options.filenamePatterns})}var url=Djblets.buildURL({baseURL:reviewRequestURL+"diff-context/",queryData:queryData});$.ajax(url).done(function(rsp){return _this.set(_this._parseDiffContext(rsp.diff_context))})},_parseDiffContext:function _parseDiffContext(rsp){if(rsp.comments_hint){this.commentsHint.set(this.commentsHint.parse(rsp.comments_hint))}if(rsp.files){this.files.reset(rsp.files,{parse:true})}if(rsp.pagination){this.pagination.set(this.pagination.parse(rsp.pagination))}if(rsp.revision){this.revision.set(this.revision.parse(rsp.revision))}return{canDownloadDiff:rsp.revision&&rsp.revision.interdiff_revision===null,filenamePatterns:rsp.filename_patterns||null,numDiffs:rsp.num_diffs||0}}});"use strict";(function(){var UpdatesBubbleView=Backbone.View.extend({id:"updates-bubble",template:_.template(['<span id="updates-bubble-summary"><%- summary %></span>'," by ",'<a href="<%- user.url %>" id="updates-bubble-user">',"<%- user.fullname || user.username %>","</a>",'<span id="updates-bubble-buttons">',' <a href="#" class="update-page"><%- updatePageText %></a>'," | ",' <a href="#" class="ignore"><%- ignoreText %></a>'].join("")),events:{"click .update-page":"_onUpdatePageClicked","click .ignore":"_onIgnoreClicked"},render:function render(){this.$el.html(this.template(_.defaults({updatePageText:gettext("Update Page"),ignoreText:gettext("Ignore")},this.options.updateInfo))).hide();return this},open:function open(){this.$el.css("position","fixed").fadeIn()},close:function close(){this.trigger("closed");this.$el.fadeOut(_.bind(this.remove,this))},_onUpdatePageClicked:function _onUpdatePageClicked(e){e.preventDefault();e.stopPropagation();this.trigger("updatePage")},_onIgnoreClicked:function _onIgnoreClicked(e){e.preventDefault();e.stopPropagation();this.close()}});RB.ReviewablePageView=RB.PageView.extend({events:_.defaults({"click #review-action":"_onEditReviewClicked","click #ship-it-action":"_onShipItClicked","click #general-comment-action":"_onAddCommentClicked","click .has-menu .has-menu":"_onMenuClicked"},RB.PageView.prototype.events),initialize:function initialize(options){var _this=this;this.options=options;RB.DnDUploader.create();this.reviewRequestEditorView=new RB.ReviewRequestEditorView({el:$("#review-request"),model:this.model.reviewRequestEditor});this._updatesBubble=null;this._favIconURL=null;this._favIconNotifyURL=null;this._logoNotificationsURL=null;["reviewRequest","pendingReview"].forEach(function(attrName){_this[attrName]=_this.model.get(attrName);_this.listenTo(_this.model,"change:"+attrName,function(){_this[attrName]=_this.model.get(attrName)})});RB.NotificationManager.instance.setup();if(RB.UserSession.instance.get("authenticated")){this._starManager=new RB.StarManagerView({model:new RB.StarManager,el:this.$(".star").parent()})}this.listenTo(this.model,"reviewRequestUpdated",this._onReviewRequestUpdated)},render:function render(){var _this2=this;var $favicon=$("head").find('link[rel="shortcut icon"]');this._favIconURL=$favicon.attr("href");this._favIconNotifyURL=STATIC_URLS["rb/images/favicon_notify.ico"];this._logoNotificationsURL=STATIC_URLS["rb/images/logo.png"];var pendingReview=this.model.get("pendingReview");this.draftReviewBanner=RB.DraftReviewBannerView.create({el:$("#review-banner"),model:pendingReview,reviewRequestEditor:this.model.reviewRequestEditor});this.listenTo(pendingReview,"destroy published",function(){return _this2.draftReviewBanner.hideAndReload()});this.reviewRequestEditorView.render();return this},remove:function remove(){this.draftReviewBanner.remove();_super(this).remove.call(this)},_onReviewRequestUpdated:function _onReviewRequestUpdated(info){this._updateFavIcon(this._favIconNotifyURL);if(RB.NotificationManager.instance.shouldNotify()){this._showDesktopNotification(info)}this._showUpdatesBubble(info)},_showUpdatesBubble:function _showUpdatesBubble(info){var _this3=this;if(this._updatesBubble){this._updatesBubble.remove()}var reviewRequest=this.model.get("reviewRequest");this._updatesBubble=new UpdatesBubbleView({updateInfo:info,reviewRequest:reviewRequest});this.listenTo(this._updatesBubble,"closed",function(){return _this3._updateFavIcon(_this3._favIconURL)});this.listenTo(this._updatesBubble,"updatePage",function(){window.location=reviewRequest.get("reviewURL")});this._updatesBubble.render().$el.appendTo(this.$el);this._updatesBubble.open()},
_showDesktopNotification:function _showDesktopNotification(info){var reviewRequest=this.model.get("reviewRequest");RB.NotificationManager.instance.notify({title:info.summary,body:interpolate(gettext("Review request #%s, by %s"),[reviewRequest.id,info.user.fullname||info.user.username]),iconURL:this._logoNotificationsURL,onClick:function onClick(){window.location=reviewRequest.get("reviewURL")}})},_updateFavIcon:function _updateFavIcon(url){$("head").find('link[rel="shortcut icon"]').remove().end().append($("<link/>").attr({href:url,rel:"shortcut icon",type:"image/x-icon"}))},_onEditReviewClicked:function _onEditReviewClicked(){RB.ReviewDialogView.create({review:this.model.get("pendingReview"),reviewRequestEditor:this.model.reviewRequestEditor});return false},_onAddCommentClicked:function _onAddCommentClicked(){var pendingReview=this.model.get("pendingReview");var comment=pendingReview.createGeneralComment(undefined,RB.UserSession.instance.get("commentsOpenAnIssue"));this.listenTo(comment,"saved",function(){return RB.DraftReviewBannerView.instance.show()});RB.CommentDialogView.create({comment:comment,reviewRequestEditor:this.model.reviewRequestEditor});return false},_onShipItClicked:function _onShipItClicked(){if(confirm(gettext("Are you sure you want to post this review?"))){this.model.markShipIt()}return false},_onMenuClicked:function _onMenuClicked(e){e.preventDefault();e.stopPropagation()}})})();"use strict";RB.DiffViewerPageView=RB.ReviewablePageView.extend({SCROLL_BACKWARD:-1,SCROLL_FORWARD:1,ANCHOR_COMMENT:1,ANCHOR_FILE:2,ANCHOR_CHUNK:4,DIFF_SCROLLDOWN_AMOUNT:15,keyBindings:{"aAKP<m":"_selectPreviousFile","fFJN>":"_selectNextFile","sSkp,":"_selectPreviousDiff","dDjn.":"_selectNextDiff","[x":"_selectPreviousComment","]c":"_selectNextComment","\r":"_recenterSelected",rR:"_createComment"},events:_.extend({"click .toggle-whitespace-only-chunks":"_toggleWhitespaceOnlyChunks","click .toggle-show-whitespace":"_toggleShowExtraWhitespace"},RB.ReviewablePageView.prototype.events),_fileEntryTemplate:_.template('<div class="diff-container">\n <div class="diff-box">\n  <table class="sidebyside loading <% if (newFile) { %>newfile<% } %>"\n         id="file_container_<%- id %>">\n   <thead>\n    <tr class="filename-row">\n     <th>\n      <span class="fa fa-spinner fa-pulse"></span>\n      <%- filename %>\n     </th>\n    </tr>\n   </thead>\n  </table>\n </div>\n</div>'),anchorTemplate:_.template('<a name="<%- anchorName %>" class="highlight-anchor"></a>'),initialize:function initialize(){var _this=this;RB.ReviewablePageView.prototype.initialize.apply(this,arguments);this._selectedAnchorIndex=-1;this._$window=$(window);this._$anchors=$();this._$controls=null;this._$diffs=null;this._diffReviewableViews=[];this._diffFileIndexView=null;this._highlightedChunk=null;this.listenTo(this.model.diffReviewables,"add",this._onDiffReviewableAdded);var diffQueue=$.funcQueue("diff_files");this.listenTo(this.model.diffReviewables,"populating",function(){_this._diffReviewableViews.forEach(function(view){return view.remove()});_this._diffReviewableViews=[];_this._$diffs.children(".diff-container").remove();_this._highlightedChunk=null;diffQueue.clear()});this.listenTo(this.model.diffReviewables,"populated",function(){return diffQueue.start()});this.router=new Backbone.Router;this.router.route(/^(\d+(?:-\d+)?)\/?(\?[^#]*)?/,"revision",function(revision,queryStr){var queryArgs=Djblets.parseQueryString(queryStr||"");var page=queryArgs.page;var revisionRange=revision.split("-",2);_this.model.loadDiffRevision({page:page?parseInt(page,10):1,filenamePatterns:queryArgs.filenames||null,revision:parseInt(revisionRange[0],10),interdiffRevision:revisionRange.length===2?parseInt(revisionRange[1],10):null})});Backbone.history.start({pushState:true,hashChange:false,root:this.model.get("reviewRequest").get("reviewURL")+"diff/",silent:true});this._setInitialURL(document.location.search||"",RB.getLocationHash())},remove:function remove(){RB.ReviewablePageView.prototype.remove.call(this);this._$window.off("resize."+this.cid);this._diffFileIndexView.remove()},render:function render(){var _this2=this;RB.ReviewablePageView.prototype.render.call(this);this._$controls=$("#view_controls");this._diffFileIndexView=new RB.DiffFileIndexView({el:$("#diff_index"),collection:this.model.files});this._diffFileIndexView.render();this.listenTo(this._diffFileIndexView,"anchorClicked",this.selectAnchorByName);this._diffRevisionLabelView=new RB.DiffRevisionLabelView({el:$("#diff_revision_label"),model:this.model.revision});this._diffRevisionLabelView.render();this.listenTo(this._diffRevisionLabelView,"revisionSelected",this._onRevisionSelected);var numDiffs=this.model.get("numDiffs");if(numDiffs>1){this._diffRevisionSelectorView=new RB.DiffRevisionSelectorView({el:$("#diff_revision_selector"),model:this.model.revision,numDiffs:numDiffs});this._diffRevisionSelectorView.render();this.listenTo(this._diffRevisionSelectorView,"revisionSelected",this._onRevisionSelected)}this._commentsHintView=new RB.DiffCommentsHintView({el:$("#diff_comments_hint"),model:this.model.commentsHint});this._commentsHintView.render();this.listenTo(this._commentsHintView,"revisionSelected",this._onRevisionSelected);this._paginationView1=new RB.PaginationView({el:$("#pagination1"),model:this.model.pagination});this._paginationView1.render();this.listenTo(this._paginationView1,"pageSelected",_.partial(this._onPageSelected,false));this._paginationView2=new RB.PaginationView({el:$("#pagination2"),model:this.model.pagination});this._paginationView2.render();this.listenTo(this._paginationView2,"pageSelected",_.partial(this._onPageSelected,true));this._$diffs=$("#diffs").bindClass(RB.UserSession.instance,"diffsShowExtraWhitespace","ewhl");this._chunkHighlighter=new RB.ChunkHighlighterView;this._chunkHighlighter.render().$el.prependTo(this._$diffs);$("#diff-details").removeClass("loading");$("#download-diff-action").bindVisibility(this.model,"canDownloadDiff");this._$window.on("resize."+this.cid,_.throttleLayout(this._onWindowResize.bind(this)));if(this.model.diffReviewables.length>0){this.model.diffReviewables.each(function(diffReviewable){return _this2._onDiffReviewableAdded(diffReviewable)});$.funcQueue("diff_files").start()}return this},queueLoadDiff:function queueLoadDiff(diffReviewable){var _this3=this;var options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};$.funcQueue("diff_files").add(function(){var fileDiffID=diffReviewable.get("fileDiffID");if(!options.showDeleted&&$("#file"+fileDiffID).length===1){_this3._renderFileDiff(diffReviewable)}else{var prefix=options.showDeleted?"#file":"#file_container_";diffReviewable.getRenderedDiff({complete:function complete(xhr){var $container=$(prefix+fileDiffID).parent();if($container.length===0){return}$container.hide();$container[0].innerHTML=xhr.responseText;_this3._renderFileDiff(diffReviewable)}},_this3,options)}})},_renderFileDiff:function _renderFileDiff(diffReviewable){var _this4=this;var elementName="file"+diffReviewable.get("fileDiffID");var $el=$("#"+elementName);if($el.length===0){$.funcQueue("diff_files").next();return}var diffReviewableView=new RB.DiffReviewableView({el:$el,model:diffReviewable});this._diffFileIndexView.addDiff(this._diffReviewableViews.length,diffReviewableView);this._diffReviewableViews.push(diffReviewableView);diffReviewableView.render();diffReviewableView.$el.parent().show();this.listenTo(diffReviewableView,"fileClicked",function(){_this4.selectAnchorByName(diffReviewable.get("file").get("index"))});this.listenTo(diffReviewableView,"chunkClicked",function(name){_this4.selectAnchorByName(name,false)});this.listenTo(diffReviewableView,"moveFlagClicked",function(line){_this4.selectAnchor(_this4.$("a[target="+line+"]"))});this._updateAnchors(diffReviewableView.$el);this.listenTo(diffReviewableView,"chunkExpansionChanged",function(){_this4._highlightAnchor($(_this4._$anchors[_this4._selectedAnchorIndex]))});if(this._startAtAnchorName){var $anchor=$(document.getElementsByName(this._startAtAnchorName));var urlSplit=this._startAtAnchorName.split(",");if($anchor.length===0&&urlSplit.length===2&&elementName===urlSplit[0]){$anchor=$(this.anchorTemplate({anchorName:this._startAtAnchorName}));diffReviewableView.$el.find("tr[line='"+urlSplit[1]+"']").addClass("highlight-anchor").append($anchor)}if($anchor.length!==0){this.selectAnchor($anchor);this._startAtAnchorName=null}}this.listenTo(diffReviewableView,"showDeletedClicked",function(){_this4.queueLoadDiff(diffReviewable,{showDeleted:true});$.funcQueue("diff_files").start()});$.funcQueue("diff_files").next()},selectAnchor:function selectAnchor($anchor,scroll){if(!$anchor||$anchor.length===0||$anchor.parent().is(":hidden")){return false}if(scroll!==false){this._navigate({anchor:$anchor.attr("name"),updateURLOnly:true});var scrollAmount=this.DIFF_SCROLLDOWN_AMOUNT;if(RB.DraftReviewBannerView.instance){scrollAmount+=RB.DraftReviewBannerView.instance.getHeight()}this._$window.scrollTop($anchor.offset().top-scrollAmount)}this._highlightAnchor($anchor);for(var i=0;i<this._$anchors.length;i++){if(this._$anchors[i]===$anchor[0]){this._selectedAnchorIndex=i;break}}return true},selectAnchorByName:function selectAnchorByName(name,scroll){return this.selectAnchor($(document.getElementsByName(name)),scroll)},_highlightAnchor:function _highlightAnchor($anchor){this._highlightedChunk=$anchor.closest("tbody").add($anchor.closest("thead"));this._chunkHighlighter.highlight(this._highlightedChunk)},_updateAnchors:function _updateAnchors($table){this._$anchors=this._$anchors.add($table.find("th a[name]"));if(this._selectedAnchorIndex===-1&&this._$anchors.length>0){this._selectedAnchorIndex=0;this._highlightAnchor($(this._$anchors[this._selectedAnchorIndex]))}},_getNextAnchor:function _getNextAnchor(dir,anchorTypes){for(var i=this._selectedAnchorIndex+dir;i>=0&&i<this._$anchors.length;i+=dir){var $anchor=$(this._$anchors[i]);if($anchor.closest("tr").hasClass("dimmed")){continue}if(anchorTypes&this.ANCHOR_COMMENT&&$anchor.hasClass("commentflag-anchor")||anchorTypes&this.ANCHOR_FILE&&$anchor.hasClass("file-anchor")||anchorTypes&this.ANCHOR_CHUNK&&$anchor.hasClass("chunk-anchor")){return $anchor}}return null},_selectPreviousFile:function _selectPreviousFile(){this.selectAnchor(this._getNextAnchor(this.SCROLL_BACKWARD,this.ANCHOR_FILE))},_selectNextFile:function _selectNextFile(){this.selectAnchor(this._getNextAnchor(this.SCROLL_FORWARD,this.ANCHOR_FILE))},_selectPreviousDiff:function _selectPreviousDiff(){this.selectAnchor(this._getNextAnchor(this.SCROLL_BACKWARD,this.ANCHOR_CHUNK|this.ANCHOR_FILE))},_selectNextDiff:function _selectNextDiff(){this.selectAnchor(this._getNextAnchor(this.SCROLL_FORWARD,this.ANCHOR_CHUNK|this.ANCHOR_FILE))},_selectPreviousComment:function _selectPreviousComment(){this.selectAnchor(this._getNextAnchor(this.SCROLL_BACKWARD,this.ANCHOR_COMMENT))},_selectNextComment:function _selectNextComment(){this.selectAnchor(this._getNextAnchor(this.SCROLL_FORWARD,this.ANCHOR_COMMENT))},_recenterSelected:function _recenterSelected(){this.selectAnchor($(this._$anchors[this._selectedAnchorIndex]))},_createComment:function _createComment(){var chunkID=this._highlightedChunk[0].id;var chunkElement=document.getElementById(chunkID);if(chunkElement){var lineElements=chunkElement.getElementsByTagName("tr");var beginLineNum=lineElements[0].getAttribute("line");var beginNode=lineElements[0].cells[2];var endLineNum=lineElements[lineElements.length-1].getAttribute("line");var endNode=lineElements[lineElements.length-1].cells[2];this._diffReviewableViews.forEach(function(diffReviewableView){if($.contains(diffReviewableView.el,beginNode)){diffReviewableView.createComment(beginLineNum,endLineNum,beginNode,endNode)}})}},_toggleWhitespaceOnlyChunks:function _toggleWhitespaceOnlyChunks(){this._diffReviewableViews.forEach(function(view){return view.toggleWhitespaceOnlyChunks()});this._$controls.find(".ws").toggle();return false},_toggleShowExtraWhitespace:function _toggleShowExtraWhitespace(){this._$controls.find(".ew").toggle();RB.UserSession.instance.toggleAttr("diffsShowExtraWhitespace");return false},_setInitialURL:function _setInitialURL(queryString,anchor){this._startAtAnchorName=anchor||null;this._navigate({queryString:queryString,anchor:anchor,updateURLOnly:true})},_navigate:function _navigate(options){var curRevision=this.model.revision.get("revision");var curInterdiffRevision=this.model.revision.get("interdiffRevision");var revision=options.revision!==undefined?options.revision:curRevision;var interdiffRevision=options.interdiffRevision!==undefined?options.interdiffRevision:curInterdiffRevision;var baseURL=revision;if(interdiffRevision){baseURL+="-"+interdiffRevision}baseURL+="/";var queryData=options.queryString;if(queryData===undefined){queryData=[];var page=options.page;if(page===undefined&&revision===curRevision&&interdiffRevision===curInterdiffRevision){page=this.model.pagination.get("currentPage")}if(page&&page!==1){queryData.push({name:"page",value:page})}var filenamePatterns=this.model.get("filenamePatterns");if(filenamePatterns&&filenamePatterns.length>0){queryData.push({name:"filenames",value:filenamePatterns})}}var url=Djblets.buildURL({baseURL:baseURL,queryData:queryData,anchor:options.anchor});var navOptions=void 0;if(options.updateURLOnly){navOptions={replace:true,trigger:false}}else{navOptions={trigger:true}}this.router.navigate(url,navOptions)},_onDiffReviewableAdded:function _onDiffReviewableAdded(diffReviewable){var file=diffReviewable.get("file");this._$diffs.append(this._fileEntryTemplate({id:file.id,newFile:file.get("isnew"),filename:file.get("depotFilename")}));this.queueLoadDiff(diffReviewable)},_onWindowResize:function _onWindowResize(){for(var i=0;i<this._diffReviewableViews.length;i++){this._diffReviewableViews[i].updateLayout()}this._chunkHighlighter.updateLayout()},_onRevisionSelected:function _onRevisionSelected(revisions){var base=revisions[0];var tip=revisions[1];if(base===0){base=tip;tip=null}this._navigate({revision:base,interdiffRevision:tip})},_onPageSelected:function _onPageSelected(scroll,page){if(scroll){this.selectAnchorByName("index_header",true)}this._navigate({page:page})}});_.extend(RB.DiffViewerPageView.prototype,RB.KeyBindingsMixin);"use strict";RB.formatText=function($el){var options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};if(options.richText){if(options.newText!==undefined){$el.html(options.newText)}$el.addClass("rich-text").find("a").attr("target","_blank");RB.LinkifyUtils.linkifyChildren($el[0],options.bugTrackerURL)}else if(options.newText!==undefined){$el.html(RB.LinkifyUtils.linkifyText(options.newText||"",options.bugTrackerURL,options.isHTMLEncoded)).removeClass("rich-text")}else if($el!==undefined&&$el.length!==0){RB.LinkifyUtils.linkifyChildren($el[0],options.bugTrackerURL)}};"use strict";RB.AbstractCommentBlockView=Backbone.View.extend({events:{click:"_onClicked"},tooltipSides:"lrbt",dispose:function dispose(){this.trigger("removing");this.remove();this._$tooltip.remove()},render:function render(){this._$tooltip=$.tooltip(this.$el,{side:this.tooltipSides}).addClass("comments");this.renderContent();this.model.on("change:draftComment",this._onDraftCommentChanged,this);this._onDraftCommentChanged();this._updateTooltip();return this},hideTooltip:function hideTooltip(){this._$tooltip.hide()},positionCommentDlg:function positionCommentDlg(commentDlg){commentDlg.positionBeside(this.$el,{side:"r",fitOnScreen:true})},positionNotifyBubble:function positionNotifyBubble($bubble){$bubble.move(Math.round((this.$el.width()-$bubble.width())/2),Math.round((this.$el.height()-$bubble.height())/2))},notify:function notify(text,cb,context){var $bubble=$('<div class="bubble">').css("opacity",0).appendTo(this.$el).text(text);this.positionNotifyBubble($bubble);$bubble.animate({top:"-=10px",opacity:.8},350,"swing").delay(1200).animate({top:"+=10px",opacity:0},350,"swing",function(){$bubble.remove();if(_.isFunction(cb)){cb.call(context)}})},_updateTooltip:function _updateTooltip(){var $list=$("<ul/>");var draftComment=this.model.get("draftComment");var tooltipTemplate=_.template('<li>\n <div class="reviewer">\n  <%- user %>:\n </div>\n <pre class="rich-text"><%= html %></pre>\n</li>');if(draftComment){$(tooltipTemplate({user:RB.UserSession.instance.get("fullName"),html:draftComment.get("html")})).addClass("draft").appendTo($list)}this.model.get("serializedComments").forEach(function(comment){$(tooltipTemplate({user:comment.user.name,html:comment.html})).appendTo($list)});this._$tooltip.empty().append($list)},_onDraftCommentChanged:function _onDraftCommentChanged(){var _this=this;var comment=this.model.get("draftComment");if(!comment){this.$el.removeClass("draft");return}comment.on("change:text",this._updateTooltip,this);comment.on("destroy",function(){_this.notify(gettext("Comment Deleted"),function(){if(_this.model.isEmpty()){_this.$el.fadeOut(350,function(){return _this.dispose()})}else{_this.$el.removeClass("draft");_this._updateTooltip()}})});comment.on("saved",function(options){_this._updateTooltip();if(!options.boundsUpdated){_this.notify(gettext("Comment Saved"))}RB.DraftReviewBannerView.instance.show()});this.$el.addClass("draft")},_onClicked:function _onClicked(){this.trigger("clicked")}});"use strict";RB.AbstractReviewableView=Backbone.View.extend({commentBlockView:null,commentsListName:null,initialize:function initialize(){var options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};console.assert(this.commentBlockView,"commentBlockView must be defined by the subclass");console.assert(this.commentsListName,"commentsListName must be defined by the subclass");this.commentDlg=null;this._activeCommentBlock=null;this.renderedInline=options.renderedInline||false},render:function render(){this.renderContent();this.model.commentBlocks.each(this._addCommentBlockView,this);this.model.commentBlocks.on("add",this._addCommentBlockView,this);return this},renderContent:function renderContent(){},createAndEditCommentBlock:function createAndEditCommentBlock(options){var _this=this;if(this.commentDlg!==null&&this.commentDlg.model.get("dirty")&&!confirm(gettext("You are currently editing another comment. Would you like to discard it and create a new one?"))){return}var defaultCommentBlockFields=_.result(this.model,"defaultCommentBlockFields");if(defaultCommentBlockFields.length===0&&this.model.reviewableIDField){console.log("Deprecation notice: Reviewable subclass is missing "+"defaultCommentBlockFields. Rename reviewableIDField "+"to defaultCommentBlockFields, and make it a list.");defaultCommentBlockFields=[this.model.reviewableIDField]}this.once("commentBlockViewAdded",function(commentBlockView){return _this.showCommentDlg(commentBlockView)});_.extend(options,_.pick(this.model.attributes,defaultCommentBlockFields));this.model.createCommentBlock(options)},showCommentDlg:function showCommentDlg(commentBlockView){var _this2=this;var commentBlock=commentBlockView.model;commentBlock.ensureDraftComment();if(this._activeCommentBlock===commentBlock){return}this.stopListening(this.commentDlg,"closed");this.commentDlg=RB.CommentDialogView.create({comment:commentBlock.get("draftComment"),publishedComments:commentBlock.get("serializedComments"),publishedCommentsType:this.commentsListName,position:function position(dlg){return commentBlockView.positionCommentDlg(dlg)}});this._activeCommentBlock=commentBlock;this.listenTo(this.commentDlg,"closed",function(){_this2.commentDlg=null;_this2._activeCommentBlock=null})},_addCommentBlockView:function _addCommentBlockView(commentBlock){var _this3=this;var commentBlockView=new this.commentBlockView({model:commentBlock});commentBlockView.on("clicked",function(){return _this3.showCommentDlg(commentBlockView)});commentBlockView.render();this.trigger("commentBlockViewAdded",commentBlockView)}});"use strict";(function(){var CommentsListView=Backbone.View.extend({itemTemplate:_.template('<li class="<%= itemClass %>">\n <h2>\n  <%- comment.user.name %>\n  <span class="actions">\n   <a class="comment-list-view-action" href="<%= comment.url %>"><%- viewText %></a>\n   <a class="comment-list-reply-action"\n      href="<%= reviewRequestURL %>?reply_id=<%= comment.reply_to_id || comment.comment_id %>&reply_type=<%= replyType %>"\n      ><%- replyText %></a>\n  </span>\n </h2>\n <pre><%- comment.text %></pre>\n</li>'),setComments:function setComments(comments,replyType){var _this=this;if(comments.length===0){return}var reviewRequestURL=this.options.reviewRequestURL;var commentIssueManager=this.options.commentIssueManager;var interactive=this.options.issuesInteractive;var odd=true;var $items=$();_.each(comments,function(serializedComment){var commentID=serializedComment.comment_id;var $item=$(_this.itemTemplate({comment:serializedComment,itemClass:odd?"odd":"even",reviewRequestURL:reviewRequestURL,replyText:CommentsListView._replyText,replyType:replyType,viewText:CommentsListView._viewText}));if(serializedComment.issue_opened){var commentIssueBar=new RB.CommentIssueBarView({reviewID:serializedComment.review_id,commentID:commentID,commentType:replyType,issueStatus:serializedComment.issue_status,interactive:interactive,commentIssueManager:commentIssueManager});commentIssueBar.render().$el.appendTo($item);_this.listenTo(commentIssueManager,"issueStatusUpdated",function(comment){if(comment.id===commentID){serializedComment.issue_status=comment.get("issueStatus")}})}$items=$items.add($item);odd=!odd});this.$el.empty().append($items)}},{_replyText:gettext("Reply"),_viewText:gettext("View")});RB.CommentDialogView=Backbone.View.extend({DIALOG_TOTAL_HEIGHT:350,DIALOG_NON_EDITABLE_HEIGHT:120,SLIDE_DISTANCE:10,COMMENTS_BOX_WIDTH:280,FORM_BOX_WIDTH:450,className:"comment-dlg",template:_.template('<div class="other-comments">\n <h1 class="title"><%- otherReviewsText %></h1>\n <ul></ul>\n</div>\n<form method="post">\n <h1 class="comment-dlg-header">\n  <span class="title"></span>\n  <% if (authenticated && !hasDraft) { %>\n   <a class="markdown-info" href="<%- markdownDocsURL %>"\n      target="_blank"><%- markdownText %></a>\n  <% } %>\n </h1>\n <% if (!authenticated) { %>\n  <p class="login-text"><%= loginText %></p>\n <% } else if (hasDraft) { %>\n  <p class="draft-warning"><%= draftWarning %></p>\n <% } %>\n <div class="comment-dlg-body">\n  <div class="comment-text-field"></div>\n  <ul class="comment-dlg-options">\n   <li class="comment-issue-options">\n    <input type="checkbox" id="comment_issue">\n    <label for="comment_issue" accesskey="i"><%= openAnIssueText %></label>\n    <% if (showVerify) { %>\n     <input type="checkbox" id="comment_issue_verify">\n     <label for="comment_issue_verify"><%= verifyIssueText %></label>\n    <% } %>\n   </li>\n   <li class="comment-markdown-options">\n    <input type="checkbox" id="enable_markdown">\n    <label for="enable_markdown" accesskey="m"><%= enableMarkdownText %></label>\n   </li>\n  </ul>\n </div>\n <div class="comment-dlg-footer">\n  <div class="buttons">\n   <input type="button" class="save" value="<%- saveButton %>"\n          disabled="true">\n   <input type="button" class="cancel" value="<%- cancelButton %>">\n   <input type="button" class="delete" value="<%- deleteButton %>"\n          disabled="true">\n   <input type="button" class="close" value="<%- closeButton %>">\n  </div>\n </div>\n</form>'),events:{"click .buttons .cancel":"_onCancelClicked","click .buttons .close":"_onCancelClicked","click .buttons .delete":"_onDeleteClicked","click .buttons .save":"save","keydown .comment-text-field":"_onTextKeyDown"},render:function render(){var _this2=this;var userSession=RB.UserSession.instance;var reviewRequest=this.model.get("reviewRequest");var reviewRequestEditor=this.model.get("reviewRequestEditor");this.options.animate=this.options.animate!==false;this.$el.hide().html(this.template({authenticated:userSession.get("authenticated"),hasDraft:reviewRequest.get("hasDraft"),markdownDocsURL:MANUAL_URL+"users/markdown/",markdownText:RB.CommentDialogView._markdownText,otherReviewsText:RB.CommentDialogView._otherReviewsText,loginText:interpolate(RB.CommentDialogView._loginTextTemplate,[userSession.get("loginURL")]),draftWarning:interpolate(RB.CommentDialogView._draftWarningTextTemplate,[reviewRequest.get("reviewURL")]),openAnIssueText:RB.CommentDialogView._openAnIssueText,enableMarkdownText:RB.CommentDialogView._enableMarkdownText,saveButton:RB.CommentDialogView._saveText,cancelButton:RB.CommentDialogView._cancelText,deleteButton:RB.CommentDialogView._deleteText,closeButton:RB.CommentDialogView._closeText,showVerify:RB.EnabledFeatures.issueVerification,verifyIssueText:RB.CommentDialogView._verifyIssueText}));this._$commentsPane=this.$(".other-comments");this._$draftForm=this.$("form");this._$body=this._$draftForm.children(".comment-dlg-body");this._$header=this._$draftForm.children(".comment-dlg-header");this._$footer=this._$draftForm.children(".comment-dlg-footer");this._$title=this._$header.children(".title");this._$commentOptions=this._$body.children(".comment-dlg-options");this._$issueOptions=this._$commentOptions.children(".comment-issue-options").bindVisibility(this.model,"canEdit");this._$markdownOptions=this._$commentOptions.children(".comment-markdown-options").bindVisibility(this.model,"canEdit");this._$issueField=this._$issueOptions.find("#comment_issue").bindProperty("checked",this.model,"openIssue").bindProperty("disabled",this.model,"editing",{elementToModel:false,inverse:true});this._$issueVerificationField=this._$issueOptions.find("#comment_issue_verify").bindProperty("checked",this.model,"requireVerification").bindProperty("disabled",this.model,"editing",{elementToModel:false,inverse:true});this._$enableMarkdownField=this._$markdownOptions.find("#enable_markdown").bindProperty("checked",this.model,"richText").bindProperty("disabled",this.model,"editing",{elementToModel:false,inverse:true});this.$buttons=this._$footer.find(".buttons");this.$saveButton=this.$buttons.find("input.save").bindVisibility(this.model,"canEdit").bindProperty("disabled",this.model,"canSave",{elementToModel:false,inverse:true});this.$cancelButton=this.$buttons.find("input.cancel").bindVisibility(this.model,"canEdit");this.$deleteButton=this.$buttons.find("input.delete").bindVisibility(this.model,"canDelete").bindProperty("disabled",this.model,"canDelete",{elementToModel:false,inverse:true});this.$closeButton=this.$buttons.find("input.close").bindVisibility(this.model,"canEdit",{inverse:true});this.commentsList=new CommentsListView({el:this._$commentsPane.find("ul"),reviewRequestURL:reviewRequest.get("reviewURL"),commentIssueManager:this.options.commentIssueManager,issuesInteractive:reviewRequestEditor.get("editable")});this._textEditor=new RB.TextEditorView({el:this._$draftForm.find(".comment-text-field"),autoSize:false,minHeight:0,text:this.model.get("text"),bindRichText:{model:this.model,attrName:"richText"}});this._textEditor.render();this._textEditor.show();this._textEditor.$el.bindVisibility(this.model,"canEdit");this.listenTo(this._textEditor,"change",function(){return _this2.model.set("text",_this2._textEditor.getText())});this._textEditor.bindRichTextCheckbox(this._$enableMarkdownField);this._textEditor.bindRichTextVisibility(this._$draftForm.find(".markdown-info"));this.listenTo(this.model,"change:text",function(){return _this2._textEditor.setText(_this2.model.get("text"))});this.listenTo(this.model,"change:richText",this._handleResize);this.$el.css("position","absolute").mousedown(function(evt){evt.stopPropagation()}).resizable({handles:$.support.touch?"grip,se":"grip,n,e,s,w,se,sw,ne,nw",transparent:true,resize:_.bind(this._handleResize,this)}).proxyTouchEvents();this._$header.css("cursor","move");this.$el.draggable({handle:".comment-dlg-header"});this.listenTo(this.model,"change:dirty",this._updateTitle);this._updateTitle();this.listenTo(this.model,"change:publishedComments",function(){return _this2._onPublishedCommentsChanged()});this._onPublishedCommentsChanged();RB.CommentDialogHook.each(function(hook){var HookViewType=hook.get("viewType");var hookView=new HookViewType({extension:hook.get("extension"),commentDialog:_this2,commentEditor:_this2.model,el:_this2.el});hookView.render()});return this},save:function save(){this.model.set("text",this._textEditor.getText());if(this.model.get("canSave")){this.model.save({error:function error(model,xhr){alert(gettext("Error saving comment: ")+xhr.errorText)}});this.close()}},open:function open(){function openDialog(){this.$el.scrollIntoView();this._textEditor.focus()}this.$el.css({top:parseInt(this.$el.css("top"),10)-this.SLIDE_DISTANCE,opacity:0}).show();this._handleResize();if(this.model.get("canEdit")){this.model.beginEdit()}if(this.options.animate){this.$el.animate({top:"+="+this.SLIDE_DISTANCE+"px",opacity:1},350,"swing",_.bind(openDialog,this))}else{openDialog.call(this)}},close:function close(){var onClosed=arguments.length>0&&arguments[0]!==undefined?arguments[0]:undefined;var context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};function closeDialog(){this.model.close();this.$el.remove();this.trigger("closed");if(_.isFunction(onClosed)){onClosed.call(context)}}if(this.options.animate&&this.$el.is(":visible")){this.$el.animate({top:"-="+this.SLIDE_DISTANCE+"px",opacity:0},350,"swing",_.bind(closeDialog,this))}else{closeDialog.call(this)}},move:function move(x,y){this.$el.move(x,y)},positionBeside:function positionBeside($el,options){this.$el.positionToSide($el,options)},_updateTitle:function _updateTitle(){this._$title.text(this.model.get("dirty")?RB.CommentDialogView._yourCommentDirtyText:RB.CommentDialogView._yourCommentText)},_onPublishedCommentsChanged:function _onPublishedCommentsChanged(){var comments=this.model.get("publishedComments")||[];this.commentsList.setComments(comments,this.model.get("publishedCommentsType"));var showComments=comments.length>0;this._$commentsPane.setVisible(showComments);var width=this.FORM_BOX_WIDTH;if(showComments){width+=this.COMMENTS_BOX_WIDTH}this.$el.width(width).height(this.model.get("canEdit")?this.DIALOG_TOTAL_HEIGHT:this.DIALOG_NON_EDITABLE_HEIGHT)},_handleResize:function _handleResize(){var height=this.$el.height();var width=this.$el.width();var commentsWidth=0;if(this._$commentsPane.is(":visible")){this._$commentsPane.outerWidth(this.COMMENTS_BOX_WIDTH).outerHeight(height).move(0,0,"absolute");var $commentsList=this.commentsList.$el;$commentsList.height(this._$commentsPane.height()-$commentsList.position().top);commentsWidth=this._$commentsPane.outerWidth(true);width-=commentsWidth}this._$draftForm.outerWidth(width).outerHeight(height).move(commentsWidth,0,"absolute");var $textField=this._textEditor.$el;this._textEditor.setSize(this._$body.width()-$textField.getExtents("b","lr"),this._$draftForm.height()-this._$header.outerHeight()-this._$commentOptions.outerHeight()-this._$footer.outerHeight()-$textField.getExtents("b","tb"))},_onCancelClicked:function _onCancelClicked(){var shouldExit=true;if(this.model.get("dirty")){shouldExit=confirm(RB.CommentDialogView._shouldExitText)}if(shouldExit){this.model.cancel();this.close()}},_onDeleteClicked:function _onDeleteClicked(){if(this.model.get("canDelete")){this.model.deleteComment();this.close()}},_onTextKeyDown:function _onTextKeyDown(e){e.stopPropagation();switch(e.which){case $.ui.keyCode.ESCAPE:this._onCancelClicked();return false;case 10:case $.ui.keyCode.ENTER:if(e.metaKey||e.ctrlKey){this.save();e.preventDefault();e.stopPropagation()}break;case 73:case 105:if(e.metaKey||e.altKey){e.preventDefault();this.model.set("openIssue",!this.model.get("openIssue"))}break;case 77:case 109:if(e.metaKey||e.altKey){e.preventDefault();this.model.set("richText",!this.model.get("richText"))}break;default:break}}},{_instance:null,create:function create(){var options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};console.assert(options.comment,"A comment must be specified")
;var reviewRequestEditor=options.reviewRequestEditor||RB.PageManager.getPage().model.reviewRequestEditor;var dlg=new RB.CommentDialogView({animate:options.animate,commentIssueManager:options.commentIssueManager||reviewRequestEditor.get("commentIssueManager"),model:new RB.CommentEditor({comment:options.comment,reviewRequest:reviewRequestEditor.get("reviewRequest"),reviewRequestEditor:reviewRequestEditor,publishedComments:options.publishedComments||undefined,publishedCommentsType:options.publishedCommentsType||undefined})});dlg.render().$el.css("z-index",999).appendTo(options.container||document.body);options.position=options.position||{};if(_.isFunction(options.position)){options.position(dlg)}else if(options.position.beside){dlg.positionBeside(options.position.beside.el,options.position.beside)}else{var x=options.position.x;var y=options.position.y;if(x===undefined){x=$(document).scrollLeft()+($(window).width()-dlg.$el.width())/2}if(y===undefined){y=$(document).scrollTop()+($(window).height()-dlg.$el.height())/2}dlg.move(x,y)}dlg.on("closed",function(){return RB.CommentDialogView._instance=null});var instance=RB.CommentDialogView._instance;var showCommentDlg=function showCommentDlg(){try{dlg.open()}catch(e){dlg.close();throw e}RB.CommentDialogView._instance=dlg};if(instance){instance.on("closed",showCommentDlg);instance.close()}else{showCommentDlg()}return dlg},_cancelText:gettext("Cancel"),_closeText:gettext("Close"),_deleteText:gettext("Delete"),_draftWarningTextTemplate:gettext('The review request\'s current <a href="%s">draft</a> needs to be published before you can comment.'),_enableMarkdownText:gettext("Enable <u>M</u>arkdown"),_loginTextTemplate:gettext('You must <a href="%s">log in</a> to post a comment.'),_markdownText:gettext("Markdown"),_openAnIssueText:gettext("Open an <u>I</u>ssue"),_otherReviewsText:gettext("Other reviews"),_saveText:gettext("Save"),_shouldExitText:gettext("You have unsaved changes. Are you sure you want to exit?"),_verifyIssueText:gettext("Require Verification"),_yourCommentText:gettext("Your comment"),_yourCommentDirtyText:gettext("Your comment (unsaved)")})})();"use strict";RB.CommentIssueBarView=Backbone.View.extend({events:{"click .reopen":"_onReopenClicked","click .resolve":"_onFixedClicked","click .drop":"_onDropClicked","click .verify-dropped":"_onVerifyDroppedClicked","click .verify-resolved":"_onVerifyFixedClicked"},statusInfo:{open:{visibleButtons:[".drop",".resolve"],text:gettext("An issue was opened.")},resolved:{visibleButtons:[".reopen"],text:gettext("The issue has been resolved.")},dropped:{visibleButtons:[".reopen"],text:gettext("The issue has been dropped.")},"verifying-dropped":{visibleButtons:[".reopen"],text:gettext("Waiting for verification before dropping...")},"verifying-resolved":{visibleButtons:[".reopen"],text:gettext("Waiting for verification before resolving...")}},template:_.template('<div class="issue-state">\n <div class="issue-container">\n  <span class="rb-icon"></span>\n  <span class="issue-details">\n   <span class="issue-message"></span>\n   <% if (interactive) { %>\n    <span class="issue-actions">\n     <input type="button" class="issue-button resolve"\n            value="<%- fixedLabel %>">\n     <input type="button" class="issue-button drop"\n            value="<%- dropLabel %>">\n     <input type="button" class="issue-button reopen"\n            value="<%- reopenLabel %>">\n     <input type="button" class="issue-button verify-resolved"\n            value="<%- verifyFixedLabel %>">\n     <input type="button" class="issue-button verify-dropped"\n            value="<%- verifyDroppedLabel %>">\n    </span>\n   <% } %>\n  </span>\n </div>\n</div>'),initialize:function initialize(){var page=RB.PageManager.getPage();this._manager=this.options.commentIssueManager||page.model.commentIssueManager;this._issueStatus=this.options.issueStatus;this._$buttons=null;this._$state=null;this._$icon=null;this._$message=null},render:function render(){if(this.$el.children().length===0){this.$el.append(this.template({interactive:this.options.interactive,fixedLabel:gettext("Fixed"),dropLabel:gettext("Drop"),reopenLabel:gettext("Re-open"),verifyDroppedLabel:gettext("Verify Dropped"),verifyFixedLabel:gettext("Verify Fixed")}))}this._$buttons=this.$(".issue-button");this._$state=this.$(".issue-state");this._$icon=this.$(".rb-icon");this._$message=this.$(".issue-message");this._manager.on("issueStatusUpdated",this._onIssueStatusUpdated,this);this._showStatus(this._issueStatus);return this},_setStatus:function _setStatus(issueStatus){this._$buttons.prop("disabled",true);this._manager.setCommentState(this.options.reviewID,this.options.commentID,this.options.commentType,issueStatus)},_showStatus:function _showStatus(issueStatus){var statusInfo=this.statusInfo[issueStatus];var prevStatus=this._issueStatus;this._issueStatus=issueStatus;this._$state.removeClass(prevStatus).addClass(issueStatus);var iconClass=void 0;if(issueStatus===RB.BaseComment.STATE_VERIFYING_DROPPED||issueStatus===RB.BaseComment.STATE_VERIFYING_RESOLVED){iconClass="rb-icon rb-icon-issue-verifying"}else{iconClass="rb-icon rb-icon-issue-"+issueStatus}this._$icon.attr("class",iconClass);this._$buttons.hide();this._$message.text(statusInfo.text);if(this.options.interactive){var visibleButtons=statusInfo.visibleButtons;if(this.options.canVerify){if(issueStatus===RB.BaseComment.STATE_VERIFYING_DROPPED){visibleButtons.push(".verify-dropped")}else if(issueStatus===RB.BaseComment.STATE_VERIFYING_RESOLVED){visibleButtons.push(".verify-resolved")}}this._$buttons.filter(visibleButtons.join(",")).show();this._$buttons.prop("disabled",false)}this.trigger("statusChanged",prevStatus,issueStatus)},_onReopenClicked:function _onReopenClicked(){this._setStatus(RB.BaseComment.STATE_OPEN)},_onFixedClicked:function _onFixedClicked(){var _this=this;var comment=this._manager.getComment(this.options.reviewID,this.options.commentID,this.options.commentType);comment.ready({ready:function ready(){if(comment.requiresVerification()&&comment.getAuthorUsername()!==RB.UserSession.instance.get("username")){_this._setStatus(RB.BaseComment.STATE_VERIFYING_RESOLVED)}else{_this._setStatus(RB.BaseComment.STATE_RESOLVED)}}})},_onDropClicked:function _onDropClicked(){var _this2=this;var comment=this._manager.getComment(this.options.reviewID,this.options.commentID,this.options.commentType);comment.ready({ready:function ready(){if(comment.requiresVerification()&&comment.getAuthorUsername()!==RB.UserSession.instance.get("username")){_this2._setStatus(RB.BaseComment.STATE_VERIFYING_DROPPED)}else{_this2._setStatus(RB.BaseComment.STATE_DROPPED)}}})},_onVerifyFixedClicked:function _onVerifyFixedClicked(){this._setStatus(RB.BaseComment.STATE_RESOLVED)},_onVerifyDroppedClicked:function _onVerifyDroppedClicked(){this._setStatus(RB.BaseComment.STATE_DROPPED)},_onIssueStatusUpdated:function _onIssueStatusUpdated(comment){if(comment.id===this.options.commentID){this._showStatus(comment.get("issueStatus"))}}});"use strict";RB.DiffFragmentQueueView=Backbone.View.extend({initialize:function initialize(options){this._containerPrefix=options.containerPrefix;this._diffFragmentViewOptions=options.diffFragmentViewOptions;this._fragmentsBasePath=options.reviewRequestPath+"_fragments/diff-comments/";this._queueName=options.queueName;this._queue={};this._saved={}},queueLoad:function queueLoad(commentID,key,onFragmentRendered){var queue=this._queue;if(!queue[key]){queue[key]=[]}queue[key].push({commentID:commentID,onFragmentRendered:onFragmentRendered||null})},saveFragment:function saveFragment(commentID){var $el=this._getCommentContainer(commentID);if($el.length===1&&$el.data("diff-fragment-view")){this._saved[commentID]=$el.html()}},loadFragments:function loadFragments(onDone){var _this=this;if(_.isEmpty(this._queue)&&_.isEmpty(this._saved)){if(_.isFunction(onDone)){onDone()}return}var queueName=this._queueName;_.each(this._queue,function(queuedLoads){$.funcQueue(queueName).add(function(){var pendingCommentIDs=[];var onFragmentRenderedFuncs={};for(var i=0;i<queuedLoads.length;i++){var queuedLoad=queuedLoads[i];var commentID=queuedLoad.commentID;var onFragmentRendered=_.isFunction(queuedLoad.onFragmentRendered)?queuedLoad.onFragmentRendered:null;if(_this._saved.hasOwnProperty(commentID)){var html=_this._saved[commentID];var container=_this._getCommentContainer(commentID);console.assert(container);var view=container.data("diff-fragment-view");if(view){view.$el.html(html);view.render()}else{view=_this._renderFragment(container,commentID,html)}if(onFragmentRendered){onFragmentRendered(view)}delete _this._saved[commentID]}else{pendingCommentIDs.push(commentID);onFragmentRenderedFuncs[commentID]=onFragmentRendered}}if(pendingCommentIDs.length>0){_this._loadDiff(pendingCommentIDs.join(","),{queueName:queueName,onFragmentRendered:function onFragmentRendered(commentID,view){if(onFragmentRenderedFuncs[commentID]){onFragmentRenderedFuncs[commentID](view)}},onDone:function onDone(){return $.funcQueue(queueName).next()}})}else{$.funcQueue(queueName).next()}})});if(_.isFunction(onDone)){$.funcQueue(queueName).add(function(){onDone();$.funcQueue(queueName).next()})}this._queue={};$.funcQueue(queueName).start()},_getCommentContainer:function _getCommentContainer(commentID){return $("#"+this._containerPrefix+"_"+commentID)},_loadDiff:function _loadDiff(commentIDs){var _this2=this;var options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var containerPrefix=this._containerPrefix;var queryArgs=[];var onFragmentRendered=_.isFunction(options.onFragmentRendered)?options.onFragmentRendered:null;if(options.linesOfContext!==undefined){queryArgs.push("lines_of_context="+options.linesOfContext)}if(!containerPrefix.includes("draft")){queryArgs.push("allow_expansion=1")}queryArgs.push(TEMPLATE_SERIAL);RB.apiCall({url:""+this._fragmentsBasePath+commentIDs+"/",data:queryArgs.join("&"),dataType:"arraybuffer",type:"GET",success:function success(arrayBuffer){var dataView=new DataView(arrayBuffer);var len=dataView.byteLength;var pos=0;var totalFragments=0;var totalRenders=0;var done=false;var onFragmentLoaded=function onFragmentLoaded(commentID,html){var containerID="#"+containerPrefix+"_"+commentID;var $container=$(containerID);if($container.length===0){console.error("Unable to find container %s for "+"comment ID %s. There may be missing "+"state in the database.",containerID,commentID)}else{var view=_this2._renderFragment($("#"+containerPrefix+"_"+commentID),commentID,html);if(onFragmentRendered){onFragmentRendered(commentID,view)}}totalRenders++;if(done&&totalRenders===totalFragments&&_.isFunction(options.onDone)){options.onDone()}};while(!done){var parsed=_this2._parseDiffFragmentFromPayload(arrayBuffer,dataView,pos);totalFragments++;pos=parsed.pos;done=pos>=len;parsed.load(onFragmentLoaded)}}})},_parseDiffFragmentFromPayload:function _parseDiffFragmentFromPayload(arrayBuffer,dataView,pos){var commentID=dataView.getUint32(pos,true);pos+=4;var htmlLen=dataView.getUint32(pos,true);pos+=4;var htmlStart=pos;pos+=htmlLen;return{pos:pos,load:function load(cb){RB.DataUtils.readBlobAsString(new Blob([arrayBuffer.slice(htmlStart,htmlStart+htmlLen)]),function(html){return cb(commentID,html)})}}},_renderFragment:function _renderFragment($container,commentID,html){var _this3=this;RB.scrollManager.markForUpdate($container);$container.html(html);var view=$container.data("diff-fragment-view");if(!view){view=new RB.DiffFragmentView(_.defaults({el:$container,loadDiff:function loadDiff(options){RB.setActivityIndicator(true,{type:"GET"});_this3._loadDiff(commentID,_.defaults({onDone:function onDone(){RB.setActivityIndicator(false,{});if(options.onDone){options.onDone()}}},options))}},this._diffFragmentViewOptions));$container.data("diff-fragment-view",view)}view.render();RB.scrollManager.markUpdated($container);return view}});"use strict";RB.DiffFragmentView=Backbone.View.extend({events:{"click .diff-expand-btn":"_onExpandButtonClicked","click .diff-collapse-btn":"_onCollapseButtonClicked",mouseenter:"_tryShowControlsDelayed",mouseleave:"_tryHideControlsDelayed"},COLLAPSED_HEADERS_HEIGHT:4,_controlsHoverTimeout:250,initialize:function initialize(){var options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};this._loadDiff=options.loadDiff;this._collapsible=!!options.collapsible;this._$table=null;this._$thead=null;this._$diffHeaders=null;this._$controls=null;this._centeredMgr=null;this._contextExpanded=false},render:function render(){var _this=this;this.$el.removeClass("allow-transitions");this._$table=this.$el.children("table");this._$diffHeaders=this._$table.find(".diff-header");this._$thead=this._$table.children("thead");this._$controls=this._$diffHeaders.find("td > div");if(this._collapsible&&this.$el.is(":visible")){this.hideControls()}else{this.showControls()}if(this._collapsible){_.defer(function(){return _this.$el.addClass("allow-transitions")})}return this},showControls:function showControls(){this._$table.removeClass("collapsed").addClass("expanded");this._$thead.css("transform","");this._$diffHeaders.css("transform","")},hideControls:function hideControls(animate){var _this2=this;if(this._contextExpanded){return}if(animate===false){this.$el.removeClass("allow-transitions")}this._$table.removeClass("expanded").addClass("collapsed");var $firstDiffHeader=this._$diffHeaders.eq(0);if($firstDiffHeader.hasClass("diff-header-above")){var translateY=$firstDiffHeader.height()-this.COLLAPSED_HEADERS_HEIGHT;this._$thead.css("transform","translateY("+translateY+"px)")}_.each(this._$diffHeaders,function(diffHeaderEl){var $diffHeader=$(diffHeaderEl);var scale=_this2.COLLAPSED_HEADERS_HEIGHT/$diffHeader.height();$diffHeader.css("transform","scaleY("+scale+")")});if(animate===false){_.defer(function(){return _this2.$el.addClass("allow-transitions")})}},_expandOrCollapse:function _expandOrCollapse($btn){this._loadDiff({linesOfContext:$btn.data("lines-of-context"),onDone:this._onExpandOrCollapseFinished.bind(this)})},_tryShowControlsDelayed:function _tryShowControlsDelayed(){var _this3=this;if(this._collapsible){_.delay(function(){if(_this3.$el.is(":hover")){_this3.showControls()}},this._controlsHoverTimeout)}},_tryHideControlsDelayed:function _tryHideControlsDelayed(){var _this4=this;if(this._collapsible){_.delay(function(){if(!_this4.$el.is(":hover")){_this4.hideControls()}},this._controlsHoverTimeout)}},_onExpandOrCollapseFinished:function _onExpandOrCollapseFinished(){RB.setActivityIndicator(false,{});if(this._centeredMgr!==null){this._centeredMgr.remove();this._centeredMgr=null}var $collapseButtons=this.$(".diff-collapse-btn");if($collapseButtons.length>0){this._centeredMgr=new RB.CenteredElementManager({elements:new Map(Array.prototype.map.call($collapseButtons,function(el){var $chunks=$(el).closest(".sidebyside").children("tbody").not(".diff-header");return[el,{$top:$chunks.eq(0),$bottom:$chunks.eq(-1)}]}))});this._centeredMgr.updatePosition();this._contextExpanded=true}else{this._contextExpanded=false}this.render();if(!this._contextExpanded){this._tryHideControlsDelayed()}},_onExpandButtonClicked:function _onExpandButtonClicked(e){e.preventDefault();e.stopPropagation();this._expandOrCollapse($(e.target).closest(".diff-expand-btn"),e)},_onCollapseButtonClicked:function _onCollapseButtonClicked(e){e.preventDefault();e.stopPropagation();this._expandOrCollapse($(e.target).closest(".diff-collapse-btn"),e)}});"use strict";(function(){var DnDDropTarget=Backbone.Model.extend({defaults:function defaults(){return{$target:$(window),callback:function callback(){},dropText:gettext("Drop to upload")}}});var DnDDropOverlayView=Backbone.View.extend({className:"dnd-overlay",events:{dragenter:"_onDragEnter",dragover:"_onDragOver",dragleave:"_onDragLeave",drop:"_onDrop"},render:function render(){this.$el.text(this.model.get("dropText"));return this},show:function show(){var _this=this;var $target=this.model.get("$target");$target.addClass("dnd-overlay-visible");_.defer(function(){var offset=$target.offset();var width=$target.outerWidth()+"px";var height=$target.outerHeight()+"px";_this.$el.css({width:width,height:height,"line-height":height,left:offset.left+"px",top:offset.top+"px"}).show()})},hide:function hide(){this.model.get("$target").removeClass("dnd-overlay-visible");this.$el.hide()},close:function close(){var _this2=this;this.$el.fadeOut(function(){_this2.trigger("closed");_this2.remove()})},_onDrop:function _onDrop(e){e.stopPropagation();e.preventDefault();var dt=e.originalEvent.dataTransfer;var files=dt&&dt.files;if(files){var callback=this.model.get("callback");var _iteratorNormalCompletion=true;var _didIteratorError=false;var _iteratorError=undefined;try{for(var _iterator=Array.from(files)[Symbol.iterator](),_step;!(_iteratorNormalCompletion=(_step=_iterator.next()).done);_iteratorNormalCompletion=true){var file=_step.value;callback(file)}}catch(err){_didIteratorError=true;_iteratorError=err}finally{try{if(!_iteratorNormalCompletion&&_iterator.return){_iterator.return()}}finally{if(_didIteratorError){throw _iteratorError}}}}this.trigger("closing")},_onDragEnter:function _onDragEnter(e){e.preventDefault();var dt=e.originalEvent.dataTransfer;if(dt){dt.dropEffect="copy";this.$el.addClass("dnd-overlay-highlight")}},_onDragOver:function _onDragOver(e){e.preventDefault()},_onDragLeave:function _onDragLeave(e){e.preventDefault();var dt=e.originalEvent.dataTransfer;if(dt){dt.dropEffect="none";this.$el.removeClass("dnd-overlay-highlight")}}});RB.DnDUploader=Backbone.View.extend({initialize:function initialize(){this._dropTargets=new Backbone.Collection({model:DnDDropTarget});this._dropOverlays=[];this._hideOverlayTimeout=null;this._overlaysVisible=false;this._overlaysHiding=false;_.bindAll(this,"_showOverlays","_hideOverlays");$(window).on("dragstart dragenter dragover",this._showOverlays).on("dragend dragleave",this._hideOverlays)},registerDropTarget:function registerDropTarget($target,dropText,callback){if(this._dropTargets.findWhere({$target:$target})===undefined){var target=new DnDDropTarget({$target:$target,dropText:dropText,callback:callback});this._dropTargets.add(target);var overlay=new DnDDropOverlayView({model:target});overlay.render().$el.hide().appendTo(document.body);this.listenTo(overlay,"closing",this._hideOverlays);this._dropOverlays.push(overlay)}else{console.error("Drop target was already registered!",$target)}},unregisterDropTarget:function unregisterDropTarget($target){var target=this._dropTargets.findWhere({$target:$target});var overlayIx=this._dropOverlays.findIndex(function(overlay){return overlay.model===target});if(overlayIx!==-1){this._dropOverlays[overlayIx].remove();this._dropOverlays.splice(overlayIx,1)}if(target!==undefined){this._dropTargets.remove(target)}},_showOverlays:function _showOverlays(e){if(e.originalEvent.dataTransfer!==undefined&&Array.from(e.originalEvent.dataTransfer.types).includes("Files")){this._overlaysHiding=false;if(!this._overlaysVisible){this._overlaysVisible=true;this._dropOverlays.forEach(function(overlay){return overlay.show()})}}},_hideOverlays:function _hideOverlays(){var _this3=this;if(this._hideOverlayTimeout){clearTimeout(this._hideOverlayTimeout)}this._overlaysHiding=true;this._hideOverlayTimeout=setTimeout(function(){if(_this3._overlaysHiding){_this3._overlaysVisible=false;_this3._dropOverlays.forEach(function(overlay){return overlay.hide()})}},200)}},{instance:null,create:function create(){console.assert(RB.DnDUploader.instance===null,"DnDUploader.create may only be called once");RB.DnDUploader.instance=new RB.DnDUploader;return RB.DnDUploader.instance}})})();"use strict";RB.DraftReviewBannerView=Backbone.View.extend({events:{"click #review-banner-edit":"_onEditReviewClicked","click #review-banner-discard":"_onDiscardClicked"},render:function render(){var _this=this;this._$buttons=this.$("input");this._$banner=this.$(".banner");var model=this.model;this.listenTo(model,"saving destroying",function(){return _this._$buttons.prop("disabled",true)});this.listenTo(model,"saved destroyed",function(){return _this._$buttons.prop("disabled",false)});this.listenTo(model,"publishError",function(errorText){return alert(errorText)});this._publishButton=new RB.SplitButtonView({el:$("#review-banner-publish-container"),text:gettext("Publish Review"),click:_.bind(this._onPublishClicked,this),id:"review-banner-publish",alternatives:[{text:gettext("... and only e-mail the owner"),click:function click(){return _this._onPublishClicked({publishToOwnerOnly:true})},id:"review-banner-publish-submitter-only"}]});this._publishButton.render();if(!this.$el.hasClass("hidden")){this.show()}this.$el.addClass("ui-ready");return this},show:function show(){var height=this._$banner.outerHeight();RB.scrollManager.markForUpdate(this.$el);this.$el.removeClass("hidden").css({maxHeight:height,height:height});RB.scrollManager.scrollYOffset+=height;RB.scrollManager.markUpdated(this.$el)},hide:function hide(){var _this2=this;RB.scrollManager.markForUpdate(this.$el);var height=this._$banner.outerHeight();this.$el.addClass("hidden").css("max-height","");_.delay(function(){_this2.$el.css("height","");RB.scrollManager.markUpdated(_this2.$el);RB.scrollManager.scrollYOffset-=height},500)},hideAndReload:function hideAndReload(){var _this3=this;this.hide();_.defer(function(){window.location=_this3.model.get("parentObject").get("reviewURL")})},getHeight:function getHeight(){return this._$banner.outerHeight()},remove:function remove(){if(this._publishButton){this._publishButton.remove()}_super(this).remove.call(this)},_onEditReviewClicked:function _onEditReviewClicked(){RB.ReviewDialogView.create({review:this.model,reviewRequestEditor:this.options.reviewRequestEditor});return false},_onPublishClicked:function _onPublishClicked(){var options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};if(options.publishToOwnerOnly){this.model.set("publishToOwnerOnly",true)}this.model.publish({attrs:["public","publishToOwnerOnly"]});return false},_onDiscardClicked:function _onDiscardClicked(){var _this4=this;$("<p/>").text(gettext("If you discard this review, all related comments will be permanently deleted.")).modalBox({title:gettext("Are you sure you want to discard this review?"),buttons:[$('<input type="button">').val(gettext("Cancel")),$('<input type="button">').val(gettext("Discard")).click(function(){return _this4.model.destroy()})]});return false}},{instance:null,create:function create(options){if(!this.instance){this.instance=new RB.DraftReviewBannerView(options);this.instance.render()}return this.instance}});RB.UploadAttachmentView=Backbone.View.extend({className:"upload-attachment",template:_.template(['<div class="formdlg" style="width: 50em;">',' <div class="error" style="display: none;"></div>',' <form encoding="multipart/form-data" enctype="multipart/form-data"','       id="attachment-upload-form">',"  <table>","   <tbody>","    <tr>",'     <td class="label"><label><%- captionText %></label></td>','     <td><input name="caption" type="text" value="<%- presetCaption %>"></td>','     <td><ul class="errorlist" style="display: none;"></ul></td>',"    </tr>","    <tr>",'     <td class="label">','      <label class="required"><%- pathText %></label>',"     </td>",'     <td><input name="path" id="path" type="file"></td>','     <td><ul class="errorlist" style="display: none;"></ul></td>',"    </tr>","   </tbody>","  </table>","  <% if (attachmentHistoryID >= 0) { %>",'    <input type="hidden" name="attachment_history"','           value="<%- attachmentHistoryID %>" />',"  <% } %>"," </form>","</div>"].join("")),events:{"change #path":"updateUploadButtonEnabledState"},initialize:function(options){this.options=$.extend({attachmentHistoryID:-1,presetCaption:""},options)},send:function(){this.options.reviewRequest.createFileAttachment().save({form:this.$("#attachment-upload-form"),success:function(){window.location.reload()},error:function(model,xhr){this.displayErrors($.parseJSON(xhr.responseText))}},this)},displayErrors:function(rsp){var errorStr=rsp&&rsp.err?rsp.err.msg:gettext("Unknown Error"),fieldName,$errorList,i,nameToRow={caption:0,path:1};this.$(".error").text(errorStr).show();if(rsp&&rsp.fields){for(fieldName in rsp.fields){if(rsp.fields.hasOwnProperty(fieldName)){$errorList=this.$(".errorlist").css("display","block")[nameToRow[fieldName]];for(i=0;i<rsp.fields[fieldName].length;i++){$("<li/>").html(rsp.fields[fieldName][i]).appendTo($errorList)}}}}},render:function(){var self=this;this.$el.append(this.template({attachmentHistoryID:this.options.attachmentHistoryID,captionText:gettext("Caption:"),pathText:gettext("Path:"),presetCaption:this.options.presetCaption})).modalBox({title:gettext("Upload File"),buttons:[$('<input type="button"/>').val(gettext("Cancel")),$('<input id="upload" type="button" disabled/>').val(gettext("Upload")).click(function(){self.send();return false})]});this._$path=$("#path");this._$uploadBtn=$("#upload");return this},updateUploadButtonEnabledState:function(){this._$uploadBtn.enable(this._$path.val())}});RB.RevisionSelectorView=Backbone.View.extend({template:_.template(['<div class="revision-selector">',' <div class="revision-selector-trough" />',' <div class="revision-selector-range" />',' <div class="revision-selector-ticks" />',' <div class="revision-selector-labels" />',' <div class="revision-selector-handles" />',"</div>"].join("")),events:{"mousedown .revision-selector-handle":"_onHandleMouseDown","mousedown .revision-selector-label":"_onLabelMouseDown","click .revision-selector-label":"_onLabelClick"},initialize:function(options){console.assert(_.isObject(options));console.assert(options.numHandles===1||options.numHandles===2);this._activeHandle=null;this._firstLabelActive=options.firstLabelActive;this._mouseActive=false;this._numHandles=options.numHandles;this._values=[];this._rendered=false;this.listenTo(this.model,"change",this._update);_.bindAll(this,"_onHandleMouseUp","_onHandleMouseMove")},render:function(revisionLabels){var i;this.$el.html(this.template());this._positions=[];for(i=0;i<revisionLabels.length;i++){this._positions.push(i*30)}this._$handles=this.$(".revision-selector-handles");this._$range=this.$(".revision-selector-range");this._$ticks=this.$(".revision-selector-ticks");this._$labels=this.$(".revision-selector-labels");this._$trough=this.$(".revision-selector-trough").width(this._positions[i-1]);_.each(revisionLabels,function(label,i){var $label;$("<div/>").addClass("revision-selector-tick").css("left",this._positions[i]+"px").appendTo(this._$ticks);$label=$("<div/>").text(label).addClass("revision-selector-label").appendTo(this._$labels);$label.css("left",this._positions[i]-$label.width()/2+"px");if(this._firstLabelActive||i>0){$label.data("revision",i).addClass("revision-selector-label-active")}},this);for(i=0;i<this._numHandles;i++){$("<div/>").addClass("revision-selector-handle rb-icon rb-icon-range-slider").data("handle-id",i).appendTo(this._$handles)}this._rendered=true;this._update();return this},_updateHandles:function(){var positions=this._positions,values;if(this._mouseActive){values=this._activeValues}else{values=this._values}this._$handles.children().each(function(i){$(this).css("left",positions[values[i]]-4+"px")});if(this._numHandles===2){this._$range.css({left:positions[values[0]]+"px",width:positions[values[1]-values[0]]+"px"})}},_onHandleMouseDown:function(ev){var $target=$(ev.currentTarget),i;this._activeValues=[];for(i=0;i<this._values.length;i++){this._activeValues.push(i)}this._mouseActive=true;this._activeHandle=$target.data("handle-id");document.addEventListener("mouseup",this._onHandleMouseUp,true);document.addEventListener("mousemove",this._onHandleMouseMove,true);$("body").addClass("revision-selector-grabbed");ev.preventDefault();return false},_onHandleMouseUp:function(ev){console.assert(this._mouseActive);this._mouseActive=false;this._activeHandle=null;document.removeEventListener("mouseup",this._onHandleMouseUp,true);document.removeEventListener("mousemove",this._onHandleMouseMove,true);$("body").removeClass("revision-selector-grabbed");if(!_.isEqual(this._activeValues,this._values)){this.trigger("revisionSelected",this._activeValues)}ev.stopPropagation();ev.preventDefault()},_onHandleMouseMove:function(ev){var positions=this._positions,positionsLen=positions.length,mouseX,i,closestPos,closestDist,dist;console.assert(this._mouseActive);mouseX=window.pageXOffset+ev.clientX-this._$trough.offset().left;for(i=0;i<positionsLen;i++){dist=Math.abs(positions[i]-mouseX);if(closestDist===undefined||dist<closestDist){closestDist=dist;closestPos=i}}if(this._numHandles===1){this._activeValues[0]=closestPos}else if(this._numHandles===2){if(this._activeHandle===0){this._activeValues[0]=Math.min(closestPos,positionsLen-2);if(this._values[1]<=this._activeValues[0]){this._activeValues[1]=this._activeValues[0]+1}else{this._activeValues[1]=this._values[1]}}else if(this._activeHandle===1){this._activeValues[1]=Math.max(closestPos,1);if(this._values[0]>=this._activeValues[1]){this._activeValues[0]=this._activeValues[1]-1}else{this._activeValues[0]=this._values[0]}}}this._updateHandles()}});"use strict";RB.FileAttachmentReviewableView=RB.AbstractReviewableView.extend({commentsListName:"file_attachment_comments"});"use strict";RB.FileAttachmentRevisionLabelView=Backbone.View.extend({events:{"click .select-latest":"_onSelectLatest","click .select-changed":"_onSelectChanged"},template:_.template("<p><%- header %></p>\n<% if (detail) { %><p><%= detail %></p><% } %>"),_interdiffTemplate:_.template(gettext("This file attachment has multiple revisions. Showing changes between revision <%- diffAgainstRevision %> and <%- revision %>.")),_latestTemplate:_.template(gettext("This file attachment has multiple revisions. Showing revision <%- revision %> (latest).")),_oldHeaderTemplate:_.template(gettext("This file attachment has multiple revisions. Showing revision <%- revision %>.")),_oldDetailTemplate:_.template(gettext('This is not the most recent revision of the file. The <a href="#" class="select-latest">latest version</a> is revision <%- latestRevision %>. <a href="#" class="select-changed">See what\'s changed.</a>')),initialize:function initialize(){this.listenTo(this.model,"change",this.render)},render:function render(){var revision=this.model.get("fileRevision");var diffAgainstRevision=this.model.get("diffRevision");var latestRevision=this.model.get("numRevisions");var header="";var detail=null;if(diffAgainstRevision){header=this._interdiffTemplate({revision:revision,diffAgainstRevision:diffAgainstRevision})}else if(revision===latestRevision){header=this._latestTemplate({revision:revision})}else{header=this._oldHeaderTemplate({revision:revision});detail=this._oldDetailTemplate({revision:revision,latestRevision:latestRevision})}this.$el.html(this.template({header:header,detail:detail}));return this},_onSelectLatest:function _onSelectLatest(ev){ev.stopPropagation();ev.preventDefault();this.trigger("revisionSelected",[0,this.model.get("numRevisions")])},_onSelectChanged:function _onSelectChanged(ev){ev.stopPropagation();ev.preventDefault();this.trigger("revisionSelected",[this.model.get("fileRevision"),this.model.get("numRevisions")])}});RB.FileAttachmentRevisionSelectorView=RB.RevisionSelectorView.extend({initialize:function(){_super(this).initialize.call(this,{firstLabelActive:true,numHandles:2})},render:function(){var numRevisions=this.model.get("numRevisions"),labels=[gettext("No Diff")],i;for(i=1;i<=numRevisions;i++){labels.push(i.toString())}return _super(this).render.call(this,labels,true)},_update:function(){var revision=this.model.get("fileRevision"),diffRevision=this.model.get("diffRevision");if(diffRevision){this._values=[revision,diffRevision]}else{this._values=[0,revision]}if(this._rendered){this._updateHandles()}},_onLabelClick:function(ev){var $target=$(ev.currentTarget);this.trigger("revisionSelected",[0,$target.data("revision")])}});RB.FileAttachmentThumbnail=Backbone.View.extend({
className:"file-container",events:{"click .file-delete":"_onDeleteClicked","click .file-add-comment a":"_onAddCommentClicked","click .file-update a":"_onUpdateClicked"},template:_.template(['<div class="file">',' <div class="file-actions-container">','  <ul class="file-actions"></ul>'," </div>",' <div class="file-thumbnail-container"></div>',' <div class="file-caption-container">','<div class="file-caption can-edit">','<a href="<%- downloadURL %>" class="<%- captionClass %>">',"<%- caption %>","</a>","</div>"," </div>","</div>"].join("")),actionsTemplate:_.template(["<% if (loaded) { %>","<%  if (reviewURL) { %>",'<li><a class="file-review" href="<%- reviewURL %>">','<span class="fa fa-comment-o"></span> <%- reviewText %></a>',"</li>","<%  } else { %>",'<li class="file-add-comment">','<a href="#"><span class="fa fa-comment-o"></span> <%- commentText %></a>',"</li>","<%  } %>",'<li><a class="file-download" href="<%- downloadURL %>">','<span class="fa fa-download"></span> <%- downloadText %>',"</a></li>","<%  if (canEdit) { %>","<%   if (attachmentHistoryID) { %>",'<li class="file-update">','<a href="#" data-attachment-history-id="<%- attachmentHistoryID %>">','<span class="fa fa-upload"></span> <%- updateText %>',"</a></li>","<%   } %>",'<li class="file-delete"><a href="#">','<span class="fa fa-trash-o"></span> <%- deleteText %>',"</a></li>","<%  } %>","<% } %>"].join("")),thumbnailContainerTemplate:_.template(["<% if (!loaded) { %>",'<span class="fa fa-spinner fa-pulse"></span>',"<% } else { %>","<%     if (reviewURL) { %>",'<a href="<%- reviewURL %>" class="file-thumbnail-overlay"></a>',"<%     } %>","<%=  thumbnailHTML %>","<% } %>"].join("")),initialize:function(options){this.options=options;this._draftComment=null;this._comments=[];this._commentsProcessed=false;this._scrollingThumbnail=false},render:function(){var self=this;if(this.options.renderThumbnail){this._renderContents()}this._$captionContainer=this.$(".file-caption");this._$caption=this._$captionContainer.find("a.edit");this.listenTo(this.model,"destroy",function(){this.$el.fadeOut(function(){self.remove()})});this.listenTo(this.model,"change:caption",this._onCaptionChanged);this._onCaptionChanged();this.$el.hover(_.bind(this._onHoverIn,this),_.bind(this._onHoverOut,this));if(this.options.renderThumbnail){this._$actionsContainer=this.$(".file-actions-container");this._$actions=this._$actionsContainer.children(".file-actions");this._$captionContainer=this.$(".file-caption-container");this._$thumbnailContainer=this.$(".file-thumbnail-container");this._$file=this.$(".file");this._$actions.find(".file-download").bindProperty("href",this.model,"downloadURL",{elementToModel:false});this._$caption.bindProperty("href",this.model,"downloadURL",{elementToModel:false});this.listenTo(this.model,"change:loaded",this._onLoadedChanged);this._onLoadedChanged();this.listenTo(this.model,"change:thumbnailHTML",this._renderThumbnail);this._renderThumbnail()}if(this.options.canEdit!==false){this._$caption.inlineEditor({editIconClass:"rb-icon rb-icon-edit",showButtons:true}).on({beginEditPreShow:function(){self.$el.addClass("editing");self._stopAnimating()},beginEdit:function(){var $this=$(this);if($this.hasClass("empty-caption")){$this.inlineEditor("field").val("")}self.trigger("beginEdit")},cancel:function(){self.$el.removeClass("editing");self.trigger("endEdit")},complete:function(e,value){self.$el.removeClass("editing");self.model.ready({ready:function(){self.model.set("caption",value);self.trigger("endEdit");self.model.save({attrs:["caption"]})}})}})}return this},fadeIn:function(){this.$el.css("opacity",0).fadeTo(1e3,1)},showCommentDlg:function(){console.assert(!this.model.get("reviewURL"),"showCommentDlg can only be called if the file "+"attachment does not have a review UI");this._processComments();this._createDraftComment();RB.CommentDialogView.create({comment:this._draftComment,publishedComments:this._comments,publishedCommentsType:"file_attachment_comments",position:{beside:{el:this.$el,side:"br",fitOnScreen:true}}})},_processComments:function(){var comments=this.options.comments||[],len=comments.length,comment,i;if(this._commentsProcessed){return}for(i=0;i<len;i++){comment=comments[i];if(comment.localdraft){this._createDraftComment(comment.comment_id,comment.text)}else{this._comments.push(comment)}}this._commentsProcessed=true},_createDraftComment:function(commentID,text){var review;if(this._draftComment!==null){return}review=this.options.reviewRequest.createReview();this._draftComment=review.createFileAttachmentComment(commentID,this.model.id);if(text){this._draftComment.set("text",text)}this._draftComment.on("saved",function(){this.trigger("commentSaved",this._draftComment)},this)},_renderContents:function(){var caption=this.model.get("caption"),captionText=caption?caption:gettext("No caption"),captionClass=caption?"edit":"edit empty-caption";this.$el.html(this.template(_.defaults({caption:captionText,captionClass:captionClass},this.model.attributes))).addClass(this.className)},_renderThumbnail:function(){this._$thumbnailContainer.html(this.thumbnailContainerTemplate(this.model.attributes));Djblets.enableRetinaImages(this._$thumbnailContainer);this._$thumbnailContainer.find("a").each(function(){this.tabIndex=-1})},_onLoadedChanged:function(){this._$actions.html(this.actionsTemplate(_.defaults({canEdit:this.options.canEdit,deleteText:gettext("Delete"),downloadText:gettext("Download"),reviewText:gettext("Review"),commentText:gettext("Comment"),updateText:gettext("Update")},this.model.attributes)))},_onCaptionChanged:function(){var caption=this.model.get("caption");if(caption){this._$caption.text(caption).removeClass("empty-caption")}else{this._$caption.text(gettext("No caption")).addClass("empty-caption")}},_onAddCommentClicked:function(e){e.preventDefault();e.stopPropagation();this.showCommentDlg()},_onUpdateClicked:function(e){var updateDlg;e.preventDefault();e.stopPropagation();updateDlg=new RB.UploadAttachmentView({attachmentHistoryID:$(e.target).data("attachment-history-id"),presetCaption:this.model.get("caption"),reviewRequest:this.options.reviewRequest});updateDlg.render()},_onDeleteClicked:function(e){e.preventDefault();e.stopPropagation();this.model.destroy()},_onHoverIn:function(){var $thumbnail=this.$(".file-thumbnail").children(),actionsWidth=this._$actionsContainer.outerWidth(),actionsRight=this._$file.offset().left+this._$file.outerWidth()+actionsWidth,elHeight,thumbnailHeight,distance,duration;this.trigger("hoverIn",this.$el);if(actionsRight>$(window).width()){this._$actionsContainer.css("left",-actionsWidth).addClass("left")}else{this._$actionsContainer.css("left","100%").addClass("right")}if(!this.$el.hasClass("editing")&&$thumbnail.length===1){elHeight=this.$el.height();thumbnailHeight=$thumbnail.height()||0;if(thumbnailHeight>elHeight){distance=elHeight-thumbnailHeight;duration=Math.abs(distance)/200*1e3;this._scrollingThumbnail=true;$thumbnail.delay(1e3).animate({"margin-top":distance+"px"},{duration:duration,easing:"linear"}).delay(500).animate({"margin-top":0},{duration:duration,easing:"linear",complete:_.bind(function(){this._scrollingThumbnail=false},this)})}}},_onHoverOut:function(){this.trigger("hoverOut");this._$actionsContainer.removeClass("left").removeClass("right");this._stopAnimating()},_stopAnimating:function(){if(this._scrollingThumbnail){this._scrollingThumbnail=false;this.$(".file-thumbnail").children().stop(true).animate({"margin-top":0},{duration:100})}}});RB.FloatingBannerView=Backbone.View.extend({initialize:function(){this._$floatSpacer=null;_.bindAll(this,"_updateFloatPosition","_updateSize")},render:function(){$(window).scroll(this._updateFloatPosition).resize(this._updateSize);_.defer(this._updateFloatPosition);return this},remove:function(){if(this._$floatSpacer!==null){this._$floatSpacer.remove()}Backbone.View.prototype.remove.call(this)},_updateSize:function(){var rect;if(this._$floatSpacer!==null){if(this.$el.hasClass("floating")){rect=this._$floatSpacer.parent()[0].getBoundingClientRect();this.$el.width(Math.ceil(rect.width)-this.$el.getExtents("bpm","lr"))}else{this.$el.width("auto")}}},_updateFloatPosition:function(){var $container,containerTop,containerBottom,containerHeight,wasFloating,windowTop,topOffset,outerHeight;if(this.$el.parent().length===0){return}if(this._$floatSpacer===null){this._$floatSpacer=this.$el.wrap($("<div/>")).parent();this._updateSize()}$container=this.options.$floatContainer;containerTop=$container.offset().top;containerHeight=$container.outerHeight();containerBottom=containerTop+containerHeight;windowTop=$(window).scrollTop();topOffset=this._$floatSpacer.offset().top-windowTop;outerHeight=this.$el.outerHeight(true);wasFloating=this.$el.hasClass("floating");if(!$container.hasClass(this.options.noFloatContainerClass)&&topOffset<0&&containerTop<windowTop&&windowTop<containerBottom){if(!wasFloating){this._$floatSpacer.height(this.$el.outerHeight()).css({"margin-top":this.$el.css("margin-top"),"margin-bottom":this.$el.css("margin-bottom")});this.$el.addClass("floating").css("position","fixed")}this.$el.css("top",windowTop>containerBottom-outerHeight?containerBottom-outerHeight-windowTop:0);this._updateSize()}else if(wasFloating){this.$el.removeClass("floating").css({top:"",position:""});this._$floatSpacer.height("auto").css("margin",0)}}});"use strict";RB.RegionCommentBlockView=RB.AbstractCommentBlockView.extend({className:"selection",events:_.defaults({click:"_onClicked",mousedown:"_onMouseDown"},RB.AbstractCommentBlockView.prototype.events),initialize:function initialize(){this._scale=1;this._moveState={hasMoved:false,initialCursor:{},initialBounds:{},dragCallback:_.noop};_.bindAll(this,"_onDrag","_onWindowMouseUp")},delegateEvents:function delegateEvents(){RB.AbstractCommentBlockView.prototype.delegateEvents.call(this);this.listenTo(this.model,"change:x change:y change:width change:height",this._updateBounds);this.listenTo(this.model,"change:count",this._updateCount)},undelegateEvents:function undelegateEvents(){RB.AbstractCommentBlockView.prototype.undelegateEvents.call(this);$(window).off("mousemove",this._onDrag);this.stopListening(this.model)},setSelectionRegionSizeFunc:function setSelectionRegionSizeFunc(func){this.selectionRegionSizeFunc=func},getSelectionRegionSize:function getSelectionRegionSize(){return _.result(this,"selectionRegionSizeFunc")},_startDragging:function _startDragging(left,top,callback){this._moveState.hasMoved=false;this._moveState.initialCursor.left=left;this._moveState.initialCursor.top=top;this._moveState.initialBounds.left=this.$el.position().left;this._moveState.initialBounds.top=this.$el.position().top;this._moveState.initialBounds.width=this.$el.width();this._moveState.initialBounds.height=this.$el.height();this._moveState.dragCallback=callback;$(window).on("mousemove",this._onDrag)},_endDragging:function _endDragging(){var _this=this;_.defer(function(){_this._moveState.hasMoved=false});$(window).off("mousemove",this._onDrag)},_moveTo:function _moveTo(left,top){var region=this.getSelectionRegionSize();var maxLeft=region.width-this.model.get("width")*this._scale;var maxTop=region.height-this.model.get("height")*this._scale;var newLeft=this._moveState.initialBounds.left+left-this._moveState.initialCursor.left;var newTop=this._moveState.initialBounds.top+top-this._moveState.initialCursor.top;this.model.set({x:RB.MathUtils.clip(newLeft,0,maxLeft)/this._scale,y:RB.MathUtils.clip(newTop,0,maxTop)/this._scale})},_resizeTo:function _resizeTo(left,top){var region=this.getSelectionRegionSize();var maxWidth=region.width-this.model.get("x")*this._scale;var maxHeight=region.height-this.model.get("y")*this._scale;var newWidth=this._moveState.initialBounds.width+left-this._moveState.initialCursor.left;var newHeight=this._moveState.initialBounds.height+top-this._moveState.initialCursor.top;this.model.set({width:RB.MathUtils.clip(newWidth,0,maxWidth)/this._scale,height:RB.MathUtils.clip(newHeight,0,maxHeight)/this._scale})},_onMouseDown:function _onMouseDown(e){if(this.model.canUpdateBounds()){e.preventDefault();e.stopPropagation();var draggingCallback=null;if(e.target===this._$flag.get(0)){draggingCallback=this._moveTo}else if(e.target===this._$resizeIcon.get(0)){draggingCallback=this._resizeTo}if(draggingCallback){this._startDragging(e.pageX,e.pageY,draggingCallback);$(window).one("mouseup",this._onWindowMouseUp)}}},_onWindowMouseUp:function _onWindowMouseUp(){if(this._moveState.hasMoved){this.model.saveDraftCommentBounds()}this._endDragging()},_onDrag:function _onDrag(e){e.preventDefault();e.stopPropagation();this.hideTooltip();this._moveState.hasMoved=true;this._moveState.dragCallback.call(this,e.pageX,e.pageY)},renderContent:function renderContent(){this._updateBounds();if(this.model.canUpdateBounds()){this.$el.addClass("can-update-bound");this._$resizeIcon=$('<div class="resize-icon" />').appendTo(this.$el)}this._$flag=$('<div class="selection-flag" />').appendTo(this.$el);this._updateCount()},positionCommentDlg:function positionCommentDlg(commentDlg){commentDlg.positionBeside(this._$flag,{side:"b",fitOnScreen:true})},_updateBounds:function _updateBounds(){this.$el.move(this.model.get("x")*this._scale,this.model.get("y")*this._scale,"absolute").width(this.model.get("width")*this._scale).height(this.model.get("height")*this._scale)},_updateCount:function _updateCount(){if(this._$flag){this._$flag.text(this.model.get("count"))}},_onClicked:function _onClicked(){if(!this._moveState.hasMoved){this.trigger("clicked")}},setScale:function setScale(scale){this._scale=scale;this._updateBounds()}});"use strict";(function(){var BaseCommentView=Backbone.View.extend({tagName:"li",thumbnailTemplate:null,events:{"click .delete-comment":"_deleteComment"},editorTemplate:_.template('<div class="edit-fields">\n <div class="edit-field">\n  <div class="comment-text-field">\n   <label class="comment-label" for="<%= id %>">\n    <%- commentText %>\n    <a href="#" role="button" class="delete-comment"\n       aria-label="<%- deleteCommentText %>"\n       title="<%- deleteCommentText %>"\n       ><span class="fa fa-trash-o" aria-hidden="true"></span></a>\n   </label>\n   <pre id="<%= id %>" class="reviewtext rich-text"\n        data-rich-text="true"><%- text %></pre>\n  </div>\n </div>\n <div class="edit-field">\n  <input class="issue-opened" id="<%= issueOpenedID %>"\n         type="checkbox">\n  <label for="<%= issueOpenedID %>"><%- openAnIssueText %></label>\n  <% if (showVerify) { %>\n   <input class="issue-verify" id="<%= verifyIssueID %>"\n          type="checkbox">\n   <label for="<%= verifyIssueID %>"><%- verifyIssueText %></label>\n  <% } %>\n </div>\n</div>'),_DELETE_COMMENT_TEXT:gettext("Are you sure you want to delete this comment?"),initialize:function initialize(){this.$issueOpened=null;this.$editor=null;this.textEditor=null;this._origExtraData=_.clone(this.model.get("extraData"));this._hookViews=[]},remove:function remove(){this._hookViews.forEach(function(view){return view.remove()});this._hookViews=[];Backbone.View.prototype.remove.call(this)},needsSave:function needsSave(){return this.inlineEditorView.isDirty()||!_.isEqual(this.model.get("extraData"),this._origExtraData)},save:function save(options){if(this.inlineEditorView.isDirty()){this.model.once("sync",function(){return options.success()});this.inlineEditorView.submit()}else{this.model.save(_.extend({attrs:["forceTextType","includeTextTypes","extraData"]},options))}},render:function render(){var _this=this;this.$el.addClass("draft").append(this.renderThumbnail()).append(this.editorTemplate({deleteCommentText:gettext("Delete comment"),commentText:gettext("Comment"),id:_.uniqueId("draft_comment_"),issueOpenedID:_.uniqueId("issue-opened"),openAnIssueText:gettext("Open an Issue"),text:this.model.get("text"),verifyIssueID:_.uniqueId("issue-verify"),showVerify:RB.EnabledFeatures.issueVerification,verifyIssueText:RB.CommentDialogView._verifyIssueText})).find("time.timesince").timesince().end();this.$issueOpened=this.$(".issue-opened").prop("checked",this.model.get("issueOpened")).change(function(){_this.model.set("issueOpened",_this.$issueOpened.prop("checked"));if(!_this.model.isNew()){_this.model.save({attrs:["forceTextType","includeTextTypes","issueOpened"]})}});this._$issueVerify=this.$(".issue-verify").prop("checked",this.model.requiresVerification()).change(function(){var extraData=_.clone(_this.model.get("extraData"));extraData.require_verification=_this._$issueVerify.prop("checked");_this.model.set("extraData",extraData);if(!_this.model.isNew()){_this.model.save({attrs:["forceTextType","includeTextTypes","extra_data.require_verification"]})}});var $editFields=this.$(".edit-fields");this.$editor=this.$("pre.reviewtext");this.inlineEditorView=new RB.RichTextInlineEditorView({el:this.$editor,editIconClass:"rb-icon rb-icon-edit",notifyUnchangedCompletion:true,multiline:true,textEditorOptions:{bindRichText:{model:this.model,attrName:"richText"}}});this.inlineEditorView.render();this.textEditor=this.inlineEditorView.textEditor;this.listenTo(this.inlineEditorView,"complete",function(value){var attrs=["forceTextType","includeTextTypes","richText","text"];if(_this.model.isNew()){attrs.push("extra_data.require_verification","issueOpened")}_this.model.set({text:value,richText:_this.textEditor.richText});_this.model.save({attrs:attrs})});this.listenTo(this.model,"change:"+this._getRawValueFieldsName(),this._updateRawValue);this._updateRawValue();this.listenTo(this.model,"saved",this.renderText);this.renderText();this.listenTo(this.model,"destroying",function(){return _this.stopListening(_this.model)});RB.ReviewDialogCommentHook.each(function(hook){var HookView=hook.get("viewType");var hookView=new HookView({extension:hook.get("extension"),model:_this.model});_this._hookViews.push(hookView);$('<div class="edit-field"/>').append(hookView.$el).appendTo($editFields);hookView.render()});return this},renderThumbnail:function renderThumbnail(){if(this.thumbnailTemplate===null){return null}return $(this.thumbnailTemplate(this.model.attributes))},renderText:function renderText(){var reviewRequest=this.model.get("parentObject").get("parentObject");if(this.$editor){RB.formatText(this.$editor,{newText:this.model.get("text"),richText:this.model.get("richText"),isHTMLEncoded:true,bugTrackerURL:reviewRequest.get("bugTrackerURL")})}},_deleteComment:function _deleteComment(){if(confirm(this._DELETE_COMMENT_TEXT)){this.model.destroy()}},_updateRawValue:function _updateRawValue(){if(this.$editor){this.inlineEditorView.options.hasRawValue=true;this.inlineEditorView.options.rawValue=this.model.get(this._getRawValueFieldsName()).text}},_getRawValueFieldsName:function _getRawValueFieldsName(){return RB.UserSession.instance.get("defaultUseRichText")?"markdownTextFields":"rawTextFields"}});var DiffCommentView=BaseCommentView.extend({thumbnailTemplate:_.template('<div class="review-dialog-comment-diff"\n     id="review_draft_comment_container_<%= id %>">\n <table class="sidebyside loading">\n  <thead>\n   <tr>\n    <th class="filename"><%- revisionText %></th>\n   </tr>\n  </thead>\n  <tbody>\n   <% for (var i = 0; i < numLines; i++) { %>\n    <tr><td><pre>&nbsp;</pre></td></tr>\n   <% } %>\n  </tbody>\n </table>\n</div>'),render:function render(){BaseCommentView.prototype.render.call(this);var fileDiffID=this.model.get("fileDiffID");var interFileDiffID=this.model.get("interFileDiffID");this.options.diffQueue.queueLoad(this.model.id,interFileDiffID?fileDiffID+"-"+interFileDiffID:fileDiffID);return this},renderThumbnail:function renderThumbnail(){var fileDiff=this.model.get("fileDiff");var interFileDiff=this.model.get("interFileDiff");var revisionText=void 0;if(interFileDiff){revisionText=interpolate(gettext("%(filename)s (Diff revisions %(fileDiffRevision)s - %(interFileDiffRevision)s)"),{filename:fileDiff.get("destFilename"),fileDiffRevision:fileDiff.get("sourceRevision"),inteFfileDiffRevision:interFileDiff.get("sourceRevision")},true)}else{revisionText=interpolate(gettext("%(filename)s (Diff revision %(fileDiffRevision)s)"),{filename:fileDiff.get("destFilename"),fileDiffRevision:fileDiff.get("sourceRevision")},true)}return $(this.thumbnailTemplate({id:this.model.get("id"),numLines:this.model.getNumLines(),revisionText:revisionText}))}});var FileAttachmentCommentView=BaseCommentView.extend({thumbnailTemplate:_.template('<div class="file-attachment">\n <span class="filename">\n  <a href="<%- reviewURL %>"><%- linkText %></a>\n </span>\n <span class="diffrevision"><%- revisionsStr %></span>\n <div class="thumbnail"><%= thumbnailHTML %></div>\n</div>'),renderThumbnail:function renderThumbnail(){var fileAttachment=this.model.get("fileAttachment");var diffAgainstFileAttachment=this.model.get("diffAgainstFileAttachment");var revision=fileAttachment.get("revision");var revisionsStr=void 0;if(!revision){revisionsStr=""}else if(diffAgainstFileAttachment){revisionsStr=interpolate(gettext("(Revisions %(revision1)s - %(revision2)s)"),{revision1:diffAgainstFileAttachment.get("revision"),revision2:revision},true)}else{revisionsStr=interpolate(gettext("(Revision %s)"),[revision])}return $(this.thumbnailTemplate(_.defaults({revisionsStr:revisionsStr},this.model.attributes)))}});var GeneralCommentView=BaseCommentView.extend({thumbnailTemplate:null});var ScreenshotCommentView=BaseCommentView.extend({thumbnailTemplate:_.template('<div class="screenshot">\n <span class="filename">\n  <a href="<%- screenshot.reviewURL %>"><%- displayName %></a>\n </span>\n <img src="<%= thumbnailURL %>" width="<%= width %>"\n      height="<%= height %>" alt="<%- displayName %>" />\n</div>'),renderThumbnail:function renderThumbnail(){var screenshot=this.model.get("screenshot");return $(this.thumbnailTemplate(_.defaults({screenshot:screenshot.attributes,displayName:screenshot.getDisplayName()},this.model.attributes)))}});var HeaderFooterCommentView=Backbone.View.extend({tagName:"li",editorTemplate:_.template('<div class="edit-fields">\n <div class="edit-field">\n  <div class="add-link-container">\n   <a href="#" class="add-link"><%- linkText %></a>\n  </div>\n  <div class="comment-text-field">\n   <label for="<%= id %>" class="comment-label">\n    <%- commentText %>\n   </label>\n   <pre id="<%= id %>" class="reviewtext rich-text"\n        data-rich-text="true"><%- text %></pre>\n  </div>\n </div>\n</div>'),events:{"click .add-link":"openEditor"},initialize:function initialize(options){this.propertyName=options.propertyName;this.richTextPropertyName=options.richTextPropertyName;this.linkText=options.linkText;this.commentText=options.commentText;this.$editor=null;this.textEditor=null},setLinkText:function setLinkText(linkText){this.$(".add-link").text(linkText)},render:function render(){var _this2=this;var text=this.model.get(this.propertyName);this.$el.addClass("draft").append(this.editorTemplate({commentText:this.commentText,id:this.propertyName,linkText:this.linkText,text:text||""})).find("time.timesince").timesince().end();this.$editor=this.$("pre.reviewtext");this.inlineEditorView=new RB.RichTextInlineEditorView({el:this.$editor,editIconClass:"rb-icon rb-icon-edit",notifyUnchangedCompletion:true,multiline:true,textEditorOptions:{bindRichText:{model:this.model,attrName:this.richTextPropertyName}}});this.inlineEditorView.render();this.textEditor=this.inlineEditorView.textEditor;this.listenTo(this.inlineEditorView,"complete",function(value){_this2.model.set(_this2.propertyName,value);_this2.model.set(_this2.richTextPropertyName,_this2.textEditor.richText);_this2.model.save({attrs:[_this2.propertyName,_this2.richTextPropertyName,"forceTextType","includeTextTypes"]})});this.listenTo(this.inlineEditorView,"cancel",function(){if(!_this2.model.get(_this2.propertyName)){_this2._$editorContainer.hide();_this2._$linkContainer.show()}});this._$editorContainer=this.$(".comment-text-field");this._$linkContainer=this.$(".add-link-container");this.listenTo(this.model,"change:"+this._getRawValueFieldsName(),this._updateRawValue);this._updateRawValue();this.listenTo(this.model,"saved",this.renderText);this.renderText()},renderText:function renderText(){if(this.$editor){var text=this.model.get(this.propertyName);if(text){var reviewRequest=this.model.get("parentObject");this._$editorContainer.show();this._$linkContainer.hide();RB.formatText(this.$editor,{newText:text,richText:this.model.get(this.richTextPropertyName),isHTMLEncoded:true,bugTrackerURL:reviewRequest.get("bugTrackerURL")})}else{this._$editorContainer.hide();this._$linkContainer.show()}}},needsSave:function needsSave(){return this.inlineEditorView.isDirty()},save:function save(options){this.model.once("sync",function(){return options.success()});this.inlineEditorView.submit()},openEditor:function openEditor(ev){this._$linkContainer.hide();this._$editorContainer.show();this.inlineEditorView.startEdit();if(ev){ev.preventDefault()}return false},_deleteComment:function _deleteComment(){},_updateRawValue:function _updateRawValue(){if(this.$editor){var rawValues=this.model.get(this._getRawValueFieldsName());this.inlineEditorView.options.hasRawValue=true;this.inlineEditorView.options.rawValue=rawValues[this.propertyName]}},_getRawValueFieldsName:function _getRawValueFieldsName(){return RB.UserSession.instance.get("defaultUseRichText")?"markdownTextFields":"rawTextFields"}});RB.ReviewDialogView=Backbone.View.extend({id:"review-form-comments",className:"review",template:_.template('<div class="edit-field">\n <input id="id_shipit" type="checkbox" />\n <label for="id_shipit"><%- shipItText %></label>\n</div>\n<div class="review-dialog-hooks-container"></div>\n<div class="edit-field body-top"></div>\n<ol id="review-dialog-body-top-comments" class="review-comments"></ol>\n<ol id="review-dialog-general-comments" class="review-comments"></ol>\n<ol id="review-dialog-screenshot-comments" class="review-comments"></ol>\n<ol id="review-dialog-file-attachment-comments" class="review-comments"></ol>\n<ol id="review-dialog-diff-comments" class="review-comments"></ol>\n<ol id="review-dialog-body-bottom-comments" class="review-comments"></ol>\n<div class="spinner"><span class="fa fa-spinner fa-pulse"></span></div>\n<div class="edit-field body-bottom"></div>'),initialize:function initialize(){var _this3=this;this._$diffComments=$();this._$fileAttachmentComments=$();this._$generalComments=$();this._$screenshotComments=$();this._$dlg=null;this._$buttons=null;this._$spinner=null;this._$shipIt=null;this._commentViews=[];this._hookViews=[];_.bindAll(this,"_onAddCommentClicked");var reviewRequest=this.model.get("parentObject");this._diffQueue=new RB.DiffFragmentQueueView({containerPrefix:"review_draft_comment_container",reviewRequestPath:reviewRequest.get("reviewURL"),queueName:"review_draft_diff_comments"});this._diffCommentsCollection=new RB.ResourceCollection([],{model:RB.DiffComment,parentResource:this.model,extraQueryData:{"order-by":"filediff,first_line"}});this._bodyTopView=new HeaderFooterCommentView({model:this.model,propertyName:"bodyTop",richTextPropertyName:"bodyTopRichText",linkText:gettext("Add header"),commentText:gettext("Header")});this._bodyBottomView=new HeaderFooterCommentView({model:this.model,propertyName:"bodyBottom",richTextPropertyName:"bodyBottomRichText",linkText:gettext("Add footer"),commentText:gettext("Footer")});this.listenTo(this._diffCommentsCollection,"add",function(comment){var view=new DiffCommentView({model:comment,diffQueue:_this3._diffQueue});_this3._renderComment(view,_this3._$diffComments)});this._fileAttachmentCommentsCollection=new RB.ResourceCollection([],{model:RB.FileAttachmentComment,parentResource:this.model});this.listenTo(this._fileAttachmentCommentsCollection,"add",function(comment){var view=new FileAttachmentCommentView({model:comment});_this3._renderComment(view,_this3._$fileAttachmentComments)});this._$lastGeneralComment=null;this._generalCommentsCollection=new RB.ResourceCollection([],{model:RB.GeneralComment,parentResource:this.model});this.listenTo(this._generalCommentsCollection,"add",function(comment){var view=new GeneralCommentView({model:comment});_this3._renderComment(view,_this3._$generalComments)});this._screenshotCommentsCollection=new RB.ResourceCollection([],{model:RB.ScreenshotComment,parentResource:this.model});this.listenTo(this._screenshotCommentsCollection,"add",function(comment){var view=new ScreenshotCommentView({model:comment});_this3._renderComment(view,_this3._$screenshotComments)});this._defaultUseRichText=RB.UserSession.instance.get("defaultUseRichText");this._queryData={"force-text-type":"html"};if(this._defaultUseRichText){this._queryData["include-text-types"]="raw,markdown"}else{this._queryData["include-text-types"]="raw"}this._setTextTypeAttributes(this.model);this.options.reviewRequestEditor.incr("editCount")},remove:function remove(){if(this._publishButton){this._publishButton.remove();this._publishButton=null}this._hookViews.forEach(function(view){return view.remove()});this._hookViews=[];_super(this).remove.call(this)},close:function close(){this.options.reviewRequestEditor.decr("editCount");this._$dlg.modalBox("destroy");this.trigger("closed");this.remove()},render:function render(){var _this4=this;this.$el.html(this.template({addHeaderText:gettext("Add header"),addFooterText:gettext("Add footer"),shipItText:gettext("Ship It"),markdownDocsURL:MANUAL_URL+"users/markdown/",markdownText:gettext("Markdown Reference")}));this._$diffComments=this.$("#review-dialog-diff-comments");this._$fileAttachmentComments=this.$("#review-dialog-file-attachment-comments");this._$generalComments=this.$("#review-dialog-general-comments");this._$screenshotComments=this.$("#review-dialog-screenshot-comments");this._$spinner=this.$(".spinner");this._$shipIt=this.$("#id_shipit");var $hooksContainer=this.$(".review-dialog-hooks-container");RB.ReviewDialogHook.each(function(hook){var HookView=hook.get("viewType");var hookView=new HookView({extension:hook.get("extension"),model:_this4.model});_this4._hookViews.push(hookView);$hooksContainer.append(hookView.$el);hookView.render()});this._bodyTopView.$el.appendTo(this.$("#review-dialog-body-top-comments"));this._bodyBottomView.$el.appendTo(this.$("#review-dialog-body-bottom-comments"));this.model.set("loaded",false);this.model.ready({data:this._queryData,ready:function ready(){_this4._renderDialog();_this4._bodyTopView.render();_this4._bodyBottomView.render();if(_this4.model.isNew()||_this4.model.get("bodyTop")===""){_this4._bodyTopView.openEditor()}if(_this4.model.isNew()){_this4._$spinner.remove();_this4._$spinner=null;_this4._handleEmptyReview()}else{_this4._$shipIt.prop("checked",_this4.model.get("shipIt"));_this4._loadComments()}_this4.listenTo(_this4.model,"change:bodyBottom",_this4._handleEmptyReview)}});return this},_loadComments:function _loadComments(){var _this5=this;var collections=[this._screenshotCommentsCollection,this._fileAttachmentCommentsCollection,this._diffCommentsCollection];if(RB.EnabledFeatures.generalComments){collections.unshift(this._generalCommentsCollection)}this._loadCommentsFromCollection(collections,function(){_this5._$spinner.remove();_this5._$spinner=null;_this5._handleEmptyReview()})},_handleEmptyReview:function _handleEmptyReview(){if(this._commentViews.length===0&&!this.model.get("bodyBottom")){this._bodyBottomView.$el.hide();this._bodyTopView.setLinkText(gettext("Add text"))}},_loadCommentsFromCollection:function _loadCommentsFromCollection(collections,onDone){var _this6=this;var collection=collections.shift();if(collection){collection.fetchAll({data:this._queryData,success:function success(){if(collection===_this6._diffCommentsCollection){_this6._diffQueue.loadFragments()}_this6._loadCommentsFromCollection(collections,onDone)},error:function error(rsp){alert(rsp.errorText)}})}else{onDone()}},_renderComment:function _renderComment(view,$container){var _this7=this;this._setTextTypeAttributes(view.model);this._commentViews.push(view);this.listenTo(view.model,"destroyed",function(){view.$el.fadeOut({
complete:function complete(){view.remove();_this7._handleEmptyReview()}});_this7._commentViews=_.without(_this7._commentViews,view)});$container.append(view.$el);view.render();this._$dlg.scrollTop(view.$el.position().top+this._$dlg.getExtents("p","t"))},_renderDialog:function _renderDialog(){var _this8=this;var $leftButtons=$('<div class="review-dialog-buttons-left"/>');var $rightButtons=$('<div class="review-dialog-buttons-right"/>');var buttons=[$leftButtons,$rightButtons];if(RB.EnabledFeatures.generalComments){$leftButtons.append($('<input type="button" />').val(gettext("Add General Comment")).attr("title",gettext("Add a new general comment to the review")).click(this._onAddCommentClicked))}$rightButtons.append($('<div id="review-form-publish-split-btn-container" />'));$rightButtons.append($('<input type="button"/>').val(gettext("Discard Review")).click(function(){return _this8._onDiscardClicked()}));$rightButtons.append($('<input type="button"/>').val(gettext("Close")).click(function(){_this8._saveReview(false);return false}));var reviewRequest=this.model.get("parentObject");this._$dlg=$("<div/>").attr("id","review-form").append(this.$el).modalBox({container:this.options.container||"body",boxID:"review-form-modalbox",title:interpolate(gettext("Review for: %s"),[reviewRequest.get("summary")]),stretchX:true,stretchY:true,buttons:buttons}).keypress(function(e){return e.stopPropagation()}).attr("scrollTop",0).trigger("ready");this._publishButton=new RB.SplitButtonView({el:$("#review-form-publish-split-btn-container"),text:gettext("Publish Review"),click:function click(){_this8._saveReview(true);return false},direction:"up",alternatives:[{text:gettext("... and only e-mail the owner"),click:function click(){_this8._saveReview(true,{publishToOwnerOnly:true});_this8.close();return false}}]});this._publishButton.render();this._$buttons=this._$dlg.modalBox("buttons")},_onAddCommentClicked:function _onAddCommentClicked(){var comment=this.model.createGeneralComment(undefined,RB.UserSession.instance.get("commentsOpenAnIssue"));this._generalCommentsCollection.add(comment);this._bodyBottomView.$el.show();this._commentViews[this._commentViews.length-1].inlineEditorView.startEdit();return false},_onDiscardClicked:function _onDiscardClicked(){var _this9=this;var $cancelButton=$('<input type="button">').val(gettext("Cancel"));var $discardButton=$('<input type="button">').val(gettext("Discard")).click(function(){_this9.close();_this9.model.destroy({success:function success(){return RB.DraftReviewBannerView.instance.hideAndReload()}})});$("<p/>").text(gettext("If you discard this review, all related comments will be permanently deleted.")).modalBox({title:gettext("Are you sure you want to discard this review?"),buttons:[$cancelButton,$discardButton]});return false},_saveReview:function _saveReview(publish){var _this10=this;var options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};if(publish&&options.publishToOwnerOnly){this.model.set("publishToOwnerOnly",true)}this._$buttons.prop("disabled");var madeChanges=false;$.funcQueue("reviewForm").clear();function maybeSave(view){if(view.needsSave()){$.funcQueue("reviewForm").add(function(){madeChanges=true;view.save({success:function success(){return $.funcQueue("reviewForm").next()}})})}}maybeSave(this._bodyTopView);maybeSave(this._bodyBottomView);this._commentViews.forEach(function(view){return maybeSave(view)});$.funcQueue("reviewForm").add(function(){var shipIt=_this10._$shipIt.prop("checked");var saveFunc=publish?_this10.model.publish:_this10.model.save;if(_this10.model.get("public")===publish&&_this10.model.get("shipIt")===shipIt){$.funcQueue("reviewForm").next()}else{madeChanges=true;_this10.model.set({shipIt:shipIt});saveFunc.call(_this10.model,{attrs:["public","shipIt","forceTextType","includeTextTypes","publishToOwnerOnly"],success:function success(){return $.funcQueue("reviewForm").next()},error:function error(){console.error("Failed to save review",arguments)}})}});$.funcQueue("reviewForm").add(function(){var reviewBanner=RB.DraftReviewBannerView.instance;_this10.close();if(reviewBanner){if(publish){reviewBanner.hideAndReload()}else if(_this10.model.isNew()&&!madeChanges){reviewBanner.hide()}else{reviewBanner.show()}}});$.funcQueue("reviewForm").start()},_setTextTypeAttributes:function _setTextTypeAttributes(model){model.set({forceTextType:"html",includeTextTypes:this._defaultUseRichText?"raw,markdown":"raw"})}},{_instance:null,create:function create(){var options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};console.assert(!RB.ReviewDialogView._instance,"A ReviewDialogView is already opened");console.assert(options.review,"A review must be specified");var dialog=new RB.ReviewDialogView({container:options.container,model:options.review,reviewRequestEditor:options.reviewRequestEditor});RB.ReviewDialogView._instance=dialog;dialog.render();dialog.on("closed",function(){RB.ReviewDialogView._instance=null});return dialog}})})();"use strict";(function(){var Fields={};Fields.BaseFieldView=Backbone.View.extend({editableProp:"editable",useExtraData:true,initialize:function initialize(options){Backbone.View.prototype.initialize.call(this,options);this.options=options;this.fieldID=options.fieldID;this.jsonFieldName=options.jsonFieldName||this.jsonFieldName||this.fieldID;this._fieldName=undefined;this.$el.data("field-id",this.fieldID)},fieldName:function fieldName(){if(this._fieldName===undefined){this._fieldName=this.fieldID.replace(/_(.)/g,function(m,c){return c.toUpperCase()})}return this._fieldName},_loadValue:function _loadValue(options){var fieldName=this.useExtraData?this.jsonFieldName:_.result(this,"fieldName");return this.model.getDraftField(fieldName,_.defaults({useExtraData:this.useExtraData},options))},_saveValue:function _saveValue(value,options){this.model.setDraftField(_.result(this,"fieldName"),value,_.defaults({jsonFieldName:this.jsonFieldName,useExtraData:this.useExtraData},options))},needsSave:function needsSave(){return false},finishSave:function finishSave(){}});Fields.TextFieldView=Fields.BaseFieldView.extend({autocomplete:null,multiline:false,allowRichText:false,useEditIconOnly:false,richTextAttr:function richTextAttr(){return this.allowRichText?_.result(this,"fieldName")+"RichText":null},initialize:function initialize(options){Fields.BaseFieldView.prototype.initialize.call(this,options);this.jsonTextTypeFieldName=this.jsonFieldName==="text"?"text_type":this.jsonFieldName+"_text_type"},_getInlineEditorClass:function _getInlineEditorClass(){return this.allowRichText?RB.RichTextInlineEditorView:RB.InlineEditorView},render:function render(){var _this=this;if(!this.$el.hasClass("editable")){return this}var fieldName=_.result(this,"fieldName");var EditorClass=this._getInlineEditorClass();var inlineEditorOptions={el:this.$el,formClass:this.$el.prop("id")+"-editor",editIconClass:"rb-icon rb-icon-edit",enabled:this.model.get(this.editableProp),multiline:this.multiline,useEditIconOnly:this.useEditIconOnly,showRequiredFlag:this.$el.hasClass("required"),deferEventSetup:this.autocomplete!==null};if(this.allowRichText){_.extend(inlineEditorOptions,{textEditorOptions:{minHeight:0,richText:this._loadRichTextValue()},matchHeight:false,hasRawValue:true,rawValue:this._loadValue({useRawTextValue:true})||""})}this.inlineEditorView=new EditorClass(inlineEditorOptions);this.inlineEditorView.render();this.listenTo(this.inlineEditorView,"beginEdit",function(){return _this.model.incr("editCount")});this.listenTo(this.inlineEditorView,"resize",function(){return _this.trigger("resize")});this.listenTo(this.inlineEditorView,"cancel",function(){_this.trigger("resize");_this.model.decr("editCount")});this.listenTo(this.inlineEditorView,"complete",function(value){_this.trigger("resize");_this.model.decr("editCount");var saveOptions={allowMarkdown:_this.allowRichText,error:function error(err){_this._formatField();_this.trigger("fieldError",err)},success:function success(){_this._formatField();_this.trigger("fieldSaved")}};if(_this.allowRichText){saveOptions.richText=_this.inlineEditorView.textEditor.richText;saveOptions.jsonTextTypeFieldName=_this.jsonTextTypeFieldName}_this._saveValue(value,saveOptions)});if(this.autocomplete!==null){this._buildAutoComplete();this.inlineEditorView.setupEvents()}this.listenTo(this.model,"change:"+this.editableProp,function(model,editable){if(editable){_this.inlineEditorView.enable()}else{_this.inlineEditorView.disable()}});this.listenTo(this.model,"fieldChanged:"+fieldName,this._formatField);return this},_convertToLink:function _convertToLink(item){var options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};if(!item){return $()}var $link=$("<a/>").attr("href",options.makeItemURL?options.makeItemURL(item):item).text(options.makeItemText?options.makeItemText(item):item);if(options.cssClass){$link.addClass(options.cssClass)}return $link},_buildAutoComplete:function _buildAutoComplete(){var ac=this.autocomplete;var reviewRequest=this.model.get("reviewRequest");this.inlineEditorView.$field.rbautocomplete({formatItem:function formatItem(data){var s=data[ac.nameKey];if(ac.descKey&&data[ac.descKey]){s+=" <span>("+_.escape(data[ac.descKey])+")</span>"}return s},matchCase:false,multiple:true,parse:function parse(data){var items=_.isFunction(ac.fieldName)?ac.fieldName(data):data[ac.fieldName];return items.map(function(item){if(ac.parseItem){item=ac.parseItem(item)}return{data:item,value:item[ac.nameKey],result:item[ac.nameKey]}})},url:SITE_ROOT+reviewRequest.get("localSitePrefix")+"api/"+(ac.resourceName||ac.fieldName)+"/",extraParams:ac.extraParams,cmp:ac.cmp,width:350,error:function error(xhr){var text=void 0;try{text=JSON.parse(xhr.responseText).err.msg}catch(e){text="HTTP "+xhr.status+" "+xhr.statusText}alert(text)}}).on("autocompleteshow",function(){var resultsPane=$(".ui-autocomplete-results:not("+":has(.ui-autocomplete-footer))");if(resultsPane.length>0){$("<div/>").addClass("ui-autocomplete-footer").text(gettext("Press Tab to auto-complete.")).appendTo(resultsPane)}})},_formatField:function _formatField(){var value=this._loadValue();if(_.isFunction(this.formatValue)){this.formatValue(value)}else{this.$el.text(value)}},needsSave:function needsSave(){return this.inlineEditorView&&this.inlineEditorView.isDirty()},finishSave:function finishSave(){this.inlineEditorView.submit()},_loadRichTextValue:function _loadRichTextValue(){if(this.useExtraData){var textTypeFieldName=this.jsonTextTypeFieldName;var textType=this.model.getDraftField(textTypeFieldName,{useExtraData:true,useRawTextValue:true});if(textType===undefined){return undefined}console.assert(textType==="plain"||textType==="markdown",'Text type "'+textType+'" in field "'+textTypeFieldName+'" '+"not supported.");return textType==="markdown"}else{return this.model.getDraftField(_.result(this,"richTextAttr"))}}});Fields.MultilineTextFieldView=Fields.TextFieldView.extend({multiline:true,allowRichText:null,initialize:function initialize(options){Fields.TextFieldView.prototype.initialize.call(this,options);if(this.allowRichText===null){this.allowRichText=this.$el.data("allow-markdown");var reviewRequest=this.model.get("reviewRequest");var extraData=reviewRequest.draft.get("extraData");var rawValue=this.$el.data("raw-value");extraData[this.jsonFieldName]=rawValue!==undefined?rawValue||"":this.$el.text();this.$el.removeAttr("data-raw-value");if(this.allowRichText){extraData[this.jsonTextTypeFieldName]=this.$el.hasClass("rich-text")?"markdown":"plain"}}},formatText:function formatText(options){var _this2=this;var reviewRequest=this.model.get("reviewRequest");options=_.defaults({bugTrackerURL:reviewRequest.get("bugTrackerURL"),isHTMLEncoded:true},options);if(this.allowRichText){options.richText=this._loadRichTextValue()}RB.formatText(this.$el,options);this.$("img").load(function(){return _this2.trigger("resize")})},render:function render(){Fields.TextFieldView.prototype.render.call(this);this.formatText();return this},formatValue:function formatValue(data){if(this.allowRichText){this.formatText({newText:data})}}});Fields.CommaSeparatedValuesTextFieldView=Fields.TextFieldView.extend({useEditIconOnly:true,_urlizeList:function _urlizeList(list){var options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var $links=$();if(list){for(var i=0;i<list.length;i++){$links=$links.add(this._convertToLink(list[i],options));if(i<list.length-1){$links=$links.add(document.createTextNode(", "))}}}return $links},formatValue:function formatValue(data){data=data||[];this.$el.html(data.join(", "))}});Fields.CheckboxFieldView=Fields.BaseFieldView.extend({render:function render(){var _this3=this;Fields.BaseFieldView.prototype.render.call(this);this.$el.change(function(){_this3._saveValue(_this3.$el.is(":checked"),{error:function error(err){return _this3.trigger("fieldError",err)},success:function success(){return _this3.trigger("fieldSaved")}})});return this}});Fields.DropdownFieldView=Fields.BaseFieldView.extend({render:function render(){var _this4=this;Fields.BaseFieldView.prototype.render.call(this);this.$el.change(function(){_this4._saveValue(_this4.$el.val(),{error:function error(err){return _this4.trigger("fieldError",err)},success:function success(){return _this4.trigger("fieldSaved")}})});return this}});Fields.DateFieldView=Fields.TextFieldView.extend({render:function render(){var _this5=this;Fields.TextFieldView.prototype.render.call(this);this.inlineEditorView.$field.datepicker({changeMonth:true,changeYear:true,dateFormat:$.datepicker.ISO_8601,showButtonPanel:true,onSelect:function onSelect(dateText,instance){if(dateText!==instance.lastVal){_this5.inlineEditorView._dirty=true}}});return this},_saveValue:function _saveValue(value,options){var m=moment(value,"YYYY-MM-DD",true);if(!m.isValid()){value="";this.$el.text("")}Fields.TextFieldView.prototype._saveValue.call(this,value,options)}});Fields.BranchFieldView=Fields.TextFieldView.extend({useExtraData:false});Fields.BugsFieldView=Fields.CommaSeparatedValuesTextFieldView.extend({useExtraData:false,formatValue:function formatValue(data){data=data||[];var reviewRequest=this.model.get("reviewRequest");var bugTrackerURL=reviewRequest.get("bugTrackerURL");if(bugTrackerURL){this.$el.empty().append(this._urlizeList(data,{makeItemURL:function makeItemURL(item){return bugTrackerURL.replace("--bug_id--",item)},cssClass:"bug"})).find(".bug").bug_infobox()}else{this.$el.text(data.join(", "))}}});Fields.ChangeDescriptionFieldView=Fields.MultilineTextFieldView.extend({allowRichText:true,jsonFieldName:"changedescription",useExtraData:false});Fields.CloseDescriptionFieldView=Fields.MultilineTextFieldView.extend({allowRichText:true,useExtraData:false,editableProp:"statusEditable",_saveValue:function _saveValue(value,options){this.model.get("reviewRequest").close(_.defaults({type:this.closeType,description:value,postData:{force_text_type:"html",include_text_types:"raw"}},options))}});Fields.DependsOnFieldView=Fields.CommaSeparatedValuesTextFieldView.extend({autocomplete:{fieldName:function fieldName(data){return data.search.review_requests},nameKey:"id",descKey:"id",display_name:"summary",resourceName:"search",parseItem:function parseItem(item){item.id=item.id.toString();item.display_name=item.summary;return item},extraParams:{summary:1},cmp:function cmp(term,a,b){return b.data.id-a.data.id}},useEditIconOnly:true,useExtraData:false,formatValue:function formatValue(data){data=data||[];this.$el.empty().append(this._urlizeList(data,{makeItemURL:function makeItemURL(item){return item.url},makeItemText:function makeItemText(item){return item.id},cssClass:"review-request-link"})).find(".review-request-link").review_request_infobox()}});Fields.DescriptionFieldView=Fields.MultilineTextFieldView.extend({allowRichText:true,useExtraData:false});Fields.OwnerFieldView=Fields.TextFieldView.extend({autocomplete:{fieldName:"users",nameKey:"username",descKey:"fullname",extraParams:{fullname:1},cmp:function cmp(term,a,b){var aUsername=a.data.username;var bUsername=b.data.username;var aFullname=a.data.fullname;var bFullname=a.data.fullname;if(aUsername.indexOf(term)===0){if(bUsername.indexOf(term)===0){return aUsername.localeCompare(bUsername)}return-1}else if(bUsername.indexOf(term)===0){return 1}else{return aFullname.localeCompare(bFullname)}}},useEditIconOnly:true,useExtraData:false,formatValue:function formatValue(data){var $link=this._convertToLink(data,{makeItemURL:function makeItemURL(item){var href=item.href;return href.substr(href.indexOf("/users"))},makeItemText:function makeItemText(item){return item.title},cssClass:"user"});this.$el.empty().append($link.user_infobox())}});Fields.SummaryFieldView=Fields.TextFieldView.extend({useExtraData:false});Fields.TargetGroupsFieldView=Fields.CommaSeparatedValuesTextFieldView.extend({autocomplete:{fieldName:"groups",nameKey:"name",descKey:"display_name",extraParams:{displayname:1}},useEditIconOnly:true,useExtraData:false,formatValue:function formatValue(data){data=data||[];this.$el.empty().append(this._urlizeList(data,{makeItemURL:function makeItemURL(item){return item.url},makeItemText:function makeItemText(item){return item.name}}))}});Fields.TargetPeopleFieldView=Fields.CommaSeparatedValuesTextFieldView.extend({autocomplete:{fieldName:"users",nameKey:"username",descKey:"fullname",extraParams:{fullname:1},cmp:function cmp(term,a,b){var aUsername=a.data.username;var bUsername=b.data.username;var aFullname=a.data.fullname;var bFullname=a.data.fullname;if(aUsername.indexOf(term)===0){if(bUsername.indexOf(term)===0){return aUsername.localeCompare(bUsername)}return-1}else if(bUsername.indexOf(term)===0){return 1}else{return aFullname.localeCompare(bFullname)}}},useEditIconOnly:true,useExtraData:false,formatValue:function formatValue(data){data=data||[];this.$el.empty().append(this._urlizeList(data,{makeItemURL:function makeItemURL(item){return item.url},makeItemText:function makeItemText(item){return item.username},cssClass:"user"})).find(".user").user_infobox()}});Fields.TestingDoneFieldView=Fields.MultilineTextFieldView.extend({allowRichText:true,useExtraData:false});RB.ReviewRequestFields=Fields})();"use strict";(function(){var BannerView=Backbone.View.extend({className:"banner",title:"",subtitle:"",actions:[],showChangesField:true,describeText:"",fieldOptions:{},descriptionFieldID:"change_description",descriptionFieldName:null,descriptionFieldHTML:"",descriptionFieldClasses:"",showSendEmail:false,DescriptionFieldViewType:RB.ReviewRequestFields.ChangeDescriptionFieldView,template:_.template('<h1><%- title %></h1>\n<% if (subtitle) { %>\n<p><%- subtitle %></p>\n<% } %>\n<span class="banner-actions">\n<% _.each(actions, function(action) { %>\n <input type="button" id="<%= action.id %>"\n        value="<%- action.label %>" />\n<% }); %>\n<% if (showSendEmail) { %>\n <label>\n  <input type="checkbox" class="send-email" checked />\n  <%- sendEmailText %>\n</label>\n<% } %>\n</span>\n<% if (showChangesField) { %>\n <p><label for="field_<%- descriptionFieldID %>"><%- describeText %></label></p>\n <pre id="field_<%- descriptionFieldID %>"\n      class="field field-text-area <%- descriptionFieldClasses %>"\n      data-field-id="field_<%- descriptionFieldID %>"\n      ><%= descriptionFieldHTML %></pre>\n<% } %>'),initialize:function initialize(options){this.reviewRequestEditorView=options.reviewRequestEditorView;this.reviewRequestEditor=this.reviewRequestEditorView.model;this.reviewRequest=this.reviewRequestEditor.get("reviewRequest");this.$buttons=null},render:function render(){var _this=this;if(this.$el.children().length===0){this.$el.html(this.template({title:this.title,subtitle:this.subtitle,actions:this.actions,showChangesField:this.showChangesField,describeText:this.describeText,descriptionFieldID:this.descriptionFieldID,descriptionFieldHTML:this.descriptionFieldHTML,descriptionFieldClasses:this.descriptionFieldClasses,showSendEmail:this.showSendEmail,sendEmailText:gettext("Send E-Mail")}))}if(this.DescriptionFieldViewType){this.field=new this.DescriptionFieldViewType({el:this.$("#field_"+this.descriptionFieldID),fieldID:this.descriptionFieldID,model:this.reviewRequestEditor});this.reviewRequestEditorView.addFieldView(this.field)}this.$buttons=this.$("input");this.reviewRequestEditor.on("saving destroying",function(){return _this.$buttons.prop("disabled",true)});this.reviewRequestEditor.on("saved saveFailed destroyed",function(){return _this.$buttons.prop("disabled",false)});return this}});var ClosedBannerView=BannerView.extend({descriptionFieldID:"close_description",descriptionFieldName:"closeDescription",DescriptionFieldViewType:RB.ReviewRequestFields.CloseDescriptionFieldView,actions:[{id:"btn-review-request-reopen",label:gettext("Reopen for Review")}],closeType:undefined,events:{"click #btn-review-request-reopen":"_onReopenClicked"},render:function render(){var descriptionFieldClasses=[];if(this.reviewRequestEditor.get("statusMutableByUser")){descriptionFieldClasses.push("editable")}if(this.reviewRequest.get("closeDescriptionRichText")){descriptionFieldClasses.push("rich-text")}this.descriptionFieldClasses=descriptionFieldClasses.join(" ");this.descriptionFieldHTML=this.reviewRequestEditor.get("closeDescriptionRenderedText");BannerView.prototype.render.apply(this,arguments);this.field.closeType=this.closeType;return this},_onReopenClicked:function _onReopenClicked(){this.reviewRequest.reopen({error:function error(model,xhr){return alert(xhr.errorText)}});return false}});var DiscardedBannerView=ClosedBannerView.extend({id:"discard-banner",title:gettext("This change has been discarded."),describeText:gettext("Describe the reason it's discarded (optional):"),closeType:RB.ReviewRequest.CLOSE_DISCARDED});var SubmittedBannerView=ClosedBannerView.extend({id:"submitted-banner",title:gettext("This change has been marked as submitted."),describeText:gettext("Describe the submission (optional):"),closeType:RB.ReviewRequest.CLOSE_SUBMITTED});var DraftBannerView=BannerView.extend({id:"draft-banner",title:gettext("This review request is a draft."),subtitle:gettext("Be sure to publish when finished."),describeText:gettext("Describe your changes (optional):"),descriptionFieldID:"change_description",descriptionFieldName:"changeDescription",_newDraftTemplate:_.template('<div class="interdiff-link">\n <%- newDiffText %>\n <a href="<%- interdiffLink %>"><%- showChangesText %></a>\n</div>'),events:{"click #btn-draft-publish":"_onPublishDraftClicked","click #btn-draft-discard":"_onDiscardDraftClicked","click #btn-review-request-discard":"_onCloseDiscardedClicked"},initialize:function initialize(){BannerView.prototype.initialize.apply(this,arguments);if(this.reviewRequest.get("public")){this.showSendEmail=this.reviewRequestEditor.get("showSendEmail");this.title=gettext("This review request is a draft.");this.actions=[{id:"btn-draft-publish",label:gettext("Publish Changes")},{id:"btn-draft-discard",label:gettext("Discard Draft")}]}else{this.showChangesField=false;this.actions=[{id:"btn-draft-publish",label:gettext("Publish")},{id:"btn-review-request-discard",label:gettext("Discard Review Request")}]}},_onPublishDraftClicked:function _onPublishDraftClicked(){var $sendEmail=this.$(".send-email");this.reviewRequestEditorView.publishDraft({trivial:$sendEmail.length===1&&!$sendEmail.is(":checked")});return false},_onDiscardDraftClicked:function _onDiscardDraftClicked(){this.reviewRequest.draft.destroy({error:function error(xhr){return alert(xhr.errorText)}});return false},_onCloseDiscardedClicked:function _onCloseDiscardedClicked(){this.reviewRequest.close({type:RB.ReviewRequest.CLOSE_DISCARDED});return false},render:function render(){var descriptionFieldClasses=[];if(this.reviewRequestEditor.get("mutableByUser")){descriptionFieldClasses.push("editable")}var draft=this.reviewRequest.draft;if(draft.get("changeDescriptionRichText")){descriptionFieldClasses.push("rich-text")}this.descriptionFieldClasses=descriptionFieldClasses.join(" ");this.descriptionFieldHTML=this.reviewRequestEditor.get("changeDescriptionRenderedText");BannerView.prototype.render.apply(this,arguments);var interdiffLink=draft.get("interdiffLink");if(interdiffLink){this.$el.append(this._newDraftTemplate({newDiffText:gettext("This draft adds a new diff."),showChangesText:gettext("Show changes"),interdiffLink:interdiffLink}))}return this}});RB.ReviewRequestEditorView=Backbone.View.extend({defaultFields:[{fieldID:"branch"},{fieldID:"bugs_closed",fieldName:"bugsClosed",selector:"#field_bugs_closed",useEditIconOnly:true},{fieldID:"depends_on",fieldName:"dependsOn",useEditIconOnly:true},{fieldID:"description",allowMarkdown:true},{fieldID:"summary"},{fieldID:"submitter",fieldName:"submitter",useEditIconOnly:true},{fieldID:"target_groups",fieldName:"targetGroups",useEditIconOnly:true},{fieldID:"target_people",fieldName:"targetPeople",useEditIconOnly:true},{fieldID:"testing_done",fieldName:"testingDone",allowMarkdown:true}],events:{"click #archive-review-request-link":"_onArchiveClicked","click #unarchive-review-request-link":"_onUnarchiveClicked","click #mute-review-request-link":"_onMuteClicked","click #unmute-review-request-link":"_onUnmuteClicked"},_archiveActionsTemplate:_.template('<% if (visibility === RB.ReviewRequest.VISIBILITY_VISIBLE) { %>\n <li><a id="archive-review-request-link" href="#"><%- archiveText %></a></li>\n <li><a id="mute-review-request-link" href="#"><%- muteText %></a></li>\n<% } else if (visibility === RB.ReviewRequest.VISIBILITY_ARCHIVED) { %>\n <li><a id="unarchive-review-request-link" href="#"><%- unarchiveText %></a></li>\n<% } else if (visibility === RB.ReviewRequest.VISIBILITY_MUTED) { %>\n <li><a id="unmute-review-request-link" href="#"><%- unmuteText %></a></li>\n<% } %>'),initialize:function initialize(){_.bindAll(this,"_checkResizeLayout","_scheduleResizeLayout","_onCloseDiscardedClicked","_onCloseSubmittedClicked","_onDeleteReviewRequestClicked","_onUpdateDiffClicked","_onArchiveClicked","_onUnarchiveClicked","_onMuteClicked","_onUnmuteClicked","_onUploadFileClicked");this._fieldViews={};this.rendered=false;this.draft=this.model.get("reviewRequest").draft;this.banner=null;this._$main=null;this._$extra=null;this._blockResizeLayout=false},addFieldView:function addFieldView(view){var _this2=this;this._fieldViews[view.fieldID]=view;view.reviewRequestEditorView=this;this.listenTo(view,"resize",this._scheduleResizeLayout);this.listenTo(view,"fieldError",function(err){_this2._$warning.delay(6e3).fadeOut(400,function(){return _this2._$warning.hide()}).html(err.errorText).show()});this.listenTo(view,"fieldSaved",this.showBanner);if(this.rendered){view.render()}},getFieldView:function getFieldView(fieldID){return this._fieldViews[fieldID]},render:function render(){var _this3=this;var reviewRequest=this.model.get("reviewRequest");var fileAttachments=this.model.get("fileAttachments");var draft=reviewRequest.draft;this._$box=this.$(".review-request");this._$warning=$("#review-request-warning");this._$screenshots=$("#screenshot-thumbnails");this._$attachments=$("#file-list");this._$attachmentsContainer=$(this._$attachments.parent()[0]);this._$bannersContainer=$("#review-request-banners");this._$main=$("#review-request-main");this._$extra=$("#review-request-extra");this.listenTo(reviewRequest,"change:visibility",this._updateArchiveVisibility);this._updateArchiveVisibility();this.showBanner();if(this.model.get("editable")){RB.DnDUploader.instance.registerDropTarget(this._$attachmentsContainer,gettext("Drop to add a file attachment"),this._uploadFile.bind(this))}$("#review-request-files-placeholder").remove();fileAttachments.each(function(fileAttachment){return _this3.buildFileAttachmentThumbnail(fileAttachment,fileAttachments,{noAnimation:true})});this.listenTo(fileAttachments,"add",this.buildFileAttachmentThumbnail);this.listenTo(fileAttachments,"destroy",function(){if(fileAttachments.length===0){_this3._$attachmentsContainer.hide()}});_.each(this._$screenshots.find(".screenshot-container"),this._importScreenshotThumbnail,this);_.each($(".binary"),this._importFileAttachmentThumbnail,this);for(var fieldID in this._fieldViews){if(this._fieldViews.hasOwnProperty(fieldID)){this._fieldViews[fieldID].render()}}$(window).resize(this._scheduleResizeLayout);this.listenTo(this.model,"change:editCount",this._checkResizeLayout);this._checkResizeLayout();this._setupActions();this.model.on("publishError",function(errorText){alert(errorText);_this3.$("#btn-draft-publish").enable();_this3.$("#btn-draft-discard").enable()});this.model.on("closeError",function(errorText){return alert(errorText)});this.model.on("saved",this.showBanner,this);this.model.on("published",this._refreshPage,this);reviewRequest.on("closed reopened",this._refreshPage,this);draft.on("destroyed",this._refreshPage,this);window.onbeforeunload=this._onBeforeUnload.bind(this);this.rendered=true;return this},_onBeforeUnload:function _onBeforeUnload(evt){if(this.model.get("editCount")>0){var msg=gettext("You have unsaved changes that will be lost if you navigate away from this page.");evt=evt||window.event;evt.returnValue=msg;return msg}},showBanner:function showBanner(){if(this.banner){return}var reviewRequest=this.model.get("reviewRequest");var state=reviewRequest.get("state");var BannerClass=void 0;if(state===RB.ReviewRequest.CLOSE_SUBMITTED){BannerClass=SubmittedBannerView}else if(state===RB.ReviewRequest.CLOSE_DISCARDED){BannerClass=DiscardedBannerView}else if(state===RB.ReviewRequest.PENDING&&this.model.get("hasDraft")){BannerClass=DraftBannerView}else{return}var $existingBanner=this._$bannersContainer.children();console.assert(BannerClass);console.assert($existingBanner.length<=1);if($existingBanner.length===0){$existingBanner=undefined}this.banner=new BannerClass({el:$existingBanner,reviewRequestEditorView:this});if($existingBanner){$existingBanner.show()}else{this.banner.$el.appendTo(this._$bannersContainer)}this.banner.render()},publishDraft:function publishDraft(options){var fields=Object.values(this._fieldViews).filter(function(view){return view.needsSave()});this.model.set({publishing:true,pendingSaveCount:fields.length});if(fields.length===0){this.model.publishDraft(options)}else{fields.forEach(function(field){return field.finishSave()})}},_uploadFile:function _uploadFile(file){var fileAttachment=this.model.createFileAttachment();fileAttachment.set("file",file);fileAttachment.save()},_setupActions:function _setupActions(){var _this4=this;var $closeDiscarded=this.$("#discard-review-request-action");var $closeSubmitted=this.$("#submit-review-request-action");var $deletePermanently=this.$("#delete-review-request-action");var $updateDiff=this.$("#upload-diff-action");var $uploadFile=this.$("#upload-file-action");$closeDiscarded.click(this._onCloseDiscardedClicked);$closeSubmitted.click(this._onCloseSubmittedClicked);$deletePermanently.click(this._onDeleteReviewRequestClicked);$updateDiff.click(this._onUpdateDiffClicked);$uploadFile.click(this._onUploadFileClicked);RB.ReviewRequestActionHook.each(function(hook){_.each(hook.get("callbacks"),function(handler,selector){return _this4.$(selector).click(handler)})})},buildFileAttachmentThumbnail:function buildFileAttachmentThumbnail(fileAttachment,collection){var _this5=this;var options=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};var fileAttachmentComments=this.model.get("fileAttachmentComments");var $thumbnail=options.$el;var view=new RB.FileAttachmentThumbnail({el:$thumbnail,model:fileAttachment,comments:fileAttachmentComments[fileAttachment.id],renderThumbnail:$thumbnail===undefined,reviewRequest:this.model.get("reviewRequest"),canEdit:this.model.get("editable")===true});view.render();if(!$thumbnail){this._$attachmentsContainer.show();view.$el.insertBefore(this._$attachments.children("br"));if(!options.noAnimation){view.fadeIn()}}this.listenTo(view,"hoverIn",function($thumbnail){_this5._$attachments.find(".file").not($thumbnail.find(".file")[0]).addClass("faded")});this.listenTo(view,"hoverOut",function(){
return _this5._$attachments.find(".file").removeClass("faded")});view.on("beginEdit",function(){return _this5.model.incr("editCount")});view.on("endEdit",function(){return _this5.model.decr("editCount")});view.on("commentSaved",function(){return RB.DraftReviewBannerView.instance.show()})},_importFileAttachmentThumbnail:function _importFileAttachmentThumbnail(thumbnailEl){var $thumbnail=$(thumbnailEl);var id=$thumbnail.data("file-id");var $caption=$thumbnail.find(".file-caption .edit");var reviewRequest=this.model.get("reviewRequest");var fileAttachment=reviewRequest.draft.createFileAttachment({id:id});if(!$caption.hasClass("empty-caption")){fileAttachment.set("caption",$caption.text())}this.model.get("fileAttachments").add(fileAttachment,{$el:$thumbnail})},_importScreenshotThumbnail:function _importScreenshotThumbnail(thumbnailEl){var _this6=this;var $thumbnail=$(thumbnailEl);var id=$thumbnail.data("screenshot-id");var reviewRequest=this.model.get("reviewRequest");var screenshot=reviewRequest.createScreenshot(id);var view=new RB.ScreenshotThumbnail({el:$thumbnail,model:screenshot});view.render();this.model.get("screenshots").add(screenshot);view.on("beginEdit",function(){return _this6.model.incr("editCount")});view.on("endEdit",function(){return _this6.model.decr("editCount")})},_checkResizeLayout:function _checkResizeLayout(){if(this._$main.length!==0&&!this._blockResizeLayout){this._resizeLayout()}},_resizeLayout:function _resizeLayout(){var $lastContent=this._$main.children(".review-request-section:last-child");var $lastFieldContainer=$lastContent.children(".field-container");var $lastField=$lastFieldContainer.children(".editable");var lastFieldView=this._fieldViews[$lastField.data("field-id")];var lastContentTop=Math.ceil($lastContent.position().top);var editor=lastFieldView.inlineEditorView.textEditor;var detailsWidth=300;var detailsPadding=10;var $detailsBody=$("#review-request-details tbody");var $detailsLabels=$detailsBody.find("th:first-child");var $detailsValues=$detailsBody.find("span");this._blockResizeLayout=true;$detailsValues.css("max-width",detailsWidth-$detailsLabels.outerWidth()-detailsPadding*3+"px");this._$main.height("auto");$lastContent.height("auto");$lastField.height("auto");if(editor){editor.setSize(null,"auto")}this._$main.height(this._$extra.offset().top-this._$main.offset().top);var height=this._$main.height();if($lastContent.outerHeight()+lastContentTop<height){$lastContent.outerHeight(height-lastContentTop);var contentHeight=$lastContent.height()-Math.ceil($lastFieldContainer.position().top);if(lastFieldView.inlineEditorView.editing()&&editor){editor.setSize(null,contentHeight-lastFieldView.inlineEditorView.$buttons.height())}else{var newEditableHeight=contentHeight+$lastField.getExtents("m","tb");if(newEditableHeight>$lastField.outerHeight()){$lastField.outerHeight(newEditableHeight)}}}this._blockResizeLayout=false},_scheduleResizeLayout:_.throttleLayout(function(){this._checkResizeLayout()},{defer:true}),_onCloseDiscardedClicked:function _onCloseDiscardedClicked(){var _this7=this;var confirmText=gettext("Are you sure you want to discard this review request?");if(confirm(confirmText)){this.model.get("reviewRequest").close({type:RB.ReviewRequest.CLOSE_DISCARDED,error:function error(model,xhr){return _this7.model.trigger("closeError",xhr.errorText)}})}return false},_onCloseSubmittedClicked:function _onCloseSubmittedClicked(){var _this8=this;var submit=true;if(this.banner){submit=confirm(gettext("You have an unpublished draft. If you close this review request, the draft will be discarded. Are you sure you want to close the review request?"))}if(submit){this.model.get("reviewRequest").close({type:RB.ReviewRequest.CLOSE_SUBMITTED,error:function error(model,xhr){return _this8.model.trigger("closeError",xhr.errorText)}})}return false},_onDeleteReviewRequestClicked:function _onDeleteReviewRequestClicked(){var _this9=this;var $dlg=$("<p>").text(gettext("This deletion cannot be undone. All diffs and reviews will be deleted as well.")).modalBox({title:gettext("Are you sure you want to delete this review request?"),buttons:[$('<input type="button" value="'+gettext("Cancel")+'"/>'),$('<input type="button" value="'+gettext("Delete")+'"/>').click(function(){_this9.model.get("reviewRequest").destroy({buttons:$("input",$dlg.modalBox("buttons")),success:function success(){window.location=SITE_ROOT}})})]});return false},_onUpdateDiffClicked:function _onUpdateDiffClicked(){var reviewRequest=this.model.get("reviewRequest");var updateDiffView=new RB.UpdateDiffView({model:new RB.UploadDiffModel({changeNumber:reviewRequest.get("commitID"),repository:reviewRequest.get("repository"),reviewRequest:reviewRequest})});updateDiffView.render();return false},_onUploadFileClicked:function _onUploadFileClicked(e){e.stopPropagation();e.preventDefault();var uploadDialog=new RB.UploadAttachmentView({reviewRequest:this.model.get("reviewRequest")});uploadDialog.render()},_onArchiveClicked:function _onArchiveClicked(){return this._updateArchiveState(RB.UserSession.instance.archivedReviewRequests,true,RB.ReviewRequest.VISIBILITY_ARCHIVED)},_onUnarchiveClicked:function _onUnarchiveClicked(){return this._updateArchiveState(RB.UserSession.instance.archivedReviewRequests,false,RB.ReviewRequest.VISIBILITY_VISIBLE)},_onMuteClicked:function _onMuteClicked(){return this._updateArchiveState(RB.UserSession.instance.mutedReviewRequests,true,RB.ReviewRequest.VISIBILITY_MUTED)},_onUnmuteClicked:function _onUnmuteClicked(){return this._updateArchiveState(RB.UserSession.instance.mutedReviewRequests,false,RB.ReviewRequest.VISIBILITY_VISIBLE)},_updateArchiveState:function _updateArchiveState(collection,add,newState){var reviewRequest=this.model.get("reviewRequest");var options={success:function success(){return reviewRequest.set("visibility",newState)}};if(add){collection.addImmediately(reviewRequest,options,this)}else{collection.removeImmediately(reviewRequest,options,this)}return false},_updateArchiveVisibility:function _updateArchiveVisibility(){var visibility=this.model.get("reviewRequest").get("visibility");this.$("#hide-review-request-menu").html(this._archiveActionsTemplate({visibility:visibility,archiveText:gettext("Archive"),muteText:gettext("Mute"),unarchiveText:gettext("Unarchive"),unmuteText:gettext("Unmute")}));var iconClass=visibility===RB.ReviewRequest.VISIBILITY_VISIBLE?"rb-icon-archive-off":"rb-icon-archive-on";this.$("#hide-review-request-link").html('<span class="rb-icon '+iconClass+'"></span>')},_refreshPage:function _refreshPage(){window.location=this.model.get("reviewRequest").get("reviewURL")}})})();RB.ScreenshotThumbnail=Backbone.View.extend({events:{"click a.delete":"_onDeleteClicked"},render:function(){var self=this;this.model.on("destroy",function(){this.$el.fadeOut(function(){self.remove()})},this);this.$caption=this.$el.find("a.edit").inlineEditor({editIconClass:"rb-icon rb-icon-edit",showButtons:false}).on({beginEdit:function(){self.trigger("beginEdit")},cancel:function(){self.trigger("endEdit")},complete:function(e,value){self.model.ready({ready:function(){self.model.set("caption",value);self.trigger("endEdit");self.model.save()}})}});return this},_onDeleteClicked:function(e){e.preventDefault();e.stopPropagation();this.model.destroy()}});"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i["return"])_i["return"]()}finally{if(_d)throw _e}}return _arr}return function(arr,i){if(Array.isArray(arr)){return arr}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();(function(){var scalingFactors=new Map([[.33,"33%"],[.5,"50%"],[1,"100%"],[2,"200%"]]);var BaseImageView=Backbone.View.extend({template:null,mode:null,name:null,initialize:function initialize(){var _this=this;this.$commentRegion=null;this.listenTo(this.model,"change:scale",function(model,scale){return _this._onScaleChanged(scale)})},className:function className(){return"image-diff-"+this.mode},loadImages:function loadImages($images){var _this2=this;var scale=this.model.get("scale");var loadsRemaining=$images.length;this._$images=$images;$images.each(function(ix,image){var $image=$(image);if($image.data("initial-width")===undefined){image.onload=function(){loadsRemaining--;console.assert(loadsRemaining>=0);$image.data({"initial-width":image.width,"initial-height":image.height}).css({width:image.width*scale,height:image.height*scale});if(loadsRemaining===0){_this2.onImagesLoaded();_this2.trigger("regionChanged")}}}else{loadsRemaining--;if(loadsRemaining===0){_this2.onImagesLoaded();_this2.trigger("regionChanged")}}})},getSelectionRegion:function getSelectionRegion(){var $region=this.$commentRegion;var offset=$region.position();offset.left+=$region.getExtents("m","l");return{left:offset.left,top:offset.top,width:$region.width(),height:$region.height()}},onImagesLoaded:function onImagesLoaded(){var scale=null;var filename=this.model.get("filename");if(filename){if(filename.includes("@2x.")){scale=.5}else if(filename.includes("@3x.")){scale=.33}}if(scale===null){var _getInitialSize=this.getInitialSize(),width=_getInitialSize.width;var maxWidth=this.$el.closest(".image-content").width();var scales=Array.from(scalingFactors.keys()).filter(function(f){return f<=1});for(var i=scales.length-1;i>=0;i--){scale=scales[i];if(width*scale<=maxWidth){break}}}this.model.set("scale",scale)},_onScaleChanged:function _onScaleChanged(scale){this._$images.each(function(index,el){var $image=$(el);$image.css({width:$image.data("initial-width")*scale,height:$image.data("initial-height")*scale})})},getInitialSize:function getInitialSize(){console.assert(false,"subclass of BaseImageView must implement getInitialSize")}});var ImageAttachmentView=BaseImageView.extend({mode:"attachment",tagName:"img",render:function render(){this.$el.attr({title:this.model.get("caption"),src:this.model.get("imageURL")});this.$commentRegion=this.$el;this.loadImages(this.$el);return this},getInitialSize:function getInitialSize(){var $img=this._$images.eq(0);return{width:$img.data("initial-width"),height:$img.height("initial-height")}}});var ImageDifferenceDiffView=BaseImageView.extend({mode:"difference",name:gettext("Difference"),template:_.template(['<div class="image-container">'," <canvas></canvas>","</div>"].join("")),initialize:function initialize(){_super(this).initialize.call(this);this._origImage=null;this._modifiedImage=null},render:function render(){this.$el.html(this.template(this.model.attributes));this.$commentRegion=this.$("canvas");this._$canvas=this.$commentRegion;this._origImage=new Image;this._origImage.src=this.model.get("diffAgainstImageURL");this._modifiedImage=new Image;this._modifiedImage.src=this.model.get("imageURL");this.loadImages($([this._origImage,this._modifiedImage]));return this},onImagesLoaded:function onImagesLoaded(){var origImage=this._origImage;var modifiedImage=this._modifiedImage;var scale=this.model.get("scale");this._maxWidth=Math.max(origImage.width,modifiedImage.width);this._maxHeight=Math.max(origImage.height,modifiedImage.height);_super(this).onImagesLoaded.call(this);this._$canvas.attr({width:this._maxWidth,height:this._maxHeight}).css({width:this._maxWidth*scale+"px",height:this._maxHeight*scale+"px"});var $modifiedCanvas=$("<canvas/>").attr({width:this._maxWidth,height:this._maxHeight});var origContext=this._$canvas[0].getContext("2d");origContext.drawImage(origImage,0,0);var modifiedContext=$modifiedCanvas[0].getContext("2d");modifiedContext.drawImage(modifiedImage,0,0);var origImageData=origContext.getImageData(0,0,this._maxWidth,this._maxHeight);var origPixels=origImageData.data;var modifiedPixels=modifiedContext.getImageData(0,0,this._maxWidth,this._maxHeight).data;for(var i=0;i<origPixels.length;i+=4){origPixels[i]+=modifiedPixels[i]-2*Math.min(origPixels[i],modifiedPixels[i]);origPixels[i+1]+=modifiedPixels[i+1]-2*Math.min(origPixels[i+1],modifiedPixels[i+1]);origPixels[i+2]+=modifiedPixels[i+2]-2*Math.min(origPixels[i+2],modifiedPixels[i+2]);origPixels[i+3]=modifiedPixels[i+3]}origContext.putImageData(origImageData,0,0)},_onScaleChanged:function _onScaleChanged(scale){this._$canvas.css({width:this._maxWidth*scale+"px",height:this._maxHeight*scale+"px"})},getInitialSize:function getInitialSize(){return{width:this._maxWidth,height:this._maxHeight}}});var ImageOnionDiffView=BaseImageView.extend({mode:"onion",name:gettext("Onion Skin"),template:_.template(['<div class="image-containers">',' <div class="orig-image">','  <img title="<%- caption %>" src="<%- diffAgainstImageURL %>" />'," </div>",' <div class="modified-image">','  <img title="<%- caption %>" src="<%- imageURL %>" />'," </div>","</div>",'<div class="image-slider"></div>'].join("")),DEFAULT_OPACITY:.25,initialize:function initialize(){_super(this).initialize.call(this);this._$origImage=null;this._$modifiedImage=null;this._$modifiedImageContainer=null},render:function render(){var _this3=this;this.$el.html(this.template(this.model.attributes));this.$commentRegion=this.$(".image-containers");this._$origImage=this.$(".orig-image img");this._$modifiedImage=this.$(".modified-image img");this._$modifiedImageContainer=this._$modifiedImage.parent();this.$(".image-slider").slider({value:this.DEFAULT_OPACITY*100,slide:function slide(e,ui){return _this3.setOpacity(ui.value/100)}});this.setOpacity(this.DEFAULT_OPACITY);this.loadImages(this.$("img"));return this},setOpacity:function setOpacity(percentage){this._$modifiedImageContainer.css("opacity",percentage)},onImagesLoaded:function onImagesLoaded(){_super(this).onImagesLoaded.call(this);this._resize()},_onScaleChanged:function _onScaleChanged(scale){_super(this)._onScaleChanged.call(this,scale);this._resize()},_resize:function _resize(){var scale=this.model.get("scale");var origW=this._$origImage.data("initial-width")*scale;var origH=this._$origImage.data("initial-height")*scale;var newW=this._$modifiedImage.data("initial-width")*scale;var newH=this._$modifiedImage.data("initial-height")*scale;this._$origImage.parent().width(origW).height(origH);this._$modifiedImage.parent().width(newW).height(newH);this.$(".image-containers").width(Math.max(origW,newW)).height(Math.max(origH,newH))},getInitialSize:function getInitialSize(){return{width:Math.max(this._$origImage.data("initial-width"),this._$modifiedImage.data("initial-width")),height:Math.max(this._$origImage.data("initial-height"),this._$modifiedImage.data("initial-height"))}}});var ImageSplitDiffView=BaseImageView.extend({mode:"split",name:gettext("Split"),template:_.template(['<div class="image-containers">',' <div class="image-diff-split-container-orig">','  <div class="orig-image">','   <img title="<%- caption %>" src="<%- diffAgainstImageURL %>" />',"  </div>"," </div>",' <div class="image-diff-split-container-modified">','  <div class="modified-image">','   <img title="<%- caption %>" src="<%- imageURL %>" />',"  </div>"," </div>","</div>",'<div class="image-slider"></div>'].join("")),DEFAULT_SPLIT_PCT:.25,initialize:function initialize(){_super(this).initialize.call(this);this._$modifiedImage=null;this._$origImage=null;this._$origSplitContainer=null;this._$modifiedSplitContainer=null;this._$slider=null;this._maxWidth=0},render:function render(){var _this4=this;this.$el.html(this.template(this.model.attributes));this.$commentRegion=this.$(".image-containers");this._$origImage=this.$(".orig-image img");this._$modifiedImage=this.$(".modified-image img");this._$origSplitContainer=this.$(".image-diff-split-container-orig");this._$modifiedSplitContainer=this.$(".image-diff-split-container-modified");this._$slider=this.$(".image-slider").slider({value:this.DEFAULT_SPLIT_PCT*100,slide:function slide(e,ui){return _this4.setSplitPercentage(ui.value/100)}});this.loadImages(this.$("img"));return this},setSplitPercentage:function setSplitPercentage(percentage){this._$origSplitContainer.outerWidth(this._maxWidth*percentage);this._$modifiedSplitContainer.outerWidth(this._maxWidth*(1-percentage))},onImagesLoaded:function onImagesLoaded(){_super(this).onImagesLoaded.call(this);this._resize()},_onScaleChanged:function _onScaleChanged(scale){_super(this)._onScaleChanged.call(this,scale);this._resize()},_resize:function _resize(){var $origImageContainer=this._$origImage.parent();var scale=this.model.get("scale");var origW=this._$origImage.data("initial-width")*scale;var origH=this._$origImage.data("initial-height")*scale;var newW=this._$modifiedImage.data("initial-width")*scale;var newH=this._$modifiedImage.data("initial-height")*scale;var maxH=Math.max(origH,newH);var maxOuterH=maxH+$origImageContainer.getExtents("b","tb");this._maxWidth=Math.max(origW,newW);this._maxHeight=Math.max(origH,newH);$origImageContainer.outerWidth(origW).height(origH);this._$modifiedImage.parent().outerWidth(newW).height(newH);this._$origSplitContainer.outerWidth(this._maxWidth).height(maxOuterH);this._$modifiedSplitContainer.outerWidth(this._maxWidth).height(maxOuterH);this.$(".image-containers").width(this._maxWidth).height(maxH);this._$slider.width(this._maxWidth);this.setSplitPercentage(this.DEFAULT_SPLIT_PCT)},getInitialSize:function getInitialSize(){return{width:this._maxWidth,height:this._maxHeight}}});var ImageTwoUpDiffView=BaseImageView.extend({mode:"two-up",name:gettext("Two-Up"),template:_.template(['<div class="image-container image-container-orig">',' <div class="orig-image">','  <img title="<%- caption %>" src="<%- diffAgainstImageURL %>" />'," </div>","</div>",'<div class="image-container image-container-modified">',' <div class="modified-image">','  <img title="<%- caption %>" src="<%- imageURL %>" />'," </div>","</div>"].join("")),render:function render(){this.$el.html(this.template(this.model.attributes));this.$commentRegion=this.$(".modified-image img");this._$origImage=this.$(".orig-image img");this._$modifiedImage=this.$(".modified-image img");this.loadImages(this.$("img"));return this},getInitialSize:function getInitialSize(){return{width:Math.max(this._$origImage.data("initial-width"),this._$modifiedImage.data("initial-width")),height:Math.max(this._$origImage.data("initial-height"),this._$modifiedImage.data("initial-height"))}}});RB.ImageReviewableView=RB.FileAttachmentReviewableView.extend({className:"image-review-ui",commentBlockView:RB.RegionCommentBlockView,events:{"click .image-diff-mode":"_onImageModeClicked","click .image-resolution-menu .menu-item":"_onImageZoomLevelClicked","mousedown .selection-container":"_onMouseDown","mouseup .selection-container":"_onMouseUp","mousemove .selection-container":"_onMouseMove"},modeItemTemplate:_.template('<li><a class="image-diff-mode" href="#" data-mode="<%- mode %>"><%- name %></a></li>'),captionTableTemplate:_.template("<table><tr><%= items %></tr></table>"),captionItemTemplate:_.template(["<td>",' <h1 class="caption">',"  <%- caption %>"," </h1>","</td>"].join("")),errorTemplate:_.template(['<div class="review-ui-error">',' <div class="rb-icon rb-icon-warning"></div>'," <%- errorStr %>","</div>"].join("")),ANIM_SPEED_MS:200,initialize:function initialize(){var _this5=this;RB.FileAttachmentReviewableView.prototype.initialize.apply(this,arguments);_.bindAll(this,"_adjustPos");this._activeSelection={};this._diffModeSelectors={};this._diffModeViews={};this._commentBlockViews=[];this.on("commentBlockViewAdded",function(commentBlockView){commentBlockView.setSelectionRegionSizeFunc(function(){return _.pick(_this5._imageView.getSelectionRegion(),"width","height")});commentBlockView.setScale(_this5.model.get("scale"));_this5._$selectionArea.append(commentBlockView.$el);_this5._commentBlockViews.push(commentBlockView);_this5.listenTo(commentBlockView,"removing",function(){_this5._commentBlockViews=_.without(_this5._commentBlockViews,commentBlockView)})});this.listenTo(this.model,"change:scale",function(model,scale){_this5._commentBlockViews.forEach(function(view){return view.setScale(scale)});_this5.$(".image-resolution-menu-current").text(scalingFactors.get(scale));_.defer(_this5._adjustPos)})},renderContent:function renderContent(){var _this6=this;var hasDiff=!!this.model.get("diffAgainstFileAttachmentID");this._$selectionArea=$("<div/>").addClass("selection-container").hide().proxyTouchEvents();this._$selectionRect=$("<div/>").addClass("selection-rect").prependTo(this._$selectionArea).proxyTouchEvents().hide();this.$el.hover(function(){_this6._$selectionArea.show();_this6._adjustPos()},function(){if(_this6._$selectionRect.is(":hidden")&&!_this6.commentDlg){_this6._$selectionArea.hide()}});var $wrapper=$('<div class="image-content" />').append(this._$selectionArea);if(this.model.get("diffTypeMismatch")){this.$el.append(this.errorTemplate({errorStr:gettext("These revisions cannot be compared because they are different file types.")}))}else if(hasDiff){this._$modeBar=$('<ul class="image-diff-modes"/>').appendTo(this.$el);this._$imageDiffs=$('<div class="image-diffs"/>');this._addDiffMode(ImageTwoUpDiffView);this._addDiffMode(ImageDifferenceDiffView);this._addDiffMode(ImageSplitDiffView);this._addDiffMode(ImageOnionDiffView);$wrapper.append(this._$imageDiffs).appendTo(this.$el);this._setDiffMode(ImageTwoUpDiffView.prototype.mode)}else{this._imageView=new ImageAttachmentView({model:this.model});$wrapper.append(this._imageView.$el).appendTo(this.$el);this._imageView.render()}$(window).resize(this._adjustPos).load(this._adjustPos);var $header=$("<div />").addClass("review-ui-header").prependTo(this.$el);if(this.model.get("numRevisions")>1){var $revisionLabel=$('<div id="revision_label" />').appendTo($header);this._revisionLabelView=new RB.FileAttachmentRevisionLabelView({el:$revisionLabel,model:this.model});this._revisionLabelView.render();this.listenTo(this._revisionLabelView,"revisionSelected",this._onRevisionSelected);var $revisionSelector=$('<div id="attachment_revision_selector" />').appendTo($header);this._revisionSelectorView=new RB.FileAttachmentRevisionSelectorView({el:$revisionSelector,model:this.model});this._revisionSelectorView.render();this.listenTo(this._revisionSelectorView,"revisionSelected",this._onRevisionSelected);if(!this.renderedInline){if(hasDiff){var captionItems=[this.captionItemTemplate({caption:interpolate(gettext("%(caption)s (revision %(revision)s)"),{caption:this.model.get("diffCaption"),revision:this.model.get("diffRevision")},true)}),this.captionItemTemplate({caption:interpolate(gettext("%(caption)s (revision %(revision)s)"),{caption:this.model.get("caption"),revision:this.model.get("fileRevision")},true)})];$header.append(this.captionTableTemplate({items:captionItems.join("")}))}else{var $captionBar=$('<div class="image-single-revision">').appendTo($header);$('<h1 class="caption" />').text(interpolate(gettext("%(caption)s (revision %(revision)s)"),{caption:this.model.get("caption"),revision:this.model.get("fileRevision")},true)).appendTo($captionBar)}}}else{if(!this.renderedInline){$header.addClass("image-single-revision");$('<h1 class="caption" />').text(this.model.get("caption")).appendTo($header)}}var $resolutionMenu=$(['<li class="image-resolution-menu has-menu">',' <a href="#" class="menu-header">','  <span class="fa fa-search-plus"></span>','  <span class="image-resolution-menu-current">100%</span>','  <span class="rb-icon rb-icon-dropdown-arrow">'," </a>",' <ul class="menu" />',"</li>"].join(""));var $menu=$resolutionMenu.find(".menu");scalingFactors.forEach(function(text,scale){$('<li class="menu-item" data-image-scale="'+scale+'" />').text(text).appendTo($menu)});if(hasDiff){this._$modeBar.append($resolutionMenu)}else{this.$(".caption").after($resolutionMenu)}},_onRevisionSelected:function _onRevisionSelected(revisions){var revisionIDs=this.model.get("attachmentRevisionIDs");var _revisions=_slicedToArray(revisions,2),base=_revisions[0],tip=_revisions[1];if(tip===0){return}var revisionTip=revisionIDs[tip-1];var redirectURL=void 0;if(base===0){redirectURL="../"+revisionTip+"/"}else{var revisionBase=revisionIDs[base-1];redirectURL="../"+revisionBase+"-"+revisionTip+"/"}window.location.replace(redirectURL)},_addDiffMode:function _addDiffMode(ViewClass){var mode=ViewClass.prototype.mode;var view=new ViewClass({model:this.model});this._diffModeViews[mode]=view;view.$el.hide();this._$imageDiffs.append(view.$el);view.render();var $selector=$(this.modeItemTemplate({mode:mode,name:view.name}));$selector.appendTo(this._$modeBar).addClass("selected");var selectorWidth=$selector.outerWidth(true);$selector.removeClass("selected").width(selectorWidth);this._diffModeSelectors[mode]=$selector},_setDiffMode:function _setDiffMode(mode){var _this7=this;var newView=this._diffModeViews[mode];if(this._imageView){this._diffModeSelectors[this._imageView.mode].removeClass("selected");newView.$el.show();var height=newView.$el.height();newView.$el.hide();this._$imageDiffs.animate({height:height,duration:this.ANIM_SPEED_MS});this._$selectionArea.fadeOut(this.ANIM_SPEED_MS);this._imageView.$el.fadeOut(this.ANIM_SPEED_MS,function(){return _this7._showDiffMode(newView,true)})}else{this._showDiffMode(newView)}this._diffModeSelectors[newView.mode].addClass("selected")},_showDiffMode:function _showDiffMode(newView,animate){if(this._imageView){this.stopListening(this._imageView,"regionChanged")}this._imageView=newView;if(animate){this._imageView.$el.fadeIn(this.ANIM_SPEED_MS);this._$selectionArea.fadeIn(this.ANIM_SPEED_MS)}else{this._imageView.$el.show();this._$selectionArea.show()}this.listenTo(this._imageView,"regionChanged",this._adjustPos);this._adjustPos()},_onImageModeClicked:function _onImageModeClicked(e){e.preventDefault();e.stopPropagation();this._setDiffMode($(e.target).data("mode"))},_onImageZoomLevelClicked:function _onImageZoomLevelClicked(e){e.preventDefault();e.stopPropagation();this.model.set("scale",$(e.target).data("image-scale"))},_onMouseDown:function _onMouseDown(e){if(e.which===1&&!this.commentDlg&&!$(e.target).hasClass("selection-flag")){var offset=this._$selectionArea.offset();this._activeSelection.beginX=e.pageX-Math.floor(offset.left)-1;this._activeSelection.beginY=e.pageY-Math.floor(offset.top)-1;var updateData={left:this._activeSelection.beginX,top:this._activeSelection.beginY,width:1,height:1};this._$selectionRect.css(updateData).data(updateData).show();if(this._$selectionRect.is(":hidden")){this.commentDlg.close()}return false}},_onMouseUp:function _onMouseUp(e){if(!this.commentDlg&&this._$selectionRect.is(":visible")){e.stopPropagation();this._$selectionRect.hide();var position=this._$selectionRect.data();var scale=this.model.get("scale");if(position.width>5&&position.height>5){this.createAndEditCommentBlock({x:Math.floor(position.left/scale),y:Math.floor(position.top/scale),width:Math.floor(position.width/scale),height:Math.floor(position.height/scale)})}}},_onMouseMove:function _onMouseMove(e){if(!this.commentDlg&&this._$selectionRect.is(":visible")){var offset=this._$selectionArea.offset();var x=e.pageX-Math.floor(offset.left)-1;var y=e.pageY-Math.floor(offset.top)-1;var updateData={};if(this._activeSelection.beginX<=x){updateData.left=this._activeSelection.beginX;updateData.width=x-this._activeSelection.beginX}else{updateData.left=x;updateData.width=this._activeSelection.beginX-x}if(this._activeSelection.beginY<=y){updateData.top=this._activeSelection.beginY;updateData.height=y-this._activeSelection.beginY}else{updateData.top=y;updateData.height=this._activeSelection.beginY-y}this._$selectionRect.css(updateData).data(updateData);return false}},_adjustPos:function _adjustPos(){var region=this._imageView.getSelectionRegion();this._$selectionArea.width(region.width).height(region.height).css({left:region.left,top:region.top});if(this._$imageDiffs){this._$imageDiffs.height(this._imageView.$el.height())}}})})();"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i["return"])_i["return"]()}finally{if(_d)throw _e}}return _arr}return function(arr,i){if(Array.isArray(arr)){return arr}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();RB.DummyReviewableView=RB.FileAttachmentReviewableView.extend({commentBlockView:RB.AbstractCommentBlockView,captionTableTemplate:_.template("<table><tr><%= items %></tr></table>"),captionItemTemplate:_.template('<td>\n <h1 class="caption"><%- caption %></h1>\n</td>'),renderContent:function renderContent(){var $header=$("<div/>").addClass("review-ui-header").prependTo(this.$el);if(this.model.get("numRevisions")>1){var $revisionLabel=$('<div id="revision_label"/>').appendTo($header);this._revisionLabelView=new RB.FileAttachmentRevisionLabelView({el:$revisionLabel,model:this.model});this._revisionLabelView.render();this.listenTo(this._revisionLabelView,"revisionSelected",this._onRevisionSelected);var $revisionSelector=$('<div id="attachment_revision_selector" />').appendTo($header);this._revisionSelectorView=new RB.FileAttachmentRevisionSelectorView({el:$revisionSelector,model:this.model});this._revisionSelectorView.render();this.listenTo(this._revisionSelectorView,"revisionSelected",this._onRevisionSelected);var captionItems=[];captionItems.push(this.captionItemTemplate({caption:interpolate(gettext("%(caption)s (revision %(revision)s)"),{caption:this.model.get("caption"),revision:this.model.get("fileRevision")},true)}));if(this.model.get("diffAgainstFileAttachmentID")!==null){captionItems.push(this.captionItemTemplate({caption:interpolate(gettext("%(caption)s (revision %(revision)s)"),{caption:this.model.get("diffCaption"),revision:this.model.get("diffRevision")},true)}))}$header.append(this.captionTableTemplate({items:captionItems.join("")}))}else{$('<h1 class="caption file-attachment-single-revision">').text(this.model.get("caption")).appendTo($header)}},_onRevisionSelected:function _onRevisionSelected(revisions){var _revisions=_slicedToArray(revisions,2),base=_revisions[0],tip=_revisions[1];if(tip===0){return}var revisionIDs=this.model.get("attachmentRevisionIDs");var revisionTip=revisionIDs[tip-1];var redirectURL=void 0;if(base===0){redirectURL="../"+revisionTip+"/"}else{var revisionBase=revisionIDs[base-1];redirectURL="../"+revisionBase+"-"+revisionTip+"/"}window.location.replace(redirectURL)}});"use strict";RB.TextBasedCommentBlockView=RB.AbstractCommentBlockView.extend({tagName:"span",className:"commentflag",template:_.template('<span class="commentflag-shadow"></span>\n<span class="commentflag-inner">\n <span class="commentflag-count"></span>\n</span>\n<a name="<%= anchorName %>" class="commentflag-anchor"></a>'),initialize:function initialize(){this.$beginRow=null;this.$endRow=null;this._$window=$(window);this._prevCommentHeight=null;this._prevWindowWidth=null;this._resizeRegistered=false},renderContent:function renderContent(){this.$el.html(this.template(_.defaults(this.model.attributes,{anchorName:this.buildAnchorName()})));this.$(".commentflag-count").bindProperty("text",this.model,"count",{elementToModel:false})},remove:function remove(){Backbone.View.prototype.remove.call(this);if(this._resizeRegistered){this._$window.off("resize."+this.cid)}},setRows:function setRows($beginRow,$endRow){this.$beginRow=$beginRow;this.$endRow=$endRow;_.defer(_.bind(function(){this._updateSize();this.$el.show()},this));if($beginRow&&$endRow){if(!this._resizeRegistered){this._$window.on("resize."+this.cid,_.bind(this._updateSize,this))}}else{if(this._resizeRegistered){this._$window.off("resize."+this.cid)}}},positionCommentDlg:function positionCommentDlg(commentDlg){commentDlg.$el.css({
left:$(document).scrollLeft()+(this._$window.width()-commentDlg.$el.width())/2,top:this.$endRow.offset().top+this.$endRow.height()})},positionNotifyBubble:function positionNotifyBubble($bubble){$bubble.css({left:this.$el.width(),top:0})},buildAnchorName:function buildAnchorName(){return"line"+this.model.get("beginLineNum")},_updateSize:function _updateSize(){var windowWidth=this._$window.width();if(this._prevWindowWidth===windowWidth){return}this._prevWindowWidth=windowWidth;var commentHeight=this.$endRow.offset().top+this.$endRow.outerHeight()-this.$beginRow.offset().top-(this.$el.getExtents("m","t")||-4);if(commentHeight!==this._prevCommentHeight){this.$el.height(commentHeight);this._prevCommentHeight=commentHeight}}});"use strict";var _slicedToArray=function(){function sliceIterator(arr,i){var _arr=[];var _n=true;var _d=false;var _e=undefined;try{for(var _i=arr[Symbol.iterator](),_s;!(_n=(_s=_i.next()).done);_n=true){_arr.push(_s.value);if(i&&_arr.length===i)break}}catch(err){_d=true;_e=err}finally{try{if(!_n&&_i["return"])_i["return"]()}finally{if(_d)throw _e}}return _arr}return function(arr,i){if(Array.isArray(arr)){return arr}else if(Symbol.iterator in Object(arr)){return sliceIterator(arr,i)}else{throw new TypeError("Invalid attempt to destructure non-iterable instance")}}}();RB.TextBasedReviewableView=RB.FileAttachmentReviewableView.extend({commentBlockView:RB.TextBasedCommentBlockView,initialize:function initialize(options){var _this=this;RB.FileAttachmentReviewableView.prototype.initialize.call(this,options);this._$viewTabs=null;this._$textTable=null;this._$renderedTable=null;this._textSelector=null;this._renderedSelector=null;this.on("commentBlockViewAdded",this._placeCommentBlockView,this);this.router=new Backbone.Router({routes:{":viewMode(/line:lineNum)":"viewMode"}});this.listenTo(this.router,"route:viewMode",function(viewMode,lineNum){if(viewMode.indexOf("line")===0){lineNum=viewMode.substr(4);viewMode=null}if(viewMode){_this.model.set("viewMode",viewMode)}if(lineNum){_this._scrollToLine(lineNum)}})},remove:function remove(){_super(this).remove.call(this);this._textSelector.remove();this._renderedSelector.remove()},renderContent:function renderContent(){this._$viewTabs=this.$(".text-review-ui-views li");this._$textTable=this.$(".text-review-ui-text-table");this._textSelector=new RB.TextCommentRowSelector({el:this._$textTable,reviewableView:this});this._textSelector.render();if(this.model.get("hasRenderedView")){this._$renderedTable=this.$(".text-review-ui-rendered-table");this._renderedSelector=new RB.TextCommentRowSelector({el:this._$renderedTable,reviewableView:this});this._renderedSelector.render()}this.listenTo(this.model,"change:viewMode",this._onViewChanged);var $fileHeader=this.$(".review-ui-header");if(this.model.get("numRevisions")>1){this._revisionSelectorView=new RB.FileAttachmentRevisionSelectorView({el:$fileHeader.find("#attachment_revision_selector"),model:this.model});this._revisionSelectorView.render();this.listenTo(this._revisionSelectorView,"revisionSelected",this._onRevisionSelected);this._revisionLabelView=new RB.FileAttachmentRevisionLabelView({el:$fileHeader.find("#revision_label"),model:this.model});this._revisionLabelView.render();this.listenTo(this._revisionLabelView,"revisionSelected",this._onRevisionSelected)}Backbone.history.start({root:window.location})},_onRevisionSelected:function _onRevisionSelected(revisions){var _revisions=_slicedToArray(revisions,2),base=_revisions[0],tip=_revisions[1];if(tip===0){return}var revisionIDs=this.model.get("attachmentRevisionIDs");var revisionTip=revisionIDs[tip-1];var redirectURL=void 0;if(base===0){redirectURL="../"+revisionTip+"/"}else{var revisionBase=revisionIDs[base-1];redirectURL="../"+revisionBase+"-"+revisionTip+"/"}window.location.replace(redirectURL)},_scrollToLine:function _scrollToLine(lineNum){var $table=this._getTableForViewMode(this.model.get("viewMode"));var rows=$table[0].tBodies[0].rows;lineNum=RB.MathUtils.clip(lineNum,1,rows.length)-1;var $row=$($table[0].tBodies[0].rows[lineNum]);$(window).scrollTop($row.offset().top)},_getTableForViewMode:function _getTableForViewMode(viewMode){if(viewMode==="source"){return this._$textTable}else if(viewMode==="rendered"&&this.model.get("hasRenderedView")){return this._$renderedTable}else{console.assert(false,"Unexpected viewMode "+viewMode);return null}},_getRowSelectorForViewMode:function _getRowSelectorForViewMode(viewMode){if(viewMode==="source"){return this._textSelector}else if(viewMode==="rendered"&&this.model.get("hasRenderedView")){return this._renderedSelector}else{console.assert(false,"Unexpected viewMode "+viewMode);return null}},_placeCommentBlockView:function _placeCommentBlockView(commentBlockView){var commentBlock=commentBlockView.model;var beginLineNum=commentBlock.get("beginLineNum");var endLineNum=commentBlock.get("endLineNum");if(beginLineNum&&endLineNum){var viewMode=commentBlock.get("viewMode");var rowSelector=this._getRowSelectorForViewMode(viewMode);if(!rowSelector){return}var rowEls=void 0;if(this.model.get("diffRevision")){rowEls=rowSelector.getRowsForRange(beginLineNum,endLineNum)}else{var rows=rowSelector.el.tBodies[0].rows;rowEls=[rows[beginLineNum-1],rows[endLineNum-1]]}if(rowEls){commentBlockView.setRows($(rowEls[0]),$(rowEls[1]));commentBlockView.$el.appendTo(commentBlockView.$beginRow[0].cells[0])}}},_onViewChanged:function _onViewChanged(){var viewMode=this.model.get("viewMode");this._$viewTabs.removeClass("active").filter("[data-view-mode="+viewMode+"]").addClass("active");this._$textTable.setVisible(viewMode==="source");this._$renderedTable.setVisible(viewMode==="rendered");$(window).triggerHandler("resize")}});(function(){RB.TextCommentRowSelector=Backbone.View.extend({ghostCommentFlagTemplate:_.template(['<span class="commentflag ghost-commentflag">',' <span class="commentflag-shadow"></span>',' <span class="commentflag-inner"></span>',"</span>"].join("")),events:{copy:"_onCopy",mousedown:"_onMouseDown",mouseup:"_onMouseUp",mouseover:"_onMouseOver",mouseout:"_onMouseOut",touchstart:"_onTouchStart",touchend:"_onTouchEnd",touchmove:"_onTouchMove",touchcancel:"_onTouchCancel"},initialize:function(){this._$begin=null;this._$end=null;this._beginLineNum=0;this._endLineNum=0;this._lastSeenIndex=0;this._selectionClass=null;this._supportsSetClipboard=window.getSelection!==undefined&&window.Range!==undefined&&window.Range.prototype.cloneContents!==undefined;this._newlineChar=null;this._$ghostCommentFlag=null;this._$ghostCommentFlagCell=null},remove:function(){Backbone.View.prototype.remove.call(this);this._$ghostCommentFlag.remove()},render:function(){this._$ghostCommentFlag=$(this.ghostCommentFlagTemplate()).on({mousedown:_.bind(this._onMouseDown,this),mouseup:_.bind(this._onMouseUp,this),mouseover:_.bind(this._onMouseOver,this),mouseout:_.bind(this._onMouseOut,this)}).hide().appendTo("body");return this},createComment:function(beginLineNum,endLineNum,beginNode,endNode){this._beginLineNum=beginLineNum;this._endLineNum=endLineNum;this._$begin=this._getActualLineNumCell($(beginNode)).parent();this._$end=this._getActualLineNumCell($(endNode)).parent();if(this._isLineNumCell(endNode)){this._end(this._getActualLineNumCell($(endNode)).parent())}this._reset()},getRowsForRange:function(beginLineNum,endLineNum,minRowIndex){var beginRowEl=this.findLineNumRow(beginLineNum,minRowIndex),endRowEl,rowIndex;if(beginRowEl){rowIndex=beginRowEl.rowIndex;endRowEl=endLineNum===beginLineNum?beginRowEl:this.findLineNumRow(endLineNum,rowIndex,rowIndex+endLineNum-beginLineNum);return[beginRowEl,endRowEl]}else{return null}},findLineNumRow:function(lineNum,startRow,endRow){var row=null,table=this.el,rowOffset=1,guessRowNum,guessRow,oldHigh,oldLow,high,low,value,found,i,j;if(table.rows.length-rowOffset>lineNum){row=table.rows[rowOffset+lineNum];if(row&&this.getLineNum(row)===lineNum){return row}}if(startRow){startRow-=rowOffset}low=startRow||0;high=Math.min(endRow||table.rows.length,table.rows.length);if(endRow!==undefined&&endRow<table.rows.length){if(this.getLineNum(table.rows[endRow])===lineNum){return table.rows[endRow]}}else if(row){high=Math.min(high,rowOffset+lineNum)}for(i=Math.round((low+high)/2);low<high-1;){row=table.rows[rowOffset+i];if(!row){high--;i=Math.round((low+high)/2);continue}value=this.getLineNum(row);if(!value){found=false;for(j=1;j<=(high-low)/2;j++){row=table.rows[rowOffset+i+j];if(row&&this.getLineNum(row)){i=i+j;found=true;break}else{row=table.rows[rowOffset+i-j];if(row&&this.getLineNum(row)){i=i-j;found=true;break}}}if(found){value=this.getLineNum(row)}else{return null}}guessRowNum=lineNum-value+rowOffset+i;if(guessRowNum>=0&&guessRowNum<table.rows.length){guessRow=table.rows[guessRowNum];if(guessRow&&this.getLineNum(guessRow)===lineNum){return guessRow}}oldHigh=high;oldLow=low;if(value>lineNum){high=i}else if(value<lineNum){low=i}else{return row}if(oldHigh===high&&oldLow===low){break}i=Math.round((low+high)/2)}return null},_begin:function($row){var lineNum=this.getLineNum($row[0]);this._$begin=$row;this._$end=$row;this._beginLineNum=lineNum;this._endLineNum=lineNum;this._lastSeenIndex=$row[0].rowIndex;$row.addClass("selected");this.$el.disableSelection()},_end:function($row){var $commentFlag;if(this._beginLineNum===this._endLineNum){$commentFlag=$row.find(".commentflag");if($commentFlag.length===1){$commentFlag.click();return}}this.options.reviewableView.createAndEditCommentBlock({beginLineNum:this._beginLineNum,endLineNum:this._endLineNum,$beginRow:this._$begin,$endRow:this._$end})},_addRow:function($row){var lineNum,min,max,i;lineNum=this.getLineNum($row[0]);if(lineNum<this._beginLineNum){this._$begin=$row;this._beginLineNum=lineNum}else if(lineNum>this._beginLineNum){this._$end=$row;this._endLineNum=lineNum}min=Math.min(this._lastSeenIndex,$row[0].rowIndex);max=Math.max(this._lastSeenIndex,$row[0].rowIndex);for(i=min;i<=max;i++){$(this.el.rows[i]).addClass("selected")}this._lastSeenIndex=$row[0].rowIndex},_highlightRow:function($row){var $lineNumCell=$($row[0].cells[0]);if($lineNumCell.find(".commentflag").length===0){this._$ghostCommentFlag.css("top",$row.offset().top-1).show().parent().removeClass("selected");this._$ghostCommentFlagCell=$lineNumCell}$row.addClass("selected")},_removeOldRows:function($row){var destRowIndex=$row[0].rowIndex;if(destRowIndex>=this._$begin[0].rowIndex){if(this._lastSeenIndex!==this._$end[0].rowIndex&&this._lastSeenIndex<destRowIndex){this._removeSelectionClasses(this._lastSeenIndex,destRowIndex);this._$begin=$row;this._beginLineNum=this.getLineNum($row[0])}else{this._removeSelectionClasses(destRowIndex,this._lastSeenIndex);this._$end=$row;this._endLineNum=this.getLineNum($row[0])}this._lastSeenIndex=destRowIndex}},_reset:function(){if(this._$begin){this._removeSelectionClasses(this._$begin[0].rowIndex,this._$end[0].rowIndex);this._$begin=null;this._$end=null;this._beginLineNum=0;this._endLineNum=0;this._lastSeenIndex=0}this._$ghostCommentFlagCell=null;this.$el.enableSelection()},_removeSelectionClasses:function(startRowIndex,endRowIndex){var i;for(i=startRowIndex;i<=endRowIndex;i++){$(this.el.rows[i]).removeClass("selected")}},_isLineNumCell:function(cell){return cell.tagName==="TH"&&cell.parentNode.getAttribute("line")},_getActualLineNumCell:function($node){if($node.hasClass("commentflag")){if($node[0]===this._$ghostCommentFlag[0]){$node=this._$ghostCommentFlagCell}else{$node=$node.parent()}}return $node},_onCopy:function(e){var clipboardData=e.originalEvent.clipboardData||window.clipboardData;if(clipboardData&&this._supportsSetClipboard&&this._copySelectionToClipboard(clipboardData)){return false}},_copySelectionToClipboard:function(clipboardData){var sel=window.getSelection(),s="",excludeTBodyClass,tdClass,range,doc,nodes,i,j;function findPreTags(result,parentEl,tdClass,excludeTBodyClass){var node,i;for(i=0;i<parentEl.children.length;i++){node=parentEl.children[i];if(node.nodeType===Node.ELEMENT_NODE){if(node.tagName==="PRE"){result.push(node)}else if((node.tagName!=="TD"||$(node).hasClass(tdClass))&&(node.tagName!=="TBODY"||!$(node).hasClass(excludeTBodyClass))){findPreTags(result,node,tdClass,excludeTBodyClass)}}}}if(this._newlineChar===null){if(navigator.appVersion.indexOf("Win")!==-1){this._newlineChar="\r\n"}else{this._newlineChar="\n"}}if(this._selectedCellIndex===3||this.$el.hasClass("newfile")){tdClass="r";excludeTBodyClass="delete"}else{tdClass="l";excludeTBodyClass="insert"}for(i=0;i<sel.rangeCount;i++){range=sel.getRangeAt(i);if(range.collapsed){continue}nodes=[];doc=range.cloneContents();findPreTags(nodes,doc,tdClass,excludeTBodyClass);if(nodes.length>0){for(j=0;j<nodes.length;j++){s+=nodes[j].textContent;if(j<nodes.length-1||range.endContainer.nodeType===Node.ELEMENT_NODE&&range.endOffset>0){s+=this._newlineChar}}}else{s+=$(doc).text();break}}try{clipboardData.setData("text",s)}catch(e){this._supportsSetClipboard=false;return false}return true},_onMouseDown:function(e){var node=e.target,$node;if(this._selectionClass){this.$el.removeClass(this._selectionClass)}if(this._$ghostCommentFlagCell){node=this._$ghostCommentFlagCell[0]}if(this._isLineNumCell(node)){this._begin($(node.parentNode));return false}else{if(node.tagName==="TD"){$node=$(node)}else{$node=$(node).parentsUntil("tr","td")}if($node.length>0){this._selectionClass="selecting-col-"+$node[0].cellIndex;this._selectedCellIndex=$node[0].cellIndex;this.$el.addClass(this._selectionClass)}}return true},_onMouseUp:function(e){var node=e.target;e.preventDefault();if(this._$ghostCommentFlagCell){node=this._$ghostCommentFlagCell[0]}if(this._isLineNumCell(node)){this._end(this._getActualLineNumCell($(node)).parent());e.stopImmediatePropagation()}this._reset()},_onMouseOver:function(e){var $node=this._getActualLineNumCell($(e.target)),$row=$node.parent();if(this._isLineNumCell($node[0])){if(this._$begin){this._addRow($row)}else{this._highlightRow($row)}}else if(this._$ghostCommentFlagCell&&$node[0]!==this._$ghostCommentFlagCell[0]){$row.removeClass("selected")}},_onMouseOut:function(e){var relTarget=e.relatedTarget,$node=this._getActualLineNumCell($(e.target));if(relTarget!==this._$ghostCommentFlag[0]){this._$ghostCommentFlag.hide();this._$ghostCommentFlagCell=null}if(this._$begin){if(relTarget&&this._isLineNumCell(relTarget)){this._removeOldRows($(relTarget.parentNode))}}else if($node&&this._isLineNumCell($node[0])){$node.parent().removeClass("selected")}},_onTouchStart:function(e){var firstTouch=e.originalEvent.targetTouches[0],$node=this._getActualLineNumCell($(firstTouch.target));if($node!==null&&this._isLineNumCell($node[0])){e.preventDefault();this._begin($node.parent())}},_onTouchEnd:function(e){var firstTouch=e.originalEvent.changedTouches[0],target=document.elementFromPoint(firstTouch.clientX,firstTouch.clientY),$node=this._getActualLineNumCell($(target));if($node!==null&&this._isLineNumCell($node[0])){e.preventDefault();this._end($node.parent())}this._reset()},_onTouchMove:function(e){var firstTouch=e.originalEvent.targetTouches[0],target=document.elementFromPoint(firstTouch.clientX,firstTouch.clientY),$node=this._getActualLineNumCell($(target)),$row;if($node!==null){$row=$node.parent();if(this._lastSeenIndex!==$row[0].rowIndex&&this._isLineNumCell($node[0])){e.preventDefault();this._removeOldRows($row);this._addRow($row)}}},_onTouchCancel:function(){this._reset()},getLineNum:function(row){return parseInt(row.getAttribute("line"),10)}})})();"use strict";RB.MarkdownReviewableView=RB.TextBasedReviewableView.extend({className:"markdown-review-ui"});RB.UploadDiffView=Backbone.View.extend({events:{"dragenter .dnd":"_onDragEnter","dragover .dnd":"_onDragOver","dragleave .dnd":"_onDragLeave","drop .dnd":"_onDrop","submit #basedir-form":"_onBasedirSubmit","submit #changenum-form":"_onChangenumSubmit","click .startover":"_onStartOverClicked","click #select-diff-file":"_onSelectFileClicked","click #select-parent-diff-file":"_onSelectFileClicked"},initialize:function(){this.listenTo(this.model,"change:state",this._onStateChanged);this.listenTo(this.model,"change:error",this._onErrorChanged)},render:function(){var self=this,selectDiffText,selectParentDiffText;if(this._canDragDrop()){selectDiffText=gettext('<input type="button" id="select-diff-file" value="Select"> or drag and drop a diff file to begin');selectParentDiffText=gettext('<input type="button" id="select-parent-diff-file" value="Select"> or drag and drop a parent diff file if you have one')}else{selectDiffText=gettext('<input type="button" id="select-diff-file" value="Select"> a file to begin');selectParentDiffText=gettext('<input type="button" id="select-parent-diff-file" value="Select"> a parent diff file if you have one')}this.$el.html(this.template({pendingChangeHeader:gettext("Create from a local change"),tipHeader:gettext("Tip:"),tip:gettext('Use <tt>rbt post</tt> from <a href="https://www.reviewboard.org/downloads/rbtools/">RBTools</a> to more easily create and update review requests.'),selectDiff:selectDiffText,selectParentDiff:selectParentDiffText,baseDir:gettext("What is the base directory for this diff?"),changeNum:gettext("What is the change number for this diff?"),startOver:gettext("Start Over"),ok:gettext("OK")}));this._$fileInput=$('<input type="file" />').hide().appendTo(this.$el).change(function(){self.model.handleFiles(self._$fileInput.get(0).files)});this._$diffRevisionError=this.$("#parent-diff-error-contents");this._$error=this.$("#error-indicator");this._$errorContents=this.$("#error-contents");this._$processingDiff=this.$("#processing-diff");this._$promptForBasedir=this.$("#prompt-for-basedir");this._$promptForChangeNumber=this.$("#prompt-for-change-number");this._$promptForDiff=this.$("#prompt-for-diff");this._$promptForParentDiff=this.$("#prompt-for-parent-diff");this._$uploading=this.$("#uploading-diffs");this._onStateChanged(this.model,this.model.get("state"));return this},_canDragDrop:function(){return("draggable"in this.el||"ondragstart"in this.el&&"ondrop"in this.el)&&!navigator.userAgent.match("iPhone OS")&&!navigator.userAgent.match("iPad")},_onErrorChanged:function(model,error){var errorHTML='<div class="rb-icon rb-icon-warning"></div>'+error,innerHeight,outerHeight;this._$errorContents.html(errorHTML);this._$diffRevisionError.html(errorHTML);innerHeight=this._$errorContents.height();outerHeight=this._$error.height();this._$errorContents.css({top:Math.floor((outerHeight-innerHeight)/2)+"px"})},_onStateChanged:function(model,state){this._$promptForDiff.setVisible(state===this.model.State.PROMPT_FOR_DIFF);this._$promptForParentDiff.setVisible(state===this.model.State.PROMPT_FOR_PARENT_DIFF);this._$promptForBasedir.setVisible(state===this.model.State.PROMPT_FOR_BASEDIR);this._$processingDiff.setVisible(state===this.model.State.PROCESSING_DIFF);this._$promptForChangeNumber.setVisible(state===this.model.State.PROMPT_FOR_CHANGE_NUMBER);this._$uploading.setVisible(state===this.model.State.UPLOADING);this._$error.setVisible(state===this.model.State.ERROR)},_onDragEnter:function(event){event.stopPropagation();event.preventDefault();this.$(".dnd").addClass("drag-hover");return false},_onDragOver:function(event){var dt=event.originalEvent.dataTransfer;event.stopPropagation();event.preventDefault();if(dt){dt.dropEffect="copy"}return false},_onDragLeave:function(event){var dt=event.originalEvent.dataTransfer;event.stopPropagation();event.preventDefault();this.$(".dnd").removeClass("drag-hover");if(dt){dt.dropEffect="none"}return false},_onDrop:function(event){var dt=event.originalEvent.dataTransfer,files=dt&&dt.files;event.stopPropagation();event.preventDefault();if(files){this.model.handleFiles(files)}},_onBasedirSubmit:function(){var basedir=this.$("#basedir-input").val();if(basedir){this.model.set("basedir",basedir)}return false},_onChangenumSubmit:function(){var changenum=this.$("#changenum-input").val();if(changenum){this.model.set("changeNumber",changenum)}return false},_onStartOverClicked:function(){var input=this._$fileInput.clone(true);this._$fileInput.replaceWith(input);this._$fileInput=input;this.model.startOver();return false},_onSelectFileClicked:function(){this._$fileInput.click()}});RB.UpdateDiffView=RB.UploadDiffView.extend({className:"update-diff",template:_.template(['<div class="input dnd" id="prompt-for-diff">'," <form>","  <%= selectDiff %>"," </form>","</div>",'<div class="input dnd" id="prompt-for-parent-diff">'," <form>",'  <div id="parent-diff-error-contents" />',"  <%= selectParentDiff %>"," </form>",' <a href="#" class="startover"><%- startOver %></a>',"</div>",'<div class="input" id="prompt-for-basedir">',' <form id="basedir-form">',"  <%- baseDir %>",'  <input id="basedir-input" />','  <input type="submit" value="<%- ok %>" />'," </form>",' <a href="#" class="startover"><%- startOver %></a>',"</div>",'<div class="input" id="processing-diff">',' <div class="spinner"><span class="fa fa-spinner fa-pulse"></div>',"</div>",'<div class="input" id="uploading-diffs">',' <div class="spinner"><span class="fa fa-spinner fa-pulse"></div>',"</div>",'<div class="input" id="error-indicator">',' <div id="error-contents" />',' <a href="#" class="startover"><%- startOver %></a>',"</div>"].join("")),render:function(){_super(this).render.call(this);this.$el.modalBox({title:gettext("Update Diff"),buttons:[$('<input type="button" />').val(gettext("Cancel"))]});return this}});"use strict";RB.DiffCommentBlock=RB.AbstractCommentBlock.extend({defaults:_.defaults({fileDiffID:null,interFileDiffID:null,beginLineNum:null,endLineNum:null,$beginRow:null,$endRow:null},RB.AbstractCommentBlock.prototype.defaults),getNumLines:function getNumLines(){return this.get("endLineNum")+this.get("beginLineNum")+1},createComment:function createComment(id){return this.get("review").createDiffComment(id,this.get("fileDiffID"),this.get("interFileDiffID"),this.get("beginLineNum"),this.get("endLineNum"))}});RB.DiffCommentsHint=Backbone.Model.extend({defaults:{hasOtherComments:false,diffsetsWithComments:[],interdiffsWithComments:[]},parse:function(rsp){return{hasOtherComments:rsp.has_other_comments,diffsetsWithComments:_.map(rsp.diffsets_with_comments,function(diffset){return{revision:diffset.revision,isCurrent:diffset.is_current}}),interdiffsWithComments:_.map(rsp.interdiffs_with_comments,function(interdiff){return{oldRevision:interdiff.old_revision,newRevision:interdiff.new_revision,isCurrent:interdiff.is_current}})}}});RB.DiffFile=Backbone.Model.extend({defaults:{binary:false,commentCounts:null,deleted:false,depotFilename:null,destFilename:null,destRevision:null,filediff:null,index:null,interfilediff:null,newfile:false,forceInterdiff:null,forceInterdiffRevision:null},parse:function(rsp){return{binary:rsp.binary,commentCounts:rsp.comment_counts,deleted:rsp.deleted,depotFilename:rsp.depot_filename,destFilename:rsp.dest_filename,destRevision:rsp.dest_revision,filediff:rsp.filediff,id:rsp.id,index:rsp.index,interfilediff:rsp.interfilediff,newfile:rsp.newfile,revision:rsp.revision,forceInterdiff:rsp.force_interdiff,forceInterdiffRevision:rsp.interdiff_revision}}});"use strict";RB.DiffReviewable=RB.AbstractReviewable.extend({defaults:_.defaults({file:null,fileDiffID:null,interdiffRevision:null,interFileDiffID:null,revision:null},RB.AbstractReviewable.prototype.defaults),commentBlockModel:RB.DiffCommentBlock,defaultCommentBlockFields:["fileDiffID","interFileDiffID"],loadSerializedCommentBlock:function loadSerializedCommentBlock(serializedCommentBlock){this.createCommentBlock({reviewRequest:this.get("reviewRequest"),review:this.get("review"),fileDiffID:this.get("fileDiffID"),interFileDiffID:this.get("interFileDiffID"),beginLineNum:serializedCommentBlock.linenum,endLineNum:serializedCommentBlock.linenum+serializedCommentBlock.num_lines-1,serializedComments:serializedCommentBlock.comments||[]})},getRenderedDiff:function getRenderedDiff(callbacks,context){var options=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};var url=this._buildRenderedDiffURL()+"?index="+this.get("file").get("index");if(options.showDeleted){url+="&show-deleted=1"}url+="&"+TEMPLATE_SERIAL;this._fetchFragment({url:url,noActivityIndicator:true},callbacks,context)},getRenderedDiffFragment:function getRenderedDiffFragment(options,callbacks,context){console.assert(options.chunkIndex!==undefined,"chunkIndex must be provided");this._fetchFragment({url:this._buildRenderedDiffURL()+"chunk/"+options.chunkIndex+"/",data:{index:this.get("file").get("index"),"lines-of-context":options.linesOfContext}},callbacks,context)},_fetchFragment:function _fetchFragment(options,callbacks,context){RB.apiCall(_.defaults({type:"GET",dataType:"html"},options,_.bindCallbacks(callbacks,context)))},_buildRenderedDiffURL:function _buildRenderedDiffURL(){var interdiffRevision=this.get("interdiffRevision");var interFileDiffID=this.get("interFileDiffID");var revisionStr=this.get("revision");if(interdiffRevision){revisionStr+="-"+interdiffRevision}return this.get("reviewRequest").get("reviewURL")+"diff/"+revisionStr+"/fragment/"+this.get("fileDiffID")+(interFileDiffID?"-"+interFileDiffID:"")+"/"}});RB.DiffRevision=Backbone.Model.extend({defaults:{revision:null,interdiffRevision:null,latestRevision:null,isInterdiff:false,isDraftDiff:false},parse:function(rsp){return{revision:rsp.revision,interdiffRevision:rsp.interdiff_revision,latestRevision:rsp.latest_revision,isInterdiff:rsp.is_interdiff,isDraftDiff:rsp.is_draft_diff}}});RB.Pagination=Backbone.Model.extend({defaults:{isPaginated:false,pages:0,hasPrevious:false,hasNext:false,pageNumbers:[],previousPage:null,nextPage:null,currentPage:null},parse:function(rsp){return{isPaginated:rsp.is_paginated,pages:rsp.pages,hasPrevious:rsp.has_previous,hasNext:rsp.has_next,pageNumbers:rsp.page_numbers,previousPage:rsp.previous_page,nextPage:rsp.next_page,currentPage:rsp.current_page}}});RB.DiffFileCollection=Backbone.Collection.extend({model:RB.DiffFile});"use strict";RB.DiffReviewableCollection=Backbone.Collection.extend({model:RB.DiffReviewable,initialize:function initialize(models,options){this.reviewRequest=options.reviewRequest},watchFiles:function watchFiles(files){var _this=this;this.listenTo(files,"reset",function(){return _this._populateFromFiles(files)});this._populateFromFiles(files)},_populateFromFiles:function _populateFromFiles(files){var _this2=this;var reviewRequest=this.reviewRequest;console.assert(reviewRequest,"RB.DiffReviewableCollection.reviewRequest must be set");this.reset();this.trigger("populating");files.each(function(file){var filediff=file.get("filediff");var interfilediff=file.get("interfilediff");var interdiffRevision=null;if(interfilediff){interdiffRevision=interfilediff.revision}else if(file.get("forceInterdiff")){interdiffRevision=file.get("forceInterdiffRevision")}_this2.add({reviewRequest:reviewRequest,file:file,fileDiffID:filediff.id,interFileDiffID:interfilediff?interfilediff.id:null,revision:filediff.revision,interdiffRevision:interdiffRevision,serializedCommentBlocks:file.get("commentCounts")})});this.trigger("populated")}});RB.ChunkHighlighterView=Backbone.View.extend({className:"diff-highlight",initialize:function(){this._chunkEl=null;this._chunkContainerEl=null;this._$pageContainer=null;this._$window=$(window);this._prevWindowWidth=null;this._prevTop=null;this._prevHeight=null;_.bindAll(this,"updateLayout")},render:function(){this._$window.on("resize."+this.cid,_.bind(function(){var windowWidth=this._$window.width();if(windowWidth!==this._prevWindowWidth){this._prevWindowWidth=windowWidth;this.updateLayout()}},this));this._$pageContainer=$("#page-container");this.updateLayout();return this},remove:function(){_super(this).remove.call(this);this._$window.off(this.cid)},highlight:function($chunk){this._chunkEl=$chunk[0];this._chunkContainerEl=$chunk.parents(".diff-container")[0];this.updateLayout()},updateLayout:function(){var chunkEl=this._chunkEl,changed=false,css={},padding,top,height;if(!chunkEl){return}top=Math.floor(chunkEl.offsetTop+this._chunkContainerEl.offsetTop+1);height=chunkEl.clientHeight+1;if(top!==this._prevTop){css.top=top;this._prevTop=top;changed=true}if(height!==this._prevHeight){css.height=height;this._prevHeight=height;changed=true}if(changed){padding=this._$pageContainer.getExtents("p","l");css.left=-padding;css.right=-padding;this.$el.css(css)}}});"use strict";RB.DiffCommentBlockView=RB.TextBasedCommentBlockView.extend({buildAnchorName:function buildAnchorName(){var fileDiffID=this.model.get("fileDiffID");var beginLineNum=this.model.get("beginLineNum");return"file"+fileDiffID+"line"+beginLineNum}});RB.DiffCommentsHintView=Backbone.View.extend({events:{"click .revision":"_onRevisionSelected","click .interdiff":"_onInterdiffSelected"},template:_.template(['<div class="box-container">',' <div class="box important">','  <div class="box-inner comments-hint">',"   <h1><%- unpublishedCommentsHeader %></h1>","   <p><%- unpublishedCommentsText %></p>","   <ul>","   </ul>","  </div>"," </div>","</div>"].join("")),initialize:function(){this.listenTo(this.model,"change",this.render)},render:function(){var revisionText=gettext("Revision %s"),interdiffText=gettext("Interdiff revision %(oldRevision)s - %(newRevision)s"),$ul,$li;if(this.model.get("hasOtherComments")){this.$el.html(this.template({unpublishedCommentsHeader:gettext("You have unpublished comments on other revisions"),unpublishedCommentsText:gettext("Your review consists of comments on the following revisions:")}));$ul=this.$("ul");_.each(this.model.get("diffsetsWithComments"),function(diffset){$li=$("<li/>").addClass("revision").data("revision",diffset.revision).text(interpolate(revisionText,[diffset.revision])).appendTo($ul);if(diffset.isCurrent){$li.addClass("current")}});_.each(this.model.get("interdiffsWithComments"),function(interdiff){$li=$("<li/>").addClass("interdiff").data({"first-revision":interdiff.oldRevision,"second-revision":interdiff.newRevision}).text(interpolate(interdiffText,{oldRevision:interdiff.oldRevision,newRevision:interdiff.newRevision},true)).appendTo($ul);if(interdiff.isCurrent){$li.addClass("current")}})}else{this.$el.empty()}return this},_onRevisionSelected:function(ev){var $target=$(ev.currentTarget);if(!$target.hasClass("current")){this.trigger("revisionSelected",[0,$target.data("revision")])}},_onInterdiffSelected:function(ev){var $target=$(ev.currentTarget);if(!$target.hasClass("current")){this.trigger("revisionSelected",[$target.data("first-revision"),$target.data("second-revision")])}}});RB.DiffComplexityIconView=Backbone.View.extend({ICON_SIZE:20,initialize:function(options){this.numInserts=options.numInserts||0;this.numDeletes=options.numDeletes||0;this.numReplaces=options.numReplaces||0;this.totalLines=options.totalLines||null},render:function(){var numTotal=this.numInserts+this.numDeletes+this.numReplaces,numInsertsPct=this.numInserts/numTotal,numDeletesPct=this.numDeletes/numTotal,numReplacesPct=this.numReplaces/numTotal,minValue=360*.15,innerRadius=.5*(this.totalLines===null?1:(this.totalLines-numTotal)/this.totalLines),iconColors=RB.DiffComplexityIconView.getIconColors();this.$el.width(this.ICON_SIZE).height(this.ICON_SIZE).plot([{color:iconColors.insertColor,data:this._clampValue(numInsertsPct*360,minValue)},{color:iconColors.deleteColor,data:this._clampValue(numDeletesPct*360,minValue)},{color:iconColors.replaceColor,data:this._clampValue(numReplacesPct*360,minValue)}],{series:{pie:{show:true,innerRadius:innerRadius,radius:.8}}});return this},_clampValue:function(val,minValue){return val===0?0:Math.max(val,minValue)}},{_iconColors:null,getIconColors:function(){var $iconColor;if(!this._iconColors){this._iconColors={};$iconColor=$("<div/>").hide().appendTo(document.body);$iconColor[0].className="diff-changes-icon-insert";this._iconColors.insertColor=$iconColor.css("color");$iconColor[0].className="diff-changes-icon-replace";this._iconColors.replaceColor=$iconColor.css("color");$iconColor[0].className="diff-changes-icon-delete";this._iconColors.deleteColor=$iconColor.css("color");$iconColor.remove()}return this._iconColors}})
;RB.DiffFileIndexView=Backbone.View.extend({chunkTemplate:_.template('<a href="#<%= chunkID %>" class="<%= className %>"> </a>'),events:{"click a":"_onAnchorClicked"},initialize:function(){this._$items=null;this._$itemsTable=null;this.collection=this.options.collection;this.listenTo(this.collection,"reset update",this.update)},render:function(){this.$el.empty();this._$itemsTable=$("<table/>").appendTo(this.$el);this._$items=this.$("tr");this.update();return this},_itemTemplate:_.template(['<tr class="loading<%',' if (newfile) { print(" new-file"); }',' if (binary) { print(" binary-file"); }',' if (deleted) { print(" deleted-file"); }',' if (destFilename !== depotFilename) { print(" renamed-file"); }',' %>">',' <td class="diff-file-icon">','  <span class="fa fa-spinner fa-pulse"></span>'," </td>",' <td class="diff-file-info">','  <a href="#<%- index %>"><%- destFilename %></a>',"  <% if (destFilename !== depotFilename) { %>",'  <span class="diff-file-rename"><%- wasText %></span>',"  <% } %>"," </td>",' <td class="diff-chunks-cell">',"  <% if (binary) { %>","   <%- binaryFileText %>","  <% } else if (deleted) { %>","   <%- deletedFileText %>","  <% } else { %>",'   <div class="diff-chunks"></div>',"  <% } %>"," </td>","</tr>"].join("")),update:function(){this._$itemsTable.empty();this.collection.each(function(file){this._$itemsTable.append(this._itemTemplate(_.defaults({binaryFileText:gettext("Binary file"),deletedFileText:gettext("Deleted"),wasText:interpolate(gettext("Was %s"),[file.get("depotFilename")])},file.attributes)))},this);this._$items=this.$("tr")},addDiff:function(index,diffReviewableView){var $item=$(this._$items[index]).removeClass("loading");if(diffReviewableView.$el.hasClass("diff-error")){this._renderDiffError($item)}else{this._renderDiffEntry($item,diffReviewableView)}},_renderDiffError:function($item){var $fileIcon=$item.find(".diff-file-icon");$fileIcon.html('<div class="rb-icon rb-icon-warning" />').attr("title",gettext("There was an error loading this diff. See the details below."))},_renderDiffEntry:function($item,diffReviewableView){var $table=diffReviewableView.$el,fileDeleted=$item.hasClass("deleted-file"),fileAdded=$item.hasClass("new-file"),linesEqual=$table.data("lines-equal"),numDeletes=0,numInserts=0,numReplaces=0,chunksList=[],iconView,$fileIcon=$item.find(".diff-file-icon"),tooltip="",tooltipParts=[];if(fileAdded){numInserts=1}else if(fileDeleted){numDeletes=1}else if($item.hasClass("binary-file")){numReplaces=1}else{_.each($table.children("tbody"),function(chunk){var numRows=chunk.rows.length,$chunk=$(chunk);if($chunk.hasClass("delete")){numDeletes+=numRows}else if($chunk.hasClass("insert")){numInserts+=numRows}else if($chunk.hasClass("replace")){numReplaces+=numRows}else{return}chunksList.push(this.chunkTemplate({chunkID:chunk.id.substr(5),className:chunk.className}))},this);$item.find(".diff-chunks").html(chunksList.join(""))}iconView=new RB.DiffComplexityIconView({numInserts:numInserts,numDeletes:numDeletes,numReplaces:numReplaces,totalLines:linesEqual+numDeletes+numInserts+numReplaces});$fileIcon.empty().append(iconView.$el);iconView.render();if(fileAdded){tooltip=gettext("New file")}else if(fileDeleted){tooltip=gettext("Deleted file")}else{if(numInserts>0){tooltipParts.push(interpolate(ngettext("%s new line","%s new lines",numInserts),[numInserts]))}if(numReplaces>0){tooltipParts.push(interpolate(ngettext("%s line changed","%s lines changed",numReplaces),[numReplaces]))}if(numDeletes>0){tooltipParts.push(interpolate(ngettext("%s line removed","%s lines removed",numDeletes),[numDeletes]))}tooltip=tooltipParts.join(", ")}$fileIcon.attr("title",tooltip);this.listenTo(diffReviewableView,"chunkDimmed chunkUndimmed",function(chunkID){this.$('a[href="#'+chunkID+'"]').toggleClass("dimmed")})},_onAnchorClicked:function(e){e.preventDefault();this.trigger("anchorClicked",e.target.href.split("#")[1])}});"use strict";(function(){RB.DiffReviewableView=RB.AbstractReviewableView.extend({tagName:"table",commentBlockView:RB.DiffCommentBlockView,commentsListName:"diff_comments",events:{"click .download-link":"_onDownloadLinkClicked","click thead tr":"_onFileHeaderClicked","click .moved-to, .moved-from":"_onMovedLineClicked","click .diff-collapse-btn":"_onCollapseChunkClicked","click .diff-expand-btn":"_onExpandChunkClicked","click .show-deleted-content-action":"_onShowDeletedClicked",mouseup:"_onMouseUp"},initialize:function initialize(){_super(this).initialize.call(this);this._selector=new RB.TextCommentRowSelector({el:this.el,reviewableView:this});this._hiddenCommentBlockViews=[];this._visibleCommentBlockViews=[];this._$filenameRow=null;this._$revisionRow=null;this._filenameReservedWidths=0;this._colReservedWidths=0;this._numColumns=0;this._numFilenameColumns=0;this._prevContentWidth=null;this._prevFilenameWidth=null;this._prevFullWidth=null;this._$window=$(window);this._$parent=this.$el.parent();this.on("commentBlockViewAdded",this._placeCommentBlockView,this)},remove:function remove(){RB.AbstractReviewableView.prototype.remove.call(this);this._selector.remove()},render:function render(){var $thead;_super(this).render.call(this);this._centered=new RB.CenteredElementManager;$thead=$(this.el.tHead);this._$revisionRow=$thead.children(".revision-row");this._$filenameRow=$thead.children(".filename-row");this._selector.render();_.each(this.$el.children("tbody.binary"),function(thumbnailEl){var $thumbnail=$(thumbnailEl),id=$thumbnail.data("file-id"),$caption=$thumbnail.find(".file-caption .edit"),reviewRequest=this.model.get("reviewRequest"),fileAttachment=reviewRequest.createFileAttachment({id:id});if(!$caption.hasClass("empty-caption")){fileAttachment.set("caption",$caption.text())}},this);this._precalculateContentWidths();this._updateColumnSizes();return this},toggleWhitespaceOnlyChunks:function toggleWhitespaceOnlyChunks(){this.$("tbody tr.whitespace-line").toggleClass("dimmed");_.each(this.$el.children("tbody.whitespace-chunk"),function(chunk){var $chunk=$(chunk),dimming=$chunk.hasClass("replace"),chunkID=chunk.id.split("chunk")[1],$children=$chunk.children();$chunk.toggleClass("replace");$($children[0]).toggleClass("first");$($children[$children.length-1]).toggleClass("last");if(dimming){this.trigger("chunkDimmed",chunkID)}else{this.trigger("chunkUndimmed",chunkID)}},this);this.$el.children("tbody.whitespace-file").siblings("tbody").addBack().toggle()},createComment:function createComment(beginLineNum,endLineNum,beginNode,endNode){this._selector.createComment(beginLineNum,endLineNum,beginNode,endNode)},_placeCommentBlockView:function _placeCommentBlockView(commentBlockView,prevBeginRowIndex){var commentBlock=commentBlockView.model,rowEls=this._selector.getRowsForRange(commentBlock.get("beginLineNum"),commentBlock.get("endLineNum"),prevBeginRowIndex),beginRowEl,endRowEl;if(rowEls){beginRowEl=rowEls[0];endRowEl=rowEls[1];commentBlockView.setRows($(beginRowEl),$(endRowEl||beginRowEl));commentBlockView.$el.appendTo(commentBlockView.$beginRow[0].cells[0]);this._visibleCommentBlockViews.push(commentBlockView);prevBeginRowIndex=beginRowEl.rowIndex}else{this._hiddenCommentBlockViews.push(commentBlockView)}return prevBeginRowIndex},_placeHiddenCommentBlockViews:function _placeHiddenCommentBlockViews(){var hiddenCommentBlockViews=this._hiddenCommentBlockViews,prevBeginRowIndex;this._hiddenCommentBlockViews=[];_.each(hiddenCommentBlockViews,function(commentBlockView){prevBeginRowIndex=this._placeCommentBlockView(commentBlockView,prevBeginRowIndex)},this)},_hideRemovedCommentBlockViews:function _hideRemovedCommentBlockViews(){var visibleCommentBlockViews=this._visibleCommentBlockViews;this._visibleCommentBlockViews=[];_.each(visibleCommentBlockViews,function(commentBlockView){if(commentBlockView.$el.is(":visible")){this._visibleCommentBlockViews.push(commentBlockView)}else{this._hiddenCommentBlockViews.push(commentBlockView)}},this);_.sortBy(this._hiddenCommentBlockViews,function(commentBlockView){return commentBlockView.model.get("beginLineNum")})},_updateCollapseButtonPos:function _updateCollapseButtonPos(){this._centered.updatePosition()},_expandOrCollapse:function _expandOrCollapse($btn,expanding){var chunkIndex=$btn.data("chunk-index"),linesOfContext=$btn.data("lines-of-context");this.model.getRenderedDiffFragment({chunkIndex:chunkIndex,linesOfContext:linesOfContext},{success:function success(html){var $tbody=$btn.closest("tbody"),$scrollAnchor,tbodyID,scrollAnchorID,scrollOffsetTop,newEl;if(expanding){$scrollAnchor=this.$el;scrollAnchorID=$scrollAnchor[0].id;if(linesOfContext===0){tbodyID=/collapsed-(.*)/.exec(scrollAnchorID)[1]}else{tbodyID=scrollAnchorID}}else{$scrollAnchor=$btn}scrollOffsetTop=$scrollAnchor.offset().top-this._$window.scrollTop();$tbody.prev(".diff-header, .loaded").remove();$tbody.next(".diff-header, .loaded").remove();$tbody.replaceWith(html);if(expanding){this._placeHiddenCommentBlockViews()}else{this._hideRemovedCommentBlockViews()}if(tbodyID){newEl=document.getElementById(tbodyID);if(newEl){$scrollAnchor=$(newEl);if($scrollAnchor.length>0){this._$window.scrollTop($scrollAnchor.offset().top-scrollOffsetTop)}}}this._centered.setElements(new Map(Array.prototype.map.call(this.$(".diff-collapse-btn"),function(el){return[el,{$top:$(el).closest("tbody")}]})));this._updateCollapseButtonPos();this._precalculateContentWidths();this._updateColumnSizes();this.trigger("chunkExpansionChanged")}},this)},_precalculateContentWidths:function _precalculateContentWidths(){var cellPadding=0,containerExtents,$cells;if(!this.$el.hasClass("diff-error")&&this._$revisionRow.length>0){containerExtents=this.$el.getExtents("p","lr");$cells=$(this._$revisionRow[0].cells);cellPadding=$(this.el.querySelector("pre")).parent().andSelf().getExtents("p","lr");this._colReservedWidths=$cells.eq(0).outerWidth()+cellPadding+containerExtents;this._numColumns=$cells.length;if(this._numColumns===4){this._colReservedWidths+=$cells.eq(2).outerWidth()+cellPadding}$cells=$(this._$filenameRow[0].cells);this._numFilenameColumns=$cells.length;this._filenameReservedWidths=containerExtents+2*this._numFilenameColumns}else{this._colReservedWidths=0;this._filenameReservedWidths=0;this._numColumns=0;this._numFilenameColumns=0}},_updateColumnSizes:function _updateColumnSizes(){var $parent=this._$parent,fullWidth,contentWidth,filenameWidth;if(this.$el.hasClass("diff-error")){return}if(!$parent.is(":visible")){$parent=$parent.parent()}fullWidth=$parent.width();if(fullWidth===this._prevFullWidth){return}this._prevFullWidth=fullWidth;contentWidth=fullWidth-this._colReservedWidths;if(this._numColumns===4){contentWidth/=2}filenameWidth=fullWidth-this._filenameReservedWidths;if(this._numFilenameColumns===2){filenameWidth/=2}this.$el.width(fullWidth);if(filenameWidth!==this._prevFilenameWidth){this._$filenameRow.children("th").css({"min-width":Math.ceil(filenameWidth*.66),"max-width":Math.ceil(filenameWidth)});this._prevFilenameWidth=filenameWidth}if(contentWidth!==this._prevContentWidth){this._$revisionRow.children(".revision-col").css({"min-width":Math.ceil(contentWidth*.66),"max-width":Math.ceil(contentWidth)});this._prevContentWidth=contentWidth}},updateLayout:function updateLayout(){this._updateColumnSizes();this._updateCollapseButtonPos()},_onDownloadLinkClicked:function _onDownloadLinkClicked(e){e.stopPropagation()},_onFileHeaderClicked:function _onFileHeaderClicked(){this.trigger("fileClicked");return false},_onMovedLineClicked:function _onMovedLineClicked(e){e.preventDefault();e.stopPropagation();this.trigger("moveFlagClicked",$(e.target).data("line"))},_onMouseUp:function _onMouseUp(e){var node=e.target,anchor,$tbody;$tbody=$(node).closest("tbody");if($tbody.length>0&&($tbody.hasClass("delete")||$tbody.hasClass("insert")||$tbody.hasClass("replace"))){anchor=$tbody[0].querySelector("a");if(anchor){this.trigger("chunkClicked",anchor.name)}}},_onExpandChunkClicked:function _onExpandChunkClicked(e){var $target=$(e.target);if(!$target.hasClass("diff-expand-btn")){$target=$target.closest(".diff-expand-btn")}e.preventDefault();this._expandOrCollapse($target,true)},_onCollapseChunkClicked:function _onCollapseChunkClicked(e){var $target=$(e.target);if(!$target.hasClass("diff-collapse-btn")){$target=$target.closest(".diff-collapse-btn")}e.preventDefault();this._expandOrCollapse($target,false)},_onShowDeletedClicked:function _onShowDeletedClicked(e){e.preventDefault();e.stopPropagation();$(e.target).parent().html('<span class="fa fa-spinner fa-pulse"></span>');this.trigger("showDeletedClicked")}})})();RB.DiffRevisionLabelView=Backbone.View.extend({events:{"click .select-latest":"_onSelectLatest","click .select-changed":"_onSelectChanged"},template:_.template(["<h1><%- header %></h1>","<% if (detail) { %><p><%= detail %><% } %>"].join("")),_interdiffTemplate:_.template(gettext("Changes between revision <%- revision %> and <%- interdiffRevision %>")),_latestTemplate:_.template(gettext("Diff Revision <%- revision %> (Latest)")),_oldHeaderTemplate:_.template(gettext("Diff Revision <%- revision %>")),_oldDetailTemplate:_.template(gettext('This is not the most recent revision of the diff. The <a href="#" class="select-latest">latest diff</a> is revision <%- latestRevision %>. <a href="#" class="select-changed">See what\'s changed.</a>')),initialize:function(){this.listenTo(this.model,"change",this.render)},render:function(){var revision=this.model.get("revision"),interdiffRevision=this.model.get("interdiffRevision"),latestRevision=this.model.get("latestRevision"),header="",detail=null;if(this.model.get("isInterdiff")){header=this._interdiffTemplate({revision:revision,interdiffRevision:interdiffRevision})}else if(revision===latestRevision){header=this._latestTemplate({revision:revision})}else if(this.model.get("isDraftDiff")){header=gettext("Draft diff");detail=gettext("This diff is part of your current draft. Other users will not see this diff until you publish your draft.")}else{header=this._oldHeaderTemplate({revision:revision});detail=this._oldDetailTemplate({revision:revision,latestRevision:latestRevision})}this.$el.html(this.template({header:header,detail:detail}));return this},_onSelectLatest:function(ev){ev.preventDefault();this.trigger("revisionSelected",[0,this.model.get("latestRevision")]);return false},_onSelectChanged:function(ev){ev.preventDefault();this.trigger("revisionSelected",[this.model.get("revision"),this.model.get("latestRevision")]);return false}});RB.DiffRevisionSelectorView=RB.RevisionSelectorView.extend({initialize:function(){RB.RevisionSelectorView.prototype.initialize.call(this,{firstLabelActive:true,numHandles:2})},render:function(){var labels=["orig"],i;for(i=1;i<=this.options.numDiffs;i++){labels.push(i.toString())}return RB.RevisionSelectorView.prototype.render.call(this,labels)},_update:function(){var revision=this.model.get("revision"),interdiffRevision=this.model.get("interdiffRevision");this._values=[interdiffRevision?revision:0,interdiffRevision?interdiffRevision:revision];if(this._rendered){this._updateHandles()}},_onRevisionSelected:function(ev){var $target=$(ev.currentTarget);this.trigger("revisionSelected",[0,$target.data("revision")])},_onInterdiffSelected:function(ev){var $target=$(ev.currentTarget);this.trigger("revisionSelected",[$target.data("first-revision"),$target.data("second-revision")])},_onLabelClick:function(ev){var $target=$(ev.currentTarget);this.trigger("revisionSelected",[0,$target.data("revision")])}});RB.PaginationView=Backbone.View.extend({template:_.template(["<% if (isPaginated) { %>"," <%- splitText %>"," <% if (hasPrevious) { %>",'  <span class="paginate-link" data-page="<%- previousPage %>"><a href="?page=<%- previousPage %><%= extraURLOptions %>" title="<%- previousPageText %>">&lt;</a></span>'," <% } %>"," <% _.each(pageNumbers, function(page) { %>","  <% if (page === currentPage) { %>",'   <span class="paginate-current" title="<%- currentPageText %>"><%- page %></span>',"  <% } else { %>",'   <span class="paginate-link" data-page="<%- page %>"><a href="?page=<%- page %><%= extraURLOptions %>"','       title="<% print(interpolate(pageText, [page])); %>"',"       ><%- page %></a></span>","  <% } %>"," <% }); %>"," <% if (hasNext) { %>",'  <span class="paginate-link" data-page="<%- nextPage %>"><a href="?page=<%- nextPage %><%= extraURLOptions %>" title="<%- nextPageText %>">&gt;</a></span>'," <% } %>","<% } %>"].join("")),events:{"click .paginate-link":"_onPageClicked"},initialize:function(){this.listenTo(this.model,"change",this.render)},render:function(){this.$el.empty().html(this.template(_.defaults({splitText:interpolate(gettext("This diff has been split across %s pages:"),[this.model.get("pages")]),previousPageText:gettext("Previous Page"),nextPageText:gettext("Next Page"),currentPageText:gettext("Current Page"),extraURLOptions:this._buildExtraQueryString(),pageText:gettext("Page %s")},this.model.attributes)));return this},_buildExtraQueryString:function(){var queryString=window.location.search||"",newParts=[],parts=[],part,i;if(queryString.startsWith("?")){queryString=queryString.substr(1)}if(queryString){parts=queryString.split("&");for(i=0;i<parts.length;i++){part=parts[i];if(!part.startsWith("page=")){newParts.push(part)}}}if(parts.length>0){return"&"+newParts.join("&")}return""},_onPageClicked:function(ev){var page=$(ev.currentTarget).data("page");if(page!==undefined){this.trigger("pageSelected",page);return false}}})}).call(this);
