"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const defaults = require("@aws-solutions-constructs/core");
const core_2 = require("@aws-solutions-constructs/core");
class AlbToLambda extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckAlbProps(props);
        // Obtain VPC for construct (existing or created)
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: props.publicApi ? {} : { enableDnsHostnames: true, enableDnsSupport: true }
        });
        this.loadBalancer = defaults.ObtainAlb(this, id, this.vpc, props.publicApi, props.existingLoadBalancerObj, props.loadBalancerProps, props.logAlbAccessLogs, props.albLoggingBucketProps);
        // Obtain Lambda function for construct (existing or created)
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            vpc: this.vpc,
        });
        let newListener;
        if (this.loadBalancer.listeners.length === 0) {
            newListener = true;
        }
        else {
            newListener = false;
        }
        // If there's no listener, then we add one here
        if (newListener) {
            this.listener = defaults.AddListener(this, id, this.loadBalancer, props.listenerProps);
        }
        else {
            this.listener = core_2.GetActiveListener(this.loadBalancer.listeners);
        }
        const newTargetGroup = defaults.AddLambdaTarget(this, `tg${this.loadBalancer.listeners.length + 1}`, this.listener, this.lambdaFunction, props.ruleProps, props.targetProps);
        // this.listener needs to be set on the construct.
        // could be above: else { defaults.GetActiveListener }
        // do we then move that funcionality back into the construct (not the function). If so do
        // we leave it in AddNewTarget or just do it here and pass the listener?
        if (newListener && this.listener) {
            const levelOneListener = this.listener.node.defaultChild;
            const cfnTargetGroup = newTargetGroup.node.defaultChild;
            levelOneListener.addDependsOn(cfnTargetGroup);
        }
    }
}
exports.AlbToLambda = AlbToLambda;
_a = JSII_RTTI_SYMBOL_1;
AlbToLambda[_a] = { fqn: "@aws-solutions-constructs/aws-alb-lambda.AlbToLambda", version: "1.173.0" };
//# sourceMappingURL=data:application/json;base64,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