"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .capability_status import CapabilityStatus
from .capability_status_reason import CapabilityStatusReason
from .entity_capability_requirement import (
    EntityCapabilityRequirement,
    EntityCapabilityRequirementTypedDict,
)
from mollie.types import BaseModel
from mollie.utils import validate_open_enum
import pydantic
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityCapabilityTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Always the word `capability` for this resource type."""
    name: NotRequired[str]
    r"""A unique name for this capability like `payments` / `settlements`."""
    status: NotRequired[CapabilityStatus]
    status_reason: NotRequired[CapabilityStatusReason]
    requirements: NotRequired[List[EntityCapabilityRequirementTypedDict]]


class EntityCapability(BaseModel):
    resource: Optional[str] = None
    r"""Always the word `capability` for this resource type."""

    name: Optional[str] = None
    r"""A unique name for this capability like `payments` / `settlements`."""

    status: Annotated[
        Optional[CapabilityStatus], PlainValidator(validate_open_enum(False))
    ] = None

    status_reason: Annotated[
        Annotated[
            Optional[CapabilityStatusReason], PlainValidator(validate_open_enum(False))
        ],
        pydantic.Field(alias="statusReason"),
    ] = None

    requirements: Optional[List[EntityCapabilityRequirement]] = None
