"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .entity_capability import EntityCapability, EntityCapabilityTypedDict
from .entity_onboarding_status import (
    EntityOnboardingStatus,
    EntityOnboardingStatusTypedDict,
)
from .entity_organization import EntityOrganization, EntityOrganizationTypedDict
from .list_links import ListLinks, ListLinksTypedDict
from .url import URL, URLTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListClientsRequestTypedDict(TypedDict):
    embed: NotRequired[Nullable[str]]
    r"""This endpoint allows embedding related API items by appending the following values via the `embed` query string
    parameter.
    """
    from_: NotRequired[Nullable[str]]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""


class ListClientsRequest(BaseModel):
    embed: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows embedding related API items by appending the following values via the `embed` query string
    parameter.
    """

    from_: Annotated[
        OptionalNullable[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The maximum number of items to return. Defaults to 50 items."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["embed", "from", "limit"]
        nullable_fields = ["embed", "from", "limit"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListClientsCommissionTypedDict(TypedDict):
    r"""The commission object."""

    count: NotRequired[int]
    r"""The commission count."""


class ListClientsCommission(BaseModel):
    r"""The commission object."""

    count: Optional[int] = None
    r"""The commission count."""


class ListClientsLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    organization: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    onboarding: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListClientsLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[URL], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    organization: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    onboarding: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ClientEmbeddedTypedDict(TypedDict):
    organization: NotRequired[EntityOrganizationTypedDict]
    onboarding: NotRequired[EntityOnboardingStatusTypedDict]
    capabilities: NotRequired[EntityCapabilityTypedDict]


class ClientEmbedded(BaseModel):
    organization: Optional[EntityOrganization] = None

    onboarding: Optional[EntityOnboardingStatus] = None

    capabilities: Optional[EntityCapability] = None


class ListClientsClientTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a client object. Will always contain the string `client` for this resource type."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this client. Example: `org_12345678`."""
    commission: NotRequired[Nullable[ListClientsCommissionTypedDict]]
    r"""The commission object."""
    organization_created_at: NotRequired[str]
    r"""The date and time the client organization was created, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601)
    format.
    """
    links: NotRequired[ListClientsLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    embedded: NotRequired[ClientEmbeddedTypedDict]


class ListClientsClient(BaseModel):
    resource: Optional[str] = None
    r"""Indicates the response contains a client object. Will always contain the string `client` for this resource type."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this client. Example: `org_12345678`."""

    commission: OptionalNullable[ListClientsCommission] = UNSET
    r"""The commission object."""

    organization_created_at: Annotated[
        Optional[str], pydantic.Field(alias="organizationCreatedAt")
    ] = None
    r"""The date and time the client organization was created, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601)
    format.
    """

    links: Annotated[Optional[ListClientsLinks], pydantic.Field(alias="_links")] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    embedded: Annotated[Optional[ClientEmbedded], pydantic.Field(alias="_embedded")] = (
        None
    )

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "commission",
            "organizationCreatedAt",
            "_links",
            "_embedded",
        ]
        nullable_fields = ["commission"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListClientsEmbeddedTypedDict(TypedDict):
    clients: NotRequired[List[ListClientsClientTypedDict]]
    r"""An array of client objects. For a complete reference of the client object, refer to the
    [Get client endpoint](get-client) documentation.
    """


class ListClientsEmbedded(BaseModel):
    clients: Optional[List[ListClientsClient]] = None
    r"""An array of client objects. For a complete reference of the client object, refer to the
    [Get client endpoint](get-client) documentation.
    """


class ListClientsResponseTypedDict(TypedDict):
    r"""A list of client objects. For a complete reference of the client object, refer to the
    [Get client endpoint](get-client) documentation.
    """

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: NotRequired[ListClientsEmbeddedTypedDict]
    links: NotRequired[ListLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListClientsResponse(BaseModel):
    r"""A list of client objects. For a complete reference of the client object, refer to the
    [Get client endpoint](get-client) documentation.
    """

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListClientsEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[Optional[ListLinks], pydantic.Field(alias="_links")] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
