"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .locale import Locale
from .metadata import Metadata, MetadataTypedDict
from .method import Method
from .payment_address import PaymentAddress, PaymentAddressTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdatePaymentRequestBodyTypedDict(TypedDict):
    description: NotRequired[str]
    r"""The description of the payment. This will be shown to your customer on their card or bank statement when possible.
    We truncate the description automatically according to the limits of the used payment method. The description is
    also visible in any exports you generate.

    We recommend you use a unique identifier so that you can always link the payment to the order in your back office.
    This is particularly useful for bookkeeping.

    The maximum length of the description field differs per payment method, with the absolute maximum being 255
    characters. The API will not reject strings longer than the maximum length but it will truncate them to fit.
    """
    redirect_url: NotRequired[Nullable[str]]
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the
    right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for
    Apple Pay payments with an `applePayPaymentToken`.
    """
    cancel_url: NotRequired[Nullable[str]]
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not
    provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is
    therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle
    payment cancellations.
    """
    webhook_url: NotRequired[Nullable[str]]
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your payment.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """
    metadata: NotRequired[Nullable[MetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    method: NotRequired[Nullable[Method]]
    r"""Normally, a payment method screen is shown. However, when using this parameter, you can choose a specific payment
    method and your customer will skip the selection screen and is sent directly to the chosen payment method. The
    parameter enables you to fully integrate the payment method selection into your website.

    You can also specify the methods in an array. By doing so we will still show the payment method selection screen
    but will only show the methods specified in the array. For example, you can use this functionality to only show
    payment methods from a specific country to your customer `['bancontact', 'belfius']`.
    """
    locale: NotRequired[Nullable[Locale]]
    r"""Allows you to preset the language to be used."""
    due_date: NotRequired[str]
    r"""The date by which the payment should be completed in `YYYY-MM-DD` format"""
    restrict_payment_methods_to_country: NotRequired[Nullable[str]]
    r"""For digital goods in most jurisdictions, you must apply the VAT rate from your customer's country. Choose the VAT
    rates you have used for the order to ensure your customer's country matches the VAT country.

    Use this parameter to restrict the payment methods available to your customer to those from a single country.

    If available, the credit card method will still be offered, but only cards from the allowed country are accepted.

    The field expects a country code in ISO 3166-1 alpha-2 format, for example `NL`.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """
    issuer: NotRequired[Nullable[str]]
    r"""**Only relevant for iDEAL, KBC/CBC, gift card, and voucher payments.**

    **⚠️ With the introduction of iDEAL 2 in 2025, this field will be ignored for iDEAL payments. For more information
    on the migration, refer to our [help center](https://help.mollie.com/hc/articles/19100313768338-iDEAL-2-0).**

    Some payment methods are a network of connected banks or card issuers. In these cases, after selecting the payment
    method, the customer may still need to select the appropriate issuer before the payment can proceed.

    We provide hosted issuer selection screens, but these screens can be skipped by providing the `issuer` via the API
    up front.

    The full list of issuers for a specific method can be retrieved via the Methods API by using the optional
    `issuers` include.

    A valid issuer for iDEAL is for example `ideal_INGBNL2A` (for ING Bank).
    """
    billing_address: NotRequired[PaymentAddressTypedDict]
    shipping_address: NotRequired[PaymentAddressTypedDict]
    billing_email: NotRequired[str]


class UpdatePaymentRequestBody(BaseModel):
    description: Optional[str] = None
    r"""The description of the payment. This will be shown to your customer on their card or bank statement when possible.
    We truncate the description automatically according to the limits of the used payment method. The description is
    also visible in any exports you generate.

    We recommend you use a unique identifier so that you can always link the payment to the order in your back office.
    This is particularly useful for bookkeeping.

    The maximum length of the description field differs per payment method, with the absolute maximum being 255
    characters. The API will not reject strings longer than the maximum length but it will truncate them to fit.
    """

    redirect_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="redirectUrl")
    ] = UNSET
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the
    right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for
    Apple Pay payments with an `applePayPaymentToken`.
    """

    cancel_url: Annotated[OptionalNullable[str], pydantic.Field(alias="cancelUrl")] = (
        UNSET
    )
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not
    provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is
    therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle
    payment cancellations.
    """

    webhook_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="webhookUrl")
    ] = UNSET
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your payment.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """

    metadata: OptionalNullable[Metadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    method: OptionalNullable[Method] = UNSET
    r"""Normally, a payment method screen is shown. However, when using this parameter, you can choose a specific payment
    method and your customer will skip the selection screen and is sent directly to the chosen payment method. The
    parameter enables you to fully integrate the payment method selection into your website.

    You can also specify the methods in an array. By doing so we will still show the payment method selection screen
    but will only show the methods specified in the array. For example, you can use this functionality to only show
    payment methods from a specific country to your customer `['bancontact', 'belfius']`.
    """

    locale: OptionalNullable[Locale] = UNSET
    r"""Allows you to preset the language to be used."""

    due_date: Annotated[Optional[str], pydantic.Field(alias="dueDate")] = None
    r"""The date by which the payment should be completed in `YYYY-MM-DD` format"""

    restrict_payment_methods_to_country: Annotated[
        OptionalNullable[str], pydantic.Field(alias="restrictPaymentMethodsToCountry")
    ] = UNSET
    r"""For digital goods in most jurisdictions, you must apply the VAT rate from your customer's country. Choose the VAT
    rates you have used for the order to ensure your customer's country matches the VAT country.

    Use this parameter to restrict the payment methods available to your customer to those from a single country.

    If available, the credit card method will still be offered, but only cards from the allowed country are accepted.

    The field expects a country code in ISO 3166-1 alpha-2 format, for example `NL`.
    """

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """

    issuer: OptionalNullable[str] = UNSET
    r"""**Only relevant for iDEAL, KBC/CBC, gift card, and voucher payments.**

    **⚠️ With the introduction of iDEAL 2 in 2025, this field will be ignored for iDEAL payments. For more information
    on the migration, refer to our [help center](https://help.mollie.com/hc/articles/19100313768338-iDEAL-2-0).**

    Some payment methods are a network of connected banks or card issuers. In these cases, after selecting the payment
    method, the customer may still need to select the appropriate issuer before the payment can proceed.

    We provide hosted issuer selection screens, but these screens can be skipped by providing the `issuer` via the API
    up front.

    The full list of issuers for a specific method can be retrieved via the Methods API by using the optional
    `issuers` include.

    A valid issuer for iDEAL is for example `ideal_INGBNL2A` (for ING Bank).
    """

    billing_address: Annotated[
        Optional[PaymentAddress], pydantic.Field(alias="billingAddress")
    ] = None

    shipping_address: Annotated[
        Optional[PaymentAddress], pydantic.Field(alias="shippingAddress")
    ] = None

    billing_email: Annotated[Optional[str], pydantic.Field(alias="billingEmail")] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "metadata",
            "method",
            "locale",
            "dueDate",
            "restrictPaymentMethodsToCountry",
            "testmode",
            "issuer",
            "billingAddress",
            "shippingAddress",
            "billingEmail",
        ]
        nullable_fields = [
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "metadata",
            "method",
            "locale",
            "restrictPaymentMethodsToCountry",
            "testmode",
            "issuer",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdatePaymentRequestTypedDict(TypedDict):
    payment_id: str
    r"""Provide the ID of the related payment."""
    request_body: NotRequired[UpdatePaymentRequestBodyTypedDict]


class UpdatePaymentRequest(BaseModel):
    payment_id: Annotated[
        str,
        pydantic.Field(alias="paymentId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment."""

    request_body: Annotated[
        Optional[UpdatePaymentRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None
