#!/usr/bin/env python3
"""Command for BLH motor controller."""

# Initialization
INIT_CMD = [
    bytearray([0x03, 0x00, 0x01, 0x0a, 0x00, 0x82, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]),
    bytearray([0x03, 0x00, 0x01, 0x08, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]),
    bytearray([0x03, 0x00, 0x01, 0x08, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]),
    bytearray([0x03, 0x00, 0x01, 0x08, 0x00, 0xc0, 0x00, 0x10, 0x00, 0x00, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]),
    bytearray([0x03, 0x00, 0x01, 0x0c, 0x00, 0x81, 0x00, 0x82, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]),
    bytearray([0x03, 0x00, 0x01, 0x0a, 0x00, 0x86, 0x01, 0x00, 0x0c, 0x04, 0x00, 0x00, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]),
    bytearray([0x03, 0x00, 0x01, 0x0c, 0x00, 0x81, 0x00, 0xc4, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]),
    bytearray([0x03, 0x00, 0x01, 0x0c, 0x00, 0x81, 0x00, 0xc7, 0x01, 0xc8, 0x00, 0x00, 0x00, 0x00, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]),
    bytearray([0x03, 0x00, 0x01, 0x0c, 0x00, 0x81, 0x00, 0xc5, 0x01, 0x8c, 0x00, 0x00, 0x00, 0x00, 0xc5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]),
    bytearray([0x03, 0x00, 0x01, 0x0c, 0x00, 0x81, 0x00, 0xc6, 0x01, 0x8c, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00]),
    bytearray([0x03, 0x00, 0x01, 0x0c, 0x00, 0x82, 0x00, 0x5f, 0x00, 0x23, 0x02, 0x24, 0x02, 0x00, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00])
]

# Rotate forward (clockwise)
MOVE_FWD = bytearray([
    0x03, 0x00, 0x01, 0x0c, 0x00,
    0x81, 0x00, 0x9e, 0x01, 0x02,
    0x00, 0x00, 0x00, 0x00, 0x10,
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00
])

# Rotate backward (counter clockwise)
MOVE_BKW = bytearray([
    0x03, 0x00, 0x01, 0x0c, 0x00,
    0x81, 0x00, 0x9e, 0x01, 0x03,
    0x00, 0x00, 0x00, 0x00, 0x11,
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00
])

# Stop rotation
STOP = bytearray([
    0x03, 0x00, 0x01, 0x0c, 0x00,
    0x81, 0x00, 0x9e, 0x01, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x13,
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00
])

# Alarm clear
ALMCLR = bytearray([
    0x03, 0x00, 0x01, 0x0c, 0x00,
    0x81, 0x00, 0xa0, 0x01, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x2d,
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00
])

# Query status
STATUS = bytearray([
    0x03, 0x00, 0x01, 0x18, 0x00,
    0x82, 0x00, 0x45, 0x00, 0x4f,
    0x00, 0xd2, 0x00, 0x23, 0x02,
    0x24, 0x02, 0x21, 0x02, 0xa4,
    0x00, 0xa7, 0x00, 0x15, 0x00,
    0x00, 0x70, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00
])
