# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ModelComponentModel',
    'ModelMetric',
    'ModelMetricDatasetSummary',
    'ModelMetricLabelMetricsReport',
    'ModelMetricLabelMetricsReportConfidenceEntry',
    'ModelMetricOverallMetricsReport',
    'ModelMetricOverallMetricsReportConfidenceEntry',
    'ModelTestingDataset',
    'ModelTrainingDataset',
    'ModelValidationDataset',
    'ProcessorJobInputLocation',
    'ProcessorJobInputLocationObjectLocation',
    'ProcessorJobOutputLocation',
    'ProcessorJobProcessorConfig',
    'ProcessorJobProcessorConfigFeature',
    'GetModelComponentModelResult',
    'GetModelMetricResult',
    'GetModelMetricDatasetSummaryResult',
    'GetModelMetricLabelMetricsReportResult',
    'GetModelMetricLabelMetricsReportConfidenceEntryResult',
    'GetModelMetricOverallMetricsReportResult',
    'GetModelMetricOverallMetricsReportConfidenceEntryResult',
    'GetModelTestingDatasetResult',
    'GetModelTrainingDatasetResult',
    'GetModelValidationDatasetResult',
    'GetModelsFilterResult',
    'GetModelsModelCollectionResult',
    'GetModelsModelCollectionItemResult',
    'GetModelsModelCollectionItemComponentModelResult',
    'GetModelsModelCollectionItemMetricResult',
    'GetModelsModelCollectionItemMetricDatasetSummaryResult',
    'GetModelsModelCollectionItemMetricLabelMetricsReportResult',
    'GetModelsModelCollectionItemMetricLabelMetricsReportConfidenceEntryResult',
    'GetModelsModelCollectionItemMetricOverallMetricsReportResult',
    'GetModelsModelCollectionItemMetricOverallMetricsReportConfidenceEntryResult',
    'GetModelsModelCollectionItemTestingDatasetResult',
    'GetModelsModelCollectionItemTrainingDatasetResult',
    'GetModelsModelCollectionItemValidationDatasetResult',
    'GetProcessorJobInputLocationResult',
    'GetProcessorJobInputLocationObjectLocationResult',
    'GetProcessorJobOutputLocationResult',
    'GetProcessorJobProcessorConfigResult',
    'GetProcessorJobProcessorConfigFeatureResult',
    'GetProjectsFilterResult',
    'GetProjectsProjectCollectionResult',
    'GetProjectsProjectCollectionItemResult',
]

@pulumi.output_type
class ModelComponentModel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modelId":
            suggest = "model_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelComponentModel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelComponentModel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelComponentModel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 model_id: Optional[str] = None):
        """
        :param str model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        return pulumi.get(self, "model_id")


@pulumi.output_type
class ModelMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetSummaries":
            suggest = "dataset_summaries"
        elif key == "labelMetricsReports":
            suggest = "label_metrics_reports"
        elif key == "modelType":
            suggest = "model_type"
        elif key == "overallMetricsReports":
            suggest = "overall_metrics_reports"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_summaries: Optional[Sequence['outputs.ModelMetricDatasetSummary']] = None,
                 label_metrics_reports: Optional[Sequence['outputs.ModelMetricLabelMetricsReport']] = None,
                 model_type: Optional[str] = None,
                 overall_metrics_reports: Optional[Sequence['outputs.ModelMetricOverallMetricsReport']] = None):
        """
        :param Sequence['ModelMetricDatasetSummaryArgs'] dataset_summaries: Summary of count of samples used during model training.
        :param Sequence['ModelMetricLabelMetricsReportArgs'] label_metrics_reports: List of metrics entries per label.
        :param str model_type: The type of the Document model.
        :param Sequence['ModelMetricOverallMetricsReportArgs'] overall_metrics_reports: Overall Metrics report for Document Classification Model.
        """
        if dataset_summaries is not None:
            pulumi.set(__self__, "dataset_summaries", dataset_summaries)
        if label_metrics_reports is not None:
            pulumi.set(__self__, "label_metrics_reports", label_metrics_reports)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if overall_metrics_reports is not None:
            pulumi.set(__self__, "overall_metrics_reports", overall_metrics_reports)

    @property
    @pulumi.getter(name="datasetSummaries")
    def dataset_summaries(self) -> Optional[Sequence['outputs.ModelMetricDatasetSummary']]:
        """
        Summary of count of samples used during model training.
        """
        return pulumi.get(self, "dataset_summaries")

    @property
    @pulumi.getter(name="labelMetricsReports")
    def label_metrics_reports(self) -> Optional[Sequence['outputs.ModelMetricLabelMetricsReport']]:
        """
        List of metrics entries per label.
        """
        return pulumi.get(self, "label_metrics_reports")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[str]:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="overallMetricsReports")
    def overall_metrics_reports(self) -> Optional[Sequence['outputs.ModelMetricOverallMetricsReport']]:
        """
        Overall Metrics report for Document Classification Model.
        """
        return pulumi.get(self, "overall_metrics_reports")


@pulumi.output_type
class ModelMetricDatasetSummary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "testSampleCount":
            suggest = "test_sample_count"
        elif key == "trainingSampleCount":
            suggest = "training_sample_count"
        elif key == "validationSampleCount":
            suggest = "validation_sample_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelMetricDatasetSummary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelMetricDatasetSummary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelMetricDatasetSummary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 test_sample_count: Optional[int] = None,
                 training_sample_count: Optional[int] = None,
                 validation_sample_count: Optional[int] = None):
        """
        :param int test_sample_count: Number of samples used for testing the model.
        :param int training_sample_count: Number of samples used for training the model.
        :param int validation_sample_count: Number of samples used for validating the model.
        """
        if test_sample_count is not None:
            pulumi.set(__self__, "test_sample_count", test_sample_count)
        if training_sample_count is not None:
            pulumi.set(__self__, "training_sample_count", training_sample_count)
        if validation_sample_count is not None:
            pulumi.set(__self__, "validation_sample_count", validation_sample_count)

    @property
    @pulumi.getter(name="testSampleCount")
    def test_sample_count(self) -> Optional[int]:
        """
        Number of samples used for testing the model.
        """
        return pulumi.get(self, "test_sample_count")

    @property
    @pulumi.getter(name="trainingSampleCount")
    def training_sample_count(self) -> Optional[int]:
        """
        Number of samples used for training the model.
        """
        return pulumi.get(self, "training_sample_count")

    @property
    @pulumi.getter(name="validationSampleCount")
    def validation_sample_count(self) -> Optional[int]:
        """
        Number of samples used for validating the model.
        """
        return pulumi.get(self, "validation_sample_count")


@pulumi.output_type
class ModelMetricLabelMetricsReport(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "confidenceEntries":
            suggest = "confidence_entries"
        elif key == "documentCount":
            suggest = "document_count"
        elif key == "meanAveragePrecision":
            suggest = "mean_average_precision"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelMetricLabelMetricsReport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelMetricLabelMetricsReport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelMetricLabelMetricsReport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidence_entries: Optional[Sequence['outputs.ModelMetricLabelMetricsReportConfidenceEntry']] = None,
                 document_count: Optional[int] = None,
                 label: Optional[str] = None,
                 mean_average_precision: Optional[float] = None):
        """
        :param Sequence['ModelMetricLabelMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param int document_count: Total test documents in the label.
        :param str label: Label name
        :param float mean_average_precision: Mean average precision under different thresholds
        """
        if confidence_entries is not None:
            pulumi.set(__self__, "confidence_entries", confidence_entries)
        if document_count is not None:
            pulumi.set(__self__, "document_count", document_count)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if mean_average_precision is not None:
            pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Optional[Sequence['outputs.ModelMetricLabelMetricsReportConfidenceEntry']]:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> Optional[int]:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        Label name
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> Optional[float]:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class ModelMetricLabelMetricsReportConfidenceEntry(dict):
    def __init__(__self__, *,
                 accuracy: Optional[float] = None,
                 f1score: Optional[float] = None,
                 precision: Optional[float] = None,
                 recall: Optional[float] = None,
                 threshold: Optional[float] = None):
        """
        :param float accuracy: accuracy under the threshold
        :param float f1score: f1Score under the threshold
        :param float precision: Precision under the threshold
        :param float recall: Recall under the threshold
        :param float threshold: Threshold used to calculate precision and recall.
        """
        if accuracy is not None:
            pulumi.set(__self__, "accuracy", accuracy)
        if f1score is not None:
            pulumi.set(__self__, "f1score", f1score)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if recall is not None:
            pulumi.set(__self__, "recall", recall)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def accuracy(self) -> Optional[float]:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter
    def f1score(self) -> Optional[float]:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @property
    @pulumi.getter
    def precision(self) -> Optional[float]:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> Optional[float]:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[float]:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class ModelMetricOverallMetricsReport(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "confidenceEntries":
            suggest = "confidence_entries"
        elif key == "documentCount":
            suggest = "document_count"
        elif key == "meanAveragePrecision":
            suggest = "mean_average_precision"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelMetricOverallMetricsReport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelMetricOverallMetricsReport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelMetricOverallMetricsReport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidence_entries: Optional[Sequence['outputs.ModelMetricOverallMetricsReportConfidenceEntry']] = None,
                 document_count: Optional[int] = None,
                 mean_average_precision: Optional[float] = None):
        """
        :param Sequence['ModelMetricOverallMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param int document_count: Total test documents in the label.
        :param float mean_average_precision: Mean average precision under different thresholds
        """
        if confidence_entries is not None:
            pulumi.set(__self__, "confidence_entries", confidence_entries)
        if document_count is not None:
            pulumi.set(__self__, "document_count", document_count)
        if mean_average_precision is not None:
            pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Optional[Sequence['outputs.ModelMetricOverallMetricsReportConfidenceEntry']]:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> Optional[int]:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> Optional[float]:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class ModelMetricOverallMetricsReportConfidenceEntry(dict):
    def __init__(__self__, *,
                 accuracy: Optional[float] = None,
                 f1score: Optional[float] = None,
                 precision: Optional[float] = None,
                 recall: Optional[float] = None,
                 threshold: Optional[float] = None):
        """
        :param float accuracy: accuracy under the threshold
        :param float f1score: f1Score under the threshold
        :param float precision: Precision under the threshold
        :param float recall: Recall under the threshold
        :param float threshold: Threshold used to calculate precision and recall.
        """
        if accuracy is not None:
            pulumi.set(__self__, "accuracy", accuracy)
        if f1score is not None:
            pulumi.set(__self__, "f1score", f1score)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if recall is not None:
            pulumi.set(__self__, "recall", recall)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def accuracy(self) -> Optional[float]:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter
    def f1score(self) -> Optional[float]:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @property
    @pulumi.getter
    def precision(self) -> Optional[float]:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> Optional[float]:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[float]:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class ModelTestingDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"
        elif key == "datasetId":
            suggest = "dataset_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTestingDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTestingDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTestingDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_type: str,
                 bucket: Optional[str] = None,
                 dataset_id: Optional[str] = None,
                 namespace: Optional[str] = None,
                 object: Optional[str] = None):
        """
        :param str dataset_type: The dataset type, based on where it is stored.
        :param str bucket: The name of the Object Storage bucket that contains the input data file.
        :param str dataset_id: OCID of the Data Labeling dataset.
        :param str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param str object: The object name of the input data file.
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[str]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class ModelTrainingDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"
        elif key == "datasetId":
            suggest = "dataset_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTrainingDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTrainingDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTrainingDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_type: str,
                 bucket: Optional[str] = None,
                 dataset_id: Optional[str] = None,
                 namespace: Optional[str] = None,
                 object: Optional[str] = None):
        """
        :param str dataset_type: The dataset type, based on where it is stored.
        :param str bucket: The name of the Object Storage bucket that contains the input data file.
        :param str dataset_id: OCID of the Data Labeling dataset.
        :param str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param str object: The object name of the input data file.
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[str]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class ModelValidationDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"
        elif key == "datasetId":
            suggest = "dataset_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelValidationDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelValidationDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelValidationDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_type: str,
                 bucket: Optional[str] = None,
                 dataset_id: Optional[str] = None,
                 namespace: Optional[str] = None,
                 object: Optional[str] = None):
        """
        :param str dataset_type: The dataset type, based on where it is stored.
        :param str bucket: The name of the Object Storage bucket that contains the input data file.
        :param str dataset_id: OCID of the Data Labeling dataset.
        :param str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param str object: The object name of the input data file.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[str]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        The object name of the input data file.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class ProcessorJobInputLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceType":
            suggest = "source_type"
        elif key == "objectLocations":
            suggest = "object_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProcessorJobInputLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProcessorJobInputLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProcessorJobInputLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_type: str,
                 data: Optional[str] = None,
                 object_locations: Optional[Sequence['outputs.ProcessorJobInputLocationObjectLocation']] = None):
        """
        :param str source_type: The type of input location. The allowed values are:
               * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
               * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        :param str data: Raw document data with Base64 encoding.
        :param Sequence['ProcessorJobInputLocationObjectLocationArgs'] object_locations: The list of ObjectLocations.
        """
        pulumi.set(__self__, "source_type", source_type)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if object_locations is not None:
            pulumi.set(__self__, "object_locations", object_locations)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The type of input location. The allowed values are:
        * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
        * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def data(self) -> Optional[str]:
        """
        Raw document data with Base64 encoding.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="objectLocations")
    def object_locations(self) -> Optional[Sequence['outputs.ProcessorJobInputLocationObjectLocation']]:
        """
        The list of ObjectLocations.
        """
        return pulumi.get(self, "object_locations")


@pulumi.output_type
class ProcessorJobInputLocationObjectLocation(dict):
    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 namespace: Optional[str] = None,
                 object: Optional[str] = None):
        """
        :param str bucket: The Object Storage bucket name.
        :param str namespace: The Object Storage namespace name.
        :param str object: The Object Storage object name.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The Object Storage namespace name.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        The Object Storage object name.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class ProcessorJobOutputLocation(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 prefix: str):
        """
        :param str bucket: The Object Storage bucket name.
        :param str namespace: The Object Storage namespace.
        :param str prefix: The Object Storage folder name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        The Object Storage folder name.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class ProcessorJobProcessorConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "processorType":
            suggest = "processor_type"
        elif key == "documentType":
            suggest = "document_type"
        elif key == "isZipOutputEnabled":
            suggest = "is_zip_output_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProcessorJobProcessorConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProcessorJobProcessorConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProcessorJobProcessorConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 features: Sequence['outputs.ProcessorJobProcessorConfigFeature'],
                 processor_type: str,
                 document_type: Optional[str] = None,
                 is_zip_output_enabled: Optional[bool] = None,
                 language: Optional[str] = None):
        """
        :param Sequence['ProcessorJobProcessorConfigFeatureArgs'] features: The types of document analysis requested.
        :param str processor_type: The type of the processor.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param str document_type: The document type.
        :param bool is_zip_output_enabled: Whether or not to generate a ZIP file containing the results.
        :param str language: The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        """
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "processor_type", processor_type)
        if document_type is not None:
            pulumi.set(__self__, "document_type", document_type)
        if is_zip_output_enabled is not None:
            pulumi.set(__self__, "is_zip_output_enabled", is_zip_output_enabled)
        if language is not None:
            pulumi.set(__self__, "language", language)

    @property
    @pulumi.getter
    def features(self) -> Sequence['outputs.ProcessorJobProcessorConfigFeature']:
        """
        The types of document analysis requested.
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter(name="processorType")
    def processor_type(self) -> str:
        """
        The type of the processor.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "processor_type")

    @property
    @pulumi.getter(name="documentType")
    def document_type(self) -> Optional[str]:
        """
        The document type.
        """
        return pulumi.get(self, "document_type")

    @property
    @pulumi.getter(name="isZipOutputEnabled")
    def is_zip_output_enabled(self) -> Optional[bool]:
        """
        Whether or not to generate a ZIP file containing the results.
        """
        return pulumi.get(self, "is_zip_output_enabled")

    @property
    @pulumi.getter
    def language(self) -> Optional[str]:
        """
        The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        """
        return pulumi.get(self, "language")


@pulumi.output_type
class ProcessorJobProcessorConfigFeature(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "featureType":
            suggest = "feature_type"
        elif key == "generateSearchablePdf":
            suggest = "generate_searchable_pdf"
        elif key == "maxResults":
            suggest = "max_results"
        elif key == "modelId":
            suggest = "model_id"
        elif key == "tenancyId":
            suggest = "tenancy_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProcessorJobProcessorConfigFeature. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProcessorJobProcessorConfigFeature.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProcessorJobProcessorConfigFeature.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 feature_type: str,
                 generate_searchable_pdf: Optional[bool] = None,
                 max_results: Optional[int] = None,
                 model_id: Optional[str] = None,
                 tenancy_id: Optional[str] = None):
        """
        :param str feature_type: The type of document analysis requested. The allowed values are:
               * `LANGUAGE_CLASSIFICATION`: Detect the language.
               * `TEXT_EXTRACTION`: Recognize text.
               * `TABLE_EXTRACTION`: Detect and extract data in tables.
               * `KEY_VALUE_EXTRACTION`: Extract form fields.
               * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
        :param bool generate_searchable_pdf: Whether or not to generate a searchable PDF file.
        :param int max_results: The maximum number of results to return.
        :param str model_id: The custom model ID.
        :param str tenancy_id: The custom model tenancy ID when modelId represents aliasName.
        """
        pulumi.set(__self__, "feature_type", feature_type)
        if generate_searchable_pdf is not None:
            pulumi.set(__self__, "generate_searchable_pdf", generate_searchable_pdf)
        if max_results is not None:
            pulumi.set(__self__, "max_results", max_results)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if tenancy_id is not None:
            pulumi.set(__self__, "tenancy_id", tenancy_id)

    @property
    @pulumi.getter(name="featureType")
    def feature_type(self) -> str:
        """
        The type of document analysis requested. The allowed values are:
        * `LANGUAGE_CLASSIFICATION`: Detect the language.
        * `TEXT_EXTRACTION`: Recognize text.
        * `TABLE_EXTRACTION`: Detect and extract data in tables.
        * `KEY_VALUE_EXTRACTION`: Extract form fields.
        * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
        """
        return pulumi.get(self, "feature_type")

    @property
    @pulumi.getter(name="generateSearchablePdf")
    def generate_searchable_pdf(self) -> Optional[bool]:
        """
        Whether or not to generate a searchable PDF file.
        """
        return pulumi.get(self, "generate_searchable_pdf")

    @property
    @pulumi.getter(name="maxResults")
    def max_results(self) -> Optional[int]:
        """
        The maximum number of results to return.
        """
        return pulumi.get(self, "max_results")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[str]:
        """
        The custom model ID.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[str]:
        """
        The custom model tenancy ID when modelId represents aliasName.
        """
        return pulumi.get(self, "tenancy_id")


@pulumi.output_type
class GetModelComponentModelResult(dict):
    def __init__(__self__, *,
                 model_id: str):
        """
        :param str model_id: A unique model identifier.
        """
        pulumi.set(__self__, "model_id", model_id)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> str:
        """
        A unique model identifier.
        """
        return pulumi.get(self, "model_id")


@pulumi.output_type
class GetModelMetricResult(dict):
    def __init__(__self__, *,
                 dataset_summaries: Sequence['outputs.GetModelMetricDatasetSummaryResult'],
                 label_metrics_reports: Sequence['outputs.GetModelMetricLabelMetricsReportResult'],
                 model_type: str,
                 overall_metrics_reports: Sequence['outputs.GetModelMetricOverallMetricsReportResult']):
        """
        :param Sequence['GetModelMetricDatasetSummaryArgs'] dataset_summaries: Summary of count of samples used during model training.
        :param Sequence['GetModelMetricLabelMetricsReportArgs'] label_metrics_reports: List of metrics entries per label.
        :param str model_type: The type of the Document model.
        :param Sequence['GetModelMetricOverallMetricsReportArgs'] overall_metrics_reports: Overall Metrics report for Document Classification Model.
        """
        pulumi.set(__self__, "dataset_summaries", dataset_summaries)
        pulumi.set(__self__, "label_metrics_reports", label_metrics_reports)
        pulumi.set(__self__, "model_type", model_type)
        pulumi.set(__self__, "overall_metrics_reports", overall_metrics_reports)

    @property
    @pulumi.getter(name="datasetSummaries")
    def dataset_summaries(self) -> Sequence['outputs.GetModelMetricDatasetSummaryResult']:
        """
        Summary of count of samples used during model training.
        """
        return pulumi.get(self, "dataset_summaries")

    @property
    @pulumi.getter(name="labelMetricsReports")
    def label_metrics_reports(self) -> Sequence['outputs.GetModelMetricLabelMetricsReportResult']:
        """
        List of metrics entries per label.
        """
        return pulumi.get(self, "label_metrics_reports")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> str:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="overallMetricsReports")
    def overall_metrics_reports(self) -> Sequence['outputs.GetModelMetricOverallMetricsReportResult']:
        """
        Overall Metrics report for Document Classification Model.
        """
        return pulumi.get(self, "overall_metrics_reports")


@pulumi.output_type
class GetModelMetricDatasetSummaryResult(dict):
    def __init__(__self__, *,
                 test_sample_count: int,
                 training_sample_count: int,
                 validation_sample_count: int):
        """
        :param int test_sample_count: Number of samples used for testing the model.
        :param int training_sample_count: Number of samples used for training the model.
        :param int validation_sample_count: Number of samples used for validating the model.
        """
        pulumi.set(__self__, "test_sample_count", test_sample_count)
        pulumi.set(__self__, "training_sample_count", training_sample_count)
        pulumi.set(__self__, "validation_sample_count", validation_sample_count)

    @property
    @pulumi.getter(name="testSampleCount")
    def test_sample_count(self) -> int:
        """
        Number of samples used for testing the model.
        """
        return pulumi.get(self, "test_sample_count")

    @property
    @pulumi.getter(name="trainingSampleCount")
    def training_sample_count(self) -> int:
        """
        Number of samples used for training the model.
        """
        return pulumi.get(self, "training_sample_count")

    @property
    @pulumi.getter(name="validationSampleCount")
    def validation_sample_count(self) -> int:
        """
        Number of samples used for validating the model.
        """
        return pulumi.get(self, "validation_sample_count")


@pulumi.output_type
class GetModelMetricLabelMetricsReportResult(dict):
    def __init__(__self__, *,
                 confidence_entries: Sequence['outputs.GetModelMetricLabelMetricsReportConfidenceEntryResult'],
                 document_count: int,
                 label: str,
                 mean_average_precision: float):
        """
        :param Sequence['GetModelMetricLabelMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param int document_count: Total test documents in the label.
        :param str label: Label name
        :param float mean_average_precision: Mean average precision under different thresholds
        """
        pulumi.set(__self__, "confidence_entries", confidence_entries)
        pulumi.set(__self__, "document_count", document_count)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Sequence['outputs.GetModelMetricLabelMetricsReportConfidenceEntryResult']:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> int:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Label name
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> float:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class GetModelMetricLabelMetricsReportConfidenceEntryResult(dict):
    def __init__(__self__, *,
                 accuracy: float,
                 f1score: float,
                 precision: float,
                 recall: float,
                 threshold: float):
        """
        :param float accuracy: accuracy under the threshold
        :param float f1score: f1Score under the threshold
        :param float precision: Precision under the threshold
        :param float recall: Recall under the threshold
        :param float threshold: Threshold used to calculate precision and recall.
        """
        pulumi.set(__self__, "accuracy", accuracy)
        pulumi.set(__self__, "f1score", f1score)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "recall", recall)
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def accuracy(self) -> float:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter
    def f1score(self) -> float:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @property
    @pulumi.getter
    def precision(self) -> float:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> float:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetModelMetricOverallMetricsReportResult(dict):
    def __init__(__self__, *,
                 confidence_entries: Sequence['outputs.GetModelMetricOverallMetricsReportConfidenceEntryResult'],
                 document_count: int,
                 mean_average_precision: float):
        """
        :param Sequence['GetModelMetricOverallMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param int document_count: Total test documents in the label.
        :param float mean_average_precision: Mean average precision under different thresholds
        """
        pulumi.set(__self__, "confidence_entries", confidence_entries)
        pulumi.set(__self__, "document_count", document_count)
        pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Sequence['outputs.GetModelMetricOverallMetricsReportConfidenceEntryResult']:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> int:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> float:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class GetModelMetricOverallMetricsReportConfidenceEntryResult(dict):
    def __init__(__self__, *,
                 accuracy: float,
                 f1score: float,
                 precision: float,
                 recall: float,
                 threshold: float):
        """
        :param float accuracy: accuracy under the threshold
        :param float f1score: f1Score under the threshold
        :param float precision: Precision under the threshold
        :param float recall: Recall under the threshold
        :param float threshold: Threshold used to calculate precision and recall.
        """
        pulumi.set(__self__, "accuracy", accuracy)
        pulumi.set(__self__, "f1score", f1score)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "recall", recall)
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def accuracy(self) -> float:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter
    def f1score(self) -> float:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @property
    @pulumi.getter
    def precision(self) -> float:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> float:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetModelTestingDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 dataset_id: str,
                 dataset_type: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: The name of the Object Storage bucket that contains the input data file.
        :param str dataset_id: OCID of the Data Labeling dataset.
        :param str dataset_type: The dataset type, based on where it is stored.
        :param str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetModelTrainingDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 dataset_id: str,
                 dataset_type: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: The name of the Object Storage bucket that contains the input data file.
        :param str dataset_id: OCID of the Data Labeling dataset.
        :param str dataset_type: The dataset type, based on where it is stored.
        :param str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetModelValidationDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 dataset_id: str,
                 dataset_type: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: The name of the Object Storage bucket that contains the input data file.
        :param str dataset_id: OCID of the Data Labeling dataset.
        :param str dataset_type: The dataset type, based on where it is stored.
        :param str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetModelsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetModelsModelCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetModelsModelCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetModelsModelCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetModelsModelCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 component_models: Sequence['outputs.GetModelsModelCollectionItemComponentModelResult'],
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_composed_model: bool,
                 is_quick_mode: bool,
                 labels: Sequence[str],
                 lifecycle_details: str,
                 max_training_time_in_hours: float,
                 metrics: Sequence['outputs.GetModelsModelCollectionItemMetricResult'],
                 model_id: str,
                 model_type: str,
                 model_version: str,
                 project_id: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 tenancy_id: str,
                 testing_datasets: Sequence['outputs.GetModelsModelCollectionItemTestingDatasetResult'],
                 time_created: str,
                 time_updated: str,
                 trained_time_in_hours: float,
                 training_datasets: Sequence['outputs.GetModelsModelCollectionItemTrainingDatasetResult'],
                 validation_datasets: Sequence['outputs.GetModelsModelCollectionItemValidationDatasetResult']):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Sequence['GetModelsModelCollectionItemComponentModelArgs'] component_models: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) collection of active custom Key Value models that need to be composed.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param str description: An optional description of the model.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param str id: The filter to find the model with the given identifier.
        :param bool is_composed_model: Set to true when the model is created by using multiple key value extraction models.
        :param bool is_quick_mode: Set to true when experimenting with a new model type or dataset, so model training is quick, with a predefined low number of passes through the training data.
        :param Sequence[str] labels: The collection of labels used to train the custom model.
        :param str lifecycle_details: A message describing the current state in more detail, that can provide actionable information if training failed.
        :param float max_training_time_in_hours: The maximum model training time in hours, expressed as a decimal fraction.
        :param Sequence['GetModelsModelCollectionItemMetricArgs'] metrics: Trained Model Metrics.
        :param str model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        :param str model_type: The type of the Document model.
        :param str model_version: The version of the model.
        :param str project_id: The ID of the project for which to list the objects.
        :param str state: The filter to match models with the given lifecycleState.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        :param str tenancy_id: The tenancy id of the model.
        :param Sequence['GetModelsModelCollectionItemTestingDatasetArgs'] testing_datasets: The base entity which is the input for creating and training a model.
        :param str time_created: When the model was created, as an RFC3339 datetime string.
        :param str time_updated: When the model was updated, as an RFC3339 datetime string.
        :param float trained_time_in_hours: The total hours actually used for model training.
        :param Sequence['GetModelsModelCollectionItemTrainingDatasetArgs'] training_datasets: The base entity which is the input for creating and training a model.
        :param Sequence['GetModelsModelCollectionItemValidationDatasetArgs'] validation_datasets: The base entity which is the input for creating and training a model.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "component_models", component_models)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_composed_model", is_composed_model)
        pulumi.set(__self__, "is_quick_mode", is_quick_mode)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "max_training_time_in_hours", max_training_time_in_hours)
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "model_type", model_type)
        pulumi.set(__self__, "model_version", model_version)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        pulumi.set(__self__, "testing_datasets", testing_datasets)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "trained_time_in_hours", trained_time_in_hours)
        pulumi.set(__self__, "training_datasets", training_datasets)
        pulumi.set(__self__, "validation_datasets", validation_datasets)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="componentModels")
    def component_models(self) -> Sequence['outputs.GetModelsModelCollectionItemComponentModelResult']:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) collection of active custom Key Value models that need to be composed.
        """
        return pulumi.get(self, "component_models")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional description of the model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The filter to find the model with the given identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isComposedModel")
    def is_composed_model(self) -> bool:
        """
        Set to true when the model is created by using multiple key value extraction models.
        """
        return pulumi.get(self, "is_composed_model")

    @property
    @pulumi.getter(name="isQuickMode")
    def is_quick_mode(self) -> bool:
        """
        Set to true when experimenting with a new model type or dataset, so model training is quick, with a predefined low number of passes through the training data.
        """
        return pulumi.get(self, "is_quick_mode")

    @property
    @pulumi.getter
    def labels(self) -> Sequence[str]:
        """
        The collection of labels used to train the custom model.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail, that can provide actionable information if training failed.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maxTrainingTimeInHours")
    def max_training_time_in_hours(self) -> float:
        """
        The maximum model training time in hours, expressed as a decimal fraction.
        """
        return pulumi.get(self, "max_training_time_in_hours")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricResult']:
        """
        Trained Model Metrics.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> str:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> str:
        """
        The version of the model.
        """
        return pulumi.get(self, "model_version")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project for which to list the objects.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The filter to match models with the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> str:
        """
        The tenancy id of the model.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="testingDatasets")
    def testing_datasets(self) -> Sequence['outputs.GetModelsModelCollectionItemTestingDatasetResult']:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "testing_datasets")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        When the model was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        When the model was updated, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="trainedTimeInHours")
    def trained_time_in_hours(self) -> float:
        """
        The total hours actually used for model training.
        """
        return pulumi.get(self, "trained_time_in_hours")

    @property
    @pulumi.getter(name="trainingDatasets")
    def training_datasets(self) -> Sequence['outputs.GetModelsModelCollectionItemTrainingDatasetResult']:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "training_datasets")

    @property
    @pulumi.getter(name="validationDatasets")
    def validation_datasets(self) -> Sequence['outputs.GetModelsModelCollectionItemValidationDatasetResult']:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "validation_datasets")


@pulumi.output_type
class GetModelsModelCollectionItemComponentModelResult(dict):
    def __init__(__self__, *,
                 model_id: str):
        """
        :param str model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        pulumi.set(__self__, "model_id", model_id)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        return pulumi.get(self, "model_id")


@pulumi.output_type
class GetModelsModelCollectionItemMetricResult(dict):
    def __init__(__self__, *,
                 dataset_summaries: Sequence['outputs.GetModelsModelCollectionItemMetricDatasetSummaryResult'],
                 label_metrics_reports: Sequence['outputs.GetModelsModelCollectionItemMetricLabelMetricsReportResult'],
                 model_type: str,
                 overall_metrics_reports: Sequence['outputs.GetModelsModelCollectionItemMetricOverallMetricsReportResult']):
        """
        :param Sequence['GetModelsModelCollectionItemMetricDatasetSummaryArgs'] dataset_summaries: Summary of count of samples used during model training.
        :param Sequence['GetModelsModelCollectionItemMetricLabelMetricsReportArgs'] label_metrics_reports: List of metrics entries per label.
        :param str model_type: The type of the Document model.
        :param Sequence['GetModelsModelCollectionItemMetricOverallMetricsReportArgs'] overall_metrics_reports: Overall Metrics report for Document Classification Model.
        """
        pulumi.set(__self__, "dataset_summaries", dataset_summaries)
        pulumi.set(__self__, "label_metrics_reports", label_metrics_reports)
        pulumi.set(__self__, "model_type", model_type)
        pulumi.set(__self__, "overall_metrics_reports", overall_metrics_reports)

    @property
    @pulumi.getter(name="datasetSummaries")
    def dataset_summaries(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricDatasetSummaryResult']:
        """
        Summary of count of samples used during model training.
        """
        return pulumi.get(self, "dataset_summaries")

    @property
    @pulumi.getter(name="labelMetricsReports")
    def label_metrics_reports(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricLabelMetricsReportResult']:
        """
        List of metrics entries per label.
        """
        return pulumi.get(self, "label_metrics_reports")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> str:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="overallMetricsReports")
    def overall_metrics_reports(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricOverallMetricsReportResult']:
        """
        Overall Metrics report for Document Classification Model.
        """
        return pulumi.get(self, "overall_metrics_reports")


@pulumi.output_type
class GetModelsModelCollectionItemMetricDatasetSummaryResult(dict):
    def __init__(__self__, *,
                 test_sample_count: int,
                 training_sample_count: int,
                 validation_sample_count: int):
        """
        :param int test_sample_count: Number of samples used for testing the model.
        :param int training_sample_count: Number of samples used for training the model.
        :param int validation_sample_count: Number of samples used for validating the model.
        """
        pulumi.set(__self__, "test_sample_count", test_sample_count)
        pulumi.set(__self__, "training_sample_count", training_sample_count)
        pulumi.set(__self__, "validation_sample_count", validation_sample_count)

    @property
    @pulumi.getter(name="testSampleCount")
    def test_sample_count(self) -> int:
        """
        Number of samples used for testing the model.
        """
        return pulumi.get(self, "test_sample_count")

    @property
    @pulumi.getter(name="trainingSampleCount")
    def training_sample_count(self) -> int:
        """
        Number of samples used for training the model.
        """
        return pulumi.get(self, "training_sample_count")

    @property
    @pulumi.getter(name="validationSampleCount")
    def validation_sample_count(self) -> int:
        """
        Number of samples used for validating the model.
        """
        return pulumi.get(self, "validation_sample_count")


@pulumi.output_type
class GetModelsModelCollectionItemMetricLabelMetricsReportResult(dict):
    def __init__(__self__, *,
                 confidence_entries: Sequence['outputs.GetModelsModelCollectionItemMetricLabelMetricsReportConfidenceEntryResult'],
                 document_count: int,
                 label: str,
                 mean_average_precision: float):
        """
        :param Sequence['GetModelsModelCollectionItemMetricLabelMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param int document_count: Total test documents in the label.
        :param str label: Label name
        :param float mean_average_precision: Mean average precision under different thresholds
        """
        pulumi.set(__self__, "confidence_entries", confidence_entries)
        pulumi.set(__self__, "document_count", document_count)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricLabelMetricsReportConfidenceEntryResult']:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> int:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Label name
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> float:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class GetModelsModelCollectionItemMetricLabelMetricsReportConfidenceEntryResult(dict):
    def __init__(__self__, *,
                 accuracy: float,
                 f1score: float,
                 precision: float,
                 recall: float,
                 threshold: float):
        """
        :param float accuracy: accuracy under the threshold
        :param float f1score: f1Score under the threshold
        :param float precision: Precision under the threshold
        :param float recall: Recall under the threshold
        :param float threshold: Threshold used to calculate precision and recall.
        """
        pulumi.set(__self__, "accuracy", accuracy)
        pulumi.set(__self__, "f1score", f1score)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "recall", recall)
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def accuracy(self) -> float:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter
    def f1score(self) -> float:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @property
    @pulumi.getter
    def precision(self) -> float:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> float:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetModelsModelCollectionItemMetricOverallMetricsReportResult(dict):
    def __init__(__self__, *,
                 confidence_entries: Sequence['outputs.GetModelsModelCollectionItemMetricOverallMetricsReportConfidenceEntryResult'],
                 document_count: int,
                 mean_average_precision: float):
        """
        :param Sequence['GetModelsModelCollectionItemMetricOverallMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param int document_count: Total test documents in the label.
        :param float mean_average_precision: Mean average precision under different thresholds
        """
        pulumi.set(__self__, "confidence_entries", confidence_entries)
        pulumi.set(__self__, "document_count", document_count)
        pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricOverallMetricsReportConfidenceEntryResult']:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> int:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> float:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class GetModelsModelCollectionItemMetricOverallMetricsReportConfidenceEntryResult(dict):
    def __init__(__self__, *,
                 accuracy: float,
                 f1score: float,
                 precision: float,
                 recall: float,
                 threshold: float):
        """
        :param float accuracy: accuracy under the threshold
        :param float f1score: f1Score under the threshold
        :param float precision: Precision under the threshold
        :param float recall: Recall under the threshold
        :param float threshold: Threshold used to calculate precision and recall.
        """
        pulumi.set(__self__, "accuracy", accuracy)
        pulumi.set(__self__, "f1score", f1score)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "recall", recall)
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def accuracy(self) -> float:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter
    def f1score(self) -> float:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @property
    @pulumi.getter
    def precision(self) -> float:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> float:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def threshold(self) -> float:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetModelsModelCollectionItemTestingDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 dataset_id: str,
                 dataset_type: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: The name of the Object Storage bucket that contains the input data file.
        :param str dataset_id: OCID of the Data Labeling dataset.
        :param str dataset_type: The dataset type, based on where it is stored.
        :param str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetModelsModelCollectionItemTrainingDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 dataset_id: str,
                 dataset_type: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: The name of the Object Storage bucket that contains the input data file.
        :param str dataset_id: OCID of the Data Labeling dataset.
        :param str dataset_type: The dataset type, based on where it is stored.
        :param str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetModelsModelCollectionItemValidationDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 dataset_id: str,
                 dataset_type: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: The name of the Object Storage bucket that contains the input data file.
        :param str dataset_id: OCID of the Data Labeling dataset.
        :param str dataset_type: The dataset type, based on where it is stored.
        :param str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetProcessorJobInputLocationResult(dict):
    def __init__(__self__, *,
                 data: str,
                 object_locations: Sequence['outputs.GetProcessorJobInputLocationObjectLocationResult'],
                 source_type: str):
        """
        :param str data: Raw document data with Base64 encoding.
        :param Sequence['GetProcessorJobInputLocationObjectLocationArgs'] object_locations: The list of ObjectLocations.
        :param str source_type: The type of input location. The allowed values are:
               * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
               * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "object_locations", object_locations)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter
    def data(self) -> str:
        """
        Raw document data with Base64 encoding.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="objectLocations")
    def object_locations(self) -> Sequence['outputs.GetProcessorJobInputLocationObjectLocationResult']:
        """
        The list of ObjectLocations.
        """
        return pulumi.get(self, "object_locations")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The type of input location. The allowed values are:
        * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
        * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetProcessorJobInputLocationObjectLocationResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: The Object Storage bucket name.
        :param str namespace: The Object Storage namespace.
        :param str object: The Object Storage object name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The Object Storage object name.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetProcessorJobOutputLocationResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 prefix: str):
        """
        :param str bucket: The Object Storage bucket name.
        :param str namespace: The Object Storage namespace.
        :param str prefix: The Object Storage folder name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        The Object Storage folder name.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class GetProcessorJobProcessorConfigResult(dict):
    def __init__(__self__, *,
                 document_type: str,
                 features: Sequence['outputs.GetProcessorJobProcessorConfigFeatureResult'],
                 is_zip_output_enabled: bool,
                 language: str,
                 processor_type: str):
        """
        :param str document_type: The document type.
        :param Sequence['GetProcessorJobProcessorConfigFeatureArgs'] features: The types of document analysis requested.
        :param bool is_zip_output_enabled: Whether or not to generate a ZIP file containing the results.
        :param str language: The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        :param str processor_type: The type of the processor.
        """
        pulumi.set(__self__, "document_type", document_type)
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "is_zip_output_enabled", is_zip_output_enabled)
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "processor_type", processor_type)

    @property
    @pulumi.getter(name="documentType")
    def document_type(self) -> str:
        """
        The document type.
        """
        return pulumi.get(self, "document_type")

    @property
    @pulumi.getter
    def features(self) -> Sequence['outputs.GetProcessorJobProcessorConfigFeatureResult']:
        """
        The types of document analysis requested.
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter(name="isZipOutputEnabled")
    def is_zip_output_enabled(self) -> bool:
        """
        Whether or not to generate a ZIP file containing the results.
        """
        return pulumi.get(self, "is_zip_output_enabled")

    @property
    @pulumi.getter
    def language(self) -> str:
        """
        The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="processorType")
    def processor_type(self) -> str:
        """
        The type of the processor.
        """
        return pulumi.get(self, "processor_type")


@pulumi.output_type
class GetProcessorJobProcessorConfigFeatureResult(dict):
    def __init__(__self__, *,
                 feature_type: str,
                 generate_searchable_pdf: bool,
                 max_results: int,
                 model_id: str,
                 tenancy_id: str):
        """
        :param str feature_type: The type of document analysis requested. The allowed values are:
               * `LANGUAGE_CLASSIFICATION`: Detect the language.
               * `TEXT_EXTRACTION`: Recognize text.
               * `TABLE_EXTRACTION`: Detect and extract data in tables.
               * `KEY_VALUE_EXTRACTION`: Extract form fields.
               * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
        :param bool generate_searchable_pdf: Whether or not to generate a searchable PDF file.
        :param int max_results: The maximum number of results to return.
        :param str model_id: The custom model ID.
        :param str tenancy_id: The custom model tenancy ID when modelId represents aliasName.
        """
        pulumi.set(__self__, "feature_type", feature_type)
        pulumi.set(__self__, "generate_searchable_pdf", generate_searchable_pdf)
        pulumi.set(__self__, "max_results", max_results)
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "tenancy_id", tenancy_id)

    @property
    @pulumi.getter(name="featureType")
    def feature_type(self) -> str:
        """
        The type of document analysis requested. The allowed values are:
        * `LANGUAGE_CLASSIFICATION`: Detect the language.
        * `TEXT_EXTRACTION`: Recognize text.
        * `TABLE_EXTRACTION`: Detect and extract data in tables.
        * `KEY_VALUE_EXTRACTION`: Extract form fields.
        * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
        """
        return pulumi.get(self, "feature_type")

    @property
    @pulumi.getter(name="generateSearchablePdf")
    def generate_searchable_pdf(self) -> bool:
        """
        Whether or not to generate a searchable PDF file.
        """
        return pulumi.get(self, "generate_searchable_pdf")

    @property
    @pulumi.getter(name="maxResults")
    def max_results(self) -> int:
        """
        The maximum number of results to return.
        """
        return pulumi.get(self, "max_results")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> str:
        """
        The custom model ID.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> str:
        """
        The custom model tenancy ID when modelId represents aliasName.
        """
        return pulumi.get(self, "tenancy_id")


@pulumi.output_type
class GetProjectsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetProjectsProjectCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProjectsProjectCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProjectsProjectCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProjectsProjectCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 lifecycle_details: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param str description: An optional description of the project.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param str id: The filter to find the project with the given identifier.
        :param str lifecycle_details: A message describing the current state in more detail, that can provide actionable information if creation failed.
        :param str state: The filter to match projects with the given lifecycleState.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        :param str time_created: When the project was created, as an RFC3339 datetime string.
        :param str time_updated: When the project was updated, as an RFC3339 datetime string.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional description of the project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The filter to find the project with the given identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail, that can provide actionable information if creation failed.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The filter to match projects with the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        When the project was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        When the project was updated, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")


