# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BlockchainPlatformArgs', 'BlockchainPlatform']

@pulumi.input_type
class BlockchainPlatformArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 compute_shape: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 idcs_access_token: pulumi.Input[str],
                 platform_role: pulumi.Input[str],
                 ca_cert_archive_text: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 federated_user_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_byol: Optional[pulumi.Input[bool]] = None,
                 load_balancer_shape: Optional[pulumi.Input[str]] = None,
                 platform_version: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input['BlockchainPlatformReplicasArgs']] = None,
                 storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 total_ocpu_capacity: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a BlockchainPlatform resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier
        :param pulumi.Input[str] compute_shape: Compute shape - STANDARD or ENTERPRISE_SMALL or ENTERPRISE_MEDIUM or ENTERPRISE_LARGE or ENTERPRISE_EXTRA_LARGE
        :param pulumi.Input[str] display_name: Platform Instance Display name, can be renamed
        :param pulumi.Input[str] idcs_access_token: IDCS access token with Identity Domain Administrator role
        :param pulumi.Input[str] platform_role: Role of platform - founder or participant
        :param pulumi.Input[str] ca_cert_archive_text: Base64 encoded text in ASCII character set of a Thirdparty CA Certificates archive file. The Archive file is a zip file containing third part CA Certificates, the ca key and certificate files used when issuing enrollment certificates (ECerts) and transaction certificates (TCerts). The chainfile (if it exists) contains the certificate chain which should be trusted for this CA, where the 1st in the chain is always the root CA certificate. File list in zip file [ca-cert.pem,ca-key.pem,ca-chain.pem(optional)].
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Platform Instance Description
        :param pulumi.Input[str] federated_user_id: Identifier for a federated user
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_byol: Bring your own license
        :param pulumi.Input[str] load_balancer_shape: (Updatable) Type of Load Balancer shape - LB_100_MBPS or LB_400_MBPS. Default is LB_100_MBPS.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] platform_version: Platform version
        :param pulumi.Input['BlockchainPlatformReplicasArgs'] replicas: Number of replicas of service components like Rest Proxy, CA and Console
        :param pulumi.Input[float] storage_size_in_tbs: Storage size in TBs
        :param pulumi.Input[int] total_ocpu_capacity: Number of total OCPUs allocated to the platform cluster
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "compute_shape", compute_shape)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "idcs_access_token", idcs_access_token)
        pulumi.set(__self__, "platform_role", platform_role)
        if ca_cert_archive_text is not None:
            pulumi.set(__self__, "ca_cert_archive_text", ca_cert_archive_text)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if federated_user_id is not None:
            pulumi.set(__self__, "federated_user_id", federated_user_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_byol is not None:
            pulumi.set(__self__, "is_byol", is_byol)
        if load_balancer_shape is not None:
            pulumi.set(__self__, "load_balancer_shape", load_balancer_shape)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if storage_size_in_tbs is not None:
            pulumi.set(__self__, "storage_size_in_tbs", storage_size_in_tbs)
        if total_ocpu_capacity is not None:
            pulumi.set(__self__, "total_ocpu_capacity", total_ocpu_capacity)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeShape")
    def compute_shape(self) -> pulumi.Input[str]:
        """
        Compute shape - STANDARD or ENTERPRISE_SMALL or ENTERPRISE_MEDIUM or ENTERPRISE_LARGE or ENTERPRISE_EXTRA_LARGE
        """
        return pulumi.get(self, "compute_shape")

    @compute_shape.setter
    def compute_shape(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_shape", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        Platform Instance Display name, can be renamed
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> pulumi.Input[str]:
        """
        IDCS access token with Identity Domain Administrator role
        """
        return pulumi.get(self, "idcs_access_token")

    @idcs_access_token.setter
    def idcs_access_token(self, value: pulumi.Input[str]):
        pulumi.set(self, "idcs_access_token", value)

    @property
    @pulumi.getter(name="platformRole")
    def platform_role(self) -> pulumi.Input[str]:
        """
        Role of platform - founder or participant
        """
        return pulumi.get(self, "platform_role")

    @platform_role.setter
    def platform_role(self, value: pulumi.Input[str]):
        pulumi.set(self, "platform_role", value)

    @property
    @pulumi.getter(name="caCertArchiveText")
    def ca_cert_archive_text(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 encoded text in ASCII character set of a Thirdparty CA Certificates archive file. The Archive file is a zip file containing third part CA Certificates, the ca key and certificate files used when issuing enrollment certificates (ECerts) and transaction certificates (TCerts). The chainfile (if it exists) contains the certificate chain which should be trusted for this CA, where the 1st in the chain is always the root CA certificate. File list in zip file [ca-cert.pem,ca-key.pem,ca-chain.pem(optional)].
        """
        return pulumi.get(self, "ca_cert_archive_text")

    @ca_cert_archive_text.setter
    def ca_cert_archive_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_cert_archive_text", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Platform Instance Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="federatedUserId")
    def federated_user_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for a federated user
        """
        return pulumi.get(self, "federated_user_id")

    @federated_user_id.setter
    def federated_user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "federated_user_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isByol")
    def is_byol(self) -> Optional[pulumi.Input[bool]]:
        """
        Bring your own license
        """
        return pulumi.get(self, "is_byol")

    @is_byol.setter
    def is_byol(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_byol", value)

    @property
    @pulumi.getter(name="loadBalancerShape")
    def load_balancer_shape(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Type of Load Balancer shape - LB_100_MBPS or LB_400_MBPS. Default is LB_100_MBPS.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "load_balancer_shape")

    @load_balancer_shape.setter
    def load_balancer_shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_shape", value)

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[pulumi.Input[str]]:
        """
        Platform version
        """
        return pulumi.get(self, "platform_version")

    @platform_version.setter
    def platform_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_version", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input['BlockchainPlatformReplicasArgs']]:
        """
        Number of replicas of service components like Rest Proxy, CA and Console
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input['BlockchainPlatformReplicasArgs']]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="storageSizeInTbs")
    def storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        Storage size in TBs
        """
        return pulumi.get(self, "storage_size_in_tbs")

    @storage_size_in_tbs.setter
    def storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="totalOcpuCapacity")
    def total_ocpu_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Number of total OCPUs allocated to the platform cluster
        """
        return pulumi.get(self, "total_ocpu_capacity")

    @total_ocpu_capacity.setter
    def total_ocpu_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_ocpu_capacity", value)


@pulumi.input_type
class _BlockchainPlatformState:
    def __init__(__self__, *,
                 ca_cert_archive_text: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 component_details: Optional[pulumi.Input[Sequence[pulumi.Input['BlockchainPlatformComponentDetailArgs']]]] = None,
                 compute_shape: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 federated_user_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 host_ocpu_utilization_infos: Optional[pulumi.Input[Sequence[pulumi.Input['BlockchainPlatformHostOcpuUtilizationInfoArgs']]]] = None,
                 idcs_access_token: Optional[pulumi.Input[str]] = None,
                 is_byol: Optional[pulumi.Input[bool]] = None,
                 is_multi_ad: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 load_balancer_shape: Optional[pulumi.Input[str]] = None,
                 platform_role: Optional[pulumi.Input[str]] = None,
                 platform_shape_type: Optional[pulumi.Input[str]] = None,
                 platform_version: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input['BlockchainPlatformReplicasArgs']] = None,
                 service_endpoint: Optional[pulumi.Input[str]] = None,
                 service_version: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 storage_used_in_tbs: Optional[pulumi.Input[float]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 total_ocpu_capacity: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering BlockchainPlatform resources.
        :param pulumi.Input[str] ca_cert_archive_text: Base64 encoded text in ASCII character set of a Thirdparty CA Certificates archive file. The Archive file is a zip file containing third part CA Certificates, the ca key and certificate files used when issuing enrollment certificates (ECerts) and transaction certificates (TCerts). The chainfile (if it exists) contains the certificate chain which should be trusted for this CA, where the 1st in the chain is always the root CA certificate. File list in zip file [ca-cert.pem,ca-key.pem,ca-chain.pem(optional)].
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier
        :param pulumi.Input[Sequence[pulumi.Input['BlockchainPlatformComponentDetailArgs']]] component_details: Blockchain Platform component details.
        :param pulumi.Input[str] compute_shape: Compute shape - STANDARD or ENTERPRISE_SMALL or ENTERPRISE_MEDIUM or ENTERPRISE_LARGE or ENTERPRISE_EXTRA_LARGE
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Platform Instance Description
        :param pulumi.Input[str] display_name: Platform Instance Display name, can be renamed
        :param pulumi.Input[str] federated_user_id: Identifier for a federated user
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['BlockchainPlatformHostOcpuUtilizationInfoArgs']]] host_ocpu_utilization_infos: List of OcpuUtilization for all hosts
        :param pulumi.Input[str] idcs_access_token: IDCS access token with Identity Domain Administrator role
        :param pulumi.Input[bool] is_byol: Bring your own license
        :param pulumi.Input[bool] is_multi_ad: True for multi-AD blockchain plaforms, false for single-AD
        :param pulumi.Input[str] lifecycle_details: An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] load_balancer_shape: (Updatable) Type of Load Balancer shape - LB_100_MBPS or LB_400_MBPS. Default is LB_100_MBPS.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] platform_role: Role of platform - founder or participant
        :param pulumi.Input[str] platform_shape_type: Type of Platform shape - DEFAULT or CUSTOM
        :param pulumi.Input[str] platform_version: Platform version
        :param pulumi.Input['BlockchainPlatformReplicasArgs'] replicas: Number of replicas of service components like Rest Proxy, CA and Console
        :param pulumi.Input[str] service_endpoint: Service endpoint URL, valid post-provisioning
        :param pulumi.Input[str] service_version: The version of the Platform Instance.
        :param pulumi.Input[str] state: The current state of the Platform Instance.
        :param pulumi.Input[float] storage_size_in_tbs: Storage size in TBs
        :param pulumi.Input[float] storage_used_in_tbs: Storage used in TBs
        :param pulumi.Input[str] time_created: The time the the Platform Instance was created. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the Platform Instance was updated. An RFC3339 formatted datetime string
        :param pulumi.Input[int] total_ocpu_capacity: Number of total OCPUs allocated to the platform cluster
        """
        if ca_cert_archive_text is not None:
            pulumi.set(__self__, "ca_cert_archive_text", ca_cert_archive_text)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if component_details is not None:
            pulumi.set(__self__, "component_details", component_details)
        if compute_shape is not None:
            pulumi.set(__self__, "compute_shape", compute_shape)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if federated_user_id is not None:
            pulumi.set(__self__, "federated_user_id", federated_user_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host_ocpu_utilization_infos is not None:
            pulumi.set(__self__, "host_ocpu_utilization_infos", host_ocpu_utilization_infos)
        if idcs_access_token is not None:
            pulumi.set(__self__, "idcs_access_token", idcs_access_token)
        if is_byol is not None:
            pulumi.set(__self__, "is_byol", is_byol)
        if is_multi_ad is not None:
            pulumi.set(__self__, "is_multi_ad", is_multi_ad)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if load_balancer_shape is not None:
            pulumi.set(__self__, "load_balancer_shape", load_balancer_shape)
        if platform_role is not None:
            pulumi.set(__self__, "platform_role", platform_role)
        if platform_shape_type is not None:
            pulumi.set(__self__, "platform_shape_type", platform_shape_type)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if service_endpoint is not None:
            pulumi.set(__self__, "service_endpoint", service_endpoint)
        if service_version is not None:
            pulumi.set(__self__, "service_version", service_version)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_size_in_tbs is not None:
            pulumi.set(__self__, "storage_size_in_tbs", storage_size_in_tbs)
        if storage_used_in_tbs is not None:
            pulumi.set(__self__, "storage_used_in_tbs", storage_used_in_tbs)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if total_ocpu_capacity is not None:
            pulumi.set(__self__, "total_ocpu_capacity", total_ocpu_capacity)

    @property
    @pulumi.getter(name="caCertArchiveText")
    def ca_cert_archive_text(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 encoded text in ASCII character set of a Thirdparty CA Certificates archive file. The Archive file is a zip file containing third part CA Certificates, the ca key and certificate files used when issuing enrollment certificates (ECerts) and transaction certificates (TCerts). The chainfile (if it exists) contains the certificate chain which should be trusted for this CA, where the 1st in the chain is always the root CA certificate. File list in zip file [ca-cert.pem,ca-key.pem,ca-chain.pem(optional)].
        """
        return pulumi.get(self, "ca_cert_archive_text")

    @ca_cert_archive_text.setter
    def ca_cert_archive_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_cert_archive_text", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="componentDetails")
    def component_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BlockchainPlatformComponentDetailArgs']]]]:
        """
        Blockchain Platform component details.
        """
        return pulumi.get(self, "component_details")

    @component_details.setter
    def component_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BlockchainPlatformComponentDetailArgs']]]]):
        pulumi.set(self, "component_details", value)

    @property
    @pulumi.getter(name="computeShape")
    def compute_shape(self) -> Optional[pulumi.Input[str]]:
        """
        Compute shape - STANDARD or ENTERPRISE_SMALL or ENTERPRISE_MEDIUM or ENTERPRISE_LARGE or ENTERPRISE_EXTRA_LARGE
        """
        return pulumi.get(self, "compute_shape")

    @compute_shape.setter
    def compute_shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_shape", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Platform Instance Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Platform Instance Display name, can be renamed
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="federatedUserId")
    def federated_user_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for a federated user
        """
        return pulumi.get(self, "federated_user_id")

    @federated_user_id.setter
    def federated_user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "federated_user_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hostOcpuUtilizationInfos")
    def host_ocpu_utilization_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BlockchainPlatformHostOcpuUtilizationInfoArgs']]]]:
        """
        List of OcpuUtilization for all hosts
        """
        return pulumi.get(self, "host_ocpu_utilization_infos")

    @host_ocpu_utilization_infos.setter
    def host_ocpu_utilization_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BlockchainPlatformHostOcpuUtilizationInfoArgs']]]]):
        pulumi.set(self, "host_ocpu_utilization_infos", value)

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> Optional[pulumi.Input[str]]:
        """
        IDCS access token with Identity Domain Administrator role
        """
        return pulumi.get(self, "idcs_access_token")

    @idcs_access_token.setter
    def idcs_access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_access_token", value)

    @property
    @pulumi.getter(name="isByol")
    def is_byol(self) -> Optional[pulumi.Input[bool]]:
        """
        Bring your own license
        """
        return pulumi.get(self, "is_byol")

    @is_byol.setter
    def is_byol(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_byol", value)

    @property
    @pulumi.getter(name="isMultiAd")
    def is_multi_ad(self) -> Optional[pulumi.Input[bool]]:
        """
        True for multi-AD blockchain plaforms, false for single-AD
        """
        return pulumi.get(self, "is_multi_ad")

    @is_multi_ad.setter
    def is_multi_ad(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_multi_ad", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="loadBalancerShape")
    def load_balancer_shape(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Type of Load Balancer shape - LB_100_MBPS or LB_400_MBPS. Default is LB_100_MBPS.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "load_balancer_shape")

    @load_balancer_shape.setter
    def load_balancer_shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_shape", value)

    @property
    @pulumi.getter(name="platformRole")
    def platform_role(self) -> Optional[pulumi.Input[str]]:
        """
        Role of platform - founder or participant
        """
        return pulumi.get(self, "platform_role")

    @platform_role.setter
    def platform_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_role", value)

    @property
    @pulumi.getter(name="platformShapeType")
    def platform_shape_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of Platform shape - DEFAULT or CUSTOM
        """
        return pulumi.get(self, "platform_shape_type")

    @platform_shape_type.setter
    def platform_shape_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_shape_type", value)

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[pulumi.Input[str]]:
        """
        Platform version
        """
        return pulumi.get(self, "platform_version")

    @platform_version.setter
    def platform_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_version", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input['BlockchainPlatformReplicasArgs']]:
        """
        Number of replicas of service components like Rest Proxy, CA and Console
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input['BlockchainPlatformReplicasArgs']]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Service endpoint URL, valid post-provisioning
        """
        return pulumi.get(self, "service_endpoint")

    @service_endpoint.setter
    def service_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_endpoint", value)

    @property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the Platform Instance.
        """
        return pulumi.get(self, "service_version")

    @service_version.setter
    def service_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_version", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Platform Instance.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageSizeInTbs")
    def storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        Storage size in TBs
        """
        return pulumi.get(self, "storage_size_in_tbs")

    @storage_size_in_tbs.setter
    def storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="storageUsedInTbs")
    def storage_used_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        Storage used in TBs
        """
        return pulumi.get(self, "storage_used_in_tbs")

    @storage_used_in_tbs.setter
    def storage_used_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "storage_used_in_tbs", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the the Platform Instance was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the Platform Instance was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="totalOcpuCapacity")
    def total_ocpu_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Number of total OCPUs allocated to the platform cluster
        """
        return pulumi.get(self, "total_ocpu_capacity")

    @total_ocpu_capacity.setter
    def total_ocpu_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_ocpu_capacity", value)


class BlockchainPlatform(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_cert_archive_text: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_shape: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 federated_user_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 idcs_access_token: Optional[pulumi.Input[str]] = None,
                 is_byol: Optional[pulumi.Input[bool]] = None,
                 load_balancer_shape: Optional[pulumi.Input[str]] = None,
                 platform_role: Optional[pulumi.Input[str]] = None,
                 platform_version: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input[Union['BlockchainPlatformReplicasArgs', 'BlockchainPlatformReplicasArgsDict']]] = None,
                 storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 total_ocpu_capacity: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        This resource provides the Blockchain Platform resource in Oracle Cloud Infrastructure Blockchain service.

        Creates a new Blockchain Platform.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_blockchain_platform = oci.blockchain.BlockchainPlatform("test_blockchain_platform",
            compartment_id=compartment_id,
            compute_shape=blockchain_platform_compute_shape,
            display_name=blockchain_platform_display_name,
            idcs_access_token=blockchain_platform_idcs_access_token,
            platform_role=blockchain_platform_platform_role,
            ca_cert_archive_text=blockchain_platform_ca_cert_archive_text,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=blockchain_platform_description,
            federated_user_id=test_user["id"],
            freeform_tags={
                "bar-key": "value",
            },
            is_byol=blockchain_platform_is_byol,
            platform_version=blockchain_platform_platform_version)
        ```

        ## Import

        BlockchainPlatforms can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Blockchain/blockchainPlatform:BlockchainPlatform test_blockchain_platform "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ca_cert_archive_text: Base64 encoded text in ASCII character set of a Thirdparty CA Certificates archive file. The Archive file is a zip file containing third part CA Certificates, the ca key and certificate files used when issuing enrollment certificates (ECerts) and transaction certificates (TCerts). The chainfile (if it exists) contains the certificate chain which should be trusted for this CA, where the 1st in the chain is always the root CA certificate. File list in zip file [ca-cert.pem,ca-key.pem,ca-chain.pem(optional)].
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier
        :param pulumi.Input[str] compute_shape: Compute shape - STANDARD or ENTERPRISE_SMALL or ENTERPRISE_MEDIUM or ENTERPRISE_LARGE or ENTERPRISE_EXTRA_LARGE
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Platform Instance Description
        :param pulumi.Input[str] display_name: Platform Instance Display name, can be renamed
        :param pulumi.Input[str] federated_user_id: Identifier for a federated user
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] idcs_access_token: IDCS access token with Identity Domain Administrator role
        :param pulumi.Input[bool] is_byol: Bring your own license
        :param pulumi.Input[str] load_balancer_shape: (Updatable) Type of Load Balancer shape - LB_100_MBPS or LB_400_MBPS. Default is LB_100_MBPS.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] platform_role: Role of platform - founder or participant
        :param pulumi.Input[str] platform_version: Platform version
        :param pulumi.Input[Union['BlockchainPlatformReplicasArgs', 'BlockchainPlatformReplicasArgsDict']] replicas: Number of replicas of service components like Rest Proxy, CA and Console
        :param pulumi.Input[float] storage_size_in_tbs: Storage size in TBs
        :param pulumi.Input[int] total_ocpu_capacity: Number of total OCPUs allocated to the platform cluster
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BlockchainPlatformArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Blockchain Platform resource in Oracle Cloud Infrastructure Blockchain service.

        Creates a new Blockchain Platform.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_blockchain_platform = oci.blockchain.BlockchainPlatform("test_blockchain_platform",
            compartment_id=compartment_id,
            compute_shape=blockchain_platform_compute_shape,
            display_name=blockchain_platform_display_name,
            idcs_access_token=blockchain_platform_idcs_access_token,
            platform_role=blockchain_platform_platform_role,
            ca_cert_archive_text=blockchain_platform_ca_cert_archive_text,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=blockchain_platform_description,
            federated_user_id=test_user["id"],
            freeform_tags={
                "bar-key": "value",
            },
            is_byol=blockchain_platform_is_byol,
            platform_version=blockchain_platform_platform_version)
        ```

        ## Import

        BlockchainPlatforms can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Blockchain/blockchainPlatform:BlockchainPlatform test_blockchain_platform "id"
        ```

        :param str resource_name: The name of the resource.
        :param BlockchainPlatformArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BlockchainPlatformArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_cert_archive_text: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_shape: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 federated_user_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 idcs_access_token: Optional[pulumi.Input[str]] = None,
                 is_byol: Optional[pulumi.Input[bool]] = None,
                 load_balancer_shape: Optional[pulumi.Input[str]] = None,
                 platform_role: Optional[pulumi.Input[str]] = None,
                 platform_version: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input[Union['BlockchainPlatformReplicasArgs', 'BlockchainPlatformReplicasArgsDict']]] = None,
                 storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 total_ocpu_capacity: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BlockchainPlatformArgs.__new__(BlockchainPlatformArgs)

            __props__.__dict__["ca_cert_archive_text"] = ca_cert_archive_text
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if compute_shape is None and not opts.urn:
                raise TypeError("Missing required property 'compute_shape'")
            __props__.__dict__["compute_shape"] = compute_shape
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["federated_user_id"] = federated_user_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            if idcs_access_token is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_access_token'")
            __props__.__dict__["idcs_access_token"] = None if idcs_access_token is None else pulumi.Output.secret(idcs_access_token)
            __props__.__dict__["is_byol"] = is_byol
            __props__.__dict__["load_balancer_shape"] = load_balancer_shape
            if platform_role is None and not opts.urn:
                raise TypeError("Missing required property 'platform_role'")
            __props__.__dict__["platform_role"] = platform_role
            __props__.__dict__["platform_version"] = platform_version
            __props__.__dict__["replicas"] = replicas
            __props__.__dict__["storage_size_in_tbs"] = storage_size_in_tbs
            __props__.__dict__["total_ocpu_capacity"] = total_ocpu_capacity
            __props__.__dict__["component_details"] = None
            __props__.__dict__["host_ocpu_utilization_infos"] = None
            __props__.__dict__["is_multi_ad"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["platform_shape_type"] = None
            __props__.__dict__["service_endpoint"] = None
            __props__.__dict__["service_version"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["storage_used_in_tbs"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["idcsAccessToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BlockchainPlatform, __self__).__init__(
            'oci:Blockchain/blockchainPlatform:BlockchainPlatform',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ca_cert_archive_text: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            component_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BlockchainPlatformComponentDetailArgs', 'BlockchainPlatformComponentDetailArgsDict']]]]] = None,
            compute_shape: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            federated_user_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            host_ocpu_utilization_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BlockchainPlatformHostOcpuUtilizationInfoArgs', 'BlockchainPlatformHostOcpuUtilizationInfoArgsDict']]]]] = None,
            idcs_access_token: Optional[pulumi.Input[str]] = None,
            is_byol: Optional[pulumi.Input[bool]] = None,
            is_multi_ad: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            load_balancer_shape: Optional[pulumi.Input[str]] = None,
            platform_role: Optional[pulumi.Input[str]] = None,
            platform_shape_type: Optional[pulumi.Input[str]] = None,
            platform_version: Optional[pulumi.Input[str]] = None,
            replicas: Optional[pulumi.Input[Union['BlockchainPlatformReplicasArgs', 'BlockchainPlatformReplicasArgsDict']]] = None,
            service_endpoint: Optional[pulumi.Input[str]] = None,
            service_version: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
            storage_used_in_tbs: Optional[pulumi.Input[float]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            total_ocpu_capacity: Optional[pulumi.Input[int]] = None) -> 'BlockchainPlatform':
        """
        Get an existing BlockchainPlatform resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ca_cert_archive_text: Base64 encoded text in ASCII character set of a Thirdparty CA Certificates archive file. The Archive file is a zip file containing third part CA Certificates, the ca key and certificate files used when issuing enrollment certificates (ECerts) and transaction certificates (TCerts). The chainfile (if it exists) contains the certificate chain which should be trusted for this CA, where the 1st in the chain is always the root CA certificate. File list in zip file [ca-cert.pem,ca-key.pem,ca-chain.pem(optional)].
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier
        :param pulumi.Input[Sequence[pulumi.Input[Union['BlockchainPlatformComponentDetailArgs', 'BlockchainPlatformComponentDetailArgsDict']]]] component_details: Blockchain Platform component details.
        :param pulumi.Input[str] compute_shape: Compute shape - STANDARD or ENTERPRISE_SMALL or ENTERPRISE_MEDIUM or ENTERPRISE_LARGE or ENTERPRISE_EXTRA_LARGE
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Platform Instance Description
        :param pulumi.Input[str] display_name: Platform Instance Display name, can be renamed
        :param pulumi.Input[str] federated_user_id: Identifier for a federated user
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['BlockchainPlatformHostOcpuUtilizationInfoArgs', 'BlockchainPlatformHostOcpuUtilizationInfoArgsDict']]]] host_ocpu_utilization_infos: List of OcpuUtilization for all hosts
        :param pulumi.Input[str] idcs_access_token: IDCS access token with Identity Domain Administrator role
        :param pulumi.Input[bool] is_byol: Bring your own license
        :param pulumi.Input[bool] is_multi_ad: True for multi-AD blockchain plaforms, false for single-AD
        :param pulumi.Input[str] lifecycle_details: An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] load_balancer_shape: (Updatable) Type of Load Balancer shape - LB_100_MBPS or LB_400_MBPS. Default is LB_100_MBPS.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] platform_role: Role of platform - founder or participant
        :param pulumi.Input[str] platform_shape_type: Type of Platform shape - DEFAULT or CUSTOM
        :param pulumi.Input[str] platform_version: Platform version
        :param pulumi.Input[Union['BlockchainPlatformReplicasArgs', 'BlockchainPlatformReplicasArgsDict']] replicas: Number of replicas of service components like Rest Proxy, CA and Console
        :param pulumi.Input[str] service_endpoint: Service endpoint URL, valid post-provisioning
        :param pulumi.Input[str] service_version: The version of the Platform Instance.
        :param pulumi.Input[str] state: The current state of the Platform Instance.
        :param pulumi.Input[float] storage_size_in_tbs: Storage size in TBs
        :param pulumi.Input[float] storage_used_in_tbs: Storage used in TBs
        :param pulumi.Input[str] time_created: The time the the Platform Instance was created. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the Platform Instance was updated. An RFC3339 formatted datetime string
        :param pulumi.Input[int] total_ocpu_capacity: Number of total OCPUs allocated to the platform cluster
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BlockchainPlatformState.__new__(_BlockchainPlatformState)

        __props__.__dict__["ca_cert_archive_text"] = ca_cert_archive_text
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["component_details"] = component_details
        __props__.__dict__["compute_shape"] = compute_shape
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["federated_user_id"] = federated_user_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["host_ocpu_utilization_infos"] = host_ocpu_utilization_infos
        __props__.__dict__["idcs_access_token"] = idcs_access_token
        __props__.__dict__["is_byol"] = is_byol
        __props__.__dict__["is_multi_ad"] = is_multi_ad
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["load_balancer_shape"] = load_balancer_shape
        __props__.__dict__["platform_role"] = platform_role
        __props__.__dict__["platform_shape_type"] = platform_shape_type
        __props__.__dict__["platform_version"] = platform_version
        __props__.__dict__["replicas"] = replicas
        __props__.__dict__["service_endpoint"] = service_endpoint
        __props__.__dict__["service_version"] = service_version
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_size_in_tbs"] = storage_size_in_tbs
        __props__.__dict__["storage_used_in_tbs"] = storage_used_in_tbs
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["total_ocpu_capacity"] = total_ocpu_capacity
        return BlockchainPlatform(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="caCertArchiveText")
    def ca_cert_archive_text(self) -> pulumi.Output[str]:
        """
        Base64 encoded text in ASCII character set of a Thirdparty CA Certificates archive file. The Archive file is a zip file containing third part CA Certificates, the ca key and certificate files used when issuing enrollment certificates (ECerts) and transaction certificates (TCerts). The chainfile (if it exists) contains the certificate chain which should be trusted for this CA, where the 1st in the chain is always the root CA certificate. File list in zip file [ca-cert.pem,ca-key.pem,ca-chain.pem(optional)].
        """
        return pulumi.get(self, "ca_cert_archive_text")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="componentDetails")
    def component_details(self) -> pulumi.Output[Sequence['outputs.BlockchainPlatformComponentDetail']]:
        """
        Blockchain Platform component details.
        """
        return pulumi.get(self, "component_details")

    @property
    @pulumi.getter(name="computeShape")
    def compute_shape(self) -> pulumi.Output[str]:
        """
        Compute shape - STANDARD or ENTERPRISE_SMALL or ENTERPRISE_MEDIUM or ENTERPRISE_LARGE or ENTERPRISE_EXTRA_LARGE
        """
        return pulumi.get(self, "compute_shape")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Platform Instance Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Platform Instance Display name, can be renamed
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="federatedUserId")
    def federated_user_id(self) -> pulumi.Output[str]:
        """
        Identifier for a federated user
        """
        return pulumi.get(self, "federated_user_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostOcpuUtilizationInfos")
    def host_ocpu_utilization_infos(self) -> pulumi.Output[Sequence['outputs.BlockchainPlatformHostOcpuUtilizationInfo']]:
        """
        List of OcpuUtilization for all hosts
        """
        return pulumi.get(self, "host_ocpu_utilization_infos")

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> pulumi.Output[str]:
        """
        IDCS access token with Identity Domain Administrator role
        """
        return pulumi.get(self, "idcs_access_token")

    @property
    @pulumi.getter(name="isByol")
    def is_byol(self) -> pulumi.Output[bool]:
        """
        Bring your own license
        """
        return pulumi.get(self, "is_byol")

    @property
    @pulumi.getter(name="isMultiAd")
    def is_multi_ad(self) -> pulumi.Output[bool]:
        """
        True for multi-AD blockchain plaforms, false for single-AD
        """
        return pulumi.get(self, "is_multi_ad")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="loadBalancerShape")
    def load_balancer_shape(self) -> pulumi.Output[str]:
        """
        (Updatable) Type of Load Balancer shape - LB_100_MBPS or LB_400_MBPS. Default is LB_100_MBPS.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "load_balancer_shape")

    @property
    @pulumi.getter(name="platformRole")
    def platform_role(self) -> pulumi.Output[str]:
        """
        Role of platform - founder or participant
        """
        return pulumi.get(self, "platform_role")

    @property
    @pulumi.getter(name="platformShapeType")
    def platform_shape_type(self) -> pulumi.Output[str]:
        """
        Type of Platform shape - DEFAULT or CUSTOM
        """
        return pulumi.get(self, "platform_shape_type")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> pulumi.Output[str]:
        """
        Platform version
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter
    def replicas(self) -> pulumi.Output['outputs.BlockchainPlatformReplicas']:
        """
        Number of replicas of service components like Rest Proxy, CA and Console
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> pulumi.Output[str]:
        """
        Service endpoint URL, valid post-provisioning
        """
        return pulumi.get(self, "service_endpoint")

    @property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> pulumi.Output[str]:
        """
        The version of the Platform Instance.
        """
        return pulumi.get(self, "service_version")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Platform Instance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageSizeInTbs")
    def storage_size_in_tbs(self) -> pulumi.Output[float]:
        """
        Storage size in TBs
        """
        return pulumi.get(self, "storage_size_in_tbs")

    @property
    @pulumi.getter(name="storageUsedInTbs")
    def storage_used_in_tbs(self) -> pulumi.Output[float]:
        """
        Storage used in TBs
        """
        return pulumi.get(self, "storage_used_in_tbs")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the the Platform Instance was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the Platform Instance was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalOcpuCapacity")
    def total_ocpu_capacity(self) -> pulumi.Output[int]:
        """
        Number of total OCPUs allocated to the platform cluster
        """
        return pulumi.get(self, "total_ocpu_capacity")

