# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSavedQueriesResult',
    'AwaitableGetSavedQueriesResult',
    'get_saved_queries',
    'get_saved_queries_output',
]

@pulumi.output_type
class GetSavedQueriesResult:
    """
    A collection of values returned by getSavedQueries.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, display_name=None, filters=None, id=None, saved_query_collections=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if saved_query_collections and not isinstance(saved_query_collections, list):
            raise TypeError("Expected argument 'saved_query_collections' to be a list")
        pulumi.set(__self__, "saved_query_collections", saved_query_collections)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment OCID of the saved query
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the saved query
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSavedQueriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="savedQueryCollections")
    def saved_query_collections(self) -> Sequence['outputs.GetSavedQueriesSavedQueryCollectionResult']:
        """
        The list of saved_query_collection.
        """
        return pulumi.get(self, "saved_query_collections")


class AwaitableGetSavedQueriesResult(GetSavedQueriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSavedQueriesResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            saved_query_collections=self.saved_query_collections)


def get_saved_queries(access_level: Optional[str] = None,
                      compartment_id: Optional[str] = None,
                      compartment_id_in_subtree: Optional[bool] = None,
                      display_name: Optional[str] = None,
                      filters: Optional[Sequence[Union['GetSavedQueriesFilterArgs', 'GetSavedQueriesFilterArgsDict']]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSavedQueriesResult:
    """
    This data source provides the list of Saved Queries in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of saved queries run in a tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_saved_queries = oci.CloudGuard.get_saved_queries(compartment_id=compartment_id,
        access_level=saved_query_access_level,
        compartment_id_in_subtree=saved_query_compartment_id_in_subtree,
        display_name=saved_query_display_name)
    ```


    :param str access_level: Valid values are `RESTRICTED` and `ACCESSIBLE`. Default is `RESTRICTED`. Setting this to `ACCESSIBLE` returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to `RESTRICTED` permissions are checked and no partial results are displayed.
    :param str compartment_id: The OCID of the compartment in which to list resources.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned depending on the setting of `accessLevel`.
    :param str display_name: A filter to return only resources that match the entire display name given.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getSavedQueries:getSavedQueries', __args__, opts=opts, typ=GetSavedQueriesResult).value

    return AwaitableGetSavedQueriesResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        saved_query_collections=pulumi.get(__ret__, 'saved_query_collections'))


@_utilities.lift_output_func(get_saved_queries)
def get_saved_queries_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                             compartment_id: Optional[pulumi.Input[str]] = None,
                             compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                             display_name: Optional[pulumi.Input[Optional[str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSavedQueriesFilterArgs', 'GetSavedQueriesFilterArgsDict']]]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSavedQueriesResult]:
    """
    This data source provides the list of Saved Queries in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of saved queries run in a tenancy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_saved_queries = oci.CloudGuard.get_saved_queries(compartment_id=compartment_id,
        access_level=saved_query_access_level,
        compartment_id_in_subtree=saved_query_compartment_id_in_subtree,
        display_name=saved_query_display_name)
    ```


    :param str access_level: Valid values are `RESTRICTED` and `ACCESSIBLE`. Default is `RESTRICTED`. Setting this to `ACCESSIBLE` returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to `RESTRICTED` permissions are checked and no partial results are displayed.
    :param str compartment_id: The OCID of the compartment in which to list resources.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned depending on the setting of `accessLevel`.
    :param str display_name: A filter to return only resources that match the entire display name given.
    """
    ...
