# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodePoolArgs', 'NodePool']

@pulumi.input_type
class NodePoolArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 node_shape: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 initial_node_labels: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolInitialNodeLabelArgs']]]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config_details: Optional[pulumi.Input['NodePoolNodeConfigDetailsArgs']] = None,
                 node_eviction_node_pool_settings: Optional[pulumi.Input['NodePoolNodeEvictionNodePoolSettingsArgs']] = None,
                 node_image_id: Optional[pulumi.Input[str]] = None,
                 node_image_name: Optional[pulumi.Input[str]] = None,
                 node_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 node_pool_cycling_details: Optional[pulumi.Input['NodePoolNodePoolCyclingDetailsArgs']] = None,
                 node_shape_config: Optional[pulumi.Input['NodePoolNodeShapeConfigArgs']] = None,
                 node_source_details: Optional[pulumi.Input['NodePoolNodeSourceDetailsArgs']] = None,
                 quantity_per_subnet: Optional[pulumi.Input[int]] = None,
                 ssh_public_key: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a NodePool resource.
        :param pulumi.Input[str] cluster_id: The OCID of the cluster to which this node pool is attached.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment in which the node pool exists.
        :param pulumi.Input[str] node_shape: (Updatable) The name of the node shape of the nodes in the node pool.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolInitialNodeLabelArgs']]] initial_node_labels: (Updatable) A list of key/value pairs to add to nodes after they join the Kubernetes cluster.
        :param pulumi.Input[str] kubernetes_version: (Updatable) The version of Kubernetes to install on the nodes in the node pool.
        :param pulumi.Input[str] name: (Updatable) The name of the node pool. Avoid entering confidential information.
        :param pulumi.Input['NodePoolNodeConfigDetailsArgs'] node_config_details: (Updatable) The configuration of nodes in the node pool. Exactly one of the subnetIds or nodeConfigDetails properties must be specified.
        :param pulumi.Input['NodePoolNodeEvictionNodePoolSettingsArgs'] node_eviction_node_pool_settings: (Updatable) Node Eviction Details configuration
        :param pulumi.Input[str] node_image_id: Deprecated. see `nodeSource`. The OCID of the image running on the nodes in the node pool.
        :param pulumi.Input[str] node_image_name: Deprecated. Use `nodeSourceDetails` instead. If you specify values for both, this value is ignored. The name of the image running on the nodes in the node pool. Cannot be used when `node_image_id` is specified.
        :param pulumi.Input[Mapping[str, Any]] node_metadata: (Updatable) A list of key/value pairs to add to each underlying Oracle Cloud Infrastructure instance in the node pool on launch.
        :param pulumi.Input['NodePoolNodePoolCyclingDetailsArgs'] node_pool_cycling_details: (Updatable) Node Pool Cycling Details
        :param pulumi.Input['NodePoolNodeShapeConfigArgs'] node_shape_config: (Updatable) Specify the configuration of the shape to launch nodes in the node pool.
        :param pulumi.Input['NodePoolNodeSourceDetailsArgs'] node_source_details: (Updatable) Specify the source to use to launch nodes in the node pool. Currently, image is the only supported source.
        :param pulumi.Input[int] quantity_per_subnet: (Updatable) Optional, default to 1. The number of nodes to create in each subnet specified in subnetIds property. When used, subnetIds is required. This property is deprecated, use nodeConfigDetails instead.
        :param pulumi.Input[str] ssh_public_key: (Updatable) The SSH public key on each node in the node pool on launch.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: (Updatable) The OCIDs of the subnets in which to place nodes for this node pool. When used, quantityPerSubnet can be provided. This property is deprecated, use nodeConfigDetails. Exactly one of the subnetIds or nodeConfigDetails properties must be specified. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "node_shape", node_shape)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if initial_node_labels is not None:
            pulumi.set(__self__, "initial_node_labels", initial_node_labels)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_config_details is not None:
            pulumi.set(__self__, "node_config_details", node_config_details)
        if node_eviction_node_pool_settings is not None:
            pulumi.set(__self__, "node_eviction_node_pool_settings", node_eviction_node_pool_settings)
        if node_image_id is not None:
            warnings.warn("""The 'node_image_id' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""", DeprecationWarning)
            pulumi.log.warn("""node_image_id is deprecated: The 'node_image_id' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""")
        if node_image_id is not None:
            pulumi.set(__self__, "node_image_id", node_image_id)
        if node_image_name is not None:
            warnings.warn("""The 'node_image_name' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""", DeprecationWarning)
            pulumi.log.warn("""node_image_name is deprecated: The 'node_image_name' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""")
        if node_image_name is not None:
            pulumi.set(__self__, "node_image_name", node_image_name)
        if node_metadata is not None:
            pulumi.set(__self__, "node_metadata", node_metadata)
        if node_pool_cycling_details is not None:
            pulumi.set(__self__, "node_pool_cycling_details", node_pool_cycling_details)
        if node_shape_config is not None:
            pulumi.set(__self__, "node_shape_config", node_shape_config)
        if node_source_details is not None:
            pulumi.set(__self__, "node_source_details", node_source_details)
        if quantity_per_subnet is not None:
            pulumi.set(__self__, "quantity_per_subnet", quantity_per_subnet)
        if ssh_public_key is not None:
            pulumi.set(__self__, "ssh_public_key", ssh_public_key)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        The OCID of the cluster to which this node pool is attached.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The OCID of the compartment in which the node pool exists.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="nodeShape")
    def node_shape(self) -> pulumi.Input[str]:
        """
        (Updatable) The name of the node shape of the nodes in the node pool.
        """
        return pulumi.get(self, "node_shape")

    @node_shape.setter
    def node_shape(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_shape", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="initialNodeLabels")
    def initial_node_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolInitialNodeLabelArgs']]]]:
        """
        (Updatable) A list of key/value pairs to add to nodes after they join the Kubernetes cluster.
        """
        return pulumi.get(self, "initial_node_labels")

    @initial_node_labels.setter
    def initial_node_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolInitialNodeLabelArgs']]]]):
        pulumi.set(self, "initial_node_labels", value)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The version of Kubernetes to install on the nodes in the node pool.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the node pool. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeConfigDetails")
    def node_config_details(self) -> Optional[pulumi.Input['NodePoolNodeConfigDetailsArgs']]:
        """
        (Updatable) The configuration of nodes in the node pool. Exactly one of the subnetIds or nodeConfigDetails properties must be specified.
        """
        return pulumi.get(self, "node_config_details")

    @node_config_details.setter
    def node_config_details(self, value: Optional[pulumi.Input['NodePoolNodeConfigDetailsArgs']]):
        pulumi.set(self, "node_config_details", value)

    @property
    @pulumi.getter(name="nodeEvictionNodePoolSettings")
    def node_eviction_node_pool_settings(self) -> Optional[pulumi.Input['NodePoolNodeEvictionNodePoolSettingsArgs']]:
        """
        (Updatable) Node Eviction Details configuration
        """
        return pulumi.get(self, "node_eviction_node_pool_settings")

    @node_eviction_node_pool_settings.setter
    def node_eviction_node_pool_settings(self, value: Optional[pulumi.Input['NodePoolNodeEvictionNodePoolSettingsArgs']]):
        pulumi.set(self, "node_eviction_node_pool_settings", value)

    @property
    @pulumi.getter(name="nodeImageId")
    @_utilities.deprecated("""The 'node_image_id' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""")
    def node_image_id(self) -> Optional[pulumi.Input[str]]:
        """
        Deprecated. see `nodeSource`. The OCID of the image running on the nodes in the node pool.
        """
        return pulumi.get(self, "node_image_id")

    @node_image_id.setter
    def node_image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_image_id", value)

    @property
    @pulumi.getter(name="nodeImageName")
    @_utilities.deprecated("""The 'node_image_name' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""")
    def node_image_name(self) -> Optional[pulumi.Input[str]]:
        """
        Deprecated. Use `nodeSourceDetails` instead. If you specify values for both, this value is ignored. The name of the image running on the nodes in the node pool. Cannot be used when `node_image_id` is specified.
        """
        return pulumi.get(self, "node_image_name")

    @node_image_name.setter
    def node_image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_image_name", value)

    @property
    @pulumi.getter(name="nodeMetadata")
    def node_metadata(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) A list of key/value pairs to add to each underlying Oracle Cloud Infrastructure instance in the node pool on launch.
        """
        return pulumi.get(self, "node_metadata")

    @node_metadata.setter
    def node_metadata(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "node_metadata", value)

    @property
    @pulumi.getter(name="nodePoolCyclingDetails")
    def node_pool_cycling_details(self) -> Optional[pulumi.Input['NodePoolNodePoolCyclingDetailsArgs']]:
        """
        (Updatable) Node Pool Cycling Details
        """
        return pulumi.get(self, "node_pool_cycling_details")

    @node_pool_cycling_details.setter
    def node_pool_cycling_details(self, value: Optional[pulumi.Input['NodePoolNodePoolCyclingDetailsArgs']]):
        pulumi.set(self, "node_pool_cycling_details", value)

    @property
    @pulumi.getter(name="nodeShapeConfig")
    def node_shape_config(self) -> Optional[pulumi.Input['NodePoolNodeShapeConfigArgs']]:
        """
        (Updatable) Specify the configuration of the shape to launch nodes in the node pool.
        """
        return pulumi.get(self, "node_shape_config")

    @node_shape_config.setter
    def node_shape_config(self, value: Optional[pulumi.Input['NodePoolNodeShapeConfigArgs']]):
        pulumi.set(self, "node_shape_config", value)

    @property
    @pulumi.getter(name="nodeSourceDetails")
    def node_source_details(self) -> Optional[pulumi.Input['NodePoolNodeSourceDetailsArgs']]:
        """
        (Updatable) Specify the source to use to launch nodes in the node pool. Currently, image is the only supported source.
        """
        return pulumi.get(self, "node_source_details")

    @node_source_details.setter
    def node_source_details(self, value: Optional[pulumi.Input['NodePoolNodeSourceDetailsArgs']]):
        pulumi.set(self, "node_source_details", value)

    @property
    @pulumi.getter(name="quantityPerSubnet")
    def quantity_per_subnet(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Optional, default to 1. The number of nodes to create in each subnet specified in subnetIds property. When used, subnetIds is required. This property is deprecated, use nodeConfigDetails instead.
        """
        return pulumi.get(self, "quantity_per_subnet")

    @quantity_per_subnet.setter
    def quantity_per_subnet(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quantity_per_subnet", value)

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The SSH public key on each node in the node pool on launch.
        """
        return pulumi.get(self, "ssh_public_key")

    @ssh_public_key.setter
    def ssh_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_public_key", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The OCIDs of the subnets in which to place nodes for this node pool. When used, quantityPerSubnet can be provided. This property is deprecated, use nodeConfigDetails. Exactly one of the subnetIds or nodeConfigDetails properties must be specified. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)


@pulumi.input_type
class _NodePoolState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 initial_node_labels: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolInitialNodeLabelArgs']]]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config_details: Optional[pulumi.Input['NodePoolNodeConfigDetailsArgs']] = None,
                 node_eviction_node_pool_settings: Optional[pulumi.Input['NodePoolNodeEvictionNodePoolSettingsArgs']] = None,
                 node_image_id: Optional[pulumi.Input[str]] = None,
                 node_image_name: Optional[pulumi.Input[str]] = None,
                 node_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 node_pool_cycling_details: Optional[pulumi.Input['NodePoolNodePoolCyclingDetailsArgs']] = None,
                 node_shape: Optional[pulumi.Input[str]] = None,
                 node_shape_config: Optional[pulumi.Input['NodePoolNodeShapeConfigArgs']] = None,
                 node_source_details: Optional[pulumi.Input['NodePoolNodeSourceDetailsArgs']] = None,
                 node_sources: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolNodeSourceArgs']]]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolNodeArgs']]]] = None,
                 quantity_per_subnet: Optional[pulumi.Input[int]] = None,
                 ssh_public_key: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering NodePool resources.
        :param pulumi.Input[str] cluster_id: The OCID of the cluster to which this node pool is attached.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment in which the node pool exists.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolInitialNodeLabelArgs']]] initial_node_labels: (Updatable) A list of key/value pairs to add to nodes after they join the Kubernetes cluster.
        :param pulumi.Input[str] kubernetes_version: (Updatable) The version of Kubernetes to install on the nodes in the node pool.
        :param pulumi.Input[str] lifecycle_details: Details about the state of the node.
        :param pulumi.Input[str] name: (Updatable) The name of the node pool. Avoid entering confidential information.
        :param pulumi.Input['NodePoolNodeConfigDetailsArgs'] node_config_details: (Updatable) The configuration of nodes in the node pool. Exactly one of the subnetIds or nodeConfigDetails properties must be specified.
        :param pulumi.Input['NodePoolNodeEvictionNodePoolSettingsArgs'] node_eviction_node_pool_settings: (Updatable) Node Eviction Details configuration
        :param pulumi.Input[str] node_image_id: Deprecated. see `nodeSource`. The OCID of the image running on the nodes in the node pool.
        :param pulumi.Input[str] node_image_name: Deprecated. Use `nodeSourceDetails` instead. If you specify values for both, this value is ignored. The name of the image running on the nodes in the node pool. Cannot be used when `node_image_id` is specified.
        :param pulumi.Input[Mapping[str, Any]] node_metadata: (Updatable) A list of key/value pairs to add to each underlying Oracle Cloud Infrastructure instance in the node pool on launch.
        :param pulumi.Input['NodePoolNodePoolCyclingDetailsArgs'] node_pool_cycling_details: (Updatable) Node Pool Cycling Details
        :param pulumi.Input[str] node_shape: (Updatable) The name of the node shape of the nodes in the node pool.
        :param pulumi.Input['NodePoolNodeShapeConfigArgs'] node_shape_config: (Updatable) Specify the configuration of the shape to launch nodes in the node pool.
        :param pulumi.Input['NodePoolNodeSourceDetailsArgs'] node_source_details: (Updatable) Specify the source to use to launch nodes in the node pool. Currently, image is the only supported source.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolNodeSourceArgs']]] node_sources: Deprecated. see `nodeSourceDetails`. Source running on the nodes in the node pool.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolNodeArgs']]] nodes: The nodes in the node pool.
        :param pulumi.Input[int] quantity_per_subnet: (Updatable) Optional, default to 1. The number of nodes to create in each subnet specified in subnetIds property. When used, subnetIds is required. This property is deprecated, use nodeConfigDetails instead.
        :param pulumi.Input[str] ssh_public_key: (Updatable) The SSH public key on each node in the node pool on launch.
        :param pulumi.Input[str] state: The state of the nodepool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: (Updatable) The OCIDs of the subnets in which to place nodes for this node pool. When used, quantityPerSubnet can be provided. This property is deprecated, use nodeConfigDetails. Exactly one of the subnetIds or nodeConfigDetails properties must be specified. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if initial_node_labels is not None:
            pulumi.set(__self__, "initial_node_labels", initial_node_labels)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_config_details is not None:
            pulumi.set(__self__, "node_config_details", node_config_details)
        if node_eviction_node_pool_settings is not None:
            pulumi.set(__self__, "node_eviction_node_pool_settings", node_eviction_node_pool_settings)
        if node_image_id is not None:
            warnings.warn("""The 'node_image_id' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""", DeprecationWarning)
            pulumi.log.warn("""node_image_id is deprecated: The 'node_image_id' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""")
        if node_image_id is not None:
            pulumi.set(__self__, "node_image_id", node_image_id)
        if node_image_name is not None:
            warnings.warn("""The 'node_image_name' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""", DeprecationWarning)
            pulumi.log.warn("""node_image_name is deprecated: The 'node_image_name' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""")
        if node_image_name is not None:
            pulumi.set(__self__, "node_image_name", node_image_name)
        if node_metadata is not None:
            pulumi.set(__self__, "node_metadata", node_metadata)
        if node_pool_cycling_details is not None:
            pulumi.set(__self__, "node_pool_cycling_details", node_pool_cycling_details)
        if node_shape is not None:
            pulumi.set(__self__, "node_shape", node_shape)
        if node_shape_config is not None:
            pulumi.set(__self__, "node_shape_config", node_shape_config)
        if node_source_details is not None:
            pulumi.set(__self__, "node_source_details", node_source_details)
        if node_sources is not None:
            pulumi.set(__self__, "node_sources", node_sources)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if quantity_per_subnet is not None:
            pulumi.set(__self__, "quantity_per_subnet", quantity_per_subnet)
        if ssh_public_key is not None:
            pulumi.set(__self__, "ssh_public_key", ssh_public_key)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the cluster to which this node pool is attached.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment in which the node pool exists.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="initialNodeLabels")
    def initial_node_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolInitialNodeLabelArgs']]]]:
        """
        (Updatable) A list of key/value pairs to add to nodes after they join the Kubernetes cluster.
        """
        return pulumi.get(self, "initial_node_labels")

    @initial_node_labels.setter
    def initial_node_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolInitialNodeLabelArgs']]]]):
        pulumi.set(self, "initial_node_labels", value)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The version of Kubernetes to install on the nodes in the node pool.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details about the state of the node.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the node pool. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeConfigDetails")
    def node_config_details(self) -> Optional[pulumi.Input['NodePoolNodeConfigDetailsArgs']]:
        """
        (Updatable) The configuration of nodes in the node pool. Exactly one of the subnetIds or nodeConfigDetails properties must be specified.
        """
        return pulumi.get(self, "node_config_details")

    @node_config_details.setter
    def node_config_details(self, value: Optional[pulumi.Input['NodePoolNodeConfigDetailsArgs']]):
        pulumi.set(self, "node_config_details", value)

    @property
    @pulumi.getter(name="nodeEvictionNodePoolSettings")
    def node_eviction_node_pool_settings(self) -> Optional[pulumi.Input['NodePoolNodeEvictionNodePoolSettingsArgs']]:
        """
        (Updatable) Node Eviction Details configuration
        """
        return pulumi.get(self, "node_eviction_node_pool_settings")

    @node_eviction_node_pool_settings.setter
    def node_eviction_node_pool_settings(self, value: Optional[pulumi.Input['NodePoolNodeEvictionNodePoolSettingsArgs']]):
        pulumi.set(self, "node_eviction_node_pool_settings", value)

    @property
    @pulumi.getter(name="nodeImageId")
    @_utilities.deprecated("""The 'node_image_id' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""")
    def node_image_id(self) -> Optional[pulumi.Input[str]]:
        """
        Deprecated. see `nodeSource`. The OCID of the image running on the nodes in the node pool.
        """
        return pulumi.get(self, "node_image_id")

    @node_image_id.setter
    def node_image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_image_id", value)

    @property
    @pulumi.getter(name="nodeImageName")
    @_utilities.deprecated("""The 'node_image_name' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""")
    def node_image_name(self) -> Optional[pulumi.Input[str]]:
        """
        Deprecated. Use `nodeSourceDetails` instead. If you specify values for both, this value is ignored. The name of the image running on the nodes in the node pool. Cannot be used when `node_image_id` is specified.
        """
        return pulumi.get(self, "node_image_name")

    @node_image_name.setter
    def node_image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_image_name", value)

    @property
    @pulumi.getter(name="nodeMetadata")
    def node_metadata(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) A list of key/value pairs to add to each underlying Oracle Cloud Infrastructure instance in the node pool on launch.
        """
        return pulumi.get(self, "node_metadata")

    @node_metadata.setter
    def node_metadata(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "node_metadata", value)

    @property
    @pulumi.getter(name="nodePoolCyclingDetails")
    def node_pool_cycling_details(self) -> Optional[pulumi.Input['NodePoolNodePoolCyclingDetailsArgs']]:
        """
        (Updatable) Node Pool Cycling Details
        """
        return pulumi.get(self, "node_pool_cycling_details")

    @node_pool_cycling_details.setter
    def node_pool_cycling_details(self, value: Optional[pulumi.Input['NodePoolNodePoolCyclingDetailsArgs']]):
        pulumi.set(self, "node_pool_cycling_details", value)

    @property
    @pulumi.getter(name="nodeShape")
    def node_shape(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the node shape of the nodes in the node pool.
        """
        return pulumi.get(self, "node_shape")

    @node_shape.setter
    def node_shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_shape", value)

    @property
    @pulumi.getter(name="nodeShapeConfig")
    def node_shape_config(self) -> Optional[pulumi.Input['NodePoolNodeShapeConfigArgs']]:
        """
        (Updatable) Specify the configuration of the shape to launch nodes in the node pool.
        """
        return pulumi.get(self, "node_shape_config")

    @node_shape_config.setter
    def node_shape_config(self, value: Optional[pulumi.Input['NodePoolNodeShapeConfigArgs']]):
        pulumi.set(self, "node_shape_config", value)

    @property
    @pulumi.getter(name="nodeSourceDetails")
    def node_source_details(self) -> Optional[pulumi.Input['NodePoolNodeSourceDetailsArgs']]:
        """
        (Updatable) Specify the source to use to launch nodes in the node pool. Currently, image is the only supported source.
        """
        return pulumi.get(self, "node_source_details")

    @node_source_details.setter
    def node_source_details(self, value: Optional[pulumi.Input['NodePoolNodeSourceDetailsArgs']]):
        pulumi.set(self, "node_source_details", value)

    @property
    @pulumi.getter(name="nodeSources")
    def node_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolNodeSourceArgs']]]]:
        """
        Deprecated. see `nodeSourceDetails`. Source running on the nodes in the node pool.
        """
        return pulumi.get(self, "node_sources")

    @node_sources.setter
    def node_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolNodeSourceArgs']]]]):
        pulumi.set(self, "node_sources", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolNodeArgs']]]]:
        """
        The nodes in the node pool.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter(name="quantityPerSubnet")
    def quantity_per_subnet(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Optional, default to 1. The number of nodes to create in each subnet specified in subnetIds property. When used, subnetIds is required. This property is deprecated, use nodeConfigDetails instead.
        """
        return pulumi.get(self, "quantity_per_subnet")

    @quantity_per_subnet.setter
    def quantity_per_subnet(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quantity_per_subnet", value)

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The SSH public key on each node in the node pool on launch.
        """
        return pulumi.get(self, "ssh_public_key")

    @ssh_public_key.setter
    def ssh_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_public_key", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the nodepool.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The OCIDs of the subnets in which to place nodes for this node pool. When used, quantityPerSubnet can be provided. This property is deprecated, use nodeConfigDetails. Exactly one of the subnetIds or nodeConfigDetails properties must be specified. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)


class NodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 initial_node_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolInitialNodeLabelArgs', 'NodePoolInitialNodeLabelArgsDict']]]]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config_details: Optional[pulumi.Input[Union['NodePoolNodeConfigDetailsArgs', 'NodePoolNodeConfigDetailsArgsDict']]] = None,
                 node_eviction_node_pool_settings: Optional[pulumi.Input[Union['NodePoolNodeEvictionNodePoolSettingsArgs', 'NodePoolNodeEvictionNodePoolSettingsArgsDict']]] = None,
                 node_image_id: Optional[pulumi.Input[str]] = None,
                 node_image_name: Optional[pulumi.Input[str]] = None,
                 node_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 node_pool_cycling_details: Optional[pulumi.Input[Union['NodePoolNodePoolCyclingDetailsArgs', 'NodePoolNodePoolCyclingDetailsArgsDict']]] = None,
                 node_shape: Optional[pulumi.Input[str]] = None,
                 node_shape_config: Optional[pulumi.Input[Union['NodePoolNodeShapeConfigArgs', 'NodePoolNodeShapeConfigArgsDict']]] = None,
                 node_source_details: Optional[pulumi.Input[Union['NodePoolNodeSourceDetailsArgs', 'NodePoolNodeSourceDetailsArgsDict']]] = None,
                 quantity_per_subnet: Optional[pulumi.Input[int]] = None,
                 ssh_public_key: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resource provides the Node Pool resource in Oracle Cloud Infrastructure Container Engine service.

        Create a new node pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_node_pool = oci.container_engine.NodePool("test_node_pool",
            cluster_id=test_cluster["id"],
            compartment_id=compartment_id,
            name=node_pool_name,
            node_shape=node_pool_node_shape,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            initial_node_labels=[{
                "key": node_pool_initial_node_labels_key,
                "value": node_pool_initial_node_labels_value,
            }],
            kubernetes_version=node_pool_kubernetes_version,
            node_config_details={
                "placement_configs": [{
                    "availability_domain": node_pool_node_config_details_placement_configs_availability_domain,
                    "subnet_id": test_subnet["id"],
                    "capacity_reservation_id": test_capacity_reservation["id"],
                    "fault_domains": node_pool_node_config_details_placement_configs_fault_domains,
                    "preemptible_node_config": {
                        "preemption_action": {
                            "type": node_pool_node_config_details_placement_configs_preemptible_node_config_preemption_action_type,
                            "is_preserve_boot_volume": node_pool_node_config_details_placement_configs_preemptible_node_config_preemption_action_is_preserve_boot_volume,
                        },
                    },
                }],
                "size": node_pool_node_config_details_size,
                "is_pv_encryption_in_transit_enabled": node_pool_node_config_details_is_pv_encryption_in_transit_enabled,
                "kms_key_id": test_key["id"],
                "node_pool_pod_network_option_details": {
                    "cni_type": node_pool_node_config_details_node_pool_pod_network_option_details_cni_type,
                    "max_pods_per_node": node_pool_node_config_details_node_pool_pod_network_option_details_max_pods_per_node,
                    "pod_nsg_ids": node_pool_node_config_details_node_pool_pod_network_option_details_pod_nsg_ids,
                    "pod_subnet_ids": node_pool_node_config_details_node_pool_pod_network_option_details_pod_subnet_ids,
                },
                "defined_tags": {
                    "operations__cost_center": "42",
                },
                "freeform_tags": {
                    "department": "Finance",
                },
                "nsg_ids": node_pool_node_config_details_nsg_ids,
            },
            node_eviction_node_pool_settings={
                "eviction_grace_duration": node_pool_node_eviction_node_pool_settings_eviction_grace_duration,
                "is_force_delete_after_grace_duration": node_pool_node_eviction_node_pool_settings_is_force_delete_after_grace_duration,
            },
            node_image_name=test_image["name"],
            node_metadata=node_pool_node_metadata,
            node_pool_cycling_details={
                "is_node_cycling_enabled": node_pool_node_pool_cycling_details_is_node_cycling_enabled,
                "maximum_surge": node_pool_node_pool_cycling_details_maximum_surge,
                "maximum_unavailable": node_pool_node_pool_cycling_details_maximum_unavailable,
            },
            node_shape_config={
                "memory_in_gbs": node_pool_node_shape_config_memory_in_gbs,
                "ocpus": node_pool_node_shape_config_ocpus,
            },
            node_source_details={
                "image_id": test_image["id"],
                "source_type": node_pool_node_source_details_source_type,
                "boot_volume_size_in_gbs": node_pool_node_source_details_boot_volume_size_in_gbs,
            },
            quantity_per_subnet=node_pool_quantity_per_subnet,
            ssh_public_key=node_pool_ssh_public_key,
            subnet_ids=node_pool_subnet_ids)
        ```

        ## Import

        NodePools can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ContainerEngine/nodePool:NodePool test_node_pool "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: The OCID of the cluster to which this node pool is attached.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment in which the node pool exists.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolInitialNodeLabelArgs', 'NodePoolInitialNodeLabelArgsDict']]]] initial_node_labels: (Updatable) A list of key/value pairs to add to nodes after they join the Kubernetes cluster.
        :param pulumi.Input[str] kubernetes_version: (Updatable) The version of Kubernetes to install on the nodes in the node pool.
        :param pulumi.Input[str] name: (Updatable) The name of the node pool. Avoid entering confidential information.
        :param pulumi.Input[Union['NodePoolNodeConfigDetailsArgs', 'NodePoolNodeConfigDetailsArgsDict']] node_config_details: (Updatable) The configuration of nodes in the node pool. Exactly one of the subnetIds or nodeConfigDetails properties must be specified.
        :param pulumi.Input[Union['NodePoolNodeEvictionNodePoolSettingsArgs', 'NodePoolNodeEvictionNodePoolSettingsArgsDict']] node_eviction_node_pool_settings: (Updatable) Node Eviction Details configuration
        :param pulumi.Input[str] node_image_id: Deprecated. see `nodeSource`. The OCID of the image running on the nodes in the node pool.
        :param pulumi.Input[str] node_image_name: Deprecated. Use `nodeSourceDetails` instead. If you specify values for both, this value is ignored. The name of the image running on the nodes in the node pool. Cannot be used when `node_image_id` is specified.
        :param pulumi.Input[Mapping[str, Any]] node_metadata: (Updatable) A list of key/value pairs to add to each underlying Oracle Cloud Infrastructure instance in the node pool on launch.
        :param pulumi.Input[Union['NodePoolNodePoolCyclingDetailsArgs', 'NodePoolNodePoolCyclingDetailsArgsDict']] node_pool_cycling_details: (Updatable) Node Pool Cycling Details
        :param pulumi.Input[str] node_shape: (Updatable) The name of the node shape of the nodes in the node pool.
        :param pulumi.Input[Union['NodePoolNodeShapeConfigArgs', 'NodePoolNodeShapeConfigArgsDict']] node_shape_config: (Updatable) Specify the configuration of the shape to launch nodes in the node pool.
        :param pulumi.Input[Union['NodePoolNodeSourceDetailsArgs', 'NodePoolNodeSourceDetailsArgsDict']] node_source_details: (Updatable) Specify the source to use to launch nodes in the node pool. Currently, image is the only supported source.
        :param pulumi.Input[int] quantity_per_subnet: (Updatable) Optional, default to 1. The number of nodes to create in each subnet specified in subnetIds property. When used, subnetIds is required. This property is deprecated, use nodeConfigDetails instead.
        :param pulumi.Input[str] ssh_public_key: (Updatable) The SSH public key on each node in the node pool on launch.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: (Updatable) The OCIDs of the subnets in which to place nodes for this node pool. When used, quantityPerSubnet can be provided. This property is deprecated, use nodeConfigDetails. Exactly one of the subnetIds or nodeConfigDetails properties must be specified. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Node Pool resource in Oracle Cloud Infrastructure Container Engine service.

        Create a new node pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_node_pool = oci.container_engine.NodePool("test_node_pool",
            cluster_id=test_cluster["id"],
            compartment_id=compartment_id,
            name=node_pool_name,
            node_shape=node_pool_node_shape,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            initial_node_labels=[{
                "key": node_pool_initial_node_labels_key,
                "value": node_pool_initial_node_labels_value,
            }],
            kubernetes_version=node_pool_kubernetes_version,
            node_config_details={
                "placement_configs": [{
                    "availability_domain": node_pool_node_config_details_placement_configs_availability_domain,
                    "subnet_id": test_subnet["id"],
                    "capacity_reservation_id": test_capacity_reservation["id"],
                    "fault_domains": node_pool_node_config_details_placement_configs_fault_domains,
                    "preemptible_node_config": {
                        "preemption_action": {
                            "type": node_pool_node_config_details_placement_configs_preemptible_node_config_preemption_action_type,
                            "is_preserve_boot_volume": node_pool_node_config_details_placement_configs_preemptible_node_config_preemption_action_is_preserve_boot_volume,
                        },
                    },
                }],
                "size": node_pool_node_config_details_size,
                "is_pv_encryption_in_transit_enabled": node_pool_node_config_details_is_pv_encryption_in_transit_enabled,
                "kms_key_id": test_key["id"],
                "node_pool_pod_network_option_details": {
                    "cni_type": node_pool_node_config_details_node_pool_pod_network_option_details_cni_type,
                    "max_pods_per_node": node_pool_node_config_details_node_pool_pod_network_option_details_max_pods_per_node,
                    "pod_nsg_ids": node_pool_node_config_details_node_pool_pod_network_option_details_pod_nsg_ids,
                    "pod_subnet_ids": node_pool_node_config_details_node_pool_pod_network_option_details_pod_subnet_ids,
                },
                "defined_tags": {
                    "operations__cost_center": "42",
                },
                "freeform_tags": {
                    "department": "Finance",
                },
                "nsg_ids": node_pool_node_config_details_nsg_ids,
            },
            node_eviction_node_pool_settings={
                "eviction_grace_duration": node_pool_node_eviction_node_pool_settings_eviction_grace_duration,
                "is_force_delete_after_grace_duration": node_pool_node_eviction_node_pool_settings_is_force_delete_after_grace_duration,
            },
            node_image_name=test_image["name"],
            node_metadata=node_pool_node_metadata,
            node_pool_cycling_details={
                "is_node_cycling_enabled": node_pool_node_pool_cycling_details_is_node_cycling_enabled,
                "maximum_surge": node_pool_node_pool_cycling_details_maximum_surge,
                "maximum_unavailable": node_pool_node_pool_cycling_details_maximum_unavailable,
            },
            node_shape_config={
                "memory_in_gbs": node_pool_node_shape_config_memory_in_gbs,
                "ocpus": node_pool_node_shape_config_ocpus,
            },
            node_source_details={
                "image_id": test_image["id"],
                "source_type": node_pool_node_source_details_source_type,
                "boot_volume_size_in_gbs": node_pool_node_source_details_boot_volume_size_in_gbs,
            },
            quantity_per_subnet=node_pool_quantity_per_subnet,
            ssh_public_key=node_pool_ssh_public_key,
            subnet_ids=node_pool_subnet_ids)
        ```

        ## Import

        NodePools can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ContainerEngine/nodePool:NodePool test_node_pool "id"
        ```

        :param str resource_name: The name of the resource.
        :param NodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 initial_node_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolInitialNodeLabelArgs', 'NodePoolInitialNodeLabelArgsDict']]]]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config_details: Optional[pulumi.Input[Union['NodePoolNodeConfigDetailsArgs', 'NodePoolNodeConfigDetailsArgsDict']]] = None,
                 node_eviction_node_pool_settings: Optional[pulumi.Input[Union['NodePoolNodeEvictionNodePoolSettingsArgs', 'NodePoolNodeEvictionNodePoolSettingsArgsDict']]] = None,
                 node_image_id: Optional[pulumi.Input[str]] = None,
                 node_image_name: Optional[pulumi.Input[str]] = None,
                 node_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 node_pool_cycling_details: Optional[pulumi.Input[Union['NodePoolNodePoolCyclingDetailsArgs', 'NodePoolNodePoolCyclingDetailsArgsDict']]] = None,
                 node_shape: Optional[pulumi.Input[str]] = None,
                 node_shape_config: Optional[pulumi.Input[Union['NodePoolNodeShapeConfigArgs', 'NodePoolNodeShapeConfigArgsDict']]] = None,
                 node_source_details: Optional[pulumi.Input[Union['NodePoolNodeSourceDetailsArgs', 'NodePoolNodeSourceDetailsArgsDict']]] = None,
                 quantity_per_subnet: Optional[pulumi.Input[int]] = None,
                 ssh_public_key: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodePoolArgs.__new__(NodePoolArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["initial_node_labels"] = initial_node_labels
            __props__.__dict__["kubernetes_version"] = kubernetes_version
            __props__.__dict__["name"] = name
            __props__.__dict__["node_config_details"] = node_config_details
            __props__.__dict__["node_eviction_node_pool_settings"] = node_eviction_node_pool_settings
            __props__.__dict__["node_image_id"] = node_image_id
            __props__.__dict__["node_image_name"] = node_image_name
            __props__.__dict__["node_metadata"] = node_metadata
            __props__.__dict__["node_pool_cycling_details"] = node_pool_cycling_details
            if node_shape is None and not opts.urn:
                raise TypeError("Missing required property 'node_shape'")
            __props__.__dict__["node_shape"] = node_shape
            __props__.__dict__["node_shape_config"] = node_shape_config
            __props__.__dict__["node_source_details"] = node_source_details
            __props__.__dict__["quantity_per_subnet"] = quantity_per_subnet
            __props__.__dict__["ssh_public_key"] = ssh_public_key
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["node_sources"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["state"] = None
        super(NodePool, __self__).__init__(
            'oci:ContainerEngine/nodePool:NodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            initial_node_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolInitialNodeLabelArgs', 'NodePoolInitialNodeLabelArgsDict']]]]] = None,
            kubernetes_version: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_config_details: Optional[pulumi.Input[Union['NodePoolNodeConfigDetailsArgs', 'NodePoolNodeConfigDetailsArgsDict']]] = None,
            node_eviction_node_pool_settings: Optional[pulumi.Input[Union['NodePoolNodeEvictionNodePoolSettingsArgs', 'NodePoolNodeEvictionNodePoolSettingsArgsDict']]] = None,
            node_image_id: Optional[pulumi.Input[str]] = None,
            node_image_name: Optional[pulumi.Input[str]] = None,
            node_metadata: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            node_pool_cycling_details: Optional[pulumi.Input[Union['NodePoolNodePoolCyclingDetailsArgs', 'NodePoolNodePoolCyclingDetailsArgsDict']]] = None,
            node_shape: Optional[pulumi.Input[str]] = None,
            node_shape_config: Optional[pulumi.Input[Union['NodePoolNodeShapeConfigArgs', 'NodePoolNodeShapeConfigArgsDict']]] = None,
            node_source_details: Optional[pulumi.Input[Union['NodePoolNodeSourceDetailsArgs', 'NodePoolNodeSourceDetailsArgsDict']]] = None,
            node_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolNodeSourceArgs', 'NodePoolNodeSourceArgsDict']]]]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodePoolNodeArgs', 'NodePoolNodeArgsDict']]]]] = None,
            quantity_per_subnet: Optional[pulumi.Input[int]] = None,
            ssh_public_key: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'NodePool':
        """
        Get an existing NodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: The OCID of the cluster to which this node pool is attached.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment in which the node pool exists.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolInitialNodeLabelArgs', 'NodePoolInitialNodeLabelArgsDict']]]] initial_node_labels: (Updatable) A list of key/value pairs to add to nodes after they join the Kubernetes cluster.
        :param pulumi.Input[str] kubernetes_version: (Updatable) The version of Kubernetes to install on the nodes in the node pool.
        :param pulumi.Input[str] lifecycle_details: Details about the state of the node.
        :param pulumi.Input[str] name: (Updatable) The name of the node pool. Avoid entering confidential information.
        :param pulumi.Input[Union['NodePoolNodeConfigDetailsArgs', 'NodePoolNodeConfigDetailsArgsDict']] node_config_details: (Updatable) The configuration of nodes in the node pool. Exactly one of the subnetIds or nodeConfigDetails properties must be specified.
        :param pulumi.Input[Union['NodePoolNodeEvictionNodePoolSettingsArgs', 'NodePoolNodeEvictionNodePoolSettingsArgsDict']] node_eviction_node_pool_settings: (Updatable) Node Eviction Details configuration
        :param pulumi.Input[str] node_image_id: Deprecated. see `nodeSource`. The OCID of the image running on the nodes in the node pool.
        :param pulumi.Input[str] node_image_name: Deprecated. Use `nodeSourceDetails` instead. If you specify values for both, this value is ignored. The name of the image running on the nodes in the node pool. Cannot be used when `node_image_id` is specified.
        :param pulumi.Input[Mapping[str, Any]] node_metadata: (Updatable) A list of key/value pairs to add to each underlying Oracle Cloud Infrastructure instance in the node pool on launch.
        :param pulumi.Input[Union['NodePoolNodePoolCyclingDetailsArgs', 'NodePoolNodePoolCyclingDetailsArgsDict']] node_pool_cycling_details: (Updatable) Node Pool Cycling Details
        :param pulumi.Input[str] node_shape: (Updatable) The name of the node shape of the nodes in the node pool.
        :param pulumi.Input[Union['NodePoolNodeShapeConfigArgs', 'NodePoolNodeShapeConfigArgsDict']] node_shape_config: (Updatable) Specify the configuration of the shape to launch nodes in the node pool.
        :param pulumi.Input[Union['NodePoolNodeSourceDetailsArgs', 'NodePoolNodeSourceDetailsArgsDict']] node_source_details: (Updatable) Specify the source to use to launch nodes in the node pool. Currently, image is the only supported source.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolNodeSourceArgs', 'NodePoolNodeSourceArgsDict']]]] node_sources: Deprecated. see `nodeSourceDetails`. Source running on the nodes in the node pool.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodePoolNodeArgs', 'NodePoolNodeArgsDict']]]] nodes: The nodes in the node pool.
        :param pulumi.Input[int] quantity_per_subnet: (Updatable) Optional, default to 1. The number of nodes to create in each subnet specified in subnetIds property. When used, subnetIds is required. This property is deprecated, use nodeConfigDetails instead.
        :param pulumi.Input[str] ssh_public_key: (Updatable) The SSH public key on each node in the node pool on launch.
        :param pulumi.Input[str] state: The state of the nodepool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: (Updatable) The OCIDs of the subnets in which to place nodes for this node pool. When used, quantityPerSubnet can be provided. This property is deprecated, use nodeConfigDetails. Exactly one of the subnetIds or nodeConfigDetails properties must be specified. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodePoolState.__new__(_NodePoolState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["initial_node_labels"] = initial_node_labels
        __props__.__dict__["kubernetes_version"] = kubernetes_version
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["name"] = name
        __props__.__dict__["node_config_details"] = node_config_details
        __props__.__dict__["node_eviction_node_pool_settings"] = node_eviction_node_pool_settings
        __props__.__dict__["node_image_id"] = node_image_id
        __props__.__dict__["node_image_name"] = node_image_name
        __props__.__dict__["node_metadata"] = node_metadata
        __props__.__dict__["node_pool_cycling_details"] = node_pool_cycling_details
        __props__.__dict__["node_shape"] = node_shape
        __props__.__dict__["node_shape_config"] = node_shape_config
        __props__.__dict__["node_source_details"] = node_source_details
        __props__.__dict__["node_sources"] = node_sources
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["quantity_per_subnet"] = quantity_per_subnet
        __props__.__dict__["ssh_public_key"] = ssh_public_key
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_ids"] = subnet_ids
        return NodePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The OCID of the cluster to which this node pool is attached.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment in which the node pool exists.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="initialNodeLabels")
    def initial_node_labels(self) -> pulumi.Output[Sequence['outputs.NodePoolInitialNodeLabel']]:
        """
        (Updatable) A list of key/value pairs to add to nodes after they join the Kubernetes cluster.
        """
        return pulumi.get(self, "initial_node_labels")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> pulumi.Output[str]:
        """
        (Updatable) The version of Kubernetes to install on the nodes in the node pool.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Details about the state of the node.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        (Updatable) The name of the node pool. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeConfigDetails")
    def node_config_details(self) -> pulumi.Output['outputs.NodePoolNodeConfigDetails']:
        """
        (Updatable) The configuration of nodes in the node pool. Exactly one of the subnetIds or nodeConfigDetails properties must be specified.
        """
        return pulumi.get(self, "node_config_details")

    @property
    @pulumi.getter(name="nodeEvictionNodePoolSettings")
    def node_eviction_node_pool_settings(self) -> pulumi.Output['outputs.NodePoolNodeEvictionNodePoolSettings']:
        """
        (Updatable) Node Eviction Details configuration
        """
        return pulumi.get(self, "node_eviction_node_pool_settings")

    @property
    @pulumi.getter(name="nodeImageId")
    @_utilities.deprecated("""The 'node_image_id' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""")
    def node_image_id(self) -> pulumi.Output[str]:
        """
        Deprecated. see `nodeSource`. The OCID of the image running on the nodes in the node pool.
        """
        return pulumi.get(self, "node_image_id")

    @property
    @pulumi.getter(name="nodeImageName")
    @_utilities.deprecated("""The 'node_image_name' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""")
    def node_image_name(self) -> pulumi.Output[str]:
        """
        Deprecated. Use `nodeSourceDetails` instead. If you specify values for both, this value is ignored. The name of the image running on the nodes in the node pool. Cannot be used when `node_image_id` is specified.
        """
        return pulumi.get(self, "node_image_name")

    @property
    @pulumi.getter(name="nodeMetadata")
    def node_metadata(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) A list of key/value pairs to add to each underlying Oracle Cloud Infrastructure instance in the node pool on launch.
        """
        return pulumi.get(self, "node_metadata")

    @property
    @pulumi.getter(name="nodePoolCyclingDetails")
    def node_pool_cycling_details(self) -> pulumi.Output['outputs.NodePoolNodePoolCyclingDetails']:
        """
        (Updatable) Node Pool Cycling Details
        """
        return pulumi.get(self, "node_pool_cycling_details")

    @property
    @pulumi.getter(name="nodeShape")
    def node_shape(self) -> pulumi.Output[str]:
        """
        (Updatable) The name of the node shape of the nodes in the node pool.
        """
        return pulumi.get(self, "node_shape")

    @property
    @pulumi.getter(name="nodeShapeConfig")
    def node_shape_config(self) -> pulumi.Output['outputs.NodePoolNodeShapeConfig']:
        """
        (Updatable) Specify the configuration of the shape to launch nodes in the node pool.
        """
        return pulumi.get(self, "node_shape_config")

    @property
    @pulumi.getter(name="nodeSourceDetails")
    def node_source_details(self) -> pulumi.Output['outputs.NodePoolNodeSourceDetails']:
        """
        (Updatable) Specify the source to use to launch nodes in the node pool. Currently, image is the only supported source.
        """
        return pulumi.get(self, "node_source_details")

    @property
    @pulumi.getter(name="nodeSources")
    def node_sources(self) -> pulumi.Output[Sequence['outputs.NodePoolNodeSource']]:
        """
        Deprecated. see `nodeSourceDetails`. Source running on the nodes in the node pool.
        """
        return pulumi.get(self, "node_sources")

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.NodePoolNode']]:
        """
        The nodes in the node pool.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="quantityPerSubnet")
    def quantity_per_subnet(self) -> pulumi.Output[int]:
        """
        (Updatable) Optional, default to 1. The number of nodes to create in each subnet specified in subnetIds property. When used, subnetIds is required. This property is deprecated, use nodeConfigDetails instead.
        """
        return pulumi.get(self, "quantity_per_subnet")

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> pulumi.Output[str]:
        """
        (Updatable) The SSH public key on each node in the node pool on launch.
        """
        return pulumi.get(self, "ssh_public_key")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the nodepool.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) The OCIDs of the subnets in which to place nodes for this node pool. When used, quantityPerSubnet can be provided. This property is deprecated, use nodeConfigDetails. Exactly one of the subnetIds or nodeConfigDetails properties must be specified. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_ids")

