# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedDatabaseArgs', 'ManagedDatabase']

@pulumi.input_type
class ManagedDatabaseArgs:
    def __init__(__self__, *,
                 managed_database_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a ManagedDatabase resource.
        :param pulumi.Input[str] managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "managed_database_id")

    @managed_database_id.setter
    def managed_database_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "managed_database_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _ManagedDatabaseState:
    def __init__(__self__, *,
                 additional_details: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 database_status: Optional[pulumi.Input[str]] = None,
                 database_sub_type: Optional[pulumi.Input[str]] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 database_version: Optional[pulumi.Input[str]] = None,
                 db_system_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_cluster: Optional[pulumi.Input[bool]] = None,
                 managed_database_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseManagedDatabaseGroupArgs']]]] = None,
                 managed_database_id: Optional[pulumi.Input[str]] = None,
                 management_option: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_container_id: Optional[pulumi.Input[str]] = None,
                 storage_system_id: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ManagedDatabase resources.
        :param pulumi.Input[Mapping[str, Any]] additional_details: The additional details specific to a type of database defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the Managed Database Group resides.
        :param pulumi.Input[str] database_status: The status of the Oracle Database. Indicates whether the status of the database is UP, DOWN, or UNKNOWN at the current time.
        :param pulumi.Input[str] database_sub_type: The subtype of the Oracle Database. Indicates whether the database is a Container Database, Pluggable Database, Non-container Database, Autonomous Database, or Autonomous Container Database.
        :param pulumi.Input[str] database_type: The type of Oracle Database installation.
        :param pulumi.Input[str] database_version: The Oracle Database version.
        :param pulumi.Input[str] db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that this Managed Database is part of.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] deployment_type: The infrastructure used to deploy the Oracle Database.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_cluster: Indicates whether the Oracle Database is part of a cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseManagedDatabaseGroupArgs']]] managed_database_groups: A list of Managed Database Groups that the Managed Database belongs to.
        :param pulumi.Input[str] managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] management_option: The management option used when enabling Database Management.
        :param pulumi.Input[str] name: The name of the Managed Database.
        :param pulumi.Input[str] parent_container_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the parent Container Database if Managed Database is a Pluggable Database.
        :param pulumi.Input[str] storage_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the storage DB system.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the Managed Database was created.
        :param pulumi.Input[str] workload_type: The workload type of the Autonomous Database.
        """
        if additional_details is not None:
            pulumi.set(__self__, "additional_details", additional_details)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if database_status is not None:
            pulumi.set(__self__, "database_status", database_status)
        if database_sub_type is not None:
            pulumi.set(__self__, "database_sub_type", database_sub_type)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if database_version is not None:
            pulumi.set(__self__, "database_version", database_version)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_cluster is not None:
            pulumi.set(__self__, "is_cluster", is_cluster)
        if managed_database_groups is not None:
            pulumi.set(__self__, "managed_database_groups", managed_database_groups)
        if managed_database_id is not None:
            pulumi.set(__self__, "managed_database_id", managed_database_id)
        if management_option is not None:
            pulumi.set(__self__, "management_option", management_option)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_container_id is not None:
            pulumi.set(__self__, "parent_container_id", parent_container_id)
        if storage_system_id is not None:
            pulumi.set(__self__, "storage_system_id", storage_system_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The additional details specific to a type of database defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @additional_details.setter
    def additional_details(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "additional_details", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the Managed Database Group resides.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="databaseStatus")
    def database_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the Oracle Database. Indicates whether the status of the database is UP, DOWN, or UNKNOWN at the current time.
        """
        return pulumi.get(self, "database_status")

    @database_status.setter
    def database_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_status", value)

    @property
    @pulumi.getter(name="databaseSubType")
    def database_sub_type(self) -> Optional[pulumi.Input[str]]:
        """
        The subtype of the Oracle Database. Indicates whether the database is a Container Database, Pluggable Database, Non-container Database, Autonomous Database, or Autonomous Container Database.
        """
        return pulumi.get(self, "database_sub_type")

    @database_sub_type.setter
    def database_sub_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_sub_type", value)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of Oracle Database installation.
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle Database version.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_version", value)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that this Managed Database is part of.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The infrastructure used to deploy the Oracle Database.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the Oracle Database is part of a cluster.
        """
        return pulumi.get(self, "is_cluster")

    @is_cluster.setter
    def is_cluster(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cluster", value)

    @property
    @pulumi.getter(name="managedDatabaseGroups")
    def managed_database_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseManagedDatabaseGroupArgs']]]]:
        """
        A list of Managed Database Groups that the Managed Database belongs to.
        """
        return pulumi.get(self, "managed_database_groups")

    @managed_database_groups.setter
    def managed_database_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedDatabaseManagedDatabaseGroupArgs']]]]):
        pulumi.set(self, "managed_database_groups", value)

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "managed_database_id")

    @managed_database_id.setter
    def managed_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_database_id", value)

    @property
    @pulumi.getter(name="managementOption")
    def management_option(self) -> Optional[pulumi.Input[str]]:
        """
        The management option used when enabling Database Management.
        """
        return pulumi.get(self, "management_option")

    @management_option.setter
    def management_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_option", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Managed Database.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentContainerId")
    def parent_container_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the parent Container Database if Managed Database is a Pluggable Database.
        """
        return pulumi.get(self, "parent_container_id")

    @parent_container_id.setter
    def parent_container_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_container_id", value)

    @property
    @pulumi.getter(name="storageSystemId")
    def storage_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the storage DB system.
        """
        return pulumi.get(self, "storage_system_id")

    @storage_system_id.setter
    def storage_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_system_id", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the Managed Database was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[str]]:
        """
        The workload type of the Autonomous Database.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workload_type", value)


class ManagedDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 managed_database_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Managed Database resource in Oracle Cloud Infrastructure Database Management service.

        Updates the Managed Database specified by managedDatabaseId.

        ## Import

        ManagedDatabases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseManagement/managedDatabase:ManagedDatabase test_managed_database "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Managed Database resource in Oracle Cloud Infrastructure Database Management service.

        Updates the Managed Database specified by managedDatabaseId.

        ## Import

        ManagedDatabases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseManagement/managedDatabase:ManagedDatabase test_managed_database "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagedDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 managed_database_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedDatabaseArgs.__new__(ManagedDatabaseArgs)

            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            if managed_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_database_id'")
            __props__.__dict__["managed_database_id"] = managed_database_id
            __props__.__dict__["additional_details"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["database_status"] = None
            __props__.__dict__["database_sub_type"] = None
            __props__.__dict__["database_type"] = None
            __props__.__dict__["database_version"] = None
            __props__.__dict__["db_system_id"] = None
            __props__.__dict__["deployment_type"] = None
            __props__.__dict__["is_cluster"] = None
            __props__.__dict__["managed_database_groups"] = None
            __props__.__dict__["management_option"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["parent_container_id"] = None
            __props__.__dict__["storage_system_id"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["workload_type"] = None
        super(ManagedDatabase, __self__).__init__(
            'oci:DatabaseManagement/managedDatabase:ManagedDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_details: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            database_status: Optional[pulumi.Input[str]] = None,
            database_sub_type: Optional[pulumi.Input[str]] = None,
            database_type: Optional[pulumi.Input[str]] = None,
            database_version: Optional[pulumi.Input[str]] = None,
            db_system_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            deployment_type: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_cluster: Optional[pulumi.Input[bool]] = None,
            managed_database_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedDatabaseManagedDatabaseGroupArgs', 'ManagedDatabaseManagedDatabaseGroupArgsDict']]]]] = None,
            managed_database_id: Optional[pulumi.Input[str]] = None,
            management_option: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parent_container_id: Optional[pulumi.Input[str]] = None,
            storage_system_id: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            workload_type: Optional[pulumi.Input[str]] = None) -> 'ManagedDatabase':
        """
        Get an existing ManagedDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] additional_details: The additional details specific to a type of database defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the Managed Database Group resides.
        :param pulumi.Input[str] database_status: The status of the Oracle Database. Indicates whether the status of the database is UP, DOWN, or UNKNOWN at the current time.
        :param pulumi.Input[str] database_sub_type: The subtype of the Oracle Database. Indicates whether the database is a Container Database, Pluggable Database, Non-container Database, Autonomous Database, or Autonomous Container Database.
        :param pulumi.Input[str] database_type: The type of Oracle Database installation.
        :param pulumi.Input[str] database_version: The Oracle Database version.
        :param pulumi.Input[str] db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that this Managed Database is part of.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] deployment_type: The infrastructure used to deploy the Oracle Database.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_cluster: Indicates whether the Oracle Database is part of a cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedDatabaseManagedDatabaseGroupArgs', 'ManagedDatabaseManagedDatabaseGroupArgsDict']]]] managed_database_groups: A list of Managed Database Groups that the Managed Database belongs to.
        :param pulumi.Input[str] managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] management_option: The management option used when enabling Database Management.
        :param pulumi.Input[str] name: The name of the Managed Database.
        :param pulumi.Input[str] parent_container_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the parent Container Database if Managed Database is a Pluggable Database.
        :param pulumi.Input[str] storage_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the storage DB system.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the Managed Database was created.
        :param pulumi.Input[str] workload_type: The workload type of the Autonomous Database.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedDatabaseState.__new__(_ManagedDatabaseState)

        __props__.__dict__["additional_details"] = additional_details
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["database_status"] = database_status
        __props__.__dict__["database_sub_type"] = database_sub_type
        __props__.__dict__["database_type"] = database_type
        __props__.__dict__["database_version"] = database_version
        __props__.__dict__["db_system_id"] = db_system_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["deployment_type"] = deployment_type
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_cluster"] = is_cluster
        __props__.__dict__["managed_database_groups"] = managed_database_groups
        __props__.__dict__["managed_database_id"] = managed_database_id
        __props__.__dict__["management_option"] = management_option
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_container_id"] = parent_container_id
        __props__.__dict__["storage_system_id"] = storage_system_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["workload_type"] = workload_type
        return ManagedDatabase(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        The additional details specific to a type of database defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the Managed Database Group resides.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseStatus")
    def database_status(self) -> pulumi.Output[str]:
        """
        The status of the Oracle Database. Indicates whether the status of the database is UP, DOWN, or UNKNOWN at the current time.
        """
        return pulumi.get(self, "database_status")

    @property
    @pulumi.getter(name="databaseSubType")
    def database_sub_type(self) -> pulumi.Output[str]:
        """
        The subtype of the Oracle Database. Indicates whether the database is a Container Database, Pluggable Database, Non-container Database, Autonomous Database, or Autonomous Container Database.
        """
        return pulumi.get(self, "database_sub_type")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Output[str]:
        """
        The type of Oracle Database installation.
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> pulumi.Output[str]:
        """
        The Oracle Database version.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that this Managed Database is part of.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Output[str]:
        """
        The infrastructure used to deploy the Oracle Database.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> pulumi.Output[bool]:
        """
        Indicates whether the Oracle Database is part of a cluster.
        """
        return pulumi.get(self, "is_cluster")

    @property
    @pulumi.getter(name="managedDatabaseGroups")
    def managed_database_groups(self) -> pulumi.Output[Sequence['outputs.ManagedDatabaseManagedDatabaseGroup']]:
        """
        A list of Managed Database Groups that the Managed Database belongs to.
        """
        return pulumi.get(self, "managed_database_groups")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter(name="managementOption")
    def management_option(self) -> pulumi.Output[str]:
        """
        The management option used when enabling Database Management.
        """
        return pulumi.get(self, "management_option")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Managed Database.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentContainerId")
    def parent_container_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the parent Container Database if Managed Database is a Pluggable Database.
        """
        return pulumi.get(self, "parent_container_id")

    @property
    @pulumi.getter(name="storageSystemId")
    def storage_system_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the storage DB system.
        """
        return pulumi.get(self, "storage_system_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the Managed Database was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> pulumi.Output[str]:
        """
        The workload type of the Autonomous Database.
        """
        return pulumi.get(self, "workload_type")

