# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetConnectionResult',
    'AwaitableGetConnectionResult',
    'get_connection',
    'get_connection_output',
]

@pulumi.output_type
class GetConnectionResult:
    """
    A collection of values returned by getConnection.
    """
    def __init__(__self__, additional_attributes=None, compartment_id=None, connection_id=None, connection_string=None, connection_type=None, database_id=None, database_name=None, db_system_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, host=None, id=None, ingress_ips=None, key_id=None, lifecycle_details=None, nsg_ids=None, password=None, port=None, private_endpoint_id=None, replication_password=None, replication_username=None, secret_id=None, security_protocol=None, ssh_host=None, ssh_key=None, ssh_sudo_location=None, ssh_user=None, ssl_ca=None, ssl_cert=None, ssl_crl=None, ssl_key=None, ssl_mode=None, state=None, subnet_id=None, system_tags=None, technology_type=None, time_created=None, time_updated=None, username=None, vault_id=None, wallet=None):
        if additional_attributes and not isinstance(additional_attributes, list):
            raise TypeError("Expected argument 'additional_attributes' to be a list")
        pulumi.set(__self__, "additional_attributes", additional_attributes)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_id and not isinstance(connection_id, str):
            raise TypeError("Expected argument 'connection_id' to be a str")
        pulumi.set(__self__, "connection_id", connection_id)
        if connection_string and not isinstance(connection_string, str):
            raise TypeError("Expected argument 'connection_string' to be a str")
        pulumi.set(__self__, "connection_string", connection_string)
        if connection_type and not isinstance(connection_type, str):
            raise TypeError("Expected argument 'connection_type' to be a str")
        pulumi.set(__self__, "connection_type", connection_type)
        if database_id and not isinstance(database_id, str):
            raise TypeError("Expected argument 'database_id' to be a str")
        pulumi.set(__self__, "database_id", database_id)
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host and not isinstance(host, str):
            raise TypeError("Expected argument 'host' to be a str")
        pulumi.set(__self__, "host", host)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ingress_ips and not isinstance(ingress_ips, list):
            raise TypeError("Expected argument 'ingress_ips' to be a list")
        pulumi.set(__self__, "ingress_ips", ingress_ips)
        if key_id and not isinstance(key_id, str):
            raise TypeError("Expected argument 'key_id' to be a str")
        pulumi.set(__self__, "key_id", key_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if nsg_ids and not isinstance(nsg_ids, list):
            raise TypeError("Expected argument 'nsg_ids' to be a list")
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if private_endpoint_id and not isinstance(private_endpoint_id, str):
            raise TypeError("Expected argument 'private_endpoint_id' to be a str")
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        if replication_password and not isinstance(replication_password, str):
            raise TypeError("Expected argument 'replication_password' to be a str")
        pulumi.set(__self__, "replication_password", replication_password)
        if replication_username and not isinstance(replication_username, str):
            raise TypeError("Expected argument 'replication_username' to be a str")
        pulumi.set(__self__, "replication_username", replication_username)
        if secret_id and not isinstance(secret_id, str):
            raise TypeError("Expected argument 'secret_id' to be a str")
        pulumi.set(__self__, "secret_id", secret_id)
        if security_protocol and not isinstance(security_protocol, str):
            raise TypeError("Expected argument 'security_protocol' to be a str")
        pulumi.set(__self__, "security_protocol", security_protocol)
        if ssh_host and not isinstance(ssh_host, str):
            raise TypeError("Expected argument 'ssh_host' to be a str")
        pulumi.set(__self__, "ssh_host", ssh_host)
        if ssh_key and not isinstance(ssh_key, str):
            raise TypeError("Expected argument 'ssh_key' to be a str")
        pulumi.set(__self__, "ssh_key", ssh_key)
        if ssh_sudo_location and not isinstance(ssh_sudo_location, str):
            raise TypeError("Expected argument 'ssh_sudo_location' to be a str")
        pulumi.set(__self__, "ssh_sudo_location", ssh_sudo_location)
        if ssh_user and not isinstance(ssh_user, str):
            raise TypeError("Expected argument 'ssh_user' to be a str")
        pulumi.set(__self__, "ssh_user", ssh_user)
        if ssl_ca and not isinstance(ssl_ca, str):
            raise TypeError("Expected argument 'ssl_ca' to be a str")
        pulumi.set(__self__, "ssl_ca", ssl_ca)
        if ssl_cert and not isinstance(ssl_cert, str):
            raise TypeError("Expected argument 'ssl_cert' to be a str")
        pulumi.set(__self__, "ssl_cert", ssl_cert)
        if ssl_crl and not isinstance(ssl_crl, str):
            raise TypeError("Expected argument 'ssl_crl' to be a str")
        pulumi.set(__self__, "ssl_crl", ssl_crl)
        if ssl_key and not isinstance(ssl_key, str):
            raise TypeError("Expected argument 'ssl_key' to be a str")
        pulumi.set(__self__, "ssl_key", ssl_key)
        if ssl_mode and not isinstance(ssl_mode, str):
            raise TypeError("Expected argument 'ssl_mode' to be a str")
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if technology_type and not isinstance(technology_type, str):
            raise TypeError("Expected argument 'technology_type' to be a str")
        pulumi.set(__self__, "technology_type", technology_type)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)
        if vault_id and not isinstance(vault_id, str):
            raise TypeError("Expected argument 'vault_id' to be a str")
        pulumi.set(__self__, "vault_id", vault_id)
        if wallet and not isinstance(wallet, str):
            raise TypeError("Expected argument 'wallet' to be a str")
        pulumi.set(__self__, "wallet", wallet)

    @property
    @pulumi.getter(name="additionalAttributes")
    def additional_attributes(self) -> Sequence['outputs.GetConnectionAdditionalAttributeResult']:
        """
        An array of name-value pair attribute entries.
        """
        return pulumi.get(self, "additional_attributes")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> str:
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        Connect descriptor or Easy Connect Naming method used to connect to a database.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> str:
        """
        Defines the type of connection. For example, ORACLE.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> str:
        """
        The OCID of the database being referenced.
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        The name of the database being referenced.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> str:
        """
        The OCID of the database system being referenced.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user-friendly description. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The IP Address of the host.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the connection being referenced.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ingressIps")
    def ingress_ips(self) -> Sequence['outputs.GetConnectionIngressIpResult']:
        """
        List of ingress IP addresses from where to connect to this connection's privateIp.
        """
        return pulumi.get(self, "ingress_ips")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        The OCID of the key used in cryptographic operations.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        The message describing the current state of the connection's lifecycle in detail. For example, can be used to provide actionable information for a connection in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        An array of Network Security Group OCIDs used to define network access for Connections.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port to be used for the connection.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> str:
        """
        The OCID of the resource being referenced.
        """
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter(name="replicationPassword")
    def replication_password(self) -> str:
        """
        The password (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "replication_password")

    @property
    @pulumi.getter(name="replicationUsername")
    def replication_username(self) -> str:
        """
        The username (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "replication_username")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        """
        The OCID of the resource being referenced.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> str:
        """
        Security Protocol to be used for the connection.
        """
        return pulumi.get(self, "security_protocol")

    @property
    @pulumi.getter(name="sshHost")
    def ssh_host(self) -> str:
        """
        Name of the host the SSH key is valid for.
        """
        return pulumi.get(self, "ssh_host")

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> str:
        """
        Private SSH key string.
        """
        return pulumi.get(self, "ssh_key")

    @property
    @pulumi.getter(name="sshSudoLocation")
    def ssh_sudo_location(self) -> str:
        """
        Sudo location
        """
        return pulumi.get(self, "ssh_sudo_location")

    @property
    @pulumi.getter(name="sshUser")
    def ssh_user(self) -> str:
        """
        The username (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "ssh_user")

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> str:
        return pulumi.get(self, "ssl_ca")

    @property
    @pulumi.getter(name="sslCert")
    def ssl_cert(self) -> str:
        return pulumi.get(self, "ssl_cert")

    @property
    @pulumi.getter(name="sslCrl")
    def ssl_crl(self) -> str:
        return pulumi.get(self, "ssl_crl")

    @property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> str:
        return pulumi.get(self, "ssl_key")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> str:
        """
        SSL mode to be used for the connection.
        """
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The Connection's current lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        Oracle Cloud Infrastructure resource ID.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="technologyType")
    def technology_type(self) -> str:
        """
        The type of MySQL source or target connection. Example: OCI_MYSQL represents Oracle Cloud Infrastructure MySQL HeatWave Database Service
        """
        return pulumi.get(self, "technology_type")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time when this resource was created. An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time when this resource was updated. An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        Oracle Cloud Infrastructure resource ID.
        """
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter
    def wallet(self) -> str:
        return pulumi.get(self, "wallet")


class AwaitableGetConnectionResult(GetConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionResult(
            additional_attributes=self.additional_attributes,
            compartment_id=self.compartment_id,
            connection_id=self.connection_id,
            connection_string=self.connection_string,
            connection_type=self.connection_type,
            database_id=self.database_id,
            database_name=self.database_name,
            db_system_id=self.db_system_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            host=self.host,
            id=self.id,
            ingress_ips=self.ingress_ips,
            key_id=self.key_id,
            lifecycle_details=self.lifecycle_details,
            nsg_ids=self.nsg_ids,
            password=self.password,
            port=self.port,
            private_endpoint_id=self.private_endpoint_id,
            replication_password=self.replication_password,
            replication_username=self.replication_username,
            secret_id=self.secret_id,
            security_protocol=self.security_protocol,
            ssh_host=self.ssh_host,
            ssh_key=self.ssh_key,
            ssh_sudo_location=self.ssh_sudo_location,
            ssh_user=self.ssh_user,
            ssl_ca=self.ssl_ca,
            ssl_cert=self.ssl_cert,
            ssl_crl=self.ssl_crl,
            ssl_key=self.ssl_key,
            ssl_mode=self.ssl_mode,
            state=self.state,
            subnet_id=self.subnet_id,
            system_tags=self.system_tags,
            technology_type=self.technology_type,
            time_created=self.time_created,
            time_updated=self.time_updated,
            username=self.username,
            vault_id=self.vault_id,
            wallet=self.wallet)


def get_connection(connection_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_connection = oci.DatabaseMigration.get_connection(connection_id=test_connection_oci_database_migration_connection["id"])
    ```


    :param str connection_id: The OCID of the database connection.
    """
    __args__ = dict()
    __args__['connectionId'] = connection_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseMigration/getConnection:getConnection', __args__, opts=opts, typ=GetConnectionResult).value

    return AwaitableGetConnectionResult(
        additional_attributes=pulumi.get(__ret__, 'additional_attributes'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connection_id=pulumi.get(__ret__, 'connection_id'),
        connection_string=pulumi.get(__ret__, 'connection_string'),
        connection_type=pulumi.get(__ret__, 'connection_type'),
        database_id=pulumi.get(__ret__, 'database_id'),
        database_name=pulumi.get(__ret__, 'database_name'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        host=pulumi.get(__ret__, 'host'),
        id=pulumi.get(__ret__, 'id'),
        ingress_ips=pulumi.get(__ret__, 'ingress_ips'),
        key_id=pulumi.get(__ret__, 'key_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        nsg_ids=pulumi.get(__ret__, 'nsg_ids'),
        password=pulumi.get(__ret__, 'password'),
        port=pulumi.get(__ret__, 'port'),
        private_endpoint_id=pulumi.get(__ret__, 'private_endpoint_id'),
        replication_password=pulumi.get(__ret__, 'replication_password'),
        replication_username=pulumi.get(__ret__, 'replication_username'),
        secret_id=pulumi.get(__ret__, 'secret_id'),
        security_protocol=pulumi.get(__ret__, 'security_protocol'),
        ssh_host=pulumi.get(__ret__, 'ssh_host'),
        ssh_key=pulumi.get(__ret__, 'ssh_key'),
        ssh_sudo_location=pulumi.get(__ret__, 'ssh_sudo_location'),
        ssh_user=pulumi.get(__ret__, 'ssh_user'),
        ssl_ca=pulumi.get(__ret__, 'ssl_ca'),
        ssl_cert=pulumi.get(__ret__, 'ssl_cert'),
        ssl_crl=pulumi.get(__ret__, 'ssl_crl'),
        ssl_key=pulumi.get(__ret__, 'ssl_key'),
        ssl_mode=pulumi.get(__ret__, 'ssl_mode'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        technology_type=pulumi.get(__ret__, 'technology_type'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        username=pulumi.get(__ret__, 'username'),
        vault_id=pulumi.get(__ret__, 'vault_id'),
        wallet=pulumi.get(__ret__, 'wallet'))


@_utilities.lift_output_func(get_connection)
def get_connection_output(connection_id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConnectionResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_connection = oci.DatabaseMigration.get_connection(connection_id=test_connection_oci_database_migration_connection["id"])
    ```


    :param str connection_id: The OCID of the database connection.
    """
    ...
