# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TargetDatabaseArgs', 'TargetDatabase']

@pulumi.input_type
class TargetDatabaseArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 database_details: pulumi.Input['TargetDatabaseDatabaseDetailsArgs'],
                 connection_option: Optional[pulumi.Input['TargetDatabaseConnectionOptionArgs']] = None,
                 credentials: Optional[pulumi.Input['TargetDatabaseCredentialsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 peer_target_database_details: Optional[pulumi.Input[Sequence[pulumi.Input['TargetDatabasePeerTargetDatabaseDetailArgs']]]] = None,
                 tls_config: Optional[pulumi.Input['TargetDatabaseTlsConfigArgs']] = None):
        """
        The set of arguments for constructing a TargetDatabase resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment in which to create the Data Safe target database.
        :param pulumi.Input['TargetDatabaseDatabaseDetailsArgs'] database_details: (Updatable) Details of the database for the registration in Data Safe.
        :param pulumi.Input['TargetDatabaseConnectionOptionArgs'] connection_option: (Updatable) Types of connection supported by Data Safe.
        :param pulumi.Input['TargetDatabaseCredentialsArgs'] credentials: (Updatable) The database credentials required for Data Safe to connect to the database.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the target database in Data Safe.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the target database in Data Safe. The name is modifiable and does not need to be unique.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['TargetDatabasePeerTargetDatabaseDetailArgs']]] peer_target_database_details: The details of the database to be registered as a peer target database.
        :param pulumi.Input['TargetDatabaseTlsConfigArgs'] tls_config: (Updatable) The details required to establish a TLS enabled connection.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "database_details", database_details)
        if connection_option is not None:
            pulumi.set(__self__, "connection_option", connection_option)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if peer_target_database_details is not None:
            pulumi.set(__self__, "peer_target_database_details", peer_target_database_details)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment in which to create the Data Safe target database.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="databaseDetails")
    def database_details(self) -> pulumi.Input['TargetDatabaseDatabaseDetailsArgs']:
        """
        (Updatable) Details of the database for the registration in Data Safe.
        """
        return pulumi.get(self, "database_details")

    @database_details.setter
    def database_details(self, value: pulumi.Input['TargetDatabaseDatabaseDetailsArgs']):
        pulumi.set(self, "database_details", value)

    @property
    @pulumi.getter(name="connectionOption")
    def connection_option(self) -> Optional[pulumi.Input['TargetDatabaseConnectionOptionArgs']]:
        """
        (Updatable) Types of connection supported by Data Safe.
        """
        return pulumi.get(self, "connection_option")

    @connection_option.setter
    def connection_option(self, value: Optional[pulumi.Input['TargetDatabaseConnectionOptionArgs']]):
        pulumi.set(self, "connection_option", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['TargetDatabaseCredentialsArgs']]:
        """
        (Updatable) The database credentials required for Data Safe to connect to the database.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['TargetDatabaseCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the target database in Data Safe.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the target database in Data Safe. The name is modifiable and does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="peerTargetDatabaseDetails")
    def peer_target_database_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetDatabasePeerTargetDatabaseDetailArgs']]]]:
        """
        The details of the database to be registered as a peer target database.
        """
        return pulumi.get(self, "peer_target_database_details")

    @peer_target_database_details.setter
    def peer_target_database_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetDatabasePeerTargetDatabaseDetailArgs']]]]):
        pulumi.set(self, "peer_target_database_details", value)

    @property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[pulumi.Input['TargetDatabaseTlsConfigArgs']]:
        """
        (Updatable) The details required to establish a TLS enabled connection.
        """
        return pulumi.get(self, "tls_config")

    @tls_config.setter
    def tls_config(self, value: Optional[pulumi.Input['TargetDatabaseTlsConfigArgs']]):
        pulumi.set(self, "tls_config", value)


@pulumi.input_type
class _TargetDatabaseState:
    def __init__(__self__, *,
                 associated_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connection_option: Optional[pulumi.Input['TargetDatabaseConnectionOptionArgs']] = None,
                 credentials: Optional[pulumi.Input['TargetDatabaseCredentialsArgs']] = None,
                 database_details: Optional[pulumi.Input['TargetDatabaseDatabaseDetailsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 peer_target_database_details: Optional[pulumi.Input[Sequence[pulumi.Input['TargetDatabasePeerTargetDatabaseDetailArgs']]]] = None,
                 peer_target_databases: Optional[pulumi.Input[Sequence[pulumi.Input['TargetDatabasePeerTargetDatabaseArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 tls_config: Optional[pulumi.Input['TargetDatabaseTlsConfigArgs']] = None):
        """
        Input properties used for looking up and filtering TargetDatabase resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] associated_resource_ids: The OCIDs of associated resources like database, Data Safe private endpoint etc.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment in which to create the Data Safe target database.
        :param pulumi.Input['TargetDatabaseConnectionOptionArgs'] connection_option: (Updatable) Types of connection supported by Data Safe.
        :param pulumi.Input['TargetDatabaseCredentialsArgs'] credentials: (Updatable) The database credentials required for Data Safe to connect to the database.
        :param pulumi.Input['TargetDatabaseDatabaseDetailsArgs'] database_details: (Updatable) Details of the database for the registration in Data Safe.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the target database in Data Safe.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the target database in Data Safe. The name is modifiable and does not need to be unique.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the peer target database in Data Safe.
        :param pulumi.Input[Sequence[pulumi.Input['TargetDatabasePeerTargetDatabaseDetailArgs']]] peer_target_database_details: The details of the database to be registered as a peer target database.
        :param pulumi.Input[Sequence[pulumi.Input['TargetDatabasePeerTargetDatabaseArgs']]] peer_target_databases: The OCIDs of associated resources like Database, Data Safe private endpoint etc.
        :param pulumi.Input[str] state: The current state of the target database in Data Safe.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the database was registered in Data Safe and created as a target database in Data Safe.
        :param pulumi.Input[str] time_updated: The date and time of the target database update in Data Safe.
        :param pulumi.Input['TargetDatabaseTlsConfigArgs'] tls_config: (Updatable) The details required to establish a TLS enabled connection.
        """
        if associated_resource_ids is not None:
            pulumi.set(__self__, "associated_resource_ids", associated_resource_ids)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_option is not None:
            pulumi.set(__self__, "connection_option", connection_option)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if database_details is not None:
            pulumi.set(__self__, "database_details", database_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if peer_target_database_details is not None:
            pulumi.set(__self__, "peer_target_database_details", peer_target_database_details)
        if peer_target_databases is not None:
            pulumi.set(__self__, "peer_target_databases", peer_target_databases)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)

    @property
    @pulumi.getter(name="associatedResourceIds")
    def associated_resource_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The OCIDs of associated resources like database, Data Safe private endpoint etc.
        """
        return pulumi.get(self, "associated_resource_ids")

    @associated_resource_ids.setter
    def associated_resource_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "associated_resource_ids", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment in which to create the Data Safe target database.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectionOption")
    def connection_option(self) -> Optional[pulumi.Input['TargetDatabaseConnectionOptionArgs']]:
        """
        (Updatable) Types of connection supported by Data Safe.
        """
        return pulumi.get(self, "connection_option")

    @connection_option.setter
    def connection_option(self, value: Optional[pulumi.Input['TargetDatabaseConnectionOptionArgs']]):
        pulumi.set(self, "connection_option", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['TargetDatabaseCredentialsArgs']]:
        """
        (Updatable) The database credentials required for Data Safe to connect to the database.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['TargetDatabaseCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="databaseDetails")
    def database_details(self) -> Optional[pulumi.Input['TargetDatabaseDatabaseDetailsArgs']]:
        """
        (Updatable) Details of the database for the registration in Data Safe.
        """
        return pulumi.get(self, "database_details")

    @database_details.setter
    def database_details(self, value: Optional[pulumi.Input['TargetDatabaseDatabaseDetailsArgs']]):
        pulumi.set(self, "database_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the target database in Data Safe.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the target database in Data Safe. The name is modifiable and does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details about the current state of the peer target database in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="peerTargetDatabaseDetails")
    def peer_target_database_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetDatabasePeerTargetDatabaseDetailArgs']]]]:
        """
        The details of the database to be registered as a peer target database.
        """
        return pulumi.get(self, "peer_target_database_details")

    @peer_target_database_details.setter
    def peer_target_database_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetDatabasePeerTargetDatabaseDetailArgs']]]]):
        pulumi.set(self, "peer_target_database_details", value)

    @property
    @pulumi.getter(name="peerTargetDatabases")
    def peer_target_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetDatabasePeerTargetDatabaseArgs']]]]:
        """
        The OCIDs of associated resources like Database, Data Safe private endpoint etc.
        """
        return pulumi.get(self, "peer_target_databases")

    @peer_target_databases.setter
    def peer_target_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetDatabasePeerTargetDatabaseArgs']]]]):
        pulumi.set(self, "peer_target_databases", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the target database in Data Safe.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the database was registered in Data Safe and created as a target database in Data Safe.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the target database update in Data Safe.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[pulumi.Input['TargetDatabaseTlsConfigArgs']]:
        """
        (Updatable) The details required to establish a TLS enabled connection.
        """
        return pulumi.get(self, "tls_config")

    @tls_config.setter
    def tls_config(self, value: Optional[pulumi.Input['TargetDatabaseTlsConfigArgs']]):
        pulumi.set(self, "tls_config", value)


class TargetDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connection_option: Optional[pulumi.Input[Union['TargetDatabaseConnectionOptionArgs', 'TargetDatabaseConnectionOptionArgsDict']]] = None,
                 credentials: Optional[pulumi.Input[Union['TargetDatabaseCredentialsArgs', 'TargetDatabaseCredentialsArgsDict']]] = None,
                 database_details: Optional[pulumi.Input[Union['TargetDatabaseDatabaseDetailsArgs', 'TargetDatabaseDatabaseDetailsArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 peer_target_database_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetDatabasePeerTargetDatabaseDetailArgs', 'TargetDatabasePeerTargetDatabaseDetailArgsDict']]]]] = None,
                 tls_config: Optional[pulumi.Input[Union['TargetDatabaseTlsConfigArgs', 'TargetDatabaseTlsConfigArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Target Database resource in Oracle Cloud Infrastructure Data Safe service.

        Registers the specified database with Data Safe and creates a Data Safe target database in the Data Safe Console.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_target_database = oci.data_safe.TargetDatabase("test_target_database",
            compartment_id=compartment_id,
            database_details={
                "database_type": target_database_database_details_database_type,
                "infrastructure_type": target_database_database_details_infrastructure_type,
                "autonomous_database_id": test_autonomous_database["id"],
                "db_system_id": test_db_system["id"],
                "instance_id": test_instance["id"],
                "ip_addresses": target_database_database_details_ip_addresses,
                "listener_port": target_database_database_details_listener_port,
                "service_name": test_service["name"],
                "vm_cluster_id": test_vm_cluster["id"],
            },
            connection_option={
                "connection_type": target_database_connection_option_connection_type,
                "datasafe_private_endpoint_id": test_private_endpoint["id"],
                "on_prem_connector_id": test_on_prem_connector["id"],
            },
            credentials={
                "password": target_database_credentials_password,
                "user_name": test_user["name"],
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=target_database_description,
            display_name=target_database_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            peer_target_database_details=[{
                "database_details": {
                    "database_type": target_database_peer_target_database_details_database_details_database_type,
                    "infrastructure_type": target_database_peer_target_database_details_database_details_infrastructure_type,
                    "autonomous_database_id": test_autonomous_database["id"],
                    "db_system_id": test_db_system["id"],
                    "instance_id": test_instance["id"],
                    "ip_addresses": target_database_peer_target_database_details_database_details_ip_addresses,
                    "listener_port": target_database_peer_target_database_details_database_details_listener_port,
                    "service_name": test_service["name"],
                    "vm_cluster_id": test_vm_cluster["id"],
                },
                "dataguard_association_id": test_association["id"],
                "description": target_database_peer_target_database_details_description,
                "display_name": target_database_peer_target_database_details_display_name,
                "tls_config": {
                    "status": target_database_peer_target_database_details_tls_config_status,
                    "certificate_store_type": target_database_peer_target_database_details_tls_config_certificate_store_type,
                    "key_store_content": target_database_peer_target_database_details_tls_config_key_store_content,
                    "store_password": target_database_peer_target_database_details_tls_config_store_password,
                    "trust_store_content": target_database_peer_target_database_details_tls_config_trust_store_content,
                },
            }],
            tls_config={
                "status": target_database_tls_config_status,
                "certificate_store_type": target_database_tls_config_certificate_store_type,
                "key_store_content": target_database_tls_config_key_store_content,
                "store_password": target_database_tls_config_store_password,
                "trust_store_content": target_database_tls_config_trust_store_content,
            })
        ```

        ## Import

        TargetDatabases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/targetDatabase:TargetDatabase test_target_database "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment in which to create the Data Safe target database.
        :param pulumi.Input[Union['TargetDatabaseConnectionOptionArgs', 'TargetDatabaseConnectionOptionArgsDict']] connection_option: (Updatable) Types of connection supported by Data Safe.
        :param pulumi.Input[Union['TargetDatabaseCredentialsArgs', 'TargetDatabaseCredentialsArgsDict']] credentials: (Updatable) The database credentials required for Data Safe to connect to the database.
        :param pulumi.Input[Union['TargetDatabaseDatabaseDetailsArgs', 'TargetDatabaseDatabaseDetailsArgsDict']] database_details: (Updatable) Details of the database for the registration in Data Safe.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the target database in Data Safe.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the target database in Data Safe. The name is modifiable and does not need to be unique.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['TargetDatabasePeerTargetDatabaseDetailArgs', 'TargetDatabasePeerTargetDatabaseDetailArgsDict']]]] peer_target_database_details: The details of the database to be registered as a peer target database.
        :param pulumi.Input[Union['TargetDatabaseTlsConfigArgs', 'TargetDatabaseTlsConfigArgsDict']] tls_config: (Updatable) The details required to establish a TLS enabled connection.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TargetDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Target Database resource in Oracle Cloud Infrastructure Data Safe service.

        Registers the specified database with Data Safe and creates a Data Safe target database in the Data Safe Console.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_target_database = oci.data_safe.TargetDatabase("test_target_database",
            compartment_id=compartment_id,
            database_details={
                "database_type": target_database_database_details_database_type,
                "infrastructure_type": target_database_database_details_infrastructure_type,
                "autonomous_database_id": test_autonomous_database["id"],
                "db_system_id": test_db_system["id"],
                "instance_id": test_instance["id"],
                "ip_addresses": target_database_database_details_ip_addresses,
                "listener_port": target_database_database_details_listener_port,
                "service_name": test_service["name"],
                "vm_cluster_id": test_vm_cluster["id"],
            },
            connection_option={
                "connection_type": target_database_connection_option_connection_type,
                "datasafe_private_endpoint_id": test_private_endpoint["id"],
                "on_prem_connector_id": test_on_prem_connector["id"],
            },
            credentials={
                "password": target_database_credentials_password,
                "user_name": test_user["name"],
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=target_database_description,
            display_name=target_database_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            peer_target_database_details=[{
                "database_details": {
                    "database_type": target_database_peer_target_database_details_database_details_database_type,
                    "infrastructure_type": target_database_peer_target_database_details_database_details_infrastructure_type,
                    "autonomous_database_id": test_autonomous_database["id"],
                    "db_system_id": test_db_system["id"],
                    "instance_id": test_instance["id"],
                    "ip_addresses": target_database_peer_target_database_details_database_details_ip_addresses,
                    "listener_port": target_database_peer_target_database_details_database_details_listener_port,
                    "service_name": test_service["name"],
                    "vm_cluster_id": test_vm_cluster["id"],
                },
                "dataguard_association_id": test_association["id"],
                "description": target_database_peer_target_database_details_description,
                "display_name": target_database_peer_target_database_details_display_name,
                "tls_config": {
                    "status": target_database_peer_target_database_details_tls_config_status,
                    "certificate_store_type": target_database_peer_target_database_details_tls_config_certificate_store_type,
                    "key_store_content": target_database_peer_target_database_details_tls_config_key_store_content,
                    "store_password": target_database_peer_target_database_details_tls_config_store_password,
                    "trust_store_content": target_database_peer_target_database_details_tls_config_trust_store_content,
                },
            }],
            tls_config={
                "status": target_database_tls_config_status,
                "certificate_store_type": target_database_tls_config_certificate_store_type,
                "key_store_content": target_database_tls_config_key_store_content,
                "store_password": target_database_tls_config_store_password,
                "trust_store_content": target_database_tls_config_trust_store_content,
            })
        ```

        ## Import

        TargetDatabases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/targetDatabase:TargetDatabase test_target_database "id"
        ```

        :param str resource_name: The name of the resource.
        :param TargetDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TargetDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connection_option: Optional[pulumi.Input[Union['TargetDatabaseConnectionOptionArgs', 'TargetDatabaseConnectionOptionArgsDict']]] = None,
                 credentials: Optional[pulumi.Input[Union['TargetDatabaseCredentialsArgs', 'TargetDatabaseCredentialsArgsDict']]] = None,
                 database_details: Optional[pulumi.Input[Union['TargetDatabaseDatabaseDetailsArgs', 'TargetDatabaseDatabaseDetailsArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 peer_target_database_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetDatabasePeerTargetDatabaseDetailArgs', 'TargetDatabasePeerTargetDatabaseDetailArgsDict']]]]] = None,
                 tls_config: Optional[pulumi.Input[Union['TargetDatabaseTlsConfigArgs', 'TargetDatabaseTlsConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TargetDatabaseArgs.__new__(TargetDatabaseArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["connection_option"] = connection_option
            __props__.__dict__["credentials"] = credentials
            if database_details is None and not opts.urn:
                raise TypeError("Missing required property 'database_details'")
            __props__.__dict__["database_details"] = database_details
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["peer_target_database_details"] = peer_target_database_details
            __props__.__dict__["tls_config"] = tls_config
            __props__.__dict__["associated_resource_ids"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["peer_target_databases"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(TargetDatabase, __self__).__init__(
            'oci:DataSafe/targetDatabase:TargetDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associated_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            connection_option: Optional[pulumi.Input[Union['TargetDatabaseConnectionOptionArgs', 'TargetDatabaseConnectionOptionArgsDict']]] = None,
            credentials: Optional[pulumi.Input[Union['TargetDatabaseCredentialsArgs', 'TargetDatabaseCredentialsArgsDict']]] = None,
            database_details: Optional[pulumi.Input[Union['TargetDatabaseDatabaseDetailsArgs', 'TargetDatabaseDatabaseDetailsArgsDict']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            peer_target_database_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetDatabasePeerTargetDatabaseDetailArgs', 'TargetDatabasePeerTargetDatabaseDetailArgsDict']]]]] = None,
            peer_target_databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TargetDatabasePeerTargetDatabaseArgs', 'TargetDatabasePeerTargetDatabaseArgsDict']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            tls_config: Optional[pulumi.Input[Union['TargetDatabaseTlsConfigArgs', 'TargetDatabaseTlsConfigArgsDict']]] = None) -> 'TargetDatabase':
        """
        Get an existing TargetDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] associated_resource_ids: The OCIDs of associated resources like database, Data Safe private endpoint etc.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment in which to create the Data Safe target database.
        :param pulumi.Input[Union['TargetDatabaseConnectionOptionArgs', 'TargetDatabaseConnectionOptionArgsDict']] connection_option: (Updatable) Types of connection supported by Data Safe.
        :param pulumi.Input[Union['TargetDatabaseCredentialsArgs', 'TargetDatabaseCredentialsArgsDict']] credentials: (Updatable) The database credentials required for Data Safe to connect to the database.
        :param pulumi.Input[Union['TargetDatabaseDatabaseDetailsArgs', 'TargetDatabaseDatabaseDetailsArgsDict']] database_details: (Updatable) Details of the database for the registration in Data Safe.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the target database in Data Safe.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the target database in Data Safe. The name is modifiable and does not need to be unique.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the peer target database in Data Safe.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TargetDatabasePeerTargetDatabaseDetailArgs', 'TargetDatabasePeerTargetDatabaseDetailArgsDict']]]] peer_target_database_details: The details of the database to be registered as a peer target database.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TargetDatabasePeerTargetDatabaseArgs', 'TargetDatabasePeerTargetDatabaseArgsDict']]]] peer_target_databases: The OCIDs of associated resources like Database, Data Safe private endpoint etc.
        :param pulumi.Input[str] state: The current state of the target database in Data Safe.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the database was registered in Data Safe and created as a target database in Data Safe.
        :param pulumi.Input[str] time_updated: The date and time of the target database update in Data Safe.
        :param pulumi.Input[Union['TargetDatabaseTlsConfigArgs', 'TargetDatabaseTlsConfigArgsDict']] tls_config: (Updatable) The details required to establish a TLS enabled connection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TargetDatabaseState.__new__(_TargetDatabaseState)

        __props__.__dict__["associated_resource_ids"] = associated_resource_ids
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_option"] = connection_option
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["database_details"] = database_details
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["peer_target_database_details"] = peer_target_database_details
        __props__.__dict__["peer_target_databases"] = peer_target_databases
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["tls_config"] = tls_config
        return TargetDatabase(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associatedResourceIds")
    def associated_resource_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The OCIDs of associated resources like database, Data Safe private endpoint etc.
        """
        return pulumi.get(self, "associated_resource_ids")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment in which to create the Data Safe target database.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionOption")
    def connection_option(self) -> pulumi.Output['outputs.TargetDatabaseConnectionOption']:
        """
        (Updatable) Types of connection supported by Data Safe.
        """
        return pulumi.get(self, "connection_option")

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Output['outputs.TargetDatabaseCredentials']:
        """
        (Updatable) The database credentials required for Data Safe to connect to the database.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="databaseDetails")
    def database_details(self) -> pulumi.Output['outputs.TargetDatabaseDatabaseDetails']:
        """
        (Updatable) Details of the database for the registration in Data Safe.
        """
        return pulumi.get(self, "database_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description of the target database in Data Safe.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The display name of the target database in Data Safe. The name is modifiable and does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Details about the current state of the peer target database in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="peerTargetDatabaseDetails")
    def peer_target_database_details(self) -> pulumi.Output[Sequence['outputs.TargetDatabasePeerTargetDatabaseDetail']]:
        """
        The details of the database to be registered as a peer target database.
        """
        return pulumi.get(self, "peer_target_database_details")

    @property
    @pulumi.getter(name="peerTargetDatabases")
    def peer_target_databases(self) -> pulumi.Output[Sequence['outputs.TargetDatabasePeerTargetDatabase']]:
        """
        The OCIDs of associated resources like Database, Data Safe private endpoint etc.
        """
        return pulumi.get(self, "peer_target_databases")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the target database in Data Safe.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the database was registered in Data Safe and created as a target database in Data Safe.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time of the target database update in Data Safe.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> pulumi.Output['outputs.TargetDatabaseTlsConfig']:
        """
        (Updatable) The details required to establish a TLS enabled connection.
        """
        return pulumi.get(self, "tls_config")

