# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeploymentArgs', 'Deployment']

@pulumi.input_type
class DeploymentArgs:
    def __init__(__self__, *,
                 deploy_pipeline_id: pulumi.Input[str],
                 deployment_type: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deploy_artifact_override_arguments: Optional[pulumi.Input['DeploymentDeployArtifactOverrideArgumentsArgs']] = None,
                 deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 deploy_stage_override_arguments: Optional[pulumi.Input['DeploymentDeployStageOverrideArgumentsArgs']] = None,
                 deployment_arguments: Optional[pulumi.Input['DeploymentDeploymentArgumentsArgs']] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 previous_deployment_id: Optional[pulumi.Input[str]] = None,
                 trigger_new_devops_deployment: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Deployment resource.
        :param pulumi.Input[str] deploy_pipeline_id: The OCID of a pipeline.
        :param pulumi.Input[str] deployment_type: (Updatable) Specifies type for this deployment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input['DeploymentDeployArtifactOverrideArgumentsArgs'] deploy_artifact_override_arguments: Specifies the list of artifact override arguments at the time of deployment.
        :param pulumi.Input[str] deploy_stage_id: Specifies the OCID of the stage to be redeployed.
        :param pulumi.Input['DeploymentDeployStageOverrideArgumentsArgs'] deploy_stage_override_arguments: Specifies the list of arguments to be overriden per Stage at the time of deployment.
        :param pulumi.Input['DeploymentDeploymentArgumentsArgs'] deployment_arguments: Specifies list of arguments passed along with the deployment.
        :param pulumi.Input[str] display_name: (Updatable) Deployment display name. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] previous_deployment_id: Specifies the OCID of the previous deployment to be redeployed.
        :param pulumi.Input[bool] trigger_new_devops_deployment: A boolean specifying if a new deployment should be created on every apply. As long as this value is set to true in the config, every apply will trigger a new deployment to be created. The existing deployment resource will be replaced with the new one in the state file (deployment resources are never deleted, they persist as a store of records, but your state file will only track the latest one created with this resource block). 
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. Additionally, while `trigger_new_devops_deployment`
               is set true each apply will force the destruction and recreation of the resource with the new property values.
        """
        pulumi.set(__self__, "deploy_pipeline_id", deploy_pipeline_id)
        pulumi.set(__self__, "deployment_type", deployment_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deploy_artifact_override_arguments is not None:
            pulumi.set(__self__, "deploy_artifact_override_arguments", deploy_artifact_override_arguments)
        if deploy_stage_id is not None:
            pulumi.set(__self__, "deploy_stage_id", deploy_stage_id)
        if deploy_stage_override_arguments is not None:
            pulumi.set(__self__, "deploy_stage_override_arguments", deploy_stage_override_arguments)
        if deployment_arguments is not None:
            pulumi.set(__self__, "deployment_arguments", deployment_arguments)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if previous_deployment_id is not None:
            pulumi.set(__self__, "previous_deployment_id", previous_deployment_id)
        if trigger_new_devops_deployment is not None:
            pulumi.set(__self__, "trigger_new_devops_deployment", trigger_new_devops_deployment)

    @property
    @pulumi.getter(name="deployPipelineId")
    def deploy_pipeline_id(self) -> pulumi.Input[str]:
        """
        The OCID of a pipeline.
        """
        return pulumi.get(self, "deploy_pipeline_id")

    @deploy_pipeline_id.setter
    def deploy_pipeline_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "deploy_pipeline_id", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Specifies type for this deployment.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deployArtifactOverrideArguments")
    def deploy_artifact_override_arguments(self) -> Optional[pulumi.Input['DeploymentDeployArtifactOverrideArgumentsArgs']]:
        """
        Specifies the list of artifact override arguments at the time of deployment.
        """
        return pulumi.get(self, "deploy_artifact_override_arguments")

    @deploy_artifact_override_arguments.setter
    def deploy_artifact_override_arguments(self, value: Optional[pulumi.Input['DeploymentDeployArtifactOverrideArgumentsArgs']]):
        pulumi.set(self, "deploy_artifact_override_arguments", value)

    @property
    @pulumi.getter(name="deployStageId")
    def deploy_stage_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the OCID of the stage to be redeployed.
        """
        return pulumi.get(self, "deploy_stage_id")

    @deploy_stage_id.setter
    def deploy_stage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deploy_stage_id", value)

    @property
    @pulumi.getter(name="deployStageOverrideArguments")
    def deploy_stage_override_arguments(self) -> Optional[pulumi.Input['DeploymentDeployStageOverrideArgumentsArgs']]:
        """
        Specifies the list of arguments to be overriden per Stage at the time of deployment.
        """
        return pulumi.get(self, "deploy_stage_override_arguments")

    @deploy_stage_override_arguments.setter
    def deploy_stage_override_arguments(self, value: Optional[pulumi.Input['DeploymentDeployStageOverrideArgumentsArgs']]):
        pulumi.set(self, "deploy_stage_override_arguments", value)

    @property
    @pulumi.getter(name="deploymentArguments")
    def deployment_arguments(self) -> Optional[pulumi.Input['DeploymentDeploymentArgumentsArgs']]:
        """
        Specifies list of arguments passed along with the deployment.
        """
        return pulumi.get(self, "deployment_arguments")

    @deployment_arguments.setter
    def deployment_arguments(self, value: Optional[pulumi.Input['DeploymentDeploymentArgumentsArgs']]):
        pulumi.set(self, "deployment_arguments", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Deployment display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="previousDeploymentId")
    def previous_deployment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the OCID of the previous deployment to be redeployed.
        """
        return pulumi.get(self, "previous_deployment_id")

    @previous_deployment_id.setter
    def previous_deployment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "previous_deployment_id", value)

    @property
    @pulumi.getter(name="triggerNewDevopsDeployment")
    def trigger_new_devops_deployment(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean specifying if a new deployment should be created on every apply. As long as this value is set to true in the config, every apply will trigger a new deployment to be created. The existing deployment resource will be replaced with the new one in the state file (deployment resources are never deleted, they persist as a store of records, but your state file will only track the latest one created with this resource block). 

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. Additionally, while `trigger_new_devops_deployment`
        is set true each apply will force the destruction and recreation of the resource with the new property values.
        """
        return pulumi.get(self, "trigger_new_devops_deployment")

    @trigger_new_devops_deployment.setter
    def trigger_new_devops_deployment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "trigger_new_devops_deployment", value)


@pulumi.input_type
class _DeploymentState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deploy_artifact_override_arguments: Optional[pulumi.Input['DeploymentDeployArtifactOverrideArgumentsArgs']] = None,
                 deploy_pipeline_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentDeployPipelineArtifactArgs']]]] = None,
                 deploy_pipeline_environments: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentDeployPipelineEnvironmentArgs']]]] = None,
                 deploy_pipeline_id: Optional[pulumi.Input[str]] = None,
                 deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 deploy_stage_override_arguments: Optional[pulumi.Input['DeploymentDeployStageOverrideArgumentsArgs']] = None,
                 deployment_arguments: Optional[pulumi.Input['DeploymentDeploymentArgumentsArgs']] = None,
                 deployment_execution_progresses: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentDeploymentExecutionProgressArgs']]]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 previous_deployment_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 trigger_new_devops_deployment: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Deployment resources.
        :param pulumi.Input[str] compartment_id: The OCID of a compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input['DeploymentDeployArtifactOverrideArgumentsArgs'] deploy_artifact_override_arguments: Specifies the list of artifact override arguments at the time of deployment.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentDeployPipelineArtifactArgs']]] deploy_pipeline_artifacts: List of all artifacts used in the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentDeployPipelineEnvironmentArgs']]] deploy_pipeline_environments: List of all environments used in the pipeline.
        :param pulumi.Input[str] deploy_pipeline_id: The OCID of a pipeline.
        :param pulumi.Input[str] deploy_stage_id: Specifies the OCID of the stage to be redeployed.
        :param pulumi.Input['DeploymentDeployStageOverrideArgumentsArgs'] deploy_stage_override_arguments: Specifies the list of arguments to be overriden per Stage at the time of deployment.
        :param pulumi.Input['DeploymentDeploymentArgumentsArgs'] deployment_arguments: Specifies list of arguments passed along with the deployment.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentDeploymentExecutionProgressArgs']]] deployment_execution_progresses: The execution progress details of a deployment.
        :param pulumi.Input[str] deployment_type: (Updatable) Specifies type for this deployment.
        :param pulumi.Input[str] display_name: (Updatable) Deployment display name. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] previous_deployment_id: Specifies the OCID of the previous deployment to be redeployed.
        :param pulumi.Input[str] project_id: The OCID of a project.
        :param pulumi.Input[str] state: The current state of the deployment.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: Time the deployment was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[str] time_updated: Time the deployment was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[bool] trigger_new_devops_deployment: A boolean specifying if a new deployment should be created on every apply. As long as this value is set to true in the config, every apply will trigger a new deployment to be created. The existing deployment resource will be replaced with the new one in the state file (deployment resources are never deleted, they persist as a store of records, but your state file will only track the latest one created with this resource block). 
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. Additionally, while `trigger_new_devops_deployment`
               is set true each apply will force the destruction and recreation of the resource with the new property values.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deploy_artifact_override_arguments is not None:
            pulumi.set(__self__, "deploy_artifact_override_arguments", deploy_artifact_override_arguments)
        if deploy_pipeline_artifacts is not None:
            pulumi.set(__self__, "deploy_pipeline_artifacts", deploy_pipeline_artifacts)
        if deploy_pipeline_environments is not None:
            pulumi.set(__self__, "deploy_pipeline_environments", deploy_pipeline_environments)
        if deploy_pipeline_id is not None:
            pulumi.set(__self__, "deploy_pipeline_id", deploy_pipeline_id)
        if deploy_stage_id is not None:
            pulumi.set(__self__, "deploy_stage_id", deploy_stage_id)
        if deploy_stage_override_arguments is not None:
            pulumi.set(__self__, "deploy_stage_override_arguments", deploy_stage_override_arguments)
        if deployment_arguments is not None:
            pulumi.set(__self__, "deployment_arguments", deployment_arguments)
        if deployment_execution_progresses is not None:
            pulumi.set(__self__, "deployment_execution_progresses", deployment_execution_progresses)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if previous_deployment_id is not None:
            pulumi.set(__self__, "previous_deployment_id", previous_deployment_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if trigger_new_devops_deployment is not None:
            pulumi.set(__self__, "trigger_new_devops_deployment", trigger_new_devops_deployment)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of a compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deployArtifactOverrideArguments")
    def deploy_artifact_override_arguments(self) -> Optional[pulumi.Input['DeploymentDeployArtifactOverrideArgumentsArgs']]:
        """
        Specifies the list of artifact override arguments at the time of deployment.
        """
        return pulumi.get(self, "deploy_artifact_override_arguments")

    @deploy_artifact_override_arguments.setter
    def deploy_artifact_override_arguments(self, value: Optional[pulumi.Input['DeploymentDeployArtifactOverrideArgumentsArgs']]):
        pulumi.set(self, "deploy_artifact_override_arguments", value)

    @property
    @pulumi.getter(name="deployPipelineArtifacts")
    def deploy_pipeline_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentDeployPipelineArtifactArgs']]]]:
        """
        List of all artifacts used in the pipeline.
        """
        return pulumi.get(self, "deploy_pipeline_artifacts")

    @deploy_pipeline_artifacts.setter
    def deploy_pipeline_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentDeployPipelineArtifactArgs']]]]):
        pulumi.set(self, "deploy_pipeline_artifacts", value)

    @property
    @pulumi.getter(name="deployPipelineEnvironments")
    def deploy_pipeline_environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentDeployPipelineEnvironmentArgs']]]]:
        """
        List of all environments used in the pipeline.
        """
        return pulumi.get(self, "deploy_pipeline_environments")

    @deploy_pipeline_environments.setter
    def deploy_pipeline_environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentDeployPipelineEnvironmentArgs']]]]):
        pulumi.set(self, "deploy_pipeline_environments", value)

    @property
    @pulumi.getter(name="deployPipelineId")
    def deploy_pipeline_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of a pipeline.
        """
        return pulumi.get(self, "deploy_pipeline_id")

    @deploy_pipeline_id.setter
    def deploy_pipeline_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deploy_pipeline_id", value)

    @property
    @pulumi.getter(name="deployStageId")
    def deploy_stage_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the OCID of the stage to be redeployed.
        """
        return pulumi.get(self, "deploy_stage_id")

    @deploy_stage_id.setter
    def deploy_stage_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deploy_stage_id", value)

    @property
    @pulumi.getter(name="deployStageOverrideArguments")
    def deploy_stage_override_arguments(self) -> Optional[pulumi.Input['DeploymentDeployStageOverrideArgumentsArgs']]:
        """
        Specifies the list of arguments to be overriden per Stage at the time of deployment.
        """
        return pulumi.get(self, "deploy_stage_override_arguments")

    @deploy_stage_override_arguments.setter
    def deploy_stage_override_arguments(self, value: Optional[pulumi.Input['DeploymentDeployStageOverrideArgumentsArgs']]):
        pulumi.set(self, "deploy_stage_override_arguments", value)

    @property
    @pulumi.getter(name="deploymentArguments")
    def deployment_arguments(self) -> Optional[pulumi.Input['DeploymentDeploymentArgumentsArgs']]:
        """
        Specifies list of arguments passed along with the deployment.
        """
        return pulumi.get(self, "deployment_arguments")

    @deployment_arguments.setter
    def deployment_arguments(self, value: Optional[pulumi.Input['DeploymentDeploymentArgumentsArgs']]):
        pulumi.set(self, "deployment_arguments", value)

    @property
    @pulumi.getter(name="deploymentExecutionProgresses")
    def deployment_execution_progresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentDeploymentExecutionProgressArgs']]]]:
        """
        The execution progress details of a deployment.
        """
        return pulumi.get(self, "deployment_execution_progresses")

    @deployment_execution_progresses.setter
    def deployment_execution_progresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentDeploymentExecutionProgressArgs']]]]):
        pulumi.set(self, "deployment_execution_progresses", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies type for this deployment.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Deployment display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="previousDeploymentId")
    def previous_deployment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the OCID of the previous deployment to be redeployed.
        """
        return pulumi.get(self, "previous_deployment_id")

    @previous_deployment_id.setter
    def previous_deployment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "previous_deployment_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of a project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the deployment.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Time the deployment was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        Time the deployment was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="triggerNewDevopsDeployment")
    def trigger_new_devops_deployment(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean specifying if a new deployment should be created on every apply. As long as this value is set to true in the config, every apply will trigger a new deployment to be created. The existing deployment resource will be replaced with the new one in the state file (deployment resources are never deleted, they persist as a store of records, but your state file will only track the latest one created with this resource block). 

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. Additionally, while `trigger_new_devops_deployment`
        is set true each apply will force the destruction and recreation of the resource with the new property values.
        """
        return pulumi.get(self, "trigger_new_devops_deployment")

    @trigger_new_devops_deployment.setter
    def trigger_new_devops_deployment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "trigger_new_devops_deployment", value)


class Deployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deploy_artifact_override_arguments: Optional[pulumi.Input[Union['DeploymentDeployArtifactOverrideArgumentsArgs', 'DeploymentDeployArtifactOverrideArgumentsArgsDict']]] = None,
                 deploy_pipeline_id: Optional[pulumi.Input[str]] = None,
                 deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 deploy_stage_override_arguments: Optional[pulumi.Input[Union['DeploymentDeployStageOverrideArgumentsArgs', 'DeploymentDeployStageOverrideArgumentsArgsDict']]] = None,
                 deployment_arguments: Optional[pulumi.Input[Union['DeploymentDeploymentArgumentsArgs', 'DeploymentDeploymentArgumentsArgsDict']]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 previous_deployment_id: Optional[pulumi.Input[str]] = None,
                 trigger_new_devops_deployment: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        This resource provides the Deployment resource in Oracle Cloud Infrastructure Devops service.

        Creates a new deployment.

        ## Import

        Deployments can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/deployment:Deployment test_deployment "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Union['DeploymentDeployArtifactOverrideArgumentsArgs', 'DeploymentDeployArtifactOverrideArgumentsArgsDict']] deploy_artifact_override_arguments: Specifies the list of artifact override arguments at the time of deployment.
        :param pulumi.Input[str] deploy_pipeline_id: The OCID of a pipeline.
        :param pulumi.Input[str] deploy_stage_id: Specifies the OCID of the stage to be redeployed.
        :param pulumi.Input[Union['DeploymentDeployStageOverrideArgumentsArgs', 'DeploymentDeployStageOverrideArgumentsArgsDict']] deploy_stage_override_arguments: Specifies the list of arguments to be overriden per Stage at the time of deployment.
        :param pulumi.Input[Union['DeploymentDeploymentArgumentsArgs', 'DeploymentDeploymentArgumentsArgsDict']] deployment_arguments: Specifies list of arguments passed along with the deployment.
        :param pulumi.Input[str] deployment_type: (Updatable) Specifies type for this deployment.
        :param pulumi.Input[str] display_name: (Updatable) Deployment display name. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] previous_deployment_id: Specifies the OCID of the previous deployment to be redeployed.
        :param pulumi.Input[bool] trigger_new_devops_deployment: A boolean specifying if a new deployment should be created on every apply. As long as this value is set to true in the config, every apply will trigger a new deployment to be created. The existing deployment resource will be replaced with the new one in the state file (deployment resources are never deleted, they persist as a store of records, but your state file will only track the latest one created with this resource block). 
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. Additionally, while `trigger_new_devops_deployment`
               is set true each apply will force the destruction and recreation of the resource with the new property values.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Deployment resource in Oracle Cloud Infrastructure Devops service.

        Creates a new deployment.

        ## Import

        Deployments can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/deployment:Deployment test_deployment "id"
        ```

        :param str resource_name: The name of the resource.
        :param DeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deploy_artifact_override_arguments: Optional[pulumi.Input[Union['DeploymentDeployArtifactOverrideArgumentsArgs', 'DeploymentDeployArtifactOverrideArgumentsArgsDict']]] = None,
                 deploy_pipeline_id: Optional[pulumi.Input[str]] = None,
                 deploy_stage_id: Optional[pulumi.Input[str]] = None,
                 deploy_stage_override_arguments: Optional[pulumi.Input[Union['DeploymentDeployStageOverrideArgumentsArgs', 'DeploymentDeployStageOverrideArgumentsArgsDict']]] = None,
                 deployment_arguments: Optional[pulumi.Input[Union['DeploymentDeploymentArgumentsArgs', 'DeploymentDeploymentArgumentsArgsDict']]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 previous_deployment_id: Optional[pulumi.Input[str]] = None,
                 trigger_new_devops_deployment: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentArgs.__new__(DeploymentArgs)

            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["deploy_artifact_override_arguments"] = deploy_artifact_override_arguments
            if deploy_pipeline_id is None and not opts.urn:
                raise TypeError("Missing required property 'deploy_pipeline_id'")
            __props__.__dict__["deploy_pipeline_id"] = deploy_pipeline_id
            __props__.__dict__["deploy_stage_id"] = deploy_stage_id
            __props__.__dict__["deploy_stage_override_arguments"] = deploy_stage_override_arguments
            __props__.__dict__["deployment_arguments"] = deployment_arguments
            if deployment_type is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_type'")
            __props__.__dict__["deployment_type"] = deployment_type
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["previous_deployment_id"] = previous_deployment_id
            __props__.__dict__["trigger_new_devops_deployment"] = trigger_new_devops_deployment
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["deploy_pipeline_artifacts"] = None
            __props__.__dict__["deploy_pipeline_environments"] = None
            __props__.__dict__["deployment_execution_progresses"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["project_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Deployment, __self__).__init__(
            'oci:DevOps/deployment:Deployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            deploy_artifact_override_arguments: Optional[pulumi.Input[Union['DeploymentDeployArtifactOverrideArgumentsArgs', 'DeploymentDeployArtifactOverrideArgumentsArgsDict']]] = None,
            deploy_pipeline_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentDeployPipelineArtifactArgs', 'DeploymentDeployPipelineArtifactArgsDict']]]]] = None,
            deploy_pipeline_environments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentDeployPipelineEnvironmentArgs', 'DeploymentDeployPipelineEnvironmentArgsDict']]]]] = None,
            deploy_pipeline_id: Optional[pulumi.Input[str]] = None,
            deploy_stage_id: Optional[pulumi.Input[str]] = None,
            deploy_stage_override_arguments: Optional[pulumi.Input[Union['DeploymentDeployStageOverrideArgumentsArgs', 'DeploymentDeployStageOverrideArgumentsArgsDict']]] = None,
            deployment_arguments: Optional[pulumi.Input[Union['DeploymentDeploymentArgumentsArgs', 'DeploymentDeploymentArgumentsArgsDict']]] = None,
            deployment_execution_progresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentDeploymentExecutionProgressArgs', 'DeploymentDeploymentExecutionProgressArgsDict']]]]] = None,
            deployment_type: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            previous_deployment_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            trigger_new_devops_deployment: Optional[pulumi.Input[bool]] = None) -> 'Deployment':
        """
        Get an existing Deployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of a compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Union['DeploymentDeployArtifactOverrideArgumentsArgs', 'DeploymentDeployArtifactOverrideArgumentsArgsDict']] deploy_artifact_override_arguments: Specifies the list of artifact override arguments at the time of deployment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentDeployPipelineArtifactArgs', 'DeploymentDeployPipelineArtifactArgsDict']]]] deploy_pipeline_artifacts: List of all artifacts used in the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentDeployPipelineEnvironmentArgs', 'DeploymentDeployPipelineEnvironmentArgsDict']]]] deploy_pipeline_environments: List of all environments used in the pipeline.
        :param pulumi.Input[str] deploy_pipeline_id: The OCID of a pipeline.
        :param pulumi.Input[str] deploy_stage_id: Specifies the OCID of the stage to be redeployed.
        :param pulumi.Input[Union['DeploymentDeployStageOverrideArgumentsArgs', 'DeploymentDeployStageOverrideArgumentsArgsDict']] deploy_stage_override_arguments: Specifies the list of arguments to be overriden per Stage at the time of deployment.
        :param pulumi.Input[Union['DeploymentDeploymentArgumentsArgs', 'DeploymentDeploymentArgumentsArgsDict']] deployment_arguments: Specifies list of arguments passed along with the deployment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentDeploymentExecutionProgressArgs', 'DeploymentDeploymentExecutionProgressArgsDict']]]] deployment_execution_progresses: The execution progress details of a deployment.
        :param pulumi.Input[str] deployment_type: (Updatable) Specifies type for this deployment.
        :param pulumi.Input[str] display_name: (Updatable) Deployment display name. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] previous_deployment_id: Specifies the OCID of the previous deployment to be redeployed.
        :param pulumi.Input[str] project_id: The OCID of a project.
        :param pulumi.Input[str] state: The current state of the deployment.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: Time the deployment was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[str] time_updated: Time the deployment was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[bool] trigger_new_devops_deployment: A boolean specifying if a new deployment should be created on every apply. As long as this value is set to true in the config, every apply will trigger a new deployment to be created. The existing deployment resource will be replaced with the new one in the state file (deployment resources are never deleted, they persist as a store of records, but your state file will only track the latest one created with this resource block). 
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. Additionally, while `trigger_new_devops_deployment`
               is set true each apply will force the destruction and recreation of the resource with the new property values.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeploymentState.__new__(_DeploymentState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["deploy_artifact_override_arguments"] = deploy_artifact_override_arguments
        __props__.__dict__["deploy_pipeline_artifacts"] = deploy_pipeline_artifacts
        __props__.__dict__["deploy_pipeline_environments"] = deploy_pipeline_environments
        __props__.__dict__["deploy_pipeline_id"] = deploy_pipeline_id
        __props__.__dict__["deploy_stage_id"] = deploy_stage_id
        __props__.__dict__["deploy_stage_override_arguments"] = deploy_stage_override_arguments
        __props__.__dict__["deployment_arguments"] = deployment_arguments
        __props__.__dict__["deployment_execution_progresses"] = deployment_execution_progresses
        __props__.__dict__["deployment_type"] = deployment_type
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["previous_deployment_id"] = previous_deployment_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["trigger_new_devops_deployment"] = trigger_new_devops_deployment
        return Deployment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of a compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deployArtifactOverrideArguments")
    def deploy_artifact_override_arguments(self) -> pulumi.Output['outputs.DeploymentDeployArtifactOverrideArguments']:
        """
        Specifies the list of artifact override arguments at the time of deployment.
        """
        return pulumi.get(self, "deploy_artifact_override_arguments")

    @property
    @pulumi.getter(name="deployPipelineArtifacts")
    def deploy_pipeline_artifacts(self) -> pulumi.Output[Sequence['outputs.DeploymentDeployPipelineArtifact']]:
        """
        List of all artifacts used in the pipeline.
        """
        return pulumi.get(self, "deploy_pipeline_artifacts")

    @property
    @pulumi.getter(name="deployPipelineEnvironments")
    def deploy_pipeline_environments(self) -> pulumi.Output[Sequence['outputs.DeploymentDeployPipelineEnvironment']]:
        """
        List of all environments used in the pipeline.
        """
        return pulumi.get(self, "deploy_pipeline_environments")

    @property
    @pulumi.getter(name="deployPipelineId")
    def deploy_pipeline_id(self) -> pulumi.Output[str]:
        """
        The OCID of a pipeline.
        """
        return pulumi.get(self, "deploy_pipeline_id")

    @property
    @pulumi.getter(name="deployStageId")
    def deploy_stage_id(self) -> pulumi.Output[str]:
        """
        Specifies the OCID of the stage to be redeployed.
        """
        return pulumi.get(self, "deploy_stage_id")

    @property
    @pulumi.getter(name="deployStageOverrideArguments")
    def deploy_stage_override_arguments(self) -> pulumi.Output['outputs.DeploymentDeployStageOverrideArguments']:
        """
        Specifies the list of arguments to be overriden per Stage at the time of deployment.
        """
        return pulumi.get(self, "deploy_stage_override_arguments")

    @property
    @pulumi.getter(name="deploymentArguments")
    def deployment_arguments(self) -> pulumi.Output['outputs.DeploymentDeploymentArguments']:
        """
        Specifies list of arguments passed along with the deployment.
        """
        return pulumi.get(self, "deployment_arguments")

    @property
    @pulumi.getter(name="deploymentExecutionProgresses")
    def deployment_execution_progresses(self) -> pulumi.Output[Sequence['outputs.DeploymentDeploymentExecutionProgress']]:
        """
        The execution progress details of a deployment.
        """
        return pulumi.get(self, "deployment_execution_progresses")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Output[str]:
        """
        (Updatable) Specifies type for this deployment.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Deployment display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="previousDeploymentId")
    def previous_deployment_id(self) -> pulumi.Output[str]:
        """
        Specifies the OCID of the previous deployment to be redeployed.
        """
        return pulumi.get(self, "previous_deployment_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The OCID of a project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the deployment.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        Time the deployment was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        Time the deployment was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="triggerNewDevopsDeployment")
    def trigger_new_devops_deployment(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean specifying if a new deployment should be created on every apply. As long as this value is set to true in the config, every apply will trigger a new deployment to be created. The existing deployment resource will be replaced with the new one in the state file (deployment resources are never deleted, they persist as a store of records, but your state file will only track the latest one created with this resource block). 

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. Additionally, while `trigger_new_devops_deployment`
        is set true each apply will force the destruction and recreation of the resource with the new property values.
        """
        return pulumi.get(self, "trigger_new_devops_deployment")

