# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDeploymentUpgradeResult',
    'AwaitableGetDeploymentUpgradeResult',
    'get_deployment_upgrade',
    'get_deployment_upgrade_output',
]

@pulumi.output_type
class GetDeploymentUpgradeResult:
    """
    A collection of values returned by getDeploymentUpgrade.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, deployment_id=None, deployment_upgrade_id=None, deployment_upgrade_type=None, description=None, display_name=None, freeform_tags=None, id=None, is_cancel_allowed=None, is_reschedule_allowed=None, is_rollback_allowed=None, is_security_fix=None, is_snoozed=None, lifecycle_details=None, lifecycle_sub_state=None, ogg_version=None, previous_ogg_version=None, release_type=None, state=None, system_tags=None, time_created=None, time_finished=None, time_ogg_version_supported_until=None, time_released=None, time_schedule=None, time_schedule_max=None, time_snoozed_until=None, time_started=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if deployment_id and not isinstance(deployment_id, str):
            raise TypeError("Expected argument 'deployment_id' to be a str")
        pulumi.set(__self__, "deployment_id", deployment_id)
        if deployment_upgrade_id and not isinstance(deployment_upgrade_id, str):
            raise TypeError("Expected argument 'deployment_upgrade_id' to be a str")
        pulumi.set(__self__, "deployment_upgrade_id", deployment_upgrade_id)
        if deployment_upgrade_type and not isinstance(deployment_upgrade_type, str):
            raise TypeError("Expected argument 'deployment_upgrade_type' to be a str")
        pulumi.set(__self__, "deployment_upgrade_type", deployment_upgrade_type)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_cancel_allowed and not isinstance(is_cancel_allowed, bool):
            raise TypeError("Expected argument 'is_cancel_allowed' to be a bool")
        pulumi.set(__self__, "is_cancel_allowed", is_cancel_allowed)
        if is_reschedule_allowed and not isinstance(is_reschedule_allowed, bool):
            raise TypeError("Expected argument 'is_reschedule_allowed' to be a bool")
        pulumi.set(__self__, "is_reschedule_allowed", is_reschedule_allowed)
        if is_rollback_allowed and not isinstance(is_rollback_allowed, bool):
            raise TypeError("Expected argument 'is_rollback_allowed' to be a bool")
        pulumi.set(__self__, "is_rollback_allowed", is_rollback_allowed)
        if is_security_fix and not isinstance(is_security_fix, bool):
            raise TypeError("Expected argument 'is_security_fix' to be a bool")
        pulumi.set(__self__, "is_security_fix", is_security_fix)
        if is_snoozed and not isinstance(is_snoozed, bool):
            raise TypeError("Expected argument 'is_snoozed' to be a bool")
        pulumi.set(__self__, "is_snoozed", is_snoozed)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_sub_state and not isinstance(lifecycle_sub_state, str):
            raise TypeError("Expected argument 'lifecycle_sub_state' to be a str")
        pulumi.set(__self__, "lifecycle_sub_state", lifecycle_sub_state)
        if ogg_version and not isinstance(ogg_version, str):
            raise TypeError("Expected argument 'ogg_version' to be a str")
        pulumi.set(__self__, "ogg_version", ogg_version)
        if previous_ogg_version and not isinstance(previous_ogg_version, str):
            raise TypeError("Expected argument 'previous_ogg_version' to be a str")
        pulumi.set(__self__, "previous_ogg_version", previous_ogg_version)
        if release_type and not isinstance(release_type, str):
            raise TypeError("Expected argument 'release_type' to be a str")
        pulumi.set(__self__, "release_type", release_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_finished and not isinstance(time_finished, str):
            raise TypeError("Expected argument 'time_finished' to be a str")
        pulumi.set(__self__, "time_finished", time_finished)
        if time_ogg_version_supported_until and not isinstance(time_ogg_version_supported_until, str):
            raise TypeError("Expected argument 'time_ogg_version_supported_until' to be a str")
        pulumi.set(__self__, "time_ogg_version_supported_until", time_ogg_version_supported_until)
        if time_released and not isinstance(time_released, str):
            raise TypeError("Expected argument 'time_released' to be a str")
        pulumi.set(__self__, "time_released", time_released)
        if time_schedule and not isinstance(time_schedule, str):
            raise TypeError("Expected argument 'time_schedule' to be a str")
        pulumi.set(__self__, "time_schedule", time_schedule)
        if time_schedule_max and not isinstance(time_schedule_max, str):
            raise TypeError("Expected argument 'time_schedule_max' to be a str")
        pulumi.set(__self__, "time_schedule_max", time_schedule_max)
        if time_snoozed_until and not isinstance(time_snoozed_until, str):
            raise TypeError("Expected argument 'time_snoozed_until' to be a str")
        pulumi.set(__self__, "time_snoozed_until", time_snoozed_until)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment being referenced.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="deploymentUpgradeId")
    def deployment_upgrade_id(self) -> str:
        return pulumi.get(self, "deployment_upgrade_id")

    @property
    @pulumi.getter(name="deploymentUpgradeType")
    def deployment_upgrade_type(self) -> str:
        """
        The type of the deployment upgrade: MANUAL or AUTOMATIC
        """
        return pulumi.get(self, "deployment_upgrade_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Metadata about this specific object.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCancelAllowed")
    def is_cancel_allowed(self) -> bool:
        """
        Indicates if cancel is allowed. Scheduled upgrade can be cancelled only if target version is not forced by service,  otherwise only reschedule allowed.
        """
        return pulumi.get(self, "is_cancel_allowed")

    @property
    @pulumi.getter(name="isRescheduleAllowed")
    def is_reschedule_allowed(self) -> bool:
        """
        Indicates if reschedule is allowed. Upgrade can be rescheduled postponed until the end of the service defined auto-upgrade period.
        """
        return pulumi.get(self, "is_reschedule_allowed")

    @property
    @pulumi.getter(name="isRollbackAllowed")
    def is_rollback_allowed(self) -> bool:
        """
        Indicates if rollback is allowed. In practice only the last upgrade can be rolled back.
        * Manual upgrade is allowed to rollback only until the old version isn't deprecated yet.
        * Automatic upgrade by default is not allowed, unless a serious issue does not justify.
        """
        return pulumi.get(self, "is_rollback_allowed")

    @property
    @pulumi.getter(name="isSecurityFix")
    def is_security_fix(self) -> bool:
        """
        Indicates if OGG release contains security fix.
        """
        return pulumi.get(self, "is_security_fix")

    @property
    @pulumi.getter(name="isSnoozed")
    def is_snoozed(self) -> bool:
        """
        Indicates if upgrade notifications are snoozed or not.
        """
        return pulumi.get(self, "is_snoozed")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> str:
        """
        Possible GGS lifecycle sub-states.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @property
    @pulumi.getter(name="oggVersion")
    def ogg_version(self) -> str:
        """
        Version of OGG
        """
        return pulumi.get(self, "ogg_version")

    @property
    @pulumi.getter(name="previousOggVersion")
    def previous_ogg_version(self) -> str:
        """
        Version of OGG
        """
        return pulumi.get(self, "previous_ogg_version")

    @property
    @pulumi.getter(name="releaseType")
    def release_type(self) -> str:
        """
        The type of release.
        """
        return pulumi.get(self, "release_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Possible lifecycle states.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> str:
        """
        The date and time the request was finished. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeOggVersionSupportedUntil")
    def time_ogg_version_supported_until(self) -> str:
        """
        The time until OGG version is supported. After this date has passed OGG version will not be available anymore. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_ogg_version_supported_until")

    @property
    @pulumi.getter(name="timeReleased")
    def time_released(self) -> str:
        """
        The time the resource was released. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_released")

    @property
    @pulumi.getter(name="timeSchedule")
    def time_schedule(self) -> str:
        """
        The time of upgrade schedule. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_schedule")

    @property
    @pulumi.getter(name="timeScheduleMax")
    def time_schedule_max(self) -> str:
        """
        Indicates the latest time until the deployment upgrade could be rescheduled. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_schedule_max")

    @property
    @pulumi.getter(name="timeSnoozedUntil")
    def time_snoozed_until(self) -> str:
        """
        The time the upgrade notifications are snoozed until. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_snoozed_until")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The date and time the request was started. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetDeploymentUpgradeResult(GetDeploymentUpgradeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeploymentUpgradeResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            deployment_id=self.deployment_id,
            deployment_upgrade_id=self.deployment_upgrade_id,
            deployment_upgrade_type=self.deployment_upgrade_type,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_cancel_allowed=self.is_cancel_allowed,
            is_reschedule_allowed=self.is_reschedule_allowed,
            is_rollback_allowed=self.is_rollback_allowed,
            is_security_fix=self.is_security_fix,
            is_snoozed=self.is_snoozed,
            lifecycle_details=self.lifecycle_details,
            lifecycle_sub_state=self.lifecycle_sub_state,
            ogg_version=self.ogg_version,
            previous_ogg_version=self.previous_ogg_version,
            release_type=self.release_type,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_finished=self.time_finished,
            time_ogg_version_supported_until=self.time_ogg_version_supported_until,
            time_released=self.time_released,
            time_schedule=self.time_schedule,
            time_schedule_max=self.time_schedule_max,
            time_snoozed_until=self.time_snoozed_until,
            time_started=self.time_started,
            time_updated=self.time_updated)


def get_deployment_upgrade(deployment_upgrade_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeploymentUpgradeResult:
    """
    This data source provides details about a specific Deployment Upgrade resource in Oracle Cloud Infrastructure Golden Gate service.

    Retrieves a deployment upgrade.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_deployment_upgrade = oci.GoldenGate.get_deployment_upgrade(deployment_upgrade_id=test_deployment_upgrade_oci_golden_gate_deployment_upgrade["id"])
    ```


    :param str deployment_upgrade_id: A unique Deployment Upgrade identifier.
    """
    __args__ = dict()
    __args__['deploymentUpgradeId'] = deployment_upgrade_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getDeploymentUpgrade:getDeploymentUpgrade', __args__, opts=opts, typ=GetDeploymentUpgradeResult).value

    return AwaitableGetDeploymentUpgradeResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        deployment_id=pulumi.get(__ret__, 'deployment_id'),
        deployment_upgrade_id=pulumi.get(__ret__, 'deployment_upgrade_id'),
        deployment_upgrade_type=pulumi.get(__ret__, 'deployment_upgrade_type'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_cancel_allowed=pulumi.get(__ret__, 'is_cancel_allowed'),
        is_reschedule_allowed=pulumi.get(__ret__, 'is_reschedule_allowed'),
        is_rollback_allowed=pulumi.get(__ret__, 'is_rollback_allowed'),
        is_security_fix=pulumi.get(__ret__, 'is_security_fix'),
        is_snoozed=pulumi.get(__ret__, 'is_snoozed'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        lifecycle_sub_state=pulumi.get(__ret__, 'lifecycle_sub_state'),
        ogg_version=pulumi.get(__ret__, 'ogg_version'),
        previous_ogg_version=pulumi.get(__ret__, 'previous_ogg_version'),
        release_type=pulumi.get(__ret__, 'release_type'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_finished=pulumi.get(__ret__, 'time_finished'),
        time_ogg_version_supported_until=pulumi.get(__ret__, 'time_ogg_version_supported_until'),
        time_released=pulumi.get(__ret__, 'time_released'),
        time_schedule=pulumi.get(__ret__, 'time_schedule'),
        time_schedule_max=pulumi.get(__ret__, 'time_schedule_max'),
        time_snoozed_until=pulumi.get(__ret__, 'time_snoozed_until'),
        time_started=pulumi.get(__ret__, 'time_started'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_deployment_upgrade)
def get_deployment_upgrade_output(deployment_upgrade_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDeploymentUpgradeResult]:
    """
    This data source provides details about a specific Deployment Upgrade resource in Oracle Cloud Infrastructure Golden Gate service.

    Retrieves a deployment upgrade.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_deployment_upgrade = oci.GoldenGate.get_deployment_upgrade(deployment_upgrade_id=test_deployment_upgrade_oci_golden_gate_deployment_upgrade["id"])
    ```


    :param str deployment_upgrade_id: A unique Deployment Upgrade identifier.
    """
    ...
