# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetFleetJavaMigrationAnalysisResultResult',
    'AwaitableGetFleetJavaMigrationAnalysisResultResult',
    'get_fleet_java_migration_analysis_result',
    'get_fleet_java_migration_analysis_result_output',
]

@pulumi.output_type
class GetFleetJavaMigrationAnalysisResultResult:
    """
    A collection of values returned by getFleetJavaMigrationAnalysisResult.
    """
    def __init__(__self__, application_execution_type=None, application_key=None, application_name=None, application_path=None, bucket=None, fleet_id=None, host_name=None, id=None, java_migration_analysis_result_id=None, managed_instance_id=None, metadata=None, namespace=None, object_lists=None, object_storage_upload_dir_path=None, source_jdk_version=None, target_jdk_version=None, time_created=None, work_request_id=None):
        if application_execution_type and not isinstance(application_execution_type, str):
            raise TypeError("Expected argument 'application_execution_type' to be a str")
        pulumi.set(__self__, "application_execution_type", application_execution_type)
        if application_key and not isinstance(application_key, str):
            raise TypeError("Expected argument 'application_key' to be a str")
        pulumi.set(__self__, "application_key", application_key)
        if application_name and not isinstance(application_name, str):
            raise TypeError("Expected argument 'application_name' to be a str")
        pulumi.set(__self__, "application_name", application_name)
        if application_path and not isinstance(application_path, str):
            raise TypeError("Expected argument 'application_path' to be a str")
        pulumi.set(__self__, "application_path", application_path)
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if host_name and not isinstance(host_name, str):
            raise TypeError("Expected argument 'host_name' to be a str")
        pulumi.set(__self__, "host_name", host_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if java_migration_analysis_result_id and not isinstance(java_migration_analysis_result_id, str):
            raise TypeError("Expected argument 'java_migration_analysis_result_id' to be a str")
        pulumi.set(__self__, "java_migration_analysis_result_id", java_migration_analysis_result_id)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if metadata and not isinstance(metadata, str):
            raise TypeError("Expected argument 'metadata' to be a str")
        pulumi.set(__self__, "metadata", metadata)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if object_lists and not isinstance(object_lists, list):
            raise TypeError("Expected argument 'object_lists' to be a list")
        pulumi.set(__self__, "object_lists", object_lists)
        if object_storage_upload_dir_path and not isinstance(object_storage_upload_dir_path, str):
            raise TypeError("Expected argument 'object_storage_upload_dir_path' to be a str")
        pulumi.set(__self__, "object_storage_upload_dir_path", object_storage_upload_dir_path)
        if source_jdk_version and not isinstance(source_jdk_version, str):
            raise TypeError("Expected argument 'source_jdk_version' to be a str")
        pulumi.set(__self__, "source_jdk_version", source_jdk_version)
        if target_jdk_version and not isinstance(target_jdk_version, str):
            raise TypeError("Expected argument 'target_jdk_version' to be a str")
        pulumi.set(__self__, "target_jdk_version", target_jdk_version)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if work_request_id and not isinstance(work_request_id, str):
            raise TypeError("Expected argument 'work_request_id' to be a str")
        pulumi.set(__self__, "work_request_id", work_request_id)

    @property
    @pulumi.getter(name="applicationExecutionType")
    def application_execution_type(self) -> str:
        """
        Execution type of the application for an application type, such as WAR and EAR, that is deployed or installed.
        """
        return pulumi.get(self, "application_execution_type")

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> str:
        """
        The unique key that identifies the application.
        """
        return pulumi.get(self, "application_key")

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> str:
        """
        The name of the application for which the Java migration analysis was performed.
        """
        return pulumi.get(self, "application_name")

    @property
    @pulumi.getter(name="applicationPath")
    def application_path(self) -> str:
        """
        The installation path of the application for which the Java migration analysis was performed.
        """
        return pulumi.get(self, "application_path")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the object storage bucket that contains the results of the migration analysis.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> str:
        """
        The fleet OCID.
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        The hostname of the managed instance that hosts the application for which the Java migration analysis was performed.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="javaMigrationAnalysisResultId")
    def java_migration_analysis_result_id(self) -> str:
        return pulumi.get(self, "java_migration_analysis_result_id")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> str:
        """
        The managed instance OCID.
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter
    def metadata(self) -> str:
        """
        Additional info reserved for future use.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The object storage namespace that contains the results of the migration analysis.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectLists")
    def object_lists(self) -> Sequence[str]:
        """
        The names of the object storage objects that contain the results of the migration analysis.
        """
        return pulumi.get(self, "object_lists")

    @property
    @pulumi.getter(name="objectStorageUploadDirPath")
    def object_storage_upload_dir_path(self) -> str:
        """
        The directory path of the object storage bucket that contains the results of the migration analysis.
        """
        return pulumi.get(self, "object_storage_upload_dir_path")

    @property
    @pulumi.getter(name="sourceJdkVersion")
    def source_jdk_version(self) -> str:
        """
        The source JDK version of the application that's currently running.
        """
        return pulumi.get(self, "source_jdk_version")

    @property
    @pulumi.getter(name="targetJdkVersion")
    def target_jdk_version(self) -> str:
        """
        The target JDK version of the application to be migrated.
        """
        return pulumi.get(self, "target_jdk_version")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the result is compiled.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> str:
        """
        The OCID of the work request of this analysis.
        """
        return pulumi.get(self, "work_request_id")


class AwaitableGetFleetJavaMigrationAnalysisResultResult(GetFleetJavaMigrationAnalysisResultResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetJavaMigrationAnalysisResultResult(
            application_execution_type=self.application_execution_type,
            application_key=self.application_key,
            application_name=self.application_name,
            application_path=self.application_path,
            bucket=self.bucket,
            fleet_id=self.fleet_id,
            host_name=self.host_name,
            id=self.id,
            java_migration_analysis_result_id=self.java_migration_analysis_result_id,
            managed_instance_id=self.managed_instance_id,
            metadata=self.metadata,
            namespace=self.namespace,
            object_lists=self.object_lists,
            object_storage_upload_dir_path=self.object_storage_upload_dir_path,
            source_jdk_version=self.source_jdk_version,
            target_jdk_version=self.target_jdk_version,
            time_created=self.time_created,
            work_request_id=self.work_request_id)


def get_fleet_java_migration_analysis_result(fleet_id: Optional[str] = None,
                                             java_migration_analysis_result_id: Optional[str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetJavaMigrationAnalysisResultResult:
    """
    This data source provides details about a specific Fleet Java Migration Analysis Result resource in Oracle Cloud Infrastructure Jms service.

    Retrieve Java Migration Analysis result.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_java_migration_analysis_result = oci.Jms.get_fleet_java_migration_analysis_result(fleet_id=test_fleet["id"],
        java_migration_analysis_result_id=fleet_java_migration_analysis_result_id)
    ```


    :param str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param str java_migration_analysis_result_id: The OCID of the analysis result.
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    __args__['javaMigrationAnalysisResultId'] = java_migration_analysis_result_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetJavaMigrationAnalysisResult:getFleetJavaMigrationAnalysisResult', __args__, opts=opts, typ=GetFleetJavaMigrationAnalysisResultResult).value

    return AwaitableGetFleetJavaMigrationAnalysisResultResult(
        application_execution_type=pulumi.get(__ret__, 'application_execution_type'),
        application_key=pulumi.get(__ret__, 'application_key'),
        application_name=pulumi.get(__ret__, 'application_name'),
        application_path=pulumi.get(__ret__, 'application_path'),
        bucket=pulumi.get(__ret__, 'bucket'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        host_name=pulumi.get(__ret__, 'host_name'),
        id=pulumi.get(__ret__, 'id'),
        java_migration_analysis_result_id=pulumi.get(__ret__, 'java_migration_analysis_result_id'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        metadata=pulumi.get(__ret__, 'metadata'),
        namespace=pulumi.get(__ret__, 'namespace'),
        object_lists=pulumi.get(__ret__, 'object_lists'),
        object_storage_upload_dir_path=pulumi.get(__ret__, 'object_storage_upload_dir_path'),
        source_jdk_version=pulumi.get(__ret__, 'source_jdk_version'),
        target_jdk_version=pulumi.get(__ret__, 'target_jdk_version'),
        time_created=pulumi.get(__ret__, 'time_created'),
        work_request_id=pulumi.get(__ret__, 'work_request_id'))


@_utilities.lift_output_func(get_fleet_java_migration_analysis_result)
def get_fleet_java_migration_analysis_result_output(fleet_id: Optional[pulumi.Input[str]] = None,
                                                    java_migration_analysis_result_id: Optional[pulumi.Input[str]] = None,
                                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFleetJavaMigrationAnalysisResultResult]:
    """
    This data source provides details about a specific Fleet Java Migration Analysis Result resource in Oracle Cloud Infrastructure Jms service.

    Retrieve Java Migration Analysis result.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_java_migration_analysis_result = oci.Jms.get_fleet_java_migration_analysis_result(fleet_id=test_fleet["id"],
        java_migration_analysis_result_id=fleet_java_migration_analysis_result_id)
    ```


    :param str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    :param str java_migration_analysis_result_id: The OCID of the analysis result.
    """
    ...
