# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JavaDownloadsJavaDownloadReportArgs', 'JavaDownloadsJavaDownloadReport']

@pulumi.input_type
class JavaDownloadsJavaDownloadReportArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 format: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_end: Optional[pulumi.Input[str]] = None,
                 time_start: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a JavaDownloadsJavaDownloadReport resource.
        :param pulumi.Input[str] compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) here should be the tenancy OCID.
        :param pulumi.Input[str] format: The format of the report that is generated.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        :param pulumi.Input[str] time_end: The end time until when the download records have to be included (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[str] time_start: The start time from when download records have to be included (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "format", format)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if time_end is not None:
            pulumi.set(__self__, "time_end", time_end)
        if time_start is not None:
            pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) here should be the tenancy OCID.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def format(self) -> pulumi.Input[str]:
        """
        The format of the report that is generated.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input[str]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> Optional[pulumi.Input[str]]:
        """
        The end time until when the download records have to be included (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_end")

    @time_end.setter
    def time_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_end", value)

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[pulumi.Input[str]]:
        """
        The start time from when download records have to be included (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_start")

    @time_start.setter
    def time_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_start", value)


@pulumi.input_type
class _JavaDownloadsJavaDownloadReportState:
    def __init__(__self__, *,
                 checksum_type: Optional[pulumi.Input[str]] = None,
                 checksum_value: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaDownloadReportCreatedByArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 file_size_in_bytes: Optional[pulumi.Input[str]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 sort_by: Optional[pulumi.Input[str]] = None,
                 sort_order: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_end: Optional[pulumi.Input[str]] = None,
                 time_start: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering JavaDownloadsJavaDownloadReport resources.
        :param pulumi.Input[str] checksum_type: The algorithm used for calculating the checksum.
        :param pulumi.Input[str] checksum_value: The checksum value of the Java download report file.
        :param pulumi.Input[str] compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) here should be the tenancy OCID.
        :param pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaDownloadReportCreatedByArgs']]] created_bies: An authorized principal.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[str] display_name: Display name for the Java download report.
        :param pulumi.Input[str] file_size_in_bytes: Approximate size of the Java download report file in bytes.
        :param pulumi.Input[str] format: The format of the report that is generated.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        :param pulumi.Input[str] state: The current state of the Java download report.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the Java download report was created, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        :param pulumi.Input[str] time_end: The end time until when the download records have to be included (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[str] time_start: The start time from when download records have to be included (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if checksum_type is not None:
            pulumi.set(__self__, "checksum_type", checksum_type)
        if checksum_value is not None:
            pulumi.set(__self__, "checksum_value", checksum_value)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if created_bies is not None:
            pulumi.set(__self__, "created_bies", created_bies)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if file_size_in_bytes is not None:
            pulumi.set(__self__, "file_size_in_bytes", file_size_in_bytes)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if sort_by is not None:
            pulumi.set(__self__, "sort_by", sort_by)
        if sort_order is not None:
            pulumi.set(__self__, "sort_order", sort_order)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_end is not None:
            pulumi.set(__self__, "time_end", time_end)
        if time_start is not None:
            pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter(name="checksumType")
    def checksum_type(self) -> Optional[pulumi.Input[str]]:
        """
        The algorithm used for calculating the checksum.
        """
        return pulumi.get(self, "checksum_type")

    @checksum_type.setter
    def checksum_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checksum_type", value)

    @property
    @pulumi.getter(name="checksumValue")
    def checksum_value(self) -> Optional[pulumi.Input[str]]:
        """
        The checksum value of the Java download report file.
        """
        return pulumi.get(self, "checksum_value")

    @checksum_value.setter
    def checksum_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checksum_value", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) here should be the tenancy OCID.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="createdBies")
    def created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaDownloadReportCreatedByArgs']]]]:
        """
        An authorized principal.
        """
        return pulumi.get(self, "created_bies")

    @created_bies.setter
    def created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaDownloadReportCreatedByArgs']]]]):
        pulumi.set(self, "created_bies", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name for the Java download report.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="fileSizeInBytes")
    def file_size_in_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        Approximate size of the Java download report file in bytes.
        """
        return pulumi.get(self, "file_size_in_bytes")

    @file_size_in_bytes.setter
    def file_size_in_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_size_in_bytes", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        The format of the report that is generated.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="sortBy")
    def sort_by(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "sort_by")

    @sort_by.setter
    def sort_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sort_by", value)

    @property
    @pulumi.getter(name="sortOrder")
    def sort_order(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "sort_order")

    @sort_order.setter
    def sort_order(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sort_order", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Java download report.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the Java download report was created, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> Optional[pulumi.Input[str]]:
        """
        The end time until when the download records have to be included (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_end")

    @time_end.setter
    def time_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_end", value)

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[pulumi.Input[str]]:
        """
        The start time from when download records have to be included (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_start")

    @time_start.setter
    def time_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_start", value)


class JavaDownloadsJavaDownloadReport(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_end: Optional[pulumi.Input[str]] = None,
                 time_start: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Java Download Report resource in Oracle Cloud Infrastructure Jms Java Downloads service.

        Create a new report in the specified format containing the download details
        for the tenancy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_java_download_report = oci.jms.JavaDownloadsJavaDownloadReport("test_java_download_report",
            compartment_id=tenancy_ocid,
            format=java_download_report_format,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            time_end=java_download_report_time_end,
            time_start=java_download_report_time_start)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) here should be the tenancy OCID.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[str] format: The format of the report that is generated.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        :param pulumi.Input[str] time_end: The end time until when the download records have to be included (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[str] time_start: The start time from when download records have to be included (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JavaDownloadsJavaDownloadReportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Java Download Report resource in Oracle Cloud Infrastructure Jms Java Downloads service.

        Create a new report in the specified format containing the download details
        for the tenancy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_java_download_report = oci.jms.JavaDownloadsJavaDownloadReport("test_java_download_report",
            compartment_id=tenancy_ocid,
            format=java_download_report_format,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            time_end=java_download_report_time_end,
            time_start=java_download_report_time_start)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param JavaDownloadsJavaDownloadReportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JavaDownloadsJavaDownloadReportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_end: Optional[pulumi.Input[str]] = None,
                 time_start: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JavaDownloadsJavaDownloadReportArgs.__new__(JavaDownloadsJavaDownloadReportArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if format is None and not opts.urn:
                raise TypeError("Missing required property 'format'")
            __props__.__dict__["format"] = format
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["time_end"] = time_end
            __props__.__dict__["time_start"] = time_start
            __props__.__dict__["checksum_type"] = None
            __props__.__dict__["checksum_value"] = None
            __props__.__dict__["created_bies"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["file_size_in_bytes"] = None
            __props__.__dict__["sort_by"] = None
            __props__.__dict__["sort_order"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
        super(JavaDownloadsJavaDownloadReport, __self__).__init__(
            'oci:Jms/javaDownloadsJavaDownloadReport:JavaDownloadsJavaDownloadReport',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            checksum_type: Optional[pulumi.Input[str]] = None,
            checksum_value: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JavaDownloadsJavaDownloadReportCreatedByArgs', 'JavaDownloadsJavaDownloadReportCreatedByArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            file_size_in_bytes: Optional[pulumi.Input[str]] = None,
            format: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            sort_by: Optional[pulumi.Input[str]] = None,
            sort_order: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_end: Optional[pulumi.Input[str]] = None,
            time_start: Optional[pulumi.Input[str]] = None) -> 'JavaDownloadsJavaDownloadReport':
        """
        Get an existing JavaDownloadsJavaDownloadReport resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] checksum_type: The algorithm used for calculating the checksum.
        :param pulumi.Input[str] checksum_value: The checksum value of the Java download report file.
        :param pulumi.Input[str] compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) here should be the tenancy OCID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JavaDownloadsJavaDownloadReportCreatedByArgs', 'JavaDownloadsJavaDownloadReportCreatedByArgsDict']]]] created_bies: An authorized principal.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[str] display_name: Display name for the Java download report.
        :param pulumi.Input[str] file_size_in_bytes: Approximate size of the Java download report file in bytes.
        :param pulumi.Input[str] format: The format of the report that is generated.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        :param pulumi.Input[str] state: The current state of the Java download report.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the Java download report was created, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        :param pulumi.Input[str] time_end: The end time until when the download records have to be included (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[str] time_start: The start time from when download records have to be included (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JavaDownloadsJavaDownloadReportState.__new__(_JavaDownloadsJavaDownloadReportState)

        __props__.__dict__["checksum_type"] = checksum_type
        __props__.__dict__["checksum_value"] = checksum_value
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["created_bies"] = created_bies
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["file_size_in_bytes"] = file_size_in_bytes
        __props__.__dict__["format"] = format
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["sort_by"] = sort_by
        __props__.__dict__["sort_order"] = sort_order
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_end"] = time_end
        __props__.__dict__["time_start"] = time_start
        return JavaDownloadsJavaDownloadReport(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="checksumType")
    def checksum_type(self) -> pulumi.Output[str]:
        """
        The algorithm used for calculating the checksum.
        """
        return pulumi.get(self, "checksum_type")

    @property
    @pulumi.getter(name="checksumValue")
    def checksum_value(self) -> pulumi.Output[str]:
        """
        The checksum value of the Java download report file.
        """
        return pulumi.get(self, "checksum_value")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) here should be the tenancy OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBies")
    def created_bies(self) -> pulumi.Output[Sequence['outputs.JavaDownloadsJavaDownloadReportCreatedBy']]:
        """
        An authorized principal.
        """
        return pulumi.get(self, "created_bies")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Display name for the Java download report.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fileSizeInBytes")
    def file_size_in_bytes(self) -> pulumi.Output[str]:
        """
        Approximate size of the Java download report file in bytes.
        """
        return pulumi.get(self, "file_size_in_bytes")

    @property
    @pulumi.getter
    def format(self) -> pulumi.Output[str]:
        """
        The format of the report that is generated.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="sortBy")
    def sort_by(self) -> pulumi.Output[str]:
        return pulumi.get(self, "sort_by")

    @property
    @pulumi.getter(name="sortOrder")
    def sort_order(self) -> pulumi.Output[str]:
        return pulumi.get(self, "sort_order")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Java download report.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the Java download report was created, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> pulumi.Output[str]:
        """
        The end time until when the download records have to be included (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> pulumi.Output[str]:
        """
        The start time from when download records have to be included (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_start")

