# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetProtocolsResult',
    'AwaitableGetProtocolsResult',
    'get_protocols',
    'get_protocols_output',
]

@pulumi.output_type
class GetProtocolsResult:
    """
    A collection of values returned by getProtocols.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, protocols=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if protocols and not isinstance(protocols, list):
            raise TypeError("Expected argument 'protocols' to be a list")
        pulumi.set(__self__, "protocols", protocols)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetProtocolsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def protocols(self) -> Sequence['outputs.GetProtocolsProtocolResult']:
        """
        The list of protocols.
        """
        return pulumi.get(self, "protocols")


class AwaitableGetProtocolsResult(GetProtocolsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProtocolsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            protocols=self.protocols)


def get_protocols(compartment_id: Optional[str] = None,
                  filters: Optional[Sequence[Union['GetProtocolsFilterArgs', 'GetProtocolsFilterArgsDict']]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProtocolsResult:
    """
    This data source provides the list of Load Balancer Protocols in Oracle Cloud Infrastructure Load Balancer service.

    Lists all supported traffic protocols.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_load_balancer_protocols = oci.LoadBalancer.get_protocols(compartment_id=compartment_id)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the load balancer protocols to list.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LoadBalancer/getProtocols:getProtocols', __args__, opts=opts, typ=GetProtocolsResult).value

    return AwaitableGetProtocolsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        protocols=pulumi.get(__ret__, 'protocols'))


@_utilities.lift_output_func(get_protocols)
def get_protocols_output(compartment_id: Optional[pulumi.Input[str]] = None,
                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetProtocolsFilterArgs', 'GetProtocolsFilterArgsDict']]]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProtocolsResult]:
    """
    This data source provides the list of Load Balancer Protocols in Oracle Cloud Infrastructure Load Balancer service.

    Lists all supported traffic protocols.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_load_balancer_protocols = oci.LoadBalancer.get_protocols(compartment_id=compartment_id)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the load balancer protocols to list.
    """
    ...
