# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NamespaceIngestTimeRuleArgs', 'NamespaceIngestTimeRule']

@pulumi.input_type
class NamespaceIngestTimeRuleArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input['NamespaceIngestTimeRuleActionArgs']]],
                 compartment_id: pulumi.Input[str],
                 conditions: pulumi.Input['NamespaceIngestTimeRuleConditionsArgs'],
                 display_name: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a NamespaceIngestTimeRule resource.
        :param pulumi.Input[Sequence[pulumi.Input['NamespaceIngestTimeRuleActionArgs']]] actions: (Updatable) The action(s) to be performed if the ingest time rule condition(s) are satisfied.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input['NamespaceIngestTimeRuleConditionsArgs'] conditions: (Updatable) The condition(s) to evaluate for an ingest time rule.
        :param pulumi.Input[str] display_name: (Updatable) The ingest time rule display name.
        :param pulumi.Input[str] namespace: The Logging Analytics namespace used for the request. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Description for this resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "namespace", namespace)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input['NamespaceIngestTimeRuleActionArgs']]]:
        """
        (Updatable) The action(s) to be performed if the ingest time rule condition(s) are satisfied.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input['NamespaceIngestTimeRuleActionArgs']]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Input['NamespaceIngestTimeRuleConditionsArgs']:
        """
        (Updatable) The condition(s) to evaluate for an ingest time rule.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: pulumi.Input['NamespaceIngestTimeRuleConditionsArgs']):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The ingest time rule display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The Logging Analytics namespace used for the request. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description for this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _NamespaceIngestTimeRuleState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceIngestTimeRuleActionArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input['NamespaceIngestTimeRuleConditionsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 ingest_time_rule_id: Optional[pulumi.Input[str]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NamespaceIngestTimeRule resources.
        :param pulumi.Input[Sequence[pulumi.Input['NamespaceIngestTimeRuleActionArgs']]] actions: (Updatable) The action(s) to be performed if the ingest time rule condition(s) are satisfied.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input['NamespaceIngestTimeRuleConditionsArgs'] conditions: (Updatable) The condition(s) to evaluate for an ingest time rule.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Description for this resource.
        :param pulumi.Input[str] display_name: (Updatable) The ingest time rule display name.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_enabled: A flag indicating whether or not the ingest time rule is enabled.
        :param pulumi.Input[str] namespace: The Logging Analytics namespace used for the request. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the ingest time rule.
        :param pulumi.Input[str] time_created: The date and time the resource was created, in the format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The date and time the resource was last updated, in the format defined by RFC3339.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ingest_time_rule_id is not None:
            pulumi.set(__self__, "ingest_time_rule_id", ingest_time_rule_id)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceIngestTimeRuleActionArgs']]]]:
        """
        (Updatable) The action(s) to be performed if the ingest time rule condition(s) are satisfied.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NamespaceIngestTimeRuleActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input['NamespaceIngestTimeRuleConditionsArgs']]:
        """
        (Updatable) The condition(s) to evaluate for an ingest time rule.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input['NamespaceIngestTimeRuleConditionsArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description for this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The ingest time rule display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="ingestTimeRuleId")
    def ingest_time_rule_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ingest_time_rule_id")

    @ingest_time_rule_id.setter
    def ingest_time_rule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingest_time_rule_id", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether or not the ingest time rule is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The Logging Analytics namespace used for the request. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the ingest time rule.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the resource was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the resource was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class NamespaceIngestTimeRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamespaceIngestTimeRuleActionArgs', 'NamespaceIngestTimeRuleActionArgsDict']]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[Union['NamespaceIngestTimeRuleConditionsArgs', 'NamespaceIngestTimeRuleConditionsArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Namespace Ingest Time Rule resource in Oracle Cloud Infrastructure Log Analytics service.

        Creates a new ingest time rule in the specified compartment. You may also specify optional information such as description, defined tags, and free-form tags.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_namespace_ingest_time_rule = oci.log_analytics.NamespaceIngestTimeRule("test_namespace_ingest_time_rule",
            actions=[{
                "compartment_id": compartment_id,
                "metric_name": test_metric["name"],
                "namespace": namespace_ingest_time_rule_actions_namespace,
                "type": namespace_ingest_time_rule_actions_type,
                "dimensions": namespace_ingest_time_rule_actions_dimensions,
                "resource_group": namespace_ingest_time_rule_actions_resource_group,
            }],
            compartment_id=compartment_id,
            conditions={
                "field_name": namespace_ingest_time_rule_conditions_field_name,
                "field_operator": namespace_ingest_time_rule_conditions_field_operator,
                "field_value": namespace_ingest_time_rule_conditions_field_value,
                "kind": namespace_ingest_time_rule_conditions_kind,
                "additional_conditions": [{
                    "condition_field": namespace_ingest_time_rule_conditions_additional_conditions_condition_field,
                    "condition_operator": namespace_ingest_time_rule_conditions_additional_conditions_condition_operator,
                    "condition_value": namespace_ingest_time_rule_conditions_additional_conditions_condition_value,
                }],
            },
            display_name=namespace_ingest_time_rule_display_name,
            namespace=namespace_ingest_time_rule_namespace,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=namespace_ingest_time_rule_description,
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        NamespaceIngestTimeRules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LogAnalytics/namespaceIngestTimeRule:NamespaceIngestTimeRule test_namespace_ingest_time_rule "namespaces/{namespaceName}/ingestTimeRules/{ingestTimeRuleId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NamespaceIngestTimeRuleActionArgs', 'NamespaceIngestTimeRuleActionArgsDict']]]] actions: (Updatable) The action(s) to be performed if the ingest time rule condition(s) are satisfied.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Union['NamespaceIngestTimeRuleConditionsArgs', 'NamespaceIngestTimeRuleConditionsArgsDict']] conditions: (Updatable) The condition(s) to evaluate for an ingest time rule.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Description for this resource.
        :param pulumi.Input[str] display_name: (Updatable) The ingest time rule display name.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] namespace: The Logging Analytics namespace used for the request. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NamespaceIngestTimeRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Namespace Ingest Time Rule resource in Oracle Cloud Infrastructure Log Analytics service.

        Creates a new ingest time rule in the specified compartment. You may also specify optional information such as description, defined tags, and free-form tags.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_namespace_ingest_time_rule = oci.log_analytics.NamespaceIngestTimeRule("test_namespace_ingest_time_rule",
            actions=[{
                "compartment_id": compartment_id,
                "metric_name": test_metric["name"],
                "namespace": namespace_ingest_time_rule_actions_namespace,
                "type": namespace_ingest_time_rule_actions_type,
                "dimensions": namespace_ingest_time_rule_actions_dimensions,
                "resource_group": namespace_ingest_time_rule_actions_resource_group,
            }],
            compartment_id=compartment_id,
            conditions={
                "field_name": namespace_ingest_time_rule_conditions_field_name,
                "field_operator": namespace_ingest_time_rule_conditions_field_operator,
                "field_value": namespace_ingest_time_rule_conditions_field_value,
                "kind": namespace_ingest_time_rule_conditions_kind,
                "additional_conditions": [{
                    "condition_field": namespace_ingest_time_rule_conditions_additional_conditions_condition_field,
                    "condition_operator": namespace_ingest_time_rule_conditions_additional_conditions_condition_operator,
                    "condition_value": namespace_ingest_time_rule_conditions_additional_conditions_condition_value,
                }],
            },
            display_name=namespace_ingest_time_rule_display_name,
            namespace=namespace_ingest_time_rule_namespace,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=namespace_ingest_time_rule_description,
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        NamespaceIngestTimeRules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LogAnalytics/namespaceIngestTimeRule:NamespaceIngestTimeRule test_namespace_ingest_time_rule "namespaces/{namespaceName}/ingestTimeRules/{ingestTimeRuleId}"
        ```

        :param str resource_name: The name of the resource.
        :param NamespaceIngestTimeRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamespaceIngestTimeRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamespaceIngestTimeRuleActionArgs', 'NamespaceIngestTimeRuleActionArgsDict']]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[Union['NamespaceIngestTimeRuleConditionsArgs', 'NamespaceIngestTimeRuleConditionsArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamespaceIngestTimeRuleArgs.__new__(NamespaceIngestTimeRuleArgs)

            if actions is None and not opts.urn:
                raise TypeError("Missing required property 'actions'")
            __props__.__dict__["actions"] = actions
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if conditions is None and not opts.urn:
                raise TypeError("Missing required property 'conditions'")
            __props__.__dict__["conditions"] = conditions
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["ingest_time_rule_id"] = None
            __props__.__dict__["is_enabled"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(NamespaceIngestTimeRule, __self__).__init__(
            'oci:LogAnalytics/namespaceIngestTimeRule:NamespaceIngestTimeRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NamespaceIngestTimeRuleActionArgs', 'NamespaceIngestTimeRuleActionArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            conditions: Optional[pulumi.Input[Union['NamespaceIngestTimeRuleConditionsArgs', 'NamespaceIngestTimeRuleConditionsArgsDict']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            ingest_time_rule_id: Optional[pulumi.Input[str]] = None,
            is_enabled: Optional[pulumi.Input[bool]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'NamespaceIngestTimeRule':
        """
        Get an existing NamespaceIngestTimeRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NamespaceIngestTimeRuleActionArgs', 'NamespaceIngestTimeRuleActionArgsDict']]]] actions: (Updatable) The action(s) to be performed if the ingest time rule condition(s) are satisfied.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Union['NamespaceIngestTimeRuleConditionsArgs', 'NamespaceIngestTimeRuleConditionsArgsDict']] conditions: (Updatable) The condition(s) to evaluate for an ingest time rule.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Description for this resource.
        :param pulumi.Input[str] display_name: (Updatable) The ingest time rule display name.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_enabled: A flag indicating whether or not the ingest time rule is enabled.
        :param pulumi.Input[str] namespace: The Logging Analytics namespace used for the request. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the ingest time rule.
        :param pulumi.Input[str] time_created: The date and time the resource was created, in the format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The date and time the resource was last updated, in the format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamespaceIngestTimeRuleState.__new__(_NamespaceIngestTimeRuleState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["ingest_time_rule_id"] = ingest_time_rule_id
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return NamespaceIngestTimeRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence['outputs.NamespaceIngestTimeRuleAction']]:
        """
        (Updatable) The action(s) to be performed if the ingest time rule condition(s) are satisfied.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output['outputs.NamespaceIngestTimeRuleConditions']:
        """
        (Updatable) The condition(s) to evaluate for an ingest time rule.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Description for this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The ingest time rule display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="ingestTimeRuleId")
    def ingest_time_rule_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "ingest_time_rule_id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[bool]:
        """
        A flag indicating whether or not the ingest time rule is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        The Logging Analytics namespace used for the request. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the ingest time rule.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the resource was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the resource was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

