# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetOpsiConfigurationResult',
    'AwaitableGetOpsiConfigurationResult',
    'get_opsi_configuration',
    'get_opsi_configuration_output',
]

@pulumi.output_type
class GetOpsiConfigurationResult:
    """
    A collection of values returned by getOpsiConfiguration.
    """
    def __init__(__self__, compartment_id=None, config_item_custom_statuses=None, config_item_fields=None, config_items=None, config_items_applicable_contexts=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, opsi_config_fields=None, opsi_config_type=None, opsi_configuration_id=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if config_item_custom_statuses and not isinstance(config_item_custom_statuses, list):
            raise TypeError("Expected argument 'config_item_custom_statuses' to be a list")
        pulumi.set(__self__, "config_item_custom_statuses", config_item_custom_statuses)
        if config_item_fields and not isinstance(config_item_fields, list):
            raise TypeError("Expected argument 'config_item_fields' to be a list")
        pulumi.set(__self__, "config_item_fields", config_item_fields)
        if config_items and not isinstance(config_items, list):
            raise TypeError("Expected argument 'config_items' to be a list")
        pulumi.set(__self__, "config_items", config_items)
        if config_items_applicable_contexts and not isinstance(config_items_applicable_contexts, list):
            raise TypeError("Expected argument 'config_items_applicable_contexts' to be a list")
        pulumi.set(__self__, "config_items_applicable_contexts", config_items_applicable_contexts)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if opsi_config_fields and not isinstance(opsi_config_fields, list):
            raise TypeError("Expected argument 'opsi_config_fields' to be a list")
        pulumi.set(__self__, "opsi_config_fields", opsi_config_fields)
        if opsi_config_type and not isinstance(opsi_config_type, str):
            raise TypeError("Expected argument 'opsi_config_type' to be a str")
        pulumi.set(__self__, "opsi_config_type", opsi_config_type)
        if opsi_configuration_id and not isinstance(opsi_configuration_id, str):
            raise TypeError("Expected argument 'opsi_configuration_id' to be a str")
        pulumi.set(__self__, "opsi_configuration_id", opsi_configuration_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configItemCustomStatuses")
    def config_item_custom_statuses(self) -> Sequence[str]:
        return pulumi.get(self, "config_item_custom_statuses")

    @property
    @pulumi.getter(name="configItemFields")
    def config_item_fields(self) -> Sequence[str]:
        return pulumi.get(self, "config_item_fields")

    @property
    @pulumi.getter(name="configItems")
    def config_items(self) -> Sequence['outputs.GetOpsiConfigurationConfigItemResult']:
        """
        Array of configuration item summary objects.
        """
        return pulumi.get(self, "config_items")

    @property
    @pulumi.getter(name="configItemsApplicableContexts")
    def config_items_applicable_contexts(self) -> Sequence[str]:
        return pulumi.get(self, "config_items_applicable_contexts")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of OPSI configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        User-friendly display name for the OPSI configuration. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of OPSI configuration resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="opsiConfigFields")
    def opsi_config_fields(self) -> Sequence[str]:
        return pulumi.get(self, "opsi_config_fields")

    @property
    @pulumi.getter(name="opsiConfigType")
    def opsi_config_type(self) -> str:
        """
        OPSI configuration type.
        """
        return pulumi.get(self, "opsi_config_type")

    @property
    @pulumi.getter(name="opsiConfigurationId")
    def opsi_configuration_id(self) -> str:
        return pulumi.get(self, "opsi_configuration_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        OPSI configuration resource lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time at which the resource was first created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetOpsiConfigurationResult(GetOpsiConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOpsiConfigurationResult(
            compartment_id=self.compartment_id,
            config_item_custom_statuses=self.config_item_custom_statuses,
            config_item_fields=self.config_item_fields,
            config_items=self.config_items,
            config_items_applicable_contexts=self.config_items_applicable_contexts,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            opsi_config_fields=self.opsi_config_fields,
            opsi_config_type=self.opsi_config_type,
            opsi_configuration_id=self.opsi_configuration_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_opsi_configuration(config_item_custom_statuses: Optional[Sequence[str]] = None,
                           config_item_fields: Optional[Sequence[str]] = None,
                           config_items_applicable_contexts: Optional[Sequence[str]] = None,
                           opsi_config_fields: Optional[Sequence[str]] = None,
                           opsi_configuration_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOpsiConfigurationResult:
    """
    This data source provides details about a specific Opsi Configuration resource in Oracle Cloud Infrastructure Opsi service.

    Gets details of an OPSI configuration resource.
    Values specified in configItemField and configItemCustomStatus query params will be considered, only if configItems field is requested as part of opsiConfigField query param.
    Values specified in configItemCustomStatus will determine whether only customized configuration items or only non-customized configuration items or both have to be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_opsi_configuration = oci.Opsi.get_opsi_configuration(opsi_configuration_id=test_opsi_configuration_oci_opsi_opsi_configuration["id"],
        config_item_custom_statuses=opsi_configuration_config_item_custom_status,
        config_item_fields=opsi_configuration_config_item_field,
        config_items_applicable_contexts=opsi_configuration_config_items_applicable_context,
        opsi_config_fields=opsi_configuration_opsi_config_field)
    ```


    :param Sequence[str] config_item_custom_statuses: Specifies whether only customized configuration items or only non-customized configuration items or both have to be returned. By default only customized configuration items are returned.
    :param Sequence[str] config_item_fields: Specifies the fields to return in a config item summary.
    :param Sequence[str] config_items_applicable_contexts: Returns the configuration items filtered by applicable contexts sent in this param. By default configuration items of all applicable contexts are returned.
    :param Sequence[str] opsi_config_fields: Optional fields to return as part of OpsiConfiguration object. Unless requested, these fields will not be returned by default.
    :param str opsi_configuration_id: [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of OPSI configuration resource.
    """
    __args__ = dict()
    __args__['configItemCustomStatuses'] = config_item_custom_statuses
    __args__['configItemFields'] = config_item_fields
    __args__['configItemsApplicableContexts'] = config_items_applicable_contexts
    __args__['opsiConfigFields'] = opsi_config_fields
    __args__['opsiConfigurationId'] = opsi_configuration_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getOpsiConfiguration:getOpsiConfiguration', __args__, opts=opts, typ=GetOpsiConfigurationResult).value

    return AwaitableGetOpsiConfigurationResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        config_item_custom_statuses=pulumi.get(__ret__, 'config_item_custom_statuses'),
        config_item_fields=pulumi.get(__ret__, 'config_item_fields'),
        config_items=pulumi.get(__ret__, 'config_items'),
        config_items_applicable_contexts=pulumi.get(__ret__, 'config_items_applicable_contexts'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        opsi_config_fields=pulumi.get(__ret__, 'opsi_config_fields'),
        opsi_config_type=pulumi.get(__ret__, 'opsi_config_type'),
        opsi_configuration_id=pulumi.get(__ret__, 'opsi_configuration_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_opsi_configuration)
def get_opsi_configuration_output(config_item_custom_statuses: Optional[pulumi.Input[Sequence[str]]] = None,
                                  config_item_fields: Optional[pulumi.Input[Sequence[str]]] = None,
                                  config_items_applicable_contexts: Optional[pulumi.Input[Sequence[str]]] = None,
                                  opsi_config_fields: Optional[pulumi.Input[Sequence[str]]] = None,
                                  opsi_configuration_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOpsiConfigurationResult]:
    """
    This data source provides details about a specific Opsi Configuration resource in Oracle Cloud Infrastructure Opsi service.

    Gets details of an OPSI configuration resource.
    Values specified in configItemField and configItemCustomStatus query params will be considered, only if configItems field is requested as part of opsiConfigField query param.
    Values specified in configItemCustomStatus will determine whether only customized configuration items or only non-customized configuration items or both have to be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_opsi_configuration = oci.Opsi.get_opsi_configuration(opsi_configuration_id=test_opsi_configuration_oci_opsi_opsi_configuration["id"],
        config_item_custom_statuses=opsi_configuration_config_item_custom_status,
        config_item_fields=opsi_configuration_config_item_field,
        config_items_applicable_contexts=opsi_configuration_config_items_applicable_context,
        opsi_config_fields=opsi_configuration_opsi_config_field)
    ```


    :param Sequence[str] config_item_custom_statuses: Specifies whether only customized configuration items or only non-customized configuration items or both have to be returned. By default only customized configuration items are returned.
    :param Sequence[str] config_item_fields: Specifies the fields to return in a config item summary.
    :param Sequence[str] config_items_applicable_contexts: Returns the configuration items filtered by applicable contexts sent in this param. By default configuration items of all applicable contexts are returned.
    :param Sequence[str] opsi_config_fields: Optional fields to return as part of OpsiConfiguration object. Unless requested, these fields will not be returned by default.
    :param str opsi_configuration_id: [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of OPSI configuration resource.
    """
    ...
