# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEventsResult',
    'AwaitableGetEventsResult',
    'get_events',
    'get_events_output',
]

@pulumi.output_type
class GetEventsResult:
    """
    A collection of values returned by getEvents.
    """
    def __init__(__self__, compartment_id=None, event_collections=None, event_fingerprint=None, event_summary=None, event_summary_contains=None, filters=None, id=None, is_managed_by_autonomous_linux=None, resource_id=None, state=None, time_created_greater_than_or_equal_to=None, time_created_less_than=None, types=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if event_collections and not isinstance(event_collections, list):
            raise TypeError("Expected argument 'event_collections' to be a list")
        pulumi.set(__self__, "event_collections", event_collections)
        if event_fingerprint and not isinstance(event_fingerprint, str):
            raise TypeError("Expected argument 'event_fingerprint' to be a str")
        pulumi.set(__self__, "event_fingerprint", event_fingerprint)
        if event_summary and not isinstance(event_summary, str):
            raise TypeError("Expected argument 'event_summary' to be a str")
        pulumi.set(__self__, "event_summary", event_summary)
        if event_summary_contains and not isinstance(event_summary_contains, str):
            raise TypeError("Expected argument 'event_summary_contains' to be a str")
        pulumi.set(__self__, "event_summary_contains", event_summary_contains)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_managed_by_autonomous_linux and not isinstance(is_managed_by_autonomous_linux, bool):
            raise TypeError("Expected argument 'is_managed_by_autonomous_linux' to be a bool")
        pulumi.set(__self__, "is_managed_by_autonomous_linux", is_managed_by_autonomous_linux)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created_greater_than_or_equal_to and not isinstance(time_created_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_created_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_created_greater_than_or_equal_to", time_created_greater_than_or_equal_to)
        if time_created_less_than and not isinstance(time_created_less_than, str):
            raise TypeError("Expected argument 'time_created_less_than' to be a str")
        pulumi.set(__self__, "time_created_less_than", time_created_less_than)
        if types and not isinstance(types, list):
            raise TypeError("Expected argument 'types' to be a list")
        pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="eventCollections")
    def event_collections(self) -> Sequence['outputs.GetEventsEventCollectionResult']:
        """
        The list of event_collection.
        """
        return pulumi.get(self, "event_collections")

    @property
    @pulumi.getter(name="eventFingerprint")
    def event_fingerprint(self) -> Optional[str]:
        """
        Fingerprint of the event.
        """
        return pulumi.get(self, "event_fingerprint")

    @property
    @pulumi.getter(name="eventSummary")
    def event_summary(self) -> Optional[str]:
        """
        Summary of the event.
        """
        return pulumi.get(self, "event_summary")

    @property
    @pulumi.getter(name="eventSummaryContains")
    def event_summary_contains(self) -> Optional[str]:
        return pulumi.get(self, "event_summary_contains")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetEventsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the event.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isManagedByAutonomousLinux")
    def is_managed_by_autonomous_linux(self) -> Optional[bool]:
        """
        Indicates whether the event occurred on a resource that is managed by the Autonomous Linux service.
        """
        return pulumi.get(self, "is_managed_by_autonomous_linux")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance or resource where the event occurred.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the event.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> Optional[str]:
        return pulumi.get(self, "time_created_less_than")

    @property
    @pulumi.getter
    def types(self) -> Optional[Sequence[str]]:
        """
        Event type:
        * `KERNEL_OOPS` - Used to identify a kernel panic condition event
        * `KERNEL_CRASH` - Used to identify an internal fatal kernel error that cannot be safely recovered from
        * `EXPLOIT_ATTEMPT` - Used to identify a known exploit detection as identified by Ksplice
        * `SOFTWARE_UPDATE` - Software updates - Packages
        * `KSPLICE_UPDATE` - Ksplice updates
        * `SOFTWARE_SOURCE` - Software source
        * `AGENT` - Agent
        * `MANAGEMENT_STATION` - Management Station
        """
        return pulumi.get(self, "types")


class AwaitableGetEventsResult(GetEventsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventsResult(
            compartment_id=self.compartment_id,
            event_collections=self.event_collections,
            event_fingerprint=self.event_fingerprint,
            event_summary=self.event_summary,
            event_summary_contains=self.event_summary_contains,
            filters=self.filters,
            id=self.id,
            is_managed_by_autonomous_linux=self.is_managed_by_autonomous_linux,
            resource_id=self.resource_id,
            state=self.state,
            time_created_greater_than_or_equal_to=self.time_created_greater_than_or_equal_to,
            time_created_less_than=self.time_created_less_than,
            types=self.types)


def get_events(compartment_id: Optional[str] = None,
               event_fingerprint: Optional[str] = None,
               event_summary: Optional[str] = None,
               event_summary_contains: Optional[str] = None,
               filters: Optional[Sequence[Union['GetEventsFilterArgs', 'GetEventsFilterArgsDict']]] = None,
               id: Optional[str] = None,
               is_managed_by_autonomous_linux: Optional[bool] = None,
               resource_id: Optional[str] = None,
               state: Optional[str] = None,
               time_created_greater_than_or_equal_to: Optional[str] = None,
               time_created_less_than: Optional[str] = None,
               types: Optional[Sequence[str]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventsResult:
    """
    This data source provides the list of Events in Oracle Cloud Infrastructure Os Management Hub service.

    Lists events that match the specified criteria, such as compartment, state, and event type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_events = oci.OsManagementHub.get_events(compartment_id=compartment_id,
        event_fingerprint=event_event_fingerprint,
        event_summary=event_event_summary,
        event_summary_contains=event_event_summary_contains,
        id=event_id,
        is_managed_by_autonomous_linux=event_is_managed_by_autonomous_linux,
        resource_id=test_resource["id"],
        state=event_state,
        time_created_greater_than_or_equal_to=event_time_created_greater_than_or_equal_to,
        time_created_less_than=event_time_created_less_than,
        types=event_type)
    ```


    :param str compartment_id: The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param str event_fingerprint: The eventFingerprint of the KernelEventData.
    :param str event_summary: A filter to return only events whose summary matches the given value.
    :param str event_summary_contains: A filter to return only events with a summary that contains the value provided.
    :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the event.
    :param bool is_managed_by_autonomous_linux: Indicates whether to list only resources managed by the Autonomous Linux service.
    :param str resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource. This filter returns resources associated with the specified resource.
    :param str state: A filter to return only events that match the state provided. The state value is case-insensitive.
    :param str time_created_greater_than_or_equal_to: A filter that returns events that occurred on or after the date provided.       Example: `2016-08-25T21:10:29.600Z`
    :param str time_created_less_than: A filter that returns events that occurred on or before the date provided.       Example: `2016-08-25T21:10:29.600Z`
    :param Sequence[str] types: A filter to return only resources whose type matches the given value.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['eventFingerprint'] = event_fingerprint
    __args__['eventSummary'] = event_summary
    __args__['eventSummaryContains'] = event_summary_contains
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['isManagedByAutonomousLinux'] = is_managed_by_autonomous_linux
    __args__['resourceId'] = resource_id
    __args__['state'] = state
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    __args__['types'] = types
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getEvents:getEvents', __args__, opts=opts, typ=GetEventsResult).value

    return AwaitableGetEventsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        event_collections=pulumi.get(__ret__, 'event_collections'),
        event_fingerprint=pulumi.get(__ret__, 'event_fingerprint'),
        event_summary=pulumi.get(__ret__, 'event_summary'),
        event_summary_contains=pulumi.get(__ret__, 'event_summary_contains'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_managed_by_autonomous_linux=pulumi.get(__ret__, 'is_managed_by_autonomous_linux'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created_greater_than_or_equal_to=pulumi.get(__ret__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__ret__, 'time_created_less_than'),
        types=pulumi.get(__ret__, 'types'))


@_utilities.lift_output_func(get_events)
def get_events_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                      event_fingerprint: Optional[pulumi.Input[Optional[str]]] = None,
                      event_summary: Optional[pulumi.Input[Optional[str]]] = None,
                      event_summary_contains: Optional[pulumi.Input[Optional[str]]] = None,
                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetEventsFilterArgs', 'GetEventsFilterArgsDict']]]]] = None,
                      id: Optional[pulumi.Input[Optional[str]]] = None,
                      is_managed_by_autonomous_linux: Optional[pulumi.Input[Optional[bool]]] = None,
                      resource_id: Optional[pulumi.Input[Optional[str]]] = None,
                      state: Optional[pulumi.Input[Optional[str]]] = None,
                      time_created_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                      time_created_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                      types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEventsResult]:
    """
    This data source provides the list of Events in Oracle Cloud Infrastructure Os Management Hub service.

    Lists events that match the specified criteria, such as compartment, state, and event type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_events = oci.OsManagementHub.get_events(compartment_id=compartment_id,
        event_fingerprint=event_event_fingerprint,
        event_summary=event_event_summary,
        event_summary_contains=event_event_summary_contains,
        id=event_id,
        is_managed_by_autonomous_linux=event_is_managed_by_autonomous_linux,
        resource_id=test_resource["id"],
        state=event_state,
        time_created_greater_than_or_equal_to=event_time_created_greater_than_or_equal_to,
        time_created_less_than=event_time_created_less_than,
        types=event_type)
    ```


    :param str compartment_id: The OCID of the compartment that contains the resources to list. This filter returns only resources contained within the specified compartment.
    :param str event_fingerprint: The eventFingerprint of the KernelEventData.
    :param str event_summary: A filter to return only events whose summary matches the given value.
    :param str event_summary_contains: A filter to return only events with a summary that contains the value provided.
    :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the event.
    :param bool is_managed_by_autonomous_linux: Indicates whether to list only resources managed by the Autonomous Linux service.
    :param str resource_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource. This filter returns resources associated with the specified resource.
    :param str state: A filter to return only events that match the state provided. The state value is case-insensitive.
    :param str time_created_greater_than_or_equal_to: A filter that returns events that occurred on or after the date provided.       Example: `2016-08-25T21:10:29.600Z`
    :param str time_created_less_than: A filter that returns events that occurred on or before the date provided.       Example: `2016-08-25T21:10:29.600Z`
    :param Sequence[str] types: A filter to return only resources whose type matches the given value.
    """
    ...
