# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagementStationResult',
    'AwaitableGetManagementStationResult',
    'get_management_station',
    'get_management_station_output',
]

@pulumi.output_type
class GetManagementStationResult:
    """
    A collection of values returned by getManagementStation.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, healths=None, hostname=None, id=None, managed_instance_id=None, management_station_id=None, mirror_capacity=None, mirror_sync_statuses=None, mirrors=None, overall_percentage=None, overall_state=None, profile_id=None, proxies=None, refresh_trigger=None, scheduled_job_id=None, state=None, system_tags=None, total_mirrors=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if healths and not isinstance(healths, list):
            raise TypeError("Expected argument 'healths' to be a list")
        pulumi.set(__self__, "healths", healths)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_instance_id and not isinstance(managed_instance_id, str):
            raise TypeError("Expected argument 'managed_instance_id' to be a str")
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if management_station_id and not isinstance(management_station_id, str):
            raise TypeError("Expected argument 'management_station_id' to be a str")
        pulumi.set(__self__, "management_station_id", management_station_id)
        if mirror_capacity and not isinstance(mirror_capacity, int):
            raise TypeError("Expected argument 'mirror_capacity' to be a int")
        pulumi.set(__self__, "mirror_capacity", mirror_capacity)
        if mirror_sync_statuses and not isinstance(mirror_sync_statuses, list):
            raise TypeError("Expected argument 'mirror_sync_statuses' to be a list")
        pulumi.set(__self__, "mirror_sync_statuses", mirror_sync_statuses)
        if mirrors and not isinstance(mirrors, list):
            raise TypeError("Expected argument 'mirrors' to be a list")
        pulumi.set(__self__, "mirrors", mirrors)
        if overall_percentage and not isinstance(overall_percentage, int):
            raise TypeError("Expected argument 'overall_percentage' to be a int")
        pulumi.set(__self__, "overall_percentage", overall_percentage)
        if overall_state and not isinstance(overall_state, str):
            raise TypeError("Expected argument 'overall_state' to be a str")
        pulumi.set(__self__, "overall_state", overall_state)
        if profile_id and not isinstance(profile_id, str):
            raise TypeError("Expected argument 'profile_id' to be a str")
        pulumi.set(__self__, "profile_id", profile_id)
        if proxies and not isinstance(proxies, list):
            raise TypeError("Expected argument 'proxies' to be a list")
        pulumi.set(__self__, "proxies", proxies)
        if refresh_trigger and not isinstance(refresh_trigger, int):
            raise TypeError("Expected argument 'refresh_trigger' to be a int")
        pulumi.set(__self__, "refresh_trigger", refresh_trigger)
        if scheduled_job_id and not isinstance(scheduled_job_id, str):
            raise TypeError("Expected argument 'scheduled_job_id' to be a str")
        pulumi.set(__self__, "scheduled_job_id", scheduled_job_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if total_mirrors and not isinstance(total_mirrors, int):
            raise TypeError("Expected argument 'total_mirrors' to be a int")
        pulumi.set(__self__, "total_mirrors", total_mirrors)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the management station.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Explanation of the health status.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name for the management station.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def healths(self) -> Sequence['outputs.GetManagementStationHealthResult']:
        """
        Overall health information of the management station.
        """
        return pulumi.get(self, "healths")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Hostname of the management station.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance that is acting as the management station.
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter(name="managementStationId")
    def management_station_id(self) -> str:
        return pulumi.get(self, "management_station_id")

    @property
    @pulumi.getter(name="mirrorCapacity")
    def mirror_capacity(self) -> int:
        """
        A decimal number representing the amount of mirror capacity used by the sync.
        """
        return pulumi.get(self, "mirror_capacity")

    @property
    @pulumi.getter(name="mirrorSyncStatuses")
    def mirror_sync_statuses(self) -> Sequence['outputs.GetManagementStationMirrorSyncStatusResult']:
        """
        Status summary of the mirror sync.
        """
        return pulumi.get(self, "mirror_sync_statuses")

    @property
    @pulumi.getter
    def mirrors(self) -> Sequence['outputs.GetManagementStationMirrorResult']:
        """
        Mirror information used for the management station configuration.
        """
        return pulumi.get(self, "mirrors")

    @property
    @pulumi.getter(name="overallPercentage")
    def overall_percentage(self) -> int:
        """
        A decimal number representing the progress of the current mirror sync.
        """
        return pulumi.get(self, "overall_percentage")

    @property
    @pulumi.getter(name="overallState")
    def overall_state(self) -> str:
        """
        Current state of the mirror sync for the management station.
        """
        return pulumi.get(self, "overall_state")

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the registration profile used for the management station.
        """
        return pulumi.get(self, "profile_id")

    @property
    @pulumi.getter
    def proxies(self) -> Sequence['outputs.GetManagementStationProxyResult']:
        """
        Proxy information used for the management station configuration.
        """
        return pulumi.get(self, "proxies")

    @property
    @pulumi.getter(name="refreshTrigger")
    def refresh_trigger(self) -> int:
        return pulumi.get(self, "refresh_trigger")

    @property
    @pulumi.getter(name="scheduledJobId")
    def scheduled_job_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the scheduled job for the mirror sync.
        """
        return pulumi.get(self, "scheduled_job_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the management station.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="totalMirrors")
    def total_mirrors(self) -> int:
        """
        The number of software sources that the station is mirroring.
        """
        return pulumi.get(self, "total_mirrors")


class AwaitableGetManagementStationResult(GetManagementStationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagementStationResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            healths=self.healths,
            hostname=self.hostname,
            id=self.id,
            managed_instance_id=self.managed_instance_id,
            management_station_id=self.management_station_id,
            mirror_capacity=self.mirror_capacity,
            mirror_sync_statuses=self.mirror_sync_statuses,
            mirrors=self.mirrors,
            overall_percentage=self.overall_percentage,
            overall_state=self.overall_state,
            profile_id=self.profile_id,
            proxies=self.proxies,
            refresh_trigger=self.refresh_trigger,
            scheduled_job_id=self.scheduled_job_id,
            state=self.state,
            system_tags=self.system_tags,
            total_mirrors=self.total_mirrors)


def get_management_station(management_station_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagementStationResult:
    """
    This data source provides details about a specific Management Station resource in Oracle Cloud Infrastructure Os Management Hub service.

    Gets information about the specified management station.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_station = oci.OsManagementHub.get_management_station(management_station_id=test_management_station_oci_os_management_hub_management_station["id"])
    ```


    :param str management_station_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station.
    """
    __args__ = dict()
    __args__['managementStationId'] = management_station_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getManagementStation:getManagementStation', __args__, opts=opts, typ=GetManagementStationResult).value

    return AwaitableGetManagementStationResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        healths=pulumi.get(__ret__, 'healths'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        managed_instance_id=pulumi.get(__ret__, 'managed_instance_id'),
        management_station_id=pulumi.get(__ret__, 'management_station_id'),
        mirror_capacity=pulumi.get(__ret__, 'mirror_capacity'),
        mirror_sync_statuses=pulumi.get(__ret__, 'mirror_sync_statuses'),
        mirrors=pulumi.get(__ret__, 'mirrors'),
        overall_percentage=pulumi.get(__ret__, 'overall_percentage'),
        overall_state=pulumi.get(__ret__, 'overall_state'),
        profile_id=pulumi.get(__ret__, 'profile_id'),
        proxies=pulumi.get(__ret__, 'proxies'),
        refresh_trigger=pulumi.get(__ret__, 'refresh_trigger'),
        scheduled_job_id=pulumi.get(__ret__, 'scheduled_job_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        total_mirrors=pulumi.get(__ret__, 'total_mirrors'))


@_utilities.lift_output_func(get_management_station)
def get_management_station_output(management_station_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagementStationResult]:
    """
    This data source provides details about a specific Management Station resource in Oracle Cloud Infrastructure Os Management Hub service.

    Gets information about the specified management station.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_station = oci.OsManagementHub.get_management_station(management_station_id=test_management_station_oci_os_management_hub_management_station["id"])
    ```


    :param str management_station_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management station.
    """
    ...
