# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWindowsUpdatesResult',
    'AwaitableGetWindowsUpdatesResult',
    'get_windows_updates',
    'get_windows_updates_output',
]

@pulumi.output_type
class GetWindowsUpdatesResult:
    """
    A collection of values returned by getWindowsUpdates.
    """
    def __init__(__self__, classification_types=None, compartment_id=None, display_name_contains=None, filters=None, id=None, names=None, windows_update_collections=None):
        if classification_types and not isinstance(classification_types, list):
            raise TypeError("Expected argument 'classification_types' to be a list")
        pulumi.set(__self__, "classification_types", classification_types)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if windows_update_collections and not isinstance(windows_update_collections, list):
            raise TypeError("Expected argument 'windows_update_collections' to be a list")
        pulumi.set(__self__, "windows_update_collections", windows_update_collections)

    @property
    @pulumi.getter(name="classificationTypes")
    def classification_types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "classification_types")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetWindowsUpdatesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        Name of the Windows update.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="windowsUpdateCollections")
    def windows_update_collections(self) -> Sequence['outputs.GetWindowsUpdatesWindowsUpdateCollectionResult']:
        """
        The list of windows_update_collection.
        """
        return pulumi.get(self, "windows_update_collections")


class AwaitableGetWindowsUpdatesResult(GetWindowsUpdatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWindowsUpdatesResult(
            classification_types=self.classification_types,
            compartment_id=self.compartment_id,
            display_name_contains=self.display_name_contains,
            filters=self.filters,
            id=self.id,
            names=self.names,
            windows_update_collections=self.windows_update_collections)


def get_windows_updates(classification_types: Optional[Sequence[str]] = None,
                        compartment_id: Optional[str] = None,
                        display_name_contains: Optional[str] = None,
                        filters: Optional[Sequence[Union['GetWindowsUpdatesFilterArgs', 'GetWindowsUpdatesFilterArgsDict']]] = None,
                        names: Optional[Sequence[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWindowsUpdatesResult:
    """
    This data source provides the list of Windows Updates in Oracle Cloud Infrastructure Os Management Hub service.

    Lists Windows updates that have been reported to the service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_windows_updates = oci.OsManagementHub.get_windows_updates(compartment_id=compartment_id,
        classification_types=windows_update_classification_type,
        display_name_contains=windows_update_display_name_contains,
        names=windows_update_name)
    ```


    :param Sequence[str] classification_types: A filter to return only packages that match the given update classification type.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment. This parameter is required and returns only resources contained within the specified compartment.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[str] names: A filter based on the unique identifier for the Windows update. Note that this is not an OCID, but is a unique identifier assigned by Microsoft.  Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'
    """
    __args__ = dict()
    __args__['classificationTypes'] = classification_types
    __args__['compartmentId'] = compartment_id
    __args__['displayNameContains'] = display_name_contains
    __args__['filters'] = filters
    __args__['names'] = names
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getWindowsUpdates:getWindowsUpdates', __args__, opts=opts, typ=GetWindowsUpdatesResult).value

    return AwaitableGetWindowsUpdatesResult(
        classification_types=pulumi.get(__ret__, 'classification_types'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        names=pulumi.get(__ret__, 'names'),
        windows_update_collections=pulumi.get(__ret__, 'windows_update_collections'))


@_utilities.lift_output_func(get_windows_updates)
def get_windows_updates_output(classification_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                               compartment_id: Optional[pulumi.Input[str]] = None,
                               display_name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[Union['GetWindowsUpdatesFilterArgs', 'GetWindowsUpdatesFilterArgsDict']]]]] = None,
                               names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetWindowsUpdatesResult]:
    """
    This data source provides the list of Windows Updates in Oracle Cloud Infrastructure Os Management Hub service.

    Lists Windows updates that have been reported to the service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_windows_updates = oci.OsManagementHub.get_windows_updates(compartment_id=compartment_id,
        classification_types=windows_update_classification_type,
        display_name_contains=windows_update_display_name_contains,
        names=windows_update_name)
    ```


    :param Sequence[str] classification_types: A filter to return only packages that match the given update classification type.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment. This parameter is required and returns only resources contained within the specified compartment.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param Sequence[str] names: A filter based on the unique identifier for the Windows update. Note that this is not an OCID, but is a unique identifier assigned by Microsoft.  Example: '6981d463-cd91-4a26-b7c4-ea4ded9183ed'
    """
    ...
