"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BudgetNotifier = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_budgets_1 = require("aws-cdk-lib/aws-budgets");
const constructs_1 = require("constructs");
const notificationType_1 = require("./notificationType");
const timeUnit_1 = require("./timeUnit");
class BudgetNotifier extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.validateProperties(props);
        const costFilters = this.createCostFilters(props);
        const subscribers = this.createSubscribers(props);
        new aws_budgets_1.CfnBudget(this, 'MonthlyBudget_' + id, {
            budget: {
                budgetType: 'COST',
                timeUnit: props.timeUnit ? props.timeUnit : timeUnit_1.TimeUnit.MONTHLY,
                budgetLimit: {
                    amount: props.limit,
                    unit: props.unit,
                },
                costFilters: costFilters,
            },
            notificationsWithSubscribers: [
                {
                    notification: {
                        comparisonOperator: 'GREATER_THAN',
                        threshold: props.threshold,
                        thresholdType: 'PERCENTAGE',
                        notificationType: props.notificationType
                            ? props.notificationType
                            : notificationType_1.NotificationType.ACTUAL,
                    },
                    subscribers: subscribers,
                },
            ],
        });
    }
    validateProperties(props) {
        if (props.recipients && props.recipients.length > 10) {
            throw new Error('The maximum number of 10 e-mail recipients is exceeded.');
        }
        if (props.threshold <= 0) {
            throw new Error('Thresholds less than or equal to 0 are not allowed.');
        }
    }
    createSubscribers(props) {
        const subscribers = new Array();
        if (props.recipients) {
            for (const recipient of props.recipients) {
                subscribers.push({
                    address: recipient,
                    subscriptionType: 'EMAIL',
                });
            }
        }
        if (props.topicArn) {
            subscribers.push({
                address: props.topicArn,
                subscriptionType: 'SNS',
            });
        }
        return subscribers;
    }
    createCostFilters(props) {
        const tags = [];
        if (props.application) {
            tags.push('user:Application$' + props.application);
        }
        if (props.costCenter) {
            tags.push('user:Cost Center$' + props.costCenter);
        }
        if (props.service) {
            tags.push('user:Service$' + props.service);
        }
        const costFilters = {};
        if (tags && tags.length > 0) {
            costFilters.TagKeyValue = tags;
        }
        const availabilityZones = [];
        if (props.availabilityZones) {
            for (const az of props.availabilityZones) {
                availabilityZones.push(az);
            }
            costFilters.AZ = availabilityZones;
        }
        return costFilters;
    }
}
exports.BudgetNotifier = BudgetNotifier;
_a = JSII_RTTI_SYMBOL_1;
BudgetNotifier[_a] = { fqn: "aws_budget_notifier.BudgetNotifier", version: "0.3.18" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYnVkZ2V0Tm90aWZpZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvYnVkZ2V0Tm90aWZpZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSx5REFBb0Q7QUFDcEQsMkNBQXVDO0FBQ3ZDLHlEQUFzRDtBQUN0RCx5Q0FBc0M7QUEwRHRDLE1BQWEsY0FBZSxTQUFRLHNCQUFTO0lBQzNDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBMEI7UUFDbEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLENBQUMsa0JBQWtCLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFL0IsTUFBTSxXQUFXLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ2xELE1BQU0sV0FBVyxHQUFHLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUVsRCxJQUFJLHVCQUFTLENBQUMsSUFBSSxFQUFFLGdCQUFnQixHQUFHLEVBQUUsRUFBRTtZQUN6QyxNQUFNLEVBQUU7Z0JBQ04sVUFBVSxFQUFFLE1BQU07Z0JBQ2xCLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxtQkFBUSxDQUFDLE9BQU87Z0JBQzVELFdBQVcsRUFBRTtvQkFDWCxNQUFNLEVBQUUsS0FBSyxDQUFDLEtBQUs7b0JBQ25CLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSTtpQkFDakI7Z0JBQ0QsV0FBVyxFQUFFLFdBQVc7YUFDekI7WUFFRCw0QkFBNEIsRUFBRTtnQkFDNUI7b0JBQ0UsWUFBWSxFQUFFO3dCQUNaLGtCQUFrQixFQUFFLGNBQWM7d0JBQ2xDLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUzt3QkFDMUIsYUFBYSxFQUFFLFlBQVk7d0JBQzNCLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxnQkFBZ0I7NEJBQ3RDLENBQUMsQ0FBQyxLQUFLLENBQUMsZ0JBQWdCOzRCQUN4QixDQUFDLENBQUMsbUNBQWdCLENBQUMsTUFBTTtxQkFDNUI7b0JBQ0QsV0FBVyxFQUFFLFdBQVc7aUJBQ3pCO2FBQ0Y7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU8sa0JBQWtCLENBQUMsS0FBMEI7UUFDbkQsSUFBSSxLQUFLLENBQUMsVUFBVSxJQUFJLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxHQUFHLEVBQUUsRUFBRTtZQUNwRCxNQUFNLElBQUksS0FBSyxDQUNiLHlEQUF5RCxDQUMxRCxDQUFDO1NBQ0g7UUFFRCxJQUFJLEtBQUssQ0FBQyxTQUFTLElBQUksQ0FBQyxFQUFFO1lBQ3hCLE1BQU0sSUFBSSxLQUFLLENBQUMscURBQXFELENBQUMsQ0FBQztTQUN4RTtJQUNILENBQUM7SUFFTyxpQkFBaUIsQ0FBQyxLQUEwQjtRQUNsRCxNQUFNLFdBQVcsR0FBRyxJQUFJLEtBQUssRUFBZ0MsQ0FBQztRQUM5RCxJQUFJLEtBQUssQ0FBQyxVQUFVLEVBQUU7WUFDcEIsS0FBSyxNQUFNLFNBQVMsSUFBSSxLQUFLLENBQUMsVUFBVSxFQUFFO2dCQUN4QyxXQUFXLENBQUMsSUFBSSxDQUFDO29CQUNmLE9BQU8sRUFBRSxTQUFTO29CQUNsQixnQkFBZ0IsRUFBRSxPQUFPO2lCQUMxQixDQUFDLENBQUM7YUFDSjtTQUNGO1FBQ0QsSUFBSSxLQUFLLENBQUMsUUFBUSxFQUFFO1lBQ2xCLFdBQVcsQ0FBQyxJQUFJLENBQUM7Z0JBQ2YsT0FBTyxFQUFFLEtBQUssQ0FBQyxRQUFRO2dCQUN2QixnQkFBZ0IsRUFBRSxLQUFLO2FBQ3hCLENBQUMsQ0FBQztTQUNKO1FBRUQsT0FBTyxXQUFXLENBQUM7SUFDckIsQ0FBQztJQUVPLGlCQUFpQixDQUFDLEtBQTBCO1FBQ2xELE1BQU0sSUFBSSxHQUFrQixFQUFFLENBQUM7UUFDL0IsSUFBSSxLQUFLLENBQUMsV0FBVyxFQUFFO1lBQ3JCLElBQUksQ0FBQyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQyxDQUFDO1NBQ3BEO1FBRUQsSUFBSSxLQUFLLENBQUMsVUFBVSxFQUFFO1lBQ3BCLElBQUksQ0FBQyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQyxDQUFDO1NBQ25EO1FBRUQsSUFBSSxLQUFLLENBQUMsT0FBTyxFQUFFO1lBQ2pCLElBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztTQUM1QztRQUVELE1BQU0sV0FBVyxHQUFRLEVBQUUsQ0FBQztRQUU1QixJQUFJLElBQUksSUFBSSxJQUFJLENBQUMsTUFBTSxHQUFDLENBQUMsRUFBRTtZQUN6QixXQUFXLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQztTQUNoQztRQUNELE1BQU0saUJBQWlCLEdBQWtCLEVBQUUsQ0FBQztRQUM1QyxJQUFJLEtBQUssQ0FBQyxpQkFBaUIsRUFBRTtZQUMzQixLQUFLLE1BQU0sRUFBRSxJQUFJLEtBQUssQ0FBQyxpQkFBaUIsRUFBRTtnQkFDeEMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDO2FBQzVCO1lBQ0QsV0FBVyxDQUFDLEVBQUUsR0FBRyxpQkFBaUIsQ0FBQztTQUNwQztRQUNELE9BQU8sV0FBVyxDQUFDO0lBQ3JCLENBQUM7O0FBL0ZILHdDQWdHQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENmbkJ1ZGdldCB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1idWRnZXRzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgTm90aWZpY2F0aW9uVHlwZSB9IGZyb20gJy4vbm90aWZpY2F0aW9uVHlwZSc7XG5pbXBvcnQgeyBUaW1lVW5pdCB9IGZyb20gJy4vdGltZVVuaXQnO1xuXG4vKipcbiAqIENvbmZpZ3VyYXRpb24gb3B0aW9ucyBvZiB0aGUge0BsaW5rIEJ1ZGdldE5vdGlmaWVyIHwgQnVkZ2V0Tm90aWZpZXJ9LlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEJ1ZGdldE5vdGlmaWVyUHJvcHMge1xuICAvKipcbiAgICogQnVkZ2V0IG5vdGlmaWNhdGlvbnMgd2lsbCBiZSBzZW50IHRvIGVhY2ggb2YgdGhlIHJlY2lwaWVudHMgKGUtbWFpbCBhZGRyZXNzZXMpLlxuICAgKiBBIG1heGltdW0gb2YgMTAgcmVjaXBpZW50cyBpcyBhbGxvd2VkLlxuICAgKi9cbiAgcmVhZG9ubHkgcmVjaXBpZW50cz86IEFycmF5PHN0cmluZz47XG5cbiAgLypcbiAgICogQnVkZ2V0IG5vdGlmaWNhdGlvbnMgd2lsbCBiZSBzZW50IHRvIHRoaXMgU05TIHRvcGljLiBUaGUgdG9waWMgc2hvdWxkIGFscmVhZHkgZXhpc3QgYW5kIG5lZWRzIHRvIGhhdmUgdGhlXG4gICAqIGNvcnJlY3QgcmVzb3VyY2UgcG9saWN5IHNldHVwIChBbGxvdyBzZXJ2aWNlIHByaW5jaXBhbCB0byBTTlM6UHVibGlzaCB0byB0aGUgdG9waWMpXG4gICAqL1xuICByZWFkb25seSB0b3BpY0Fybj86IHN0cmluZztcbiAgLyoqXG4gICAqIElmIHNwZWNpZmllZCB0aGUgYXZhaWxhYmlsaXR5IHpvbmVzIHdpbGwgYmUgYWRkZWQgYXMgdGFnIGZpbHRlci5cbiAgICovXG4gIHJlYWRvbmx5IGF2YWlsYWJpbGl0eVpvbmVzPzogQXJyYXk8c3RyaW5nPjtcbiAgLyoqXG4gICAqIElmIHNwZWNpZmllZCB0aGUgYXBwbGljYXRpb24gbmFtZSB3aWxsIGJlIGFkZGVkIGFzIHRhZyBmaWx0ZXIuXG4gICAqL1xuICByZWFkb25seSBhcHBsaWNhdGlvbj86IHN0cmluZztcbiAgLyoqXG4gICAqIElmIHNwZWNpZmllZCB0aGUgY29zdCBjZW50ZXIgd2lsbCBiZSBhZGRlZCBhcyB0YWcgZmlsdGVyLlxuICAgKi9cbiAgcmVhZG9ubHkgY29zdENlbnRlcj86IHN0cmluZztcblxuICAvKipcbiAgICogSWYgc3BlY2lmaWVkIHRoZSBzZXJ2aWNlIHdpbGwgYmUgYWRkZWQgYXMgdGFnIGZpbHRlci5cbiAgICovXG4gIHJlYWRvbmx5IHNlcnZpY2U/OiBzdHJpbmc7XG4gIC8qKlxuICAgKiBUaGUgdGhyZXNob2xkIHZhbHVlIGluIHBlcmNlbnQgKDAtMTAwKS5cbiAgICovXG4gIHJlYWRvbmx5IHRocmVzaG9sZDogbnVtYmVyO1xuICAvKipcbiAgICogVGhlIGxlbmd0aCBvZiB0aW1lIHVudGlsIGEgYnVkZ2V0IHJlc2V0cyB0aGUgYWN0dWFsIGFuZCBmb3JlY2FzdGVkIHNwZW5kLlxuICAgKiBAc2VlIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtYnVkZ2V0cy1idWRnZXQtYnVkZ2V0ZGF0YS5odG1sI2Nmbi1idWRnZXRzLWJ1ZGdldC1idWRnZXRkYXRhLXRpbWV1bml0XG4gICAqL1xuICByZWFkb25seSB0aW1lVW5pdD86IFRpbWVVbml0O1xuICAvKipcbiAgICogVGhlIGNvc3QgYXNzb2NpYXRlZCB3aXRoIHRoZSBidWRnZXQgdGhyZXNob2xkLlxuICAgKi9cbiAgcmVhZG9ubHkgbGltaXQ6IG51bWJlcjtcbiAgLyoqXG4gICAqIFRoZSB1bml0IG9mIG1lYXN1cmVtZW50IHRoYXQgaXMgdXNlZCBmb3IgdGhlIGJ1ZGdldCB0aHJlc2hvbGQsIHN1Y2ggYXMgZG9sbGFycyBvciBHQi5cbiAgICovXG4gIHJlYWRvbmx5IHVuaXQ6IHN0cmluZztcbiAgLyoqXG4gICAqIFdoZXRoZXIgdGhlIG5vdGlmaWNhdGlvbiBpcyBmb3IgaG93IG11Y2ggeW91IGhhdmUgc3BlbnQgKEFDVFVBTCkgb3IgZm9yIGhvdyBtdWNoIHlvdSdyZSBmb3JlY2FzdGVkIHRvIHNwZW5kIChGT1JFQ0FTVEVEKS5cbiAgICogQHNlZSBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWJ1ZGdldHMtYnVkZ2V0LW5vdGlmaWNhdGlvbi5odG1sI2Nmbi1idWRnZXRzLWJ1ZGdldC1ub3RpZmljYXRpb24tbm90aWZpY2F0aW9udHlwZVxuICAgKi9cbiAgcmVhZG9ubHkgbm90aWZpY2F0aW9uVHlwZT86IE5vdGlmaWNhdGlvblR5cGU7XG59XG5cbmV4cG9ydCBjbGFzcyBCdWRnZXROb3RpZmllciBleHRlbmRzIENvbnN0cnVjdCB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBCdWRnZXROb3RpZmllclByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHRoaXMudmFsaWRhdGVQcm9wZXJ0aWVzKHByb3BzKTtcblxuICAgIGNvbnN0IGNvc3RGaWx0ZXJzID0gdGhpcy5jcmVhdGVDb3N0RmlsdGVycyhwcm9wcyk7XG4gICAgY29uc3Qgc3Vic2NyaWJlcnMgPSB0aGlzLmNyZWF0ZVN1YnNjcmliZXJzKHByb3BzKTtcblxuICAgIG5ldyBDZm5CdWRnZXQodGhpcywgJ01vbnRobHlCdWRnZXRfJyArIGlkLCB7XG4gICAgICBidWRnZXQ6IHtcbiAgICAgICAgYnVkZ2V0VHlwZTogJ0NPU1QnLFxuICAgICAgICB0aW1lVW5pdDogcHJvcHMudGltZVVuaXQgPyBwcm9wcy50aW1lVW5pdCA6IFRpbWVVbml0Lk1PTlRITFksXG4gICAgICAgIGJ1ZGdldExpbWl0OiB7XG4gICAgICAgICAgYW1vdW50OiBwcm9wcy5saW1pdCxcbiAgICAgICAgICB1bml0OiBwcm9wcy51bml0LFxuICAgICAgICB9LFxuICAgICAgICBjb3N0RmlsdGVyczogY29zdEZpbHRlcnMsXG4gICAgICB9LFxuXG4gICAgICBub3RpZmljYXRpb25zV2l0aFN1YnNjcmliZXJzOiBbXG4gICAgICAgIHtcbiAgICAgICAgICBub3RpZmljYXRpb246IHtcbiAgICAgICAgICAgIGNvbXBhcmlzb25PcGVyYXRvcjogJ0dSRUFURVJfVEhBTicsXG4gICAgICAgICAgICB0aHJlc2hvbGQ6IHByb3BzLnRocmVzaG9sZCxcbiAgICAgICAgICAgIHRocmVzaG9sZFR5cGU6ICdQRVJDRU5UQUdFJyxcbiAgICAgICAgICAgIG5vdGlmaWNhdGlvblR5cGU6IHByb3BzLm5vdGlmaWNhdGlvblR5cGVcbiAgICAgICAgICAgICAgPyBwcm9wcy5ub3RpZmljYXRpb25UeXBlXG4gICAgICAgICAgICAgIDogTm90aWZpY2F0aW9uVHlwZS5BQ1RVQUwsXG4gICAgICAgICAgfSxcbiAgICAgICAgICBzdWJzY3JpYmVyczogc3Vic2NyaWJlcnMsXG4gICAgICAgIH0sXG4gICAgICBdLFxuICAgIH0pO1xuICB9XG5cbiAgcHJpdmF0ZSB2YWxpZGF0ZVByb3BlcnRpZXMocHJvcHM6IEJ1ZGdldE5vdGlmaWVyUHJvcHMpOiB2b2lkIHtcbiAgICBpZiAocHJvcHMucmVjaXBpZW50cyAmJiBwcm9wcy5yZWNpcGllbnRzLmxlbmd0aCA+IDEwKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICAgICdUaGUgbWF4aW11bSBudW1iZXIgb2YgMTAgZS1tYWlsIHJlY2lwaWVudHMgaXMgZXhjZWVkZWQuJyxcbiAgICAgICk7XG4gICAgfVxuXG4gICAgaWYgKHByb3BzLnRocmVzaG9sZCA8PSAwKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1RocmVzaG9sZHMgbGVzcyB0aGFuIG9yIGVxdWFsIHRvIDAgYXJlIG5vdCBhbGxvd2VkLicpO1xuICAgIH1cbiAgfVxuXG4gIHByaXZhdGUgY3JlYXRlU3Vic2NyaWJlcnMocHJvcHM6IEJ1ZGdldE5vdGlmaWVyUHJvcHMpIHtcbiAgICBjb25zdCBzdWJzY3JpYmVycyA9IG5ldyBBcnJheTxDZm5CdWRnZXQuU3Vic2NyaWJlclByb3BlcnR5PigpO1xuICAgIGlmIChwcm9wcy5yZWNpcGllbnRzKSB7XG4gICAgICBmb3IgKGNvbnN0IHJlY2lwaWVudCBvZiBwcm9wcy5yZWNpcGllbnRzKSB7XG4gICAgICAgIHN1YnNjcmliZXJzLnB1c2goe1xuICAgICAgICAgIGFkZHJlc3M6IHJlY2lwaWVudCxcbiAgICAgICAgICBzdWJzY3JpcHRpb25UeXBlOiAnRU1BSUwnLFxuICAgICAgICB9KTtcbiAgICAgIH1cbiAgICB9XG4gICAgaWYgKHByb3BzLnRvcGljQXJuKSB7XG4gICAgICBzdWJzY3JpYmVycy5wdXNoKHtcbiAgICAgICAgYWRkcmVzczogcHJvcHMudG9waWNBcm4sXG4gICAgICAgIHN1YnNjcmlwdGlvblR5cGU6ICdTTlMnLFxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgcmV0dXJuIHN1YnNjcmliZXJzO1xuICB9XG5cbiAgcHJpdmF0ZSBjcmVhdGVDb3N0RmlsdGVycyhwcm9wczogQnVkZ2V0Tm90aWZpZXJQcm9wcykge1xuICAgIGNvbnN0IHRhZ3M6IEFycmF5PHN0cmluZz4gPSBbXTtcbiAgICBpZiAocHJvcHMuYXBwbGljYXRpb24pIHtcbiAgICAgIHRhZ3MucHVzaCgndXNlcjpBcHBsaWNhdGlvbiQnICsgcHJvcHMuYXBwbGljYXRpb24pO1xuICAgIH1cblxuICAgIGlmIChwcm9wcy5jb3N0Q2VudGVyKSB7XG4gICAgICB0YWdzLnB1c2goJ3VzZXI6Q29zdCBDZW50ZXIkJyArIHByb3BzLmNvc3RDZW50ZXIpO1xuICAgIH1cblxuICAgIGlmIChwcm9wcy5zZXJ2aWNlKSB7XG4gICAgICB0YWdzLnB1c2goJ3VzZXI6U2VydmljZSQnICsgcHJvcHMuc2VydmljZSk7XG4gICAgfVxuXG4gICAgY29uc3QgY29zdEZpbHRlcnM6IGFueSA9IHt9O1xuXG4gICAgaWYgKHRhZ3MgJiYgdGFncy5sZW5ndGg+MCkge1xuICAgICAgY29zdEZpbHRlcnMuVGFnS2V5VmFsdWUgPSB0YWdzO1xuICAgIH1cbiAgICBjb25zdCBhdmFpbGFiaWxpdHlab25lczogQXJyYXk8c3RyaW5nPiA9IFtdO1xuICAgIGlmIChwcm9wcy5hdmFpbGFiaWxpdHlab25lcykge1xuICAgICAgZm9yIChjb25zdCBheiBvZiBwcm9wcy5hdmFpbGFiaWxpdHlab25lcykge1xuICAgICAgICBhdmFpbGFiaWxpdHlab25lcy5wdXNoKGF6KTtcbiAgICAgIH1cbiAgICAgIGNvc3RGaWx0ZXJzLkFaID0gYXZhaWxhYmlsaXR5Wm9uZXM7XG4gICAgfVxuICAgIHJldHVybiBjb3N0RmlsdGVycztcbiAgfVxufVxuIl19