#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_sns_1 = require("aws-cdk-lib/aws-sns");
const budgetNotifier_1 = require("./budgetNotifier");
const notificationType_1 = require("./notificationType");
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, 'BudgetNotifierStack');
const topic = new aws_sns_1.Topic(stack, 'topic');
const statement = new aws_iam_1.PolicyStatement({
    effect: aws_iam_1.Effect.ALLOW,
    principals: [new aws_iam_1.ServicePrincipal('budgets.amazonaws.com')],
    actions: ['SNS:Publish'],
    sid: 'Allow budget to publish to SNS',
    resources: [topic.topicArn],
});
topic.addToResourcePolicy(statement);
new budgetNotifier_1.BudgetNotifier(stack, 'notifier', {
    topicArn: topic.topicArn,
    availabilityZones: ['eu-central-1'],
    costCenter: 'MyCostCenter',
    limit: 10,
    unit: 'USD',
    threshold: 15,
    notificationType: notificationType_1.NotificationType.FORECASTED,
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYnVkZ2V0Tm90aWZpZXJTdGFjay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9idWRnZXROb3RpZmllclN0YWNrLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLDZDQUF5QztBQUN6QyxpREFBZ0Y7QUFDaEYsaURBQTRDO0FBRTVDLHFEQUFrRDtBQUNsRCx5REFBc0Q7QUFFdEQsTUFBTSxHQUFHLEdBQUcsSUFBSSxpQkFBRyxFQUFFLENBQUM7QUFDdEIsTUFBTSxLQUFLLEdBQUcsSUFBSSxtQkFBSyxDQUFDLEdBQUcsRUFBRSxxQkFBcUIsQ0FBQyxDQUFDO0FBRXBELE1BQU0sS0FBSyxHQUFHLElBQUksZUFBSyxDQUFDLEtBQUssRUFBRSxPQUFPLENBQUMsQ0FBQztBQUV4QyxNQUFNLFNBQVMsR0FBRyxJQUFJLHlCQUFlLENBQUM7SUFDcEMsTUFBTSxFQUFFLGdCQUFNLENBQUMsS0FBSztJQUNwQixVQUFVLEVBQUUsQ0FBQyxJQUFJLDBCQUFnQixDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDM0QsT0FBTyxFQUFFLENBQUMsYUFBYSxDQUFDO0lBQ3hCLEdBQUcsRUFBRSxnQ0FBZ0M7SUFDckMsU0FBUyxFQUFFLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQztDQUM1QixDQUFDLENBQUM7QUFFSCxLQUFLLENBQUMsbUJBQW1CLENBQUMsU0FBUyxDQUFDLENBQUM7QUFFckMsSUFBSSwrQkFBYyxDQUFDLEtBQUssRUFBRSxVQUFVLEVBQUU7SUFDcEMsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO0lBQ3hCLGlCQUFpQixFQUFFLENBQUMsY0FBYyxDQUFDO0lBQ25DLFVBQVUsRUFBRSxjQUFjO0lBQzFCLEtBQUssRUFBRSxFQUFFO0lBQ1QsSUFBSSxFQUFFLEtBQUs7SUFDWCxTQUFTLEVBQUUsRUFBRTtJQUNiLGdCQUFnQixFQUFFLG1DQUFnQixDQUFDLFVBQVU7Q0FDOUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiIyEvdXNyL2Jpbi9lbnYgbm9kZVxuaW1wb3J0IHsgQXBwLCBTdGFjayB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IFBvbGljeVN0YXRlbWVudCwgRWZmZWN0LCBTZXJ2aWNlUHJpbmNpcGFsIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBUb3BpYyB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1zbnMnO1xuXG5pbXBvcnQgeyBCdWRnZXROb3RpZmllciB9IGZyb20gJy4vYnVkZ2V0Tm90aWZpZXInO1xuaW1wb3J0IHsgTm90aWZpY2F0aW9uVHlwZSB9IGZyb20gJy4vbm90aWZpY2F0aW9uVHlwZSc7XG5cbmNvbnN0IGFwcCA9IG5ldyBBcHAoKTtcbmNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKGFwcCwgJ0J1ZGdldE5vdGlmaWVyU3RhY2snKTtcblxuY29uc3QgdG9waWMgPSBuZXcgVG9waWMoc3RhY2ssICd0b3BpYycpO1xuXG5jb25zdCBzdGF0ZW1lbnQgPSBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgZWZmZWN0OiBFZmZlY3QuQUxMT1csXG4gIHByaW5jaXBhbHM6IFtuZXcgU2VydmljZVByaW5jaXBhbCgnYnVkZ2V0cy5hbWF6b25hd3MuY29tJyldLFxuICBhY3Rpb25zOiBbJ1NOUzpQdWJsaXNoJ10sXG4gIHNpZDogJ0FsbG93IGJ1ZGdldCB0byBwdWJsaXNoIHRvIFNOUycsXG4gIHJlc291cmNlczogW3RvcGljLnRvcGljQXJuXSxcbn0pO1xuXG50b3BpYy5hZGRUb1Jlc291cmNlUG9saWN5KHN0YXRlbWVudCk7XG5cbm5ldyBCdWRnZXROb3RpZmllcihzdGFjaywgJ25vdGlmaWVyJywge1xuICB0b3BpY0FybjogdG9waWMudG9waWNBcm4sXG4gIGF2YWlsYWJpbGl0eVpvbmVzOiBbJ2V1LWNlbnRyYWwtMSddLFxuICBjb3N0Q2VudGVyOiAnTXlDb3N0Q2VudGVyJyxcbiAgbGltaXQ6IDEwLFxuICB1bml0OiAnVVNEJyxcbiAgdGhyZXNob2xkOiAxNSxcbiAgbm90aWZpY2F0aW9uVHlwZTogTm90aWZpY2F0aW9uVHlwZS5GT1JFQ0FTVEVELFxufSk7XG4iXX0=