# coding: utf-8

import six

from huaweicloudsdkcore.utils.http_utils import sanitize_for_serialization


class IpAllowList:

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    sensitive_list = []

    openapi_types = {
        'address': 'str',
        'description': 'str'
    }

    attribute_map = {
        'address': 'address',
        'description': 'description'
    }

    def __init__(self, address=None, description=None):
        r"""IpAllowList

        The model defined in huaweicloud sdk

        :param address: **参数说明**：白名单ip地址。 
        :type address: str
        :param description: **参数说明**：描述。 
        :type description: str
        """
        
        

        self._address = None
        self._description = None
        self.discriminator = None

        self.address = address
        if description is not None:
            self.description = description

    @property
    def address(self):
        r"""Gets the address of this IpAllowList.

        **参数说明**：白名单ip地址。 

        :return: The address of this IpAllowList.
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address):
        r"""Sets the address of this IpAllowList.

        **参数说明**：白名单ip地址。 

        :param address: The address of this IpAllowList.
        :type address: str
        """
        self._address = address

    @property
    def description(self):
        r"""Gets the description of this IpAllowList.

        **参数说明**：描述。 

        :return: The description of this IpAllowList.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        r"""Sets the description of this IpAllowList.

        **参数说明**：描述。 

        :param description: The description of this IpAllowList.
        :type description: str
        """
        self._description = description

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                if attr in self.sensitive_list:
                    result[attr] = "****"
                else:
                    result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        import simplejson as json
        if six.PY2:
            import sys
            reload(sys)
            sys.setdefaultencoding("utf-8")
        return json.dumps(sanitize_for_serialization(self), ensure_ascii=False)

    def __repr__(self):
        """For `print`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IpAllowList):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
