"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
/**
 * An immutable wrapper around an IRole
 *
 * This wrapper ignores all mutating operations, like attaching policies or
 * adding policy statements.
 *
 * Useful in cases where you want to turn off CDK's automatic permissions
 * management, and instead have full control over all permissions.
 *
 * Note: if you want to ignore all mutations for an externally defined role
 * which was imported into the CDK with {@link Role.fromRoleArn}, you don't have to use this class -
 * simply pass the property mutable = false when calling {@link Role.fromRoleArn}.
 */
class ImmutableRole {
    constructor(role) {
        this.role = role;
        this.assumeRoleAction = this.role.assumeRoleAction;
        this.policyFragment = this.role.policyFragment;
        this.grantPrincipal = this.role.grantPrincipal;
        this.roleArn = this.role.roleArn;
        this.roleName = this.role.roleName;
        this.node = this.role.node;
        this.stack = this.role.stack;
        // implement IDependable privately
        core_1.DependableTrait.implement(this, {
            dependencyRoots: [role]
        });
    }
    attachInlinePolicy(_policy) {
        // do nothing
    }
    addManagedPolicy(_policy) {
        // do nothing
    }
    addToPolicy(_statement) {
        // Not really added, but for the purposes of consumer code pretend that it was.
        return true;
    }
    grant(grantee, ...actions) {
        return this.role.grant(grantee, ...actions);
    }
    grantPassRole(grantee) {
        return this.role.grantPassRole(grantee);
    }
}
exports.ImmutableRole = ImmutableRole;
//# sourceMappingURL=data:application/json;base64,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