"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
/**
 * An immutable wrapper around an IRole
 *
 * This wrapper ignores all mutating operations, like attaching policies or
 * adding policy statements.
 *
 * Useful in cases where you want to turn off CDK's automatic permissions
 * management, and instead have full control over all permissions.
 *
 * Note: if you want to ignore all mutations for an externally defined role
 * which was imported into the CDK with {@link Role.fromRoleArn}, you don't have to use this class -
 * simply pass the property mutable = false when calling {@link Role.fromRoleArn}.
 */
class ImmutableRole {
    constructor(role) {
        this.role = role;
        this.assumeRoleAction = this.role.assumeRoleAction;
        this.policyFragment = this.role.policyFragment;
        this.grantPrincipal = this;
        this.roleArn = this.role.roleArn;
        this.roleName = this.role.roleName;
        this.node = this.role.node;
        this.stack = this.role.stack;
        // implement IDependable privately
        core_1.DependableTrait.implement(this, {
            dependencyRoots: [role]
        });
    }
    attachInlinePolicy(_policy) {
        // do nothing
    }
    addManagedPolicy(_policy) {
        // do nothing
    }
    addToPolicy(_statement) {
        // Not really added, but for the purposes of consumer code pretend that it was.
        return true;
    }
    grant(grantee, ...actions) {
        return this.role.grant(grantee, ...actions);
    }
    grantPassRole(grantee) {
        return this.role.grantPassRole(grantee);
    }
}
exports.ImmutableRole = ImmutableRole;
//# sourceMappingURL=data:application/json;base64,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