"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyTemplate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const aws_verifiedpermissions_1 = require("aws-cdk-lib/aws-verifiedpermissions");
const core_1 = require("aws-cdk-lib/core");
const cedar_helpers_1 = require("./cedar-helpers");
class PolicyTemplateBase extends core_1.Resource {
}
class PolicyTemplate extends PolicyTemplateBase {
    /**
     * Create a PolicyTemplate construct that represents an external policy template via policy template id.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param policyTemplateId The PolicyTemplate's id.
     */
    static fromPolicyTemplateId(scope, id, policyTemplateId) {
        return PolicyTemplate.fromPolicyTemplateAttributes(scope, id, {
            policyTemplateId,
        });
    }
    /**
     * Creates a PolicyTemplate construct that represents an external Policy Template.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs A `PolicyTemplateAttributes` object.
     */
    static fromPolicyTemplateAttributes(scope, id, attrs) {
        class Import extends PolicyTemplateBase {
            constructor(policyTemplateId) {
                super(scope, id);
                this.policyTemplateId = policyTemplateId;
            }
        }
        let policyTemplateId;
        policyTemplateId = attrs.policyTemplateId;
        return new Import(policyTemplateId);
    }
    static fromFile(scope, id, props) {
        const templateFileContents = fs.readFileSync(props.path).toString();
        (0, cedar_helpers_1.checkParseTemplate)(templateFileContents);
        return new PolicyTemplate(scope, id, {
            statement: templateFileContents,
            description: props.description,
            policyStore: props.policyStore,
        });
    }
    constructor(scope, id, props) {
        super(scope, id);
        (0, cedar_helpers_1.checkParseTemplate)(props.statement);
        this.policyTemplate = new aws_verifiedpermissions_1.CfnPolicyTemplate(this, id, {
            statement: props.statement,
            description: props.description,
            policyStoreId: props.policyStore.policyStoreId,
        });
        this.policyTemplateId = this.policyTemplate.attrPolicyTemplateId;
        this.statement = this.policyTemplate.statement;
        this.description = props.description;
        this.policyStore = props.policyStore;
    }
}
exports.PolicyTemplate = PolicyTemplate;
_a = JSII_RTTI_SYMBOL_1;
PolicyTemplate[_a] = { fqn: "@cdklabs/cdk-verified-permissions.PolicyTemplate", version: "0.1.1" };
//# sourceMappingURL=data:application/json;base64,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