/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.PatternHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.SwitchHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.IfExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.RecordVarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.SwitchExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public final class SwitchPatternHelper {
    public static boolean isBootstrapSwitch(@NotNull Exprent headExprent) {
        if (!(headExprent instanceof SwitchExprent)) {
            return false;
        }
        SwitchExprent switchExprent = (SwitchExprent)headExprent;
        Exprent switchSelector = switchExprent.getValue();
        if (switchSelector instanceof InvocationExprent) {
            InvocationExprent invocationExprent = (InvocationExprent)switchSelector;
            if (invocationExprent.isDynamicCall("typeSwitch", 2)) {
                return true;
            }
            if (invocationExprent.isDynamicCall("enumSwitch", 2)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static Map<Integer, String> getMapCaseClasses(List<PooledConstant> bootstrapArguments) {
        HashMap<Integer, String> mapCaseClasses = new HashMap<Integer, String>();
        for (int i = 0; i < bootstrapArguments.size(); ++i) {
            PooledConstant constant = bootstrapArguments.get(i);
            if (!(constant instanceof PrimitiveConstant)) continue;
            PrimitiveConstant primitiveConstant = (PrimitiveConstant)constant;
            if (primitiveConstant.type != 7) continue;
            mapCaseClasses.put(i, primitiveConstant.getString());
        }
        return mapCaseClasses;
    }

    private static boolean isNonNullCheck(@NotNull Exprent exprent, @NotNull Exprent switchVar) {
        if (!(exprent instanceof InvocationExprent)) {
            return false;
        }
        InvocationExprent invocationExprent = (InvocationExprent)exprent;
        return invocationExprent.isStatic() && "requireNonNull".equals(invocationExprent.getName()) && "java/util/Objects".equals(invocationExprent.getClassName()) && invocationExprent.getParameters() != null && invocationExprent.getParameters().size() == 1 && switchVar.equals(invocationExprent.getParameters().get(0));
    }

    private static boolean checkReinitVar(@NotNull Exprent var, @NotNull Statement statement, @NotNull Set<AssignmentExprent> exclude) {
        List<Exprent> exprents = statement.getExprents();
        if (exprents != null) {
            for (Exprent exprent : exprents) {
                Exprent left;
                AssignmentExprent assignmentExprent;
                if (!(exprent instanceof AssignmentExprent) || exclude.contains(assignmentExprent = (AssignmentExprent)exprent) || !var.equals(left = assignmentExprent.getLeft())) continue;
                return true;
            }
        }
        if (statement.getStats() != null) {
            for (Statement children : statement.getStats()) {
                if (!SwitchPatternHelper.checkReinitVar(var, children, exclude)) continue;
                return true;
            }
        }
        return false;
    }

    private static class PatternContainer {
        private final Map<Statement, List<PatternStatement>> patternsByStatement = new HashMap<Statement, List<PatternStatement>>();

        private PatternContainer() {
        }

        void replacePattern(@NotNull Statement statement, @Nullable Exprent guard, @NotNull Statement caseStatement, @Nullable VarExprent assignedName) {
            PatternStatement patternStatement = new PatternStatement(statement, guard, caseStatement, assignedName);
            ArrayList<PatternStatement> patterns = new ArrayList<PatternStatement>();
            patterns.add(patternStatement);
            this.patternsByStatement.put(statement, patterns);
        }

        void addPattern(@NotNull Statement statement, @Nullable Exprent guard, @NotNull Statement caseStatement, @Nullable VarExprent assignedName) {
            this.patternsByStatement.compute(statement, (key, value) -> {
                if (value == null) {
                    value = new ArrayList<PatternStatement>();
                }
                value.add(new PatternStatement((Statement)key, guard, caseStatement, assignedName));
                return value;
            });
        }

        @Nullable
        List<PatternStatement> getPatterns(@NotNull Statement statement) {
            return this.patternsByStatement.get(statement);
        }

        record PatternStatement(@NotNull Statement statement, @Nullable Exprent guard, @NotNull Statement caseStatement, @Nullable VarExprent variable) {
        }
    }

    private static class SwitchOnReferenceCandidate
    implements SwitchHelper.SwitchOnCandidate {
        @NotNull
        private final SwitchStatement myRootSwitchStatement;
        @NotNull
        private final InvocationExprent myPreviousSelector;
        @NotNull
        private final Exprent myNewSwitchSelectorVariant;
        @NotNull
        private final List<SwitchHelper.TempVarAssignmentItem> myTempVarAssignments;
        @NotNull
        private final List<JavacReferenceFinder.FullCase> mySortedCasesFromRoot;
        @NotNull
        private final Set<SwitchStatement> myUsedSwitchStatements;
        @NotNull
        private final Set<AssignmentExprent> myUsedTypeVarAssignments;
        @Nullable
        private final Runnable myCleaner;
        @NotNull
        private final PatternContainer myPatternContainer;
        @Nullable
        private final DoStatement myUppedDoStatement;
        private final boolean myMustCleanNonNull;

        private SwitchOnReferenceCandidate(@NotNull SwitchStatement rootSwitchStatement, @NotNull InvocationExprent previousSelector, @NotNull Exprent newSwitchSelectorVariant, @NotNull List<JavacReferenceFinder.FullCase> cases, @NotNull PatternContainer patternContainer, @NotNull List<SwitchHelper.TempVarAssignmentItem> tempVarAssignments, @NotNull Set<SwitchStatement> usedSwitchStatements, @NotNull Set<AssignmentExprent> usedTypeVarAssignments, @Nullable DoStatement uppedDoStatement, boolean mustCleanNonNull, @Nullable Runnable cleaner) {
            this.myRootSwitchStatement = rootSwitchStatement;
            this.myPreviousSelector = previousSelector;
            this.myNewSwitchSelectorVariant = newSwitchSelectorVariant;
            this.myTempVarAssignments = tempVarAssignments;
            this.mySortedCasesFromRoot = cases;
            this.myUsedSwitchStatements = usedSwitchStatements;
            this.myCleaner = cleaner;
            this.myPatternContainer = patternContainer;
            this.myMustCleanNonNull = mustCleanNonNull;
            this.myUppedDoStatement = uppedDoStatement;
            this.myUsedTypeVarAssignments = usedTypeVarAssignments;
        }

        @Override
        public void simplify() {
            Exprent oldSelector;
            this.prepareSortedCases();
            if (this.myCleaner != null) {
                this.myCleaner.run();
            }
            SwitchOnReferenceCandidate.resort(this.myRootSwitchStatement, this.mySortedCasesFromRoot);
            Exprent headExprent = this.myRootSwitchStatement.getHeadExprent();
            List<PooledConstant> bootstrapArguments = this.myPreviousSelector.getBootstrapArguments();
            Map<Integer, String> mapCaseClasses = SwitchPatternHelper.getMapCaseClasses(bootstrapArguments);
            Map<Integer, Exprent> mapCaseValue = this.getMapCaseValue(bootstrapArguments);
            boolean hasPattern = this.remapCaseValues(mapCaseValue, mapCaseClasses);
            if (headExprent != null) {
                headExprent.replaceExprent(this.myPreviousSelector, this.myNewSwitchSelectorVariant);
            }
            if (hasPattern) {
                SwitchOnReferenceCandidate.remapWithPatterns(this.myRootSwitchStatement, this.myPatternContainer, this.myUppedDoStatement, this.myTempVarAssignments);
                SwitchOnReferenceCandidate.cleanDefault(this.myRootSwitchStatement);
            }
            if ((oldSelector = this.myPreviousSelector.getInstance()) instanceof VarExprent) {
                VarExprent oldSelectorVarExprent = (VarExprent)oldSelector;
                Exprent exprent = this.myNewSwitchSelectorVariant;
                if (exprent instanceof VarExprent) {
                    VarExprent newSwitchSelectorVarExprent = (VarExprent)exprent;
                    SwitchOnReferenceCandidate.changeEverywhere(oldSelectorVarExprent, newSwitchSelectorVarExprent, this.myRootSwitchStatement.getCaseStatements());
                    SwitchOnReferenceCandidate.changeDefaultToFullCase(this.myRootSwitchStatement, newSwitchSelectorVarExprent);
                }
            }
        }

        private static void changeDefaultToFullCase(@NotNull SwitchStatement myRoot, @NotNull VarExprent newSwitch) {
            List<List<StatEdge>> edges = myRoot.getCaseEdges();
            for (int i = 0; i < edges.size(); ++i) {
                AssignmentExprent assignmentExprent;
                Exprent exprent;
                Statement defaultStatement;
                Statement statementWithFirstAssignment;
                List<StatEdge> statEdges = edges.get(i);
                if (statEdges.size() != 1 || statEdges.get(0) != myRoot.getDefaultEdge() || (statementWithFirstAssignment = SwitchOnReferenceCandidate.getStatementWithFirstAssignment(defaultStatement = myRoot.getCaseStatements().get(i))) == null || statementWithFirstAssignment.getExprents() == null || statementWithFirstAssignment.getExprents().isEmpty() || !((exprent = statementWithFirstAssignment.getExprents().get(0)) instanceof AssignmentExprent) || (assignmentExprent = (AssignmentExprent)exprent).getRight() == null || !((exprent = assignmentExprent.getLeft()) instanceof VarExprent)) continue;
                VarExprent newVarExprent = (VarExprent)exprent;
                if (!assignmentExprent.getRight().equals(newSwitch) || !assignmentExprent.getLeft().getExprType().equals(newSwitch.getExprType())) continue;
                statementWithFirstAssignment.getExprents().remove(0);
                List<@Nullable Exprent> defaultValues = myRoot.getCaseValues().get(i);
                defaultValues.clear();
                defaultValues.add(newVarExprent);
                myRoot.setUseCustomDefault();
                break;
            }
        }

        @Nullable
        private static Statement getStatementWithFirstAssignment(@NotNull Statement statement) {
            if (statement.getExprents() != null && !statement.getExprents().isEmpty()) {
                if (statement.getExprents().get(0) instanceof AssignmentExprent) {
                    return statement;
                }
                return null;
            }
            if (!statement.getStats().isEmpty()) {
                return SwitchOnReferenceCandidate.getStatementWithFirstAssignment((Statement)statement.getStats().get(0));
            }
            return null;
        }

        private static void changeEverywhere(@NotNull VarExprent oldVariant, @NotNull VarExprent newVariant, @NotNull List<Statement> statements) {
            for (Statement statement : statements) {
                if (statement.getExprents() != null) {
                    for (Exprent exprent : statement.getExprents()) {
                        for (Exprent nestedExprent : exprent.getAllExprents()) {
                            if (!nestedExprent.equals(oldVariant)) continue;
                            exprent.replaceExprent(nestedExprent, newVariant);
                        }
                    }
                }
                for (Statement nestedStat : statement.getStats()) {
                    SwitchOnReferenceCandidate.changeEverywhere(oldVariant, newVariant, nestedStat.getStats());
                }
            }
        }

        @Override
        public Set<SwitchStatement> usedSwitch() {
            return this.myUsedSwitchStatements;
        }

        @Override
        public List<SwitchHelper.TempVarAssignmentItem> prepareTempAssignments() {
            return this.myTempVarAssignments;
        }

        @NotNull
        private Map<Integer, Exprent> getMapCaseValue(List<PooledConstant> bootstrapArguments) {
            HashMap<Integer, Exprent> mapCaseValue = new HashMap<Integer, Exprent>();
            for (int i = 0; i < bootstrapArguments.size(); ++i) {
                PooledConstant constant = bootstrapArguments.get(i);
                if (!(constant instanceof PrimitiveConstant)) continue;
                PrimitiveConstant primitiveConstant = (PrimitiveConstant)constant;
                if (primitiveConstant.type == 7) continue;
                if (this.myPreviousSelector.isDynamicCall("enumSwitch", 2)) {
                    mapCaseValue.put(i, new FieldExprent(primitiveConstant.getString(), null, true, null, null, null));
                    continue;
                }
                VarType type = switch (primitiveConstant.type) {
                    case 8 -> VarType.VARTYPE_STRING;
                    case 3 -> VarType.VARTYPE_INT;
                    default -> VarType.VARTYPE_UNKNOWN;
                };
                mapCaseValue.put(i, new ConstExprent(type, primitiveConstant.value, null));
            }
            return mapCaseValue;
        }

        private void prepareSortedCases() {
            for (int i = 0; i < this.mySortedCasesFromRoot.size(); ++i) {
                Statement currentStatement = this.mySortedCasesFromRoot.get((int)i).statement;
                List<StatEdge> edges = currentStatement.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
                if (edges.size() != 1) continue;
                StatEdge onlyEdge = edges.get(0);
                if (onlyEdge.getType() != StatEdge.EdgeType.REGULAR && !onlyEdge.explicit) {
                    onlyEdge.explicit = true;
                    onlyEdge.labeled = false;
                }
                if (i != this.myRootSwitchStatement.getCaseStatements().size() - 1 || onlyEdge.getType() != StatEdge.EdgeType.BREAK || !onlyEdge.explicit || onlyEdge.labeled) continue;
                onlyEdge.explicit = false;
            }
            if (this.myMustCleanNonNull) {
                JavacReferenceFinder.FullCase toDelete = null;
                for (JavacReferenceFinder.FullCase fullCase : this.mySortedCasesFromRoot) {
                    int nullIndex = -1;
                    List<Exprent> exprents = fullCase.exprents;
                    for (int i = 0; i < exprents.size(); ++i) {
                        ConstExprent constExprent;
                        Exprent t = exprents.get(i);
                        if (!(t instanceof ConstExprent) || (constExprent = (ConstExprent)t).getIntValue() != -1) continue;
                        nullIndex = i;
                        break;
                    }
                    if (nullIndex == -1) continue;
                    if (fullCase.exprents().size() != 1) {
                        fullCase.exprents.remove(nullIndex);
                        fullCase.edges.remove(nullIndex);
                        break;
                    }
                    toDelete = fullCase;
                    break;
                }
                this.mySortedCasesFromRoot.remove(toDelete);
            }
        }

        private boolean remapCaseValues(@NotNull Map<Integer, Exprent> mapCaseValue, @NotNull Map<Integer, String> mapCaseClasses) {
            @NotNull List<List<@Nullable Exprent>> values = this.myRootSwitchStatement.getCaseValues();
            boolean hasPattern = false;
            for (int caseIndex = 0; caseIndex < values.size(); ++caseIndex) {
                List<Exprent> caseValues = values.get(caseIndex);
                for (int valueIndex = 0; valueIndex < caseValues.size(); ++valueIndex) {
                    Exprent newCaseValue;
                    Exprent caseValue = caseValues.get(valueIndex);
                    if (!(caseValue instanceof ConstExprent)) continue;
                    ConstExprent constCaseValue = (ConstExprent)caseValue;
                    int expectedValue = constCaseValue.getIntValue();
                    if (expectedValue == -1) {
                        caseValues.set(valueIndex, new ConstExprent(VarType.VARTYPE_NULL, null, null));
                    }
                    if ((newCaseValue = mapCaseValue.get(expectedValue)) == null) {
                        String className = mapCaseClasses.get(expectedValue);
                        if (className == null) continue;
                        List<PatternContainer.PatternStatement> guards = this.myPatternContainer.getPatterns(this.myRootSwitchStatement.getCaseStatements().get(caseIndex));
                        if (guards != null && guards.size() == 1) {
                            newCaseValue = guards.get(0).variable();
                        }
                        if (newCaseValue == null) {
                            newCaseValue = JavacReferenceFinder.createDefaultPatternVal(className);
                        }
                        hasPattern = true;
                    }
                    caseValues.set(valueIndex, newCaseValue);
                }
            }
            return hasPattern;
        }

        private static void remapWithPatterns(@NotNull SwitchStatement switchStatement, @Nullable PatternContainer patternContainer, @Nullable DoStatement upperDoStatement, @NotNull List<SwitchHelper.TempVarAssignmentItem> tempVarAssignments) {
            if (patternContainer == null) {
                return;
            }
            SwitchOnReferenceCandidate.extendCases(switchStatement, patternContainer);
            SwitchOnReferenceCandidate.addGuards(switchStatement, patternContainer);
            Set collectedPatterns = patternContainer.patternsByStatement.values().stream().flatMap(t -> t.stream()).map(t -> t.caseStatement).collect(Collectors.toSet());
            if (upperDoStatement != null) {
                Optional<Statement> lastStatementOpt = SwitchOnReferenceCandidate.findNestedLastStatement(patternContainer);
                Statement containerStatement = patternContainer.patternsByStatement.keySet().iterator().next();
                Optional<Statement> baseSwitchStatementOpt = containerStatement.getStats().stream().filter(t -> t instanceof SwitchStatement).findAny();
                if (lastStatementOpt.isPresent() && baseSwitchStatementOpt.isPresent() && new HashSet<Statement>(switchStatement.getCaseStatements()).containsAll(collectedPatterns)) {
                    Statement lastStatement = lastStatementOpt.get();
                    Statement baseSwitchStatement = baseSwitchStatementOpt.get();
                    if (baseSwitchStatement.getFirst() != null && baseSwitchStatement.getFirst().getExprents() != null && lastStatement.getExprents() != null && switchStatement.getFirst() != null && switchStatement.getFirst().getExprents() != null) {
                        for (Exprent exprent : baseSwitchStatement.getFirst().getExprents()) {
                            Object varExprent;
                            if (!(exprent instanceof VarExprent) || !((VarExprent)(varExprent = (VarExprent)exprent)).isDefinition() || !lastStatement.getExprents().stream().anyMatch(arg_0 -> SwitchOnReferenceCandidate.lambda$remapWithPatterns$3((VarExprent)varExprent, arg_0))) continue;
                            switchStatement.getFirst().getExprents().add((Exprent)varExprent);
                            break;
                        }
                    }
                    ArrayList<Statement> lst = new ArrayList<Statement>();
                    lst.add(switchStatement);
                    lst.add(lastStatement);
                    ArrayList<StatEdge> edges = new ArrayList<StatEdge>(lastStatement.getAllPredecessorEdges());
                    for (StatEdge edge : edges) {
                        lastStatement.removePredecessor(edge);
                    }
                    for (Statement statement : switchStatement.getCaseStatements()) {
                        lastStatement.addPredecessor(new StatEdge(StatEdge.EdgeType.BREAK, statement, lastStatement));
                    }
                    SequenceStatement statement = new SequenceStatement(lst);
                    ArrayList<StatEdge> lastSuccessors = new ArrayList<StatEdge>(lastStatement.getAllSuccessorEdges());
                    for (StatEdge edge : lastSuccessors) {
                        statement.addSuccessor(edge);
                        lastStatement.removeSuccessor(edge);
                    }
                    upperDoStatement.getParent().replaceStatement(upperDoStatement, statement);
                } else {
                    List<StatEdge> continueEdges = upperDoStatement.getPredecessorEdges(StatEdge.EdgeType.CONTINUE);
                    upperDoStatement.getParent().replaceStatement(upperDoStatement, switchStatement);
                    for (StatEdge edge : switchStatement.getPredecessorEdges(StatEdge.EdgeType.CONTINUE)) {
                        Statement source = edge.getSource();
                        if (!continueEdges.contains(edge) || !upperDoStatement.containsStatement(source)) continue;
                        source.removeSuccessor(edge);
                        source.getParent().getStats().removeWithKey(source.id);
                        for (StatEdge predecessorEdge : source.getAllPredecessorEdges()) {
                            predecessorEdge.getSource().removeSuccessor(predecessorEdge);
                        }
                    }
                }
                SwitchOnReferenceCandidate.normalizeCaseLabels(switchStatement, upperDoStatement);
            }
            SwitchOnReferenceCandidate.normalizeLabels(switchStatement, tempVarAssignments);
            SwitchOnReferenceCandidate.deleteNullCases(switchStatement);
        }

        @NotNull
        private static Optional<Statement> findNestedLastStatement(@NotNull PatternContainer patternContainer) {
            return Optional.of(patternContainer).map(c -> c.patternsByStatement).filter(patterns -> patterns.size() == 1).map(patterns -> (Statement)patterns.keySet().iterator().next()).map(p -> {
                if (p.getStats() != null && p.getStats().size() >= 2 && p.getStats().get(p.getStats().size() - 2) instanceof SwitchStatement) {
                    return (Statement)p.getStats().get(p.getStats().size() - 1);
                }
                return null;
            }).filter(t -> {
                BasicBlockStatement basicBlockStatement;
                return t instanceof BasicBlockStatement && (basicBlockStatement = (BasicBlockStatement)t).getExprents() != null;
            });
        }

        private static void deleteNullCases(@NotNull SwitchStatement statement) {
            @NotNull List<List<@Nullable Exprent>> values = statement.getCaseValues();
            for (int i = 0; i < values.size(); ++i) {
                List<Exprent> value = values.get(i);
                int indexOfNull = -1;
                ConstExprent nullExprent = null;
                for (int j = 0; j < value.size(); ++j) {
                    ConstExprent constExprent;
                    Exprent exprent = value.get(j);
                    if (!(exprent instanceof ConstExprent) || !(constExprent = (ConstExprent)exprent).isNull()) continue;
                    nullExprent = constExprent;
                    indexOfNull = j;
                    break;
                }
                if (nullExprent == null || !value.stream().anyMatch(t -> t instanceof VarExprent)) continue;
                value.remove(nullExprent);
                statement.getCaseEdges().get(i).remove(indexOfNull);
            }
        }

        private static void addGuards(@NotNull SwitchStatement switchStatement, @NotNull PatternContainer patternContainer) {
            for (int i = 0; i < switchStatement.getCaseStatements().size(); ++i) {
                Statement currentCaseStatement = switchStatement.getCaseStatements().get(i);
                List<PatternContainer.PatternStatement> patterns = patternContainer.getPatterns(currentCaseStatement);
                if (patterns == null || patterns.size() != 1) continue;
                Statement newStatement = patterns.get(0).caseStatement();
                switchStatement.replaceStatement(switchStatement.getCaseStatements().get(i), newStatement);
                switchStatement.getCaseStatements().set(i, newStatement);
                switchStatement.getCaseEdges().get(i).forEach(edge -> edge.setDestination(((PatternContainer.PatternStatement)patterns.get(0)).caseStatement()));
                Exprent guard = patterns.get(0).guard();
                if (guard == null) continue;
                switchStatement.addGuard(switchStatement.getCaseStatements().get(i), guard);
            }
        }

        private static void extendCases(@NotNull SwitchStatement switchStatement, @NotNull PatternContainer patternContainer) {
            for (Map.Entry<Statement, List<PatternContainer.PatternStatement>> entry : patternContainer.patternsByStatement.entrySet()) {
                if (entry.getValue().size() == 1) continue;
                Statement currentStatement = entry.getKey();
                int indexOf = switchStatement.getCaseStatements().indexOf(currentStatement);
                if (indexOf < 0) continue;
                List<PatternContainer.PatternStatement> value = entry.getValue();
                for (int i = value.size() - 1; i >= 0; --i) {
                    PatternContainer.PatternStatement patternStatement = value.get(i);
                    int duplicatedIndex = switchStatement.duplicateCaseStatement(currentStatement);
                    if (duplicatedIndex < 0) continue;
                    switchStatement.replaceStatement(switchStatement.getCaseStatements().get(duplicatedIndex), patternStatement.caseStatement);
                    switchStatement.getCaseEdges().get(duplicatedIndex).forEach(edge -> edge.setDestination(patternStatement.caseStatement));
                    VarExprent variable = patternStatement.variable();
                    ArrayList<VarExprent> newList = new ArrayList<VarExprent>();
                    newList.add(variable);
                    switchStatement.getCaseValues().set(duplicatedIndex, newList);
                    Exprent guard = patternStatement.guard;
                    if (guard == null) continue;
                    switchStatement.addGuard(patternStatement.caseStatement, guard);
                }
                switchStatement.removeCaseStatement(currentStatement);
            }
        }

        private static void normalizeCaseLabels(@NotNull SwitchStatement switchStatement, @NotNull DoStatement upperDoStatement) {
            @NotNull List<Statement> statements = switchStatement.getCaseStatements();
            for (int i = 0; i < statements.size(); ++i) {
                Statement caseStatement = statements.get(i);
                List<StatEdge> edges = caseStatement.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
                if (edges.isEmpty() && !caseStatement.getStats().isEmpty()) {
                    edges = ((Statement)caseStatement.getStats().get(caseStatement.getStats().size() - 1)).getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
                }
                if (edges.size() != 1 || edges.get(0).getType() != StatEdge.EdgeType.BREAK || !upperDoStatement.equals(edges.get((int)0).closure) && !switchStatement.equals(edges.get((int)0).closure)) continue;
                edges.get((int)0).labeled = false;
            }
        }

        private static void normalizeLabels(@NotNull SwitchStatement switchStatement, @NotNull List<SwitchHelper.TempVarAssignmentItem> tempVarAssignments) {
            HashSet<StatEdge> labelsToDelete = new HashSet<StatEdge>();
            Set tempVars = tempVarAssignments.stream().map(t -> t.varExprent()).collect(Collectors.toSet());
            for (StatEdge label : switchStatement.getLabelEdges()) {
                Statement source;
                if (!label.explicit || !label.labeled || !((source = label.getSource()) instanceof BasicBlockStatement)) continue;
                BasicBlockStatement basicBlockStatement = (BasicBlockStatement)source;
                boolean toDelete = true;
                if (basicBlockStatement.getExprents() == null) continue;
                for (Exprent exprent : basicBlockStatement.getExprents()) {
                    if (!(exprent instanceof AssignmentExprent)) {
                        toDelete = false;
                        break;
                    }
                    AssignmentExprent assignmentExprent = (AssignmentExprent)exprent;
                    if (tempVars.contains(assignmentExprent.getLeft())) continue;
                    toDelete = false;
                    break;
                }
                if (!toDelete) continue;
                labelsToDelete.add(label);
            }
            switchStatement.getLabelEdges().removeAll(labelsToDelete);
        }

        private static void cleanDefault(@NotNull SwitchStatement statement) {
            @NotNull List<List<StatEdge>> caseEdges = statement.getCaseEdges();
            int indexDefault = -1;
            boolean deleteDefault = false;
            for (int caseIndex = 0; caseIndex < caseEdges.size(); ++caseIndex) {
                ConstExprent constExprent2;
                ConstExprent constExprent1;
                Exprent exprent;
                InvocationExprent constructor;
                NewExprent newExprent;
                Exprent exprent2;
                ExitExprent exitExprent;
                Exprent expectedFastExit;
                List<StatEdge> edges = caseEdges.get(caseIndex);
                int indexDefaultInside = edges.indexOf(statement.getDefaultEdge());
                if (indexDefaultInside == -1) continue;
                indexDefault = caseIndex;
                if (edges.size() != 1) {
                    ArrayList<Exprent> exprentsToRemove = new ArrayList<Exprent>();
                    ArrayList<StatEdge> edgesToRemove = new ArrayList<StatEdge>();
                    List<@Nullable Exprent> exprents = statement.getCaseValues().get(caseIndex);
                    for (int i = 0; i < edges.size(); ++i) {
                        if (edges.get(i) == statement.getDefaultEdge() || !(exprents.get(i) instanceof VarExprent)) continue;
                        exprentsToRemove.add(exprents.get(i));
                        edgesToRemove.add(edges.get(i));
                    }
                    edges.removeAll(edgesToRemove);
                    exprents.removeAll(exprentsToRemove);
                    break;
                }
                Statement defaultStatement = statement.getCaseStatements().get(caseIndex);
                if (defaultStatement.getExprents() == null || defaultStatement.getExprents().size() != 1 || !((expectedFastExit = defaultStatement.getExprents().get(0)) instanceof ExitExprent) || (exitExprent = (ExitExprent)expectedFastExit).getExitType() != 1 || !((exprent2 = exitExprent.getValue()) instanceof NewExprent) || (newExprent = (NewExprent)exprent2).getConstructor() == null || !"java/lang/MatchException".equals((constructor = newExprent.getConstructor()).getClassName()) || constructor.getParameters().size() != 2 || !((exprent = constructor.getParameters().get(0)) instanceof ConstExprent) || !(constExprent1 = (ConstExprent)exprent).isNull() || !((exprent = constructor.getParameters().get(1)) instanceof ConstExprent) || !(constExprent2 = (ConstExprent)exprent).isNull()) break;
                deleteDefault = true;
                break;
            }
            if (deleteDefault) {
                statement.getCaseStatements().remove(indexDefault);
                statement.getCaseValues().remove(indexDefault);
                statement.getCaseEdges().remove(indexDefault);
            }
        }

        private static void resort(@NotNull SwitchStatement statement, @NotNull List<JavacReferenceFinder.FullCase> cases) {
            statement.getCaseStatements().clear();
            statement.getCaseStatements().addAll(cases.stream().map(t -> t.statement).toList());
            statement.getCaseEdges().clear();
            statement.getCaseEdges().addAll(cases.stream().map(t -> t.edges).toList());
            statement.getCaseValues().clear();
            statement.getCaseValues().addAll(cases.stream().map(t -> t.exprents).toList());
        }

        private static /* synthetic */ boolean lambda$remapWithPatterns$3(VarExprent varExprent, Exprent e) {
            return e.containsExprent(varExprent);
        }
    }

    private static class JavacReferenceFinder {
        @Nullable
        private final PatternHelper.VarTracker myVarTracker;
        @NotNull
        private final Set<Exprent> myTypeVars;
        @NotNull
        private final SwitchStatement myRootSwitchStatement;
        @NotNull
        private final InvocationExprent mySwitchSelector;
        @NotNull
        private final List<SwitchHelper.TempVarAssignmentItem> myTempVarAssignments = new ArrayList<SwitchHelper.TempVarAssignmentItem>();
        @NotNull
        private final Set<SwitchStatement> myUsedSwitch = new HashSet<SwitchStatement>();

        private JavacReferenceFinder(@Nullable PatternHelper.VarTracker tracker, @NotNull Set<Exprent> typeVars, @NotNull SwitchStatement rootSwitchStatement, @NotNull InvocationExprent switchSelector) {
            this.myVarTracker = tracker;
            this.myTypeVars = new HashSet<Exprent>(typeVars);
            this.myRootSwitchStatement = rootSwitchStatement;
            this.mySwitchSelector = switchSelector;
            this.myUsedSwitch.add(this.myRootSwitchStatement);
        }

        @Nullable
        public SwitchOnReferenceCandidate findCandidate() {
            Initializer initializer;
            Exprent instance = this.mySwitchSelector.getInstance();
            if (instance == null) {
                return null;
            }
            if (this.myRootSwitchStatement.getHeadExprent() == null) {
                return null;
            }
            if (this.myRootSwitchStatement.getCaseValues().size() != this.myRootSwitchStatement.getCaseEdges().size() || this.myRootSwitchStatement.getCaseValues().size() != this.myRootSwitchStatement.getCaseStatements().size()) {
                return null;
            }
            if (!(instance instanceof VarExprent)) {
                return null;
            }
            VarExprent instanceVarExprent = (VarExprent)instance;
            if (!SwitchPatternHelper.isBootstrapSwitch(this.myRootSwitchStatement.getHeadExprent())) {
                return null;
            }
            if (this.checkBootstrap()) {
                return null;
            }
            List<Exprent> parameters = this.mySwitchSelector.getParameters();
            if (!instance.equals(parameters.get(0))) {
                return null;
            }
            Exprent typeVar = parameters.get(1);
            Root root = this.getRoot();
            if (root == null) {
                return null;
            }
            if (root.firstExprents() == null) {
                return null;
            }
            if (this.myVarTracker != null) {
                PatternHelper.processAtLeastOneBlock(this.myVarTracker, root.firstStatement());
            }
            if ((initializer = this.findInitializer(root, typeVar)).initVar2() == null) {
                return null;
            }
            HashSet<AssignmentExprent> usedTypeVarAssignments = new HashSet<AssignmentExprent>();
            usedTypeVarAssignments.add(initializer.initVar2());
            this.myTypeVars.add(typeVar);
            Map<Statement, List<PatternHelper.PatternVariableCandidate>> candidates = this.collectPatterns(instanceVarExprent, root.doParentStatement(), usedTypeVarAssignments);
            if (candidates == null) {
                return null;
            }
            candidates.values().stream().flatMap(t -> t.stream()).forEach(candidate -> this.myTempVarAssignments.addAll(candidate.getTempAssignments()));
            PatternContainer patternContainer = this.collectGuards(candidates, typeVar, root.doParentStatement(), usedTypeVarAssignments);
            if (root.doParentStatement() != null ? SwitchPatternHelper.checkReinitVar(typeVar, root.doParentStatement(), usedTypeVarAssignments) : SwitchPatternHelper.checkReinitVar(typeVar, this.myRootSwitchStatement, usedTypeVarAssignments)) {
                return null;
            }
            List<FullCase> resortedCases = JavacReferenceFinder.resortForSwitchBootstrap(this.myRootSwitchStatement);
            if (resortedCases == null) {
                return null;
            }
            List<Exprent> finalFirstExprents = root.firstExprents();
            Exprent finalNonNullCheck = initializer.nonNullCheck();
            return new SwitchOnReferenceCandidate(this.myRootSwitchStatement, this.mySwitchSelector, initializer.instance(), resortedCases, patternContainer, this.myTempVarAssignments, this.myUsedSwitch, usedTypeVarAssignments, root.doParentStatement(), initializer.nonNullCheck() != null, () -> {
                if (finalNonNullCheck != null) {
                    finalFirstExprents.remove(finalNonNullCheck);
                }
            });
        }

        @NotNull
        private Initializer findInitializer(@NotNull Root root, Exprent typeVar) {
            AssignmentExprent firstAssignment;
            Exprent instance = Objects.requireNonNull(this.mySwitchSelector.getInstance());
            Exprent nonNullCheck = null;
            AssignmentExprent initVar2 = null;
            for (Exprent exprent : root.firstExprents()) {
                if (!(exprent instanceof AssignmentExprent) || !instance.equals((firstAssignment = (AssignmentExprent)exprent).getLeft())) continue;
                instance = firstAssignment.getRight();
                Exprent exprent2 = firstAssignment.getLeft();
                if (!(exprent2 instanceof VarExprent)) continue;
                VarExprent varExprent = (VarExprent)exprent2;
                this.myTempVarAssignments.add(new SwitchHelper.TempVarAssignmentItem(varExprent, root.firstStatement()));
            }
            for (Exprent exprent : root.firstExprents()) {
                Integer value;
                ConstExprent constExprent;
                Object object;
                if (SwitchPatternHelper.isNonNullCheck(exprent, instance)) {
                    nonNullCheck = exprent;
                }
                if (!(exprent instanceof AssignmentExprent) || !typeVar.equals((firstAssignment = (AssignmentExprent)exprent).getLeft()) || !((object = firstAssignment.getRight()) instanceof ConstExprent) || !((object = (constExprent = (ConstExprent)object).getValue()) instanceof Integer) || (value = (Integer)object) != 0) continue;
                initVar2 = firstAssignment;
                Exprent exprent3 = firstAssignment.getLeft();
                if (!(exprent3 instanceof VarExprent)) continue;
                VarExprent varExprent = (VarExprent)exprent3;
                this.myTempVarAssignments.add(new SwitchHelper.TempVarAssignmentItem(varExprent, root.firstStatement()));
            }
            return new Initializer(instance, nonNullCheck, initVar2);
        }

        @Nullable
        private Root getRoot() {
            SwitchStatement upperSwitchStatement;
            SequenceStatement sequenceStatement;
            DoStatement upperDoStatement;
            DoStatement nestedDoStatement;
            SequenceStatement sequenceStatement2;
            DoStatement upperDoStatement2;
            DoStatement nestedDoStatement2;
            Statement statement;
            Statement first = this.myRootSwitchStatement.getFirst();
            if (first == null) {
                return null;
            }
            List<Exprent> firstExprents = first.getExprents();
            Statement doParentStatement = null;
            if (this.myVarTracker != null && (statement = this.myRootSwitchStatement.getParent()) instanceof DoStatement && (nestedDoStatement2 = (DoStatement)statement).getConditionExprent() == null && (statement = nestedDoStatement2.getParent()) instanceof DoStatement && (upperDoStatement2 = (DoStatement)statement).getConditionExprent() == null && (statement = upperDoStatement2.getParent()) instanceof SequenceStatement && (sequenceStatement2 = (SequenceStatement)statement).getStats().size() >= 2 && sequenceStatement2.getStats().getLast() == upperDoStatement2 && (statement = sequenceStatement2.getStats().get(sequenceStatement2.getStats().size() - 2)) instanceof BasicBlockStatement) {
                BasicBlockStatement basicBlockStatement = (BasicBlockStatement)statement;
                firstExprents = basicBlockStatement.getExprents();
                first = basicBlockStatement;
                doParentStatement = nestedDoStatement2;
            } else if (this.myVarTracker != null && (statement = this.myRootSwitchStatement.getParent()) instanceof DoStatement && (nestedDoStatement = (DoStatement)statement).getConditionExprent() == null && (statement = nestedDoStatement.getParent()) instanceof DoStatement && (upperDoStatement = (DoStatement)statement).getConditionExprent() == null && (statement = upperDoStatement.getParent()) instanceof SequenceStatement && (sequenceStatement = (SequenceStatement)statement).getStats().size() == 2 && sequenceStatement.getStats().get(1) == upperDoStatement && (statement = sequenceStatement.getStats().get(0)) instanceof SwitchStatement && (upperSwitchStatement = (SwitchStatement)statement).getCaseStatements().size() == 2) {
                int indexDefault;
                int n = upperSwitchStatement.getCaseEdges().get(0).contains(upperSwitchStatement.getDefaultEdge()) ? 0 : (indexDefault = upperSwitchStatement.getCaseEdges().get(1).contains(upperSwitchStatement.getDefaultEdge()) ? 1 : -1);
                if (indexDefault == -1) {
                    return null;
                }
                int other = indexDefault == 0 ? 1 : 0;
                Statement statement2 = upperSwitchStatement.getCaseStatements().get(other);
                if (statement2.getStats().isEmpty()) {
                    return null;
                }
                last = (Statement)statement2.getStats().getLast();
                firstExprents = last.getExprents();
                first = last;
                doParentStatement = nestedDoStatement;
            } else if (firstExprents == null || firstExprents.stream().noneMatch(t -> t instanceof AssignmentExprent)) {
                CatchStatement catchStatement;
                BasicBlockStatement basicBlockStatement;
                Object e;
                SequenceStatement upperStatement;
                Statement parent = this.myRootSwitchStatement.getParent();
                DoStatement doStatement = null;
                if (parent instanceof DoStatement) {
                    doStatement = (DoStatement)parent;
                }
                if (doStatement == null && (last = this.myRootSwitchStatement.getParent().getParent()) instanceof DoStatement) {
                    DoStatement nextStatement;
                    doStatement = nextStatement = (DoStatement)last;
                }
                if (doStatement == null || doStatement.getLoopType() != DoStatement.LoopType.DO || doStatement.getStats().size() != 1 || !((last = doStatement.getParent()) instanceof SequenceStatement) || (upperStatement = (SequenceStatement)last).getExprents() != null) {
                    return null;
                }
                VBStyleCollection<Statement, Integer> upperStatementStats = upperStatement.getStats();
                int indexOfDo = upperStatementStats.indexOf(doStatement);
                if (indexOfDo == -1 || indexOfDo == 0) {
                    return null;
                }
                if (upperStatementStats.get(indexOfDo) == doStatement && (e = upperStatementStats.get(indexOfDo - 1)) instanceof BasicBlockStatement && (basicBlockStatement = (BasicBlockStatement)e).getStats().isEmpty() && basicBlockStatement.getExprents() != null && !basicBlockStatement.getExprents().isEmpty()) {
                    firstExprents = basicBlockStatement.getExprents();
                    doParentStatement = doStatement;
                    first = basicBlockStatement;
                } else if (upperStatementStats.get(indexOfDo) == doStatement && (e = upperStatementStats.get(indexOfDo - 1)) instanceof CatchStatement && (catchStatement = (CatchStatement)e).getStats().size() >= 2 && ((Statement)catchStatement.getStats().get(1)).getExprents() != null && !Objects.requireNonNull(((Statement)catchStatement.getStats().get(1)).getExprents()).isEmpty()) {
                    firstExprents = ((Statement)catchStatement.getStats().get(1)).getExprents();
                    doParentStatement = doStatement;
                    first = (Statement)catchStatement.getStats().get(1);
                } else {
                    return null;
                }
            }
            if (doParentStatement != null) {
                for (StatEdge edge : doParentStatement.getLabelEdges()) {
                    DoStatement firstDo;
                    SequenceStatement sequenceStatement3;
                    Statement source;
                    if (!edge.labeled || !edge.explicit || this.myRootSwitchStatement.containsStatement(source = edge.getSource())) continue;
                    Statement parent = this.myRootSwitchStatement.getParent();
                    if (!(parent instanceof SequenceStatement) || (sequenceStatement3 = (SequenceStatement)parent).getStats().size() != 2) {
                        return null;
                    }
                    int index = sequenceStatement3.getStats().indexOf(this.myRootSwitchStatement);
                    if (index != 0) {
                        return null;
                    }
                    Object e = sequenceStatement3.getStats().get(1);
                    if (!(e instanceof DoStatement) || (firstDo = (DoStatement)e).getStats().size() != 1 || !((e = firstDo.getStats().get(0)) instanceof DoStatement)) {
                        return null;
                    }
                    DoStatement nestedDo = (DoStatement)e;
                    if (nestedDo.containsStatement(source)) continue;
                    return null;
                }
            }
            return new Root(first, firstExprents, (DoStatement)doParentStatement);
        }

        private boolean checkBootstrap() {
            List<PooledConstant> bootstrapArguments = this.mySwitchSelector.getBootstrapArguments();
            if (bootstrapArguments == null) {
                return true;
            }
            for (PooledConstant bootstrapArgument : bootstrapArguments) {
                if (!(bootstrapArgument instanceof PrimitiveConstant)) {
                    return true;
                }
                PrimitiveConstant primitiveConstant = (PrimitiveConstant)bootstrapArgument;
                int type = primitiveConstant.type;
                if (type == 3 || type == 8 || type == 7) continue;
                return true;
            }
            return false;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable
        private static List<FullCase> resortForSwitchBootstrap(@NotNull SwitchStatement statement) {
            for (Statement caseStatement : statement.getCaseStatements()) {
                if (caseStatement != null) continue;
                return null;
            }
            @NotNull List<List<@Nullable Exprent>> values = statement.getCaseValues();
            ArrayList sortedCaseValue = new ArrayList();
            ArrayList sortedEdges = new ArrayList();
            for (int i = 0; i < values.size(); ++i) {
                List<Exprent> caseValue = statement.getCaseValues().get(i);
                for (Exprent exprent : caseValue) {
                    if (exprent == null) continue;
                    if (!(exprent instanceof ConstExprent)) {
                        return null;
                    }
                    ConstExprent constCaseValue = (ConstExprent)exprent;
                    if (constCaseValue.getConstType() == VarType.VARTYPE_INT || constCaseValue.getConstType() == VarType.VARTYPE_BYTECHAR || constCaseValue.getConstType() == VarType.VARTYPE_CHAR || constCaseValue.getConstType() == VarType.VARTYPE_BYTE) continue;
                    return null;
                }
                List<StatEdge> edges = statement.getCaseEdges().get(i);
                if (edges.size() != caseValue.size()) {
                    return null;
                }
                List<CaseValueWithEdge> sorted = IntStream.range(0, edges.size()).mapToObj(ind -> new CaseValueWithEdge((Exprent)caseValue.get(ind), (StatEdge)edges.get(ind))).sorted(Comparator.comparing(o -> o.edge == statement.getDefaultEdge()).thenComparingLong(o -> {
                    long l;
                    Exprent patt0$temp = o.exprent;
                    if (patt0$temp instanceof ConstExprent) {
                        ConstExprent c = (ConstExprent)patt0$temp;
                        l = c.getIntValue();
                    } else {
                        l = Long.MIN_VALUE;
                    }
                    return l;
                })).toList();
                sortedEdges.add(sorted.stream().map(t -> t.edge).collect(Collectors.toList()));
                sortedCaseValue.add(sorted.stream().map(t -> t.exprent).collect(Collectors.toList()));
            }
            List<FullCase> sortedAll = IntStream.range(0, statement.getCaseValues().size()).mapToObj(ind -> new FullCase(statement.getCaseStatements().get(ind), (List)sortedCaseValue.get(ind), (List)sortedEdges.get(ind))).sorted(Comparator.comparing(fullCase -> !fullCase.edges().isEmpty() && fullCase.edges().get(fullCase.exprents.size() - 1) == statement.getDefaultEdge()).thenComparingLong(o -> {
                long l;
                Exprent patt0$temp;
                if (!o.exprents.isEmpty() && (patt0$temp = o.exprents.get(o.exprents.size() - 1)) instanceof ConstExprent) {
                    @NotNull @Nullable ConstExprent c = (ConstExprent)patt0$temp;
                    l = c.getIntValue();
                } else {
                    l = Long.MIN_VALUE;
                }
                return l;
            })).collect(Collectors.toList());
            for (int i = 0; i < sortedAll.size() && i != sortedAll.size() - 1; ++i) {
                Statement destination;
                StatEdge currentEdge;
                List<StatEdge> edges;
                FullCase current = sortedAll.get(i);
                FullCase next = sortedAll.get(i + 1);
                if (current.exprents.isEmpty() || next.exprents.isEmpty()) {
                    return null;
                }
                Exprent currentFirstExpr = current.exprents.get(0);
                Exprent nextFirstExpr = next.exprents.get(0);
                if (currentFirstExpr instanceof ConstExprent) {
                    ConstExprent constExprent1 = (ConstExprent)currentFirstExpr;
                    if (nextFirstExpr instanceof ConstExprent) {
                        ConstExprent constExprent2 = (ConstExprent)nextFirstExpr;
                        if (constExprent1.getIntValue() > constExprent2.getIntValue() && constExprent1.getIntValue() != -1 && constExprent2.getIntValue() != -1 && statement.getDefaultEdge() != next.edges.get(next.edges.size() - 1)) {
                            return null;
                        }
                    }
                }
                if ((edges = current.statement.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL)).size() != 1 || (currentEdge = edges.get(0)).getType() != StatEdge.EdgeType.REGULAR || (destination = currentEdge.getDestination()) == next.statement()) continue;
                return null;
            }
            return sortedAll;
        }

        @NotNull
        private static VarExprent createDefaultPatternVal(@NotNull String className) {
            VarProcessor processor = DecompilerContext.getVarProcessor();
            VarExprent varExprent = new VarExprent(DecompilerContext.getCounterContainer().getCounterAndIncrement(2), new VarType(8, 0, className), processor);
            varExprent.setDefinition(true);
            processor.setVarName(varExprent.getVarVersion(), VarExprent.getName(varExprent.getVarVersion()));
            return varExprent;
        }

        @Nullable
        private Map<Statement, List<PatternHelper.PatternVariableCandidate>> collectPatterns(@NotNull VarExprent instance, @Nullable DoStatement doStatement, @NotNull Set<AssignmentExprent> assignmentExprents) {
            HashMap<Statement, List<PatternHelper.PatternVariableCandidate>> candidates = new HashMap<Statement, List<PatternHelper.PatternVariableCandidate>>();
            List<PooledConstant> bootstrapArguments = this.mySwitchSelector.getBootstrapArguments();
            Map<Integer, String> mapCaseClasses = SwitchPatternHelper.getMapCaseClasses(bootstrapArguments);
            @NotNull List<List<@Nullable Exprent>> values = this.myRootSwitchStatement.getCaseValues();
            for (int caseIndex = 0; caseIndex < values.size(); ++caseIndex) {
                AssignmentExprent assignmentExprent;
                Exprent exprent;
                Statement defaultStatement;
                List<Exprent> caseValues = values.get(caseIndex);
                for (int valueIndex = 0; valueIndex < caseValues.size(); ++valueIndex) {
                    VarExprent left;
                    AssignmentExprent assignmentExprent2;
                    Exprent exprent2;
                    Exprent exprent3;
                    VBStyleCollection<Statement, Integer> sequenceStatementStats;
                    Statement last;
                    SequenceStatement sequenceStatement;
                    ConstExprent constCaseValue;
                    int expectedValue;
                    String className;
                    Exprent caseValue = caseValues.get(valueIndex);
                    if (!(caseValue instanceof ConstExprent) || (className = mapCaseClasses.get(expectedValue = (constCaseValue = (ConstExprent)caseValue).getIntValue())) == null) continue;
                    Statement caseStatement = this.myRootSwitchStatement.getCaseStatements().get(caseIndex);
                    PatternHelper.VarTracker currentVarTracker = this.myVarTracker;
                    if (currentVarTracker == null) {
                        RecordVarExprent recordVarExprent = new RecordVarExprent(instance);
                        currentVarTracker = new PatternHelper.VarTracker(recordVarExprent);
                        currentVarTracker.put(instance, recordVarExprent, this.myRootSwitchStatement);
                    }
                    ConstExprent checkType = new ConstExprent(new VarType(className), null, null);
                    if ((currentVarTracker = currentVarTracker.copy()) == null) continue;
                    PatternHelper.PatternVariableCandidate candidate = null;
                    if (caseStatement instanceof SequenceStatement && !(sequenceStatement = (SequenceStatement)caseStatement).getStats().isEmpty() && (last = (Statement)(sequenceStatementStats = sequenceStatement.getStats()).get(sequenceStatementStats.size() - 1)) instanceof BasicBlockStatement && last.getExprents() != null && last.getExprents().size() == 1 && (exprent3 = last.getExprents().get(0)) instanceof AssignmentExprent && (exprent2 = (assignmentExprent2 = (AssignmentExprent)exprent3).getLeft()) instanceof VarExprent && this.myTypeVars.contains(left = (VarExprent)exprent2)) {
                        SequenceStatement newSequence = new SequenceStatement(sequenceStatementStats.subList(0, sequenceStatementStats.size() - 1));
                        HashMap<Statement, Statement> previousParents = new HashMap<Statement, Statement>();
                        for (Statement currentStat : newSequence.getStats()) {
                            previousParents.put(currentStat, currentStat.getParent());
                            currentStat.setParent(newSequence);
                        }
                        newSequence.setParent(sequenceStatement.getParent());
                        candidate = PatternHelper.findNextPatternVarCandidate(newSequence, instance, checkType, currentVarTracker, newSequence);
                        for (Statement currentStat : newSequence.getStats()) {
                            Statement currentParent = (Statement)previousParents.get(currentStat);
                            if (currentParent == null) continue;
                            currentStat.setParent(currentParent);
                        }
                        if (candidate != null && (candidate = this.normalizeCandidateWithBrokenEdges(candidate, newSequence, sequenceStatement, last, doStatement, assignmentExprents, assignmentExprent2)) == null) {
                            return null;
                        }
                    }
                    if (candidate == null) {
                        candidate = PatternHelper.findNextPatternVarCandidate(caseStatement, instance, checkType, currentVarTracker, caseStatement);
                    }
                    if (candidate != null) {
                        List<PatternHelper.PatternVariableCandidate> nestedSwitches = this.tryToFindNestedSwitch(candidate, caseStatement, assignmentExprents, currentVarTracker);
                        if (nestedSwitches == null || nestedSwitches.isEmpty()) {
                            return null;
                        }
                        candidates.put(caseStatement, nestedSwitches);
                        continue;
                    }
                    if (!"java/lang/Object".equals(className)) continue;
                    ArrayList<PatternHelper.PatternVariableCandidate> value = new ArrayList<PatternHelper.PatternVariableCandidate>();
                    value.add(new PatternHelper.PatternVariableCandidate(JavacReferenceFinder.createDefaultPatternVal(className), caseStatement, new HashSet<IfStatement>(), new ArrayList<SwitchHelper.TempVarAssignmentItem>(), () -> {}));
                    candidates.put(caseStatement, value);
                }
                if (!this.myRootSwitchStatement.getCaseEdges().get(caseIndex).contains(this.myRootSwitchStatement.getDefaultEdge()) || !((defaultStatement = this.myRootSwitchStatement.getCaseStatements().get(caseIndex)) instanceof BasicBlockStatement) || defaultStatement.getExprents() == null || defaultStatement.getExprents().size() != 1 || !((exprent = defaultStatement.getExprents().get(0)) instanceof AssignmentExprent) || !this.myTypeVars.contains((assignmentExprent = (AssignmentExprent)exprent).getLeft())) continue;
                assignmentExprents.add(assignmentExprent);
            }
            return candidates;
        }

        @NotNull
        private PatternContainer collectGuards(@NotNull Map<Statement, List<PatternHelper.PatternVariableCandidate>> candidates, @NotNull Exprent typeVar, @Nullable Statement doParentStatement, @NotNull Set<AssignmentExprent> usedAssignments) {
            PatternContainer container = new PatternContainer();
            @NotNull List<Statement> statements = this.myRootSwitchStatement.getCaseStatements();
            for (int i = 0; i < statements.size(); ++i) {
                AssignmentExprent nameAssignmentExprent;
                Exprent exprent;
                Integer index;
                ConstExprent constExprent;
                AssignmentExprent expectedAssignmentExprent;
                Object object;
                IfStatement ifStatement;
                List<Exprent> exprents;
                OptionalInt maxCaseValue;
                Statement previousValueStatement = statements.get(i);
                Statement caseStatement = statements.get(i);
                List<PatternHelper.PatternVariableCandidate> variableCandidates = candidates.get(caseStatement);
                if (variableCandidates != null) {
                    for (PatternHelper.PatternVariableCandidate variableCandidate : variableCandidates) {
                        container.addPattern(previousValueStatement, variableCandidate.getGuards(), variableCandidate.getNextStatement(), variableCandidate.getVarExprent());
                    }
                    if (variableCandidates.size() != 1) continue;
                    caseStatement = variableCandidates.get(0).getNextStatement();
                }
                if (caseStatement.getStats().size() < 2 || doParentStatement == null || (maxCaseValue = (exprents = this.myRootSwitchStatement.getCaseValues().get(i)).stream().filter(t -> t instanceof ConstExprent).mapToInt(t -> ((ConstExprent)t).getIntValue()).max()).isEmpty()) continue;
                boolean guardIsNegated = false;
                Object e = caseStatement.getStats().get(0);
                if (!(e instanceof IfStatement) || (ifStatement = (IfStatement)e).getIfstat() == null || ifStatement.getElsestat() != null || ifStatement.iftype != 0) continue;
                AssignmentExprent assignmentExprent = null;
                if (ifStatement.getIfstat().getExprents() != null && ifStatement.getIfstat().getExprents().size() == 1 && (object = ifStatement.getIfstat().getExprents().get(0)) instanceof AssignmentExprent && (expectedAssignmentExprent = (AssignmentExprent)object).getLeft() != typeVar && (object = expectedAssignmentExprent.getRight()) instanceof ConstExprent && (object = (constExprent = (ConstExprent)object).getValue()) instanceof Integer && (index = (Integer)object) > maxCaseValue.getAsInt()) {
                    assignmentExprent = expectedAssignmentExprent;
                    guardIsNegated = true;
                }
                if (!guardIsNegated) {
                    Integer index2;
                    ConstExprent constExprent2;
                    AssignmentExprent expectedAssignmentExprent2;
                    Object object2;
                    StatEdge breakEdge;
                    Statement breakStatement = (Statement)caseStatement.getStats().get(1);
                    Statement expectedBreakStatement = (Statement)caseStatement.getStats().get(caseStatement.getStats().size() - 1);
                    List<StatEdge> successorEdges = expectedBreakStatement.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
                    if (successorEdges.size() != 1 || (breakEdge = successorEdges.get(0)).getType() == StatEdge.EdgeType.REGULAR || breakEdge.getDestination() != doParentStatement || breakStatement.getExprents() == null || breakStatement.getExprents().size() != 1 || !((object2 = breakStatement.getExprents().get(0)) instanceof AssignmentExprent) || (expectedAssignmentExprent2 = (AssignmentExprent)object2).getLeft() == typeVar || !((object2 = expectedAssignmentExprent2.getRight()) instanceof ConstExprent) || !((object2 = (constExprent2 = (ConstExprent)object2).getValue()) instanceof Integer) || (index2 = (Integer)object2) <= maxCaseValue.getAsInt()) continue;
                    assignmentExprent = expectedAssignmentExprent2;
                    Statement ifstat = ifStatement.getIfstat();
                    List<StatEdge> edges = ifstat.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
                    if (!edges.isEmpty() && (edges.size() != 1 || edges.get(0).getType() == StatEdge.EdgeType.REGULAR)) continue;
                }
                if (ifStatement.getHeadexprentList().size() != 1 || ifStatement.getHeadexprent() == null || ifStatement.getHeadexprent().getCondition() == null || ifStatement.getIfstat() == null) continue;
                IfExprent ifExprent = ifStatement.getHeadexprent();
                Statement newCaseStatement = ifStatement.getIfstat();
                if (guardIsNegated) {
                    ifExprent = ifExprent.negateIf();
                    newCaseStatement = new SequenceStatement(caseStatement.getStats().subList(1, caseStatement.getStats().size()));
                }
                Exprent nameAssignment = Optional.ofNullable(ifStatement.getStats()).map(stats -> !stats.isEmpty() ? ((Statement)stats.get(0)).getExprents() : null).map(exprs -> exprs.size() == 1 ? (Exprent)exprs.get(0) : null).orElse(null);
                usedAssignments.add(assignmentExprent);
                VarExprent nextValue = null;
                if (nameAssignment instanceof AssignmentExprent && (exprent = (nameAssignmentExprent = (AssignmentExprent)nameAssignment).getLeft()) instanceof VarExprent) {
                    VarExprent varExprent = (VarExprent)exprent;
                    this.myTempVarAssignments.add(new SwitchHelper.TempVarAssignmentItem(varExprent, ifStatement));
                    nextValue = varExprent;
                }
                if (variableCandidates != null && variableCandidates.size() == 1) {
                    nextValue = variableCandidates.get(0).getVarExprent();
                }
                container.replacePattern(previousValueStatement, ifExprent.getCondition(), newCaseStatement, nextValue);
            }
            return container;
        }

        @Nullable
        private PatternHelper.PatternVariableCandidate normalizeCandidateWithBrokenEdges(@NotNull PatternHelper.PatternVariableCandidate oldCandidate, @NotNull SequenceStatement newSequence, @NotNull SequenceStatement previousSequenceStatement, @NotNull Statement last, @Nullable DoStatement doStatement, @NotNull Set<AssignmentExprent> assignmentExprents, @NotNull AssignmentExprent assignmentExprent) {
            IfStatement ifStatement;
            PatternHelper.PatternVariableCandidate candidate = oldCandidate;
            Statement nextStatement = candidate.getNextStatement();
            if (nextStatement == newSequence) {
                candidate = new PatternHelper.PatternVariableCandidate(candidate.getVarExprent(), previousSequenceStatement, candidate.getUsedIfStatement(), candidate.getTempAssignments(), candidate.getCleaner());
            } else if (nextStatement instanceof IfStatement && (ifStatement = (IfStatement)nextStatement).getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL).size() == 1 && ifStatement.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL).get(0).getDestination() == last) {
                ArrayList<Statement> statements = new ArrayList<Statement>();
                statements.add(ifStatement);
                statements.add(last);
                candidate = new PatternHelper.PatternVariableCandidate(candidate.getVarExprent(), new SequenceStatement(statements), candidate.getUsedIfStatement(), candidate.getTempAssignments(), candidate.getCleaner());
            } else if (nextStatement instanceof SequenceStatement) {
                SequenceStatement nextSeqStat = (SequenceStatement)nextStatement;
                if (nextSeqStat.getStats().isEmpty()) {
                    return null;
                }
                Statement lastNextStatement = (Statement)nextSeqStat.getStats().get(nextSeqStat.getStats().size() - 1);
                List<StatEdge> edges = lastNextStatement.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
                if (edges.size() != 1) {
                    return null;
                }
                StatEdge edge = edges.get(0);
                if (edge.getDestination() != last) {
                    if (!this.edgeCanBeWayOutOfRoot(doStatement, edge)) {
                        return null;
                    }
                    assignmentExprents.add(assignmentExprent);
                }
                nextSeqStat.getStats().addWithKey(last, last.id);
            } else {
                StatEdge edge;
                List<StatEdge> edges = nextStatement.getSuccessorEdges(StatEdge.EdgeType.ALL);
                if (edges.size() == 1 && edges.get(0).getType() == StatEdge.EdgeType.BREAK && this.edgeCanBeWayOutOfRoot(doStatement, edge = edges.get(0))) {
                    assignmentExprents.add(assignmentExprent);
                }
            }
            return candidate;
        }

        private boolean edgeCanBeWayOutOfRoot(@Nullable DoStatement doStatement, @NotNull StatEdge edge) {
            DoStatement upperDoStatement;
            Statement statement;
            return edge.getDestination() instanceof DummyExitStatement || doStatement == null && edge.closure == this.myRootSwitchStatement || doStatement != null && edge.closure == doStatement || doStatement != null && (statement = edge.closure) instanceof DoStatement && (upperDoStatement = (DoStatement)statement).containsStatement(doStatement) || this.outsideCatch(edge, doStatement);
        }

        private boolean outsideCatch(@NotNull StatEdge edge, @Nullable DoStatement doStatement) {
            Statement destination = edge.getDestination();
            Statement parent = destination.getParent();
            int indexOf = parent.getStats().indexOf(destination);
            if (indexOf < 1) {
                return false;
            }
            Statement previousStatement = (Statement)parent.getStats().get(indexOf - 1);
            return previousStatement.containsStatement(this.myRootSwitchStatement) && (doStatement == null || previousStatement.containsStatement(doStatement));
        }

        @Nullable
        private List<PatternHelper.PatternVariableCandidate> tryToFindNestedSwitch(@NotNull PatternHelper.PatternVariableCandidate previousCandidate, @NotNull Statement caseStatement, @NotNull Set<AssignmentExprent> usedAssignmentExprents, @NotNull PatternHelper.VarTracker varTracker) {
            SwitchExprent switchExprent;
            IMatchable nestedDoStatement;
            HashSet<AssignmentExprent> toAddAssignmentExprent = new HashSet<AssignmentExprent>();
            ArrayList<PatternHelper.PatternVariableCandidate> defaultValue = new ArrayList<PatternHelper.PatternVariableCandidate>();
            defaultValue.add(previousCandidate);
            Statement currentStatement = previousCandidate.getNextStatement();
            VBStyleCollection<Statement, Integer> currentStats = currentStatement.getStats();
            if (currentStats.isEmpty()) {
                return defaultValue;
            }
            SwitchStatement nestedSwitchStatement = null;
            if (!caseStatement.getLabelEdges().isEmpty()) {
                int indexDefaultStatement;
                SwitchStatement upperSwitchStatement;
                DoStatement nestedDoStatement2;
                Statement statement;
                nextStatement = previousCandidate.getNextStatement();
                if (!(nextStatement instanceof SequenceStatement) || (sequenceStatement = (SequenceStatement)nextStatement).getStats().size() != 1 || !(sequenceStatement.getStats().get(0) instanceof BasicBlockStatement) || caseStatement.getLabelEdges().size() != 1) {
                    return defaultValue;
                }
                edge = caseStatement.getLabelEdges().iterator().next();
                if (!(((StatEdge)edge).getType() == StatEdge.EdgeType.BREAK && (statement = ((StatEdge)edge).getDestination()) instanceof DoStatement && ((DoStatement)(upperDoStatement = (DoStatement)statement)).getConditionExprent() == null && ((Statement)upperDoStatement).getStats().size() == 1 && (statement = ((Statement)upperDoStatement).getStats().get(0)) instanceof DoStatement && (nestedDoStatement2 = (DoStatement)statement).getConditionExprent() == null && nestedDoStatement2.getStats().size() == 1 && (statement = nestedDoStatement2.getStats().get(0)) instanceof SwitchStatement)) {
                    return defaultValue;
                }
                SwitchStatement switchStatement = (SwitchStatement)statement;
                Statement statement2 = caseStatement.getParent();
                if (!(statement2 instanceof SwitchStatement) || (upperSwitchStatement = (SwitchStatement)statement2).getCaseStatements().size() != 2) {
                    return defaultValue;
                }
                int indexCurrentStat = upperSwitchStatement.getCaseStatements().indexOf(caseStatement);
                if (indexCurrentStat == -1) {
                    return defaultValue;
                }
                int n = indexDefaultStatement = indexCurrentStat == 0 ? 1 : 0;
                if (!upperSwitchStatement.getCaseEdges().get(indexDefaultStatement).contains(upperSwitchStatement.getDefaultEdge())) {
                    return defaultValue;
                }
                Statement defaultStatement = upperSwitchStatement.getCaseStatements().get(indexDefaultStatement);
                if (defaultStatement.getExprents() == null) {
                    return defaultValue;
                }
                for (Exprent defaultExprent : defaultStatement.getExprents()) {
                    if (!(defaultExprent instanceof AssignmentExprent)) continue;
                    AssignmentExprent assignmentExprent = (AssignmentExprent)defaultExprent;
                    toAddAssignmentExprent.add(assignmentExprent);
                }
                nestedSwitchStatement = switchStatement;
            } else {
                nextStatement = currentStats.get(0);
                if (nextStatement instanceof SwitchStatement) {
                    SwitchStatement switchStatement;
                    nestedSwitchStatement = switchStatement = (SwitchStatement)nextStatement;
                } else {
                    SwitchStatement newSwitchStatement;
                    DoStatement doStatement;
                    if (currentStats.size() < 2) {
                        return defaultValue;
                    }
                    if (!(currentStats.get(0) instanceof BasicBlockStatement)) {
                        return defaultValue;
                    }
                    sequenceStatement = currentStats.get(1);
                    if (sequenceStatement instanceof SwitchStatement) {
                        SwitchStatement switchStatement;
                        nestedSwitchStatement = switchStatement = (SwitchStatement)((Object)sequenceStatement);
                    }
                    if ((edge = currentStats.get(1)) instanceof DoStatement && !(doStatement = (DoStatement)edge).getStats().isEmpty() && (edge = doStatement.getStats().get(0)) instanceof SwitchStatement) {
                        SwitchStatement switchStatement;
                        nestedSwitchStatement = switchStatement = (SwitchStatement)edge;
                    }
                    if ((upperDoStatement = currentStats.get(1)) instanceof DoStatement && (doStatement = (DoStatement)upperDoStatement).getStats().size() == 1 && (upperDoStatement = doStatement.getStats().get(0)) instanceof SequenceStatement && (sequenceStatement = (SequenceStatement)upperDoStatement).getStats().size() == 2 && (upperDoStatement = sequenceStatement.getStats().get(0)) instanceof SwitchStatement) {
                        nestedSwitchStatement = newSwitchStatement = (SwitchStatement)upperDoStatement;
                    }
                    if ((upperDoStatement = currentStats.get(1)) instanceof DoStatement && (doStatement = (DoStatement)upperDoStatement).getStats().size() == 1 && (upperDoStatement = doStatement.getStats().get(0)) instanceof DoStatement && ((Statement)(nestedDoStatement = (DoStatement)upperDoStatement)).getStats().size() == 1 && (upperDoStatement = ((Statement)nestedDoStatement).getStats().get(0)) instanceof SwitchStatement) {
                        nestedSwitchStatement = newSwitchStatement = (SwitchStatement)upperDoStatement;
                    }
                }
            }
            if (nestedSwitchStatement == null) {
                return defaultValue;
            }
            nestedDoStatement = nestedSwitchStatement.getHeadExprent();
            if (!(nestedDoStatement instanceof SwitchExprent) || !((nestedDoStatement = (switchExprent = (SwitchExprent)nestedDoStatement).getValue()) instanceof InvocationExprent)) {
                return defaultValue;
            }
            InvocationExprent invocationExprent = (InvocationExprent)nestedDoStatement;
            SwitchOnReferenceCandidate recognized = new JavacReferenceFinder(varTracker, this.myTypeVars, nestedSwitchStatement, invocationExprent).findCandidate();
            if (recognized == null) {
                return defaultValue;
            }
            VarExprent exprent = previousCandidate.getVarExprent();
            if (!(exprent instanceof RecordVarExprent)) {
                return defaultValue;
            }
            RecordVarExprent currentRecordDeconstruction = (RecordVarExprent)exprent;
            RecordVarExprent component = currentRecordDeconstruction.getDirectComponent(recognized.myPreviousSelector.getInstance());
            if (component == null) {
                return defaultValue;
            }
            ArrayList<PatternHelper.PatternVariableCandidate> candidates = new ArrayList<PatternHelper.PatternVariableCandidate>();
            Map<Integer, String> classes = SwitchPatternHelper.getMapCaseClasses(recognized.myPreviousSelector.getBootstrapArguments());
            for (FullCase fullCase : recognized.mySortedCasesFromRoot) {
                Object nestedPatternVariableCandidate;
                RecordVarExprent copy;
                List<PatternContainer.PatternStatement> nestedPatterns;
                StatEdge edge;
                List<Exprent> fullCaseExprents = fullCase.exprents;
                Statement nestedStatement = fullCase.statement;
                List<StatEdge> edges = nestedStatement.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL);
                if (edges.size() == 1 && ((edge = edges.get(0)).getType() == StatEdge.EdgeType.CONTINUE || edge.getType() == StatEdge.EdgeType.BREAK) && nestedStatement.getExprents() != null) {
                    for (Exprent nestedExprent : nestedStatement.getExprents()) {
                        VarExprent left;
                        AssignmentExprent assignmentExprent;
                        Exprent exprent2;
                        if (!(nestedExprent instanceof AssignmentExprent) || !((exprent2 = (assignmentExprent = (AssignmentExprent)nestedExprent).getLeft()) instanceof VarExprent) || !this.myTypeVars.contains(left = (VarExprent)exprent2)) continue;
                        toAddAssignmentExprent.add(assignmentExprent);
                    }
                }
                if ((nestedPatterns = recognized.myPatternContainer.getPatterns(nestedStatement)) == null || nestedPatterns.isEmpty()) {
                    ConstExprent constExprent;
                    Exprent nestedExprent;
                    if (fullCaseExprents.size() == 2 && (nestedExprent = fullCaseExprents.get(0)) instanceof ConstExprent && (constExprent = (ConstExprent)nestedExprent).getIntValue() == -1) {
                        fullCaseExprents.remove(fullCaseExprents.get(0));
                    }
                    if (fullCaseExprents.size() != 1) {
                        return null;
                    }
                    if (fullCaseExprents.get(0) == null) continue;
                    nestedExprent = fullCaseExprents.get(0);
                    if (!(nestedExprent instanceof ConstExprent)) {
                        return null;
                    }
                    constExprent = (ConstExprent)nestedExprent;
                    String newClassName = classes.get(constExprent.getIntValue());
                    if (newClassName == null) {
                        return null;
                    }
                    copy = currentRecordDeconstruction.copy();
                    RecordVarExprent toReplace = copy.getDirectComponent(recognized.myPreviousSelector.getInstance());
                    if (toReplace == null) {
                        return null;
                    }
                    toReplace.setVarType(new VarType(newClassName));
                    nestedPatternVariableCandidate = new PatternHelper.PatternVariableCandidate(copy, fullCase.statement(), previousCandidate.getUsedIfStatement(), previousCandidate.getTempVarAssignments(), previousCandidate.getCleaner());
                    candidates.add((PatternHelper.PatternVariableCandidate)nestedPatternVariableCandidate);
                    continue;
                }
                for (PatternContainer.PatternStatement nestedPattern : nestedPatterns) {
                    nestedPatternVariableCandidate = nestedPattern.variable;
                    if (nestedPatternVariableCandidate instanceof RecordVarExprent) {
                        RecordVarExprent recordVarExprent;
                        copy = recordVarExprent = (RecordVarExprent)nestedPatternVariableCandidate;
                    } else {
                        if (nestedPattern.variable == null) {
                            return null;
                        }
                        copy = currentRecordDeconstruction.copy();
                        RecordVarExprent toReplace = copy.getDirectComponent(recognized.myPreviousSelector.getInstance());
                        if (toReplace == null) {
                            return null;
                        }
                        if (!toReplace.copyFrom(nestedPattern.variable)) {
                            return null;
                        }
                    }
                    PatternHelper.PatternVariableCandidate nestedPatternVariableCandidate2 = new PatternHelper.PatternVariableCandidate(copy, nestedPattern.caseStatement, previousCandidate.getUsedIfStatement(), previousCandidate.getTempVarAssignments(), previousCandidate.getCleaner());
                    nestedPatternVariableCandidate2.setGuards(nestedPattern.guard);
                    candidates.add(nestedPatternVariableCandidate2);
                }
            }
            if (!candidates.isEmpty()) {
                ((PatternHelper.PatternVariableCandidate)candidates.get(0)).getTempAssignments().addAll(recognized.myTempVarAssignments);
            }
            usedAssignmentExprents.addAll(recognized.myUsedTypeVarAssignments);
            usedAssignmentExprents.addAll(toAddAssignmentExprent);
            this.myUsedSwitch.add(nestedSwitchStatement);
            return candidates;
        }

        private record Root(Statement firstStatement, List<Exprent> firstExprents, DoStatement doParentStatement) {
        }

        private record Initializer(Exprent instance, Exprent nonNullCheck, AssignmentExprent initVar2) {
        }

        private record FullCase(@NotNull Statement statement, @NotNull List<Exprent> exprents, @NotNull List<StatEdge> edges) {
        }

        private record CaseValueWithEdge(@Nullable Exprent exprent, @Nullable StatEdge edge) {
        }
    }

    static class JavacReferenceRecognizer
    implements SwitchHelper.SwitchRecognizer {
        JavacReferenceRecognizer() {
        }

        @Override
        @Nullable
        public SwitchHelper.SwitchOnCandidate recognize(@NotNull SwitchStatement statement, @NotNull InvocationExprent switchSelector) {
            return new JavacReferenceFinder(null, new HashSet<Exprent>(), statement, switchSelector).findCandidate();
        }
    }
}

