"""Data backend. Declarations, file loading."""

from pathlib import Path
from typing import Dict, List, Tuple

from PIL import Image

from .common import normalized

Letter = Tuple[
    Tuple[bool, ...],
    Tuple[bool, ...],
    Tuple[bool, ...],
    Tuple[bool, ...],
    Tuple[bool, ...],
    Tuple[bool, ...],
    Tuple[bool, ...],
    Tuple[bool, ...],
]

__all__ = ["hex_to_color", "color_hexes", "color_to_hex", "font"]

hex_to_color = {
    "0048ba": "Absolute Zero",
    "8ffe09": "Acid green",
    "bd6c48": "Adobe",
    "7cb9e8": "Aero",
    "c9ffe5": "Aero Blue",
    "b284be": "African Violet",
    "72a0c1": "Air Superiority Blue",
    "edeae0": "Alabaster",
    "54ac68": "Algae",
    "21c36f": "Algae green",
    "f0f8ff": "Alice Blue",
    "c46210": "Alloy Orange",
    "efdecd": "Almond",
    "070d0d": "Almost Black",
    "e52b50": "Amaranth",
    "f19cbb": "Amaranth Pink",
    "ab274f": "Amaranth Purple",
    "d3212d": "Amaranth Red",
    "3b7a57": "Amazon",
    "feb308": "Amber",
    "9b5fc0": "Amethyst",
    "a4c639": "Android Green",
    "cd9575": "Antique Brass",
    "665d1e": "Antique Bronze",
    "915c83": "Antique Fuchsia",
    "841b2d": "Antique Ruby",
    "faebd7": "Antique White",
    "6ecb3c": "Apple",
    "76cd26": "Apple Green",
    "ffb16d": "Apricot",
    "13eac9": "Aqua",
    "02d8e9": "Aqua Blue",
    "12e193": "Aqua Green",
    "04d8b2": "Aqua Marine",
    "7fffd4": "Aquamarine",
    "d0ff14": "Arctic Lime",
    "4b5d16": "Army Green",
    "8f9779": "Artichoke",
    "e9d66b": "Arylide Yellow",
    "b2beb5": "Ash Gray",
    "77ab56": "Asparagus",
    "ff9966": "Atomic Tangerine",
    "3d0734": "Aubergine",
    "9a3001": "Auburn",
    "fdee00": "Aureolin",
    "90b134": "Avocado",
    "87a922": "Avocado Green",
    "1d5dec": "Azul",
    "069af3": "Azure",
    "2e5894": "B'dazzled Blue",
    "a2cffe": "Baby Blue",
    "a1caf1": "Baby Blue Eyes",
    "8cff9e": "Baby Green",
    "ffb7ce": "Baby Pink",
    "ab9004": "Baby Poo",
    "937c00": "Baby Poop",
    "8f9805": "Baby Poop Green",
    "fefefa": "Baby Powder",
    "b6c406": "Baby Puke Green",
    "ca9bf7": "Baby Purple",
    "ad900d": "Baby Shit Brown",
    "889717": "Baby Shit Green",
    "ffff7e": "Banana",
    "fae7b5": "Banana Mania",
    "fafe4b": "Banana Yellow",
    "fe46a5": "Barbie Pink",
    "94ac02": "Barf Green",
    "7c0a02": "Barn Red",
    "ac1db8": "Barney",
    "a00498": "Barney Purple",
    "6b7c85": "Battleship Grey",
    "9f8170": "Beaver",
    "e6daa6": "Beige",
    "990f4b": "Berry",
    "9c2542": "Big Dip o'Ruby",
    "b5c306": "Bile",
    "ffe4c4": "Bisque",
    "3d2b1f": "Bistre",
    "cae00d": "Bitter Lemon",
    "bfff00": "Bitter Lime",
    "fe6f5e": "Bittersweet",
    "bf4f51": "Bittersweet Shimmer",
    "000000": "Black",
    "3d0c02": "Black Bean",
    "1b1811": "Black Chocolate",
    "3b2f2f": "Black Coffee",
    "54626f": "Black Coral",
    "3b3c36": "Black Olive",
    "bfafb2": "Black Shadows",
    "ffebcd": "Blanched Almond",
    "afa88b": "Bland",
    "a57164": "Blast-off Bronze",
    "ff6700": "Blaze Orange",
    "318ce7": "Bleu De France",
    "ace5ee": "Blizzard Blue",
    "faf0be": "Blond",
    "770001": "Blood",
    "fe4b03": "Blood Orange",
    "980002": "Blood Red",
    "0000ff": "Blue",
    "a2a2d0": "Blue Bell",
    "2242c7": "Blue Blue",
    "137e6d": "Blue Green",
    "607c8e": "Blue Grey",
    "5dadec": "Blue Jeans",
    "5729ce": "Blue Purple",
    "126180": "Blue Sapphire",
    "5d06e9": "Blue Violet",
    "533cc6": "Blue With A Hint Of Purple",
    "5072a7": "Blue Yonder",
    "0d98ba": "Blue-Green",
    "8a2be2": "Blue-Violet",
    "0f9b8e": "Blue/Green",
    "758da3": "Blue/Grey",
    "5a06ef": "Blue/Purple",
    "464196": "Blueberry",
    "3c69e7": "Bluetiful",
    "2bb179": "Bluey Green",
    "89a0b0": "Bluey Grey",
    "6241c7": "Bluey Purple",
    "2976bb": "Bluish",
    "10a674": "Bluish Green",
    "748b97": "Bluish Grey",
    "703be7": "Bluish Purple",
    "5539cc": "Blurple",
    "f29e8e": "Blush",
    "fe828c": "Blush Pink",
    "79443b": "Bole",
    "e3dac9": "Bone",
    "9bb53c": "Booger",
    "96b403": "Booger Green",
    "7b002c": "Bordeaux",
    "63b365": "Boring Green",
    "044a05": "Bottle Green",
    "87413f": "Brandy",
    "a03623": "Brick",
    "c14a09": "Brick Orange",
    "8f1402": "Brick Red",
    "0bf9ea": "Bright Aqua",
    "0165fc": "Bright Blue",
    "41fdfe": "Bright Cyan",
    "01ff07": "Bright Green",
    "c760ff": "Bright Lavender",
    "26f7fd": "Bright Light Blue",
    "2dfe54": "Bright Light Green",
    "c95efb": "Bright Lilac",
    "87fd05": "Bright Lime",
    "65fe08": "Bright Lime Green",
    "ff08e8": "Bright Magenta",
    "c32148": "Bright Maroon",
    "1974d2": "Bright Navy Blue",
    "9cbb04": "Bright Olive",
    "ff5b00": "Bright Orange",
    "fe01b1": "Bright Pink",
    "be03fd": "Bright Purple",
    "ff000d": "Bright Red",
    "05ffa6": "Bright Sea Green",
    "02ccfe": "Bright Sky Blue",
    "01f9c6": "Bright Teal",
    "0ffef9": "Bright Turquoise",
    "ad0afd": "Bright Violet",
    "fffd01": "Bright Yellow",
    "9dff00": "Bright Yellow Green",
    "ff55a3": "Brilliant Rose",
    "fb607f": "Brink Pink",
    "05480d": "British Racing Green",
    "a87900": "Bronze",
    "653700": "Brown",
    "706c11": "Brown Green",
    "8d8468": "Brown Grey",
    "b96902": "Brown Orange",
    "922b05": "Brown Red",
    "af6e4d": "Brown Sugar",
    "b29705": "Brown Yellow",
    "9c6d57": "Brownish",
    "6a6e09": "Brownish Green",
    "86775f": "Brownish Grey",
    "cb7723": "Brownish Orange",
    "c27e79": "Brownish Pink",
    "76424e": "Brownish Purple",
    "9e3623": "Brownish Red",
    "c9b003": "Brownish Yellow",
    "6f6c0a": "Browny Green",
    "ca6b02": "Browny Orange",
    "7e4071": "Bruise",
    "ff6cb5": "Bubblegum",
    "fe83cc": "Bubblegum Pink",
    "7bb661": "Bud Green",
    "fef69e": "Buff",
    "610023": "Burgundy",
    "deb887": "Burlywood",
    "a17a74": "Burnished Brown",
    "c04e01": "Burnt Orange",
    "9f2305": "Burnt Red",
    "b75203": "Burnt Siena",
    "b04e0f": "Burnt Sienna",
    "a0450e": "Burnt Umber",
    "d5ab09": "Burnt Yellow",
    "6832e3": "Burple",
    "ffff81": "Butter",
    "fffd74": "Butter Yellow",
    "fdb147": "Butterscotch",
    "bd33a4": "Byzantine",
    "702963": "Byzantium",
    "536872": "Cadet",
    "4e7496": "Cadet Blue",
    "91a3b0": "Cadet Grey",
    "006b3c": "Cadmium Green",
    "ed872d": "Cadmium Orange",
    "e30022": "Cadmium Red",
    "fff600": "Cadmium Yellow",
    "a3c1ad": "Cambridge Blue",
    "c69f59": "Camel",
    "efbbcc": "Cameo Pink",
    "7f8f4e": "Camo",
    "526525": "Camo Green",
    "4b6113": "Camouflage Green",
    "fdff63": "Canary",
    "fffe40": "Canary Yellow",
    "ff0800": "Candy Apple Red",
    "ff63e9": "Candy Pink",
    "592720": "Caput Mortuum",
    "af6f09": "Caramel",
    "c41e3a": "Cardinal",
    "00cc99": "Caribbean Green",
    "9d0216": "Carmine",
    "fd798f": "Carnation",
    "ff7fa7": "Carnation Pink",
    "b31b1b": "Carnelian",
    "8ab8fe": "Carolina Blue",
    "ed9121": "Carrot Orange",
    "00563f": "Castleton Green",
    "703642": "Catawba",
    "c95a49": "Cedar Chest",
    "befdb7": "Celadon",
    "2f847c": "Celadon Green",
    "c1fd95": "Celery",
    "b2ffff": "Celeste",
    "246bce": "Celtic Blue",
    "a5a391": "Cement",
    "de0c62": "Cerise",
    "0485d1": "Cerulean",
    "056eee": "Cerulean Blue",
    "6d9bc3": "Cerulean Frost",
    "007aa5": "Cg Blue",
    "e03c31": "Cg Red",
    "f7e7ce": "Champagne",
    "f1ddcf": "Champagne Pink",
    "343837": "Charcoal",
    "3c4142": "Charcoal Grey",
    "232b2b": "Charleston Green",
    "e68fac": "Charm Pink",
    "c1f80a": "Chartreuse",
    "cf0234": "Cherry",
    "ffb7c5": "Cherry Blossom Pink",
    "f7022a": "Cherry Red",
    "742802": "Chestnut",
    "de6fa1": "China Pink",
    "a8516e": "China Rose",
    "aa381e": "Chinese Red",
    "856088": "Chinese Violet",
    "ffb200": "Chinese Yellow",
    "3d1c02": "Chocolate",
    "411900": "Chocolate Brown",
    "ffa700": "Chrome Yellow",
    "98817b": "Cinereous",
    "e34234": "Cinnabar",
    "ac4f06": "Cinnamon",
    "cd607e": "Cinnamon Satin",
    "e4d00a": "Citrine",
    "9fa91f": "Citron",
    "680018": "Claret",
    "b66a50": "Clay",
    "b2713d": "Clay Brown",
    "247afd": "Clear Blue",
    "acc2d9": "Cloudy Blue",
    "1e488f": "Cobalt",
    "030aa7": "Cobalt Blue",
    "875f42": "Cocoa",
    "d2691e": "Cocoa Brown",
    "a6814c": "Coffee",
    "b9d9eb": "Columbia Blue",
    "f88379": "Congo Pink",
    "4984b8": "Cool Blue",
    "33b864": "Cool Green",
    "95a3a6": "Cool Grey",
    "b66325": "Copper",
    "ad6f69": "Copper Penny",
    "cb6d51": "Copper Red",
    "996666": "Copper Rose",
    "ff3800": "Coquelicot",
    "fc5a50": "Coral",
    "ff6163": "Coral Pink",
    "893f45": "Cordovan",
    "fbec5d": "Corn",
    "6a79f7": "Cornflower",
    "5170d7": "Cornflower Blue",
    "fff8dc": "Cornsilk",
    "2e2d88": "Cosmic Cobalt",
    "fff8e7": "Cosmic Latte",
    "ffbcd9": "Cotton Candy",
    "81613c": "Coyote Brown",
    "9e003a": "Cranberry",
    "ffffc2": "Cream",
    "ffffb6": "Creme",
    "8c000f": "Crimson",
    "fffd78": "Custard",
    "00ffff": "Cyan",
    "58427c": "Cyber Grape",
    "ffd300": "Cyber Yellow",
    "f56fa1": "Cyclamen",
    "fedf08": "Dandelion",
    "1b2431": "Dark",
    "05696b": "Dark Aqua",
    "017371": "Dark Aquamarine",
    "ac9362": "Dark Beige",
    "00035b": "Dark Blue",
    "005249": "Dark Blue Green",
    "1f3b4d": "Dark Blue Grey",
    "666699": "Dark Blue-Gray",
    "341c02": "Dark Brown",
    "5d3954": "Dark Byzantium",
    "cf524e": "Dark Coral",
    "26428b": "Dark Cornflower Blue",
    "fff39a": "Dark Cream",
    "0a888a": "Dark Cyan",
    "536878": "Dark Electric Blue",
    "002d04": "Dark Forest Green",
    "9d0759": "Dark Fuchsia",
    "b59410": "Dark Gold",
    "b8860b": "Dark Goldenrod",
    "388004": "Dark Grass Green",
    "033500": "Dark Green",
    "1f6357": "Dark Green Blue",
    "363737": "Dark Grey",
    "29465b": "Dark Grey Blue",
    "d90166": "Dark Hot Pink",
    "1f0954": "Dark Indigo",
    "1a2421": "Dark Jungle Green",
    "9b8f55": "Dark Khaki",
    "483c32": "Dark Lava",
    "856798": "Dark Lavender",
    "9c6da5": "Dark Lilac",
    "84b701": "Dark Lime",
    "7ebd01": "Dark Lime Green",
    "534b4f": "Dark Liver",
    "960056": "Dark Magenta",
    "3c0008": "Dark Maroon",
    "874c62": "Dark Mauve",
    "48c072": "Dark Mint",
    "20c073": "Dark Mint Green",
    "4a5d23": "Dark Moss Green",
    "a88905": "Dark Mustard",
    "000435": "Dark Navy",
    "00022e": "Dark Navy Blue",
    "373e02": "Dark Olive",
    "3c4d03": "Dark Olive Green",
    "c65102": "Dark Orange",
    "9932cc": "Dark Orchid",
    "56ae57": "Dark Pastel Green",
    "de7e5d": "Dark Peach",
    "665fd1": "Dark Periwinkle",
    "cb416b": "Dark Pink",
    "3f012c": "Dark Plum",
    "35063e": "Dark Purple",
    "840000": "Dark Red",
    "b5485d": "Dark Rose",
    "02066f": "Dark Royal Blue",
    "598556": "Dark Sage",
    "c85a53": "Dark Salmon",
    "a88f59": "Dark Sand",
    "11875d": "Dark Sea Green",
    "1fb57a": "Dark Seafoam",
    "3eaf76": "Dark Seafoam Green",
    "3c1414": "Dark Sienna",
    "448ee4": "Dark Sky Blue",
    "214761": "Dark Slate Blue",
    "2f4f4f": "Dark Slategrey",
    "177245": "Dark Spring Green",
    "af884a": "Dark Tan",
    "7f684e": "Dark Taupe",
    "014d4e": "Dark Teal",
    "045c5a": "Dark Turquoise",
    "34013f": "Dark Violet",
    "d5b60a": "Dark Yellow",
    "728f02": "Dark Yellow Green",
    "014182": "Darkish Blue",
    "287c37": "Darkish Green",
    "da467d": "Darkish Pink",
    "751973": "Darkish Purple",
    "a90308": "Darkish Red",
    "00703c": "Dartmouth Green",
    "555555": "Davy's Grey",
    "08787f": "Deep Aqua",
    "040273": "Deep Blue",
    "410200": "Deep Brown",
    "da3287": "Deep Cerise",
    "fad6a5": "Deep Champagne",
    "b94e48": "Deep Chestnut",
    "02590f": "Deep Green",
    "004b49": "Deep Jungle Green",
    "8d5eb7": "Deep Lavender",
    "966ebd": "Deep Lilac",
    "a0025c": "Deep Magenta",
    "dc4d01": "Deep Orange",
    "cb0162": "Deep Pink",
    "36013f": "Deep Purple",
    "9a0200": "Deep Red",
    "c74767": "Deep Rose",
    "ff9933": "Deep Saffron",
    "015482": "Deep Sea Blue",
    "0d75f8": "Deep Sky Blue",
    "4a646c": "Deep Space Sparkle",
    "7e5e60": "Deep Taupe",
    "00555a": "Deep Teal",
    "017374": "Deep Turquoise",
    "490648": "Deep Violet",
    "3b638c": "Denim",
    "3b5b92": "Denim Blue",
    "ccad60": "Desert",
    "edc9af": "Desert Sand",
    "9f8303": "Diarrhea",
    "8a6e45": "Dirt",
    "836539": "Dirt Brown",
    "3f829d": "Dirty Blue",
    "667e2c": "Dirty Green",
    "c87606": "Dirty Orange",
    "ca7b80": "Dirty Pink",
    "734a65": "Dirty Purple",
    "cdc50a": "Dirty Yellow",
    "3e82fc": "Dodger Blue",
    "d71868": "Dogwood Rose",
    "828344": "Drab",
    "749551": "Drab Green",
    "4b0101": "Dried Blood",
    "ff91af": "Drunk-Tank Pink",
    "c3fbf4": "Duck Egg Blue",
    "00009c": "Duke Blue",
    "49759c": "Dull Blue",
    "876e4b": "Dull Brown",
    "74a662": "Dull Green",
    "d8863b": "Dull Orange",
    "d5869d": "Dull Pink",
    "84597e": "Dull Purple",
    "bb3f3f": "Dull Red",
    "5f9e8f": "Dull Teal",
    "eedc5b": "Dull Yellow",
    "4e5481": "Dusk",
    "26538d": "Dusk Blue",
    "475f94": "Dusky Blue",
    "cc7a8b": "Dusky Pink",
    "895b7b": "Dusky Purple",
    "ba6873": "Dusky Rose",
    "b2996e": "Dust",
    "5a86ad": "Dusty Blue",
    "76a973": "Dusty Green",
    "ac86a8": "Dusty Lavender",
    "f0833a": "Dusty Orange",
    "d58a94": "Dusty Pink",
    "825f87": "Dusty Purple",
    "b9484e": "Dusty Red",
    "c0737a": "Dusty Rose",
    "4c9085": "Dusty Teal",
    "efdfbb": "Dutch White",
    "a2653e": "Earth",
    "e1a95f": "Earth Yellow",
    "8cfd7e": "Easter Green",
    "c071fe": "Easter Purple",
    "555d50": "Ebony",
    "feffca": "Ecru",
    "1b1b1b": "Eerie Black",
    "ffffd4": "Egg Shell",
    "380835": "Eggplant",
    "430541": "Eggplant Purple",
    "f0ead6": "Eggshell",
    "c4fff7": "Eggshell Blue",
    "1034a6": "Egyptian Blue",
    "0652ff": "Electric Blue",
    "21fc0d": "Electric Green",
    "6f00ff": "Electric Indigo",
    "a8ff04": "Electric Lime",
    "ff0490": "Electric Pink",
    "aa23ff": "Electric Purple",
    "8f00ff": "Electric Violet",
    "01a049": "Emerald",
    "028f1e": "Emerald Green",
    "6c3082": "Eminence",
    "1b4d3e": "English Green",
    "b48395": "English Lavender",
    "ab4b52": "English Red",
    "cc474b": "English Vermillion",
    "563c5c": "English Violet",
    "00ff40": "Erin",
    "96c8a2": "Eton Blue",
    "05472a": "Evergreen",
    "658cbb": "Faded Blue",
    "7bb274": "Faded Green",
    "f0944d": "Faded Orange",
    "de9dac": "Faded Pink",
    "916e99": "Faded Purple",
    "d3494e": "Faded Red",
    "feff7f": "Faded Yellow",
    "801818": "Falu Red",
    "b53389": "Fandango",
    "de5285": "Fandango Pink",
    "f400a1": "Fashion Fuchsia",
    "cfaf7b": "Fawn",
    "4d5d53": "Feldgrau",
    "63a950": "Fern",
    "548d44": "Fern Green",
    "6c541e": "Field Drab",
    "ff5470": "Fiery Rose",
    "b22222": "Fire Brick",
    "fe0002": "Fire Engine Red",
    "e95c4b": "Fire Opal",
    "e25822": "Flame",
    "3c73a8": "Flat Blue",
    "699d4c": "Flat Green",
    "eedc82": "Flax",
    "0063dc": "Flickr Blue",
    "fb0081": "Flickr Pink",
    "a2006d": "Flirt",
    "fffaf0": "Floral White",
    "15f4ee": "Fluorescent Blue",
    "08ff08": "Fluorescent Green",
    "0aff02": "Fluro Green",
    "90fda9": "Foam Green",
    "0b5509": "Forest",
    "06470c": "Forest Green",
    "154406": "Forrest Green",
    "a67b5b": "French Beige",
    "856d4d": "French Bistre",
    "436bad": "French Blue",
    "fd3f92": "French Fuchsia",
    "86608e": "French Lilac",
    "9efd38": "French Lime",
    "d473d4": "French Mauve",
    "fd6c9e": "French Pink",
    "c72c48": "French Raspberry",
    "f64a8a": "French Rose",
    "77b5fe": "French Sky Blue",
    "8806ce": "French Violet",
    "69d84f": "Fresh Green",
    "58bc08": "Frog Green",
    "e936a7": "Frostbite",
    "ed0dd9": "Fuchsia",
    "cc397b": "Fuchsia Purple",
    "c74375": "Fuchsia Rose",
    "e48400": "Fulvous",
    "cc6666": "Fuzzy Wuzzy",
    "dcdcdc": "Gainsboro",
    "e49b0f": "Gamboge",
    "007f66": "Generic Viridian",
    "f8f8ff": "Ghost White",
    "6082b6": "Glaucous",
    "ab92b3": "Glossy Grape",
    "00ab66": "Go Green",
    "dbb40c": "Gold",
    "85754e": "Gold Fusion",
    "f5bf03": "Golden",
    "b27a01": "Golden Brown",
    "fcc200": "Golden Poppy",
    "fac205": "Golden Rod",
    "fec615": "Golden Yellow",
    "daa520": "Goldenrod",
    "676767": "Granite Gray",
    "a8e4a0": "Granny Smith Apple",
    "6c3461": "Grape",
    "5d1451": "Grape Purple",
    "fd5956": "Grapefruit",
    "5cac2d": "Grass",
    "3f9b0b": "Grass Green",
    "419c03": "Grassy Green",
    "808080": "Gray",
    "00ff00": "Green",
    "5edc1f": "Green Apple",
    "06b48b": "Green Blue",
    "544e03": "Green Brown",
    "77926f": "Green Grey",
    "a7f432": "Green Lizard",
    "6eaea1": "Green Sheen",
    "0cb577": "Green Teal",
    "c9ff27": "Green Yellow",
    "1164b4": "Green-Blue",
    "009966": "Green-Cyan",
    "adff2f": "Green-Yellow",
    "01c08d": "Green/Blue",
    "b5ce08": "Green/Yellow",
    "40a368": "Greenish",
    "c9d179": "Greenish Beige",
    "0b8b87": "Greenish Blue",
    "696112": "Greenish Brown",
    "2afeb7": "Greenish Cyan",
    "96ae8d": "Greenish Grey",
    "bccb7a": "Greenish Tan",
    "32bf84": "Greenish Teal",
    "00fbb0": "Greenish Turquoise",
    "cdfd02": "Greenish Yellow",
    "42b395": "Greeny Blue",
    "696006": "Greeny Brown",
    "7ea07a": "Greeny Grey",
    "c6f808": "Greeny Yellow",
    "929591": "Grey",
    "6b8ba4": "Grey Blue",
    "7f7053": "Grey Brown",
    "789b73": "Grey Green",
    "c3909b": "Grey Pink",
    "826d8c": "Grey Purple",
    "5e9b8a": "Grey Teal",
    "647d8e": "Grey/Blue",
    "86a17d": "Grey/Green",
    "a8a495": "Greyish",
    "5e819d": "Greyish Blue",
    "7a6a4f": "Greyish Brown",
    "82a67d": "Greyish Green",
    "c88d94": "Greyish Pink",
    "887191": "Greyish Purple",
    "719f91": "Greyish Teal",
    "a0bf16": "Gross Green",
    "a99a86": "Grullo",
    "536267": "Gunmetal",
    "446ccf": "Han Blue",
    "5218fa": "Han Purple",
    "3fff00": "Harlequin",
    "da9100": "Harvest Gold",
    "8e7618": "Hazel",
    "ff7a00": "Heat Wave",
    "a484ac": "Heather",
    "d94ff5": "Heliotrope",
    "1bfc06": "Highlighter Green",
    "f0fff0": "Honeydew",
    "006db0": "Honolulu Blue",
    "49796b": "Hooker's Green",
    "9be5aa": "Hospital Green",
    "25ff29": "Hot Green",
    "f504c9": "Hot Magenta",
    "ff028d": "Hot Pink",
    "cb00f5": "Hot Purple",
    "0b4008": "Hunter Green",
    "d6fffa": "Ice",
    "d7fffe": "Ice Blue",
    "71a6d2": "Iceberg",
    "8fae22": "Icky Green",
    "fcf75e": "Icterine",
    "319177": "Illuminating Emerald",
    "ed2939": "Imperial Red",
    "b2ec5d": "Inchworm",
    "4c516d": "Independence",
    "138808": "India Green",
    "850e04": "Indian Red",
    "e3a857": "Indian Yellow",
    "380282": "Indigo",
    "3a18b1": "Indigo Blue",
    "00416a": "Indigo Dye",
    "002fa7": "International Klein Blue",
    "ff4f00": "International Orange",
    "6258c4": "Iris",
    "019529": "Irish Green",
    "f4f0ec": "Isabelline",
    "ffffcb": "Ivory",
    "1fa774": "Jade",
    "2baf6a": "Jade Green",
    "f8de7e": "Jasmine",
    "a50b5e": "Jazzberry Jam",
    "343434": "Jet",
    "f4ca16": "Jonquil",
    "bdda57": "June Bud",
    "048243": "Jungle Green",
    "009337": "Kelley Green",
    "02ab2e": "Kelly Green",
    "3ab09e": "Keppel",
    "5cb200": "Kermit Green",
    "aeff6e": "Key Lime",
    "aaa662": "Khaki",
    "728639": "Khaki Green",
    "9cef43": "Kiwi",
    "8ee53f": "Kiwi Green",
    "e79fc4": "Kobi",
    "6b4423": "Kobicha",
    "354230": "Kombu Green",
    "512888": "Ksu Purple",
    "d6cadd": "Languid Lavender",
    "26619c": "Lapis Lazuli",
    "ffff66": "Laser Lemon",
    "a9ba9d": "Laurel Green",
    "cf1020": "Lava",
    "c79fef": "Lavender",
    "8b88f8": "Lavender Blue",
    "fff0f5": "Lavender Blush",
    "c4c3d0": "Lavender Gray",
    "dd85d7": "Lavender Pink",
    "4da409": "Lawn Green",
    "71aa34": "Leaf",
    "5ca904": "Leaf Green",
    "51b73b": "Leafy Green",
    "ac7434": "Leather",
    "fdff52": "Lemon",
    "fffacd": "Lemon Chiffon",
    "cca01d": "Lemon Curry",
    "fdff00": "Lemon Glacier",
    "adf802": "Lemon Green",
    "bffe28": "Lemon Lime",
    "f6eabe": "Lemon Meringue",
    "fdff38": "Lemon Yellow",
    "545aa7": "Liberty",
    "8fb67b": "Lichen",
    "8cffdb": "Light Aqua",
    "7bfdc7": "Light Aquamarine",
    "fffeb6": "Light Beige",
    "95d0fc": "Light Blue",
    "7efbb3": "Light Blue Green",
    "b7c9e2": "Light Blue Grey",
    "76fda8": "Light Bluish Green",
    "53fe5c": "Light Bright Green",
    "ad8150": "Light Brown",
    "a8415b": "Light Burgundy",
    "f08080": "Light Coral",
    "93ccea": "Light Cornflower Blue",
    "acfffc": "Light Cyan",
    "894585": "Light Eggplant",
    "4f9153": "Light Forest Green",
    "c8ad7f": "Light French Beige",
    "fddc5c": "Light Gold",
    "fafad2": "Light Goldenrod Yellow",
    "9af764": "Light Grass Green",
    "d3d3d3": "Light Gray",
    "96f97b": "Light Green",
    "56fca2": "Light Green Blue",
    "63f7b4": "Light Greenish Blue",
    "d8dcd6": "Light Grey",
    "9dbcd4": "Light Grey Blue",
    "b7e1a1": "Light Grey Green",
    "6d5acf": "Light Indigo",
    "e6f2a2": "Light Khaki",
    "efc0fe": "Light Lavendar",
    "dfc5fe": "Light Lavender",
    "cafffb": "Light Light Blue",
    "c8ffb0": "Light Light Green",
    "edc8ff": "Light Lilac",
    "aefd6c": "Light Lime",
    "b9ff66": "Light Lime Green",
    "fa5ff7": "Light Magenta",
    "a24857": "Light Maroon",
    "c292a1": "Light Mauve",
    "b6ffbb": "Light Mint",
    "a6fbb2": "Light Mint Green",
    "a6c875": "Light Moss Green",
    "f7d560": "Light Mustard",
    "155084": "Light Navy",
    "2e5a88": "Light Navy Blue",
    "4efd54": "Light Neon Green",
    "acbf69": "Light Olive",
    "a4be5c": "Light Olive Green",
    "fdaa48": "Light Orange",
    "b2fba5": "Light Pastel Green",
    "c4fe82": "Light Pea Green",
    "ffd8b1": "Light Peach",
    "c1c6fc": "Light Periwinkle",
    "ffd1df": "Light Pink",
    "9d5783": "Light Plum",
    "bf77f6": "Light Purple",
    "ff474c": "Light Red",
    "ffc5cb": "Light Rose",
    "3a2efe": "Light Royal Blue",
    "bcecac": "Light Sage",
    "fea993": "Light Salmon",
    "98f6b0": "Light Sea Green",
    "a0febf": "Light Seafoam",
    "a7ffb5": "Light Seafoam Green",
    "c6fcff": "Light Sky Blue",
    "778899": "Light Slategrey",
    "b0c4de": "Light Steelblue",
    "fbeeac": "Light Tan",
    "90e4c1": "Light Teal",
    "7ef4cc": "Light Turquoise",
    "b36ff6": "Light Urple",
    "d6b4fc": "Light Violet",
    "fffe7a": "Light Yellow",
    "ccfd7f": "Light Yellow Green",
    "c2ff89": "Light Yellowish Green",
    "75fd63": "Lighter Green",
    "a55af4": "Lighter Purple",
    "3d7afd": "Lightish Blue",
    "61e160": "Lightish Green",
    "a552e6": "Lightish Purple",
    "fe2f4a": "Lightish Red",
    "cea2fd": "Lilac",
    "ae98aa": "Lilac Luster",
    "c48efd": "Liliac",
    "aaff32": "Lime",
    "89fe05": "Lime Green",
    "d0fe1d": "Lime Yellow",
    "195905": "Lincoln Green",
    "faf0e6": "Linen",
    "d5174e": "Lipstick",
    "c0022f": "Lipstick Red",
    "6ca0dc": "Little Boy Blue",
    "674c47": "Liver",
    "987456": "Liver Chestnut",
    "6699cc": "Livid",
    "efb435": "Macaroni And Cheese",
    "cc3336": "Madder Lake",
    "ff00ff": "Magenta",
    "9f4576": "Magenta Haze",
    "aaf0d1": "Magic Mint",
    "f8f4ff": "Magnolia",
    "4a0100": "Mahogany",
    "f4d054": "Maize",
    "6050dc": "Majorelle Blue",
    "0bda51": "Malachite",
    "979aaa": "Manatee",
    "f37a48": "Mandarin",
    "ffa62b": "Mango",
    "ff8243": "Mango Tango",
    "fffa86": "Manilla",
    "74c365": "Mantis",
    "880085": "Mardi Gras",
    "fcc006": "Marigold",
    "042e60": "Marine",
    "01386a": "Marine Blue",
    "650021": "Maroon",
    "ae7181": "Mauve",
    "915f6d": "Mauve Taupe",
    "ef98aa": "Mauvelous",
    "47abcc": "Maximum Blue",
    "30bfbf": "Maximum Blue Green",
    "acace6": "Maximum Blue Purple",
    "5e8c31": "Maximum Green",
    "d9e650": "Maximum Green Yellow",
    "733380": "Maximum Purple",
    "d92121": "Maximum Red",
    "a63a79": "Maximum Red Purple",
    "fafa37": "Maximum Yellow",
    "f2ba49": "Maximum Yellow Red",
    "4c9141": "May Green",
    "73c2fb": "Maya Blue",
    "66cdaa": "Medium Aquamarine",
    "2c6fbb": "Medium Blue",
    "7f5112": "Medium Brown",
    "e2062c": "Medium Candy Apple Red",
    "af4035": "Medium Carmine",
    "39ad48": "Medium Green",
    "7d7f7c": "Medium Grey",
    "ba55d3": "Medium Orchid",
    "f36196": "Medium Pink",
    "9e43a2": "Medium Purple",
    "3cb371": "Medium Sea Green",
    "7b68ee": "Medium Slate Blue",
    "00fa9a": "Medium Spring Green",
    "48d1cc": "Medium Turquoise",
    "c71585": "Medium Violet Red",
    "f8b878": "Mellow Apricot",
    "ff7855": "Melon",
    "730039": "Merlot",
    "4f738e": "Metallic Blue",
    "d3af37": "Metallic Gold",
    "0a7e8c": "Metallic Seaweed",
    "9c7c38": "Metallic Sunburst",
    "e4007c": "Mexican Pink",
    "276ab3": "Mid Blue",
    "50a747": "Mid Green",
    "7ed4e6": "Middle Blue",
    "8dd9cc": "Middle Blue Green",
    "8b72be": "Middle Blue Purple",
    "4d8c57": "Middle Green",
    "acbf60": "Middle Green Yellow",
    "8b8680": "Middle Grey",
    "d982b5": "Middle Purple",
    "e58e73": "Middle Red",
    "a55353": "Middle Red Purple",
    "ffeb00": "Middle Yellow",
    "ecb176": "Middle Yellow Red",
    "03012d": "Midnight",
    "020035": "Midnight Blue",
    "004953": "Midnight Green",
    "280137": "Midnight Purple",
    "ffc40c": "Mikado Yellow",
    "667c3e": "Military Green",
    "7f4e1e": "Milk Chocolate",
    "ffdae9": "Mimi Pink",
    "e3f988": "Mindaro",
    "36747d": "Ming",
    "f5e050": "Minion Yellow",
    "9ffeb0": "Mint",
    "f5fffa": "Mint Cream",
    "8fff9f": "Mint Green",
    "0bf77d": "Minty Green",
    "bbb477": "Misty Moss",
    "ffe4e1": "Misty Rose",
    "ffe4b5": "Moccasin",
    "9d7651": "Mocha",
    "8da399": "Morning Blue",
    "769958": "Moss",
    "658b38": "Moss Green",
    "638b27": "Mossy Green",
    "30ba8f": "Mountain Meadow",
    "997a8d": "Mountbatten Pink",
    "18453b": "Msu Green",
    "735c12": "Mud",
    "60460f": "Mud Brown",
    "606602": "Mud Green",
    "886806": "Muddy Brown",
    "657432": "Muddy Green",
    "bfac05": "Muddy Yellow",
    "920a4e": "Mulberry",
    "6c7a0e": "Murky Green",
    "ba9e88": "Mushroom",
    "ceb301": "Mustard",
    "ac7e04": "Mustard Brown",
    "a8b504": "Mustard Green",
    "d2bd0a": "Mustard Yellow",
    "3b719f": "Muted Blue",
    "5fa052": "Muted Green",
    "d1768f": "Muted Pink",
    "805b87": "Muted Purple",
    "317873": "Myrtle Green",
    "d65282": "Mystic",
    "ad4379": "Mystic Maroon",
    "f6adc6": "Nadeshiko Pink",
    "70b23f": "Nasty Green",
    "ffdead": "Navajo White",
    "01153e": "Navy",
    "001146": "Navy Blue",
    "35530a": "Navy Green",
    "04d9ff": "Neon Blue",
    "0cff0c": "Neon Green",
    "ff4127": "Neon Orange",
    "fe019a": "Neon Pink",
    "bc13fe": "Neon Purple",
    "ff073a": "Neon Red",
    "cfff04": "Neon Yellow",
    "d7837f": "New York Pink",
    "696969": "Nice",
    "107ab0": "Nice Blue",
    "727472": "Nickel",
    "040348": "Night Blue",
    "a4dded": "Non-Photo Blue",
    "e9ffdb": "Nyanza",
    "017b92": "Ocean",
    "03719c": "Ocean Blue",
    "3d9973": "Ocean Green",
    "bf9b0c": "Ocher",
    "bf9005": "Ochre",
    "c69c04": "Ocre",
    "5684ae": "Off Blue",
    "6ba353": "Off Green",
    "ffffe4": "Off White",
    "f1f33f": "Off Yellow",
    "43302e": "Old Burgundy",
    "cfb53b": "Old Gold",
    "fdf5e6": "Old Lace",
    "796878": "Old Lavender",
    "673147": "Old Mauve",
    "c77986": "Old Pink",
    "c87f89": "Old Rose",
    "848482": "Old Silver",
    "6e750e": "Olive",
    "645403": "Olive Brown",
    "6f7632": "Olive Drab",
    "677a04": "Olive Green",
    "c2b709": "Olive Yellow",
    "9ab973": "Olivine",
    "353839": "Onyx",
    "a8c3bc": "Opal",
    "b784a7": "Opera Mauve",
    "f97306": "Orange",
    "be6400": "Orange Brown",
    "ff9f00": "Orange Peel",
    "ff6f52": "Orange Pink",
    "fd411e": "Orange Red",
    "fa5b3d": "Orange Soda",
    "ffad01": "Orange Yellow",
    "ff681f": "Orange-Red",
    "f5bd1f": "Orange-Yellow",
    "fd8d49": "Orangeish",
    "b16002": "Orangey Brown",
    "fa4224": "Orangey Red",
    "fdb915": "Orangey Yellow",
    "fc824a": "Orangish",
    "b25f03": "Orangish Brown",
    "f43605": "Orangish Red",
    "c875c4": "Orchid",
    "f2bdcd": "Orchid Pink",
    "841617": "Ou Crimson Red",
    "2d383a": "Outer Space",
    "ff6e4a": "Outrageous Orange",
    "800020": "Oxblood",
    "002147": "Oxford Blue",
    "1ca9c9": "Pacific Blue",
    "006600": "Pakistan Green",
    "682860": "Palatinate Purple",
    "fff9d0": "Pale",
    "b8ffeb": "Pale Aqua",
    "d0fefe": "Pale Blue",
    "b1916e": "Pale Brown",
    "9bc4e2": "Pale Cerulean",
    "b7fffa": "Pale Cyan",
    "fdde6c": "Pale Gold",
    "eee8aa": "Pale Golden Rod",
    "c7fdb5": "Pale Green",
    "fdfdfe": "Pale Grey",
    "eecffe": "Pale Lavender",
    "b1fc99": "Pale Light Green",
    "e4cbff": "Pale Lilac",
    "befd73": "Pale Lime",
    "b1ff65": "Pale Lime Green",
    "d767ad": "Pale Magenta",
    "fed0fc": "Pale Mauve",
    "b9cc81": "Pale Olive",
    "b1d27b": "Pale Olive Green",
    "ffa756": "Pale Orange",
    "ffe5ad": "Pale Peach",
    "ffcfdc": "Pale Pink",
    "b790d4": "Pale Purple",
    "d9544d": "Pale Red",
    "fdc1c5": "Pale Rose",
    "ffb19a": "Pale Salmon",
    "c9c0bb": "Pale Silver",
    "bdf6fe": "Pale Sky Blue",
    "ecebbd": "Pale Spring Bud",
    "82cbb2": "Pale Teal",
    "a5fbd5": "Pale Turquoise",
    "ceaefa": "Pale Violet",
    "db7093": "Pale Violet Red",
    "ffff84": "Pale Yellow",
    "78184a": "Pansy Purple",
    "009b7d": "Paolo Veronese Green",
    "ffefd5": "Papaya Whip",
    "e63e62": "Paradise Pink",
    "fefcaf": "Parchment",
    "a2bffe": "Pastel Blue",
    "b0ff9d": "Pastel Green",
    "ff964f": "Pastel Orange",
    "ffbacd": "Pastel Pink",
    "caa0ff": "Pastel Purple",
    "db5856": "Pastel Red",
    "fffe71": "Pastel Yellow",
    "800080": "Patriarch",
    "a4bf20": "Pea",
    "8eab12": "Pea Green",
    "929901": "Pea Soup",
    "94a617": "Pea Soup Green",
    "ffb07c": "Peach",
    "ffdab9": "Peach Puff",
    "ff9a8a": "Peachy Pink",
    "016795": "Peacock Blue",
    "cbf85f": "Pear",
    "b768a2": "Pearly Purple",
    "8e82fe": "Periwinkle",
    "8f99fb": "Periwinkle Blue",
    "e12c2c": "Permanent Geranium Lake",
    "8f8ce7": "Perrywinkle",
    "1c39bb": "Persian Blue",
    "00a693": "Persian Green",
    "32127a": "Persian Indigo",
    "d99058": "Persian Orange",
    "f77fbe": "Persian Pink",
    "701c1c": "Persian Plum",
    "cc3333": "Persian Red",
    "fe28a2": "Persian Rose",
    "ec5800": "Persimmon",
    "cd853f": "Peru",
    "005f6a": "Petrol",
    "8ba8b7": "Pewter Blue",
    "000f89": "Phthalo Blue",
    "123524": "Phthalo Green",
    "2e2787": "Picotee Blue",
    "c30b4e": "Pictorial Carmine",
    "e78ea5": "Pig Pink",
    "fddde6": "Piggy Pink",
    "2b5d34": "Pine",
    "0a481e": "Pine Green",
    "2a2f23": "Pine Tree",
    "ff81c0": "Pink",
    "fc74fd": "Pink Flamingo",
    "ffddf4": "Pink Lace",
    "d8b2d1": "Pink Lavender",
    "db4bda": "Pink Purple",
    "f5054f": "Pink Red",
    "f78fa7": "Pink Sherbet",
    "ef1de7": "Pink/Purple",
    "d46a7e": "Pinkish",
    "b17261": "Pinkish Brown",
    "c8aca9": "Pinkish Grey",
    "ff724c": "Pinkish Orange",
    "d648d7": "Pinkish Purple",
    "f10c45": "Pinkish Red",
    "d99b82": "Pinkish Tan",
    "fc86aa": "Pinky",
    "c94cbe": "Pinky Purple",
    "fc2647": "Pinky Red",
    "ddd618": "Piss Yellow",
    "c0fa8b": "Pistachio",
    "e5e4e2": "Platinum",
    "580f41": "Plum",
    "4e0550": "Plum Purple",
    "5946b2": "Plump Purple",
    "40fd14": "Poison Green",
    "5da493": "Polished Pine",
    "8f7303": "Poo",
    "885f01": "Poo Brown",
    "7f5e00": "Poop",
    "7a5901": "Poop Brown",
    "6f7c00": "Poop Green",
    "be4f62": "Popstar",
    "ff5a36": "Portland Orange",
    "b1d1fc": "Powder Blue",
    "ffb2d0": "Powder Pink",
    "0804f9": "Primary Blue",
    "f58025": "Princeton Orange",
    "004577": "Prussian Blue",
    "df00ff": "Psychedelic Purple",
    "a57e52": "Puce",
    "a5a502": "Puke",
    "947706": "Puke Brown",
    "9aae07": "Puke Green",
    "c2be0e": "Puke Yellow",
    "e17701": "Pumpkin",
    "fb7d07": "Pumpkin Orange",
    "0203e2": "Pure Blue",
    "7e1e9c": "Purple",
    "632de9": "Purple Blue",
    "673a3f": "Purple Brown",
    "866f85": "Purple Grey",
    "9678b6": "Purple Mountain Majesty",
    "4e5180": "Purple Navy",
    "e03fd8": "Purple Pink",
    "fe4eda": "Purple Pizzazz",
    "9c51b6": "Purple Plum",
    "990147": "Purple Red",
    "5d21d0": "Purple/Blue",
    "d725de": "Purple/Pink",
    "98568d": "Purpleish",
    "6140ef": "Purpleish Blue",
    "df4ec8": "Purpleish Pink",
    "8756e4": "Purpley",
    "5f34e7": "Purpley Blue",
    "947e94": "Purpley Grey",
    "c83cb9": "Purpley Pink",
    "94568c": "Purplish",
    "601ef9": "Purplish Blue",
    "6b4247": "Purplish Brown",
    "7a687f": "Purplish Grey",
    "ce5dae": "Purplish Pink",
    "b0054b": "Purplish Red",
    "983fb2": "Purply",
    "661aee": "Purply Blue",
    "f075e6": "Purply Pink",
    "9a4eae": "Purpureus",
    "beae8a": "Putty",
    "436b95": "Queen Blue",
    "e8ccd7": "Queen Pink",
    "a6a6a6": "Quick Silver",
    "8e3a59": "Quinacridone Magenta",
    "014600": "Racing Green",
    "ff355e": "Radical Red",
    "2cfa1f": "Radioactive Green",
    "242124": "Raisin Black",
    "b00149": "Raspberry",
    "b3446c": "Raspberry Rose",
    "9a6200": "Raw Sienna",
    "a75e09": "Raw Umber",
    "ff33cc": "Razzle Dazzle Rose",
    "e3256b": "Razzmatazz",
    "8d4e85": "Razzmic Berry",
    "d4ffff": "Really Light Blue",
    "663399": "Rebecca Purple",
    "ff0000": "Red",
    "8b2e16": "Red Brown",
    "fd3c06": "Red Orange",
    "fa2a55": "Red Pink",
    "820747": "Red Purple",
    "fd3a4a": "Red Salsa",
    "9e0168": "Red Violet",
    "8c0034": "Red Wine",
    "ff5349": "Red-Orange",
    "e40078": "Red-Purple",
    "c0448f": "Red-Violet",
    "c44240": "Reddish",
    "7f2b0a": "Reddish Brown",
    "997570": "Reddish Grey",
    "f8481c": "Reddish Orange",
    "fe2c54": "Reddish Pink",
    "910951": "Reddish Purple",
    "6e1005": "Reddy Brown",
    "a45a52": "Redwood",
    "002387": "Resolution Blue",
    "004040": "Rich Black",
    "021bf9": "Rich Blue",
    "720058": "Rich Purple",
    "444c38": "Rifle Green",
    "8af1fe": "Robin Egg Blue",
    "6dedfd": "Robin's Egg",
    "98eff9": "Robin's Egg Blue",
    "8a7f80": "Rocket Metallic",
    "838996": "Roman Silver",
    "fe86a4": "Rosa",
    "cf6275": "Rose",
    "f9429e": "Rose Bonbon",
    "9e5e6f": "Rose Dust",
    "674846": "Rose Ebony",
    "e32636": "Rose Madder",
    "f7879a": "Rose Pink",
    "aa98a9": "Rose Quartz",
    "be013c": "Rose Red",
    "905d5d": "Rose Taupe",
    "ab4e52": "Rose Vale",
    "65000b": "Rosewood",
    "d40000": "Rosso Corsa",
    "bc8f8f": "Rosy Brown",
    "f6688e": "Rosy Pink",
    "ab1239": "Rouge",
    "0c1793": "Royal",
    "0504aa": "Royal Blue",
    "4b006e": "Royal Purple",
    "fada5e": "Royal Yellow",
    "ce4676": "Ruber",
    "d10056": "Rubine Red",
    "ca0147": "Ruby",
    "9b111e": "Ruby Red",
    "a81c07": "Rufous",
    "a13905": "Russet",
    "679267": "Russian Green",
    "32174d": "Russian Violet",
    "a83c09": "Rust",
    "8b3103": "Rust Brown",
    "c45508": "Rust Orange",
    "aa2704": "Rust Red",
    "cd5909": "Rusty Orange",
    "af2f0d": "Rusty Red",
    "043927": "Sacramento State Green",
    "8b4513": "Saddle Brown",
    "ff7800": "Safety Orange",
    "eed202": "Safety Yellow",
    "feb209": "Saffron",
    "87ae73": "Sage",
    "88b378": "Sage Green",
    "ff796c": "Salmon",
    "fe7b7c": "Salmon Pink",
    "e2ca76": "Sand",
    "cba560": "Sand Brown",
    "967117": "Sand Dune",
    "fce166": "Sand Yellow",
    "c9ae74": "Sandstone",
    "f1da7a": "Sandy",
    "c4a661": "Sandy Brown",
    "fdee73": "Sandy Yellow",
    "5c8b15": "Sap Green",
    "2138ab": "Sapphire",
    "0067a5": "Sapphire Blue",
    "cba135": "Satin Sheen Gold",
    "be0119": "Scarlet",
    "ffd800": "School Bus Yellow",
    "66ff66": "Screamin' Green",
    "3c9992": "Sea",
    "047495": "Sea Blue",
    "53fca1": "Sea Green",
    "fff5ee": "Sea Shell",
    "80f9ad": "Seafoam",
    "78d1b6": "Seafoam Blue",
    "7af9ab": "Seafoam Green",
    "59260b": "Seal Brown",
    "18d17b": "Seaweed",
    "35ad6b": "Seaweed Green",
    "ffba00": "Selective Yellow",
    "985e2b": "Sepia",
    "8a795d": "Shadow",
    "778ba5": "Shadow Blue",
    "01b44c": "Shamrock",
    "02c14d": "Shamrock Green",
    "8fd400": "Sheen Green",
    "d98695": "Shimmering Blush",
    "5fa778": "Shiny Shamrock",
    "7f5f00": "Shit",
    "7b5804": "Shit Brown",
    "758000": "Shit Green",
    "fe02a2": "Shocking Pink",
    "9db92c": "Sick Green",
    "94b21c": "Sickly Green",
    "d0e429": "Sickly Yellow",
    "a9561e": "Sienna",
    "c5c9c7": "Silver",
    "acacac": "Silver Chalice",
    "c4aead": "Silver Pink",
    "bfc1c2": "Silver Sand",
    "cb410b": "Sinopia",
    "ff3855": "Sizzling Red",
    "ffdb00": "Sizzling Sunrise",
    "007474": "Skobeloff",
    "82cafc": "Sky",
    "75bbfd": "Sky Blue",
    "cf71af": "Sky Magenta",
    "516572": "Slate",
    "5b7c99": "Slate Blue",
    "708090": "Slate Gray",
    "658d6d": "Slate Green",
    "59656d": "Slate Grey",
    "99cc04": "Slime Green",
    "299617": "Slimy Green",
    "c84186": "Smitten",
    "100c08": "Smoky Black",
    "acbb0d": "Snot",
    "9dc100": "Snot Green",
    "fffafa": "Snow",
    "6488ea": "Soft Blue",
    "6fc276": "Soft Green",
    "fdb0c0": "Soft Pink",
    "a66fb5": "Soft Purple",
    "893843": "Solid Pink",
    "757575": "Sonic Silver",
    "1d2951": "Space Cadet",
    "807532": "Spanish Bistre",
    "0070b8": "Spanish Blue",
    "d10047": "Spanish Carmine",
    "989898": "Spanish Gray",
    "009150": "Spanish Green",
    "e86100": "Spanish Orange",
    "f7bfbe": "Spanish Pink",
    "e60026": "Spanish Red",
    "4c2882": "Spanish Violet",
    "007f5c": "Spanish Viridian",
    "1ef876": "Spearmint",
    "a7fc00": "Spring Bud",
    "87ff2a": "Spring Frost",
    "a9f971": "Spring Green",
    "0a5f38": "Spruce",
    "f2ab15": "Squash",
    "23297a": "St.Patrick's Blue",
    "007bb8": "Star Command Blue",
    "738595": "Steel",
    "5a7d9a": "Steel Blue",
    "6f828a": "Steel Grey",
    "cc33cc": "Steel Pink",
    "5f8a8b": "Steel Teal",
    "ada587": "Stone",
    "507b9c": "Stormy Blue",
    "fcf679": "Straw",
    "fb2943": "Strawberry",
    "0c06f7": "Strong Blue",
    "ff0789": "Strong Pink",
    "914e75": "Sugar Plum",
    "ffdf22": "Sun Yellow",
    "ffc512": "Sunflower",
    "ffda03": "Sunflower Yellow",
    "ffcc33": "Sunglow",
    "fff917": "Sunny Yellow",
    "e3ab57": "Sunray",
    "fffd37": "Sunshine Yellow",
    "cf6ba9": "Super Pink",
    "698339": "Swamp",
    "748500": "Swamp Green",
    "a83731": "Sweet Brown",
    "d1b26f": "Tan",
    "ab7e4c": "Tan Brown",
    "a9be70": "Tan Green",
    "ff9408": "Tangerine",
    "fb4d46": "Tart Orange",
    "b9a281": "Taupe",
    "8b8589": "Taupe Gray",
    "65ab7c": "Tea",
    "bdf8a3": "Tea Green",
    "029386": "Teal",
    "01889f": "Teal Blue",
    "25a36f": "Teal Green",
    "24bca8": "Tealish",
    "0cdc73": "Tealish Green",
    "cf3476": "Telemagenta",
    "ca6641": "Terra Cotta",
    "cb6843": "Terracota",
    "d8bfd8": "Thistle",
    "fc89ac": "Tickle Me Pink",
    "7bf2da": "Tiffany Blue",
    "dbd7d2": "Timberwolf",
    "eee600": "Titanium Yellow",
    "ef4026": "Tomato",
    "ec2d01": "Tomato Red",
    "13bbaf": "Topaz",
    "c7ac7d": "Toupe",
    "61de2a": "Toxic Green",
    "2a7e19": "Tree Green",
    "00755e": "Tropical Rain Forest",
    "010fcc": "True Blue",
    "089404": "True Green",
    "3e8ede": "Tufts Blue",
    "deaa88": "Tumbleweed",
    "06c2ac": "Turquoise",
    "06b1c4": "Turquoise Blue",
    "04f489": "Turquoise Green",
    "75b84f": "Turtle Green",
    "7c4848": "Tuscan Red",
    "c09999": "Tuscany",
    "4e518b": "Twilight",
    "0a437a": "Twilight Blue",
    "8a496b": "Twilight Lavender",
    "66023c": "Tyrian Purple",
    "0033aa": "Ua Blue",
    "d9004c": "Ua Red",
    "31668a": "Ugly Blue",
    "7d7103": "Ugly Brown",
    "7a9703": "Ugly Green",
    "cd7584": "Ugly Pink",
    "a442a0": "Ugly Purple",
    "d0c101": "Ugly Yellow",
    "ff6fff": "Ultra Pink",
    "2000b1": "Ultramarine",
    "1805db": "Ultramarine Blue",
    "b26400": "Umber",
    "ffddca": "Unbleached Silk",
    "5b92e5": "United Nations Blue",
    "644117": "UPS Brown",
    "ae2029": "Upsdell Red",
    "afdbf5": "Uranian Blue",
    "004f98": "Usafa Blue",
    "664228": "Van Dyke Brown",
    "f3e5ab": "Vanilla",
    "f38fa9": "Vanilla Ice",
    "c5b358": "Vegas Gold",
    "750851": "Velvet",
    "c80815": "Venetian Red",
    "43b3ae": "Verdigris",
    "d9381e": "Vermilion",
    "f4320c": "Vermillion",
    "a020f0": "Veronica",
    "000133": "Very Dark Blue",
    "1d0200": "Very Dark Brown",
    "062e03": "Very Dark Green",
    "2a0134": "Very Dark Purple",
    "d5ffff": "Very Light Blue",
    "d3b683": "Very Light Brown",
    "d1ffbd": "Very Light Green",
    "fff4f2": "Very Light Pink",
    "f6cefc": "Very Light Purple",
    "d6fffe": "Very Pale Blue",
    "cffdbc": "Very Pale Green",
    "0339f8": "Vibrant Blue",
    "0add08": "Vibrant Green",
    "ad03de": "Vibrant Purple",
    "9a0eea": "Violet",
    "510ac9": "Violet Blue",
    "fb5ffc": "Violet Pink",
    "a50055": "Violet Red",
    "324ab2": "Violet-Blue",
    "f75394": "Violet-Red",
    "1e9167": "Viridian",
    "009698": "Viridian Green",
    "152eff": "Vivid Blue",
    "9f1d35": "Vivid Burgundy",
    "2fef10": "Vivid Green",
    "9900fa": "Vivid Purple",
    "00ccff": "Vivid Sky Blue",
    "ffa089": "Vivid Tangerine",
    "9f00ff": "Vivid Violet",
    "ceff00": "Volt",
    "a2a415": "Vomit",
    "89a203": "Vomit Green",
    "c7c10c": "Vomit Yellow",
    "004242": "Warm Black",
    "4b57db": "Warm Blue",
    "964e02": "Warm Brown",
    "978a84": "Warm Grey",
    "fb5581": "Warm Pink",
    "952e8f": "Warm Purple",
    "bcf5a6": "Washed Out Green",
    "0e87cc": "Water Blue",
    "fd4659": "Watermelon",
    "3ae57f": "Weird Green",
    "fbdd7e": "Wheat",
    "ffffff": "White",
    "f5f5f5": "White Smoke",
    "a2add0": "Wild Blue Yonder",
    "d470a2": "Wild Orchid",
    "ff43a4": "Wild Strawberry",
    "fc6c85": "Wild Watermelon",
    "3778bf": "Windows Blue",
    "a75502": "Windsor Tan",
    "80013f": "Wine",
    "7b0323": "Wine Red",
    "ff007c": "Winter Sky",
    "20f986": "Wintergreen",
    "56887d": "Wintergreen Dream",
    "a87dc2": "Wisteria",
    "0f4d92": "Yale Blue",
    "ffff00": "Yellow",
    "b79400": "Yellow Brown",
    "c0fb2d": "Yellow Green",
    "cb9d06": "Yellow Ochre",
    "fcb001": "Yellow Orange",
    "ffe36e": "Yellow Tan",
    "9acd32": "Yellow-Green",
    "c8fd3d": "Yellow/Green",
    "faee66": "Yellowish",
    "9b7a01": "Yellowish Brown",
    "b0dd16": "Yellowish Green",
    "ffab0f": "Yellowish Orange",
    "fcfc81": "Yellowish Tan",
    "ae8b0c": "Yellowy Brown",
    "bff128": "Yellowy Green",
    "2e5090": "Yinmn Blue",
    "0014a8": "Zaffre",
    "39a78e": "Zomp",
}
color_hexes = tuple(hex_to_color)
color_to_hex = {normalized(v): k for k, v in hex_to_color.items()}


def load_font() -> Dict[str, Letter]:
    """Load a font into memory.

    :return: Loaded fontmap
    """
    letters: Dict[str, Letter] = {}
    img = Image.open(Path(__file__).absolute().parent / "font.png")  # ToDo make this CLI accessible

    if img.width != len(font_chars) * 8 or img.height != 8:
        raise AssertionError(f"Expected the font image to have size of ({len(font_chars) * 8}, 8), but got {img.size}")

    for char_index, char in enumerate(font_chars):
        letter: List[List[bool]] = [[] for _ in range(8)]

        first, last = 8, -1

        for row in range(8):
            for col in range(8):
                color = sum(img.getpixel((8 * char_index + col, row))) == 0

                letter[row].append(color)

                if color:
                    first = min(first, col)
                    last = max(last, col)

        letters[char] = tuple((*row[max(first, 0) : min(last + 1, 8)], False) for row in letter)  # type: ignore

    return letters


def font(char: str) -> Letter:
    """Font map getter.

    :param char: Character to load
    :return: Fontmap of :param char:. if unknown, full block will be returned
    """
    if len(char) != 1:
        raise AssertionError("Length of char must be 1")
    return chars.get(char, default_char)


font_chars = r"!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~"
chars: Dict[str, Letter] = load_font()
chars[" "] = ((False,) * 4,) * 8  # type: ignore
default_char: Letter = ((*(True,) * 7, False),) * 8  # type: ignore
