# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from pydantic import AnyUrl, BaseModel, ConfigDict, Field, RootModel, conint, constr

from . import v2
#from .partner import v2


class SearchFilter(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str = Field(..., description='Filter a collection by a string search')


class ObjectMeta(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: AnyUrl = Field(
        ...,
        description='Self is a Uniform Resource Locator (URL) at which an object can be addressed. This URL encodes the service location, API version, and other particulars necessary to locate the resource at a point in time',
        examples=['https://api.confluent.cloud/v2/kafka-clusters/lkc-f3a90de'],
    )
    resource_name: Optional[AnyUrl] = Field(
        None,
        description='Resource Name is a Uniform Resource Identifier (URI) that is globally unique across space and time. It is represented as a Confluent Resource Name',
        examples=['crn://confluent.cloud/kafka=lkc-f3a90de'],
    )
    created_at: Optional[datetime] = Field(
        None,
        description='The date and time at which this object was created. It is represented in RFC3339 format and is in UTC.',
        examples=['2006-01-02T15:04:05-07:00'],
    )
    updated_at: Optional[datetime] = Field(
        None,
        description='The date and time at which this object was last updated. It is represented in RFC3339 format and is in UTC.',
        examples=['2006-01-02T15:04:05-07:00'],
    )
    deleted_at: Optional[datetime] = Field(
        None,
        description='The date and time at which this object was (or will be) deleted. It is represented in RFC3339 format and is in UTC.',
        examples=['2006-01-02T15:04:05-07:00'],
    )


class ListMeta(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[AnyUrl] = Field(
        None,
        description='A link to the first page of results. If a response does not contain a first link, then direct navigation to the first page is not supported.',
        examples=['https://api.confluent.cloud/v2/resourcekinds'],
    )
    last: Optional[AnyUrl] = Field(
        None,
        description='A link to the last page of results. If a response does not contain a last link, then direct navigation to the last page is not supported.',
        examples=[
            'https://api.confluent.cloud/v2/resourcekinds?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[AnyUrl] = Field(
        None,
        description='A link to the previous page of results. If a response does not contain a prev link, then either there is no previous data or backwards traversal through the result set is not supported.',
        examples=[
            'https://api.confluent.cloud/v2/resourcekinds?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[AnyUrl] = Field(
        None,
        description='A link to the next page of results. If a response does not contain a next link, then there is no more data available.',
        examples=[
            'https://api.confluent.cloud/v2/resourcekinds?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )
    total_size: Optional[conint(ge=0)] = Field(
        None,
        description='Number of records in the full result set. This response may be paginated and have a smaller number of records.',
        examples=[123],
    )


class ObjectReference(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: constr(min_length=1, max_length=255) = Field(
        ..., description='ID of the referred resource'
    )
    environment: Optional[constr(min_length=1, max_length=255)] = Field(
        None, description='Environment of the referred resource, if env-scoped'
    )
    related: AnyUrl = Field(
        ..., description='API URL for accessing or modifying the referred object'
    )
    resource_name: AnyUrl = Field(
        ..., description='CRN reference to the referred resource'
    )
    api_version: Optional[constr(min_length=1)] = Field(
        None, description='API group and version of the referred resource'
    )
    kind: Optional[constr(min_length=1)] = Field(
        None, description='Kind of the referred resource'
    )


class TypedGlobalObjectReference(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: constr(min_length=1, max_length=255) = Field(
        ..., description='ID of the referred resource'
    )
    related: AnyUrl = Field(
        ..., description='API URL for accessing or modifying the referred object'
    )
    resource_name: AnyUrl = Field(
        ..., description='CRN reference to the referred resource'
    )
    api_version: Optional[constr(min_length=1)] = Field(
        None, description='API group and version of the referred resource'
    )
    kind: Optional[constr(min_length=1)] = Field(
        None, description='Kind of the referred resource'
    )


class TypedEnvScopedObjectReference(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: constr(min_length=1, max_length=255) = Field(
        ..., description='ID of the referred resource'
    )
    environment: Optional[constr(min_length=1, max_length=255)] = Field(
        None, description='Environment of the referred resource, if env-scoped'
    )
    related: AnyUrl = Field(
        ..., description='API URL for accessing or modifying the referred object'
    )
    resource_name: AnyUrl = Field(
        ..., description='CRN reference to the referred resource'
    )
    api_version: Optional[constr(min_length=1)] = Field(
        None, description='API group and version of the referred resource'
    )
    kind: Optional[constr(min_length=1)] = Field(
        None, description='Kind of the referred resource'
    )


class Source(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    pointer: Optional[str] = Field(
        None,
        description='A JSON Pointer [RFC6901] to the associated entity in the request document [e.g. "/spec" for a spec object, or "/spec/title" for a specific field].',
    )
    parameter: Optional[str] = Field(
        None, description='A string indicating which query parameter caused the error.'
    )


class Error(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
        populate_by_name=True,
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='A unique identifier for this particular occurrence of the problem.',
    )
    status: Optional[str] = Field(
        None,
        description='The HTTP status code applicable to this problem, expressed as a string value.',
    )
    code: Optional[str] = Field(
        None,
        description='An application-specific error code, expressed as a string value.',
    )
    title: Optional[str] = Field(
        None,
        description='A short, human-readable summary of the problem. It **SHOULD NOT** change from occurrence to occurrence of the problem, except for purposes of localization.',
    )
    detail: Optional[str] = Field(
        None,
        description='A human-readable explanation specific to this occurrence of the problem.',
    )
    source: Optional[Source] = Field(
        None,
        description='If this error was caused by a particular part of the API request, the source will point to the query string parameter or request body property that caused it.',
    )
    error_code: Optional[int] = None
    message: Optional[str] = None


class MultipleSearchFilter(RootModel[List[str]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: List[str] = Field(
        ..., description='Filter a collection by a string search for one or more values'
    )


class GlobalObjectReference(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: constr(min_length=1, max_length=255) = Field(
        ..., description='ID of the referred resource'
    )
    related: AnyUrl = Field(
        ..., description='API URL for accessing or modifying the referred object'
    )
    resource_name: AnyUrl = Field(
        ..., description='CRN reference to the referred resource'
    )


class EnvScopedObjectReference(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: constr(min_length=1, max_length=255) = Field(
        ..., description='ID of the referred resource'
    )
    environment: Optional[constr(min_length=1, max_length=255)] = Field(
        None, description='Environment of the referred resource, if env-scoped'
    )
    related: AnyUrl = Field(
        ..., description='API URL for accessing or modifying the referred object'
    )
    resource_name: AnyUrl = Field(
        ..., description='CRN reference to the referred resource'
    )


class AclOperation(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str


class AclPatternType(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str


class AclPermission(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str


class AclResourceType(Enum):
    unknown = 'UNKNOWN'
    any = 'ANY'
    topic = 'TOPIC'
    group = 'GROUP'
    cluster = 'CLUSTER'
    transactional_id = 'TRANSACTIONAL_ID'
    delegation_token = 'DELEGATION_TOKEN'


class Datum(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str
    value: Optional[str] = None
    operation: Optional[str] = None


class AlterConfigBatchRequestData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[Datum]
    validate_only: Optional[bool] = None


class AnyValue(RootModel[Optional[Any]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Optional[Any] = None


class AuthorizedOperations(RootModel[List[str]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: List[str]


class ClusterConfigType(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str


class CreateAclRequestData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    resource_type: AclResourceType
    resource_name: str
    pattern_type: AclPatternType
    principal: str
    host: str
    operation: AclOperation
    permission: AclPermission


class CreateAclRequestDataList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[CreateAclRequestData]


class Config(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str
    value: Optional[str] = None


class CreateTopicRequestData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    topic_name: str
    partitions_count: Optional[int] = None
    replication_factor: Optional[int] = None
    configs: Optional[List[Config]] = None
    validate_only: Optional[bool] = None


class ConfigSource(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str


class ConfigSynonymData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str
    value: Optional[str] = None
    source: ConfigSource


class ConsumerGroupState(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str


class ProduceResponseData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    size: int
    type: str


class ProduceRequestData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Optional[str] = None
    data: Optional[AnyValue] = None


class ProduceRequestHeader(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str
    value: Optional[str] = None


class Relationship(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    related: str


class ResourceCollectionMetadata(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: str
    next: Optional[str] = None


class ResourceMetadata(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: str
    resource_name: Optional[str] = None


class UpdateConfigRequestData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    value: Optional[str] = None


class UpdatePartitionCountRequestData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    partitions_count: int


class BrokerReplicaExclusionRequestData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    broker_id: int
    reason: str


class BrokerReplicaExclusionBatchRequestData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[BrokerReplicaExclusionRequestData]


class ConfigData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str
    value: str


class CreateLinkRequestData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    source_cluster_id: Optional[str] = None
    destination_cluster_id: Optional[str] = None
    remote_cluster_id: Optional[str] = Field(
        None, description='The expected remote cluster ID.'
    )
    cluster_link_id: Optional[str] = Field(
        None,
        description="The expected cluster link ID. Can be provided when creating the second side of a bidirectional link for validating the link ID is as expected. If it's not provided, it's inferred from the remote cluster.",
    )
    configs: Optional[List[ConfigData]] = None


class UpdateLinkConfigRequestData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    value: str


class LinkState(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str


class LinkError(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str


class LinkTaskError(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    error_code: str
    error_message: str


class LinkTaskState(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str


class LinkTaskErrorCode(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str


class CreateMirrorTopicRequestData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    source_topic_name: str
    mirror_topic_name: Optional[str] = None
    replication_factor: Optional[int] = None
    configs: Optional[List[ConfigData]] = None


class AlterMirrorsRequestData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    mirror_topic_names: Optional[List[str]] = Field(
        None, description='The mirror topics specified as a list of topic names.'
    )
    mirror_topic_name_pattern: Optional[str] = Field(
        None, description='The mirror topics specified as a pattern.'
    )


class RemoveBrokersRequestData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    broker_ids: List[int]


class PartitionLevelTruncationData(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    partition_id: int
    offset_truncated_to: int
    messages_truncated: int


class MirrorLag(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    partition: int
    lag: int
    last_source_fetch_offset: int


class MirrorTopicStatus(Enum):
    active = 'ACTIVE'
    failed = 'FAILED'
    link_failed = 'LINK_FAILED'
    link_paused = 'LINK_PAUSED'
    paused = 'PAUSED'
    pending_stopped = 'PENDING_STOPPED'
    source_unavailable = 'SOURCE_UNAVAILABLE'
    stopped = 'STOPPED'
    pending_mirror = 'PENDING_MIRROR'
    pending_synchronize = 'PENDING_SYNCHRONIZE'
    pending_setup_for_restore = 'PENDING_SETUP_FOR_RESTORE'
    pending_restore = 'PENDING_RESTORE'


class AnyUnevenLoadStatus(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str


class BalancerStatus(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str


class BrokerTaskType(Enum):
    add_broker = 'add-broker'
    remove_broker = 'remove-broker'


class BrokerTaskStatus(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str


class ExclusionOp(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str


class BrokerReplicaExclusionStatus(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str


class DeprecatedPartitionReassignmentStatus(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str


class DeprecatedBrokerShutdownStatus(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str


class ClusterConfig(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    max_schemas: Optional[int] = Field(
        None,
        alias='maxSchemas',
        description='Maximum number of registered schemas allowed',
        examples=[20000],
    )
    max_requests_per_sec: Optional[int] = Field(
        None,
        alias='maxRequestsPerSec',
        description='Maximum number of allowed requests per second',
        examples=[25],
    )


class CompatibilityCheckResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    is_compatible: Optional[bool] = Field(
        None, description='Whether the compared schemas are compatible'
    )
    messages: Optional[List[str]] = Field(
        None, description='Error messages', examples=[[]]
    )


class ErrorMessage(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    error_code: Optional[int] = Field(None, description='The error code')
    message: Optional[str] = Field(None, description='The error message')


class ExporterUpdateRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    context_type: Optional[str] = Field(
        None,
        alias='contextType',
        description='Context type of the exporter. One of CUSTOM, NONE or AUTO (default)',
        examples=['CUSTOM'],
    )
    context: Optional[str] = Field(
        None,
        description='Customized context of the exporter if contextType equals CUSTOM.',
        examples=['User'],
    )
    subjects: Optional[List[str]] = Field(
        None, description='Name of each exporter subject'
    )
    subject_rename_format: Optional[str] = Field(
        None,
        alias='subjectRenameFormat',
        description='Format string for the subject name in the destination cluster, which may contain ${subject} as a placeholder for the originating subject name. For example, dc_${subject} for the subject orders will map to the destination subject name dc_orders.',
    )
    config: Optional[Dict[str, str]] = Field(
        None, description='The map containing exporter’s configurations'
    )


class ExporterStatusResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Optional[str] = Field(
        None, description='Name of exporter.', examples=['test-exporter']
    )
    state: Optional[str] = Field(
        None,
        description='State of the exporter. Could be STARTING, RUNNING or PAUSED',
        examples=['RUNNING'],
    )
    offset: Optional[int] = Field(
        None, description='Offset of the exporter', examples=[100]
    )
    ts: Optional[int] = Field(
        None, description='Timestamp of the exporter', examples=[1631206325]
    )
    trace: Optional[str] = Field(
        None, description='Error trace of the exporter', examples=['']
    )


class ExporterConfigResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    schema_registry_url: Optional[str] = Field(
        None,
        alias='schema.registry.url',
        description='Config SR URL',
        examples=['<Physical SR Endpoint>'],
    )
    basic_auth_credentials_source: Optional[str] = Field(
        None,
        alias='basic.auth.credentials.source',
        description='Config SR Auth',
        examples=['USER_INFO'],
    )
    basic_auth_user_info: Optional[str] = Field(
        None, alias='basic.auth.user.info', description='Config SR User Info'
    )


class SchemaReference(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Optional[str] = Field(
        None, description='Reference name', examples=['io.confluent.kafka.example.User']
    )
    subject: Optional[str] = Field(
        None, description='Name of the referenced subject', examples=['User']
    )
    version: Optional[int] = Field(
        None, description='Version number of the referenced subject', examples=[1]
    )


class ExporterReference(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Optional[str] = Field(
        None, description='Name of the exporter', examples=['test-exporter']
    )
    context_type: Optional[str] = Field(
        None,
        alias='contextType',
        description='Context type of the exporter. One of CUSTOM, NONE or AUTO (default)',
        examples=['CUSTOM'],
    )
    context: Optional[str] = Field(
        None,
        description='Customized context of the exporter if contextType equals CUSTOM.',
        examples=['User'],
    )
    subjects: Optional[List[str]] = Field(
        None, description='Name of each exporter subject'
    )
    subject_rename_format: Optional[str] = Field(
        None,
        alias='subjectRenameFormat',
        description='Format string for the subject name in the destination cluster, which may contain ${subject} as a placeholder for the originating subject name. For example, dc_${subject} for the subject orders will map to the destination subject name dc_orders.',
    )
    config: Optional[Dict[str, str]] = Field(
        None, description='The map containing exporter’s configurations'
    )


class DefaultMetadata(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    properties: Optional[Dict[str, Any]] = Field(
        None, description='The metadata properties and their new values'
    )


class OverrideMetadata(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    properties: Optional[Dict[str, Any]] = Field(
        None, description='The metadata properties and their new values'
    )


class DefaultRuleSet(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    properties: Optional[Dict[str, Any]] = Field(
        None, description='The metadata properties and their new values'
    )


class OverrideRuleSet(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    properties: Optional[Dict[str, Any]] = Field(
        None, description='The metadata properties and their new values'
    )


class Config1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    alias: Optional[str] = Field(
        None,
        description='If alias is specified, then this subject is an alias for the subject\nnamed by the alias. That means that any reference to this subject\nwill be replaced by the alias.',
    )
    normalize: Optional[bool] = Field(
        None,
        description='If true, then schemas are automatically normalized when registered or\nwhen passed during lookups. This means that clients do not have to\npass the "normalize" query parameter to have normalization occur.',
    )
    compatibility_level: Optional[str] = Field(
        None,
        alias='compatibilityLevel',
        description='Compatibility Level',
        examples=['FULL_TRANSITIVE'],
    )
    compatibility_group: Optional[str] = Field(
        None,
        alias='compatibilityGroup',
        description='Only schemas that belong to the same compatibility group will be\nchecked for compatibility.',
    )
    default_metadata: Optional[DefaultMetadata] = Field(
        None,
        alias='defaultMetadata',
        description='Default value for the metadata to be used during schema registration.',
    )
    override_metadata: Optional[OverrideMetadata] = Field(
        None,
        alias='overrideMetadata',
        description='Override value for the metadata to be used during schema registration.',
    )
    default_rule_set: Optional[DefaultRuleSet] = Field(
        None,
        alias='defaultRuleSet',
        description='Default value for the ruleSet to be used during schema registration.',
    )
    override_rule_set: Optional[OverrideRuleSet] = Field(
        None,
        alias='overrideRuleSet',
        description='Override value for the ruleSet to be used during schema registration.',
    )


class ConfigUpdateRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    alias: Optional[str] = Field(
        None,
        description='If alias is specified, then this subject is an alias for the subject\nnamed by the alias. That means that any reference to this subject\nwill be replaced by the alias.',
    )
    normalize: Optional[bool] = Field(
        None,
        description='If true, then schemas are automatically normalized when registered\nor when passed during lookups. This means that clients do not have\nto pass the "normalize" query parameter to have normalization occur.',
    )
    compatibility: Optional[str] = Field(
        None, description='Compatibility Level', examples=['FULL_TRANSITIVE']
    )
    compatibility_group: Optional[str] = Field(
        None,
        alias='compatibilityGroup',
        description='Only schemas that belong to the same compatibility group will be\nchecked for compatibility.',
    )
    default_metadata: Optional[DefaultMetadata] = Field(
        None,
        alias='defaultMetadata',
        description='Default value for the metadata to be used during schema registration.',
    )
    override_metadata: Optional[OverrideMetadata] = Field(
        None,
        alias='overrideMetadata',
        description='Override value for the metadata to be used during schema registration.',
    )
    default_rule_set: Optional[DefaultRuleSet] = Field(
        None,
        alias='defaultRuleSet',
        description='Default value for the ruleSet to be used during schema registration.',
    )
    override_rule_set: Optional[OverrideRuleSet] = Field(
        None,
        alias='overrideRuleSet',
        description='Override value for the ruleSet to be used during schema registration.',
    )


class Mode(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    mode: Optional[str] = Field(
        None, description='Schema Registry operating mode', examples=['READWRITE']
    )


class ModeUpdateRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    mode: Optional[str] = Field(
        None, description='Schema Registry operating mode', examples=['READWRITE']
    )


class SchemaString(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    schema_type: Optional[str] = Field(
        None, alias='schemaType', description='Schema type', examples=['AVRO']
    )
    schema_: Optional[str] = Field(
        None,
        alias='schema',
        description='Schema string identified by the ID',
        examples=['{"schema": "{"type": "string"}"}'],
    )
    references: Optional[List[SchemaReference]] = Field(
        None, description='References to other schemas'
    )
    max_id: Optional[int] = Field(
        None, alias='maxId', description='Maximum ID', examples=[1]
    )


class SubjectVersion(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    subject: Optional[str] = Field(
        None, description='Name of the subject', examples=['User']
    )
    version: Optional[int] = Field(None, description='Version number', examples=[1])


class ExporterResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Optional[str] = Field(
        None, description='Name of the exporter', examples=['test-exporter']
    )


class RegisterSchemaResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: Optional[int] = Field(
        None, description='Globally unique identifier of the schema', examples=[100001]
    )


class Algorithm(Enum):
    aes128_gcm = 'AES128_GCM'
    aes256_gcm = 'AES256_GCM'
    aes256_siv = 'AES256_SIV'


class Dek(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kek_name: Optional[str] = Field(
        None, alias='kekName', description='Kek name of the dek'
    )
    subject: Optional[str] = Field(None, description='Subject of the dek')
    version: Optional[int] = Field(None, description='Version of the dek')
    algorithm: Optional[Algorithm] = Field(None, description='Algorithm of the dek')
    encrypted_key_material: Optional[str] = Field(
        None,
        alias='encryptedKeyMaterial',
        description='Encrypted key material of the dek',
    )
    key_material: Optional[str] = Field(
        None, alias='keyMaterial', description='Raw key material of the dek'
    )
    ts: Optional[int] = Field(None, description='Timestamp of the dek')
    deleted: Optional[bool] = Field(None, description='Whether the dek is deleted')


class CreateDekRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    subject: Optional[str] = Field(None, description='Subject of the dek')
    version: Optional[int] = Field(None, description='Version of the dek')
    algorithm: Optional[Algorithm] = Field(None, description='Algorithm of the dek')
    encrypted_key_material: Optional[str] = Field(
        None,
        alias='encryptedKeyMaterial',
        description='Encrypted key material of the dek',
    )
    deleted: Optional[bool] = Field(None, description='Whether the dek is deleted')


class Kek(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Optional[str] = Field(None, description='Name of the kek')
    kms_type: Optional[str] = Field(
        None, alias='kmsType', description='KMS type of the kek'
    )
    kms_key_id: Optional[str] = Field(
        None, alias='kmsKeyId', description='KMS key ID of the kek'
    )
    kms_props: Optional[Dict[str, str]] = Field(
        None, alias='kmsProps', description='Properties of the kek'
    )
    doc: Optional[str] = Field(None, description='Description of the kek')
    shared: Optional[bool] = Field(None, description='Whether the kek is shared')
    ts: Optional[int] = Field(None, description='Timestamp of the kek')
    deleted: Optional[bool] = Field(None, description='Whether the kek is deleted')


class CreateKekRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Optional[str] = Field(None, description='Name of the kek')
    kms_type: Optional[str] = Field(
        None, alias='kmsType', description='KMS type of the kek'
    )
    kms_key_id: Optional[str] = Field(
        None, alias='kmsKeyId', description='KMS key ID of the kek'
    )
    kms_props: Optional[Dict[str, str]] = Field(
        None, alias='kmsProps', description='Properties of the kek'
    )
    doc: Optional[str] = Field(None, description='Description of the kek')
    shared: Optional[bool] = Field(None, description='Whether the kek is shared')
    deleted: Optional[bool] = Field(None, description='Whether the kek is deleted')


class UpdateKekRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kms_props: Optional[Dict[str, str]] = Field(
        None, alias='kmsProps', description='Properties of the kek'
    )
    doc: Optional[str] = Field(None, description='Description of the kek')
    shared: Optional[bool] = Field(None, description='Whether the kek is shared')


class Metadata(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    tags: Optional[Dict[str, List[str]]] = None
    properties: Optional[Dict[str, str]] = None
    sensitive: Optional[List[str]] = None


class Kind(Enum):
    transform = 'TRANSFORM'
    condition = 'CONDITION'


class Mode1(Enum):
    upgrade = 'UPGRADE'
    downgrade = 'DOWNGRADE'
    updown = 'UPDOWN'
    write = 'WRITE'
    read = 'READ'
    writeread = 'WRITEREAD'


class Rule(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Optional[str] = Field(None, description='Rule name')
    doc: Optional[str] = Field(None, description='Rule doc')
    kind: Optional[Kind] = Field(None, description='Rule kind')
    mode: Optional[Mode1] = Field(None, description='Rule mode')
    type: Optional[str] = Field(None, description='Rule type')
    tags: Optional[List[str]] = Field(
        None, description='The tags to which this rule applies'
    )
    params: Optional[Dict[str, str]] = Field(
        None, description='Optional params for the rule'
    )
    expr: Optional[str] = Field(None, description='Rule expression')
    on_success: Optional[str] = Field(
        None, alias='onSuccess', description='Rule action on success'
    )
    on_failure: Optional[str] = Field(
        None, alias='onFailure', description='Rule action on failure'
    )
    disabled: Optional[bool] = Field(None, description='Whether the rule is disabled')


class EntityStatus(Enum):
    active = 'ACTIVE'
    deleted = 'DELETED'
    purged = 'PURGED'


class TimeBoundary(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    start_time: Optional[str] = Field(
        None,
        alias='startTime',
        description='The start time of format yyyy/MM/dd HH:mm:ss',
    )
    end_time: Optional[str] = Field(
        None, alias='endTime', description='The end time of format yyyy/MM/dd HH:mm:ss'
    )
    time_zone: Optional[str] = Field(
        None, alias='timeZone', description='The time zone (see java.util.TimeZone)'
    )


class Classification(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type_name: Optional[str] = Field(None, alias='typeName', description='The tag name')
    attributes: Optional[Dict[str, Dict[str, Any]]] = Field(
        None, description='The tag attributes'
    )
    entity_guid: Optional[str] = Field(
        None, alias='entityGuid', description='The internal entity guid'
    )
    entity_status: Optional[EntityStatus] = Field(
        None, alias='entityStatus', description='The entity status'
    )
    propagate: Optional[bool] = Field(None, description='Whether to propagate the tag')
    validity_periods: Optional[List[TimeBoundary]] = Field(
        None, alias='validityPeriods', description='The validity periods'
    )
    remove_propagations_on_entity_delete: Optional[bool] = Field(
        None,
        alias='removePropagationsOnEntityDelete',
        description='Whether to remove propagations on entity delete',
    )


class ClassificationHeader(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type_name: Optional[str] = Field(None, alias='typeName', description='The tag name')
    entity_guid: Optional[str] = Field(
        None, alias='entityGuid', description='The internal entity guid'
    )
    entity_status: Optional[EntityStatus] = Field(
        None, alias='entityStatus', description='The entity status'
    )
    propagate: Optional[bool] = Field(None, description='Whether to propagate the tag')
    remove_propagations_on_entity_delete: Optional[bool] = Field(
        None,
        alias='removePropagationsOnEntityDelete',
        description='Whether to remove propagations on entity delete',
    )


class Status(Enum):
    active = 'ACTIVE'
    deleted = 'DELETED'
    purged = 'PURGED'


class Status1(Enum):
    discovered = 'DISCOVERED'
    proposed = 'PROPOSED'
    imported = 'IMPORTED'
    validated = 'VALIDATED'
    deprecated = 'DEPRECATED'
    obsolete = 'OBSOLETE'
    other = 'OTHER'


class TermAssignmentHeader(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    term_guid: Optional[str] = Field(
        None, alias='termGuid', description='The term guid'
    )
    relation_guid: Optional[str] = Field(
        None, alias='relationGuid', description='The relation guid'
    )
    description: Optional[str] = Field(None, description='The description')
    display_text: Optional[str] = Field(
        None, alias='displayText', description='The display text'
    )
    expression: Optional[str] = Field(None, description='The expression')
    created_by: Optional[str] = Field(
        None, alias='createdBy', description='The creator'
    )
    steward: Optional[str] = Field(None, description='The steward')
    source: Optional[str] = Field(None, description='The source')
    confidence: Optional[int] = Field(None, description='The confidence')
    status: Optional[Status1] = Field(None, description='The status')


class Status2(Enum):
    active = 'ACTIVE'
    deleted = 'DELETED'
    purged = 'PURGED'


class EntityHeader(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type_name: Optional[str] = Field(
        None, alias='typeName', description='The type name'
    )
    attributes: Optional[Dict[str, Any]] = Field(None, description='The attributes')
    guid: Optional[str] = Field(None, description='The internal guid')
    status: Optional[Status2] = Field(None, description='The status')
    display_text: Optional[str] = Field(
        None, alias='displayText', description='The display text'
    )
    classification_names: Optional[List[str]] = Field(
        None, alias='classificationNames', description='The classification (tag) names'
    )
    classifications: Optional[List[Classification]] = Field(
        None, description='The classifications (tags)'
    )
    meaning_names: Optional[List[str]] = Field(
        None, alias='meaningNames', description='The meaning names'
    )
    meanings: Optional[List[TermAssignmentHeader]] = Field(
        None, description='The meanings'
    )
    is_incomplete: Optional[bool] = Field(
        None, alias='isIncomplete', description='Whether is incomplete'
    )
    labels: Optional[List[str]] = Field(None, description='The labels')


class PartialUpdateParams(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type_name: Optional[str] = Field(
        None, alias='typeName', description='The type name'
    )
    attributes: Optional[Dict[str, Any]] = Field(None, description='The attributes')
    guid: Optional[str] = Field(None, description='The internal guid')
    status: Optional[Status2] = Field(None, description='The status')
    classification_names: Optional[List[str]] = Field(
        None, alias='classificationNames', description='The classification (tag) names'
    )
    classifications: Optional[List[ClassificationHeader]] = Field(
        None, description='The classifications (tags)'
    )
    is_incomplete: Optional[bool] = Field(
        None, alias='isIncomplete', description='Whether is incomplete'
    )


class SearchParams(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    include_deleted: Optional[bool] = Field(
        None, alias='includeDeleted', description='Whether to include deleted'
    )
    limit: Optional[int] = Field(None, description='The limit')
    offset: Optional[int] = Field(None, description='The offset')


class SearchResult(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    search_parameters: Optional[SearchParams] = Field(None, alias='searchParameters')
    types: Optional[List[str]] = Field(None, description='The types')
    entities: Optional[List[EntityHeader]] = Field(None, description='The entities')
    referred_entities: Optional[Dict[str, EntityHeader]] = Field(
        None, alias='referredEntities', description='The referred entities'
    )


class Cardinality(Enum):
    single = 'SINGLE'
    list = 'LIST'
    set = 'SET'


class IndexType(Enum):
    default = 'DEFAULT'
    string = 'STRING'


class ConstraintDef(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Optional[str] = Field(None, description='The type')
    params: Optional[Dict[str, Dict[str, Any]]] = Field(None, description='The params')


class Category(Enum):
    primitive = 'PRIMITIVE'
    object_id_type = 'OBJECT_ID_TYPE'
    enum = 'ENUM'
    struct = 'STRUCT'
    classification = 'CLASSIFICATION'
    entity = 'ENTITY'
    array = 'ARRAY'
    map = 'MAP'
    relationship = 'RELATIONSHIP'
    business_metadata = 'BUSINESS_METADATA'


class BusinessMetadataResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type_name: Optional[str] = Field(
        None, alias='typeName', description='The business metadata name'
    )
    attributes: Optional[Dict[str, Any]] = Field(
        None, description='The business metadata attributes'
    )
    entity_type: Optional[str] = Field(
        None, alias='entityType', description='The entity type'
    )
    entity_name: Optional[str] = Field(
        None, alias='entityName', description='The qualified name of the entity'
    )
    error: Optional[ErrorMessage] = None


class BusinessMetadata(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type_name: Optional[str] = Field(
        None, alias='typeName', description='The business metadata name'
    )
    attributes: Optional[Dict[str, Any]] = Field(
        None, description='The business metadata attributes'
    )
    entity_type: Optional[str] = Field(
        None, alias='entityType', description='The entity type'
    )
    entity_name: Optional[str] = Field(
        None, alias='entityName', description='The qualified name of the entity'
    )


class TagResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type_name: Optional[str] = Field(None, alias='typeName', description='The tag name')
    attributes: Optional[Dict[str, Any]] = Field(None, description='The tag attributes')
    entity_guid: Optional[str] = Field(
        None, alias='entityGuid', description='The internal entity guid'
    )
    entity_status: Optional[EntityStatus] = Field(
        None, alias='entityStatus', description='The entity status'
    )
    propagate: Optional[bool] = Field(None, description='Whether to propagate the tag')
    validity_periods: Optional[List[TimeBoundary]] = Field(
        None, alias='validityPeriods', description='The validity periods'
    )
    remove_propagations_on_entity_delete: Optional[bool] = Field(
        None,
        alias='removePropagationsOnEntityDelete',
        description='Whether to remove propagations on entity delete',
    )
    entity_type: Optional[str] = Field(
        None, alias='entityType', description='The entity type'
    )
    entity_name: Optional[str] = Field(
        None, alias='entityName', description='The qualified name of the entity'
    )
    error: Optional[ErrorMessage] = None


class BooleanFilter(RootModel[bool]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: bool = Field(
        ..., description='Filter for whether this value is true or false.'
    )


class AzureSSOConfig(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AzureSSOConfig'] = Field(..., examples=['AzureSSOConfig'])
    tenant_id: str = Field(
        ...,
        description='The Azure AD tenant ID',
        examples=['b3a17773-05cc-4431-9560-433fb4613da8'],
    )


class PartnerSignupResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    organization_id: str = Field(
        ...,
        description='The ID of the organization',
        examples=['b3a17773-05cc-4431-9560-433fb4613da8'],
    )
    sso_url: AnyUrl = Field(
        ...,
        description='The login URL for the customer to access Confluent Cloud',
        examples=['https://confluent.cloud/login/sso/AzureAD-OIDC-Conn'],
    )
    display_message: Optional[str] = Field(
        None,
        description='The display message contains useful information which is shown on the Marketplace UI to the customers.',
        examples=[
            'Your support plan will remain the same, to change the plan, follow this [link](https://docs.confluent.io/cloud/current/faq.html#how-do-i-change-support-plans).'
        ],
    )


class CostListMeta(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    next: Optional[AnyUrl] = Field(
        None,
        description='A link to the next page of results. If a response does not contain a next link, then there is no more data available.',
        examples=[
            'https://api.confluent.cloud/v2/resourcekinds?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class StatementObjectMeta(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: AnyUrl = Field(
        ...,
        description='Self is a Uniform Resource Locator (URL) at which an object can be addressed. This URL encodes the service location, API version, and other particulars necessary to locate the resource at a point in time',
        examples=[
            'https://flink.us-west1.aws.confluent.cloud/sql/v1/environments/env-123/statements/my-statement'
        ],
    )
    created_at: Optional[datetime] = Field(
        None,
        description='The date and time at which this object was created. It is represented in RFC3339 format and is in UTC.',
        examples=['1996-03-19T01:02:03-04:05'],
    )
    updated_at: Optional[datetime] = Field(
        None,
        description='The date and time at which this object was last updated. It is represented in RFC3339 format and is in UTC.',
        examples=['2023-03-31T00:00:00-00:00'],
    )
    uid: Optional[str] = Field(
        None,
        description='A system generated globally unique identifier for this resource.',
        examples=['12345678-1234-1234-1234-123456789012'],
    )
    resource_version: Optional[str] = Field(
        None,
        description='A system generated string that uniquely identifies the version of this resource.',
        examples=['a23av'],
    )
    labels: Optional[Dict[str, str]] = Field(
        None,
        description='A map of key-value pairs that describe the resource.',
        examples=[{'user.confluent.io/hidden': 'true'}],
    )


class ResultListMeta(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[str] = Field(
        None,
        description='Self is a Uniform Resource Locator (URL) at which an object can be addressed. This URL encodes the service location, API version, and other particulars necessary to locate the resource at a point in time',
        examples=[
            'https://flink.us-west1.aws.confluent.cloud/sql/v1/environments/env-123/statements'
        ],
    )
    next: Optional[str] = Field(
        None,
        description='A URL that can be followed to get the next batch of results.',
        examples=[
            'https://flink.us-west1.aws.confluent.cloud/sql/v1/environments/env-abc123/statements?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )
    created_at: Optional[datetime] = Field(
        None,
        description='The date and time at which this object was created. It is represented in RFC3339 format and is in UTC.',
        examples=['2006-01-02T15:04:05-07:00'],
    )


class ExceptionListMeta(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[str] = Field(
        None,
        description='Self is a Uniform Resource Locator (URL) at which an object can be addressed. This URL encodes the service location, API version, and other particulars necessary to locate the resource at a point in time',
        examples=[
            'https://flink.us-west1.aws.confluent.cloud/sql/v1/environments/env-123/statements/sql123/exceptions'
        ],
    )


class Op(Enum):
    add = 'ADD'
    replace = 'REPLACE'
    test = 'TEST'


class JsonPatchRequestAddReplace(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
        populate_by_name=True,
        use_enum_values=True
    )
    path: str = Field(..., description='A JSON Pointer path.')
    value: Any = Field(..., description='The value to add, replace or test.')
    op: Op = Field(..., description='The operation to perform.')


class Op1(Enum):
    remove = 'REMOVE'


class JsonPatchRequestRemove(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
        populate_by_name=True,
    )
    path: str = Field(..., description='A JSON Pointer path.')
    op: Op1 = Field(..., description='The operation to perform.')


class Op2(Enum):
    move = 'MOVE'
    copy = 'COPY'


class JsonPatchRequestMoveCopy(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
        populate_by_name=True,
    )
    path: str = Field(..., description='A JSON Pointer path.')
    op: Op2 = Field(..., description='The operation to perform.')
    from_: str = Field(..., alias='from', description='A JSON Pointer path.')


class Failure(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    errors: List[Error] = Field(
        ..., description='List of errors which caused this operation to fail'
    )


class ProduceResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    error_code: int
    message: Optional[str] = None
    cluster_id: Optional[str] = None
    topic_name: Optional[str] = None
    partition_id: Optional[int] = None
    offset: Optional[int] = None
    timestamp: Optional[datetime] = None
    key: Optional[ProduceResponseData] = None
    value: Optional[ProduceResponseData] = None


class ProduceRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    partition_id: Optional[int] = None
    headers: Optional[List[ProduceRequestHeader]] = None
    key: Optional[ProduceRequestData] = None
    value: Optional[ProduceRequestData] = None
    timestamp: Optional[datetime] = None


class Resource(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: str
    metadata: ResourceMetadata


class ResourceCollection(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: str
    metadata: ResourceCollectionMetadata


class TopicData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    topic_name: str
    is_internal: bool
    replication_factor: int
    partitions_count: int
    partitions: Relationship
    configs: Relationship
    partition_reassignments: Relationship
    authorized_operations: Optional[AuthorizedOperations] = None


class TopicDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[TopicData]


class ReplicaStatusData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    topic_name: str
    broker_id: int
    partition_id: int
    is_leader: bool
    is_observer: bool
    is_isr_eligible: bool
    is_in_isr: bool
    is_caught_up: bool
    log_start_offset: int
    log_end_offset: int
    last_caught_up_time_ms: int
    last_fetch_time_ms: int
    link_name: Optional[str] = None


class ReplicaStatusDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[ReplicaStatusData]


class AnyUnevenLoadData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    status: AnyUnevenLoadStatus
    previous_status: AnyUnevenLoadStatus
    status_updated_at: datetime = Field(
        ...,
        description='The date and time at which this task was created.',
        examples=['2019-10-12T07:20:50Z'],
    )
    previous_status_updated_at: datetime = Field(
        ...,
        description='The date and time at which this task was created.',
        examples=['2019-10-12T07:20:50Z'],
    )
    error_code: Optional[int] = None
    error_message: Optional[str] = None
    broker_tasks: Relationship


class BalancerStatusData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    status: BalancerStatus
    error_code: Optional[int] = None
    error_message: Optional[str] = None
    any_uneven_load: Relationship
    broker_tasks: Relationship


class BrokerRemovalData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    broker_id: int
    broker_task: Relationship
    broker: Relationship


class BrokerRemovalDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[BrokerRemovalData]


class BrokerTaskData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    broker_id: int
    task_type: BrokerTaskType
    task_status: BrokerTaskStatus
    shutdown_scheduled: Optional[bool] = None
    sub_task_statuses: Dict[str, str]
    created_at: datetime = Field(
        ...,
        description='The date and time at which this task was created.',
        examples=['2019-10-12T07:20:50Z'],
    )
    updated_at: datetime = Field(
        ...,
        description='The date and time at which this task was last updated.',
        examples=['2019-10-12T07:20:50Z'],
    )
    error_code: Optional[int] = None
    error_message: Optional[str] = None
    broker: Relationship


class BrokerTaskDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[BrokerTaskData]


class BrokerReplicaExclusionData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    broker_id: int
    reason: str
    broker: Relationship


class BrokerReplicaExclusionDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[BrokerReplicaExclusionData]


class AlterBrokerReplicaExclusionData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    broker_id: int
    exclusion: ExclusionOp
    reason: str
    error_code: Optional[int] = None
    error_message: Optional[str] = None
    broker: Relationship


class AlterBrokerReplicaExclusionDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[AlterBrokerReplicaExclusionData]


class RemoveBrokerTaskData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    broker_id: int
    shutdown_scheduled: bool
    broker_replica_exclusion_status: BrokerReplicaExclusionStatus
    partition_reassignment_status: DeprecatedPartitionReassignmentStatus
    broker_shutdown_status: DeprecatedBrokerShutdownStatus
    error_code: Optional[int] = None
    error_message: Optional[str] = None
    broker: Relationship


class RemoveBrokerTaskDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[RemoveBrokerTaskData]


class LinkTask(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    task_name: str
    state: LinkTaskState
    errors: List[LinkTaskError]


class ListLinksResponseData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    source_cluster_id: Optional[str] = None
    destination_cluster_id: Optional[str] = None
    remote_cluster_id: Optional[str] = None
    link_name: str
    link_id: Optional[str] = None
    cluster_link_id: str
    topic_names: List[str]
    link_error: Optional[LinkError] = None
    link_error_message: Optional[str] = None
    link_state: Optional[LinkState] = None
    tasks: Optional[List[LinkTask]] = None


class ListLinksResponseDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[ListLinksResponseData]


class ListLinkConfigsResponseData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    name: str
    value: str
    read_only: bool
    sensitive: bool
    source: str
    synonyms: List[str]
    link_name: str


class ListLinkConfigsResponseDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[ListLinkConfigsResponseData]


class PartitionLevelTruncationDataList(RootModel[List[PartitionLevelTruncationData]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: List[PartitionLevelTruncationData]


class MirrorLags(RootModel[List[MirrorLag]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: List[MirrorLag]


class RegisterExporterRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    references: Optional[List[ExporterReference]] = Field(
        None, description='References to other schemas'
    )


class RuleSet(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    migration_rules: Optional[List[Rule]] = Field(None, alias='migrationRules')
    domain_rules: Optional[List[Rule]] = Field(None, alias='domainRules')


class Tag(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type_name: Optional[str] = Field(None, alias='typeName', description='The tag name')
    attributes: Optional[Dict[str, Any]] = Field(None, description='The tag attributes')
    entity_guid: Optional[str] = Field(
        None, alias='entityGuid', description='The internal entity guid'
    )
    entity_status: Optional[EntityStatus] = Field(
        None, alias='entityStatus', description='The entity status'
    )
    propagate: Optional[bool] = Field(None, description='Whether to propagate the tag')
    validity_periods: Optional[List[TimeBoundary]] = Field(
        None, alias='validityPeriods', description='The validity periods'
    )
    remove_propagations_on_entity_delete: Optional[bool] = Field(
        None,
        alias='removePropagationsOnEntityDelete',
        description='Whether to remove propagations on entity delete',
    )
    entity_type: Optional[str] = Field(
        None, alias='entityType', description='The entity type'
    )
    entity_name: Optional[str] = Field(
        None, alias='entityName', description='The qualified name of the entity'
    )


class Entity(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type_name: Optional[str] = Field(
        None, alias='typeName', description='The type name'
    )
    attributes: Optional[Dict[str, Any]] = Field(
        None, description='The type attributes'
    )
    guid: Optional[str] = Field(None, description='The internal guid')
    home_id: Optional[str] = Field(None, alias='homeId', description='The home id')
    is_proxy: Optional[bool] = Field(
        None, alias='isProxy', description='Whether is a proxy'
    )
    is_incomplete: Optional[bool] = Field(
        None, alias='isIncomplete', description='Whether is incomplete'
    )
    provenance_type: Optional[int] = Field(
        None, alias='provenanceType', description='The provenance type'
    )
    status: Optional[Status] = Field(None, description='The status')
    created_by: Optional[str] = Field(
        None, alias='createdBy', description='The creator'
    )
    updated_by: Optional[str] = Field(
        None, alias='updatedBy', description='The updater'
    )
    create_time: Optional[int] = Field(
        None, alias='createTime', description='The create time'
    )
    update_time: Optional[int] = Field(
        None, alias='updateTime', description='The update time'
    )
    version: Optional[int] = Field(None, description='The version')
    relationship_attributes: Optional[Dict[str, Any]] = Field(
        None, alias='relationshipAttributes', description='The relationship attributes'
    )
    classifications: Optional[List[Classification]] = Field(
        None, description='The classifications (tags)'
    )
    meanings: Optional[List[TermAssignmentHeader]] = Field(
        None, description='The meanings'
    )
    custom_attributes: Optional[Dict[str, str]] = Field(
        None, alias='customAttributes', description='The custom attributes'
    )
    business_attributes: Optional[Dict[str, Dict[str, Any]]] = Field(
        None, alias='businessAttributes', description='The business attributes'
    )
    labels: Optional[List[str]] = Field(None, description='The labels')
    proxy: Optional[bool] = Field(None, description='Whether is a proxy')


class EntityWithExtInfo(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    referred_entities: Optional[Dict[str, Entity]] = Field(
        None, alias='referredEntities', description='The referred entities'
    )
    entity: Optional[Entity] = None


class EntityPartialUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    update: Optional[List[PartialUpdateParams]] = Field(
        None, alias='UPDATE', description='The updated entities.'
    )


class AttributeDef(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Optional[str] = Field(None, description='The name')
    type_name: Optional[str] = Field(
        None, alias='typeName', description='The type name'
    )
    is_optional: Optional[bool] = Field(
        None, alias='isOptional', description='Whether is optional'
    )
    cardinality: Optional[Cardinality] = Field(None, description='The cardinality')
    values_min_count: Optional[int] = Field(
        None, alias='valuesMinCount', description='The values min count'
    )
    values_max_count: Optional[int] = Field(
        None, alias='valuesMaxCount', description='The values max count'
    )
    is_unique: Optional[bool] = Field(
        None, alias='isUnique', description='Whether is unique'
    )
    is_indexable: Optional[bool] = Field(
        None, alias='isIndexable', description='Whether is indexable'
    )
    include_in_notification: Optional[bool] = Field(
        None,
        alias='includeInNotification',
        description='Whether to include in notifications',
    )
    default_value: Optional[str] = Field(
        None, alias='defaultValue', description='The default value'
    )
    description: Optional[str] = Field(None, description='The description')
    search_weight: Optional[int] = Field(
        None, alias='searchWeight', description='The search weight'
    )
    index_type: Optional[IndexType] = Field(
        None, alias='indexType', description='The index type'
    )
    constraints: Optional[List[ConstraintDef]] = Field(
        None, description='The constraints'
    )
    options: Optional[Dict[str, str]] = Field(None, description='The options')
    display_name: Optional[str] = Field(
        None, alias='displayName', description='The display name'
    )


class TagDef(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    category: Optional[Category] = Field(None, description='The category')
    guid: Optional[str] = Field(None, description='The internal guid')
    created_by: Optional[str] = Field(
        None, alias='createdBy', description='The creator'
    )
    updated_by: Optional[str] = Field(
        None, alias='updatedBy', description='The updater'
    )
    create_time: Optional[int] = Field(
        None, alias='createTime', description='The create time'
    )
    update_time: Optional[int] = Field(
        None, alias='updateTime', description='The update time'
    )
    version: Optional[int] = Field(None, description='The version')
    name: Optional[str] = Field(None, description='The name')
    description: Optional[str] = Field(None, description='The description')
    type_version: Optional[str] = Field(
        None, alias='typeVersion', description='The type version'
    )
    service_type: Optional[str] = Field(
        None, alias='serviceType', description='The service type'
    )
    options: Optional[Dict[str, str]] = Field(None, description='The options')
    attribute_defs: Optional[List[AttributeDef]] = Field(
        None, alias='attributeDefs', description='The attribute definitions'
    )
    super_types: Optional[List[str]] = Field(
        None, alias='superTypes', description='The supertypes'
    )
    entity_types: Optional[List[str]] = Field(
        None, alias='entityTypes', description='The entity types'
    )
    sub_types: Optional[List[str]] = Field(
        None, alias='subTypes', description='The subtypes'
    )


class BusinessMetadataDefResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    category: Optional[Category] = Field(None, description='The category')
    guid: Optional[str] = Field(None, description='The internal guid')
    created_by: Optional[str] = Field(
        None, alias='createdBy', description='The creator'
    )
    updated_by: Optional[str] = Field(
        None, alias='updatedBy', description='The updater'
    )
    create_time: Optional[int] = Field(
        None, alias='createTime', description='The create time'
    )
    update_time: Optional[int] = Field(
        None, alias='updateTime', description='The update time'
    )
    version: Optional[int] = Field(None, description='The version')
    name: Optional[str] = Field(None, description='The name')
    description: Optional[str] = Field(None, description='The description')
    type_version: Optional[str] = Field(
        None, alias='typeVersion', description='The type version'
    )
    service_type: Optional[str] = Field(
        None, alias='serviceType', description='The service type'
    )
    options: Optional[Dict[str, str]] = Field(None, description='The options')
    attribute_defs: Optional[List[AttributeDef]] = Field(
        None, alias='attributeDefs', description='The attribute definitions'
    )
    error: Optional[ErrorMessage] = None


class BusinessMetadataDef(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    category: Optional[Category] = Field(None, description='The category')
    guid: Optional[str] = Field(None, description='The internal guid')
    created_by: Optional[str] = Field(
        None, alias='createdBy', description='The creator'
    )
    updated_by: Optional[str] = Field(
        None, alias='updatedBy', description='The updater'
    )
    create_time: Optional[int] = Field(
        None, alias='createTime', description='The create time'
    )
    update_time: Optional[int] = Field(
        None, alias='updateTime', description='The update time'
    )
    version: Optional[int] = Field(None, description='The version')
    name: Optional[str] = Field(None, description='The name')
    description: Optional[str] = Field(None, description='The description')
    type_version: Optional[str] = Field(
        None, alias='typeVersion', description='The type version'
    )
    service_type: Optional[str] = Field(
        None, alias='serviceType', description='The service type'
    )
    options: Optional[Dict[str, str]] = Field(None, description='The options')
    attribute_defs: Optional[List[AttributeDef]] = Field(
        None, alias='attributeDefs', description='The attribute definitions'
    )


class TagDefResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    category: Optional[Category] = Field(None, description='The category')
    guid: Optional[str] = Field(None, description='The internal guid')
    created_by: Optional[str] = Field(
        None, alias='createdBy', description='The creator'
    )
    updated_by: Optional[str] = Field(
        None, alias='updatedBy', description='The updater'
    )
    create_time: Optional[int] = Field(
        None, alias='createTime', description='The create time'
    )
    update_time: Optional[int] = Field(
        None, alias='updateTime', description='The update time'
    )
    version: Optional[int] = Field(None, description='The version')
    name: Optional[str] = Field(None, description='The name')
    description: Optional[str] = Field(None, description='The description')
    type_version: Optional[str] = Field(
        None, alias='typeVersion', description='The type version'
    )
    service_type: Optional[str] = Field(
        None, alias='serviceType', description='The service type'
    )
    options: Optional[Dict[str, str]] = Field(None, description='The options')
    attribute_defs: Optional[List[AttributeDef]] = Field(
        None, alias='attributeDefs', description='The attribute definitions'
    )
    super_types: Optional[List[str]] = Field(
        None, alias='superTypes', description='The supertypes'
    )
    entity_types: Optional[List[str]] = Field(
        None, alias='entityTypes', description='The entity types'
    )
    sub_types: Optional[List[str]] = Field(
        None, alias='subTypes', description='The subtypes'
    )
    error: Optional[ErrorMessage] = None


class PartnerSignupRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    organization: v2.Organization
    user: Optional[v2.User] = None
    entitlement: Union[v2.Entitlement, ObjectReference]


class ActivatePartnerSignupRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    user: v2.User
    organization_id: str = Field(
        ...,
        description='The ID of the organization',
        examples=['b3a17773-05cc-4431-9560-433fb4613da8'],
    )


class PartnerLinkRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    token: str = Field(
        ...,
        description='The linking token that was generated.',
        examples=[
            'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiaWF0IjoxNTE2MjM5MDIyfQ.SflKxwRJSMeKKF2QT4fwpMeJf36POk6yJV_adQssw5c'
        ],
    )
    organization: v2.Organization
    entitlement: Union[v2.Entitlement, ObjectReference]


class PatchRequest(
    RootModel[
        List[
            Union[
                JsonPatchRequestAddReplace,
                JsonPatchRequestRemove,
                JsonPatchRequestMoveCopy,
            ]
        ]
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: List[
        Union[
            JsonPatchRequestAddReplace, JsonPatchRequestRemove, JsonPatchRequestMoveCopy
        ]
    ] = Field(
        ...,
        description='PatchRequest represent a json-patch request to be applied to the Statement. See https://tools.ietf.org/html/rfc6902',
    )


class AbstractConfigData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    name: str
    value: Optional[str] = None
    is_default: bool
    is_read_only: bool
    is_sensitive: bool
    source: ConfigSource
    synonyms: List[ConfigSynonymData]


class AclData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    resource_type: AclResourceType
    resource_name: str
    pattern_type: AclPatternType
    principal: str
    host: str
    operation: AclOperation
    permission: AclPermission


class AclDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[AclData]


class BrokerConfigData(AbstractConfigData):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    broker_id: int


class BrokerConfigDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[BrokerConfigData]


class BrokerData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    broker_id: int
    host: Optional[str] = None
    port: Optional[int] = None
    rack: Optional[str] = None
    configs: Relationship
    partition_replicas: Relationship


class BrokerDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[BrokerData]


class ClusterConfigData(AbstractConfigData):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    config_type: ClusterConfigType


class ClusterConfigDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[ClusterConfigData]


class ClusterData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    controller: Optional[Relationship] = None
    acls: Relationship
    brokers: Relationship
    broker_configs: Relationship
    consumer_groups: Relationship
    topics: Relationship
    partition_reassignments: Relationship


class ClusterDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[ClusterData]


class ConsumerAssignmentData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    consumer_group_id: str
    consumer_id: str
    topic_name: str
    partition_id: int
    partition: Relationship
    lag: Relationship


class ConsumerAssignmentDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[ConsumerAssignmentData]


class ConsumerData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    consumer_group_id: str
    consumer_id: str
    instance_id: Optional[str] = None
    client_id: str
    assignments: Relationship


class ConsumerDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[ConsumerData]


class ConsumerGroupData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    consumer_group_id: str
    is_simple: bool
    partition_assignor: str
    state: ConsumerGroupState
    coordinator: Relationship
    consumer: Optional[Relationship] = None
    lag_summary: Relationship


class ConsumerGroupDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[ConsumerGroupData]


class ConsumerLagData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    consumer_group_id: str
    topic_name: str
    partition_id: int
    current_offset: int
    log_end_offset: int
    lag: int
    consumer_id: str
    instance_id: Optional[str] = None
    client_id: str


class ConsumerLagDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[ConsumerLagData]


class ConsumerGroupLagSummaryData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    consumer_group_id: str
    max_lag_consumer_id: str
    max_lag_instance_id: Optional[str] = None
    max_lag_client_id: str
    max_lag_topic_name: str
    max_lag_partition_id: int
    max_lag: int
    total_lag: int
    max_lag_consumer: Relationship
    max_lag_partition: Relationship


class PartitionData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    topic_name: str
    partition_id: int
    leader: Optional[Relationship] = None
    replicas: Relationship
    reassignment: Relationship


class PartitionDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[PartitionData]


class ReassignmentData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    topic_name: str
    partition_id: int
    adding_replicas: List[int]
    removing_replicas: List[int]
    replicas: Relationship


class ReassignmentDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[ReassignmentData]


class ReplicaData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    cluster_id: str
    topic_name: str
    partition_id: int
    broker_id: int
    is_leader: bool
    is_in_sync: bool
    broker: Relationship


class ReplicaDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[ReplicaData]


class TopicConfigData(AbstractConfigData):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    topic_name: str


class TopicConfigDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[TopicConfigData]


class ListMirrorTopicsResponseData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    link_name: str
    mirror_topic_name: str
    source_topic_name: str
    num_partitions: int
    mirror_lags: MirrorLags
    mirror_status: MirrorTopicStatus
    state_time_ms: int
    mirror_state_transition_errors: Optional[List[LinkTaskError]] = None


class ListMirrorTopicsResponseDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[ListMirrorTopicsResponseData]


class AlterMirrorStatusResponseData(Resource):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    mirror_topic_name: str
    error_message: str
    error_code: int
    mirror_lags: MirrorLags
    messages_truncated: int
    partition_level_truncation_data: PartitionLevelTruncationDataList


class AlterMirrorStatusResponseDataList(ResourceCollection):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: List[AlterMirrorStatusResponseData]


class RegisterSchemaRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    version: Optional[int] = Field(None, description='Version number')
    id: Optional[int] = Field(
        None, description='Globally unique identifier of the schema'
    )
    schema_type: Optional[str] = Field(
        None, alias='schemaType', description='Schema type'
    )
    references: Optional[List[SchemaReference]] = Field(
        None, description='References to other schemas'
    )
    schema_: Optional[str] = Field(
        None, alias='schema', description='Schema definition string'
    )
    metadata: Optional[Metadata] = None
    rule_set: Optional[RuleSet] = Field(None, alias='ruleSet')


class Schema(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    subject: Optional[str] = Field(
        None, description='Name of the subject', examples=['User']
    )
    version: Optional[int] = Field(None, description='Version number', examples=[1])
    id: Optional[int] = Field(
        None, description='Globally unique identifier of the schema', examples=[100001]
    )
    schema_type: Optional[str] = Field(
        None, alias='schemaType', description='Schema type', examples=['AVRO']
    )
    references: Optional[List[SchemaReference]] = Field(
        None, description='References to other schemas'
    )
    schema_: Optional[str] = Field(
        None,
        alias='schema',
        description='Schema definition string',
        examples=['{"schema": "{"type": "string"}"}'],
    )
    metadata: Optional[Metadata] = None
    rule_set: Optional[RuleSet] = Field(None, alias='ruleSet')


class EntityPartialUpdateResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    mutated_entities: Optional[EntityPartialUpdate] = Field(
        None, alias='mutatedEntities'
    )


class ColumnDetails(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str = Field(
        ..., description='The name of the SQL table column.', examples=['Column_Name']
    )
    type: DataType = Field(
        ...,
        description='JSON object in TableSchema format; describes the data returned by the results serving API.',
        examples=[{'type': 'CHAR', 'nullable': True, 'length': 8}],
    )


class DataType(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: str = Field(..., description='The data type of the column.')
    nullable: bool = Field(
        ..., description='Indicates whether values in this column can be null.'
    )
    length: Optional[int] = Field(None, description='The length of the data type.')
    precision: Optional[int] = Field(
        None, description='The precision of the data type.'
    )
    scale: Optional[int] = Field(None, description='The scale of the data type.')
    key_type: Optional[DataType] = Field(
        None, description='The type of the key in the data type (if applicable).'
    )
    value_type: Optional[DataType] = Field(
        None, description='The type of the value in the data type (if applicable).'
    )
    element_type: Optional[DataType] = Field(
        None, description='The type of the element in the data type (if applicable).'
    )
    fields: Optional[List[RowFieldType]] = Field(
        None, description='The fields of the element in the data type (if applicable).'
    )
    resolution: Optional[str] = Field(
        None, description='The resolution of the data type (if applicable).'
    )
    fractional_precision: Optional[int] = Field(
        None, description='The fractional precision of the data type (if applicable).'
    )


class RowFieldType(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str = Field(..., description='The name of the field.')
    field_type: DataType = Field(..., description='The data type of the field.')
    description: Optional[str] = Field(
        None, description='The description of the field.'
    )


ColumnDetails.model_rebuild()
DataType.model_rebuild()
