"use strict";
/* istanbul ignore file */
Object.defineProperty(exports, "__esModule", { value: true });
exports.external = void 0;
// eslint-disable-next-line import/no-extraneous-dependencies
const aws = require("aws-sdk");
const tls = require("tls");
const url = require("url");
let client;
function iam() {
    if (!client) {
        client = new aws.IAM();
    }
    return client;
}
function defaultLogger(fmt, ...args) {
    // tslint:disable-next-line: no-console
    console.log(fmt, ...args);
}
/**
 * Downloads the CA thumbprint from the issuer URL
 */
async function downloadThumbprint(issuerUrl) {
    exports.external.log(`downloading certificate authority thumbprint for ${issuerUrl}`);
    return new Promise((ok, ko) => {
        const purl = url.parse(issuerUrl);
        const port = purl.port ? parseInt(purl.port, 10) : 443;
        if (!purl.host) {
            return ko(new Error(`unable to determine host from issuer url ${issuerUrl}`));
        }
        const socket = tls.connect(port, purl.host, { rejectUnauthorized: false });
        socket.once('error', ko);
        socket.once('secureConnect', () => {
            const cert = socket.getPeerCertificate();
            socket.end();
            const thumbprint = cert.fingerprint.split(':').join('');
            exports.external.log(`certificate authority thumbprint for ${issuerUrl} is ${thumbprint}`);
            ok(thumbprint);
        });
    });
}
// allows unit test to replace with mocks
// tslint:disable:max-line-length
exports.external = {
    downloadThumbprint,
    log: defaultLogger,
    createOpenIDConnectProvider: (req) => iam().createOpenIDConnectProvider(req).promise(),
    deleteOpenIDConnectProvider: (req) => iam().deleteOpenIDConnectProvider(req).promise(),
    updateOpenIDConnectProviderThumbprint: (req) => iam().updateOpenIDConnectProviderThumbprint(req).promise(),
    addClientIDToOpenIDConnectProvider: (req) => iam().addClientIDToOpenIDConnectProvider(req).promise(),
    removeClientIDFromOpenIDConnectProvider: (req) => iam().removeClientIDFromOpenIDConnectProvider(req).promise(),
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXh0ZXJuYWwuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJleHRlcm5hbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsMEJBQTBCOzs7QUFFMUIsNkRBQTZEO0FBQzdELCtCQUErQjtBQUMvQiwyQkFBMkI7QUFDM0IsMkJBQTJCO0FBRTNCLElBQUksTUFBZSxDQUFDO0FBRXBCLFNBQVMsR0FBRztJQUNWLElBQUksQ0FBQyxNQUFNLEVBQUU7UUFBRSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7S0FBRTtJQUN4QyxPQUFPLE1BQU0sQ0FBQztBQUNoQixDQUFDO0FBRUQsU0FBUyxhQUFhLENBQUMsR0FBVyxFQUFFLEdBQUcsSUFBVztJQUNoRCx1Q0FBdUM7SUFDdkMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxHQUFHLEVBQUUsR0FBRyxJQUFJLENBQUMsQ0FBQztBQUM1QixDQUFDO0FBRUQ7O0dBRUc7QUFDSCxLQUFLLFVBQVUsa0JBQWtCLENBQUMsU0FBaUI7SUFDakQsZ0JBQVEsQ0FBQyxHQUFHLENBQUMsb0RBQW9ELFNBQVMsRUFBRSxDQUFDLENBQUM7SUFDOUUsT0FBTyxJQUFJLE9BQU8sQ0FBUyxDQUFDLEVBQUUsRUFBRSxFQUFFLEVBQUUsRUFBRTtRQUNwQyxNQUFNLElBQUksR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQ2xDLE1BQU0sSUFBSSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUM7UUFDdkQsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUU7WUFDZCxPQUFPLEVBQUUsQ0FBQyxJQUFJLEtBQUssQ0FBQyw0Q0FBNEMsU0FBUyxFQUFFLENBQUMsQ0FBQyxDQUFDO1NBQy9FO1FBQ0QsTUFBTSxNQUFNLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksRUFBRSxFQUFFLGtCQUFrQixFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7UUFDM0UsTUFBTSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDekIsTUFBTSxDQUFDLElBQUksQ0FBQyxlQUFlLEVBQUUsR0FBRyxFQUFFO1lBQ2hDLE1BQU0sSUFBSSxHQUFHLE1BQU0sQ0FBQyxrQkFBa0IsRUFBRSxDQUFDO1lBQ3pDLE1BQU0sQ0FBQyxHQUFHLEVBQUUsQ0FBQztZQUNiLE1BQU0sVUFBVSxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsQ0FBQztZQUN4RCxnQkFBUSxDQUFDLEdBQUcsQ0FBQyx3Q0FBd0MsU0FBUyxPQUFPLFVBQVUsRUFBRSxDQUFDLENBQUM7WUFDbkYsRUFBRSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ2pCLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQyxDQUFDLENBQUM7QUFDTCxDQUFDO0FBRUQseUNBQXlDO0FBQ3pDLGlDQUFpQztBQUNwQixRQUFBLFFBQVEsR0FBRztJQUN0QixrQkFBa0I7SUFDbEIsR0FBRyxFQUFFLGFBQWE7SUFDbEIsMkJBQTJCLEVBQUUsQ0FBQyxHQUErQyxFQUFFLEVBQUUsQ0FBQyxHQUFHLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxHQUFHLENBQUMsQ0FBQyxPQUFPLEVBQUU7SUFDbEksMkJBQTJCLEVBQUUsQ0FBQyxHQUErQyxFQUFFLEVBQUUsQ0FBQyxHQUFHLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxHQUFHLENBQUMsQ0FBQyxPQUFPLEVBQUU7SUFDbEkscUNBQXFDLEVBQUUsQ0FBQyxHQUF5RCxFQUFFLEVBQUUsQ0FBQyxHQUFHLEVBQUUsQ0FBQyxxQ0FBcUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxPQUFPLEVBQUU7SUFDaEssa0NBQWtDLEVBQUUsQ0FBQyxHQUFzRCxFQUFFLEVBQUUsQ0FBQyxHQUFHLEVBQUUsQ0FBQyxrQ0FBa0MsQ0FBQyxHQUFHLENBQUMsQ0FBQyxPQUFPLEVBQUU7SUFDdkosdUNBQXVDLEVBQUUsQ0FBQyxHQUEyRCxFQUFFLEVBQUUsQ0FBQyxHQUFHLEVBQUUsQ0FBQyx1Q0FBdUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxPQUFPLEVBQUU7Q0FDdkssQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qIGlzdGFuYnVsIGlnbm9yZSBmaWxlICovXG5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBpbXBvcnQvbm8tZXh0cmFuZW91cy1kZXBlbmRlbmNpZXNcbmltcG9ydCAqIGFzIGF3cyBmcm9tICdhd3Mtc2RrJztcbmltcG9ydCAqIGFzIHRscyBmcm9tICd0bHMnO1xuaW1wb3J0ICogYXMgdXJsIGZyb20gJ3VybCc7XG5cbmxldCBjbGllbnQ6IGF3cy5JQU07XG5cbmZ1bmN0aW9uIGlhbSgpIHtcbiAgaWYgKCFjbGllbnQpIHsgY2xpZW50ID0gbmV3IGF3cy5JQU0oKTsgfVxuICByZXR1cm4gY2xpZW50O1xufVxuXG5mdW5jdGlvbiBkZWZhdWx0TG9nZ2VyKGZtdDogc3RyaW5nLCAuLi5hcmdzOiBhbnlbXSkge1xuICAvLyB0c2xpbnQ6ZGlzYWJsZS1uZXh0LWxpbmU6IG5vLWNvbnNvbGVcbiAgY29uc29sZS5sb2coZm10LCAuLi5hcmdzKTtcbn1cblxuLyoqXG4gKiBEb3dubG9hZHMgdGhlIENBIHRodW1icHJpbnQgZnJvbSB0aGUgaXNzdWVyIFVSTFxuICovXG5hc3luYyBmdW5jdGlvbiBkb3dubG9hZFRodW1icHJpbnQoaXNzdWVyVXJsOiBzdHJpbmcpIHtcbiAgZXh0ZXJuYWwubG9nKGBkb3dubG9hZGluZyBjZXJ0aWZpY2F0ZSBhdXRob3JpdHkgdGh1bWJwcmludCBmb3IgJHtpc3N1ZXJVcmx9YCk7XG4gIHJldHVybiBuZXcgUHJvbWlzZTxzdHJpbmc+KChvaywga28pID0+IHtcbiAgICBjb25zdCBwdXJsID0gdXJsLnBhcnNlKGlzc3VlclVybCk7XG4gICAgY29uc3QgcG9ydCA9IHB1cmwucG9ydCA/IHBhcnNlSW50KHB1cmwucG9ydCwgMTApIDogNDQzO1xuICAgIGlmICghcHVybC5ob3N0KSB7XG4gICAgICByZXR1cm4ga28obmV3IEVycm9yKGB1bmFibGUgdG8gZGV0ZXJtaW5lIGhvc3QgZnJvbSBpc3N1ZXIgdXJsICR7aXNzdWVyVXJsfWApKTtcbiAgICB9XG4gICAgY29uc3Qgc29ja2V0ID0gdGxzLmNvbm5lY3QocG9ydCwgcHVybC5ob3N0LCB7IHJlamVjdFVuYXV0aG9yaXplZDogZmFsc2UgfSk7XG4gICAgc29ja2V0Lm9uY2UoJ2Vycm9yJywga28pO1xuICAgIHNvY2tldC5vbmNlKCdzZWN1cmVDb25uZWN0JywgKCkgPT4ge1xuICAgICAgY29uc3QgY2VydCA9IHNvY2tldC5nZXRQZWVyQ2VydGlmaWNhdGUoKTtcbiAgICAgIHNvY2tldC5lbmQoKTtcbiAgICAgIGNvbnN0IHRodW1icHJpbnQgPSBjZXJ0LmZpbmdlcnByaW50LnNwbGl0KCc6Jykuam9pbignJyk7XG4gICAgICBleHRlcm5hbC5sb2coYGNlcnRpZmljYXRlIGF1dGhvcml0eSB0aHVtYnByaW50IGZvciAke2lzc3VlclVybH0gaXMgJHt0aHVtYnByaW50fWApO1xuICAgICAgb2sodGh1bWJwcmludCk7XG4gICAgfSk7XG4gIH0pO1xufVxuXG4vLyBhbGxvd3MgdW5pdCB0ZXN0IHRvIHJlcGxhY2Ugd2l0aCBtb2Nrc1xuLy8gdHNsaW50OmRpc2FibGU6bWF4LWxpbmUtbGVuZ3RoXG5leHBvcnQgY29uc3QgZXh0ZXJuYWwgPSB7XG4gIGRvd25sb2FkVGh1bWJwcmludCxcbiAgbG9nOiBkZWZhdWx0TG9nZ2VyLFxuICBjcmVhdGVPcGVuSURDb25uZWN0UHJvdmlkZXI6IChyZXE6IGF3cy5JQU0uQ3JlYXRlT3BlbklEQ29ubmVjdFByb3ZpZGVyUmVxdWVzdCkgPT4gaWFtKCkuY3JlYXRlT3BlbklEQ29ubmVjdFByb3ZpZGVyKHJlcSkucHJvbWlzZSgpLFxuICBkZWxldGVPcGVuSURDb25uZWN0UHJvdmlkZXI6IChyZXE6IGF3cy5JQU0uRGVsZXRlT3BlbklEQ29ubmVjdFByb3ZpZGVyUmVxdWVzdCkgPT4gaWFtKCkuZGVsZXRlT3BlbklEQ29ubmVjdFByb3ZpZGVyKHJlcSkucHJvbWlzZSgpLFxuICB1cGRhdGVPcGVuSURDb25uZWN0UHJvdmlkZXJUaHVtYnByaW50OiAocmVxOiBhd3MuSUFNLlVwZGF0ZU9wZW5JRENvbm5lY3RQcm92aWRlclRodW1icHJpbnRSZXF1ZXN0KSA9PiBpYW0oKS51cGRhdGVPcGVuSURDb25uZWN0UHJvdmlkZXJUaHVtYnByaW50KHJlcSkucHJvbWlzZSgpLFxuICBhZGRDbGllbnRJRFRvT3BlbklEQ29ubmVjdFByb3ZpZGVyOiAocmVxOiBhd3MuSUFNLkFkZENsaWVudElEVG9PcGVuSURDb25uZWN0UHJvdmlkZXJSZXF1ZXN0KSA9PiBpYW0oKS5hZGRDbGllbnRJRFRvT3BlbklEQ29ubmVjdFByb3ZpZGVyKHJlcSkucHJvbWlzZSgpLFxuICByZW1vdmVDbGllbnRJREZyb21PcGVuSURDb25uZWN0UHJvdmlkZXI6IChyZXE6IGF3cy5JQU0uUmVtb3ZlQ2xpZW50SURGcm9tT3BlbklEQ29ubmVjdFByb3ZpZGVyUmVxdWVzdCkgPT4gaWFtKCkucmVtb3ZlQ2xpZW50SURGcm9tT3BlbklEQ29ubmVjdFByb3ZpZGVyKHJlcSkucHJvbWlzZSgpLFxufTtcbiJdfQ==