"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginMutation = void 0;
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const edge_function_1 = require("./edge-function");
const with_configuration_1 = require("./with-configuration");
class OriginMutation extends edge_function_1.EdgeFunction {
    constructor(scope, id, props = {}) {
        var _a;
        super(scope, id, {
            name: 'origin-mutation',
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'origin-mutation')),
            eventType: aws_cdk_lib_1.aws_cloudfront.LambdaEdgeEventType.ORIGIN_REQUEST,
            edgeRole: props.edgeRole,
            configuration: {
                logLevel: (_a = props.logLevel) !== null && _a !== void 0 ? _a : with_configuration_1.LogLevel.WARN,
            },
        });
    }
}
exports.OriginMutation = OriginMutation;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3JpZ2luLW11dGF0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL29yaWdpbi1tdXRhdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw2QkFBNkI7QUFDN0IsNkNBQXlEO0FBR3pELG1EQUF3RTtBQUN4RSw2REFBZ0Q7QUFNaEQsTUFBYSxjQUFlLFNBQVEsNEJBQVk7SUFDOUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUE2QixFQUFFOztRQUN2RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLElBQUksRUFBRSxpQkFBaUI7WUFDdkIsSUFBSSxFQUFFLHdCQUFVLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsaUJBQWlCLENBQUMsQ0FBQztZQUNuRixTQUFTLEVBQUUsNEJBQWMsQ0FBQyxtQkFBbUIsQ0FBQyxjQUFjO1lBQzVELFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtZQUN4QixhQUFhLEVBQUU7Z0JBQ2IsUUFBUSxRQUFFLEtBQUssQ0FBQyxRQUFRLG1DQUFJLDZCQUFRLENBQUMsSUFBSTthQUMxQztTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7Q0FDRjtBQVpELHdDQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCB7IGF3c19jbG91ZGZyb250LCBhd3NfbGFtYmRhIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbmltcG9ydCB7IEVkZ2VGdW5jdGlvbiwgQ29tbW9uRWRnZUZ1bmN0aW9uUHJvcHMgfSBmcm9tICcuL2VkZ2UtZnVuY3Rpb24nO1xuaW1wb3J0IHsgTG9nTGV2ZWwgfSBmcm9tICcuL3dpdGgtY29uZmlndXJhdGlvbic7XG5cbmV4cG9ydCBpbnRlcmZhY2UgT3JpZ2luTXV0YXRpb25Qcm9wcyBleHRlbmRzIENvbW1vbkVkZ2VGdW5jdGlvblByb3BzIHtcbiAgcmVhZG9ubHkgbG9nTGV2ZWw/OiBMb2dMZXZlbDtcbn1cblxuZXhwb3J0IGNsYXNzIE9yaWdpbk11dGF0aW9uIGV4dGVuZHMgRWRnZUZ1bmN0aW9uIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IE9yaWdpbk11dGF0aW9uUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgbmFtZTogJ29yaWdpbi1tdXRhdGlvbicsXG4gICAgICBjb2RlOiBhd3NfbGFtYmRhLkNvZGUuZnJvbUFzc2V0KHBhdGguam9pbihfX2Rpcm5hbWUsICdsYW1iZGFzJywgJ29yaWdpbi1tdXRhdGlvbicpKSxcbiAgICAgIGV2ZW50VHlwZTogYXdzX2Nsb3VkZnJvbnQuTGFtYmRhRWRnZUV2ZW50VHlwZS5PUklHSU5fUkVRVUVTVCxcbiAgICAgIGVkZ2VSb2xlOiBwcm9wcy5lZGdlUm9sZSxcbiAgICAgIGNvbmZpZ3VyYXRpb246IHtcbiAgICAgICAgbG9nTGV2ZWw6IHByb3BzLmxvZ0xldmVsID8/IExvZ0xldmVsLldBUk4sXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG59XG4iXX0=