from collections.abc import Mapping
from typing import Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="UserData")


@_attrs_define
class UserData:
    """
    Attributes:
        first_name (str):
        last_name (str):
        external_applicant_id (Union[Unset, str]): External applicant ID, could be generated by application
        email (Union[Unset, str]): Conditionally mandatory. In case of TatraPayPlus payment initiation - It is mandatory
            only if the phone attribute is not provided. If the email is not provided, the user will not receive the cardPay
            notification and payLater will ask for the email in the app.
            In case of Direct API either cardHolder or email is mandatory
        phone (Union[Unset, str]): Conditionally mandatory.  In case of TatraPayPlus payment initiation - It is
            mandatory only if the email attribute is not provided.
    """

    first_name: str
    last_name: str
    external_applicant_id: Union[Unset, str] = UNSET
    email: Union[Unset, str] = UNSET
    phone: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        first_name = self.first_name

        last_name = self.last_name

        external_applicant_id = self.external_applicant_id

        email = self.email

        phone = self.phone

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "firstName": first_name,
                "lastName": last_name,
            }
        )
        if external_applicant_id is not UNSET:
            field_dict["externalApplicantId"] = external_applicant_id
        if email is not UNSET:
            field_dict["email"] = email
        if phone is not UNSET:
            field_dict["phone"] = phone

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        first_name = d.pop("firstName")

        last_name = d.pop("lastName")

        external_applicant_id = d.pop("externalApplicantId", UNSET)

        email = d.pop("email", UNSET)

        phone = d.pop("phone", UNSET)

        user_data = cls(
            first_name=first_name,
            last_name=last_name,
            external_applicant_id=external_applicant_id,
            email=email,
            phone=phone,
        )

        user_data.additional_properties = d
        return user_data

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
