# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDatabasesResult',
    'AwaitableGetDatabasesResult',
    'get_databases',
    'get_databases_output',
]

@pulumi.output_type
class GetDatabasesResult:
    """
    A collection of values returned by getDatabases.
    """
    def __init__(__self__, compartment_id=None, databases=None, db_home_id=None, db_name=None, filters=None, id=None, state=None, system_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if databases and not isinstance(databases, list):
            raise TypeError("Expected argument 'databases' to be a list")
        pulumi.set(__self__, "databases", databases)
        if db_home_id and not isinstance(db_home_id, str):
            raise TypeError("Expected argument 'db_home_id' to be a str")
        pulumi.set(__self__, "db_home_id", db_home_id)
        if db_name and not isinstance(db_name, str):
            raise TypeError("Expected argument 'db_name' to be a str")
        pulumi.set(__self__, "db_name", db_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_id and not isinstance(system_id, str):
            raise TypeError("Expected argument 'system_id' to be a str")
        pulumi.set(__self__, "system_id", system_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def databases(self) -> Sequence['outputs.GetDatabasesDatabaseResult']:
        """
        The list of databases.
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter(name="dbHomeId")
    def db_home_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
        """
        return pulumi.get(self, "db_home_id")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[str]:
        """
        The database name.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDatabasesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the database.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemId")
    def system_id(self) -> Optional[str]:
        return pulumi.get(self, "system_id")


class AwaitableGetDatabasesResult(GetDatabasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabasesResult(
            compartment_id=self.compartment_id,
            databases=self.databases,
            db_home_id=self.db_home_id,
            db_name=self.db_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            system_id=self.system_id)


def get_databases(compartment_id: Optional[str] = None,
                  db_home_id: Optional[str] = None,
                  db_name: Optional[str] = None,
                  filters: Optional[Sequence[pulumi.InputType['GetDatabasesFilterArgs']]] = None,
                  state: Optional[str] = None,
                  system_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabasesResult:
    """
    This data source provides the list of Databases in Oracle Cloud Infrastructure Database service.

    Gets a list of the databases in the specified Database Home.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_databases = oci.Database.get_databases(compartment_id=var["compartment_id"],
        db_home_id=oci_database_db_home["test_db_home"]["id"],
        db_name=var["database_db_name"],
        state=var["database_state"],
        system_id=oci_database_system["test_system"]["id"])
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str db_home_id: A Database Home [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). *Note: Either `db_home_id` or `system_id` is required to make the LIST API call.
    :param str db_name: A filter to return only resources that match the entire database name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    :param str system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata DB system that you want to filter the database results by. Applies only to Exadata DB systems.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dbHomeId'] = db_home_id
    __args__['dbName'] = db_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['systemId'] = system_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDatabases:getDatabases', __args__, opts=opts, typ=GetDatabasesResult).value

    return AwaitableGetDatabasesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        databases=pulumi.get(__ret__, 'databases'),
        db_home_id=pulumi.get(__ret__, 'db_home_id'),
        db_name=pulumi.get(__ret__, 'db_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        system_id=pulumi.get(__ret__, 'system_id'))


@_utilities.lift_output_func(get_databases)
def get_databases_output(compartment_id: Optional[pulumi.Input[str]] = None,
                         db_home_id: Optional[pulumi.Input[Optional[str]]] = None,
                         db_name: Optional[pulumi.Input[Optional[str]]] = None,
                         filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDatabasesFilterArgs']]]]] = None,
                         state: Optional[pulumi.Input[Optional[str]]] = None,
                         system_id: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDatabasesResult]:
    """
    This data source provides the list of Databases in Oracle Cloud Infrastructure Database service.

    Gets a list of the databases in the specified Database Home.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_databases = oci.Database.get_databases(compartment_id=var["compartment_id"],
        db_home_id=oci_database_db_home["test_db_home"]["id"],
        db_name=var["database_db_name"],
        state=var["database_state"],
        system_id=oci_database_system["test_system"]["id"])
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str db_home_id: A Database Home [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). *Note: Either `db_home_id` or `system_id` is required to make the LIST API call.
    :param str db_name: A filter to return only resources that match the entire database name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    :param str system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata DB system that you want to filter the database results by. Applies only to Exadata DB systems.
    """
    ...
