/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassList<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassList.class);
    private Class<T> base;
    private List<Class<? extends T>> classes;

    public ClassList(Class<T> base) {
        this.base = base;
        this.classes = new ArrayList<Class<? extends T>>();
    }

    public ClassList(String file2, Class<T> base) throws IOException {
        this(file2, base, ClassList.class);
    }

    public ClassList(String file2, Class<T> base, Class<?> location) throws IOException {
        this.base = base;
        this.classes = new ArrayList<Class<? extends T>>();
        if (file2 == null) {
            return;
        }
        BufferedReader in = null;
        in = location == null ? new BufferedReader(new InputStreamReader(new FileInputStream(file2))) : new BufferedReader(new InputStreamReader(location.getResourceAsStream(file2)));
        while (true) {
            String line = null;
            line = in.readLine();
            if (line == null) break;
            int ndx = line.indexOf("#");
            if (ndx >= 0) {
                line = line.substring(0, ndx);
            }
            if ((line = line.trim()).equals("")) continue;
            Class<T> c = null;
            try {
                Class<?> rawClass = Class.forName(line);
                c = this.cast(rawClass);
            }
            catch (ClassNotFoundException exc) {
                LOGGER.debug("Could not find {}", (Object)line, (Object)exc);
            }
            catch (NoClassDefFoundError err) {
                LOGGER.debug("Could not find {}", (Object)line, (Object)err);
            }
            catch (ExceptionInInitializerError err) {
                LOGGER.debug("Failed to create an instance of {}", (Object)line, (Object)err);
            }
            catch (RuntimeException exc) {
                String msg = exc.getMessage();
                if (msg != null && msg.indexOf("ClassNotFound") < 0) {
                    throw exc;
                }
                LOGGER.debug("", exc);
            }
            if (c == null) {
                LOGGER.error("\"{}\" is not valid.", (Object)line);
                continue;
            }
            this.classes.add(c);
        }
        in.close();
    }

    public void addClass(Class<? extends T> c) {
        this.classes.add(c);
    }

    public void removeClass(Class<? extends T> c) {
        this.classes.remove(c);
    }

    public Class<? extends T>[] getClasses() {
        return this.classes.toArray(new Class[0]);
    }

    private Class<? extends T> cast(Class<?> rawClass) {
        if (!this.base.isAssignableFrom(rawClass)) {
            return null;
        }
        return rawClass;
    }
}

