/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ucar.bufr.BufrData;
import ucar.bufr.BufrDataExtractor;
import ucar.bufr.BufrIndexer;
import ucar.bufr.BufrInput;
import ucar.bufr.Index;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.NCdump;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.bufr.Index2NC;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.DiskCache;
import ucar.unidata.io.RandomAccessFile;

public class BufrIosp
extends AbstractIOServiceProvider {
    protected NetcdfFile ncfile;
    protected RandomAccessFile raf;
    protected StringBuffer parseInfo = new StringBuffer();
    private Index saveIndex = null;
    private File saveIndexFile = null;
    private String saveLocation;
    private BufrDataExtractor dataReader;
    static boolean debugOpen = false;
    static boolean debugMissing = false;
    static boolean debugMissingDetails = false;
    static boolean debugProj = false;
    static boolean debugTiming = false;
    static boolean debugVert = false;
    public static boolean forceNewIndex = false;
    public static boolean useMaximalCoordSys = false;
    public static boolean extendIndex = false;

    public static void useMaximalCoordSys(boolean b) {
        useMaximalCoordSys = b;
    }

    public static void setExtendIndex(boolean b) {
        extendIndex = b;
    }

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugOpen = debugFlag.isSet("Bufr/open");
        debugMissing = debugFlag.isSet("Bufr/missing");
        debugMissingDetails = debugFlag.isSet("Bufr/missingDetails");
        debugProj = debugFlag.isSet("Bufr/projection");
        debugVert = debugFlag.isSet("Bufr/vertical");
        debugTiming = debugFlag.isSet("Bufr/timing");
    }

    public boolean isValidFile(RandomAccessFile raf) {
        try {
            raf.order(0);
            raf.seek(0L);
            BufrInput bi = new BufrInput(raf);
            return bi.isValidFile();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    protected void open(Index index, CancelTask cancelTask) throws IOException {
        long startTime = System.currentTimeMillis();
        Index2NC delegate = new Index2NC();
        delegate.open(index, this.ncfile, cancelTask);
        this.ncfile.finish();
        HashMap atts = index.getGlobalAttributes();
        this.dataReader = new BufrDataExtractor(this.raf, (String)atts.get("table"));
        if (debugTiming) {
            long took = System.currentTimeMillis() - startTime;
            System.out.println(" open " + this.ncfile.getLocation() + " took=" + took + " msec ");
        }
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.raf = raf;
        this.ncfile = ncfile;
        Index index = this.getIndex(ncfile.getLocation(), cancelTask);
        this.open(index, cancelTask);
    }

    protected Index getIndex(String location, CancelTask cancelTask) throws IOException {
        this.saveLocation = location;
        String indexLocation = location + ".bfx";
        if (indexLocation.startsWith("http:")) {
            InputStream ios = this.indexExistsAsURL(indexLocation);
            if (ios != null) {
                this.saveIndex = new Index();
                this.saveIndex.open(indexLocation, ios);
                if (debugOpen) {
                    System.out.println("  opened HTTP index = " + indexLocation);
                }
                return this.saveIndex;
            }
            this.saveIndexFile = DiskCache.getCacheFile(indexLocation);
            if (debugOpen) {
                System.out.println("  HTTP index = " + this.saveIndexFile.getPath());
            }
        } else {
            this.saveIndexFile = DiskCache.getFileStandardPolicy(indexLocation);
        }
        if (!forceNewIndex && this.saveIndexFile.exists()) {
            this.saveIndex = new Index();
            boolean ok = this.saveIndex.open(this.saveIndexFile.getPath());
            if (ok) {
                if (debugOpen) {
                    System.out.println("  opened index = " + this.saveIndexFile.getPath());
                }
                if (extendIndex) {
                    long length;
                    HashMap attrHash = this.saveIndex.getGlobalAttributes();
                    String lengthS = (String)attrHash.get("length");
                    long l = length = lengthS == null ? 0L : Long.parseLong(lengthS);
                    if (length < this.raf.length()) {
                        if (debugOpen) {
                            System.out.println("  calling extendIndex");
                        }
                        this.saveIndex = this.extendIndex(this.raf, this.saveIndexFile, this.saveIndex);
                    }
                }
            } else {
                this.saveIndex = this.writeIndex(this.saveIndexFile, this.raf);
                if (debugOpen) {
                    System.out.println("  rewrite index = " + this.saveIndexFile.getPath());
                }
            }
        } else {
            this.saveIndex = this.writeIndex(this.saveIndexFile, this.raf);
            if (debugOpen) {
                System.out.println("  write index = " + this.saveIndexFile.getPath());
            }
        }
        return this.saveIndex;
    }

    private Index writeIndex(File indexFile, RandomAccessFile raf) throws IOException {
        Index index = null;
        raf.seek(0L);
        BufrIndexer indexer = new BufrIndexer();
        PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
        index = BufrIndexer.writeFileIndex((RandomAccessFile)raf, (PrintStream)ps, (boolean)true);
        return index;
    }

    public boolean sync() throws IOException {
        long length;
        HashMap attrHash = this.saveIndex.getGlobalAttributes();
        String lengthS = (String)attrHash.get("length");
        long l = length = lengthS == null ? 0L : Long.parseLong(lengthS);
        if (length < this.raf.length()) {
            if (extendIndex && this.saveIndexFile != null) {
                if (debugOpen) {
                    System.out.println("calling IndexExtender");
                }
                this.saveIndex = this.extendIndex(this.raf, this.saveIndexFile, this.saveIndex);
            } else {
                if (debugOpen) {
                    System.out.println("sync reopen Index");
                }
                this.saveIndex = this.getIndex(this.saveLocation, null);
            }
            this.ncfile.empty();
            this.open(this.saveIndex, null);
            return true;
        }
        return false;
    }

    private Index extendIndex(RandomAccessFile raf, File indexFile, Index index) throws IOException {
        return null;
    }

    private InputStream indexExistsAsURL(String indexLocation) {
        try {
            URL url = new URL(indexLocation);
            return url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        long start = System.currentTimeMillis();
        if (v2 instanceof Structure) {
            HashMap atts = this.saveIndex.getGlobalAttributes();
            ArrayList locations = this.saveIndex.getLocations();
            HashMap observations = this.saveIndex.getObservations();
            int[] shape = section.getShape();
            Range range = section.getRange(0);
            StructureMembers members = ((Structure)v2).makeStructureMembers();
            ArrayStructureMA ama = new ArrayStructureMA(members, shape);
            ArrayList vars = (ArrayList)((Structure)v2).getVariables();
            HashMap<String, Array> dataHash = new HashMap<String, Array>();
            HashMap<String, IndexIterator> iiHash = new HashMap<String, IndexIterator>();
            ArraySequence ias = null;
            StructureMembers imembers = null;
            ArrayList ivars = null;
            HashMap<String, Array> sdataHash = null;
            HashMap<String, IndexIterator> siiHash = null;
            for (int k = 0; k < vars.size(); ++k) {
                Variable v = (Variable)vars.get(k);
                if (v instanceof Structure) {
                    imembers = ((Structure)v).makeStructureMembers();
                    ias = new ArraySequence(imembers, shape[0]);
                    ivars = (ArrayList)((Structure)v).getVariables();
                    sdataHash = new HashMap<String, Array>();
                    siiHash = new HashMap<String, IndexIterator>();
                    int currOb = -1;
                    int idx = 0;
                    for (int i = 0; i < locations.size() && currOb <= range.last(); ++i) {
                        String loc = (String)locations.get(i);
                        ArrayList obs = (ArrayList)observations.get(loc);
                        for (int j = 0; j < obs.size(); ++j) {
                            if (++currOb < range.first() || currOb > range.last()) continue;
                            Index.BufrObs bo = (Index.BufrObs)obs.get(j);
                            ias.setSequenceLength(idx++, bo.dim);
                        }
                    }
                    ias.finish();
                    ArrayList im = (ArrayList)imembers.getMembers();
                    for (int j = 0; j < im.size(); ++j) {
                        StructureMembers.Member m = (StructureMembers.Member)im.get(j);
                        Array data = (Array)m.getDataObject();
                        IndexIterator ii = data.getIndexIterator();
                        sdataHash.put(m.getName(), data);
                        siiHash.put(m.getName(), ii);
                    }
                }
                Array data = null;
                int[] vshape = v.getShape();
                if (vshape.length != 0 && vshape[0] != -1) {
                    vshape[0] = vshape[0] * shape[0];
                    data = Array.factory(v.getDataType().getPrimitiveClassType(), vshape);
                } else {
                    data = Array.factory(v.getDataType().getPrimitiveClassType(), shape);
                }
                IndexIterator ii = data.getIndexIterator();
                dataHash.put(v.getShortName(), data);
                iiHash.put(v.getShortName(), ii);
            }
            if (((String)atts.get("compressdata")).equals("true")) {
                System.out.println("compressed data");
                this.readDataCompressed((String)atts.get("table"), locations, range, observations, vars, iiHash, dataHash, members);
                return ama;
            }
            BufrDataExtractor bde = new BufrDataExtractor(this.raf, (String)atts.get("table"));
            int currOb = -1;
            Variable v = null;
            for (int i = 0; i < locations.size() && currOb <= range.last(); ++i) {
                String loc = (String)locations.get(i);
                ArrayList obs = (ArrayList)observations.get(loc);
                for (int j = 0; j < obs.size(); ++j) {
                    if (++currOb < range.first() || currOb > range.last()) continue;
                    Index.BufrObs bo = (Index.BufrObs)obs.get(j);
                    if (bde.getData(bo.DDSoffset, bo.obsOffset, bo.bitPos, bo.bitBuf)) {
                        HashMap bufrdatas = bde.getBufrDatas();
                        String bKey = null;
                        for (int k = 0; k < vars.size(); ++k) {
                            IndexIterator ii;
                            BufrData bd;
                            v = (Variable)vars.get(k);
                            if (v instanceof Structure) {
                                for (int m = 0; m < ivars.size(); ++m) {
                                    v = (Variable)ivars.get(m);
                                    Attribute a = v.findAttribute("Bufr_key");
                                    if (a == null) continue;
                                    bKey = a.getStringValue();
                                    bd = (BufrData)bufrdatas.get(bKey);
                                    if (bd.getName().equals("time_nominal") || bd.getName().equals("time_observation")) {
                                        ii = (IndexIterator)siiHash.get(v.getShortName());
                                        ii.setLongNext(bd.getLongData()[0]);
                                        continue;
                                    }
                                    if (bd.isNumeric()) {
                                        ii = (IndexIterator)siiHash.get(v.getShortName());
                                        float[] bufrdata = bd.getFloatData();
                                        for (int n = 0; n < bufrdata.length; ++n) {
                                            ii.setFloatNext(bufrdata[n]);
                                        }
                                        continue;
                                    }
                                    ii = (IndexIterator)siiHash.get(v.getShortName());
                                    ii.setObjectNext(bd.getStringData()[0]);
                                }
                                continue;
                            }
                            if (v.getShortName().equals("parent_index")) {
                                ii = (IndexIterator)iiHash.get(v.getShortName());
                                ii.setIntNext(i);
                                continue;
                            }
                            Attribute a = v.findAttribute("Bufr_key");
                            if (a == null) continue;
                            bKey = a.getStringValue();
                            bd = (BufrData)bufrdatas.get(bKey);
                            if (bd.getName().equals("time_nominal") || bd.getName().equals("time_observation")) {
                                ii = (IndexIterator)iiHash.get(v.getShortName());
                                ii.setLongNext(bd.getLongData()[0]);
                                continue;
                            }
                            if (bd.isNumeric()) {
                                ii = (IndexIterator)iiHash.get(v.getShortName());
                                float[] bufrdata = bd.getFloatData();
                                for (int n = 0; n < bufrdata.length; ++n) {
                                    ii.setFloatNext(bufrdata[n]);
                                }
                                continue;
                            }
                            ii = (IndexIterator)iiHash.get(v.getShortName());
                            ii.setObjectNext(bd.getStringData()[0]);
                        }
                        continue;
                    }
                    System.out.println("getData failed for loc =" + loc);
                }
            }
            for (int k = 0; k < vars.size(); ++k) {
                v = (Variable)vars.get(k);
                Array data = (Array)dataHash.get(v.getShortName());
                StructureMembers.Member m = members.findMember(v.getShortName());
                if (v instanceof Structure) {
                    m.setDataObject(ias);
                    continue;
                }
                m.setDataObject(data);
            }
            return ama;
        }
        return this.readDataVariable(v2.getName(), v2.getDataType(), section.getRanges());
    }

    public void readDataCompressed(String table, ArrayList locations, Range range, HashMap observations, ArrayList vars, HashMap iiHash, HashMap dataHash, StructureMembers members) throws IOException, InvalidRangeException {
        BufrDataExtractor bde = new BufrDataExtractor(this.raf, table);
        int currOb = -1;
        Variable v = null;
        int numObs = -1;
        for (int i = 0; i < locations.size() && currOb <= range.last(); ++i) {
            String loc = (String)locations.get(i);
            ArrayList obs = (ArrayList)observations.get(loc);
            int end = -1;
            for (int j = 0; j < obs.size() && currOb <= range.last(); ++j) {
                Index.BufrObs bo = (Index.BufrObs)obs.get(j);
                end = currOb + bo.bitBuf > range.last() ? range.last() - currOb : -1;
                if ((currOb += bo.bitBuf) < range.first()) continue;
                numObs = bo.bitBuf;
                if (bde.getData(bo.DDSoffset, bo.obsOffset, bo.bitPos, 0)) {
                    HashMap bufrdatas = bde.getBufrDatas();
                    String bKey = null;
                    for (int k = 0; k < vars.size(); ++k) {
                        int n;
                        Object[] bufrdata;
                        IndexIterator ii;
                        v = (Variable)vars.get(k);
                        if (v.getShortName().equals("parent_index")) {
                            ii = (IndexIterator)iiHash.get(v.getShortName());
                            ii.setIntNext(i);
                            continue;
                        }
                        Attribute a = v.findAttribute("Bufr_key");
                        if (a == null) continue;
                        bKey = a.getStringValue();
                        BufrData bd = (BufrData)bufrdatas.get(bKey);
                        if (bd.getName().equals("time_nominal") || bd.getName().equals("time_observation")) {
                            ii = (IndexIterator)iiHash.get(v.getShortName());
                            bufrdata = bd.getLongData();
                            for (n = 0; n < bufrdata.length && n != end; ++n) {
                                ii.setLongNext(bufrdata[n]);
                            }
                            continue;
                        }
                        if (bd.isNumeric()) {
                            ii = (IndexIterator)iiHash.get(v.getShortName());
                            bufrdata = bd.getFloatData();
                            for (int m = 0; m < numObs && m != end; ++m) {
                                for (int n2 = m; n2 < bufrdata.length; n2 += numObs) {
                                    ii.setFloatNext(bufrdata[n2]);
                                }
                            }
                            continue;
                        }
                        ii = (IndexIterator)iiHash.get(v.getShortName());
                        bufrdata = bd.getStringData();
                        for (n = 0; n < bufrdata.length && n != end; ++n) {
                            ii.setObjectNext(bufrdata[n]);
                        }
                    }
                    continue;
                }
                System.out.println("getData failed for loc =" + loc);
            }
        }
        for (int k = 0; k < vars.size(); ++k) {
            v = (Variable)vars.get(k);
            Array data = (Array)dataHash.get(v.getShortName());
            StructureMembers.Member m = members.findMember(v.getShortName());
            m.setDataObject(data);
        }
    }

    private Array readDataVariable(String name, DataType datatype, List section) throws IOException, InvalidRangeException {
        Object p = null;
        int[] shape = Range.getShape(section);
        ArrayList locations = this.saveIndex.getLocations();
        HashMap observations = this.saveIndex.getObservations();
        ArrayList times = this.saveIndex.getObsTimes();
        if (name.equals("number_stations") || name.equals("number_trajectories")) {
            int[] number = new int[]{locations.size()};
            return Array.factory(datatype.getPrimitiveClassType(), shape, (Object)number);
        }
        if (name.equals("station_id") || name.equals("trajectory_id")) {
            String[] ids = new String[locations.size()];
            for (int i = 0; i < locations.size(); ++i) {
                ids[i] = (String)locations.get(i);
            }
            return Array.factory(datatype.getPrimitiveClassType(), shape, (Object)ids);
        }
        if (name.equals("firstChild")) {
            int pos = 0;
            int[] fc = new int[locations.size()];
            fc[0] = 0;
            for (int i = 0; i < locations.size(); ++i) {
                String loc = (String)locations.get(i);
                if (i == 0) {
                    fc[i] = 0;
                    pos = ((ArrayList)observations.get(loc)).size();
                    continue;
                }
                fc[i] = pos;
                pos += ((ArrayList)observations.get(loc)).size();
            }
            return Array.factory(datatype.getPrimitiveClassType(), shape, (Object)fc);
        }
        if (name.equals("numChildren")) {
            int[] nc = new int[locations.size()];
            for (int i = 0; i < locations.size(); ++i) {
                String loc = (String)locations.get(i);
                nc[i] = ((ArrayList)observations.get(loc)).size();
            }
            return Array.factory(datatype.getPrimitiveClassType(), shape, (Object)nc);
        }
        if (name.equals("latitude")) {
            HashMap coordinates = this.saveIndex.getCoordinates();
            float[] lat = new float[locations.size()];
            for (int i = 0; i < locations.size(); ++i) {
                String stn = (String)locations.get(i);
                Index.coordinate coord = (Index.coordinate)coordinates.get(stn);
                lat[i] = coord.latitude;
            }
            return Array.factory(datatype.getPrimitiveClassType(), shape, (Object)lat);
        }
        if (name.equals("longitude")) {
            HashMap coordinates = this.saveIndex.getCoordinates();
            float[] lon = new float[locations.size()];
            for (int i = 0; i < locations.size(); ++i) {
                String stn = (String)locations.get(i);
                Index.coordinate coord = (Index.coordinate)coordinates.get(stn);
                lon[i] = coord.longitude;
            }
            return Array.factory(datatype.getPrimitiveClassType(), shape, (Object)lon);
        }
        if (name.equals("altitude")) {
            HashMap coordinates = this.saveIndex.getCoordinates();
            int[] alt = new int[locations.size()];
            for (int i = 0; i < locations.size(); ++i) {
                String stn = (String)locations.get(i);
                Index.coordinate coord = (Index.coordinate)coordinates.get(stn);
                alt[i] = coord.altitude;
            }
            return Array.factory(datatype.getPrimitiveClassType(), shape, (Object)alt);
        }
        System.out.println("Don't know anything about " + name);
        return null;
    }

    private Array readDataVariableRecord(Variable v2, List section) throws IOException, InvalidRangeException {
        Index.BufrObs bo;
        int j;
        ArrayList obs;
        String loc;
        int i;
        HashMap atts = this.saveIndex.getGlobalAttributes();
        ArrayList locations = this.saveIndex.getLocations();
        HashMap observations = this.saveIndex.getObservations();
        int[] shape = Range.getShape(section);
        Range range = (Range)section.get(0);
        Array data = null;
        IndexIterator ii = null;
        ArraySequence ias = null;
        StructureMembers imembers = null;
        StructureMembers.Member member = null;
        if (v2.getName().startsWith("record.level")) {
            member = new StructureMembers.Member(v2.getShortName(), v2.getDescription(), v2.getUnitsString(), v2.getDataType(), v2.getShape());
            imembers = new StructureMembers("level");
            imembers.addMember(member);
            ias = new ArraySequence(imembers, shape[0]);
            int currOb = -1;
            int idx = 0;
            for (i = 0; i < locations.size() && currOb <= range.last(); ++i) {
                loc = (String)locations.get(i);
                obs = (ArrayList)observations.get(loc);
                for (j = 0; j < obs.size(); ++j) {
                    if (++currOb < range.first() || currOb > range.last()) continue;
                    bo = (Index.BufrObs)obs.get(j);
                    ias.setSequenceLength(idx++, bo.dim);
                }
            }
            ias.finish();
            data = (Array)member.getDataObject();
        } else {
            int[] vshape = v2.getShape();
            if (vshape.length != 0 && vshape[0] != -1) {
                vshape[0] = vshape[0] * shape[0];
                data = Array.factory(v2.getDataType().getPrimitiveClassType(), vshape);
            } else {
                data = Array.factory(v2.getDataType().getPrimitiveClassType(), shape);
            }
        }
        ii = data.getIndexIterator();
        if (((String)atts.get("compressdata")).equals("true")) {
            this.readDataVariableRecordCompressed((String)atts.get("table"), locations, range, observations, v2, ii, data);
            return data;
        }
        BufrDataExtractor bde = new BufrDataExtractor(this.raf, (String)atts.get("table"));
        int currOb = -1;
        for (i = 0; i < locations.size() && currOb <= range.last(); ++i) {
            loc = (String)locations.get(i);
            obs = (ArrayList)observations.get(loc);
            for (j = 0; j < obs.size(); ++j) {
                if (++currOb < range.first() || currOb > range.last()) continue;
                bo = (Index.BufrObs)obs.get(j);
                if (bde.getData(bo.DDSoffset, bo.obsOffset, bo.bitPos, bo.bitBuf)) {
                    BufrData bd;
                    Attribute a;
                    HashMap bufrdatas = bde.getBufrDatas();
                    String bKey = null;
                    if (v2.getName().startsWith("record.level")) {
                        a = v2.findAttribute("Bufr_key");
                        if (a == null) continue;
                        bKey = a.getStringValue();
                        bd = (BufrData)bufrdatas.get(bKey);
                        if (bd.getName().equals("time_nominal") || bd.getName().equals("time_observation")) {
                            ii.setLongNext(bd.getLongData()[0]);
                            continue;
                        }
                        if (bd.isNumeric()) {
                            float[] bufrdata = bd.getFloatData();
                            for (int n = 0; n < bufrdata.length; ++n) {
                                ii.setFloatNext(bufrdata[n]);
                            }
                            continue;
                        }
                        ii.setObjectNext(bd.getStringData()[0]);
                        continue;
                    }
                    if (v2.getShortName().equals("parent_index")) {
                        ii.setIntNext(i);
                        continue;
                    }
                    a = v2.findAttribute("Bufr_key");
                    if (a == null) continue;
                    bKey = a.getStringValue();
                    bd = (BufrData)bufrdatas.get(bKey);
                    if (bd.getName().equals("time_nominal") || bd.getName().equals("time_observation")) {
                        ii.setLongNext(bd.getLongData()[0]);
                        continue;
                    }
                    if (bd.isNumeric()) {
                        float[] bufrdata = bd.getFloatData();
                        for (int n = 0; n < bufrdata.length; ++n) {
                            ii.setFloatNext(bufrdata[n]);
                        }
                        continue;
                    }
                    ii.setObjectNext(bd.getStringData()[0]);
                    continue;
                }
                System.out.println("getData failed for loc =" + loc);
            }
        }
        return data;
    }

    public void readDataVariableRecordCompressed(String table, ArrayList locations, Range range, HashMap observations, Variable v2, IndexIterator ii, Array data) throws IOException, InvalidRangeException {
        BufrDataExtractor bde = new BufrDataExtractor(this.raf, table);
        int currOb = -1;
        int numObs = -1;
        for (int i = 0; i < locations.size() && currOb <= range.last(); ++i) {
            String loc = (String)locations.get(i);
            ArrayList obs = (ArrayList)observations.get(loc);
            int end = -1;
            for (int j = 0; j < obs.size() && currOb <= range.last(); ++j) {
                Index.BufrObs bo = (Index.BufrObs)obs.get(j);
                end = currOb + bo.bitBuf > range.last() ? range.last() - currOb : -1;
                if ((currOb += bo.bitBuf) < range.first()) continue;
                numObs = bo.bitBuf;
                if (bde.getData(bo.DDSoffset, bo.obsOffset, bo.bitPos, 0)) {
                    int n;
                    Object[] bufrdata;
                    HashMap bufrdatas = bde.getBufrDatas();
                    String bKey = null;
                    if (v2.getShortName().equals("parent_index")) {
                        ii.setIntNext(i);
                        continue;
                    }
                    Attribute a = v2.findAttribute("Bufr_key");
                    if (a == null) continue;
                    bKey = a.getStringValue();
                    BufrData bd = (BufrData)bufrdatas.get(bKey);
                    if (bd.getName().equals("time_nominal") || bd.getName().equals("time_observation")) {
                        bufrdata = bd.getLongData();
                        for (n = 0; n < bufrdata.length && n != end; ++n) {
                            ii.setLongNext(bufrdata[n]);
                        }
                        continue;
                    }
                    if (bd.isNumeric()) {
                        bufrdata = bd.getFloatData();
                        for (int m = 0; m < numObs && m != end; ++m) {
                            for (int n2 = m; n2 < bufrdata.length; n2 += numObs) {
                                ii.setFloatNext(bufrdata[n2]);
                            }
                        }
                        continue;
                    }
                    bufrdata = bd.getStringData();
                    for (n = 0; n < bufrdata.length && n != end; ++n) {
                        ii.setObjectNext(bufrdata[n]);
                    }
                    continue;
                }
                System.out.println("getData failed for loc =" + loc);
            }
        }
    }

    public Array readNestedData(Variable v2, Section section) throws IOException, InvalidRangeException {
        if (v2.getName().startsWith("record.")) {
            return this.readDataVariableRecord(v2, section.getRanges());
        }
        return this.readDataVariable(v2.getName(), v2.getDataType(), section.getRanges());
    }

    protected void _readData(long DDSoffset, long obsOffset, int bitPos, int bitBuf) throws IOException {
        this.dataReader.getData(DDSoffset, obsOffset, bitPos, bitBuf);
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public String getDetailInfo() {
        return this.parseInfo.toString();
    }

    public static void main(String[] args) throws Exception, IOException, InstantiationException, IllegalAccessException {
        Array data;
        String fileIn = "/home/rkambic/code/bufr/data/PROFILER_3.bufr";
        NetcdfFile.registerIOProvider(BufrIosp.class);
        NetcdfFile ncf = NetcdfFile.open(args[0]);
        System.out.println();
        System.out.println(ncf.toString());
        Variable v = ncf.findVariable("trajectory_id");
        if (v != null) {
            data = v.read();
            NCdump.printArray(data, v.getName(), System.out, null);
        }
        if ((v = ncf.findVariable("station_id")) != null) {
            data = v.read();
            NCdump.printArray(data, v.getName(), System.out, null);
        }
        if ((v = ncf.findVariable("firstChild")) != null) {
            data = v.read();
            NCdump.printArray(data, v.getName(), System.out, null);
        }
        if ((v = ncf.findVariable("numChildren")) != null) {
            data = v.read();
            NCdump.printArray(data, v.getName(), System.out, null);
        }
        System.out.println();
        v = ncf.findVariable("record");
        if (v instanceof Structure) {
            data = v.read();
            NCdump.printArray(data, "record", System.out, null);
        } else {
            data = v.read();
            int[] length = data.getShape();
            System.out.println();
            System.out.println("v2 length =" + length[0]);
            IndexIterator ii = data.getIndexIterator();
            while (ii.hasNext()) {
                System.out.println(ii.getFloatNext());
            }
        }
        ncf.close();
    }
}

