/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.Color;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static boolean debug = false;
    public static final String[] ordinalNames = new String[]{"Latest", "Second", "Third", "Fourth", "Fifth", "Sixth", "Seventh", "Eighth", "Ninth", "Tenth"};
    private static char[] htmlIn = new char[]{'&', '\"', '\'', '<', '>', '\n'};
    private static String[] htmlOut = new String[]{"&amp;", "&quot;", "&#39;", "&lt;", "&gt;", "\n<p>"};
    private static char[] xmlIn = new char[]{'&', '\"', '\'', '<', '>', '\r', '\n', '\t'};
    private static String[] xmlOut = new String[]{"&amp;", "&quot;", "&apos;", "&lt;", "&gt;", "&#xD;", "&#xA;", "&#x9;"};
    private static final Object MATCH_MUTEX = new Object();
    private static Hashtable patternCache = new Hashtable();

    public static String collapseWhitespace(String s) {
        int len = s.length();
        StringBuffer b = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) {
                b.append(c);
                continue;
            }
            b.append(' ');
            while (i + 1 < len && Character.isWhitespace(s.charAt(i + 1))) {
                ++i;
            }
        }
        return b.toString();
    }

    public static String remove(String s, String sub) {
        int pos;
        int len = sub.length();
        while (0 <= (pos = s.indexOf(sub))) {
            s = s.substring(0, pos) + s.substring(pos + len);
        }
        return s;
    }

    public static String remove(String s, int c) {
        if (0 > s.indexOf(c)) {
            return s;
        }
        StringBuffer buff = new StringBuffer(s);
        int i = 0;
        while (i < buff.length()) {
            if (buff.charAt(i) == c) {
                buff.deleteCharAt(i);
                continue;
            }
            ++i;
        }
        return buff.toString();
    }

    public static String substitute(String original, String match, String subst) {
        int pos;
        String s = original;
        while (0 <= (pos = s.indexOf(match))) {
            StringBuffer sb = new StringBuffer(s);
            s = sb.replace(pos, pos + match.length(), subst).toString();
        }
        return s;
    }

    public static String repeat(String s, int cnt) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cnt; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String substitute(String original, String[] match, String[] subst) {
        boolean ok = true;
        for (int i = 0; i < match.length; ++i) {
            if (0 > original.indexOf(match[i])) continue;
            ok = false;
            break;
        }
        if (ok) {
            return original;
        }
        StringBuffer sb = new StringBuffer(original);
        for (int i = 0; i < match.length; ++i) {
            StringUtil.substitute(sb, match[i], subst[i]);
        }
        return sb.toString();
    }

    public static void substitute(StringBuffer sbuff, String match, String subst) {
        int pos;
        int fromIndex = 0;
        int substLen = subst.length();
        int matchLen = match.length();
        while (0 <= (pos = sbuff.indexOf(match, fromIndex))) {
            sbuff.replace(pos, pos + matchLen, subst);
            fromIndex = pos + substLen;
        }
    }

    public static boolean isDigits(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String quoteHtmlContent(String x) {
        return StringUtil.replace(x, htmlIn, htmlOut);
    }

    public static String quoteXmlAttribute(String x) {
        return StringUtil.replace(x, xmlIn, xmlOut);
    }

    public static String unquoteXmlAttribute(String x) {
        return StringUtil.unreplace(x, xmlOut, xmlIn);
    }

    public static String replace(String x, char[] replaceChar, String[] replaceWith) {
        boolean ok = true;
        for (int i = 0; i < replaceChar.length; ++i) {
            int pos = x.indexOf(replaceChar[i]);
            boolean bl = ok = pos < 0;
            if (!ok) break;
        }
        if (ok) {
            return x;
        }
        StringBuffer sb = new StringBuffer(x);
        for (int i = 0; i < replaceChar.length; ++i) {
            int pos = x.indexOf(replaceChar[i]);
            if (pos < 0) continue;
            StringUtil.replace(sb, replaceChar[i], replaceWith[i]);
        }
        return sb.toString();
    }

    public static String unreplace(String x, String[] orgReplace, char[] orgChar) {
        boolean ok = true;
        for (int i = 0; i < orgReplace.length; ++i) {
            int pos = x.indexOf(orgReplace[i]);
            boolean bl = ok = pos < 0;
            if (!ok) break;
        }
        if (ok) {
            return x;
        }
        StringBuffer result = new StringBuffer(x);
        for (int i = 0; i < orgReplace.length; ++i) {
            int pos = result.indexOf(orgReplace[i]);
            if (pos < 0) continue;
            StringUtil.unreplace(result, orgReplace[i], orgChar[i]);
        }
        return result.toString();
    }

    public static int match(String s1, String s2) {
        int i;
        for (i = 0; i < s1.length() && i < s2.length() && s1.charAt(i) == s2.charAt(i); ++i) {
        }
        return i;
    }

    public static void replace(StringBuffer sb, char out, String in) {
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != out) continue;
            sb.replace(i, i + 1, in);
            i += in.length() - 1;
        }
    }

    public static void unreplace(StringBuffer sb, String out, char in) {
        int pos;
        while (0 <= (pos = sb.indexOf(out))) {
            sb.setCharAt(pos, in);
            sb.delete(pos + 1, pos + out.length());
        }
    }

    public static String replace(String s, char out, String in) {
        if (s.indexOf(out) < 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s);
        StringUtil.replace(sb, out, in);
        return sb.toString();
    }

    public static String escape(String x, String okChars) {
        boolean ok = true;
        for (int pos = 0; pos < x.length(); ++pos) {
            char c = x.charAt(pos);
            if (Character.isLetterOrDigit(c) || 0 <= okChars.indexOf(c)) continue;
            ok = false;
            break;
        }
        if (ok) {
            return x;
        }
        StringBuffer sb = new StringBuffer(x);
        for (int pos = 0; pos < sb.length(); ++pos) {
            char c = sb.charAt(pos);
            if (Character.isLetterOrDigit(c) || 0 <= okChars.indexOf(c)) continue;
            sb.setCharAt(pos, '%');
            char value = c;
            sb.insert(++pos, Integer.toHexString(value));
            ++pos;
        }
        return sb.toString();
    }

    public static String escape2(String x, String reservedChars) {
        boolean ok = true;
        for (int pos = 0; pos < x.length(); ++pos) {
            char c = x.charAt(pos);
            if (reservedChars.indexOf(c) < 0) continue;
            ok = false;
            break;
        }
        if (ok) {
            return x;
        }
        StringBuffer sb = new StringBuffer(x);
        for (int pos = 0; pos < sb.length(); ++pos) {
            char c = sb.charAt(pos);
            if (reservedChars.indexOf(c) < 0) continue;
            sb.setCharAt(pos, '%');
            char value = c;
            sb.insert(++pos, Integer.toHexString(value));
            ++pos;
        }
        return sb.toString();
    }

    public static String toHexString(Color c) {
        return "#" + StringUtil.padRight(Integer.toHexString(c.getRed()), 2, "0") + StringUtil.padRight(Integer.toHexString(c.getGreen()), 2, "0") + StringUtil.padRight(Integer.toHexString(c.getBlue()), 2, "0");
    }

    public static String unescape(String x) {
        if (x.indexOf(37) < 0) {
            return x;
        }
        char[] b = new char[2];
        StringBuffer sb = new StringBuffer(x);
        for (int pos = 0; pos < sb.length(); ++pos) {
            char c = sb.charAt(pos);
            if (c != '%') continue;
            b[0] = sb.charAt(pos + 1);
            b[1] = sb.charAt(pos + 2);
            int value = Integer.parseInt(new String(b), 16);
            c = (char)value;
            sb.setCharAt(pos, c);
            sb.delete(pos + 1, pos + 3);
        }
        return sb.toString();
    }

    public static String filter7bits(String s) {
        byte[] b = s.getBytes();
        byte[] bo = new byte[b.length];
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if ((b[i] >= 128 || b[i] <= 31) && b[i] != 10 && b[i] != 9) continue;
            bo[count++] = b[i];
        }
        return new String(bo, 0, count);
    }

    public static String filter(String x, String okChars) {
        boolean ok = true;
        for (int pos = 0; pos < x.length(); ++pos) {
            char c = x.charAt(pos);
            if (Character.isLetterOrDigit(c) || 0 <= okChars.indexOf(c)) continue;
            ok = false;
            break;
        }
        if (ok) {
            return x;
        }
        StringBuffer sb = new StringBuffer(x.length());
        for (int pos = 0; pos < x.length(); ++pos) {
            char c = x.charAt(pos);
            if (!Character.isLetterOrDigit(c) && 0 > okChars.indexOf(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String allow(String x, String allowChars, char replaceChar) {
        boolean ok = true;
        for (int pos = 0; pos < x.length(); ++pos) {
            char c = x.charAt(pos);
            if (Character.isLetterOrDigit(c) || 0 <= allowChars.indexOf(c)) continue;
            ok = false;
            break;
        }
        if (ok) {
            return x;
        }
        StringBuffer sb = new StringBuffer(x);
        for (int pos = 0; pos < sb.length(); ++pos) {
            char c = sb.charAt(pos);
            if (Character.isLetterOrDigit(c) || 0 <= allowChars.indexOf(c)) continue;
            sb.setCharAt(pos, replaceChar);
        }
        return sb.toString();
    }

    public static Object findMatch(String source, List patternList, Object dflt) {
        if (debug) {
            System.err.println("findMatch:" + source + ":");
        }
        for (int i = 0; i < patternList.size(); ++i) {
            Object object = patternList.get(i);
            if (object == null) continue;
            if (debug) {
                System.err.println("\t:" + object.toString() + ":");
            }
            if (!StringUtil.stringMatch(source, object.toString())) continue;
            return object;
        }
        return dflt;
    }

    public static Object findMatch(String source, List patternList, List results, Object dflt) {
        for (int i = 0; i < patternList.size(); ++i) {
            if (!StringUtil.stringMatch(source, patternList.get(i).toString())) continue;
            return results.get(i);
        }
        return dflt;
    }

    public static boolean containsRegExp(String patternString) {
        return patternString.indexOf(94) >= 0 || patternString.indexOf(42) >= 0 || patternString.indexOf(124) >= 0 || patternString.indexOf(40) >= 0 || patternString.indexOf(36) >= 0 || patternString.indexOf(63) >= 0 || patternString.indexOf(46) >= 0 || patternString.indexOf(91) >= 0 && patternString.indexOf(93) >= 0 || patternString.indexOf(43) >= 0;
    }

    public static boolean stringMatch(String input, String patternString) {
        return StringUtil.stringMatch(input, patternString, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stringMatch(String input, String patternString, boolean substring, boolean caseSensitive) {
        Object object = MATCH_MUTEX;
        synchronized (object) {
            try {
                if (!caseSensitive) {
                    if (input.equalsIgnoreCase(patternString)) {
                        return true;
                    }
                } else if (input.equals(patternString)) {
                    return true;
                }
                if (substring) {
                    if (!caseSensitive) {
                        if (input.toLowerCase().indexOf(patternString.toLowerCase()) >= 0) {
                            return true;
                        }
                    } else if (input.indexOf(patternString) >= 0) {
                        return true;
                    }
                }
                if (patternString.toLowerCase().indexOf("t_") >= 0) {
                    // empty if block
                }
                if (!StringUtil.containsRegExp(patternString)) {
                    return false;
                }
                Pattern pattern = (Pattern)patternCache.get(patternString);
                if (pattern == null) {
                    pattern = Pattern.compile(patternString);
                    patternCache.put(patternString, pattern);
                }
                return pattern.matcher(input).find();
            }
            catch (Exception exc) {
                System.err.println("Error regexpMatch:" + exc);
                exc.printStackTrace();
                return true;
            }
        }
    }

    public static boolean startsWithVowel(String value) {
        if (value == null || value.equals("")) {
            return false;
        }
        char lower = Character.toLowerCase(value.charAt(0));
        return lower == 'a' || lower == 'e' || lower == 'i' || lower == 'o' || lower == 'u';
    }

    public static String breakText(String text, String insert, int lineSize) {
        text = StringUtil.replace(text, "\n", " ");
        StringBuffer buff = new StringBuffer();
        while (text.length() > 0) {
            int idx;
            int len = text.length();
            if (len < lineSize) {
                buff.append(text);
                break;
            }
            for (idx = lineSize; idx < len && text.charAt(idx) != ' '; ++idx) {
            }
            if (idx == len) {
                buff.append(text);
                break;
            }
            buff.append(text.substring(0, idx));
            buff.append(insert);
            text = text.substring(idx);
        }
        return buff.toString();
    }

    public static String breakTextAtWords(String text, String insert, int lineSize) {
        StringBuffer buff = new StringBuffer();
        StringTokenizer stoker = new StringTokenizer(text);
        int lineCount = 0;
        while (stoker.hasMoreTokens()) {
            String tok = stoker.nextToken();
            if (tok.length() + lineCount >= lineSize) {
                buff.append(insert);
                lineCount = 0;
            }
            buff.append(tok);
            buff.append(" ");
            lineCount += tok.length() + 1;
        }
        return buff.toString();
    }

    public static String stripHtmlTag(String html) {
        if ((html = html.trim()).startsWith("<html>")) {
            html = html.substring(6);
        }
        if (html.endsWith("</html>")) {
            html = html.substring(0, html.length() - 7);
        }
        return html;
    }

    public static String stripTags(String html) {
        StringBuffer stripped = new StringBuffer();
        while (html.length() > 0) {
            int idx2;
            int idx = html.indexOf("<");
            if (idx < 0) {
                stripped.append(html.trim());
                break;
            }
            String text = html.substring(0, idx);
            if ((text = text.trim()).length() > 0) {
                stripped.append(text + " \n");
            }
            if ((idx2 = (html = html.substring(idx)).indexOf(">")) < 0) break;
            html = html.substring(idx2 + 1);
        }
        stripped = new StringBuffer(StringUtil.replace(stripped.toString(), "&nbsp;", ""));
        return stripped.toString();
    }

    public static String removeWhitespace(String inputString) {
        StringBuffer sb = new StringBuffer();
        char[] chars = inputString.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String zeroString(int value) {
        return StringUtil.padZero(value, 2);
    }

    public static String padZero(int value, int numDigits) {
        return StringUtil.padLeft(String.valueOf(value), numDigits, "0");
    }

    public static String padLeft(String s, int desiredLength) {
        return StringUtil.padLeft(s, desiredLength, " ");
    }

    public static String padLeft(String s, int desiredLength, String padString) {
        while (s.length() < desiredLength) {
            s = padString + s;
        }
        return s;
    }

    public static String padRight(String s, int desiredLength) {
        return StringUtil.padRight(s, desiredLength, " ");
    }

    public static String padRight(String s, int desiredLength, String padString) {
        while (s.length() < desiredLength) {
            s = s + padString;
        }
        return s;
    }

    public static String join(String[] args) {
        return StringUtil.join(" ", args);
    }

    public static String join(String delimiter, Object[] args) {
        return StringUtil.join(delimiter, args, false);
    }

    public static String join(String delimiter, Object[] args, boolean ignoreEmptyStrings) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (ignoreEmptyStrings && (args[i] == null || args[i].toString().length() == 0)) continue;
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(args[i].toString());
        }
        return sb.toString();
    }

    public static String join(String delimiter, List args) {
        return StringUtil.join(delimiter, StringUtil.listToStringArray(args));
    }

    public static String join(String delimiter, List args, boolean ignoreEmptyStrings) {
        return StringUtil.join(delimiter, StringUtil.listToStringArray(args), ignoreEmptyStrings);
    }

    public static List split(Object source) {
        return StringUtil.split(source, ",");
    }

    public static Date parseDate(String dttm) {
        String[] formats = new String[]{"yyyy-MM-dd HH:mm:ss z", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd", "yyyyMMddHHmmss", "yyyyMMddHHmm", "yyyyMMddHH", "yyyyMMdd"};
        for (int i = 0; i < formats.length; ++i) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(formats[i]);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            Date date = dateFormat.parse(dttm, new ParsePosition(0));
            if (date == null) continue;
            return date;
        }
        return null;
    }

    public static List parseIntegerListString(String s) {
        ArrayList<Integer> items = new ArrayList<Integer>();
        List tokens = StringUtil.split(s, ",");
        for (int tokIdx = 0; tokIdx < tokens.size(); ++tokIdx) {
            String token = (String)tokens.get(tokIdx);
            if (token.indexOf(":") >= 0) {
                int stride = 1;
                List subTokens = StringUtil.split(token, ":");
                if (subTokens.size() > 2) {
                    stride = new Integer(subTokens.get(2).toString());
                }
                int start = new Integer(subTokens.get(0).toString());
                int end = new Integer(subTokens.get(1).toString());
                for (int i = start; i <= end; i += stride) {
                    items.add(new Integer(i));
                }
                continue;
            }
            items.add(new Integer(token));
        }
        return items;
    }

    public static List parseLineWords(String content, int[] indices, int[] lengths, String lineDelimiter, String commentString, boolean trimWords) {
        List lines = StringUtil.split((Object)content, lineDelimiter, false);
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            String tline = line.trim();
            if (tline.length() == 0 || commentString != null && tline.startsWith(commentString)) continue;
            String[] words = new String[indices.length];
            for (int idx = 0; idx < indices.length; ++idx) {
                words[idx] = line.substring(indices[idx], indices[idx] + lengths[idx]);
                if (!trimWords) continue;
                words[idx] = words[idx].trim();
            }
            result.add(words);
        }
        return result;
    }

    public static List split(Object source, String delimiter) {
        return StringUtil.split(source, delimiter, true);
    }

    public static List split(Object source, String delimiter, boolean trim) {
        return StringUtil.split(source, delimiter, trim, false);
    }

    /*
     * Unable to fully structure code
     */
    public static List split(Object source, String delimiter, boolean trim, boolean excludeZeroLength) {
        list = new ArrayList<String>();
        if (source == null) {
            return list;
        }
        sourceString = source.toString();
        length = delimiter.length();
        do lbl-1000:
        // 3 sources

        {
            block6: {
                if ((idx = sourceString.indexOf(delimiter)) < 0) {
                    theString = sourceString;
                } else {
                    theString = sourceString.substring(0, idx);
                    sourceString = sourceString.substring(idx + length);
                }
                if (trim) {
                    theString = theString.trim();
                }
                if (!excludeZeroLength || theString.length() != 0) break block6;
                if (idx >= 0) ** GOTO lbl-1000
                break;
            }
            list.add(theString);
        } while (idx >= 0);
        return list;
    }

    public static String[] split(String s, String delimiter, int cnt) {
        String[] a = new String[cnt];
        for (int i = 0; i < cnt - 1; ++i) {
            int idx = s.indexOf(delimiter);
            if (idx < 0) {
                return null;
            }
            a[i] = s.substring(0, idx);
            s = s.substring(idx + 1);
        }
        a[cnt - 1] = s;
        return a;
    }

    public static String[] listToStringArray(List objectList) {
        String[] sa = new String[objectList.size()];
        for (int i = 0; i < objectList.size(); ++i) {
            Object o = objectList.get(i);
            if (o == null) continue;
            sa[i] = o.toString();
        }
        return sa;
    }

    public static String listToString(List l) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < l.size(); ++i) {
            if (i > 0) {
                sb.append(";");
            }
            sb.append(l.get(i).toString());
        }
        return sb.toString();
    }

    public static List toString(List l) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < l.size(); ++i) {
            stringList.add(l.get(i).toString());
        }
        return stringList;
    }

    public static String replace(String string, String pattern, String value) {
        int idx;
        StringBuffer returnValue = new StringBuffer();
        int patternLength = pattern.length();
        while ((idx = string.indexOf(pattern)) >= 0) {
            returnValue.append(string.substring(0, idx));
            if (value != null) {
                returnValue.append(value);
            }
            string = string.substring(idx + patternLength);
        }
        returnValue.append(string);
        return returnValue.toString();
    }

    public static String replaceList(String v, String[] patterns, String[] values) {
        for (int i = 0; i < patterns.length; ++i) {
            v = StringUtil.replace(v, patterns[i], values[i]);
        }
        return v;
    }

    public static String replaceList(String v, List patterns, List values) {
        if (patterns.size() != values.size()) {
            throw new IllegalArgumentException("Patterns list not the same size as values list");
        }
        for (int i = 0; i < patterns.size(); ++i) {
            v = StringUtil.replace(v, (String)patterns.get(i), (String)values.get(i));
        }
        return v;
    }

    public static List replaceList(List sourceList, String[] patterns, String[] values) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < sourceList.size(); ++i) {
            String str = (String)sourceList.get(i);
            for (int patternIdx = 0; patternIdx < patterns.length; ++patternIdx) {
                if (patterns[patternIdx] == null) continue;
                str = StringUtil.replace(str, patterns[patternIdx], values[patternIdx]);
            }
            result.add(str);
        }
        return result;
    }

    public static StringBuffer append(StringBuffer sb, Object s1) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        sb.append(s1 == null ? "null" : s1.toString());
        return sb;
    }

    public static StringBuffer append(StringBuffer sb, Object s1, Object s2) {
        sb = StringUtil.append(sb, s1);
        sb.append(s2 == null ? "null" : s2.toString());
        return sb;
    }

    public static StringBuffer append(StringBuffer sb, Object s1, Object s2, Object s3) {
        sb = StringUtil.append(sb, s1, s2);
        sb.append(s3 == null ? "null" : s3.toString());
        return sb;
    }

    public static StringBuffer append(StringBuffer sb, Object s1, Object s2, Object s3, Object s4) {
        sb = StringUtil.append(sb, s1, s2, s3);
        sb.append(s4 == null ? "null" : s4.toString());
        return sb;
    }

    public static StringBuffer append(StringBuffer sb, Object s1, Object s2, Object s3, Object s4, Object s5) {
        sb = StringUtil.append(sb, s1, s2, s3, s4);
        sb.append(s5 == null ? "null" : s5.toString());
        return sb;
    }

    public static List parseCsv(String s, boolean skipFirst) {
        s = s.trim();
        s = s + "\n";
        s = StringUtil.replaceList(s, new String[]{"\"\"\",", ",\"\"\"", "\"\""}, new String[]{"_QUOTE_\",", ",\"_QUOTE_", "_QUOTE_"});
        int cnt = s.length();
        ArrayList lines = new ArrayList();
        ArrayList<String> line = new ArrayList<String>();
        String word = "";
        boolean INWORD = false;
        boolean INQUOTE = true;
        int LOOKING = 2;
        int state = 0;
        block5: for (int i = 0; i < cnt; ++i) {
            char c = s.charAt(i);
            switch (state) {
                case 2: {
                    if (c == ',') {
                        state = 0;
                        continue block5;
                    }
                    if (c != '\n') continue block5;
                    if (line.size() > 0) {
                        if (!skipFirst && !line.get(0).toString().startsWith("#")) {
                            lines.add(line);
                        }
                        line = new ArrayList();
                        word = "";
                    }
                    state = 0;
                    continue block5;
                }
                case 0: {
                    if (c == '\"') {
                        state = 1;
                        continue block5;
                    }
                    if (c == ',') {
                        line.add(StringUtil.replace(word, "_QUOTE_", "\""));
                        word = "";
                        continue block5;
                    }
                    if (c == '\n') {
                        line.add(StringUtil.replace(word, "_QUOTE_", "\""));
                        word = "";
                        if (!(skipFirst && lines.size() <= 1 || line.get(0).toString().startsWith("#"))) {
                            lines.add(line);
                        }
                        skipFirst = false;
                        line = new ArrayList();
                        continue block5;
                    }
                    word = word + c;
                    continue block5;
                }
                case 1: {
                    if (c == '\"') {
                        line.add(StringUtil.replace(word, "_QUOTE_", "\""));
                        word = "";
                        state = 2;
                        continue block5;
                    }
                    word = word + c;
                }
            }
        }
        if (line.size() > 0 || word.length() > 0) {
            if (word.length() > 0) {
                line.add(StringUtil.replace(word, "_QUOTE_", "\""));
            }
            if (!(skipFirst && lines.size() <= 1 || line.get(0).toString().startsWith("#"))) {
                lines.add(line);
            }
        }
        return lines;
    }

    public static final String shorten(String s, int length) {
        if (s.length() > length) {
            s = s.substring(0, length - 1) + "...";
        }
        return s;
    }

    public static String toString(Object[] array) {
        StringBuffer buf = new StringBuffer();
        buf.append(": ");
        for (int i = 0; i < array.length; ++i) {
            buf.append("[");
            buf.append(i);
            buf.append("]: ");
            buf.append(array[i] == null ? "null" : array[i]);
            buf.append(" ");
        }
        return buf.toString();
    }

    public static List expandIso8601(String time) {
        ArrayList<Date> times = new ArrayList<Date>();
        List tokens = StringUtil.split(time, ",", true, true);
        for (int i = 0; i < tokens.size(); ++i) {
            String tok = (String)tokens.get(i);
            if (tok.indexOf("/") < 0) {
                times.add(StringUtil.parseIso8601(tok));
                continue;
            }
            List ranges = StringUtil.split(tok, "/", true, true);
            if (ranges.size() != 3) {
                throw new IllegalArgumentException("Invalid date format:" + tok);
            }
            Date min = StringUtil.parseIso8601((String)ranges.get(0));
            Date max = StringUtil.parseIso8601((String)ranges.get(1));
            long step = StringUtil.parseTimePeriod((String)ranges.get(2));
        }
        return times;
    }

    private static String str(String s1, String dflt) {
        return s1 != null ? s1 : dflt;
    }

    public static String findPattern(String source, String patternString) {
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(source);
        boolean ok = matcher.find();
        if (!ok) {
            return null;
        }
        if (matcher.groupCount() > 0) {
            return matcher.group(0);
        }
        return null;
    }

    public static Date parseIso8601(String time) {
        String tmp = "((\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d))?(T(\\d\\d):(\\d\\d)(:(\\d\\d)?)?(.*)?)?";
        Pattern pattern = Pattern.compile(tmp);
        Matcher matcher = pattern.matcher(time);
        boolean ok = matcher.find();
        if (!ok) {
            System.err.println("No match:" + time);
            return null;
        }
        System.err.println("Time:" + time);
        for (int i = 1; i <= matcher.groupCount(); ++i) {
        }
        int gidx = 1;
        int n = ++gidx;
        String year = StringUtil.str(matcher.group(n), "0000");
        int n2 = ++gidx;
        String month = StringUtil.str(matcher.group(n2), "01");
        int n3 = ++gidx;
        ++gidx;
        String day = StringUtil.str(matcher.group(n3), "01");
        int n4 = ++gidx;
        String hh = StringUtil.str(matcher.group(n4), "00");
        int n5 = ++gidx;
        ++gidx;
        String mm = StringUtil.str(matcher.group(n5), "00");
        int n6 = ++gidx;
        String ss = StringUtil.str(matcher.group(n6), "00");
        int n7 = ++gidx;
        ++gidx;
        String tzd = StringUtil.str(matcher.group(n7), "GMT");
        if (tzd.equals("Z") || tzd.length() == 0) {
            tzd = "GMT";
        }
        String format = "yyyy-MM-dd-HH-mm-ss-Z";
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern(format);
        String dateString = year + "-" + month + "-" + day + "-" + hh + "-" + mm + "-" + ss + "-" + tzd;
        try {
            Date dttm = sdf.parse(dateString);
            return dttm;
        }
        catch (Exception exc) {
            System.err.println("exc:" + exc);
            return null;
        }
    }

    public static long parseTimePeriod(String s) {
        if (!s.startsWith("P")) {
            throw new IllegalArgumentException("Unknown time period:" + s);
        }
        s = s.substring(1);
        String tmp = "((\\d+)Y)?((\\d+)M)?((\\d+)D)?(T((\\d+)H)?((\\d+)M)?((\\d+)S)?)";
        Pattern pattern = Pattern.compile(tmp);
        Matcher matcher = pattern.matcher(s);
        boolean ok = matcher.find();
        if (!ok) {
            System.err.println("No match:" + s);
            return 0L;
        }
        System.err.println("Duration:" + s);
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            System.err.println("\t" + matcher.group(i));
        }
        int gidx = 1;
        int n = ++gidx;
        ++gidx;
        long y = StringUtil.convert(StringUtil.str(matcher.group(n), "0"));
        int n2 = ++gidx;
        ++gidx;
        long m = StringUtil.convert(StringUtil.str(matcher.group(n2), "0"));
        int n3 = ++gidx;
        ++gidx;
        long d = StringUtil.convert(StringUtil.str(matcher.group(n3), "0"));
        ++gidx;
        int n4 = ++gidx;
        ++gidx;
        long h = StringUtil.convert(StringUtil.str(matcher.group(n4), "0"));
        int n5 = ++gidx;
        ++gidx;
        long min = StringUtil.convert(StringUtil.str(matcher.group(n5), "0"));
        int n6 = ++gidx;
        ++gidx;
        long sec = StringUtil.convert(StringUtil.str(matcher.group(n6), "0"));
        return h * 3600L + m * 60L + sec;
    }

    private static long convert(String s) {
        return new Long(s);
    }

    public static void main2(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.err.println(StringUtil.parseIntegerListString(args[i]));
        }
    }

    public static Hashtable parsePropertiesString(String s) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        if (s != null) {
            StringTokenizer tok = new StringTokenizer(s, ";");
            while (tok.hasMoreTokens()) {
                String nameValue = tok.nextToken();
                int idx = nameValue.indexOf("=");
                if (idx < 0) continue;
                properties.put(nameValue.substring(0, idx).trim(), nameValue.substring(idx + 1));
            }
        }
        return properties;
    }

    private static void showUsage() {
        System.out.println(" StringUtil escape <string> [okChars]");
        System.out.println(" StringUtil unescape <string>");
    }

    public static void main(String[] args) throws Exception {
        System.err.println(StringUtil.toHexString(Color.red));
    }

    public static void main3(String[] args) {
        if (args.length < 2) {
            StringUtil.showUsage();
            return;
        }
        if (args[0].equalsIgnoreCase("escape")) {
            String ok = args.length > 2 ? args[2] : "";
            System.out.println(" escape(" + args[1] + "," + ok + ")= " + StringUtil.escape(args[1], ok));
        } else if (args[0].equalsIgnoreCase("unescape")) {
            System.out.println(" unescape(" + args[1] + ")= " + StringUtil.unescape(args[1]));
        } else {
            StringUtil.showUsage();
        }
    }

    public static List splitMacros(String s) {
        int idx2;
        ArrayList<String> tokens = new ArrayList<String>();
        int idx1 = s.indexOf("${");
        while (idx1 >= 0 && (idx2 = s.indexOf("}", idx1)) >= 0) {
            tokens.add(s.substring(0, idx1));
            tokens.add(s.substring(idx1 + 2, idx2));
            s = s.substring(idx2 + 1);
            idx1 = s.indexOf("${");
        }
        if (s.length() > 0) {
            tokens.add(s);
        }
        return tokens;
    }

    public static String applyMacros(String s, Hashtable props, boolean throwError) {
        List toks = StringUtil.splitMacros(s);
        StringBuffer sb = new StringBuffer("");
        boolean nextMacro = false;
        for (int i = 0; i < toks.size(); ++i) {
            String tok = (String)toks.get(i);
            if (nextMacro) {
                String value;
                Object obj = props.get(tok);
                String string = value = obj != null ? obj.toString() : null;
                if (value == null) {
                    if (throwError) {
                        throw new IllegalArgumentException("Undefined macro: ${" + tok + "} in:" + s);
                    }
                    sb.append("${" + tok + "}");
                } else {
                    sb.append(value);
                }
            } else {
                sb.append(tok);
            }
            nextMacro = !nextMacro;
        }
        return sb.toString();
    }

    public static double[][] parseCoordinates(String coords) {
        String newCoords;
        coords = StringUtil.replace(coords, "\n", " ");
        while (!(newCoords = StringUtil.replace(coords, " ,", ",")).equals(coords)) {
            coords = newCoords;
        }
        while (!(newCoords = StringUtil.replace(coords, ", ", ",")).equals(coords)) {
            coords = newCoords;
        }
        List tokens = StringUtil.split(coords, " ", true, true);
        double[][] result = null;
        for (int pointIdx = 0; pointIdx < tokens.size(); ++pointIdx) {
            String tok = (String)tokens.get(pointIdx);
            List numbers = StringUtil.split(tok, ",");
            if (numbers.size() != 2 && numbers.size() != 3) {
                if (numbers.size() > 3 && tokens.size() == 1 && numbers.size() / 3 * 3 == numbers.size()) {
                    result = new double[3][numbers.size() / 3];
                    int cnt = 0;
                    for (int i = 0; i < numbers.size(); i += 3) {
                        result[0][cnt] = new Double(numbers.get(i).toString());
                        result[1][cnt] = new Double(numbers.get(i + 1).toString());
                        result[2][cnt] = new Double(numbers.get(i + 2).toString());
                        ++cnt;
                    }
                    return result;
                }
                throw new IllegalStateException("Bad number of coordinate values:" + numbers);
            }
            if (result == null) {
                result = new double[numbers.size()][tokens.size()];
            }
            for (int coordIdx = 0; coordIdx < numbers.size() && coordIdx < 3; ++coordIdx) {
                result[coordIdx][pointIdx] = new Double(numbers.get(coordIdx).toString());
            }
        }
        return result;
    }

    public static String getAnOrA(String subject) {
        String s = subject.toLowerCase();
        if (s.startsWith("a") || s.startsWith("e") || s.startsWith("o") || s.startsWith("i") || s.startsWith("u")) {
            return "an";
        }
        return "a";
    }
}

