from typing import Any, ClassVar

from typing import overload
import Boost.Python
ACCELERATION: KinematicLevel
ARG0: ArgumentPosition
ARG1: ArgumentPosition
ARG2: ArgumentPosition
ARG3: ArgumentPosition
ARG4: ArgumentPosition
BODY: FrameType
COLLISION: GeometryType
FIXED_JOINT: FrameType
JOINT: FrameType
LOCAL: ReferenceFrame
LOCAL_WORLD_ALIGNED: ReferenceFrame
OP_FRAME: FrameType
PINOCCHIO_MAJOR_VERSION: int
PINOCCHIO_MINOR_VERSION: int
PINOCCHIO_PATCH_VERSION: int
POSITION: KinematicLevel
SENSOR: FrameType
VELOCITY: KinematicLevel
VISUAL: GeometryType
WITH_CPPAD: bool
WITH_HPP_FCL: bool
WITH_OPENMP: bool
WITH_URDFDOM: bool
WORLD: ReferenceFrame

class AngleAxis(Boost.Python.instance):
    angle: Any
    axis: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def fromRotationMatrix(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def inverse(cls, Eigen) -> Any: ...
    @classmethod
    def isApprox(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def matrix(cls, Eigen) -> Any: ...
    @classmethod
    def toRotationMatrix(cls, Eigen) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __mul__(cls, other) -> Any: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class ArgumentPosition(Boost.Python.enum):
    ARG0: ClassVar[ArgumentPosition] = ...
    ARG1: ClassVar[ArgumentPosition] = ...
    ARG2: ClassVar[ArgumentPosition] = ...
    ARG3: ClassVar[ArgumentPosition] = ...
    ARG4: ClassVar[ArgumentPosition] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...
    __slots__: ClassVar[tuple] = ...

class CollisionPair(Boost.Python.instance):
    first: Any
    second: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def copy(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __copy__(cls) -> Any: ...
    @classmethod
    def __deepcopy__(cls) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class Data(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    Ag: Any
    B: Any
    C: Any
    D: Any
    Fcrb: Any
    Ig: Any
    Ivx: Any
    J: Any
    Jcom: Any
    M: Any
    Minv: Any
    U: Any
    Ycrb: Any
    a: Any
    a_gf: Any
    acom: Any
    com: Any
    dAg: Any
    dJ: Any
    ddq: Any
    ddq_dq: Any
    ddq_dv: Any
    dhg: Any
    dq_after: Any
    dtau_dq: Any
    dtau_dv: Any
    f: Any
    g: Any
    h: Any
    hg: Any
    iMf: Any
    impulse_c: Any
    jointTorqueRegressor: Any
    kinetic_energy: Any
    lambda_c: Any
    lastChild: Any
    liMi: Any
    mass: Any
    nle: Any
    nvSubtree: Any
    nvSubtree_fromRow: Any
    oMf: Any
    oMi: Any
    oa: Any
    oa_gf: Any
    of: Any
    ov: Any
    parents_fromRow: Any
    potential_energy: Any
    staticRegressor: Any
    tau: Any
    v: Any
    vcom: Any
    vxI: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def copy(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def loadFromBinary(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def loadFromString(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def loadFromText(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def loadFromXML(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def saveToBinary(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def saveToString(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def saveToText(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def saveToXML(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __copy__(cls) -> Any: ...
    @classmethod
    def __deepcopy__(cls) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class Force(Boost.Python.instance):
    __safe_for_unpickling__: ClassVar[bool] = ...
    angular: Any
    linear: Any
    vector: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def Random(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def Zero(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def copy(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def isApprox(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def isZero(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def se3Action(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def se3ActionInverse(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setRandom(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setZero(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __add__(cls, other) -> Any: ...
    @classmethod
    def __array__(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __copy__(cls) -> Any: ...
    @classmethod
    def __deepcopy__(cls) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __iadd__(cls, other) -> Any: ...
    @classmethod
    def __isub__(cls, other) -> Any: ...
    @classmethod
    def __mul__(cls, other) -> Any: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __neg__(cls) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __rmul__(cls, other) -> Any: ...
    @classmethod
    def __sub__(cls, other) -> Any: ...
    @classmethod
    def __truediv__(cls, other) -> Any: ...
    @property
    def np(self) -> Any: ...

class Frame(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    inertia: Any
    name: Any
    parent: Any
    placement: Any
    previousFrame: Any
    type: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def copy(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __copy__(cls) -> Any: ...
    @classmethod
    def __deepcopy__(cls) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class FrameType(Boost.Python.enum):
    BODY: ClassVar[FrameType] = ...
    FIXED_JOINT: ClassVar[FrameType] = ...
    JOINT: ClassVar[FrameType] = ...
    OP_FRAME: ClassVar[FrameType] = ...
    SENSOR: ClassVar[FrameType] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...
    __slots__: ClassVar[tuple] = ...

class GeometryData(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def activateCollisionPair(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def copy(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def deactivateAllCollisionPairs(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def deactivateCollisionPair(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def fillInnerOuterObjectMaps(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def loadFromBinary(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def loadFromString(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def loadFromText(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def loadFromXML(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def saveToBinary(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def saveToString(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def saveToText(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def saveToXML(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setActiveCollisionPairs(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setGeometryCollisionStatus(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setSecurityMargins(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __copy__(cls) -> Any: ...
    @classmethod
    def __deepcopy__(cls) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def activeCollisionPairs(self) -> Any: ...
    @property
    def collisionRequests(self) -> Any: ...
    @property
    def collisionResults(self) -> Any: ...
    @property
    def distanceRequests(self) -> Any: ...
    @property
    def distanceResults(self) -> Any: ...
    @property
    def oMg(self) -> Any: ...
    @property
    def radius(self) -> Any: ...

class GeometryModel(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def addAllCollisionPairs(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def addCollisionPair(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def addGeometryObject(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def copy(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def createData(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def existCollisionPair(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def existGeometryName(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def findCollisionPair(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def getGeometryId(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def removeAllCollisionPairs(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def removeCollisionPair(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def removeGeometryObject(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setCollisionPairs(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __copy__(cls) -> Any: ...
    @classmethod
    def __deepcopy__(cls) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def collisionPairs(self) -> Any: ...
    @property
    def geometryObjects(self) -> Any: ...
    @property
    def ngeoms(self) -> Any: ...

class GeometryObject(Boost.Python.instance):
    disableCollision: Any
    geometry: Any
    meshColor: Any
    meshPath: Any
    meshScale: Any
    meshTexturePath: Any
    name: Any
    overrideMaterial: Any
    parentFrame: Any
    parentJoint: Any
    placement: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def CreateCapsule(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class GeometryType(Boost.Python.enum):
    COLLISION: ClassVar[GeometryType] = ...
    VISUAL: ClassVar[GeometryType] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...
    __slots__: ClassVar[tuple] = ...

class Inertia(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    inertia: Any
    lever: Any
    mass: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def FromBox(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def FromCylinder(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def FromDynamicParameters(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def FromEllipsoid(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def FromSphere(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def Identity(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def Random(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def Zero(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def copy(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def isApprox(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def isZero(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def ivx(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def matrix(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def se3Action(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def se3ActionInverse(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIdentity(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setRandom(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setZero(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def toDynamicParameters(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def variation(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def vtiv(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def vxi(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def vxiv(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __add__(cls, other) -> Any: ...
    @classmethod
    def __array__(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __copy__(cls) -> Any: ...
    @classmethod
    def __deepcopy__(cls) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __mul__(cls, other) -> Any: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def np(self) -> Any: ...

class JointDataComposite(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def StU(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def iMlast(self) -> Any: ...
    @property
    def joints(self) -> Any: ...
    @property
    def pjMi(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataFreeFlyer(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataMimic_JointDataRX(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataMimic_JointDataRY(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataMimic_JointDataRZ(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataPX(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataPY(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataPZ(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataPlanar(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def StU(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataPrismaticUnaligned(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataRUBX(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataRUBY(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataRUBZ(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataRX(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataRY(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataRZ(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataRevoluteUnaligned(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataRevoluteUnboundedUnalignedTpl(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataSpherical(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataSphericalZYX(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def StU(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointDataTranslation(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def Dinv(self) -> Any: ...
    @property
    def M(self) -> Any: ...
    @property
    def S(self) -> Any: ...
    @property
    def U(self) -> Any: ...
    @property
    def UDinv(self) -> Any: ...
    @property
    def c(self) -> Any: ...
    @property
    def v(self) -> Any: ...

class JointModel(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasConfigurationLimit(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def hasConfigurationLimitInTangent(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelComposite(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def addJoint(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def jointPlacements(self) -> Any: ...
    @property
    def joints(self) -> Any: ...
    @property
    def njoints(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelFreeFlyer(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelMimic_JointModelRX(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelMimic_JointModelRY(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelMimic_JointModelRZ(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelPX(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelPY(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelPZ(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelPlanar(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelPrismaticUnaligned(Boost.Python.instance):
    axis: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelRUBX(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelRUBY(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelRUBZ(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelRX(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelRY(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelRZ(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelRevoluteUnaligned(Boost.Python.instance):
    axis: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelRevoluteUnboundedUnaligned(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelSpherical(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelSphericalZYX(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class JointModelTranslation(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIndexes(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def shortname(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def hasConfigurationLimit(self) -> Any: ...
    @property
    def hasConfigurationLimitInTangent(self) -> Any: ...
    @property
    def id(self) -> Any: ...
    @property
    def idx_q(self) -> Any: ...
    @property
    def idx_v(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class KinematicLevel(Boost.Python.enum):
    ACCELERATION: ClassVar[KinematicLevel] = ...
    POSITION: ClassVar[KinematicLevel] = ...
    VELOCITY: ClassVar[KinematicLevel] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...
    __slots__: ClassVar[tuple] = ...

class LieGroup(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def dDifference(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def dIntegrate(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def dIntegrateTransport(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def dIntegrate_dq(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def dIntegrate_dv(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def difference(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def distance(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def integrate(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def interpolate(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def normalize(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def random(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def randomConfiguration(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def squaredDistance(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __imul__(cls, other) -> Any: ...
    @classmethod
    def __mul__(cls, other) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def name(self) -> Any: ...
    @property
    def neutral(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nv(self) -> Any: ...

class Model(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    damping: Any
    effortLimit: Any
    frames: Any
    friction: Any
    gravity: Any
    lowerPositionLimit: Any
    name: Any
    referenceConfigurations: Any
    rotorGearRatio: Any
    rotorInertia: Any
    subtrees: Any
    supports: Any
    upperPositionLimit: Any
    velocityLimit: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def addBodyFrame(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def addFrame(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def addJoint(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def addJointFrame(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def appendBodyToJoint(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def check(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def copy(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def createData(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def existBodyName(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def existFrame(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def existJointName(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def getBodyId(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def getFrameId(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def getJointId(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def hasConfigurationLimit(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def hasConfigurationLimitInTangent(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def loadFromBinary(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def loadFromString(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def loadFromText(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def loadFromXML(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def saveToBinary(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def saveToString(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def saveToText(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def saveToXML(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __copy__(cls) -> Any: ...
    @classmethod
    def __deepcopy__(cls) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...
    @property
    def idx_qs(self) -> Any: ...
    @property
    def idx_vs(self) -> Any: ...
    @property
    def inertias(self) -> Any: ...
    @property
    def jointPlacements(self) -> Any: ...
    @property
    def joints(self) -> Any: ...
    @property
    def names(self) -> Any: ...
    @property
    def nbodies(self) -> Any: ...
    @property
    def nframes(self) -> Any: ...
    @property
    def njoints(self) -> Any: ...
    @property
    def nq(self) -> Any: ...
    @property
    def nqs(self) -> Any: ...
    @property
    def nv(self) -> Any: ...
    @property
    def nvs(self) -> Any: ...
    @property
    def parents(self) -> Any: ...

class Motion(Boost.Python.instance):
    __safe_for_unpickling__: ClassVar[bool] = ...
    angular: Any
    linear: Any
    vector: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def Random(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def Zero(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def copy(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def cross(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def isApprox(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def isZero(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def se3Action(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def se3ActionInverse(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setRandom(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setZero(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __add__(cls, other) -> Any: ...
    @classmethod
    def __array__(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __copy__(cls) -> Any: ...
    @classmethod
    def __deepcopy__(cls) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __iadd__(cls, other) -> Any: ...
    @classmethod
    def __isub__(cls, other) -> Any: ...
    @classmethod
    def __mul__(cls, other) -> Any: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __neg__(cls) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __rmul__(cls, other) -> Any: ...
    @classmethod
    def __sub__(cls, other) -> Any: ...
    @classmethod
    def __truediv__(cls, other) -> Any: ...
    @classmethod
    def __xor__(cls, other) -> Any: ...
    @property
    def action(self) -> Any: ...
    @property
    def dualAction(self) -> Any: ...
    @property
    def homogeneous(self) -> Any: ...
    @property
    def np(self) -> Any: ...

class Quaternion(Boost.Python.instance):
    w: Any
    x: Any
    y: Any
    z: Any
    @overload
    @classmethod
    def __init__(cls, boost, Eigen) -> Any: ...
    @overload
    @classmethod
    def __init__(cls, boost) -> Any: ...
    @classmethod
    def FromTwoVectors(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def Identity(cls) -> Any: ...
    @classmethod
    def _transformVector(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def angularDistance(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def assign(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def coeffs(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def conjugate(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def dot(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def inverse(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def isApprox(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def matrix(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def norm(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def normalize(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def normalized(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setFromTwoVectors(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIdentity(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def slerp(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def squaredNorm(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def toRotationMatrix(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def vec(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __abs__(cls) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __imul__(cls, other) -> Any: ...
    @classmethod
    def __len__(cls) -> Any: ...
    @classmethod
    def __mul__(cls, other) -> Any: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class ReferenceFrame(Boost.Python.enum):
    LOCAL: ClassVar[ReferenceFrame] = ...
    LOCAL_WORLD_ALIGNED: ClassVar[ReferenceFrame] = ...
    WORLD: ClassVar[ReferenceFrame] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...
    __slots__: ClassVar[tuple] = ...

class SE3(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    rotation: Any
    translation: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def Identity(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def Interpolate(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def Random(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def act(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def actInv(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def copy(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def inverse(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def isApprox(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def isIdentity(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIdentity(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setRandom(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def toActionMatrix(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def toActionMatrixInverse(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def toDualActionMatrix(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __array__(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __copy__(cls) -> Any: ...
    @classmethod
    def __deepcopy__(cls) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> bool: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __invert__(cls) -> Any: ...
    @classmethod
    def __mul__(cls, other) -> Any: ...
    @classmethod
    def __ne__(cls, other) -> bool: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def action(self) -> Any: ...
    @property
    def actionInverse(self) -> Any: ...
    @property
    def dualAction(self) -> Any: ...
    @property
    def homogeneous(self) -> Any: ...
    @property
    def np(self) -> Any: ...

class StdMap_String_VectorXd(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_Bool(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_CollisionPair(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_Double(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_Force(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_Frame(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_GeometryModel(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_GeometryObject(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_Index(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_IndexVector(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_Inertia(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_Int(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_JointModelVector(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_Matrix6x(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_Motion(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_SE3(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_StdString(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_Vector3(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class map_indexing_suite_StdMap_String_VectorXd_entry(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def data(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def key(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

def Hlog3(*args, **kwargs) -> Any: ...
def Jexp3(*args, **kwargs) -> Any: ...
def Jexp6(*args, **kwargs) -> Any: ...
def Jlog3(*args, **kwargs) -> Any: ...
def Jlog6(*args, **kwargs) -> Any: ...
def SE3ToXYZQUAT(*args, **kwargs) -> Any: ...
def SE3ToXYZQUATtuple(*args, **kwargs) -> Any: ...
def XYZQUATToSE3(*args, **kwargs) -> Any: ...
def aba(*args, **kwargs) -> Any: ...
def appendModel(*args, **kwargs) -> Any: ...
def bodyRegressor(v, a) -> Any: ...
def buildGeomFromUrdf(*args, **kwargs) -> Any: ...
def buildGeomFromUrdfString(*args, **kwargs) -> Any: ...
def buildModelFromUrdf(*args, **kwargs) -> Any: ...
def buildModelFromXML(*args, **kwargs) -> Any: ...
def buildReducedModel(*args, **kwargs) -> Any: ...
def buildSampleGeometryModelHumanoid(*args, **kwargs) -> Any: ...
def buildSampleGeometryModelManipulator(*args, **kwargs) -> Any: ...
def buildSampleModelHumanoid(*args, **kwargs) -> Any: ...
def buildSampleModelHumanoidRandom(*args, **kwargs) -> Any: ...
def buildSampleModelManipulator(*args, **kwargs) -> Any: ...
def ccrba(*args, **kwargs) -> Any: ...
def centerOfMass(*args, **kwargs) -> Any: ...
def checkVersionAtLeast(*args, **kwargs) -> Any: ...
def computeABADerivatives(*args, **kwargs) -> Any: ...
def computeAllTerms(*args, **kwargs) -> Any: ...
def computeBodyRadius(*args, **kwargs) -> Any: ...
def computeCentroidalDynamicsDerivatives(*args, **kwargs) -> Any: ...
def computeCentroidalMap(*args, **kwargs) -> Any: ...
def computeCentroidalMapTimeVariation(*args, **kwargs) -> Any: ...
def computeCentroidalMomentum(*args, **kwargs) -> Any: ...
def computeCentroidalMomentumTimeVariation(*args, **kwargs) -> Any: ...
def computeCollision(*args, **kwargs) -> Any: ...
def computeCollisions(*args, **kwargs) -> Any: ...
def computeCoriolisMatrix(*args, **kwargs) -> Any: ...
def computeDistance(*args, **kwargs) -> Any: ...
def computeDistances(*args, **kwargs) -> Any: ...
def computeForwardKinematicsDerivatives(*args, **kwargs) -> Any: ...
def computeFrameJacobian(*args, **kwargs) -> Any: ...
def computeFrameKinematicRegressor(*args, **kwargs) -> Any: ...
def computeGeneralizedGravity(*args, **kwargs) -> Any: ...
def computeGeneralizedGravityDerivatives(*args, **kwargs) -> Any: ...
def computeJointJacobian(*args, **kwargs) -> Any: ...
def computeJointJacobians(*args, **kwargs) -> Any: ...
def computeJointJacobiansTimeVariation(*args, **kwargs) -> Any: ...
def computeJointKinematicRegressor(*args, **kwargs) -> Any: ...
def computeJointTorqueRegressor(*args, **kwargs) -> Any: ...
def computeKKTContactDynamicMatrixInverse(*args, **kwargs) -> Any: ...
def computeKineticEnergy(*args, **kwargs) -> Any: ...
def computeMinverse(*args, **kwargs) -> Any: ...
def computePotentialEnergy(*args, **kwargs) -> Any: ...
def computeRNEADerivatives(*args, **kwargs) -> Any: ...
def computeStaticRegressor(*args, **kwargs) -> Any: ...
def computeStaticTorque(*args, **kwargs) -> Any: ...
def computeStaticTorqueDerivatives(*args, **kwargs) -> Any: ...
def computeSubtreeMasses(*args, **kwargs) -> Any: ...
def computeSupportedForceByFrame(*args, **kwargs) -> Any: ...
def computeSupportedInertiaByFrame(*args, **kwargs) -> Any: ...
def computeTotalMass(*args, **kwargs) -> Any: ...
def crba(*args, **kwargs) -> Any: ...
def dDifference(*args, **kwargs) -> Any: ...
def dIntegrate(*args, **kwargs) -> Any: ...
def dIntegrateTransport(*args, **kwargs) -> Any: ...
def dccrba(*args, **kwargs) -> Any: ...
def difference(*args, **kwargs) -> Any: ...
def distance(*args, **kwargs) -> Any: ...
def exp3(*args, **kwargs) -> Any: ...
def exp6(*args, **kwargs) -> Any: ...
def forwardDynamics(*args, **kwargs) -> Any: ...
def forwardKinematics(*args, **kwargs) -> Any: ...
def frameBodyRegressor(*args, **kwargs) -> Any: ...
def frameJacobianTimeVariation(*args, **kwargs) -> Any: ...
def framesForwardKinematics(*args, **kwargs) -> Any: ...
def getAcceleration(*args, **kwargs) -> Any: ...
def getCenterOfMassVelocityDerivatives(*args, **kwargs) -> Any: ...
def getCentroidalDynamicsDerivatives(*args, **kwargs) -> Any: ...
def getClassicalAcceleration(*args, **kwargs) -> Any: ...
def getCoriolisMatrix(*args, **kwargs) -> Any: ...
def getFrameAcceleration(*args, **kwargs) -> Any: ...
def getFrameAccelerationDerivatives(*args, **kwargs) -> Any: ...
def getFrameClassicalAcceleration(*args, **kwargs) -> Any: ...
def getFrameJacobian(*args, **kwargs) -> Any: ...
def getFrameJacobianTimeVariation(*args, **kwargs) -> Any: ...
def getFrameVelocity(*args, **kwargs) -> Any: ...
def getFrameVelocityDerivatives(*args, **kwargs) -> Any: ...
def getJacobianSubtreeCenterOfMass(*args, **kwargs) -> Any: ...
def getJointAccelerationDerivatives(*args, **kwargs) -> Any: ...
def getJointJacobian(*args, **kwargs) -> Any: ...
def getJointJacobianTimeVariation(*args, **kwargs) -> Any: ...
def getJointVelocityDerivatives(*args, **kwargs) -> Any: ...
def getKKTContactDynamicMatrixInverse(*args, **kwargs) -> Any: ...
def getVelocity(*args, **kwargs) -> Any: ...
def impulseDynamics(*args, **kwargs) -> Any: ...
def integrate(*args, **kwargs) -> Any: ...
def interpolate(*args, **kwargs) -> Any: ...
def isNormalized(*args, **kwargs) -> Any: ...
def isSameConfiguration(*args, **kwargs) -> Any: ...
def jacobianCenterOfMass(*args, **kwargs) -> Any: ...
def jacobianSubtreeCenterOfMass(*args, **kwargs) -> Any: ...
def jacobianSubtreeCoMJacobian(*args, **kwargs) -> Any: ...
def jointBodyRegressor(*args, **kwargs) -> Any: ...
def loadReferenceConfigurations(*args, **kwargs) -> Any: ...
def loadReferenceConfigurationsFromXML(*args, **kwargs) -> Any: ...
def loadRotorParameters(*args, **kwargs) -> Any: ...
def log3(*args, **kwargs) -> Any: ...
def log6(*args, **kwargs) -> Any: ...
def neutral(*args, **kwargs) -> Any: ...
def nonLinearEffects(*args, **kwargs) -> Any: ...
def normalize(*args, **kwargs) -> Any: ...
def printVersion(*args, **kwargs) -> Any: ...
def randomConfiguration(*args, **kwargs) -> Any: ...
def removeCollisionPairs(*args, **kwargs) -> Any: ...
def removeCollisionPairsFromXML(*args, **kwargs) -> Any: ...
def rnea(*args, **kwargs) -> Any: ...
def seed(*args, **kwargs) -> Any: ...
def sharedMemory(*args, **kwargs) -> Any: ...
def skew(*args, **kwargs) -> Any: ...
def skewSquare(*args, **kwargs) -> Any: ...
def squaredDistance(*args, **kwargs) -> Any: ...
def unSkew(*args, **kwargs) -> Any: ...
def updateFramePlacement(*args, **kwargs) -> Any: ...
def updateFramePlacements(*args, **kwargs) -> Any: ...
def updateGeometryPlacements(*args, **kwargs) -> Any: ...
def updateGlobalPlacements(*args, **kwargs) -> Any: ...
