# Generated by Django 4.2.13 on 2024-05-27 14:38

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="PlanExecutionModel",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("state", models.TextField(default="PENDING")),
                ("start_time", models.DateTimeField(null=True)),
                ("pause_time", models.DateTimeField(null=True)),
                ("finish_time", models.DateTimeField(null=True)),
                ("schedule_time", models.DateTimeField(null=True)),
                ("aps_job_id", models.TextField()),
                ("evidence_directory", models.TextField()),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="PlanModel",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("name", models.TextField()),
                ("meta", models.JSONField(default=dict)),
                ("owner", models.TextField()),
                ("settings", models.JSONField(default=dict)),
                ("dynamic", models.BooleanField(default=False)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="PlanTemplateModel",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("file", models.FileField(upload_to="uploads/")),
            ],
        ),
        migrations.CreateModel(
            name="StageExecutionModel",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("state", models.TextField(default="PENDING")),
                ("start_time", models.DateTimeField(null=True)),
                ("pause_time", models.DateTimeField(null=True)),
                ("finish_time", models.DateTimeField(null=True)),
                ("schedule_time", models.DateTimeField(null=True)),
                ("aps_job_id", models.TextField()),
                ("trigger_id", models.TextField()),
                (
                    "plan_execution",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="stage_executions",
                        to="cryton_app.planexecutionmodel",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="StageModel",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("name", models.TextField()),
                ("meta", models.JSONField(default=dict)),
                ("trigger_type", models.TextField()),
                ("trigger_args", models.JSONField()),
                (
                    "plan_model",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="stages", to="cryton_app.planmodel"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="StepModel",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("name", models.TextField()),
                ("meta", models.JSONField(default=dict)),
                ("step_type", models.TextField()),
                ("arguments", models.JSONField()),
                ("is_init", models.BooleanField(default=False)),
                ("is_final", models.BooleanField(default=False)),
                ("output_prefix", models.TextField()),
                ("output", models.JSONField(default=dict)),
                (
                    "stage_model",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="steps", to="cryton_app.stagemodel"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="WorkerModel",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("name", models.TextField()),
                ("description", models.TextField()),
                ("state", models.TextField(default="DOWN")),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SuccessorModel",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("type", models.TextField()),
                ("value", models.TextField()),
                (
                    "parent",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="successors",
                        to="cryton_app.stepmodel",
                    ),
                ),
                (
                    "successor",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="parents", to="cryton_app.stepmodel"
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="StepExecutionModel",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("state", models.TextField(default="PENDING")),
                ("start_time", models.DateTimeField(null=True)),
                ("pause_time", models.DateTimeField(null=True)),
                ("finish_time", models.DateTimeField(null=True)),
                ("result", models.TextField(default="")),
                ("serialized_output", models.JSONField(default=dict)),
                ("output", models.TextField(default="")),
                ("valid", models.BooleanField(default=False)),
                ("parent_id", models.IntegerField(null=True)),
                (
                    "stage_execution",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="step_executions",
                        to="cryton_app.stageexecutionmodel",
                    ),
                ),
                (
                    "step_model",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="step_executions",
                        to="cryton_app.stepmodel",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="stageexecutionmodel",
            name="stage_model",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, related_name="stage_executions", to="cryton_app.stagemodel"
            ),
        ),
        migrations.CreateModel(
            name="SessionModel",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("name", models.TextField()),
                ("msf_id", models.TextField()),
                (
                    "plan_execution",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="sessions",
                        to="cryton_app.planexecutionmodel",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="RunModel",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("state", models.TextField(default="PENDING")),
                ("start_time", models.DateTimeField(null=True)),
                ("pause_time", models.DateTimeField(null=True)),
                ("finish_time", models.DateTimeField(null=True)),
                ("schedule_time", models.DateTimeField(null=True)),
                ("aps_job_id", models.TextField()),
                (
                    "plan_model",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="runs", to="cryton_app.planmodel"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="planexecutionmodel",
            name="plan_model",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, related_name="plan_executions", to="cryton_app.planmodel"
            ),
        ),
        migrations.AddField(
            model_name="planexecutionmodel",
            name="run",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, related_name="plan_executions", to="cryton_app.runmodel"
            ),
        ),
        migrations.AddField(
            model_name="planexecutionmodel",
            name="worker",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, related_name="plan_executions", to="cryton_app.workermodel"
            ),
        ),
        migrations.CreateModel(
            name="OutputMappingModel",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name_from", models.TextField()),
                ("name_to", models.TextField()),
                (
                    "step_model",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="output_mappings",
                        to="cryton_app.stepmodel",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ExecutionVariableModel",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("name", models.TextField()),
                ("value", models.JSONField()),
                (
                    "plan_execution",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="execution_variables",
                        to="cryton_app.planexecutionmodel",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DependencyModel",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "dependency",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="subjects_to",
                        to="cryton_app.stagemodel",
                    ),
                ),
                (
                    "stage_model",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="dependencies",
                        to="cryton_app.stagemodel",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="CorrelationEventModel",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("correlation_id", models.TextField()),
                (
                    "step_execution",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="correlation_events",
                        to="cryton_app.stepexecutionmodel",
                    ),
                ),
            ],
        ),
    ]
